#!/usr/bin/env bash

USER_NAME="$1"
PASSWORD="$2"
DEST="$3"
RESULT_PATH="$4"

USER="$USER_NAME%$PASSWORD"

WINEXE='/var/lib/shinken/libexec/analyzer/winexe'
WMIEXEC='/var/lib/shinken/libexec/analyzer/wmiexec.py'
SMBCLIENT='/var/lib/shinken/libexec/analyzer/smbclient.py'


function launch_windows_command {
    COMMAND="$1"
    # First try the old command, that will fail on SMB2+ only server, like windows 2016
    OUT=$($WINEXE --uninstall --user="$USER" "//$DEST"   "$COMMAND" 2>&1)
    RES=$?
    if [ $RES == 0 ]; then
      return
    fi

    # Did fail, maybe because of a NT_STATUS_CONNECTION_RESET error => try the smb2&3 version
    echo "$OUT" | grep 'NT_STATUS_CONNECTION_RESET' >/dev/null
    if [ $? == 0 ];then
       echo " - Switching to a SMB3 version of the command"
       OUT=$(python $WMIEXEC "$USER_NAME:$PASSWORD@$DEST" "$COMMAND" 2>&1 )
       if [ $? == 0 ]; then
          echo "- COMMAND SUCCESS $COMMAND  : $OUT"
          return
       fi
    fi
    echo "ERROR: we cannot connect to the server $DEST with the user $USER_NAME: $OUT"
    exit 2
}



function put_files_to_server {
   OUT=$(python $SMBCLIENT "$USER_NAME:$PASSWORD@$DEST" -file /var/lib/shinken/analyzer/copy_files.smb 2>&1)
   if [ $? != 0 ];then
       echo "ERROR: cannot copy files to the server $DEST: $OUT"
       exit 2
   fi
   echo "- Files are is put into server"
}

# Final
cd /var/lib/shinken/analyzer/



# First check if we can connect
launch_windows_command 'cmd /C echo "OK"'


echo "* Cleaning previous runs"
launch_windows_command   'cmd /C  if exist "C:\shinken_analyzer" rmdir /s /q "C:\shinken_analyzer"'
launch_windows_command   'cmd /C  mkdir "C:\shinken_analyzer"'


echo "* Sending Files"
put_files_to_server



echo "* Running the analyzer on the distant server"
launch_windows_command   'cmd /C c:\shinken_analyzer\extract_and_launch.bat'


echo "* Getting back result"
TMP_GET_DIRECTORY=/tmp/analyzer-tmp-$RANDOM-$RANDOM-$RANDOM
mkdir -p $TMP_GET_DIRECTORY
SMB_FILE=$TMP_GET_DIRECTORY/get_result.smb
cp /var/lib/shinken/analyzer/get_result.smb.skel  $SMB_FILE
cd $TMP_GET_DIRECTORY

OUT=$(python $SMBCLIENT "$USER_NAME:$PASSWORD@$DEST" -file $SMB_FILE 2>&1)
if [ $? != 0 ];then
    echo "ERROR: cannot get back results from the server $DEST: $OUT"
    exit 2
fi
echo "GET RESULT SUCCESS: $OUT"

cp shinken-local-analyzer-payload.json  $RESULT_PATH

# Final clean
launch_windows_command   'cmd /C  rmdir /s /q "C:\shinken_analyzer"'

# and local
rm -fr $TMP_GET_DIRECTORY

