
<?php
// Try to authenticate user using Shinken cookie
class CoreLogonShinkenHeader {
    private function getHeader($header_name) {
        $headers = Array();
        foreach($_SERVER as $key => $value) {
            if (substr($key, 0, 5) <> 'HTTP_') {
                continue;
            }
            $header = str_replace(' ', '-', ucwords(str_replace('_', ' ', strtolower(substr($key, 5)))));
            $headers[$header] = $value;
        }

        if (array_key_exists($header_name, $headers)) {
            return $headers[$header_name];
        }
        return null;
    }

    public function check() {
        global $AUTH, $CORE;

        // Get connection parameters from configuration file
        $protocol = cfg("global", "shinken_auth_protocol");
        $port     = cfg("global", "shinken_auth_port");
        $address  = cfg("global", "shinken_auth_address");
        $shinken_admin_only     = cfg("global", "shinken_auth_restrict_to_shinken_admin");
        if ($shinken_admin_only == '1') {
            $shinken_admin_only = true;
        } else {
            $shinken_admin_only = false;
        }
        if ($address == '') {
            // If no address defined, get address from default backend socket
            $default_backend_name = cfg('defaults', 'backend');
            $socket = cfg('backend_' .$default_backend_name[0], 'socket');
            preg_match("/^tcp:(.*):\w*/", $socket, $matches);
            $address = $matches[1];
        }

        $url = $protocol. '://' .$address. ':' .$port. '/auth_nagvis';

        $data = array('restrict_to_shinken_admin' => base64_encode($shinken_admin_only));
        $auth_header_name = cfg("global", "shinken_auth_remote_user_variable");
        // Auth via header is disabled in NagVis if parameter is empty
        if ($auth_header_name == "") {
            return false;
        }
        $header = $this->getHeader($auth_header_name);

        if ($header == null) {
            return false;
        }

        $options = array(
            'http' => array(
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n" .
                             $auth_header_name. ": " .$header. "\r\n",
                'method'  => 'POST',
                'content' => http_build_query($data)
            )
        );

        $context  = stream_context_create($options);
        $result = @file_get_contents($url, false, $context);

        if ($result != false) {
            $username = $result;
        } else {
            return false;
        }

        $AUTH->setTrustUsername(true);
        $AUTH->setLogoutPossible(false);
        $AUTH->passCredentials(Array('user' => $username,
                                     'userId' => $username));

        return $AUTH->isAuthenticated();
    }
}

?>
