CONTROLLER.ShinkenElement = (function ( self ) {
    "use strict";
    self.controller_name      = MANAGER.CONST.CONTROLLER.SHINKEN_ELEMENT;
    //********************************************  EVENT LISTENER  **************************************************//
    self.keydown              = function ( event, key_code ) {
        var _object = MANAGER.__instance_property_distributor.findElement( getParentNameFromEvent( event ), true );
        if ( _object ) {
            _object.keydown( event, key_code );
        }
    };
    self.onFocusOut           = function ( event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( getParentNameFromEvent( event ), -1 );
        _object.onFocusOut( event.target );
    };
    self.clickOnRadioBtn      = function ( event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( getParentNameFromEvent( event ), true );
        var _button = DOM.Service.findParentElementWithClass( event.target, "shinken-radio-btn", 10 );
        _object.clickOnRadioBtn( _button );
    };
    self.clickOnCheckboxInput = function ( event ) {
        var _object             = MANAGER.__instance_property_distributor.findElement( getParentNameFromEvent( event ), true );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, "name", 50 );
        _object.clickOnCheckboxInput( _parent_dom_element.dataset.name );
    };
    self.onChangeOnInput      = function ( event ) {
        var _parent_name = getParentNameFromEvent( event );
        var _object      = MANAGER.__instance_property_distributor.findElement( _parent_name, true );
        _object.askComputeAfterChange( event.target, _parent_name );
    };
    self.mouseEnter           = function ( event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( getParentNameFromEvent( event ) );
        if ( _object ) {
            _object.mouseEnter( event );
        }
        else if ( event.target.classList.contains( 'shinken-check-line' ) ) {
            //BGL EN ATTENDANT QU'UN CHECK MANAGER SOIT FAIT...
            MANAGER.HelpManager.setActive( 'help_title_try_checks' );
        }
    };
    self.mouseLeave           = function ( event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( getParentNameFromEvent( event ) );
        if ( _object ) {
            _object.mouseLeave();
        }
        else if ( event.target.classList.contains( 'shinken-check-line' ) ) {
            //BGL EN ATTENDANT QU'UN CHECK MANAGER SOIT FAIT...
            MANAGER.HelpManager.askSetInactive( 'help_title_try_checks' );
        }
    };
    self.clickOnSelector      = function ( event, parent_name ) {
        var _object        = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        var _scroll_parent = DOM.Service.findParentElementWithClass( _object.dom_element, _object.is_override ? 'shinken-check-override-table-container' : 'shinken-scroll-auto', 50 );
        if ( _scroll_parent ) {
            var _scroll_before = _scroll_parent.scrollHeight;
        }
        _object.clickOnSelector( event );
        if ( _scroll_parent ) {
            var _diff_scroll_height = _scroll_parent.scrollHeight - _scroll_before;
            if ( _diff_scroll_height > 0 ) {
                _scroll_parent.scrollTop = _scroll_parent.scrollTop + _diff_scroll_height;
            }
        }
    };
    self.clickOnItemSelector  = function ( event, parent_name, dom_element ) {
        var _object   = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        var _key_name = dom_element.dataset.keyName;
        _object.clickOnItemSelector( _key_name, dom_element );
    };
    self.clickOnInput         = function ( event ) {
        event.stopPropagation();
        var _object = MANAGER.__instance_property_distributor.findElement( getParentNameFromEvent( event ), true );
        if ( _object ) {
            _object.clickOnInput();
        }
    };
    self.clickOnPaste         = function ( event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( getParentNameFromEvent( event ), true );
        _object.setCfgEditable( true );
    };
    self.onClick              = function ( event ) {
        var _dom_element = event.target;
        var name         = _dom_element.dataset.name;
        var _object      = MANAGER.__instance_property_distributor.findElement( name );
        if ( _object ) {
            _object.onClick();
        }
        else if ( _dom_element.classList.contains( 'shinken-check-line' ) ) {
            var _help_button = _dom_element.querySelector( '.tag-help' );
            if ( _help_button && _help_button.classList.contains( 'shinken-active' ) ) {
                return;
            }
            MANAGER.HelpManager.setForced( 'help_title_try_checks', _help_button );
        }
    };
    //********************************************  GETTER SETTER    ******************************************************//
    self.setType              = function ( to_set ) {
        self.type = to_set;
    };
    //********************************************  NAVIGATOR SIZE MANAGER    ******************************************************//
    self.computeSizes         = function () {
        switch ( self.type ) {
            case CONTROLLER.CONST.PHASE.ACTIVE:
                self.computeSizesForm();
                self.computeSizesHelp();
                break;
        }
    };
    self.computeSizesHelp     = function () {
        var _dom = document.querySelector( "#id-shinken-help-container" );
        if ( !_dom ) {
            return;
        }
        var _computed = DOM.Service.getComputedStyle( _dom );
        var _top      = DOM.Service.getBoundingClientRect( _dom, DOM.CONST.STYLE.TOP );
        var _borders  = parseInt( _computed[ "borderTopWidth" ] ) + parseInt( _computed[ "borderBottomWidth" ] );
        var _dom_2    = _dom.querySelector( ".shinken-help-content-container" );
        DOM.Service.setStyle( _dom, DOM.CONST.STYLE.HEIGHT, window.innerHeight - _top - _borders - 10 );
        DOM.Service.setStyle( _dom_2, DOM.CONST.STYLE.HEIGHT, window.innerHeight - DOM.Service.getBoundingClientRect( _dom_2, DOM.CONST.STYLE.TOP ) - 10 );
    };
    self.computeSizesForm     = function () {
        var _dom = document.querySelector( ".shinken-area-header" );
        if ( !_dom ) {
            return;
        }
        var _dom_form        = document.getElementById( "id-shinken-form-element" );
        var _dom_parent_form = document.querySelector( ".shinken-container-host-info" );
        var _dom_children    = _dom_parent_form.children;
        
        var _current;
        var _total_height = 0;
        for ( var i = 0, _size = _dom_children.length; i < _size; i++ ) {
            _current = _dom_children[ i ];
            if ( _current !== _dom_form ) {
                _total_height += DOM.Service.getBoundingClientRect( _current, DOM.CONST.STYLE.HEIGHT );
            }
        }
        
        var _dom_parent_height = DOM.Service.getBoundingClientRect( _dom_parent_form, DOM.CONST.STYLE.HEIGHT );
        DOM.Service.setStyle( _dom_form, DOM.CONST.STYLE.HEIGHT, _dom_parent_height - _total_height );
    };
    
    //********************************************  INTERNAL    ******************************************************//
    function getParentNameFromEvent ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-parent-event-listener", 50 );
        var parent_name         = _parent_dom_element.dataset.name;
        return parent_name;
    }
    
    return self;
})
( CONTROLLER.ShinkenElement || {} );

window.onpopstate = function ( event ) {
    var _tab_name = SHINKEN.HIGHWAY.getParams( 'tab' );
    if ( !_tab_name ) {
        _tab_name = WINDOW.CONST.ELEMENT.GENERIC;
    }
    if ( _tab_name ) {
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( MANAGER.__instance_element_distributor.current_element.getUUID() );
        _parent_window.clickOnWindow( _tab_name );
    }
};

