//__lib__ lib_external
//priority 10
SHINKEN.NAVIGATOR = (function( self ) {
    "use strict";
    
    var navigator = {
        isChrome : false,
        isFireFox: false,
        isIE     : false,
        isHidden : false
    };
    
    
    setInterval( function() {
        setDocumentHidden();
    }, 2000 );
    
    function setDocumentHidden() {
        navigator.isHidden = document.hidden;
    }
    
    self.isNavigator          = function( type ) {
        return navigator[ type ];
    };
    self.isNavigatorHidden    = function() {
        return navigator.isHidden;
    };
    self.init                 = function() {
        if ( window.navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            navigator.isFireFox = true;
        }
        else if ( window.navigator.userAgent.indexOf( 'Chrome' ) !== -1 ) {
            navigator.isChrome = true;
        }
        else if ( window.navigator.userAgent.indexOf( 'Trident' ) !== -1 ) {
            navigator.isIE = true;
        }
    };
    self.shinken_beforeunload = function( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_beforeunload();
            default:
                return '';
        }
    };
    self.shinken_unload       = function( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_unload();
            default:
                return '';
        }
    };
    
    
    return self;
})( SHINKEN.NAVIGATOR || {} );


SHINKEN.NAVIGATOR.init();
