'use strict';
var SHINKEN = {};
SHINKEN.DOM = {};
SHINKEN.MODAL     = {};
SHINKEN.NAVIGATOR = {};
SHINKEN.PAGE      = {};
SHINKEN.TOOLS            = {};
SHINKEN.TOOLS.ARRAY      = {};
SHINKEN.TOOLS.ENCRYPTION = {};
SHINKEN.OBJECT           = {};
var DOM   = {};
DOM.CONST = {};
SHINKEN.CONST = {
    KEY_CODE : {
        TAB   : 9,
        ENTER : 13,
        ESCAPE: 27,
        SPACE : 32,
        LEFT  : 37,
        UP    : 38,
        RIGHT : 39,
        DOWN  : 40,
        F1    : 112
    },
    CLASS_CSS: {
        PULSATE: 'shinken-pulsate'
    }
};
SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin = function ( link, id, label, _class, tooltip ) {
    if ( MANAGER.__instance_element_distributor.current_user.is_admin && link && id ) {
        return SHINKEN.TOOLS.buildLinkDomElement( link, id, label, _class, tooltip );
    }
    if ( !_class ) {
        _class = "title shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'span', { class: _class }, label );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkDomElement              = function ( link, id, label, _class, tooltip ) {
    var _href = "/elements/" + link + '/' + id;
    if ( !_class ) {
        _class = "title shinken-link shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'a', { class: _class, href: _href, draggable: 'false', target: "_blank", onclick: "MANAGER.EventManager.mutePropagation(event)" }, '<span class="shinken-tag-label">' + label + '</span>' );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkShinkenElement          = function ( element, label, _class, tooltip ) {
    var _uuid = element.uuid;
    if ( element.isNew() ) {
        _uuid += '?new=1';
    }
    if ( !label ) {
        label = element.getName();
    }
    return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( element.getType(), _uuid, label, _class, tooltip );
};
var COMMUNICATION               = {};
COMMUNICATION.MESSAGE           = {};
COMMUNICATION.QUERY             = {};
COMMUNICATION.MESSAGE.SUCCESS   = 'success';
COMMUNICATION.MESSAGE.ERROR     = 'error';
COMMUNICATION.MESSAGE.WARNING   = 'warning';
COMMUNICATION.CODE              = {};
COMMUNICATION.CODE.SUCCESS      = 200;
COMMUNICATION.CODE.WARNING      = 202;
COMMUNICATION.CODE.UNAUTHORIZED = 401;
COMMUNICATION.RETURN_CODE       = {
    ELEMENT_UNKNOWN: "element-unknown"
};
COMMUNICATION.QUERY.GET = {
    SEPARATOR  : {
        GET_BEGINNER: '?',
        GET_ADD     : '&',
        PARAM_SETTER: '=',
        SLASH       : '/'
    },
    SOURCE     : {
        LIST                 : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ORDER            : {
            URL    : "/api/sources/setorder",
            OPTIONS: {
                TIMESTAMP: "?ts=",
                ORDER    : "&order="
            }
        },
        REFRESH              : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ENABLED          : {
            URL    : "/api/sources/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&sname=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        SET_DISCOVERY_ENABLED: {
            URL    : "/api/sources/conf/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&source_name=",
                CONF_ID    : "&conf_id=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        FORCE_IMPORT         : {
            URL    : "/api/sources/forceimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        CLEAN_IMPORT         : {
            URL    : "/api/sources/cleanimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        REFRESH_UNIQUE       : {
            URL    : "/api/sources/unique_source/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        ANALYZER             : {
            LAUNCH_BATCH      : "/api/analyzers/launch_analyze_batch",
            STOP_ANALYSE_BATCH: "/api/analyzers/stop_analyze_batch",
            GET_RESULTS       : "/api/analyzers/get_analyze_jobs_result"
        },
        REDIRECT_DETAIL      : {
            URL    : "/sources/",
            OPTIONS: {
                TAB_DETAIL         : "tab=tab-detail-last-run",
                TAB_SUMMARY_OLD_RUN: "tab=tab-summary-old-run",
                FILTER_STATUS      : "filter=status:"
            }
        }
    },
    OVERRIDE   : {
        BASE: '/elements/service_overrides/'
    },
    MASS_CHANGE: {
        BASE: "/elements/massive_change/",
        PROGRESS_BAR: "/elements/massive_change_progress/"
    }
};
COMMUNICATION.PAGE_TYPE = {
    LIST_ALL_ELEMENT : "list-all-element",
    LIST_WORKING_AREA: "list-working-area"
};
var COMPONENT = {};
COMPONENT.CONST = {
    NOT_FOUND               : -1,
    BTN_STATE               : {
        DISABLED: -1,
        OFF     : 0,
        ON      : 1,
        DISCREET: 2,
        INIT    : 3
    },
    AUTO_SELECT_ACTION_TYPE : {
        MOVE_DOWN : 'move_down',
        MOVE_UP   : 'move_up',
        MOUSE     : 'mouse',
        KEY_INPUT : 'key_input'
    },
    BTN_NAME                : {
        SAVE: 'save'
    },
    SELECT                  : {
        SELECTOR                    : 'shinken-select-selector',
        SELECTOR_TEXT               : 'shinken-selector-label',
        SELECTOR_LIST               : 'shinken-list-select',
        SELECTOR_LIST_OPTION        : 'shinken-option',
        OPTION_ACTIVE_STAGING       : 'shinken-active-option-staging',
        OPTION_ACTIVE_WORKING_AREA  : 'shinken-active-option-working-area',
        DATA_STATE_SELECTOR         : 'stateSelector',
        TIMER_DELAY_BUILD_HTML      : 100
    },
    BTN_INHERITANCE         : {
        TIMER_DELAY_BUILD_HTML: 100
    },
    INHERITANCE_ARBORESCENCE: {},
    TAG                     : {
        STATE: {
            WORKING         : 'working_area',
            NEW             : 'new',
            STAGGING        : 'stagging',
            DISABLED        : 'disabled',
            UNKNOWN         : 'unknown',
            HIDDEN          : 'hidden',
            INHERITED       : 'inherited',
            FORCE_TO_NULL   : 'force-to-null',
            OVERRIDE_NEW    : 'override-new',
            OVERRIDE_UNKNOWN: 'override-unknown'
        }
    },
    FILTER                  : {
        TYPES_VALIDATION: {
            HAS_FOCUS: "has_focus",
            NOT_FOCUS: "not_focus"
        }
    },
    INPUT                   : {
        TYPES: {
            SINGLE_SELECT: 'single-select'
        }
    },
    LIST_SELECT             : {
        CLASS: {
            NO_RESULT   : 'shinken-no-result',
            FILTERING_ON: 'shinken-filtering-on'
        }
    },
    LIST_SELECT_ELEMENT     : {
        CLASS: {
            HIDDEN: 'shinken-hidden'
        }
    },
    BTN_RADIO               : {
        CLASS: {
            SHINKEN_BUTTON_ACTIVE  : 'shinken-active',
            SHINKEN_BUTTON_DISABLED: 'shinken-disabled'
        }
    },
    STATUS                  : {
        NONE   : 'shinken-no-status',
        INFO   : 'shinken-info',
        ERROR  : 'shinken-error-status',
        WARNING: 'shinken-warning-status',
        BEWARE : 'shinken-beware-status'
    },
    TAG_INFORMATION         : {
        STATUS: {
            NONE                 : 'none',
            ALL_DISABLED         : 'all-disabled',
            ALL_DISABLED_OVERRIDE: 'all-disabled-override',
            NOT_VALID_FOR_ARBITER: 'not-arbiter-valid',
            USER_GROUP_COHERENCY : 'user-group-coherency',
            IN_SHELL             : 'in_shell',
            CHECK_DUPLICATE      : 'check_duplicate'
        }
    }
};
var SHINKEN_LIST = {};
SHINKEN_LIST.CONST = {
    MASS_ACTION: {
        NAME          : 'mass-action',
        WORK_AREA_NAME: 'mass-action-work-area'
    },
    TYPE       : {
        CHECK_IN_HOST       : "CHECK_IN_HOST",
        MASS_CHANGE_SUM_FULL: "MASS_CHANGE_SUM_FULL",
        DATA_PROP           : "DATA_PROP"
    },
    FILTER     : {
        HAS_CHILDREN: "**SHINKEN_HAS_CHILDREN**",
        ALL         : "___ALL___",
        EMPTY       : "___EMPTY___",
        NOT_EMPTY   : "___NOT_EMPTY___",
        STATUS      : {
            DISABLED    : -1,
            OFF         : 0,
            ON          : 1,
            HAS_CHILDREN: 2
        },
        TYPE        : {
            INPUT_STRING_ARRAY: "input_string_array"
        }
    },
    SELECTION  : {
        STATUS: {
            DISABLED: -1,
            OFF     : 0,
            ON      : 1
        }
    }
};
var MANAGER = {};
MANAGER.CONST = {
    STATE       : {
        WORK_FLOW: {
            STAGING     : 'save-direct-in-staging',
            WORKING_AREA: 'save-in-working-area'
        }
    },
    DRAG_N_DROP : {
        CLASS: {
            HOVER    : 'hover',
            DRAGGABLE: 'draggable',
            DRAGGING : 'shinken-dragging-on'
        }
    },
    HELP        : {
        STATUS: {
            INACTIVE: 1,
            ACTIVE  : 2,
            FORCED  : 3
        }
    },
    AFTER_ACTION: {
        CLICK_ON_SERVICE_OVERRIDE    : 0,
        CLICK_ON_WINDOW_DATA_OVERRIDE: 1
    },
    CONTROLLER  : {
        SHINKEN_ELEMENT: 'shinken-element',
        LIST_ALL       : 'list-all',
        MASS_CHANGE    : 'mass-change',
        SOURCES        : 'Sources'
    }
};
SHINKEN.OBJECT.ShinkenObject           = function () {
};
SHINKEN.OBJECT.ShinkenObject.prototype = {
    setShinkenDebug      : function ( to_set ) {
        this.is_shinken_debug = to_set;
        var _components       = this.getComponents();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            _components[ i ].setShinkenDebug( to_set );
        }
    },
    isShinkenDebugOn     : function () {
        return this.is_shinken_debug;
    },
    getComponents        : function () {
        return [];
    },
    setNeedValidation: function (to_set) {
        this.need_validation = to_set;
        var _components       = this.getComponents();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            _components[ i ].setNeedValidation( to_set );
        }
    },
};
var OBJECT = {};
OBJECT.CONST = {
    TEMPLATE             : {
        FIELD : {
            UUID             : 'uuid',
            _ID              : '_id',
            _SYNC_KEYS       : '_SYNC_KEYS',
            NAME             : 'name',
            IS_TEMPLATE      : 'is_template',
            IS_TOP_LEVEL     : 'is_top_level',
            ITEM_TYPE        : 'item_type',
            LAST_MODIFICATION: 'last_modification',
            REGISTER         : 'register',
            SOURCES          : 'sources',
            USE              : 'use',
            ENABLED          : 'enabled',
            UNCONFIGURED     : 'unconfigured',
            STATUS           : 'template-status',
            IS_NEW           : 'is_new',
            LOOP             : 'loop',
            WORK_AREA_INFO   : 'work_area_info',
            METADATA         : '@metadata'
        },
        STATUS: {
            USEFUL  : 'useful-template',
            USELESS : 'useless-template',
            BADLOOP : 'badloop-template',
            NEW     : 'new-template',
            UNKNOWN : 'unknown-template',
            DISABLED: 'disabled-template'
        }
    },
    ELEMENT_LIST         : {
        TYPE: {
            USER       : 'user',
            INHERITANCE: 'inheritance',
            SEARCHING  : 'searching'
        }
    },
    MACRO                : {
        TYPE: {
            HOST_LOCAL        : '_HOST',
            SERVICE_LOCAL     : '_SERVICE',
            HOST_PROPERTY     : 'macros_host_properties',
            SERVICE_PROPERTY  : 'macros_service_properties',
            GLOBAL            : 'macros_global',
            GLOBAL_INTERPRETED: 'macros_global_interpreted',
            UNKNOWN           : 'unknown',
            VALUE_DFE         : 'VALUE_DFE',
            DFE_KEY           : '$KEY$'
        }
    },
    CHECK_IN_HOST        : {
        STATUS: {
            NONE                           : "",
            DFE_STRUCTURE                  : 'dfe-structure',
            ALREADY_EXISTING_NAME          : "already_existing_name",
            ALREADY_EXISTING_NAME_IN_SAME  : "already_existing_name_in_same_host",
            ALREADY_EXISTING_NAME_DUPLICATE: "already_existing_name_duplicate"
        }
    },
    ELEMENT              : {
        PHASE           : {
            INIT         : 0,
            VIEWING      : 1,
            EDITING      : 2,
            ON_SAVING    : 3,
            SAVING_FAILED: 4,
            RELOADING    : 5
        },
        FIELD           : {
            ID                    : '_id',
            UUID                  : 'uuid',
            SOURCES               : 'sources',
            IMPORT_DATE           : 'import_date',
            SERVICE_OVERRIDES     : 'service_overrides',
            SERVICE_EXCLUDES_BY_ID: 'service_excludes_by_id',
            WORK_AREA_INFO        : 'work_area_info',
            SYNC_KEYS             : '_SYNC_KEYS ',
            LAST_MODIFICATION     : 'last_modification',
            ENABLED               : 'enabled',
            STATUS                : 'status',
            ITEM_TYPE             : 'item_type'
        },
        MODULATION      : {
            TYPE: {
                NONE_FORCED: -1,
                NONE       : 0,
                PLUS       : 1,
                EXISTING   : 2,
                ERROR      : 3
            }
        },
        TYPE            : {
            CLUSTERS                  : 'clusters',
            CLUSTER_TPLS              : 'clustertpls',
            DISCOVERY                 : 'discovery',
            HOSTS                     : 'hosts',
            HOST_GROUPS               : 'hostgroups',
            HOST_TPLS                 : 'hosttpls',
            CHECK_ON_HOST             : 'serviceshosts',
            CHECK_ON_TPL_HOST         : 'serviceshosttpls',
            CHECK_ON_CLUSTER          : 'servicesclusters',
            CHECK_ON_TPL_CLUSTER      : 'servicesclustertpls',
            CHECK_TPLS                : 'servicetpls',
            COMMANDS                  : 'commands',
            CONTACT_GROUPS            : 'contactgroups',
            CONTACT_TPLS              : 'contacttpls',
            CONTACTS                  : 'contacts',
            ESCALATIONS               : 'escalations',
            MODULATION_BUSINESS_IMPACT: 'businessimpactmodulations',
            MODULATION_DATA           : 'macromodulations',
            MODULATION_RESULT         : 'resultmodulations',
            NOTIFICATION_WAYS         : 'notificationways',
            TIME_PERIODS              : 'timeperiods',
            SYNCHRONIZER_LINKER       : 'sync'
        },
        WORK_AREA_STATUS: {
            PROPOSED : 'PROPOSED',
            WORKING  : 'WORKING',
            REJECTED : 'REJECTED',
            VALIDATED: 'VALIDATED'
            
        },
        STATUS          : {
            NEW: 'new'
        },
        SAVE            : {
            TYPE: {
                LINK: "LINK"
            }
        }
    },
    OVERRIDE_STATUS      : {
        OFF: "0",
        ON : "1",
        DISABLED : "2"
    },
    MODE_OVERRIDE_EXCLUDE: {
        NORMAL  : "0",
        OVERRIDE: "1",
        EXCLUDE : "2"
    },
    EXCLUDE_STATUS       : {
        OFF    : "0",
        BY_ID  : "1",
        BY_NAME: "2"
    }
};
var PROPERTY = {};
PROPERTY.CONST = {
    NAME                  : {
        ACTIVE_CHECKS_ENABLED          : 'active_checks_enabled',
        ACL_MAKE_DOWNTIME              : 'acl_make_downtime',
        ACL_MAKE_ACKNOWLEDGE           : 'acl_make_acknowledge',
        ACL_FORCE_RESULT_CHECK         : 'acl_force_result_check',
        ACL_FORCE_RETRY_CHECK          : 'acl_force_retry_check',
        ACL_IN_TAB_HISTORY             : 'acl_in_tab_history',
        ACL_SHOW_HISTORY_RANGE         : 'acl_show_history_range',
        ACL_SHOW_SLA_RANGE             : 'acl_show_sla_range',
        ACL_TRY_CHECK_ON_SYNCHRONIZER  : 'acl_try_check_on_synchronizer',
        ACL_TRY_CHECK_ON_POLLER        : 'acl_try_check_on_poller',
        ADDRESS                        : 'address',
        ADVANCED_TIME_PERIODS          : 'advanced_time_periods',
        BP_RULE                        : 'bp_rule',
        BUSINESS_IMPACT                : 'business_impact',
        BUSINESS_IMPACT_MODULATIONS    : 'business_impact_modulations',
        BUSINESS_IMPACT_MODULATION_NAME: 'business_impact_modulation_name',
        CAN_SUBMIT_COMMANDS            : 'can_submit_commands',
        CHECK_COMMAND                  : 'check_command',
        CHECK_COMMAND_ARGS             : 'check_command_args',
        CHECK_INTERVAL                 : 'check_interval',
        CHECK_PERIOD                   : 'check_period',
        CHECK_RUNNING_TIMEOUT          : 'check_running_timeout',
        COMMAND_NAME                   : 'command_name',
        COMMAND_LINE                   : 'command_line',
        CONTACTS                       : 'contacts',
        CONTACT_NAME                   : 'contact_name',
        CONTACT_GROUPS                 : 'contact_groups',
        CONTACTGROUP_NAME              : 'contactgroup_name',
        CONTACTGROUPS                  : 'contactgroups',
        DEFAULT_VALUE                  : 'default_value',
        DEFINITION_ORDER               : 'definition_order',
        DISPLAY_NAME                   : 'display_name',
        DUPLICATE_FOREACH_NAME         : 'duplicate_foreach',
        ENABLED                        : 'enabled',
        ESCALATIONS                    : 'escalations',
        ESCALATION_NAME                : 'escalation_name',
        ESCALATION_OPTIONS             : 'escalation_options',
        EDITION_CONTACTS               : 'edition_contacts',
        EDITION_CONTACT_GROUPS         : 'edition_contact_groups',
        EVENT_HANDLER                  : 'event_handler',
        FIRST_NOTIFICATION_DELAY       : 'first_notification_delay',
        FIRST_NOTIFICATION_TIME        : 'first_notification_time',
        FLAP_DETECTION_OPTIONS         : 'flap_detection_options',
        FRESHNESS_THRESHOLD            : 'freshness_threshold',
        HOST_NAME                      : 'host_name',
        HOST_NOTIFICATION_OPTIONS      : 'host_notification_options',
        HOST_NOTIFICATION_PERIOD       : 'host_notification_period',
        HOSTGROUPS                     : 'hostgroups',
        HOSTGROUP_NAME                 : 'hostgroup_name',
        IP_RANGE                       : 'iprange',
        IS_CLUSTER                     : 'is_cluster',
        LOW_FLAP_THRESHOLD             : 'low_flap_threshold',
        LAST_NOTIFICATION_TIME         : 'last_notification_time',
        HIGH_FLAP_THRESHOLD            : 'high_flap_threshold',
        SLA_WARNING_THRESHOLD          : 'sla_warning_threshold',
        SLA_CRITICAL_THRESHOLD         : 'sla_critical_threshold',
        MACRO_MODULATIONS              : 'macromodulations',
        MACROMODULATION_NAME           : 'macromodulation_name',
        MAINTENANCE_PERIOD             : 'maintenance_period',
        MAX_CHECK_ATTEMPTS             : 'max_check_attempts',
        NAME                           : 'name',
        NOTE_URL                       : 'notes_url',
        NOTE_MULTI_URL                 : 'notes_multi_url',
        NOTIFICATIONS_ENABLED          : 'notifications_enabled',
        NOTIFICATION_PERIOD            : 'notification_period',
        NOTIFICATIONWAY_NAME           : 'notificationway_name',
        NOTIFICATIONWAYS               : 'notificationways',
        PACK                           : 'pack',
        PERIOD_ADVANCED_NAME           : 'period_advanced_type',
        PERIOD_DAY_NAME                : 'period_day_type',
        POLLER_TAG                     : 'poller_tag',
        PREFIX                         : 'prefix',
        REACTIONNER_TAG                : 'reactionner_tag',
        RESULTMODULATION_NAME          : 'resultmodulation_name',
        RETRY_INTERVAL                 : 'retry_interval',
        NOTIFICATION_OPTIONS           : 'notification_options',
        NOTIFICATION_CONTACTS          : 'notification_contacts',
        NOTIFICATION_CONTACT_GROUPS    : 'notification_contact_groups',
        NOTIFICATION_INTERVAL          : 'notification_interval',
        OUTPUT_RULES                   : 'output_rules',
        PARENTS                        : 'parents',
        PORT_RANGE                     : 'port_range',
        RESULT_MODULATIONS             : 'resultmodulations',
        SERVICE_NOTIFICATION_OPTIONS   : 'service_notification_options',
        SERVICE_DESCRIPTION            : 'service_description',
        SERVICE_EXCLUDES               : 'service_excludes',
        SHELL_EXECUTION                : 'shell_execution',
        SYNC_NAME                      : 'sync_name',
        TIMEPERIOD_NAME                : 'timeperiod_name',
        TIMEPERIODS                    : 'timeperiods',
        TIMEOUT                        : 'timeout',
        USE                            : 'use',
        VIEW_CONTACTS                  : 'view_contacts',
        VIEW_CONTACT_GROUPS            : 'view_contact_groups',
        WARNING_THRESHOLD_CPU_USAGE    : 'warning_threshold_cpu_usage',
        TIMEPERIOD_DAYS                : {
            MONDAY   : "monday",
            TUESDAY  : "tuesday",
            WEDNESDAY: "wednesday",
            THURSDAY : "thursday",
            FRIDAY   : "friday",
            SATURDAY : "saturday",
            SUNDAY   : "sunday"
        }
    },
    TYPES                 : {
        BOOLEAN                   : 'boolean',
        DATA                      : 'data',
        MULTI_SELECT              : 'select-multi',
        RANGE                     : 'range',
        RANGE_BUSINESS_IMPACT     : 'range_business_impact',
        RANGE_WITH_INPUT          : 'range_with_input',
        SINGLE_SELECT             : 'select-single',
        SINGLE_SELECT_WITH_INPUT  : 'select-single-with-input',
        STRING_INPUT              : 'input_string',
        STRING_INPUT_WITH_DROPDOWN: 'input-string-with-dropdown',
        CHECKBOX_SINGLE           : 'checkbox-single',
        CHECKBOX_MULTI            : 'checkbox-multi',
        MULTI_LINE_OBJECT         : 'multi-line-object'
    },
    CLASS                 : {
        SKINKEN_LINE: 'shinken-element-property-line'
    },
    DEFAULT_BUTTON_LABEL  : 'default_button',
    BUTTON_LABEL          : {
        DEFAULT          : 'default_button',
        NULL             : 'null_button',
        NO_OVERRIDE      : 'no_override_button',
        USER_SET         : 'user_set_button',
        COPY_TO_CLIPBOARD: 'copy_to_clipboard_button',
        SET_DOM_EDITABLE : 'set_dom_editable',
        INHERITANCE      : 'inheritance_button',
        ADD              : 'add_button',
        TARGET_URL       : 'target_url_button',
        REMOVE           : 'remove_button'
    },
    STATE_PROPERTY        : {
        INHERITANCE_AND_USER          : 'inheritance-and-user-and-plus',
        INHERITANCE                   : 'inheritance-only',
        USER_SET                      : 'user-set',
        USER_SET_NONE                 : 'user-set-none',
        USER_FORCED_DEFAULT           : 'user-default-forced',
        USER_SET_MASS_CHANGE_PLUS_ONLY: 'user-set-mass-change-plus-only',
        OVERRIDE                      : 'override-only',
        OVERRIDE_AND_PLUS             : 'override-and-plus',
        OVERRIDE_FORCED_DEFAULT       : 'override-default-forced'
    },
    STATE_PROBLEM_PROPERTY: {
        NONE       : 'none',
        HAS_ERROR  : 'has_error',
        HAS_WARNING: 'has_warning'
    },
    STATE_VALUE_PLUS      : {
        ON : '+',
        OFF: ''
    },
    STATE_IS_NULL_VALUE   : {
        TRUE : '1',
        FALSE: '0'
    },
    ACTIVE                : {
        TRUE : '1',
        FALSE: '0'
    },
    MAX_SELECTABLE_ITEMS  : {
        RESULT_MODULATIONS: '4'
    },
    CUSTOM_SELECT         : {
        PLUS_AND_INHERITANCE       : '__PLUS_AND_INHERITANCE__',
        PLUS_AND_OVERRIDE          : '__PLUS_AND_OVERRIDE__',
        NONE                       : 'null',
        INHERITANCE                : '__INHERITANCE__',
        DEFAULT                    : '__DEFAULT_NO_TEMPLATE__',
        DEFAULT_FORCED             : '__DEFAULT_NO_TEMPLATE_FORCED__',
        DEFAULT_OR_INHERITANCE     : '__DEFAULT_OR_INHERITANCE__',
        NO_OVERRIDE                : '__NO_OVERRIDE__',
        ENTER_VALUE_FOR_MASS_CHANGE: '__ENTER_VALUE_FOR_MASS_CHANGE__'
    },
    DRAG_N_DROP           : {
        TYPE: {
            SELECTED_ITEM: 'selected-item'
        }
    },
    BOOLEAN               : {
        STATE_INHERITANCE: {
            INHERITANCE: true,
            DEFAULT    : false
        }
    },
    DATA                  : {
        IDENTIFIER_DATA_LOCAL: "_",
        PROTECTED_PLACEHOLDER: '********',
        GROUP                : {
            LOCALE   : "local",
            INHERITED: "templates",
            DFE      : "foreach-dfe"
        },
        STATUS               : {
            NONE  : "",
            NEW   : "shinken-data-status-new",
            HIDDEN: "shinken-data-hidden"
        }
    },
    TIMEPERIOD            : {
        SEPARATOR   : {
            RANGES  : ",",
            HOURS   : "-",
            HOUR_MIN: ":"
        },
        FORMAT_LABEL: {
            FULL : 'full',
            RANGE: 'range',
            HOUR : 'hour'
        },
        NO_MONTH    : "None"
    },
    ACL_MULTI             : {
        NAME: {
            READ    : 'read',
            CREATE  : 'create',
            ORGANIZE: 'organize',
            MODIFY  : 'modify',
            DELETE  : 'delete',
            ALL     : 'all'
        }
    },
    ACL_TYPE              : {
        HISTORY_SLA: 'history_sla',
        HISTORY    : 'history',
        SLA        : 'sla'
    },
    OVERRIDE              : {
        SEPERATOR: {
            AFTER_NAME: ',',
            AFTER_PROP: ' ',
            BETWEEN   : '-=#=-'
        }
    },
    NOTES_URL             : {
        SEPERATOR: {
            ENTRY    : '~#~',
            KEY_VALUE: '~='
        }
    },
    CHECK_COMMAND         : {
        SEPERATOR: '!'
    },
    PROTECTED_STATUS      : {
        NONE              : 0,
        PROTECTED         : 1,
        PROTECTED_MODIFIED: 2
    },
    SELECTOR              : {
        MAIN: "main-selector"
    },
    MASS_CHANGE           : {
        ACTION      : {
            NONE             : 'NONE',
            ADD              : 'ADD',
            ADD_SYNCHRO      : 'ADD_SYNCHRO',
            MOVE             : 'MOVE',
            EMPTY            : 'EMPTY',
            FORCE_TO_DEFAULT : 'FORCE_TO_DEFAULT',
            REPLACE          : 'REPLACE',
            REMOVE           : 'REMOVE',
            REMOVE_SYNCHRO   : 'REMOVE_SYNCHRO',
            REMOVE_ALL_EXCEPT: 'REMOVE_ALL_EXCEPT',
            SET              : 'SET',
            SET_SYNCHRO      : 'SET_SYNCHRO',
            SET_OR_CREATE    : 'SET_OR_CREATE',
            SET_IF_EXIST     : 'SET_IF_EXIST'
        },
        ACTION_EXTRA: {
            NONE  : 'NONE',
            LAST  : 'LAST',
            FIRST : 'FIRST',
            BEFORE: 'BEFORE',
            AFTER : 'AFTER'
        },
        PLUS_ACTION : {
            NONE: 'NONE',
            OFF : 'OFF',
            ON  : 'ON'
        },
        SELECTOR    : {
            ACTION        : "mass_change_action",
            ACTION_EXTRA  : "mass_change_action_extra",
            ELEMENT_EXTRA : "mass_change_element_extra",
            ELEMENT_SINGLE: "mass_change_element_single",
            ACTION_PLUS   : "mass_change_plus_action"
        }
    },
    HIDDEN                : 'hidden'
};
PROPERTY.getTypeByName = function ( property_name, shinken_element_type ) {
    switch ( property_name ) {
        case PROPERTY.CONST.NAME.CHECK_INTERVAL:
        case PROPERTY.CONST.NAME.CHECK_RUNNING_TIMEOUT:
        case PROPERTY.CONST.NAME.FIRST_NOTIFICATION_DELAY:
        case PROPERTY.CONST.NAME.FLAP_DETECTION_OPTIONS:
        case PROPERTY.CONST.NAME.FRESHNESS_THRESHOLD:
        case PROPERTY.CONST.NAME.MAX_CHECK_ATTEMPTS:
        case PROPERTY.CONST.NAME.NOTE_URL:
        case PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL:
        case PROPERTY.CONST.NAME.NOTIFICATION_OPTIONS:
        case PROPERTY.CONST.NAME.RETRY_INTERVAL:
            return PROPERTY.CONST.TYPES.STRING_INPUT;
        case PROPERTY.CONST.NAME.CHECK_PERIOD:
        case PROPERTY.CONST.NAME.MAINTENANCE_PERIOD:
        case PROPERTY.CONST.NAME.NOTIFICATION_PERIOD:
            return PROPERTY.CONST.TYPES.SINGLE_SELECT;
        case PROPERTY.CONST.NAME.USE:
        case PROPERTY.CONST.NAME.VIEW_CONTACTS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
        case PROPERTY.CONST.NAME.EDITION_CONTACTS:
        case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
        case PROPERTY.CONST.NAME.CONTACTS:
        case PROPERTY.CONST.NAME.CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.ESCALATIONS:
        case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
        case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
        case PROPERTY.CONST.NAME.PARENTS:
        case PROPERTY.CONST.NAME.NOTIFICATIONWAYS:
        case PROPERTY.CONST.NAME.CONTACTGROUPS:
        case PROPERTY.CONST.NAME.HOSTGROUPS:
            return PROPERTY.CONST.TYPES.MULTI_SELECT;
        case PROPERTY.CONST.NAME.HOST_NAME:
            switch ( shinken_element_type ) {
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    return PROPERTY.CONST.TYPES.MULTI_SELECT;
                case OBJECT.CONST.ELEMENT.TYPES.CHECK_ON_TPL_HOST:
                case OBJECT.CONST.ELEMENT.TYPES.CHECK_ON_TPL_CLUSTER:
                    return PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN;
                default:
                    return PROPERTY.CONST.TYPES.STRING_INPUT;
            }
        case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
        case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            return PROPERTY.CONST.TYPES.RANGE;
        case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
        case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
            return PROPERTY.CONST.TYPES.RANGE_WITH_INPUT;
        case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
            return PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT;
        default:
            if ( SHINKEN.TOOLS.STRING.startsWith( property_name, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                return PROPERTY.CONST.TYPES.DATA;
            }
            return '';
        
    }
    
};
var SOURCE = {};
SOURCE.CONST = {
    ASK_IMPORT: {
        NONE     : 0,
        ASKED    : 1,
        CONFIRMED: 2
    },
    VIEW_TYPES: {
        DETAIL: 0,
        ALL   : 1
    },
    TYPES     : {
        ALL      : 'all',
        COLLECTOR: 'collector',
        LISTENER : 'listener',
        ANALYZER : 'analyzer'
    },
    FIELD     : {
        NAME               : 'source_name',
        TYPE               : 'type',
        ORDER              : 'order',
        STATE              : 'state',
        ENABLED            : 'enabled',
        NEXT_IMPORT        : 'next_import',
        NB_ELEMENTS_OK     : 'nb_elements_ok',
        NB_ELEMENTS_WARNING: 'nb_elements_warning',
        NB_ELEMENTS_ERROR  : 'nb_elements_error',
        OUTPUT             : 'output',
        LAST_IMPORT        : 'last_import',
        LAST_IMPORT_HTML   : 'last_import_html',
        NEXT_IMPORT_HTML   : 'next_import_html',
        IMPORT_INTERVAL    : 'import_interval',
        IMPORT_ENABLED     : 'import_enabled',
        ALREADY_IMPORT     : 'already_import',
        IP_RANGES          : 'ip_range',
        MODULE_TYPE        : 'module_type',
        FULLY_MERGED       : 'fully_merged'
    },
    STATE     : {
        OK                          : 'OK',
        PENDING                     : 'PENDING',
        WARNING                     : 'WARNING ',
        CRITICAL                    : 'CRITICAL',
        RUNNING                     : 'RUNNING',
        NOT_CONFIGURED              : 'not-configured',
        NOT_CONFIGURED_BEFORE_IMPORT: 'not-configured-before-import',
        IN_PROGRESS                 : 'difference-computing',
        NEVER_IMPORT                : 'never-import',
        READY_FOR_IMPORT            : 'ready-for-import'
    },
    RANGE     : {
        ID         : '_id',
        NAME       : 'discovery_name',
        STATE      : 'state',
        ENABLED    : 'discovery_enabled',
        DESCRIPTION: 'notes',
        IP_RANGE   : 'iprange',
        SOURCE_NAME: 'source_name'
    }
};
SHINKEN.TOOLS.STRING             = (function ( self ) {
    "use strict";
    self.CONST = {
        REGEX                 : {
            HTML_TAG        : /<(?:.|\n)*?>/gm,
            ESCAPE_CHARACTER: /\x1b/g
        },
        WHITE_SPACE           : ' ',
        NON_BREAK_SPACE       : '\u00a0',
        INVISIBLE_CHAR       : '\u200b',
        COMMA                 : ',',
        CHAR_CODE_BACK_TO_LINE: 10,
        CHAR_CODE_INVISIBLE_CHAR: 8203
    };
    
    self.capitalize                 = function ( str ) {
        if ( !str ) {
            return "";
        }
        return str.charAt( 0 ).toUpperCase() + str.substring( 1 ).toLowerCase();
    };
    self.toUpperCase                = function ( str ) {
        return str.toUpperCase();
    };
    self.isUpperCase                = function ( str ) {
        if ( !str ) {
            return false;
        }
        return str === self.toUpperCase( str );
    };
    self.extractBetween             = function ( string, start_tag, end_tag ) {
        if ( !string ) {
            return string;
        }
        var _start = string.indexOf( start_tag );
        if ( _start === -1 ) {
            return string;
        }
        _start   = _start + start_tag.length;
        var _end = string.indexOf( end_tag, _start );
        if ( _end === -1 ) {
            return string;
        }
        return string.substring( _start, _end );
    };
    self.replaceAll                 = function ( string, target, replacement ) {
        return string.split( target ).join( replacement || '' );
    };
    self.replaceWithRegex           = function ( text_to_change, regex, change_with ) {
        return text_to_change.replace( regex, change_with );
    };
    self.extractStringIfBeginningBy = function ( str, search ) {
        var _to_return = false;
        if ( str.startsWith( search ) ) {
            _to_return = str.substr( search.length, str.length );
        }
        return _to_return;
    };
    self.contains                   = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        return string.indexOf( to_find ) !== -1;
    };
    self.containsAny                = function ( string, to_find_any_of ) {
        for ( var _i = 0; _i < to_find_any_of.length; _i++ ) {
            if ( to_find_any_of[ _i ] && self.contains( string, to_find_any_of[ _i ] ) ) {
                return true;
            }
        }
        return false;
    };
    self.containsCharCode           = function ( string, char_code ) {
        if ( !string ) {
            return false;
        }
        var _codes = this.getCharCodes( string );
        return SHINKEN.TOOLS.ARRAY.contains( _codes, char_code );
    };
    self.containsIgnoreCase         = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        
        var _string_to_lower_case  = string.toLowerCase();
        var _to_find_to_lower_case = to_find.toLowerCase();
        return self.contains( _string_to_lower_case, _to_find_to_lower_case );
    };
    self.cleanMultipleSpaces        = function( string ) {
        string = self.trim( string );
        return self.replaceWithRegex( string, /\s\s+/g, self.CONST.WHITE_SPACE );
    };
    self.removeXss                  = function ( string ) {
        string = string || "";
        string = string.replace( /&/g, "" );
        string = string.replace( /</g, "" );
        string = string.replace( />/g, "" );
        string = string.replace( /"/g, "" );
        string = string.replace( /'/g, "" );
        string = string.replace( /\//g, "" );
        return string;
    };
    self.cleanXss                   = function ( string ) {
        string = string || "";
        string = string.replace( /&/g, "&amp;" );
        string = string.replace( /</g, "&lt;" );
        string = string.replace( />/g, "&gt;" );
        string = string.replace( /"/g, "&quot;" );
        string = string.replace( /'/g, "&#x27;" );
        string = string.replace( /\//g, "&#x2F;" );
        return string;
    };
    self.uncleanBeforecleanXss      = function ( string ) {
        var _string = self.unescape_xss( string );
        return self.cleanXss( _string );
    };
    self.unescape_xss               = function ( string ) {
        string = string || "";
        string = string.replace( /&amp;/g, '&' );
        string = string.replace( /&lt;/g, '<' );
        string = string.replace( /&gt;/g, '>' );
        string = string.replace( /&quot;/g, '"' );
        string = string.replace( /&#x27;/g, "'" );
        string = string.replace( /&#x2F;/g, "/" );
        return string;
    };
    self.getRandomInt               = function ( max ) {
        return Math.floor( Math.random() * Math.floor( max ) );
    };
    self.trim                       = function ( string ) {
        return string.trim();
    };
    self.trimExtented               = function ( string ) {
        var _to_return = string.trim();
        if ( _to_return === string ) {
            return string;
        }
        return self.trimExtented( _to_return );
    };
    self.format                     = function () {
        var s = arguments[ 0 ];
        for ( var i = 0; i < arguments.length - 1; i++ ) {
            var reg = new RegExp( "\\{" + i + "\\}", "gm" );
            s       = s.replace( reg, arguments[ i + 1 ] );
        }
        return s;
    };
    self.getNumberOccurence         = function ( string, to_find ) {
        if ( to_find.length <= 0 ) {
            return (string.length + 1);
        }
        
        var n    = 0;
        var pos  = 0;
        var step = to_find.length;
        
        while ( true ) {
            pos = string.indexOf( to_find, pos );
            if ( pos >= 0 ) {
                ++n;
                pos += step;
            }
            else {
                break;
            }
        }
        return n;
    };
    self.startsWith                 = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        return string.substr( 0, to_find.length ) === to_find;
    };
    self.endsWith                   = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        var _start_index = string.length - to_find.length;
        return string.substr( _start_index ) === to_find;
    };
    self.buildS4                    = function () {
        return Math.floor( (1 + Math.random()) * 0x10000 )
                   .toString( 16 )
                   .substring( 1 );
    };
    self.buildUUID                  = function () {
        return self.buildS4() + self.buildS4() + '-' + self.buildS4() + '-' + self.buildS4() + '-' +
               self.buildS4() + '-' + self.buildS4() + self.buildS4() + self.buildS4();
    };
    self.getCharCodes               = function ( string ) {
        var _size      = string.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = string.charCodeAt( i );
        }
        return _to_return;
    };
    self.b64Encode                  = function ( str ) {
        return btoa( encodeURIComponent( str ).replace( /%([0-9A-F]{2})/g, function ( match, p1 ) {
            return String.fromCharCode( parseInt( p1, 16 ) );
        } ) );
    };
    self.b64Decode                  = function ( str ) {
        return decodeURIComponent( Array.prototype.map.call( atob( str ), function ( c ) {
            return '%' + ('00' + c.charCodeAt( 0 ).toString( 16 )).slice( -2 );
        } ).join( '' ) );
    };
    self.utf8Encode                 = function ( str ) {
        return encodeURIComponent( str );
    };
    self.utf8decode                 = function ( str ) {
        return decodeURIComponent( str );
    };
    self.isEmpty                    = function ( string ) {
        if ( !string ) {
            return true;
        }
        var s = string.replace( /\s/g, '' );
        return s.length === 0;
    };
    self.isEmptyHtml                = function ( string ) {
        if ( !string ) {
            return true;
        }
        var dom = DOM.Service.createElement( 'div', '', string );
        return self.isEmpty( dom.innerText );
    };
    self.indexesOf                  = function ( string, to_find ) {
        var _to_return = [];
        
        var _length         = string.length;
        var _length_to_find = to_find.length;
        
        var _current;
        for ( var i = 0; i <= _length - _length_to_find; i++ ) {
            _current = string.substring( i, i + _length_to_find );
            if ( _current === to_find ) {
                _to_return.push( i );
            }
        }
        return _to_return;
    };
    self.indexesOfNotBetween        = function ( string, to_find, to_ignore ) {
        var _to_return = self.indexesOf( string, to_find );
        return self.splicesindexesOfNotBetween( _to_return, to_ignore );
    };
    self.splicesindexesOfNotBetween = function ( indexes, to_ignore ) {
        var _to_return = indexes;
        var _current_index;
        for ( var i = _to_return.length - 1; i >= 0; i-- ) {
            _current_index = _to_return[ i ];
            for ( var j = 0, _size_j = to_ignore.length; j < _size_j; j = j + 2 ) {
                if ( _current_index > to_ignore[ j ] && _current_index < to_ignore[ j + 1 ] ) {
                    _to_return.splice( i, 1 );
                    break;
                }
            }
        }
        return _to_return;
    };
    self.extraTextNotBetween        = function ( text, indexes_to_ignore ) {
        var _to_return = [];
        if ( !Array.isArray( indexes_to_ignore ) || !indexes_to_ignore.length ) {
            return _to_return;
        }
        var _split = self.splitWithIndexes( text, indexes_to_ignore, 1 );
        var _keep = true;
        for ( var i = 0, _size_i = _split.length; i < _size_i; i++ ) {
            if ( _keep ) {
                _to_return.push(_split[i]);
            }
            _keep = !_keep;
        }
        return _to_return;
    };
    self.isInteger                  = function ( string ) {
        var pattern = /^\d+$/;
        return pattern.test( string );
    };
    self.splitWithIndexes           = function ( string, indexes, size_split_label ) {
        var _to_return = [];
        if ( !size_split_label ) {
            size_split_label = 1;
        }
        var _size_index = indexes.length;
        if ( !_size_index ) {
            _to_return[ 0 ] = string;
            return _to_return;
        }
        
        for ( var i = 0; i <= _size_index; i++ ) {
            if ( i === 0 ) {
                _to_return[ i ] = string.substring( 0, indexes[ i ] );
            }
            else if ( i === _size_index ) {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label );
            }
            else {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label, indexes[ i ] );
            }
        }
        
        return _to_return;
        
    };
    self.prefix_by_zero             = function ( str, max ) {
        str = str.toString();
        return str.length < max ? self.prefix_by_zero( "0" + str, max ) : str;
    };
    self.getSubStringUntil          = function ( string, start, end ) {
        var _size = string.length;
        return string.substr( start, _size - end );
    };
    self.getAllIndexOf              = function ( string, to_find, to_return, start_index ) {
        if ( !to_return ) {
            to_return   = [];
            start_index = 0;
        }
        var _index = string.substr( start_index ).indexOf( to_find );
        if ( _index !== -1 ) {
            to_return.push( _index + start_index );
            return self.getAllIndexOf( string, to_find, to_return, _index + to_find.length + start_index );
        }
        return to_return;
    };
    self.escapeRegExp               = function ( string ) {
        return string.replace( /[.*+?^${}()|[\]\\]/g, '\\$&' );
    };
    self.isMatchingStarRegexTab     = function ( to_test, tab_to_test ) {
        for ( var i = 0, _size_i = tab_to_test.length; i < _size_i; i++ ) {
            if ( self.isMatchingStarRegex( to_test, tab_to_test[ i ].trim() ) ) {
                return true;
            }
        }
        return false;
    };
    self.isMatchingStarRegex        = function ( to_test, regex_star ) {
        var _contains_star = self.getAllIndexOf( regex_star, "*" );
        if ( !_contains_star.length ) {
            return to_test.trim() === regex_star.trim();
        }
        var _replaced = SHINKEN.TOOLS.STRING.replaceAll( regex_star, "**", "*" );
        if ( regex_star !== _replaced ) {
            return self.isMatchingStarRegex( to_test, _replaced );
        }
        regex_star         = self.escapeRegExp( regex_star );
        var _current       = new RegExp( SHINKEN.TOOLS.STRING.replaceAll( SHINKEN.TOOLS.STRING.trim( regex_star ), "\\*", ".*" ) );
        var _current_match = to_test.match( _current );
        if ( _current_match && _current_match[ 0 ] === to_test ) {
            return true;
        }
        return false;
    };
    return self;
})( SHINKEN.TOOLS.STRING || {} );
SHINKEN.TOOLS.STRING.PARENTHESIS = (function ( self ) {
    "use strict";
    self.isValid          = function ( indexes_opening, indexes_closing ) {
        var _size_open  = indexes_opening.length;
        var _size_close = indexes_closing.length;
        if ( _size_open !== _size_close ) {
            return _( "validator.parenthesis.not_same_number" );
        }
        for ( var i = 0; i < _size_open; i++ ) {
            if ( indexes_opening[ i ] > indexes_closing[ i ] ) {
                return _( "validator.parenthesis.not_good_order" );
            }
        }
    };
    self.getActiveIndexes = function ( indexes_opening, indexes_closing ) {
        var _to_return = [];
        var _size      = indexes_opening.length;
        var _concat    = [];
        for ( var i = 0; i < _size; i++ ) {
            _concat.push( { index: indexes_opening[ i ], is_open: true } );
        }
        for ( var i = 0; i < _size; i++ ) {
            _concat.push( { index: indexes_closing[ i ], is_open: false } );
        }
        _concat = SHINKEN.TOOLS.ARRAY.sortArray( _concat, "index" );
        if ( !_concat.length ) {
            return _to_return;
        }
        _to_return.push( _concat[ 0 ].index );
        var _current;
        var _search_close = 1;
        for ( var i = 1, _size_i = _concat.length; i < _size_i; i++ ) {
            _current = _concat[ i ];
            if ( _search_close ) {
                if ( _current.is_open ) {
                    _search_close++;
                }
                else {
                    _search_close--;
                    if ( !_search_close ) {
                        _to_return.push( _current.index );
                    }
                }
            }
            else {
                _to_return.push( _current.index );
                _search_close++;
            }
        }
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.PARENTHESIS || {} );
SHINKEN.TOOLS.MD5 = (function ( self ) {
    "use strict";
    self.MD5 = function ( d ) {
        var result = M( V( Y( X( d ), 8 * d.length ) ) );
        return result.toLowerCase();
    };
    
    function M ( d ) {
        for ( var _, m = "0123456789ABCDEF", f = "", r = 0; r < d.length; r++ ) {
            _ = d.charCodeAt( r ), f += m.charAt( _ >>> 4 & 15 ) + m.charAt( 15 & _ );
        }
        return f;
    }
    
    function X ( d ) {
        for ( var _ = Array( d.length >> 2 ), m = 0; m < _.length; m++ ) {
            _[ m ] = 0;
        }
        for ( m = 0; m < 8 * d.length; m += 8 ) {
            _[ m >> 5 ] |= (255 & d.charCodeAt( m / 8 )) << m % 32;
        }
        return _;
    }
    
    function V ( d ) {
        for ( var _ = "", m = 0; m < 32 * d.length; m += 8 ) {
            _ += String.fromCharCode( d[ m >> 5 ] >>> m % 32 & 255 );
        }
        return _;
    }
    
    function Y ( d, _ ) {
        d[ _ >> 5 ] |= 128 << _ % 32, d[ 14 + (_ + 64 >>> 9 << 4) ] = _;
        for ( var m = 1732584193, f = -271733879, r = -1732584194, i = 271733878, n = 0; n < d.length; n += 16 ) {
            var h = m,
                t = f,
                g = r,
                e = i;
            f = md5_ii( f = md5_ii( f = md5_ii( f = md5_ii( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_ff( f = md5_ff( f = md5_ff( f = md5_ff( f, r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 0 ], 7, -680876936 ), f, r, d[ n + 1 ], 12, -389564586 ), m, f, d[ n + 2 ], 17, 606105819 ), i, m, d[ n + 3 ], 22, -1044525330 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 4 ], 7, -176418897 ), f, r, d[ n + 5 ], 12, 1200080426 ), m, f, d[ n + 6 ], 17, -1473231341 ), i, m, d[ n + 7 ], 22, -45705983 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 8 ], 7, 1770035416 ), f, r, d[ n + 9 ], 12, -1958414417 ), m, f, d[ n + 10 ], 17, -42063 ), i, m, d[ n + 11 ], 22, -1990404162 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 12 ], 7, 1804603682 ), f, r, d[ n + 13 ], 12, -40341101 ), m, f, d[ n + 14 ], 17, -1502002290 ), i, m, d[ n + 15 ], 22, 1236535329 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 1 ], 5, -165796510 ), f, r, d[ n + 6 ], 9, -1069501632 ), m, f, d[ n + 11 ], 14, 643717713 ), i, m, d[ n + 0 ], 20, -373897302 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 5 ], 5, -701558691 ), f, r, d[ n + 10 ], 9, 38016083 ), m, f, d[ n + 15 ], 14, -660478335 ), i, m, d[ n + 4 ], 20, -405537848 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 9 ], 5, 568446438 ), f, r, d[ n + 14 ], 9, -1019803690 ), m, f, d[ n + 3 ], 14, -187363961 ), i, m, d[ n + 8 ], 20, 1163531501 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 13 ], 5, -1444681467 ), f, r, d[ n + 2 ], 9, -51403784 ), m, f, d[ n + 7 ], 14, 1735328473 ), i, m, d[ n + 12 ], 20, -1926607734 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 5 ], 4, -378558 ), f, r, d[ n + 8 ], 11, -2022574463 ), m, f, d[ n + 11 ], 16, 1839030562 ), i, m, d[ n + 14 ], 23, -35309556 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 1 ], 4, -1530992060 ), f, r, d[ n + 4 ], 11, 1272893353 ), m, f, d[ n + 7 ], 16, -155497632 ), i, m, d[ n + 10 ], 23, -1094730640 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 13 ], 4, 681279174 ), f, r, d[ n + 0 ], 11, -358537222 ), m, f, d[ n + 3 ], 16, -722521979 ), i, m, d[ n + 6 ], 23, 76029189 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 9 ], 4, -640364487 ), f, r, d[ n + 12 ], 11, -421815835 ), m, f, d[ n + 15 ], 16, 530742520 ), i, m, d[ n + 2 ], 23, -995338651 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 0 ], 6, -198630844 ), f, r, d[ n + 7 ], 10, 1126891415 ), m, f, d[ n + 14 ], 15, -1416354905 ), i, m, d[ n + 5 ], 21, -57434055 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 12 ], 6, 1700485571 ), f, r, d[ n + 3 ], 10, -1894986606 ), m, f, d[ n + 10 ], 15, -1051523 ), i, m, d[ n + 1 ], 21, -2054922799 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 8 ], 6, 1873313359 ), f, r, d[ n + 15 ], 10, -30611744 ), m, f, d[ n + 6 ], 15, -1560198380 ), i, m, d[ n + 13 ], 21, 1309151649 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 4 ], 6, -145523070 ), f, r, d[ n + 11 ], 10, -1120210379 ), m, f, d[ n + 2 ], 15, 718787259 ), i, m, d[ n + 9 ], 21, -343485551 ), m = safe_add( m, h ), f = safe_add( f, t ), r = safe_add( r, g ), i = safe_add( i, e );
        }
        return Array( m, f, r, i );
    }
    
    function md5_cmn ( d, _, m, f, r, i ) {
        return safe_add( bit_rol( safe_add( safe_add( _, d ), safe_add( f, i ) ), r ), m );
    }
    
    function md5_ff ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & m | ~_ & f, d, _, r, i, n );
    }
    
    function md5_gg ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & f | m & ~f, d, _, r, i, n );
    }
    
    function md5_hh ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ ^ m ^ f, d, _, r, i, n );
    }
    
    function md5_ii ( d, _, m, f, r, i, n ) {
        return md5_cmn( m ^ (_ | ~f), d, _, r, i, n );
    }
    
    function safe_add ( d, _ ) {
        var m = (65535 & d) + (65535 & _);
        return (d >> 16) + (_ >> 16) + (m >> 16) << 16 | 65535 & m;
    }
    
    function bit_rol ( d, _ ) {
        return d << _ | d >>> 32 - _;
    }
    
    return self;
})( SHINKEN.TOOLS.MD5 || {} );
String.prototype.startsWith = String.prototype.startsWith || function ( pattern ) {
    return this.indexOf( pattern ) === 0;
};
String.prototype.endsWith   = String.prototype.endsWith || function ( pattern ) {
    var d = this.length - pattern.length;
    return d >= 0 && this.lastIndexOf( pattern ) === d;
};
SHINKEN.TOOLS.CLASS = (function ( self ) {
    "use strict";
    self.CONST        = {
        COMPONENT: {
            SELECT: "component-select"
        }
    };
    self.addPrototype = function ( object_to_add_in, object_to_add_from ) {
        var _current;
        var _keys = Object.keys( object_to_add_from.prototype );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = _keys[ i ];
            if ( !object_to_add_in.prototype[ _current ] ) {
                object_to_add_in.prototype[ _current ] = object_to_add_from.prototype[ _current ];
            }
        }
    };
    return self;
})( SHINKEN.TOOLS.CLASS || {} );
var WINDOW = {};
WINDOW.CONST = {
    ELEMENT: {
        GENERIC      : "generic",
        DATAS        : "datas",
        CHECKS       : "checks",
        MONITORING   : "monitoring",
        NOTIFICATIONS: "notifications",
        ADVANCED     : "advanced",
        USER_RIGHTS  : "user-rights",
        AUTHORIZATION: "authorization"
    },
    CLASS  : {
        WINDOW_GROUP: "shinken-window-group",
        WINDOW_TAB  : "shinken-window-element"
    },
    ID     : {
        WINDOW_TAB: "id-shinken-window-",
        TAB_PANE  : "tab-pane-"
    }
};
var CONTROLLER = {};
CONTROLLER.CONST = {
    MASS_CHANGE: {
        NAME      : "mass-change",
        TYPE      : {
            PROPERTIES     : 'properties',
            DATAS          : 'datas',
            LOCAL_DATAS    : 'local_datas',
            DFE_DATAS      : 'dfe_datas',
            CHECKS         : 'checks',
            CHECKS_OVERRIDE: 'overrides',
            CHECKS_EXCLUDE : 'excludes'
        },
        GROUP_DATA: {
            ALL  : "___ALL___",
            LOCAL: "___LocalData___"
        }
    },
    PHASE      : {
        ACTIVE: 1
    }
};
SHINKEN.OBJECT.Counter           = function ( dom_element, show_if_null ) {
    this.is_string              = false;
    this.is_label_before        = false;
    this.has_animation          = false;
    this.label                  = "";
    this.show_if_null           = !!show_if_null;
    this.elements_mapping       = {};
    this.counter_final          = 0;
    this.counter_parent         = null;
    this.uuid                   = SHINKEN.TOOLS.STRING.buildUUID();
    this.timeout_html           = null;
    this.toggle_parent_activity = false;
    this.target_dom_element     = null;
    if ( dom_element ) {
        this.init( dom_element );
    }
};
SHINKEN.OBJECT.Counter.prototype = {
    init               : function ( dom_element, update_with_dom ) {
        this.dom_element = dom_element;
        this.setDiscreet( !this.dom_element );
        if ( this.dom_element ) {
            this.dom_element_label = dom_element.querySelector( '.shinken-counter-label' );
            var _name_parent       = this.dom_element.dataset.parent;
            if ( _name_parent ) {
                this.counter_parent = MANAGER.__instance_counter_distributor.findCounter( _name_parent );
            }
            var _label = this.dom_element_label.querySelector( '.shinken-counter-extra-label' );
            if ( _label ) {
                this.label           = _label.outerHTML;
                this.is_label_before = !!this.dom_element_label.dataset.isBefore;
            }
            var _is_string = this.dom_element_label.dataset.isString;
            if ( _is_string ) {
                this.is_string = true;
            }
            if ( this.dom_element.dataset.showIfNull ) {
                this.show_if_null = true;
            }
            if ( this.dom_element.dataset.isDiscreet ) {
                this.setDiscreet( true );
            }
            if ( update_with_dom ) {
                this.initValueWithDom();
            }
        }
    },
    initValueWithDom   : function () {
        if ( !this.dom_element ) {
            return;
        }
        if ( !this.dom_element.dataset.number ) {
            return;
        }
        this.update( "init_with_dom", parseInt( this.dom_element.dataset.number ) );
    },
    getValue           : function () {
        return this.counter_final;
    },
    has                : function ( name ) {
        return !!this.elements_mapping[ name ];
    },
    setDiscreet        : function ( to_set ) {
        this.is_discreet = to_set;
    },
    reset              : function () {
        this.elements_mapping = {};
        this.counter_final    = 0;
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        this._updateHTML();
    },
    showForParent      : function ( show ) {
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, show ? this.counter_final : 0 );
        }
    },
    update             : function ( name, nb_counter, tooltip, retry_update_html, is_force ) {
        if ( !nb_counter ) {
            delete this.elements_mapping[ name ];
        }
        else {
            if ( !is_force && this.elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this.elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltip( tooltip );
        }
        this.counter_final = this.is_string ? "" : 0;
        var _keys          = Object.keys( this.elements_mapping );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counter_final = this.counter_final + this.elements_mapping[ _keys[ i ] ];
        }
        if ( this.target_dom_element ) {
            DOM.Service.setDataSet( this.target_dom_element, 'number', this.counter_final || 0 );
        }
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        return this._askUpdateHTML( retry_update_html );
    },
    setParent          : function ( to_set ) {
        this.counter_parent = to_set;
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        this._updateHTML();
    },
    setTargetDomElement: function ( to_set ) {
        this.target_dom_element = to_set;
        if ( this.target_dom_element ) {
            DOM.Service.setDataSet( this.target_dom_element, 'number', this.counter_final || 0 );
        }
    },
    setLabel           : function ( to_set, is_before ) {
        this.label           = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this.is_label_before = !!is_before;
    },
    isString           : function ( to_set ) {
        this.is_string = to_set;
    },
    _askUpdateHTML     : function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        var self          = this;
        this.timeout_html = setTimeout( function () {
            self._updateHTML( retry_update_html );
            this.timeout_html = null;
        }, 50 );
    },
    _updateHTML        : function ( retry_update_html ) {
        if ( this.is_discreet ) {
            return false;
        }
        if ( !this.dom_element_label ) {
            if ( retry_update_html ) {
                var self = this;
                setTimeout( function () {
                    self._updateHTML();
                }, 100 );
            }
            return false;
        }
        if ( this.counter_final ) {
            this.dom_element_label.innerHTML = this.label ? this.is_label_before ? this.label + " " + this.counter_final : this.counter_final + " " + this.label : this.counter_final;
            DOM.Service.setDataSet( this.dom_element, 'number', this.counter_final );
        }
        else if ( this.show_if_null ) {
            this.dom_element_label.innerHTML = '0';
            DOM.Service.setDataSet( this.dom_element, 'number', '0' );
        }
        else {
            this.dom_element_label.innerHTML = '';
            DOM.Service.setDataSet( this.dom_element, 'number', '' );
        }
        
        if ( this.has_animation ) {
            var _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-pulsate-parent', 10 );
            if ( _parent_dom_element ) {
                DOM.Service.askAddClass( _parent_dom_element, 'shinken-pulsate', 2000 );
            }
        }
        if ( this.toggle_parent_activity ) {
            var _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-counter-parent', 10 );
            if ( _parent_dom_element ) {
                if ( this.counter_final ) {
                    _parent_dom_element.classList.add( 'shinken-active' );
                }
                else {
                    _parent_dom_element.classList.remove( 'shinken-active' );
                }
            }
        }
        return true;
    },
    setTooltip         : function ( label, type ) {
        if ( !label ) {
            return;
        }
        this.dom_element.setAttribute( 'onmouseenter', 'SHINKEN_TOOLTIP.showTooltip(this)' );
        this.dom_element.setAttribute( 'onmouseleave', 'SHINKEN_TOOLTIP.hideTooltip()' );
        this.dom_element.setAttribute( 'shi-tip-html', label );
        this.dom_element.setAttribute( 'shi-tip-type', type );
    }
};
SHINKEN.OBJECT.CounterInterface           = function () {
};
SHINKEN.OBJECT.CounterInterface.prototype = {
    initCounters            : function ( parent, update_with_dom ) {
        this.errors        = new SHINKEN.OBJECT.Counter();
        this.errors.type   = "errors";
        this.warnings      = new SHINKEN.OBJECT.Counter();
        this.warnings.type = "warnings";
        this.user_set      = new SHINKEN.OBJECT.Counter();
        this.user_set.type = "user_set";
        this.total         = new SHINKEN.OBJECT.Counter();
        this.total.type    = "total";
        this.initCountersDom( update_with_dom );
        if ( parent ) {
            this.setParentCounter( parent );
        }
    },
    initCountersDom         : function ( update_with_dom ) {
        if ( this.dom_element ) {
            this.errors.init( this.dom_element.querySelector( '.shinken-error-counter' ), update_with_dom );
            this.warnings.init( this.dom_element.querySelector( '.shinken-warning-counter' ), update_with_dom );
            this.user_set.init( this.dom_element.querySelector( '.shinken-user-set-counter' ), update_with_dom );
            this.total.init( this.dom_element.querySelector( '.shinken-window-total-counter' ), update_with_dom );
        }
    },
    initCounterValuesWithDom: function () {
        this.errors.initValueWithDom();
        this.warnings.initValueWithDom();
        this.user_set.initValueWithDom();
        this.total.initValueWithDom();
    },
    resetCounters           : function () {
        this.warnings.reset();
        this.errors.reset();
        this.user_set.reset();
        this.total.reset();
    },
    hideCountersForParent   : function () {
        this.warnings.showForParent( false );
        this.errors.showForParent( false );
        this.user_set.showForParent( false );
        this.total.showForParent( false );
    },
    showCountersForParent   : function () {
        this.warnings.showForParent( true );
        this.errors.showForParent( true );
        this.user_set.showForParent( true );
        this.total.showForParent( true );
    },
    hasError                : function () {
        return !!this.errors.counter_final;
    },
    hasWarning              : function () {
        return !!this.warnings.counter_final;
    },
    setError                : function ( data_name, nb ) {
        this.errors.update( data_name, nb );
    },
    setWarning              : function ( data_name, nb ) {
        this.warnings.update( data_name, nb );
    },
    setUserSet              : function ( data_name, nb ) {
        this.user_set.update( data_name, nb );
    },
    setTotal                : function ( data_name, nb ) {
        this.total.update( data_name, nb );
    },
    getCounterError         : function () {
        return this.errors;
    },
    getCounterWarning       : function () {
        return this.warnings;
    },
    getCounterUserSet       : function () {
        return this.user_set;
    },
    getCounterTotal         : function () {
        return this.total;
    },
    setParentCounter        : function ( to_set ) {
        if ( to_set ) {
            this.getCounterError().setParent( to_set.getCounterError() );
            this.getCounterWarning().setParent( to_set.getCounterWarning() );
            this.getCounterUserSet().setParent( to_set.getCounterUserSet() );
            this.getCounterTotal().setParent( to_set.getCounterTotal() );
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
            this.getCounterUserSet().setParent();
            this.getCounterTotal().setParent();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterface, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.NAVIGATOR = (function( self ) {
    "use strict";
    
    var navigator = {
        isChrome : false,
        isFireFox: false,
        isIE     : false,
        isHidden : false
    };
    
    
    setInterval( function() {
        setDocumentHidden();
    }, 2000 );
    
    function setDocumentHidden() {
        navigator.isHidden = document.hidden;
    }
    
    self.isNavigator          = function( type ) {
        return navigator[ type ];
    };
    self.isNavigatorHidden    = function() {
        return navigator.isHidden;
    };
    self.init                 = function() {
        if ( window.navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            navigator.isFireFox = true;
        }
        else if ( window.navigator.userAgent.indexOf( 'Chrome' ) !== -1 ) {
            navigator.isChrome = true;
        }
        else if ( window.navigator.userAgent.indexOf( 'Trident' ) !== -1 ) {
            navigator.isIE = true;
        }
    };
    self.shinken_beforeunload = function( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_beforeunload();
            default:
                return '';
        }
    };
    self.shinken_unload       = function( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_unload();
            default:
                return '';
        }
    };
    
    
    return self;
})( SHINKEN.NAVIGATOR || {} );
SHINKEN.NAVIGATOR.init();
SHINKEN.TOOLS.ARRAY = (function ( self ) {
    "use strict";
    
    self.split                    = function ( array_1, separator ) {
        var toReturn = array_1.split( separator );
        return toReturn;
    };
    self.concat                   = function ( array_1, array_2 ) {
        var toReturn = array_1.concat( array_2 );
        return toReturn;
    };
    self.concatUnique             = function ( array_1, array_2, key_for_unique ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            toReturn[ i ] = array_1[ i ];
        }
        _size = array_2.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !key_for_unique ) {
                self.addElement( toReturn, array_2[ i ] );
            }
            else if ( !self.containsElementWith( toReturn, array_2[ i ][ key_for_unique ], key_for_unique ) ) {
                toReturn.push( array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.sortNumber               = function ( array ) {
        if ( !array ) {
            return array;
        }
        return array.sort( function ( a, b ) {
            return a - b;
        } );
    };
    self.sortArray                = function ( array, comparator_value, first_index_to_sort, reverse ) {
        if ( reverse === undefined ) {
            reverse = false;
        }
        
        if ( !array ) {
            return array;
        }
        if ( !comparator_value ) {
            return array.sort();
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        if ( first_index_to_sort ) {
            fix_array = array.slice( 0, first_index_to_sort );
            to_sort   = array.slice( first_index_to_sort, size );
        }
        to_sort.sort( function ( a, b ) {
            if ( a[ comparator_value ] < b[ comparator_value ] ) {
                return reverse ? 1 : -1;
            }
            else if ( a[ comparator_value ] > b[ comparator_value ] ) {
                return reverse ? -1 : 1;
            }
            return 0;
        } );
        return fix_array.concat( to_sort );
    };
    self.sortArrayMultiple        = function ( array, comparator_values ) {
        if ( !array ) {
            return array;
        }
        if ( !comparator_values ) {
            return array;
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        to_sort.sort(
            function ( a, b ) {
                return self._comparator( a, b, comparator_values, 0 );
            }
        );
        return fix_array.concat( to_sort );
    };
    self.getMapValues             = function ( map ) {
        if ( !map ) {
            return null;
        }
        return Object.keys( map ).map( function ( e ) {
            return map[ e ];
        } );
    };
    self._comparator              = function ( a, b, comparators, index ) {
        if ( index >= comparators.length ) {
            return 0;
        }
        if ( a[ comparators[ index ] ] < b[ comparators[ index ] ] ) {
            return -1;
        }
        else if ( a[ comparators[ index ] ] > b[ comparators[ index ] ] ) {
            return 1;
        }
        return self._comparator( a, b, comparators, (index + 1) );
    };
    self.filterWith               = function ( array, key, value ) {
        if ( !array || !key || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var toReturn = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.filterWithDeeply         = function ( array, keys, value ) {
        if ( !array || !keys || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _to_return = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( self.findValueDeeply( _current, keys ) === value ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    };
    self.findValueDeeply          = function ( dict, keys ) {
        if ( !dict || !keys ) {
            return null;
        }
        var _size = keys.length;
        if ( _size < 1 ) {
            return null;
        }
        var _to_return = dict[ keys[ 0 ] ];
        if ( _size === 1 ) {
            return _to_return;
        }
        return self.findValueDeeply( _to_return, SHINKEN.TOOLS.ARRAY.clone( keys ).splice( -1, 1 ) );
    };
    self.findFirstElementWith     = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return _current;
            }
        }
        return null;
    };
    self.findFirstIndexWith       = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return i;
            }
        }
        return -1;
    };
    self.getLengthWith            = function ( array, key, value ) {
        var _filtered = self.filterWith( array, key, value );
        if ( !_filtered ) {
            return 0;
        }
        return _filtered.length;
    };
    self.extractKey               = function ( array, key, ignoreEmpty ) {
        if ( !array || !key ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current && !ignoreEmpty ) {
                toReturn[ i ] = null;
            }
            else {
                if ( _current[ key ] || !ignoreEmpty ) {
                    toReturn[ i ] = _current[ key ];
                }
            }
        }
        return toReturn;
    };
    self.extractKeys              = function ( array, keys ) {
        var _keys_size = keys.length;
        if ( !array || !_keys_size ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current ) {
                toReturn[ i ] = self.initEmptyArray( _keys_size );
            }
            else {
                toReturn[ i ] = [];
                for ( var j = 0; j < _keys_size; j++ ) {
                    toReturn[ i ].push( _current[ keys[ j ] ] );
                }
            }
        }
        return toReturn;
    };
    self.removeDuplicate          = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( toReturn.indexOf( _current ) !== -1 ) {
                continue;
            }
            toReturn.push( _current );
        }
        return toReturn;
    };
    self.removeDuplicateArray     = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        var _to_add;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            _to_add  = true;
            for ( var j = 0, _size_j = toReturn.length; j < _size_j; j++ ) {
                if ( self.areEquals( toReturn[ j ], _current ) ) {
                    _to_add = false;
                }
            }
            if ( _to_add ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.hasSameKeyContent        = function ( array1, array2, key ) {
        if ( !key ) {
            return false;
        }
        if ( !array1 && !array2 ) {
            return true;
        }
        if ( !array1 || !array2 ) {
            return false;
        }
        
        var _extract1 = self.extractKey( array1, key );
        var _extract2 = self.extractKey( array2, key );
        if ( _extract1 === null && _extract2 === null ) {
            return true;
        }
        else if ( _extract1 === null || _extract2 === null ) {
            return false;
        }
        
        var _size1 = _extract1.length;
        var _size2 = _extract2.length;
        
        if ( _size1 !== _size2 ) {
            return false;
        }
        
        for ( var i = 0; i < _extract1; i++ ) {
            if ( _extract1[ i ] !== _extract2[ i ] ) {
                return false;
            }
        }
        return true;
    };
    self.getElementFromTo         = function ( array, indexBegin, indexEnd ) {
        return array.slice( indexBegin, indexEnd );
    };
    self.getElement               = function ( array, key, value_to_find ) {
        var _size = self.getLength( array );
        var _current_element;
        for ( var i = 0; i < _size; i++ ) {
            _current_element = array[ i ];
            if ( _current_element[ key ] === value_to_find ) {
                return _current_element;
            }
        }
    };
    self.reverseArrayClone        = function ( array ) {
        var toReturn = Array.prototype.slice.call( array );
        toReturn.reverse();
        return toReturn;
    };
    self.initEmptyArray           = function ( length ) {
        var toReturn = [];
        for ( var i = 0; i <= length; i++ ) {
            toReturn.push( null );
        }
        return toReturn;
    };
    self.initIntegerArray         = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i );
        }
        return toReturn;
    };
    self.initIntegerArrayToString = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i + "" );
        }
        return toReturn;
    };
    self.indexOf                  = function ( array, key, value ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ][ key ];
            if ( _current && _current === value ) {
                return i;
            }
        }
        return -1;
    };
    self.search                   = function ( array, key, value ) {
        var index = self.indexOf( array, key, value );
        if ( index === -1 ) {
            return null;
        }
        return array[ index ];
    };
    self.join                     = function ( array, separator ) {
        if ( Array.isArray( array ) ) {
            return array.join( separator );
        }
        return array.toString();
    };
    self.getLength                = function ( array ) {
        if ( array ) {
            return array.length;
        }
        return 0;
    };
    self.clone                    = function ( array ) {
        return array.slice( 0 );
    };
    self.swap                     = function ( array, index_1, index_2 ) {
        if ( !array ) {
            return;
        }
        var b            = array[ index_1 ];
        array[ index_1 ] = array[ index_2 ];
        array[ index_2 ] = b;
        return array;
    };
    self.contains                 = function ( array, toSearch ) {
        if ( !array ) {
            return false;
        }
        return array.indexOf( toSearch ) !== -1;
    };
    self.addElement               = function ( array, toAdd ) {
        if ( self.contains( array, toAdd ) ) {
            return -1;
        }
        return array.push( toAdd );
    };
    self.removeElement            = function ( array, toRemove ) {
        var index = array.indexOf( toRemove );
        if ( index === -1 ) {
            return false;
        }
        array.splice( index, 1 );
        return true;
    };
    self.parseToArray             = function ( obj ) {
        if ( !obj ) {
            return null;
        }
        
        var _keys      = Object.keys( obj );
        var _size      = _keys.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = obj[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.containsElementWith      = function ( array, toSearch, key ) {
        if ( !array ) {
            return false;
        }
        if ( !key ) {
            return false;
        }
        
        var _size = array.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( array[ i ][ key ] === toSearch ) {
                return true;
            }
        }
        return false;
    };
    self.areEquals                = function ( array1, array2 ) {
        return JSON.stringify( array1 ) === JSON.stringify( array2 );
    };
    self.getMedianIndex           = function ( array, round_up ) {
        if ( !array ) {
            return SHINKEN.TOOLS.ARRAY.NOT_FOUND;
        }
        return round_up ? Math.ceil( array.length / 2 ) : Math.floor( array.length / 2 );
    };
    self.getFirstPartOf           = function ( array ) {
        return array.slice( 0, self.getMedianIndex( array ) + 1 );
    };
    self.getLastPartOf            = function ( array ) {
        return array.slice( self.getMedianIndex( array ), array.length );
    };
    return self;
})( SHINKEN.TOOLS.ARRAY || {} );
SHINKEN.TOOLS.ARRAY.NOT_FOUND = -1;
DOM.BodyService = (function( self ) {
    "use strict";
    
    var __body_element;
    var __list_to_remove = {};
    var __time_out_add;
    
    self.load = function() {
        if ( !__body_element ) {
            __body_element = document.querySelector( 'body' );
        }
    };
    self.hasChildWithID = function( id ) {
        var _child = self.getDomElement().querySelector( "#" + id );
        return _child;
    };
    self.askAddClass = function ( to_add, time_out ) {
        self.getDomElement().classList.add(to_add);
        if ( time_out ) {
            __list_to_remove[ to_add ] = true;
            clearTimeout( __time_out_add );
            __time_out_add = setTimeout( function () {
                var _keys = Object.keys( __list_to_remove );
                for( var i = 0, _size = _keys.length ; i < _size; i++ ) {
                    self.getDomElement().classList.remove(_keys[i]);
                }
                __list_to_remove = {};
            }, time_out );
        }
    };
    self.removeClass = function ( to_remove ) {
        self.getDomElement().classList.remove(to_remove);
        __list_to_remove[ to_remove ] = false;
    };
    self.addChild       = function( dom_element ) {
        DOM.Service.addElementTo( dom_element, self.getDomElement() );
    };
    self.getDomElement  = function() {
        if ( !__body_element ) {
            self.load();
        }
        return __body_element;
    };
    self.cleanDomElement  = function() {
        __body_element = null;
    };
    return self;
})( DOM.BodyService || {} );
DOM.ScrollService = (function ( self ) {
    "use strict";
    
    self.getMiddleScrollPosition       = function ( dom_element_container ) {
        var _top    = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.TOP );
        var _bottom = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.BOTTOM );
        
        return ((_bottom - _top) / 2) + _top;
    };
    self.getFirstVisibleDom            = function ( dom_element_container, css_selector_children, move_down ) {
        var _position = DOM.Service.getBoundingClientRect( dom_element_container, move_down ? DOM.CONST.STYLE.TOP : DOM.CONST.STYLE.BOTTOM );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _position, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFromMiddle = function ( dom_element_container, css_selector_children, move_down ) {
        var _middle_pos = DOM.ScrollService.getMiddleScrollPosition( dom_element_container );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _middle_pos, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFrom       = function ( list, position, move_down, dom_element_container ) {
        var _size  = list.length;
        var _index = move_down ? _size - 1 : 0;
        var _delta = move_down ? -1 : 1;
        
        var _closer_index     = _index;
        var _last_closer_diff = 9999;
        var _current;
        for ( ; _index < _size && _index >= 0; _index = _index + _delta ) {
            _current = list[ _index ];
            if ( !DOM.Service.isVisible( _current ) ) {
                continue;
            }
            if ( !DOM.Service.isFullyVisibleInParent( _current, dom_element_container ) ) {
                continue;
            }
            var _median = DOM.Service.getBoundingClientRect( _current, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
            if ( Math.abs( _median - position ) < _last_closer_diff ) {
                _last_closer_diff = Math.abs( _median - position );
                _closer_index     = _index;
                continue;
            }
            else {
                break;
            }
        }
        return list[ _closer_index ];
    };
    self.isVisible                     = function ( dom_element_container, dom_element_to_test, marge, action_type ) {
        if ( !dom_element_to_test ) {
            return false;
        }
        marge               = marge || 0;
        var _rect_to_test   = dom_element_to_test.getBoundingClientRect();
        var _rect_container = dom_element_container.getBoundingClientRect();
        
        if ( action_type ) {
            if ( _rect_to_test.bottom - _rect_container.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
            }
            if ( _rect_container.bottom - _rect_to_test.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_TOP;
            }
            return true;
        }
        else {
            return _rect_to_test.bottom - _rect_container.top >= marge && _rect_container.bottom - _rect_to_test.top >= marge;
        }
    };
    self.bindWith                      = function ( dom_element, dom_element_to_bind_with, previous_position_vertical, action_type ) {
        switch ( action_type ) {
            case DOM.CONST.ATTRIBUTE.SCROLL_TOP:
            case DOM.CONST.ATTRIBUTE.SCROLL_DOWN:
                if ( self.isVisible( dom_element, dom_element_to_bind_with, 3 * DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT ), action_type ) ) {
                    return;
                }
                else {
                    var _delta = DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT );
                    if ( previous_position_vertical ) {
                        _delta = previous_position_vertical - DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                    }
                    self.changeVerticaly( dom_element, _delta, action_type );
                }
                break;
        }
    };
    self.changeVerticaly               = function ( dom_element, delta, action_type ) {
        dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] = Math.ceil( dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] - delta );
    };
    
    return self;
})( DOM.ScrollService || {} );
DOM.Service = (function ( self ) {
    "use strict";
    
    var __previous_scrollLeft = 0;
    
    self.hasKeyInDataSet                   = function ( element, key ) {
        return typeof element.dataset[ key ] !== "undefined";
    };
    self.findParentElementWithDataSet      = function ( element, key, deepLimit ) {
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( self.hasKeyInDataSet( element, key ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithDataSet( element.parentElement, key, deepLimit );
    };
    self.findParentElementWithClass        = function ( element, class_tag, deepLimit ) {
        if ( deepLimit < 0 || !element ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    };
    self.createElement                     = function ( tag, attributes, innerHTML ) {
        var toReturn = document.createElement( tag );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                toReturn.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        if ( innerHTML ) {
            toReturn.innerHTML = innerHTML;
        }
        return toReturn;
    };
    self.cloneElement                      = function ( dom_element_to_clone, attributes ) {
        var _to_return = dom_element_to_clone.cloneNode( true );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                _to_return.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        return _to_return;
    };
    self.addTooltip                        = function ( element, attributes ) {
        if ( !attributes ) {
            return;
        }
        element.setAttribute( 'onmouseenter', "SHINKEN_TOOLTIP.showTooltip(this)" );
        element.setAttribute( 'onmouseleave', "SHINKEN_TOOLTIP.hideTooltip()" );
        var _keys = Object.keys( attributes );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            element.setAttribute( _keys[ i ], attributes[ _keys[ i ] ] );
        }
        return element;
    };
    self.bindElementOnScroll               = function ( elementScrolled, elementToBind, name_property, callback ) {
        elementScrolled.addEventListener( DOM_CONSTANT.SCROLL.EVENT, function () {
            var scrollPos         = elementScrolled.getData( name_property );
            var _do_callback      = scrollPos !== __previous_scrollLeft;
            __previous_scrollLeft = scrollPos;
            elementToBind.setData( name_property, scrollPos );
            if ( _do_callback && callback ) {
                callback();
            }
        } );
    };
    self.removeElement                     = function ( element ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        
        try {
            var _to_return = parent.removeChild( element );
            return _to_return;
        }
        catch ( e ) {
            return false;
        }
    };
    self.removeParentIfHasClassOrElement   = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        if ( !parent ) {
            return;
        }
        
        if ( parent.classList.contains( class_to_test ) ) {
            var _grand_parent = parent.parentNode;
            if ( !_grand_parent ) {
                return;
            }
            _grand_parent.removeChild( parent );
        }
        
        return parent.removeChild( element );
    };
    self.setDataSet                        = function ( element, attr, value ) {
        if ( !element ) {
            return;
        }
        element.dataset[ attr ] = value;
        element.classList.toggle( "IE-PATCH" );
    };
    self.getInnerText                      = function ( element ) {
        if ( !element ) {
            return;
        }
        return element.innerText.trim();
    };
    self.askAddClass                       = function ( element, to_add, time_out ) {
        element.classList.add( to_add );
        if ( time_out ) {
            setTimeout( function () {
                element.classList.remove( to_add );
            }, time_out );
        }
    };
    self.removeElementIfHasClass           = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        if ( !element.classList.contains( class_to_test ) ) {
            return false;
        }
        var parent = element.parentNode;
        return parent.removeChild( element );
    };
    self.addElementTo                      = function ( element, parent ) {
        if ( parent && element ) {
            parent.appendChild( element );
        }
    };
    self.addElementAfterTo                 = function ( element, target ) {
        var _next = target.nextSibling.nextSibling;
        if ( _next ) {
            target.parentNode.insertBefore( element, _next );
        }
        else {
            self.addElementTo( element, target.parentNode );
        }
    };
    self.switchElement                     = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        parent_1.removeChild( element_1 );
        parent_2.removeChild( element_2 );
        
        parent_1.appendChild( element_2 );
        parent_2.appendChild( element_1 );
    };
    self.insertElementBefore               = function ( element_existing, element_to_insert ) {
        if ( !element_existing || !element_to_insert ) {
            return;
        }
        var _parent = element_existing.parentNode;
        _parent.insertBefore( element_to_insert, element_existing );
    };
    self.getValueDataSet                   = function ( dom_element, key ) {
        return dom_element.dataset[ key ];
    };
    self.setStyle                          = function ( dom_element, key, value ) {
        if ( !dom_element || !key ) {
            return;
        }
        
        switch ( key ) {
            case DOM.CONST.STYLE.LEFT:
            case DOM.CONST.STYLE.TOP:
            case DOM.CONST.STYLE.HEIGHT:
            case DOM.CONST.STYLE.WIDTH:
            case DOM.CONST.STYLE.MAX_HEIGHT:
            case DOM.CONST.STYLE.MAX_WIDTH:
                if ( !isNaN( value ) ) {
                    value = value + 'px';
                }
                dom_element.style[ key ] = value;
                break;
            default:
                dom_element.style[ key ] = value;
        }
    };
    self.setStyles                         = function ( dom_element, styles ) {
        var keys = Object.keys( styles );
        for ( var i = 0, size = keys.length; i < size; i++ ) {
            self.setStyle( dom_element, keys[ i ], styles[ keys[ i ] ] );
        }
    };
    self.addClasses                        = function ( dom_element, class_to_add ) {
        if ( typeof class_to_add === 'string' ) {
            class_to_add = class_to_add.split( ' ' );
        }
        for ( var i = 0, _size_i = class_to_add.length; i < _size_i; i++ ) {
            dom_element.classList.add( class_to_add[ i ] );
        }
    };
    self.removeClasses                     = function ( dom_element, class_to_remove ) {
        if ( typeof class_to_remove === 'string' ) {
            class_to_remove = class_to_remove.split( ' ' );
        }
        for ( var i = 0, _size_i = class_to_remove.length; i < _size_i; i++ ) {
            dom_element.classList.remove( class_to_remove[ i ] );
        }
    };
    self.getBoundingClientRect             = function ( dom_element, key ) {
        if ( !dom_element ) {
            return;
        }
        var _rect = dom_element.getBoundingClientRect();
        if ( !key ) {
            return _rect;
        }
        if ( key === DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM ) {
            return parseInt( (_rect[ DOM.CONST.STYLE.TOP ] + _rect[ DOM.CONST.STYLE.BOTTOM ]) / 2 );
        }
        return parseInt( _rect[ key ] );
    };
    self.hasScrollHeight                   = function ( dom_element ) {
        var _height = self.getBoundingClientRect( dom_element, 'height' );
        return _height < dom_element.scrollHeight;
    };
    self.setHtmlOrHide                     = function ( dom_element, to_set ) {
        if ( !dom_element ) {
            return;
        }
        if ( to_set ) {
            dom_element.innerHTML = to_set;
            dom_element.classList.remove( 'shinken-hidden' );
        }
        else {
            dom_element.classList.add( 'shinken-hidden' );
        }
    };
    self.replaceChild                      = function ( element_to_replace, element_replace_with ) {
        var _parent_node = element_to_replace.parentNode;
        _parent_node.replaceChild( element_replace_with, element_to_replace );
    };
    self.empty                             = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        while ( dom_element.firstChild ) {
            dom_element.removeChild( dom_element.firstChild );
        }
    };
    self.removeAttribute                   = function ( dom_element, attribute_name ) {
        dom_element.removeAttribute( attribute_name );
    };
    self.getComputedStyle                  = function ( dom_element, key ) {
        if ( !dom_element ) {
            return {};
        }
        var _to_return = dom_element.currentStyle || getComputedStyle( dom_element );
        if ( key ) {
            _to_return = _to_return[ key ];
            if ( SHINKEN.TOOLS.STRING.endsWith( _to_return, 'px' ) ) {
                _to_return = parseInt( _to_return );
            }
        }
        return _to_return;
    };
    self.getHeight                  = function ( dom_element ) {
        if ( !dom_element ) {
            return 0;
        }
        return dom_element.offsetHeight;
    };
    self.isVisible                         = function ( elem, deepness ) {
        if ( !elem ) {
            return false;
        }
        if ( !deepness ) {
            deepness = 0;
        }
        if ( !(elem instanceof Element) ) {
            throw Error( 'DomUtil: elem is not an element.' );
        }
        var styles = self.getComputedStyle( elem );
        if ( styles.display === 'none' ) {
            return false;
        }
        if ( styles.visibility !== 'visible' && styles.visibility !== 'inherit' ) {
            return false;
        }
        if ( styles.opacity < 0.1 ) {
            return false;
        }
        if ( elem.parentElement && deepness > 0 ) {
            return self.isVisible( elem.parentElement, deepness-- );
        }
        return true;
    };
    self.isFullyVisibleInParent            = function ( dom_element, dom_parent ) {
        var _parent_rect = self.getBoundingClientRect(dom_parent);
        var _element_rect = self.getBoundingClientRect(dom_element);
        if ( _element_rect[DOM.CONST.STYLE.TOP] < _parent_rect[DOM.CONST.STYLE.TOP] ){
            return false;
        }
        if ( _element_rect[DOM.CONST.STYLE.BOTTOM] > _parent_rect[DOM.CONST.STYLE.BOTTOM] ){
            return false;
        }
        return true;
    };
    self.setInputValue                     = function ( dom_element, to_set ) {
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            dom_element.setAttribute( 'value', to_set );
            dom_element.classList.toggle( "IE-PATCH" );
            self.replaceChild( dom_element, dom_element );
            dom_element.value = to_set;
            return;
        }
        dom_element.value = to_set;
    };
    self.hasFocus                          = function ( dom_element ) {
        return dom_element === document.activeElement;
    };
    self.generateDomElementFromString      = function ( string ) {
        var _to_return = self.createElement( "div", "", string );
        return _to_return.children;
    };
    self.hasHrefHost                       = function ( url ) {
        var _dom_url = self.createElement( "a", { href: url } );
        return !!_dom_url.host;
    };
    self.isMatchingMedianDomElementTopWith = function ( list, y ) {
        var _median_index = SHINKEN.TOOLS.ARRAY.getMedianIndex( list, true );
        if ( _median_index === SHINKEN.TOOLS.ARRAY.NOT_FOUND ) {
            return DOM.CONST.VALUE.NONE;
        }
        var _median  = list[ _median_index ];
        var _compare = self.compareCoordinates( _median, null, y );
        if ( _compare === 0 ) {
            return _median;
        }
        return _compare;
    };
    self.compareCoordinates                = function ( dom_element, x, y ) {
        var _rect = self.getBoundingClientRect( dom_element );
        if ( x ) {
            if ( _rect.left < x ) {
                return -1;
            }
            if ( _rect.left + _rect.width > x ) {
                return 1;
            }
        }
        if ( y ) {
            if ( _rect.top > y ) {
                return -1;
            }
            if ( _rect.top + _rect.height < y ) {
                return 1;
            }
        }
        return 0;
    };
    self.show                              = function( dom_element ) {
        dom_element.classList.remove( "shinken-hidden" );
    };
    self.hide                              = function( dom_element ) {
        dom_element.classList.add( "shinken-hidden" );
    };
    self.setEditable                       = function( edit_content, dom_container, dom_to_edit ) {
        dom_to_edit.contentEditable = edit_content;
        if ( edit_content === true ) {
            self.focusAtTheEnd( dom_to_edit );
        }
        self.setDataSet( dom_container, 'statusEdit', edit_content ? "1" : "0" );
    };
    self.focusAtTheEnd                     = function( dom_element ) {
        dom_element.focus();
        var range = document.createRange();
        range.selectNodeContents( dom_element );
        range.collapse( false );
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange( range );
    };
    
    return self;
})( DOM.Service || {} );
DOM.CONST = {
    STYLE    : {
        LEFT      : 'left',
        RIGHT     : 'right',
        TOP       : 'top',
        BOTTOM    : 'bottom',
        HEIGHT    : 'height',
        MAX_HEIGHT: 'max-height',
        MAX_WIDTH : 'max-width',
        WIDTH     : 'width',
        Z_INDEX   : 'z-index',
        DISPLAY   : 'display'
    },
    ATTRIBUTE: {
        SCROLL_DOWN: 'scrollDown',
        SCROLL_TOP : 'scrollTop',
        SCROLL_LEFT: 'scrollLeft'
    },
    VALUE    : {
        NONE: 'none'
    },
    SPECIAL  : {
        MEDIAN_TOP_BOTTOM: 'MEDIAN_TOP_BOTTOM'
    },
    WAITING_TIME_BEFORE_EXEC :{
        INPUT: 200
    }
};
function __gup ( name, url ) {
    if ( !url ) {
        url = location.href;
    }
    name        = name.replace ( /[\[]/, "\\\[" ).replace ( /[\]]/, "\\\]" );
    var regexS  = "[\\?&]" + name + "=([^&#]*)";
    var regex   = new RegExp ( regexS );
    var results = regex.exec ( url );
    return results == null ? null : results[ 1 ];
}
function _find_lang_obj () {
    var lang = __gup ( 'lang' );
    if ( lang == null ) {
        lang = global_lang;
    }
    if ( lang == 'en' ) {
        return lang_en;
    }
    if ( lang == 'fr' ) {
        return lang_fr;
    }
    return lang_en;
    
}
/* find the traduction of a call in the lang objects, if cannot find in the lang, fail back to the en one */
function _ ( s ) {
    var lang_obj = _find_lang_obj ();
    var elts = s.split ( '.' );
    var p    = lang_obj;
    for ( var i = 0; i < elts.length; i++ ) {
        var key = elts[ i ];
        p       = p[ key ];
        if ( typeof p == 'undefined' ) {
            return 'TO_TRAD(' + s + ')';
        }
    }
    return p;
}
SHINKEN.HIGHWAY = (function( self ) {
    "use strict";
    self.goToParentUrl                  = function() {
        var _floors        = location.pathname.split( '/' );
        var _new_path_name = "";
        var _size          = _floors.length;
        for ( var i = 1; i < _size - 1; i++ ) {
            _new_path_name += "/";
            _new_path_name += _floors[ i ];
        }
        switch ( _new_path_name ) {
            case "":
            case "/elements/my_working_area":
            case "/elements/working_area":
            case "/elements":
            case "/analyzers":
            case "/tagger":
            case "/elements/add":
                _new_path_name = "/main";
                break;
            case "/sources":
                _new_path_name = "/main";
                var _params    = this.getParams();
                if ( _params[ 'conf-id' ] || _params[ 'synchronizer-id' ] ) {
                    delete _params[ 'conf-id' ];
                    delete _params[ 'synchronizer-id' ];
                    delete _params[ 'source-name' ];
                    _new_path_name = this.getPathWithoutOrigin() + window.SHINKEN.HIGHWAY.buildParamsToUrl( _params );
                }
                break;
            case "/elements/add/working_area":
                _new_path_name = "/elements/working_area/hosts";
                break;
            case "/sources/server-analyzer/discovery":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
            case "/sources/server-analyzer/discovery/add":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery/add":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
        }
        switch ( location.pathname ) {
            case "/elements/add/cluster":
            case "/elements/add/clustertpl":
            case "/elements/add/hosttpl":
            case "/elements/add/hostgroup":
            case "/elements/add/serviceshost":
            case "/elements/add/serviceshosttpl":
            case "/elements/add/servicescluster":
            case "/elements/add/servicesclustertpl":
            case "/elements/add/servicetpl":
            case "/elements/add/contact":
            case "/elements/add/contacttpl":
            case "/elements/add/contactgroup":
            case "/elements/add/escalation":
            case "/elements/add/notificationway":
            case "/elements/add/command":
            case "/elements/add/businessimpactmodulation":
            case "/elements/add/macromodulation":
            case "/elements/add/resultmodulation":
            case "/elements/add/timeperiod":
                _new_path_name = "/elements/" + _floors[ _size - 1 ] + 's';
                break;
        }
        window.location = location.origin + _new_path_name;
    };
    self.goToElementTab                 = function( tab_name ) {
        var _path     = self.getPath();
        var _params   = self.getParams();
        var _old_name = _params[ 'tab' ];
        if ( _old_name === tab_name ) {
            return;
        }
        _params[ 'tab' ]       = tab_name;
        var _new_params_string = self.buildParamsToUrl( _params );
        self.changeUrl( _path + _new_params_string );
    };
    self.changeUrl                      = function( new_url ) {
        window.history.pushState( "object or string", "Title", new_url );
    };
    self.getPath                        = function() {
        return location.origin + this.getPathWithoutOrigin();
    };
    self.getPathWithoutOrigin           = function() {
        return location.pathname;
    };
    self.getPathWithParamsWithoutOrigin = function() {
        return location.pathname + self.buildParamsToUrl( self.getParams() );
    };
    self.buildParamsToUrl               = function( params ) {
        var _keys = Object.keys( params );
        var _size = _keys.length;
        if ( !_size ) {
            return '';
        }
        var _to_return = COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
        for ( var i = 0; i < _size; i++ ) {
            if ( i ) {
                _to_return += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD;
            }
            _to_return += _keys[ i ] + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + params[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.getParams                      = function( param ) {
        var vars = {};
        window.location.href.replace( location.hash, '' ).replace(
            /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
            function( m, key, value ) { // callback
                vars[ key ] = value !== undefined ? value : '';
            }
        );
        
        if ( param ) {
            return vars[ param ] ? vars[ param ] : null;
        }
        return vars;
    };
    self.is                             = function( type ) {
        switch ( type ) {
            case COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT: //PATCH BUG 4022 TO REMOVE
                return location.pathname === "/elements/elements";
            case COMMUNICATION.PAGE_TYPE.LIST_WORKING_AREA:
                return location.pathname === "/elements/working_area/hosts" || location.pathname === "/elements/my_working_area/hosts";
        }
    };
    self.getListType     = function () {
        var _to_return = self.getPath().split("/");
        return _to_return[_to_return.length - 1];
    };
    self.goTo                           = function( url, event ) {
        if ( event ) {
            event.stopPropagation();
            event.preventDefault();
        }
        if ( event && event.ctrlKey ) {
            window.open( url, '_blank' );
        }
        else {
            window.location = url;
        }
    };
    self.refreshCurrentPage             = function() {
        location.reload();
    };
    self.removeItemIdFromHistory    = function ( item_id ) {
        var histories = App.HistoryManager.histories();
        for ( var i = histories.length - 1; i >= 0; i-- ) {
            var _previousUrl = histories[ i ];
            if ( SHINKEN.TOOLS.STRING.contains( _previousUrl, item_id ) ) {
                histories.splice( i, 1 );
            }
        }
        App.HistoryManager.setHandlers();
    };
    return self;
})( SHINKEN.HIGHWAY || {} );
COMPONENT.Button           = function ( dom_element, name ) {
    this.state = COMPONENT.CONST.BTN_STATE.OFF;
    this.name  = name;
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init             : function ( dom_element ) {
        this.dom_element = dom_element;
        this.value       = this.dom_element.value;
        this._computeState();
    },
    setState         : function ( to_set ) {
        this.state = to_set;
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.dom_element.classList.remove( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE );
                this.dom_element.classList.remove( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_DISABLED );
                break;
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_DISABLED );
                break;
        }
    },
    getValue         : function () {
        return this.value;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    _computeState    : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    appendToHtml     : function ( _dom_value_to_append ) {
        this.dom_element.appendChild( _dom_value_to_append );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Button, SHINKEN.OBJECT.CounterInterface );
COMPONENT.Checkbox           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.Checkbox.prototype = {
    init      : function ( dom_element ) {
        this.dom_element        = dom_element;
        this.checkbox_user      = new OBJECT.ElementCheckbox(dom_element.querySelector(".shinken-checkbox-user"));
        this.checkbox_inherited = new OBJECT.ElementCheckbox(dom_element.querySelector(".shinken-checkbox-inherited"));
        this.checkbox_default = new OBJECT.ElementCheckbox(dom_element.querySelector(".shinken-checkbox-default"));
    },
    setCheckedUser      : function ( to_set) {
        this.checkbox_user.setChecked(to_set);
    },
    setCheckedInheritance      : function (to_set) {
        this.checkbox_inherited.setChecked(to_set);
    },
    isCheckedUser      : function () {
        return this.checkbox_user.isChecked();
    },
    isCheckedInheritance      : function () {
        return this.checkbox_inherited.isChecked();
    },
    isCheckedDefault      : function () {
        return this.checkbox_default.isChecked();
    }
};
COMPONENT.InputRange           = function ( dom_element, property ) {
    this.init( dom_element, property );
};
COMPONENT.InputRange.prototype = {
    init                 : function ( dom_element, property ) {
        this.type_range      = dom_element.dataset.type;
        this.dom_input_range = dom_element.querySelector( ".shinken-range-container input" );
        switch ( property.type ) {
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                this.component_input = new COMPONENT.Input( dom_element.querySelector( ".shinken-input" ), property );
                if ( property.is_mass_change ) {
                    this.component_input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                }
                this.value = this.dom_input_range.dataset.lastValueFromUser;
                break;
            
            default:
                this.component_label_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-label-input-range" ) );
                this.value                 = parseInt( this.dom_input_range.dataset.lastValueFromUser ) + "";
                break;
        }
        this.value_from_user = property.is_mass_change ? '' : this.value;
        this.min             = this.dom_input_range.getAttribute( 'min' );
        this.max             = this.dom_input_range.getAttribute( 'max' );
        this.unit            = dom_element.dataset.unit;
        this.property_name   = property.getName();
        this.is_mass_change  = property.is_mass_change;
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( dom_element, parent || this );
    },
    setValue             : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = false;
        }
        this.value                 = to_set;
        this.dom_input_range.value = to_set;
        if ( this.component_input ) {
            if ( updateInputField && this.component_input.getValue() !== to_set ) {
                this.updateInput();
            }
            else if ( !updateInputField ) {
                this.emptyInput();
            }
        }
        else {
            this.updateLabel();
        }
    },
    setValueFromUser     : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = true;
        }
        if ( to_set === null || to_set === undefined ) {
            to_set = this.dom_input_range.value;
            if ( this.component_input && to_set !== "0" && to_set !== "100" ) {
                to_set += ".000";
            }
        }
        to_set               = to_set + '';
        this.value_from_user = to_set;
        this.setValue( to_set, updateInputField );
    },
    updateInput          : function () {
        this.component_input.dom_element.value = this.value;
        this.component_input.setValue();
        this.component_input.validateValueInput();
    },
    emptyInput           : function () {
        this.component_input.dom_element.value = '';
        this.component_input.setValue();
        this.component_input.resetCounters();
        this.component_input.setStatus( COMPONENT.CONST.STATUS.NONE );
        this.component_input.validateValueInput();
    },
    updateLabel          : function () {
        var _to_set;
        if ( this.is_mass_change && this.value === '' ) {
            _to_set = _( "mass-change.label.enter_a_value" );
        }
        else {
            switch ( this.type_range ) {
                case PROPERTY.CONST.TYPES.RANGE:
                    _to_set = this.value + this.unit;
                    break;
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                    _to_set = _( "element.business_impact_" + this.value );
                    break;
            }
        }
        this.component_label_input.updateLabel( _to_set );
    },
    getValue             : function () {
        return this.value;
    },
    getValueFromUser     : function () {
        return this.value_from_user;
    },
    getComponents        : function () {
        var _to_return = [];
        if ( this.component_input ) {
            _to_return.push( this.component_input );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputRange, SHINKEN.OBJECT.CounterInterface );
COMPONENT.InputWithDropDown           = function ( dom_element, parent, use_quotes, type ) {
    this.init( dom_element, parent, use_quotes, type );
};
COMPONENT.InputWithDropDown.prototype = {
    init                       : function ( dom_element, parent, use_quotes, type ) {
        this.parent = parent;
        this.initCounters( parent );
        this.type            = type;
        this.dom_element     = dom_element;
        this.uuid            = SHINKEN.TOOLS.STRING.buildUUID();
        this.input           = new COMPONENT.Input( this.dom_element.querySelector( '.shinken-input' ), parent || this, true );
        this.select          = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, false, true );
        this.separators      = this.dom_element.dataset.separator.split( "$^$" );
        this.separator_regex = new RegExp( "[" + this.separators.join( "" ) + "]" );
        if ( use_quotes == undefined ) {
            use_quotes = false;
        }
        this.use_quotes = !!use_quotes;
    },
    keydown                    : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.select.moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.select.moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.select.validSelectedOrFirstElement();
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, key_code ) ) {
                    event.preventDefault();
                    event.stopPropagation();
                }
        }
    },
    askComputeAfterChange      : function ( dom_element, parent ) {
        this.input.askComputeAfterChange( dom_element, parent || this );
    },
    clickOnItemSelector        : function ( parent_name, key_name, event ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _previous_value     = this.input.getValue();
        var first_part          = _previous_value.substring( 0, this.first_separator );
        var second_part         = _previous_value.substring( this.last_separator, _previous_value.length );
        var _is_specific_option = false;
        if ( event ) {
            var _parent_dom = DOM.Service.findParentElementWithDataSet( event.target, 'type', 10 );
            if ( _parent_dom && _parent_dom.dataset.type === 'is-always-visible' ) {
                _is_specific_option = true;
            }
        }
        if ( _is_specific_option ) {
            this.input.setValueFromJs( key_name );
        }
        else {
            this.input.setValueFromJs( first_part + key_name + second_part );
        }
        this.setCurrentFilter( true );
    },
    clickOnInput               : function () {
        this.setCurrentFilter();
    },
    setIsProtected             : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? "password" : this.type );
    },
    setPlaceholder             : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        this.placeholder = to_set;
        this.input.setPlaceholder( to_set );
    },
    setValidationRules         : function ( _to_set ) {
        this.input.setValidationRules( _to_set );
    },
    hasBeenChanged             : function () {
        return this.current_value !== this.original_value;
    },
    getParentName              : function () {
        return this.parent.getParentName();
    },
    getComponents              : function () {
        return [ this.input ];
    },
    getValue                   : function () {
        return this.input.getValue();
    },
    setValueFromJs             : function ( to_set ) {
        this.input.setValueFromJs( to_set );
    },
    getFinalValue              : function () {
        if ( this.timeout_ask_compute_after_change ) {
            clearTimeout( this.timeout_ask_compute_after_change );
            this.computeAfterChange();
        }
        return this.getValue();
    },
    setCurrentFilter           : function ( focus_on_last_separator, bypass_do_filter, validation_done ) {
        if ( this.select.list_element.list.length > 0 ) {
            this.select.openSelector();
        }
        var _value           = this.input.getValue();
        var _previous_filter = this.current_filter ? this.current_filter : "";
        var _cursor_position = this.input.dom_element.selectionStart;
        this.first_separator = 0;
        this.last_separator  = _value.length;
        
        var _in_quotes = false;
        for ( var i = 0; i < _cursor_position; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.first_separator = i + 1;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        for ( i = _cursor_position; i < _value.length; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.last_separator = i;
                break;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        
        if ( (this.first_separator) >= this.last_separator ) {
            this.current_filter = "";
        }
        else {
            this.current_filter = _value.substring( this.first_separator, this.last_separator ).trim();
        }
        if ( focus_on_last_separator ) {
            this.input.restoreCursorLocation( this.last_separator );
        }
        
        if ( SHINKEN.TOOLS.STRING.startsWith( this.current_filter, "=" ) ) {
            this.current_filter = this.current_filter.substring( 1 );
        }
        if ( this.use_quotes ) {
            this.current_filter = this.current_filter.replace( /"/g, '' );
        }
        this.select.setResearchDisplay( this.current_filter );
        if ( !bypass_do_filter || this.current_filter !== _previous_filter ) {
            this.select.doFilter( this.current_filter );
        }
        if ( !validation_done ) {
            this.validateValueInput();
        }
    },
    hasAutoSelect              : function () {
        return this.select.hasAutoSelect();
    },
    getDataSetLink             : function () {
        return this.select.getDataSetLink();
    },
    getListElement             : function () {
        return this.select.getListElement();
    },
    getStatus                  : function () {
        return this.input.getStatus();
    },
    addValidationRule          : function ( to_add, type ) {
        this.input.addValidationRule( to_add, type );
    },
    computeAfterChange         : function ( validation_done ) {
        this.setCurrentFilter( false, !this.input.need_validation, validation_done );
    },
    hidePopup                  : function () {
        this.select.hidePopup();
    },
    validSelectedOrFirstElement: function () {
        this.select.validSelectedOrFirstElement();
    },
    validateValueInput         : function () {
        this.input.validateValueInput();
    },
    finishActionBeforeReload   : function () {
        this.input.finishActionBeforeReload();
    },
    doActionAfterChange        : function () {
        this.computeAfterChange();
    },
    isReallyInQuotes           : function ( in_quotes ) {
        return this.use_quotes ? in_quotes : false;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputWithDropDown, SHINKEN.OBJECT.CounterInterface );
COMPONENT.Input           = function ( dom_element, parent, no_auto_valid, extra_key_validation ) {
    this.init( dom_element, parent, extra_key_validation );
};
COMPONENT.Input.prototype = {
    init                    : function ( dom_element, parent, extra_key_validation ) {
        this.initCounters( parent );
        this.dom_element             = dom_element;
        this.uuid                    = SHINKEN.TOOLS.STRING.buildUUID();
        this.current_value           = this.dom_element.getAttribute( 'value' );
        this.type                    = this.dom_element.getAttribute( 'type' );
        this.original_value          = this.current_value;
        this.placeholder_no_template = this.dom_element.placeholder;
        this.placeholder             = this.dom_element.placeholder;
        this.is_resizable            = this.dom_element.tagName === 'TEXTAREA';
        this.need_validation         = true;
        this.key_validation          = {
            "prop_name"     : parent? parent.getParentName() : '',
            "component_name": extra_key_validation || ''
        };
    },
    getDomValue             : function () {
        return this.dom_element.value;
    },
    setValueFromJs          : function ( to_set ) {
        this.current_value = to_set;
        this.computeNeedValidation();
        if ( this.need_validation ) {
            this.updateView( false, true, true );
        }
    },
    setValue                : function ( keep_cursor_pos ) {
        this.computeNeedValidation();
        this.current_value = this.getDomValue();
        this.askComputeHeight();
    },
    setStatus               : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    getStatus               : function () {
        return this.status;
    },
    setIsProtected          : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ? "password" : "shinken-password" : this.type );
    },
    setPlaceholder          : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        to_set = SHINKEN.TOOLS.STRING.unescape_xss(to_set);
        this.placeholder             = to_set;
        this.dom_element.placeholder = this.placeholder;
    },
    getValue                : function () {
        return this.current_value;
    },
    hasBeenChanged          : function () {
        return this.current_value !== this.original_value;
    },
    setTooltip              : function ( to_set ) {
        this.dom_element.setAttribute( 'shi-tip-html', to_set );
    },
    setExtraTooltip         : function ( to_set ) {
        this.extra_tooltip = to_set;
    },
    addShinkenTooltip       : function ( type, message ) {
        if ( this.extra_tooltip && this.hasBeenChanged() ) {
            if ( message ) {
                message += "<br>";
            }
            
            message += this.extra_tooltip;
            if ( type === "shinken-success-border" ) {
                type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
            }
            SHINKEN_TOOLTIP.showTooltip( this.dom_element );
        }
        this.dom_element.setAttribute( 'onmouseenter', "SHINKEN_TOOLTIP.showTooltip(this)" );
        this.dom_element.setAttribute( 'onmouseleave', "SHINKEN_TOOLTIP.hideTooltip()" );
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', message );
        
        message ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
        
    },
    setMessage              : function ( message ) {
        var _status  = COMPONENT.CONST.STATUS.NONE;
        this.message = message;
        if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [ 0, 0 ];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", message ? message.buildMessage() : "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    restoreCursorLocation   : function ( location ) {
        this.dom_element.focus();
        if ( location ) {
            this.last_cursor_location = location;
        }
        if ( !this.last_cursor_location ) {
            this.last_cursor_location = this.current_value.length;
        }
        this.dom_element.selectionStart = this.last_cursor_location;
        this.dom_element.selectionEnd   = this.last_cursor_location;
    },
    saveCursorLocation      : function () {
        this.last_cursor_location = this.getCursorLocation();
    },
    getCursorLocation       : function () {
        return this.dom_element.selectionStart;
    },
    updateView              : function ( is_inherited, update, keep_cursor_pos, has_inheritance ) {
        if ( has_inheritance !== undefined ) {
            this.has_inheritance = !!has_inheritance;
        }
        var _to_write = this.current_value;
        if ( this.current_value === 'null' && this.has_inheritance ) {
            _to_write = '';
        }
        
        if ( is_inherited ) {
            this.setStatus( COMPONENT.CONST.STATUS.NONE );
            this.resetCounters();
        }
        else {
            this.validateValueInput();
        }
        if ( keep_cursor_pos ) {
            this.saveCursorLocation();
        }
        
        if ( update ) {
            this.computeNeedValidation();
            DOM.Service.setInputValue( this.dom_element, is_inherited ? '' : _to_write );
        }
        else {
            this.current_value = this.getDomValue();
        }
        if ( this.dom_element.value ) {
            this.dom_element.classList.remove( 'shinken-empty-input' );
        }
        else {
            this.dom_element.classList.add( 'shinken-empty-input' );
        }
        this.askComputeHeight();
        if ( keep_cursor_pos ) {
            this.restoreCursorLocation();
        }
    },
    askComputeHeight : function () {
        var self = this;
        if ( self.timeout_ask_compute_height ) {
            clearTimeout( self.timeout_ask_compute_height );
        }
        self.timeout_ask_compute_height = setTimeout( function () {
            if ( self.is_resizable && DOM.Service.hasScrollHeight( self.dom_element ) && DOM.Service.getBoundingClientRect( self.dom_element, 'height' ) < 150 ) {
                self.dom_element.style.height = Math.min( 150, self.dom_element.scrollHeight + 6 ) + 'px';
            }
        }, 200 );
    },
    askComputeAfterChange   : function ( dom_element, parent, arg ) {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.computeAfterChange( dom_element, parent, arg );
        }, 200 );
    },
    finishActionBeforeReload: function () {
        if ( this.timeout_ask_compute_after_change ) {
            this.computeAfterChange();
        }
    },
    computeAfterChange      : function ( dom_element, parent, args ) {
        this.setValue();
        if (!args ){
            args = {};
        }
        args['validation_done'] = this.validateValueInput();
        args['input_object'] = this;
        if ( parent ) {
            parent.doActionAfterChange( args );
        }
    },
    validateValueInput      : function ( forced, ignore_focus ) {
        if ( !SHINKEN.TOOLS.SHINKEN_VALIDATOR ) {
            return false;
        }
        if ( this.need_validation || forced ) {
            var _validation_rules = this.getValidationRules( ignore_focus );
            var _validator;
            if ( _validation_rules ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( _validation_rules, SHINKEN.TOOLS.STRING.trimExtented( this.getValue() ) );
            }
            else {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( this.key_validation, this.getValue() );
            }
            this.setMessage( _validator );
            this.need_validation = false;
            return true;
        }
        return false;
    },
    addValidationRule       : function ( to_add, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                if ( !this.validation_rules ) {
                    this.validation_rules = [];
                }
                this.validation_rules.push( to_add );
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                if ( !this.validation_rules_not_focus ) {
                    this.validation_rules_not_focus = [];
                }
                this.validation_rules_not_focus.push( to_add );
                break;
        }
        
    },
    setValidationRules      : function ( to_set, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                this.validation_rules = to_set;
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                this.validation_rules_not_focus = to_set;
                break;
        }
    },
    computeNeedValidation   : function () {
        if ( this.need_validation ) {
            return;
        }
        if ( this.current_value !== this.getDomValue() ) {
            this.need_validation = true;
        }
    },
    getValidationRules      : function ( ignore_focus ) {
        if ( !this.validation_rules && !this.validation_rules_not_focus ) {
            return null;
        }
        if ( ignore_focus ) {
            return this.validation_rules_not_focus || this.validation_rules;
        }
        if ( !this.hasFocus() && this.validation_rules_not_focus ) {
            return this.validation_rules_not_focus;
        }
        return this.validation_rules;
    },
    hasFocus                : function () {
        return DOM.Service.hasFocus( this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Input, SHINKEN.OBJECT.CounterInterface );
COMPONENT.Label           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.Label.prototype = {
    init       : function ( dom_element ) {
        this.dom_element = dom_element;
        this.label       = dom_element.outerText;
    },
    updateLabel: function ( to_set ) {
        this.label                 = to_set;
        this.dom_element.innerHTML = this.label;
    }
};
COMPONENT.ListSelectElement           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.ListSelectElement.prototype = {
    init               : function ( dom_element ) {
        this.is_filtered   = false;
        this.reason_to_set = [];
        if ( dom_element ) {
            this.dom_element = dom_element;
            this.dom_title   = dom_element.querySelector( '.' + 'shinken-option-title' );
            this.initElement();
            this.is_selected = dom_element.classList.contains( 'shinken-selected' );
        }
    },
    initElement        : function () {
        this.element = new OBJECT.ElementList();
        this.element.setName( this.dom_element.dataset.keyName, this.dom_element );
        this.element.setLabel( this.dom_element.dataset.keyLabel );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setUUID( this.dom_element.dataset.uuid );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsHiddenForAdminSi( this.dom_element.dataset.isHiddenForAdminSi );
    },
    getElement         : function () {
        return this.element;
    },
    getDomElement      : function () {
        return this.dom_element;
    },
    getName            : function () {
        return this.element.getName();
    },
    getLabel           : function () {
        return this.element.getLabel();
    },
    getState           : function () {
        return this.element.getState();
    },
    getTextContent     : function () {
        return this.dom_title.textContent;
    },
    getTextContentShort: function () {
        return this.dom_title.dataset.label;
    },
    setSelected        : function ( _to_set, extra_class, reason ) {
        if ( !reason ) {
            reason = "shinken-main-selector";
        }
        if ( _to_set ) {
            SHINKEN.TOOLS.ARRAY.addElement( this.reason_to_set, reason );
            this.dom_element.classList.add( 'shinken-selected' );
            if ( extra_class ) {
                DOM.Service.addClasses( this.dom_element, extra_class );
            }
        }
        else {
            SHINKEN.TOOLS.ARRAY.removeElement( this.reason_to_set, reason );
            if ( this.reason_to_set.length ) {
                return;
            }
            this.dom_element.classList.remove( 'shinken-selected' );
            this.dom_element.classList.remove( 'shinken-select-focused' );
            this.dom_element.classList.remove( 'shinken-select-no-events' );
            if ( extra_class ) {
                DOM.Service.removeClasses( this.dom_element, extra_class );
            }
        }
        this.is_selected = _to_set;
    },
    isSelected         : function () {
        return this.is_selected;
    },
    setIsFiltered      : function ( to_set ) {
        this.is_filtered = to_set;
        if ( to_set ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
    },
    doFilter           : function ( filter ) {
        
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin && this.element.is_hidden_for_admin_si ) {
            return false;
        }
        if ( !filter ) {
            this.setIsFiltered( false );
            if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
                return false;
            }
            return true;
        }
        if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this.element.getName(), filter ) ) {
            this.setIsFiltered( false );
            return true;
        }
        else {
            this.setIsFiltered( true );
            return false;
        }
    },
    updateHtmlLabel    : function ( label ) {
        this.element.setLabel( label );
        this.dom_element.innerHTML = this.getLabel();
    }
};
COMPONENT.ListSelect           = function ( dom_element, parent_name, allow_multiple_select ) {
    this.init( dom_element, parent_name, allow_multiple_select );
};
COMPONENT.ListSelect.prototype = {
    init                                : function ( dom_element, parent_name, allow_multiple_select ) {
        allow_multiple_select = !!allow_multiple_select;
        this.dom_element      = dom_element;
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element_counter_research      = dom_element.querySelector( '.shinken-counter-current' );
        this.dom_element_counter_total         = dom_element.querySelector( '.shinken-counter-total' );
        this.dom_element_input_research        = dom_element.querySelector( '.shinken-input-search' );
        this.dom_element_display_research      = dom_element.querySelector( '.shinken-display-search .shinken-value' );
        this.dom_element_select_content        = dom_element.querySelector( '.list-select-content' );
        this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        this.state                             = COMPONENT.CONST.BTN_STATE.OFF;
        this.parent_name                       = parent_name;
        this.allow_multiple_select             = allow_multiple_select;
        this.initListElement();
    },
    initListElement                     : function () {
        this.list                     = [];
        this.list_mapping             = {};
        this.nbr_in_list_after_filter = 0;
        var _list_element             = this.dom_element.querySelectorAll( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION );
        this.size_list                = _list_element.length;
        for ( var i = 0; i < this.size_list; i++ ) {
            this.list[ i ]                                = new COMPONENT.ListSelectElement( _list_element[ i ] );
            this.list_mapping[ this.list[ i ].getName() ] = i;
        }
    },
    toggleStateSelectedInList           : function ( key_name, class_to_add ) {
        var _index               = this.list_mapping[ key_name ];
        var _list_select_element = this.list[ _index ];
        _list_select_element.setSelected( !_list_select_element.is_selected, class_to_add );
        return _list_select_element.getElement();
    },
    unselectAllElement                  : function ( extra_class ) {
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            _current.setSelected( false, extra_class );
        }
    },
    doChangeFilterSelect                : function () {
    
    },
    addNewElementUnknown                : function ( key_name, prop_name ) {
        var _to_add    = DOM.Service.createElement( 'div', {
                class               : COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION,
                "data-state"        : "unknown",
                "data-key-name"     : key_name,
                "data-key-label"    : key_name,
                "data-type"         : "user",
                "data-is-disabled"  : "false",
                "data-force-to-null": "false",
                "data-uuid"         : "",
                onclick             : "MANAGER.EventManager.clickOnItemSelector('event','" + prop_name + "', this)"
            },
            "<span class='shinken-space'>" + key_name + " ( " + _( 'element.unknown' ) + " )" + "</span>"
        );
        var _to_return = new COMPONENT.ListSelectElement( _to_add );
        this.addNewElement( key_name, _to_return );
        return _to_return;
    },
    addNewElement                       : function ( key_name, list_select_element ) {
        this.list[ this.size_list ]              = list_select_element;
        this.list_mapping[ key_name ]            = this.size_list;
        this.dom_element_counter_total.innerHTML = parseInt( this.dom_element_counter_total.innerHTML ) + 1;
        this.size_list++;
        this.dom_element_select_content.appendChild( list_select_element.dom_element );
    },
    getElement                          : function ( key_name ) {
        var _index = this.list_mapping[ key_name ];
        if ( _index === undefined ) {
            return null;
        }
        return this.list[ _index ].getElement();
    },
    getListSelectElement                : function ( key_name ) {
        var _index = this.list_mapping[ key_name ];
        return this.list[ _index ];
    },
    getSelectedElements                 : function () {
        var _to_return = [];
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                _to_return.push( _current_element );
            }
        }
        return _to_return;
    },
    getFirstSelectedElement             : function ( exclude_hidden ) {
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                if ( exclude_hidden && _current_element.dom_element.classList.contains( "shinken-hidden" ) ) {
                    continue;
                }
                return _current_element;
            }
        }
        return null;
    },
    setState                            : function ( state ) {
        this.state = state;
        this.setLastAutoSelectElement( false );
        return this.state;
    },
    focusOnResearchInput                : function () {
        if ( this.dom_element_input_research ) {
            this.dom_element_input_research.focus();
            if ( this.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.doFilter( this.current_filter );
            }
        }
    },
    setResearchDisplay                  : function ( value ) {
        if ( this.dom_element_display_research ) {
            this.dom_element_display_research.innerHTML = value;
        }
    },
    toggleState                         : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
            default:
                console.error( "Error::toggleState is outside its perimeter" );
        }
        return this.state;
    },
    doFilter                            : function ( filter ) {
        if ( this.current_filter && filter === this.current_filter ) {
            return;
        }
        this.current_filter           = filter;
        this.nbr_in_list_after_filter = 0;
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            if ( _current.doFilter( filter ) ) {
                this.nbr_in_list_after_filter++;
            }
        }
        if ( filter ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        if ( this.nbr_in_list_after_filter ) {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        else {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        if ( this.dom_element_counter_research ) {
            this.dom_element_counter_research.innerHTML = this.nbr_in_list_after_filter;
        }
        this.setLastAutoSelectElement( false );
        
    },
    cleanFilter                         : function () {
        this.dom_element_input_research.value = "";
        this.doFilter( '' );
    },
    addNewElementList                   : function ( value ) {
        var _to_add = new COMPONENT.ListSelectElement( _list_element[ i ] );
    },
    hasAutoSelect                       : function () {
        return this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND;
    },
    setLastAutoSelectElement            : function ( to_set, action_type, avoid ) {
        if ( to_set ) {
            DOM.ScrollService.bindWith( this.dom_element_select_content, this.list[ this.current_index_auto_select_element ].dom_element, this.previous_position_vertical, action_type );
            this.list[ this.current_index_auto_select_element ].dom_element.classList.add( 'shinken-select-focused' );
        }
        else {
            if ( !avoid ) {
                this.previous_position_vertical = 0;
            }
            if ( this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND ) {
                if ( !avoid ) {
                    this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.list[ this.current_index_auto_select_element ].dom_element, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                }
                this.list[ this.current_index_auto_select_element ].dom_element.classList.remove( 'shinken-select-focused' );
            }
            this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        }
    },
    selectSelectedOrFirstFilteredElement: function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            this.updateLastAutoSelectIndex( SHINKEN.TOOLS.ARRAY.findFirstIndexWith( this.list, "is_filtered", false ), COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.KEY_INPUT );
        }
    },
    validAutoSelect                     : function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            return false;
        }
        this.list[ this.current_index_auto_select_element ].dom_element.click();
        this.setLastAutoSelectElement( false );
        return true;
    },
    moveAutoSelectCursor                : function ( move_down ) {
        if ( this.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            return;
        }
        if ( !this.size_list ) {
            return;
        }
        var action_type = move_down ? COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN : COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP;
        var _dom_target = this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ? null : this.list[ this.current_index_auto_select_element ].dom_element;
        
        if ( !DOM.ScrollService.isVisible( this.dom_element_select_content, _dom_target, 0, action_type ) ) {
            var _dom_element;
            if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
                _dom_element = DOM.ScrollService.getFirstVisibleDom( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            else {
                _dom_element = DOM.ScrollService.getCloserVisibleDomFromMiddle( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            if ( _dom_element ) {
                this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.dom_element_select_content, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                this.updateLastAutoSelectIndex( this.list_mapping[ _dom_element.dataset.keyName ], action_type, true );
            }
            return;
        }
        var _current_counter = this.current_index_auto_select_element;
        var _current;
        var _found           = false;
        
        while ( move_down ? _current_counter < this.size_list : _current_counter >= COMPONENT.CONST.NOT_FOUND ) {
            move_down ? _current_counter++ : _current_counter--;
            _current = this.list[ _current_counter ];
            if ( !_current ) {
                this.updateLastAutoSelectIndex( this.current_index_auto_select_element, action_type );
                continue;
            }
            var _display = DOM.Service.getComputedStyle( _current.dom_element, DOM.CONST.STYLE.DISPLAY );
            if ( _display === DOM.CONST.VALUE.NONE ) {
                continue;
            }
            if ( _current.isSelected() && !this.allow_multiple_select ) {
                continue;
            }
            _found = true;
            break;
        }
        if ( _found ) {
            this.updateLastAutoSelectIndex( _current_counter, action_type );
        }
    },
    updateLastAutoSelectIndex           : function ( index, action_type, avoid ) {
        var _type = "";
        switch ( action_type ) {
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOUSE:
                if ( this.prevent_mouse_enter ) {
                    return;
                }
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN:
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
                this.prevent_mouse_enter = true;
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP:
                this.prevent_mouse_enter = true;
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_TOP;
                break;
        }
        if ( this.prevent_mouse_enter ) {
            var _self = this;
            if ( this.timeout_mouse_down ) {
                clearTimeout( this.timeout_mouse_down );
            }
            this.timeout_mouse_down = setTimeout( function () {
                _self.prevent_mouse_enter = false;
                _self.timeout_mouse_down  = null;
            }, 200 );
        }
        this.setLastAutoSelectElement( false, _type, avoid );
        this.current_index_auto_select_element = index;
        this.setLastAutoSelectElement( true, _type );
    }
};
COMPONENT.Select           = function ( dom_element, type, is_override, parent, datasetLink, allow_multiple_select ) {
    this.type                  = type;
    this.is_override           = is_override;
    this.allow_multiple_select = !!allow_multiple_select;
    this.init( dom_element, parent );
    this.setDataSetLink( datasetLink );
    this.__class = SHINKEN.TOOLS.CLASS.CONST.COMPONENT.SELECT;
};
COMPONENT.Select.prototype = {
    
    init                          : function ( dom_element, parent ) {
        this.dom_element             = dom_element;
        this.dom_select              = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR );
        this.dom_link_icon_container = this.dom_select.querySelector( '.shinken-link-icon-container' );
        this.dom_link_icon_button    = this.dom_select.querySelector( '.shinken-link-icon-button' );
        var _dom_list_select         = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST );
        this.list_element            = new COMPONENT.ListSelect( _dom_list_select, parent.getParentName(), this.allow_multiple_select );
        this.initSearchElement();
        this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        if ( this.type === PROPERTY.CONST.TYPES.MULTI_SELECT ) {
            var _dom_list_selected       = dom_element.querySelector( '.list-selected-in-select' );
            var _dom_list_inherited      = dom_element.querySelector( '.list-inherited' );
            var _dom_list_override       = dom_element.querySelector( '.shinken-list-override' );
            this.list_element_selected   = new COMPONENT.ListTag( _dom_list_selected, parent.name );
            this.list_elements_inherited = new COMPONENT.ListTag( _dom_list_inherited );
            this.list_element_override   = new COMPONENT.ListTag( _dom_list_override );
        }
        this.initCounters( parent );
    },
    initSearchElement             : function () {
        var _dom = this.dom_element.querySelector( ".shinken-input-search" );
        if ( _dom ) {
            this.component_input_search = new COMPONENT.Input( _dom );
        }
    },
    updateWithTemplateSpecific    : function ( tags ) {
        this.list_elements_inherited.addTags( tags );
    },
    hidePopup                     : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    openSelector                  : function () {
        if ( this.list_element.state === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.clickOnSelector();
        }
    },
    clickOnSelector               : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
        this.list_element.focusOnResearchInput();
    },
    clickOnItemSelector           : function ( parent_name, key_name, class_to_add ) {
        this.setLastSelectedElementName( key_name );
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                var _element = this.list_element.toggleStateSelectedInList( key_name, class_to_add );
                this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.getActiveListForUser().addTag( parent_name, _element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.clickOnItemSelector( key_name );
                break;
        }
    },
    clickOnDeleteItemSelector     : function ( key_name ) {
        var _element = this.list_element.toggleStateSelectedInList( key_name );
        this.getActiveListForUser().deleteTag( _element );
    },
    askComputeAfterChange         : function ( dom_element ) {
        switch ( dom_element.name ) {
            case 'multi-search':
                this.component_input_search.askComputeAfterChange( dom_element, this );
                break;
        }
    },
    doActionAfterChange           : function ( args ) {
        this.doFilter( this.component_input_search.getValue() );
    },
    dragStartShinken              : function ( type_element, key_name ) {
        switch ( type_element ) {
            case PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM:
                return this.getActiveListForUser().dragStartShinken( key_name );
        }
    },
    resetDragging                 : function () {
        this.list_element_selected.resetDragging();
    },
    setTitle                      : function ( _to_set ) {
        var _dom_text       = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        this.title          = _to_set;
        _dom_text.innerHTML = this.title;
    },
    setResearchDisplay            : function ( _to_set ) {
        this.list_element.setResearchDisplay( _to_set );
    },
    isSet                         : function () {
        return !this.getActiveListForUser().isEmpty();
    },
    cleanAllTags                  : function () {
        this.getActiveListForUser().emptyList();
    },
    getActiveListForUser          : function () {
        if ( this.is_override ) {
            return this.list_element_override;
        }
        else {
            return this.list_element_selected;
        }
    },
    cleanAllItemsSelected         : function ( extra_class ) {
        this.list_element.unselectAllElement( extra_class );
    },
    getValue                      : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                return this.getActiveListForUser().getValue();
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                return this.getLastSelectedElementName();
        }
    },
    getValueToSave                : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                return this.getTagsValueToSave();
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                if ( this.last_selected_key_name ) {
                    return this.getLastSelectedElement().getElement().getValueFinal();
                }
                return;
        }
    },
    getTagsValueToSave            : function () {
        var _to_return = [];
        var _tags      = this.getActiveListForUser().getTags();
        for ( var i = 0, size = _tags.length; i < size; i++ ) {
            _to_return.push( _tags[ i ].getValueFinal() );
        }
        return _to_return;
    },
    computeTitle                  : function ( add_extra, extra_label ) {
        if ( this.last_selected_key_name === undefined ) {
            var _selected = this.list_element.getSelectedElements();
            if ( _selected[ 0 ] !== undefined ) {
                this.setLastSelectedElementName( _selected[ 0 ].element.name );
            }
        }
        var _selected_element = this.getLastSelectedElement();
        var _title_to_set     = '';
        if ( _selected_element ) {
            _title_to_set = _selected_element.element.getLabel();
        }
        if ( extra_label ) {
            _title_to_set += extra_label;
        }
        this.setTitle( _title_to_set );
    },
    getLastSelectedElement        : function () {
        return this.list_element.getListSelectElement( this.last_selected_key_name );
    },
    getLastSelectedElementName    : function () {
        return this.last_selected_key_name || '';
    },
    setLastSelectedElementName    : function ( to_set ) {
        if ( this.last_selected_key_name ) {
            this.previous_selected_key_name = this.last_selected_key_name;
        }
        this.last_selected_key_name = to_set;
    },
    hasTag                        : function ( name ) {
        return !this.list_element_selected.hasTag( name ) || !this.list_elements_inherited.hasTag( name );
    },
    getMissingItemSelectorWith    : function ( property, _selected ) {
        return this.list_element_selected.getMissingItemSelectorWith( property, _selected );
    },
    getExtraItemSelectorWith      : function ( property ) {
        return this.list_element_selected.getExtraItemSelectorWith( property );
    },
    setMaximumSelected            : function ( to_set ) {
        this.maximum_selected = to_set;
    },
    getMaximumSelected            : function () {
        return this.maximum_selected;
    },
    isLimitReached                : function () {
        return (this.getActiveListForUser().getSizeTags() + this.list_elements_inherited.getSizeTags() - this.maximum_selected);
    },
    isLimitReachedForSelected     : function () {
        return (this.getActiveListForUser().getSizeTags() - this.maximum_selected);
    },
    disabledTagsOutOfLimit        : function ( limit ) {
        this.list_elements_inherited.disabledTagsOutOfLimit( limit );
    },
    getErrors                     : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterError().counter_final;
        return _to_return;
    },
    getWarnings                   : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterWarning().counter_final;
        return _to_return;
    },
    setMessage                    : function ( message ) {
        var _status = COMPONENT.CONST.STATUS.NONE;
        if ( typeof message === 'string' ) {
            _status = COMPONENT.CONST.STATUS.INFO;
        }
        else if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [ 0, 0 ];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.INFO:
                this.addShinkenTooltip( "", message );
                break;
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    addShinkenTooltip             : function ( type, message ) {
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', message );
        message ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setStatus                     : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    setDataSetLink                : function ( to_set ) {
        this.dataSetLink = to_set;
        if ( this.dataSetLink ) {
            this.computeTitle();
        }
    },
    getDataSetLink                : function () {
        return this.dataSetLink;
    },
    getListElement                : function () {
        return this.list_element;
    },
    doFilter                      : function ( filter ) {
        this.list_element.doFilter( filter );
    },
    doChangeFilterSelect          : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.doChangeFilterSelect();
                break;
        }
    },
    cleanFilter                   : function () {
        this.list_element.cleanFilter();
    },
    validOrCreateTag              : function ( name_element, prop_name ) {
        var _existing = this.list_element.getListSelectElement( name_element );
        if ( _existing ) {
            return _existing;
        }
        return this.list_element.addNewElementUnknown( name_element, prop_name );
    },
    buildLinkOpenNewTab           : function ( link, id ) {
        var _span_link                         = '<span class="shinken-link-icon-button"><span class="shinken-link-icon shinicon shinicon-open"></span></span>';
        this.dom_link_icon_container.innerHTML = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( link, id, _span_link, "shinken-link" ).outerHTML;
    },
    pulsateTag                    : function ( name ) {
        var _existing = this.list_element_selected.getTagByName( name );
        if ( _existing ) {
            _existing.pulsateTag();
        }
    },
    hasAutoSelect                 : function () {
        return this.list_element.hasAutoSelect();
    },
    moveAutoSelectCursor          : function ( move_down ) {
        this.list_element.moveAutoSelectCursor( move_down );
    },
    validAutoSelect               : function () {
        return this.list_element.validAutoSelect();
    },
    isAllElementsSelectedDisabled : function () {
        return this.getActiveListForUser().isAllElementsSelectedDisabled();
    },
    hasInvalidElementForProduction: function () {
        return this.getActiveListForUser().hasInvalidElementForProduction();
    },
    validSelectedOrFirstElement   : function () {
        this.list_element.selectSelectedOrFirstFilteredElement();
        this.validAutoSelect();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Select, SHINKEN.OBJECT.CounterInterface );
SHINKEN_LIST.Filter           = function ( dom_element, type ) {
    this.setType( type );
    this.init( dom_element );
};
SHINKEN_LIST.Filter.prototype = {
    init                   : function ( dom_element ) {
        this.dom_element = dom_element;
        this.name        = this.dom_element.dataset.name;
        this._is_active  = false;
        if ( this.dom_element.dataset.type ) {
            this.setType( this.dom_element.dataset.type );
        }
        this.initComponents();
    },
    initComponents         : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                this.component = new COMPONENT.Select( this.dom_element, PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case SHINKEN_LIST.CONST.FILTER.TYPE.INPUT_STRING_ARRAY:
                this.component = new COMPONENT.Input( this.dom_element.querySelector( ".shinken-input" ), this );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.component = new COMPONENT.InputWithDropDown( this.dom_element, this, true );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_NOT_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS );
                break;
        }
    },
    setType                : function ( to_set ) {
        switch ( to_set ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                to_set = PROPERTY.CONST.TYPES.SINGLE_SELECT;
                break;
        }
        this.type = to_set;
    },
    getUuid                : function () {
        return this.name;
    },
    isValid                : function () {
        return (this.name && this.type);
    },
    isSet                  : function () {
        this._computeState();
        return this.isActive();
    },
    getParentName          : function () {
        return this.name;
    },
    getValue               : function () {
        return this.component.getValue();
    },
    getName                : function () {
        return this.name;
    },
    getFinalValue          : function () {
        return this.component.getFinalValue();
    },
    setActive              : function ( to_set ) {
        to_set = !!to_set;
        if ( to_set ) {
            this.dom_element.classList.add( 'shinken-active' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
        }
        this._is_active = to_set;
    },
    isActive               : function () {
        return !!this._is_active;
    },
    setValue               : function ( to_set ) {
        this.component.setValueFromJs( to_set );
    },
    getListElement         : function () {
        return this.component.getListElement();
    },
    getComponents          : function () {
        return [ this.component ];
    },
    initWhenInputReady     : function () {
        var self = this;
        setTimeout( function () {
            self.component.validateValueInput();
            self._computeState();
            DOM.Service.setDataSet( self.dom_element, 'inputStatus', self.component.getStatus() );
        }, 300 );
    },
    clickOnSelector        : function () {
        this.component.clickOnSelector();
    },
    clickOnItemSelector    : function ( key_name, dom_element, selector, event ) {
        this.component.clickOnItemSelector( '', key_name, event );
        this._computeState();
        this.hidePopup();
        
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                this.component.computeTitle();
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                var forced = !(key_name !== '');
                CONTROLLER.List.getFilterAndReload( forced );
                break;
        }
    },
    doChangeFilterSelect   : function () {
        this.component.doChangeFilterSelect();
    },
    askComputeAfterChange  : function ( dom_element, parent, args ) {
        this.component.askComputeAfterChange( dom_element, parent || this, args );
    },
    doActionAfterChange    : function ( args ) {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                return;
        }
        this.component.computeAfterChange();
        this._computeState();
        DOM.Service.setDataSet( this.dom_element, 'inputStatus', this.component.getStatus() );
        switch ( args.controller_name ) {
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                CONTROLLER.List.updateCleanButtonStatus();
                break;
        }
    },
    clickChangeFilterSelect: function () {
        this.component.clickChangeFilterSelect();
    },
    clickOnInput           : function () {
        this.component.clickOnInput();
    },
    hidePopup              : function () {
        this.setNeedValidation( true );
        this.doActionAfterChange({});
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                this.component.hidePopup();
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.component.hidePopup();
                break;
        }
    },
    _computeState          : function () {
        var _value = this.getValue();
        if ( _value === SHINKEN_LIST.CONST.FILTER.ALL ) {
            _value = false;
        }
        this.setActive( !!_value );
    },
    validateValueInput     : function () {
        this.component.validateValueInput();
    },
    keydown                : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.ENTER:
                if ( this.component.hasAutoSelect() ) {
                    event.stopPropagation();
                    event.preventDefault();
                    this.component.validSelectedOrFirstElement();
                }
                else {
                    this.component.finishActionBeforeReload();
                    CONTROLLER.List.getFilterAndReload( true );
                }
                break;
            default:
                this.component.keydown( event, key_code );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Filter, SHINKEN.OBJECT.CounterInterface );
SHINKEN_LIST.Filters           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Filters.prototype = {
    init                 : function ( dom_element ) {
        this.initContents( dom_element.querySelectorAll( '.shinken-list-filter' ) );
    },
    initContents         : function ( dom_elements ) {
        this.contents = {};
        var _current;
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            _current = new SHINKEN_LIST.Filter( dom_elements[ i ], this.type );
            if ( _current.isValid() ) {
                this.contents[ _current.getName() ] = _current;
            }
        }
    },
    getFilter            : function ( name ) {
        return this.contents[ name ];
    },
    getActiveFilters     : function () {
        var _to_return = [];
        var _keys      = Object.keys( this.contents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( this.contents[ _current_key ].isSet() ) {
                _to_return.push( this.contents[ _current_key ] );
            }
        }
        return _to_return;
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( dom_element, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getFilter( _parent_dom_element.dataset.name ).askComputeAfterChange( dom_element, parent || this, { 'type': _type } );
                break;
        }
    },
    clickOnSelector      : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                var _to_return = this.getFilter( _parent_dom_element.dataset.name );
                _to_return.clickOnSelector( _parent_dom_element );
                return _to_return;
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _option             = DOM.Service.findParentElementWithDataSet( event.target, 'keyName', 10 );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getFilter( _parent_dom_element.dataset.name ).clickOnItemSelector( _option.dataset.keyName, _parent_dom_element, false, event );
                break;
        }
    },
    hidePopup            : function ( exception ) {
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( exception !== this.contents[ _keys[ i ] ] ) {
                this.contents[ _keys[ i ] ].hidePopup();
            }
        }
    }
};
SHINKEN_LIST.Header           = function ( type, dom_element ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Header.prototype = {
    init         : function ( dom_element ) {
        this.dom_element = dom_element;
    }
};
SHINKEN_LIST.Line           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Line.prototype = {
    init                  : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_filtered = this.dom_element.classList.contains( "shinken-is-filtered" ) ? SHINKEN_LIST.CONST.FILTER.STATUS.ON : SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        this.is_collapse = false;
        this.uuid        = this.dom_element.dataset.uuid;
        
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.host    = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidItem ) );
                this.parent  = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidParent ) );
                this.check   = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeCheck, this.dom_element.dataset.uuidCheck ) );
                this.dfe_key = this.dom_element.dataset.dfeKey;
                break;
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.parent_uuid           = this.dom_element.dataset.uuidParent;
                this.parent_select_element = DOM.Service.findParentElementWithClass( this.dom_element, this.dom_element.dataset.parentSelectClass, 20 );
                break;
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.uuid = this.dom_element.dataset.name;
                break;
        }
        this.initIsSelected();
        this.initCellsValue();
    },
    initIsSelected        : function () {
        if ( this.dom_element.classList.contains( "shinken-selected-disabled" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        else if ( this.dom_element.classList.contains( "shinken-selected" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
        }
        else {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_selected_counter = new SHINKEN.OBJECT.Counter();
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                if ( !this.parent_uuid ) {
                    this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_element_selected );
                }
                this.updateSelectionCounter();
                if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                    this.initCounters( CONTROLLER.MassChange.steps.get().button_next, true );
                }
                break;
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_checks_selected );
                break;
        }
    },
    initCellsValue        : function () {
        this.cell_value = {};
        var _cells      = this.dom_element.querySelectorAll( ".shinken-list-cell" );
        var _current;
        for ( var i = 0, _size_i = _cells.length; i < _size_i; i++ ) {
            _current = _cells[ i ];
            if ( _current.dataset.filterValueArray ) {
                this.cell_value[ _current.dataset.filter ] = _current.dataset.filterValueArray.split( "," );
            }
            else if ( _current.dataset.filterValue ) {
                this.cell_value[ _current.dataset.filter ] = _current.dataset.filterValue;
            }
            else {
                this.cell_value[ _current.dataset.filter ] = DOM.Service.getInnerText( _current );
            }
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.cell_value[ 'data_name_array' ] = this.uuid;
                break;
        }
    },
    applyFilter           : function ( filters ) {
        var _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        for ( var i = 0, _size_i = filters.length; i < _size_i; i++ ) {
            var _value_filter = filters[ i ].getValue();
            var _value_cell   = this.cell_value[ filters[ i ].getName() ];
            switch ( _value_cell ) {
                case SHINKEN_LIST.CONST.FILTER.HAS_CHILDREN:
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN;
                    continue;
            }
            var _type_filter = filters[ i ].type;
            switch ( _type_filter ) {
                case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                    if ( _value_filter === SHINKEN_LIST.CONST.FILTER.ALL ) {
                        break;
                    }
                    else if ( _value_filter === SHINKEN_LIST.CONST.FILTER.NOT_EMPTY ) {
                        if ( Array.isArray( _value_cell ) ) {
                            if ( SHINKEN.TOOLS.ARRAY.contains( _value_cell, SHINKEN_LIST.CONST.FILTER.EMPTY ) ) {
                                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                            }
                        }
                        else if ( _value_cell === SHINKEN_LIST.CONST.FILTER.EMPTY ) {
                            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                        }
                        break;
                    }
                    if ( Array.isArray( _value_cell ) ) {
                        if ( !SHINKEN.TOOLS.ARRAY.contains( _value_cell, _value_filter ) ) {
                            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                        }
                    }
                    else if ( _value_cell !== _value_filter ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
                case PROPERTY.CONST.TYPES.STRING_INPUT:
                    if ( !SHINKEN.TOOLS.STRING.containsIgnoreCase( _value_cell, _value_filter ) ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
                case SHINKEN_LIST.CONST.FILTER.TYPE.INPUT_STRING_ARRAY:
                    var _list  = _value_filter.split( "," );
                    var _found = false;
                    for ( var j = 0, _size_j = _list.length; j < _size_j; j++ ) {
                        if ( _list[ j ] === _value_cell ) {
                            _found = true;
                            break;
                        }
                    }
                    if ( !_found ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
            }
        }
        this.setFilter( _filter );
    },
    setFilter             : function ( to_set ) {
        this.is_filtered = to_set;
        switch ( this.is_filtered ) {
            case SHINKEN_LIST.CONST.FILTER.STATUS.ON:
                this.dom_element.classList.add( "shinken-is-filtered" );
                break;
            case SHINKEN_LIST.CONST.FILTER.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-is-filtered" );
                break;
        }
    },
    getUUID               : function () {
        return this.uuid;
    },
    toggleSelect          : function () {
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
                break;
        }
    },
    setIsSelected         : function ( to_set ) {
        if ( this.is_filtered ) {
            return;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return;
        }
        this.is_selected = to_set;
        this.updateSelectionCounter();
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.dom_element.classList.add( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.add( "shinken-selected-parent" );
                }
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.remove( "shinken-selected-parent" );
                }
                break;
        }
        
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                switch ( this.is_selected ) {
                    case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                        this.showCountersForParent();
                        break;
                    default:
                        this.hideCountersForParent();
                        break;
                }
        }
        
    },
    updateSelectionCounter: function () {
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.is_selected_counter.update( this.uuid, this.isSelected() ? 1 : 0 );
                break;
        }
    },
    setDataSet            : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        if ( if_key ) {
            if ( if_function === "matching_regex" ) {
                if ( !SHINKEN.TOOLS.STRING.isMatchingStarRegexTab( this.cell_value[ if_key ], if_values ) ) {
                    data_value = else_data_value;
                }
            }
            else {
                if ( !SHINKEN.TOOLS.STRING.containsAny( this.cell_value[ if_key ], if_values ) ) {
                    data_value = else_data_value;
                }
            }
        }
        DOM.Service.setDataSet( this.dom_element, datakey, data_value );
    },
    isSelected            : function () {
        return this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
    },
    isSelectedOrFiltered  : function () {
        if ( this.is_filtered ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        return this.is_selected;
    },
    toggleCollapse        : function ( childrens ) {
        this.setIsCollapsed( !this.is_collapse );
        for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
            childrens[ i ].setIsCollapsed( this.is_collapse );
        }
    },
    setIsCollapsed        : function ( to_set, childrens ) {
        this.is_collapse = to_set;
        if ( this.is_collapse ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
        if ( childrens ) {
            for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
                childrens[ i ].setIsCollapsed( this.is_collapse );
            }
        }
    },
    getDataToSave         : function ( type ) {
        var _to_return;
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                switch ( type ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                        _to_return       = {};
                        _to_return.value = this.isSelected() ? true : false;
                        if ( this.dom_element.dataset.originalSelected === "1" ) {
                            _to_return.value = !_to_return.value;
                        }
                        _to_return.check_link = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        break;
                    default:
                        _to_return      = [];
                        _to_return[ 0 ] = this.host.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 1 ] = this.parent.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 2 ] = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 3 ] = this.dfe_key;
                        break;
                }
            
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.CounterInterface );
SHINKEN_LIST.Lines           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Lines.prototype = {
    init                      : function ( dom_element ) {
        this.initContents( dom_element.querySelectorAll( '.shinken-list-line' ) );
    },
    initContents              : function ( dom_elements ) {
        this.contents        = [];
        this.mapping         = {};
        this.mapping_parents = {};
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.add( dom_elements[ i ] );
        }
    },
    addMappingParent          : function ( parent_uuid, uuid ) {
        if ( !parent_uuid ) {
            if ( !this.mapping_parents[ uuid ] ) {
                this.mapping_parents[ uuid ] = [];
            }
        }
        else {
            if ( !this.mapping_parents[ parent_uuid ] ) {
                this.mapping_parents[ parent_uuid ] = [];
            }
            this.mapping_parents[ parent_uuid ].push( this.mapping[ uuid ] );
        }
    },
    removeMappingParent       : function ( parent_uuid, _to_remove ) {
        if ( parent_uuid ) {
            SHINKEN.TOOLS.ARRAY.removeElement( this.mapping_parents[ parent_uuid ], _to_remove );
        }
    },
    add                       : function ( dom_element ) {
        var _to_add = new SHINKEN_LIST.Line( dom_element, this.type );
        this.contents.push( _to_add );
        this.mapping[ _to_add.getUUID() ] = _to_add;
        this.addMappingParent( _to_add.parent_uuid, _to_add.uuid );
    },
    remove                    : function ( uuid ) {
        var _to_remove = this.mapping[ uuid ];
        delete this.mapping[ uuid ];
        this.removeMappingParent( _to_remove.parent_uuid, _to_remove );
        SHINKEN.TOOLS.ARRAY.removeElement( this.contents, _to_remove );
    },
    getByUUID                 : function ( uuid ) {
        return this.mapping[ uuid ];
    },
    toggleCollapse            : function ( uuid ) {
        this.mapping[ uuid ].toggleCollapse( this.mapping_parents[ uuid ] );
    },
    setIsCollapseAllData      : function ( to_set ) {
        var _keys = Object.keys( this.mapping_parents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.mapping[ _current_key ].setIsCollapsed( to_set, this.mapping_parents[ _current_key ] );
        }
    },
    setSelectAllData          : function ( to_set ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setIsSelected( to_set );
        }
    },
    getNbSelected             : function () {
        return this.getSelected().length;
    },
    getSelected               : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].isSelected() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getNotSelected               : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].is_selected !== SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    setAllLinesDataSet        : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
        }
    },
    isAllActiveLineSelected   : function () {
        var _nb_active = 0;
        var _current;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ].isSelectedOrFiltered();
            switch ( _current ) {
                case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                    _nb_active++;
                    break;
                case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                    return false;
            }
        }
        return !!_nb_active;
    },
    applyFilter               : function ( filters ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].applyFilter( filters );
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.filterParentWithNoChildren();
                break;
        }
    },
    filterParentWithNoChildren: function () {
        var _current;
        var _filter;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered !== SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN ) {
                continue;
            }
            if ( _current.parent_uuid ) {
                continue;
            }
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            for ( var j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
                if ( this.contents[ j ].parent_uuid === _current.getUUID() && this.contents[ j ].is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.OFF ) {
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
                    break;
                }
            }
            _current.setFilter( _filter );
        }
    },
    hideAllLines              : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setFilter( SHINKEN_LIST.CONST.FILTER.STATUS.ON );
        }
    },
    getDataToSave             : function ( type ) {
        var _to_return = type === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE ? {} : [];
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.isSelected() ) {
                switch ( this.type ) {
                    case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                        switch ( type ) {
                            case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                                _current_data = _current.getDataToSave( type );
                                if ( !_to_return[ _current.host.getUUID() ] ) {
                                    _to_return[ _current.host.getUUID() ] = [];
                                }
                                _to_return[ _current.host.getUUID() ].push( _current_data );
                                break;
                            
                            default:
                                _to_return.push( _current.getDataToSave( type ) );
                                break;
                        }
                        break;
                    default:
                        _to_return.push( _current.getDataToSave( type ) );
                        break;
                }
            }
        }
        return _to_return;
    }
};
SHINKEN_LIST.Set           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Set.prototype = {
    init                 : function ( dom_element ) {
        this.dom_element = dom_element;
        this.initHeaders( this.dom_element.querySelectorAll( '.shinken-list-header' ) );
        this.filters               = new SHINKEN_LIST.Filters( dom_element, this.type );
        this.lines                 = new SHINKEN_LIST.Lines( dom_element, this.type );
        this.is_all_data_selected  = this.dom_element.classList.contains( "shinken-selected" ) ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        this.is_all_data_collapsed = false;
        this.updateHtml();
    },
    initHeaders          : function ( dom_elements ) {
        this.headers = [];
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.headers[ i ] = new SHINKEN_LIST.Header( this.type, dom_elements[ i ] );
        }
    },
    askComputeAfterChange: function ( dom_element ) {
        this.filters.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange  : function ( args ) {
        var _type = args['type'];
        switch ( _type ) {
            case 'shinken-list-filter':
                this.lines.applyFilter( this.filters.getActiveFilters() );
                this.setSelectAllStatus();
                break;
            case 'shinken-hide-all-element':
                this.lines.hideAllLines();
                break;
        }
    },
    clickOnCheckboxInput : function ( name ) {
        if ( name === "shinken-all-elements" ) {
            this.selectAllData( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ? SHINKEN_LIST.CONST.SELECTION.STATUS.OFF : SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
            return;
        }
        this.lines.mapping[ name ].toggleSelect();
        this.setSelectAllStatus();
    },
    clickOnCollapseButton: function ( uuid ) {
        if ( uuid === "shinken-all-elements" ) {
            this.collapseAllData( !this.is_all_data_collapsed );
            return;
        }
        this.setIsCollapseAllData( false );
        this.lines.toggleCollapse( uuid );
    },
    clickOnSelector      : function ( event ) {
        var _filter = this.filters.clickOnSelector( event );
        this.hidePopup( _filter );
    },
    clickOnItemSelector  : function ( event ) {
        this.filters.clickOnItemSelector( event );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        this.doActionAfterChange( {'type' : _parent_dom_element.dataset.objectType} );
    },
    setIsCollapseAllData : function ( to_set ) {
        this.is_all_data_collapsed = to_set;
        if ( this.is_all_data_collapsed ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
    },
    collapseAllData      : function ( to_set ) {
        this.setIsCollapseAllData( to_set );
        this.lines.setIsCollapseAllData( this.is_all_data_collapsed );
    },
    setSelectAllStatus   : function ( to_set ) {
        if ( to_set === undefined ) {
            to_set = this.lines.isAllActiveLineSelected() ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_all_data_selected = to_set;
        if ( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
            this.dom_element.classList.add( "shinken-selected" );
        }
        else {
            this.dom_element.classList.remove( "shinken-selected" );
        }
    },
    selectAllData        : function ( to_set ) {
        this.setSelectAllStatus( to_set );
        this.lines.setSelectAllData( this.is_all_data_selected );
    },
    getSelectedLines     : function () {
        return this.lines.getSelected();
    },
    getNotSelectedLines  : function () {
        return this.lines.getNotSelected();
    },
    setAllLinesDataSet   : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        return this.lines.setAllLinesDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
    },
    addLine              : function ( dom_element ) {
        this.lines.add( dom_element );
        this.updateHtml();
    },
    removeLine           : function ( uuid ) {
        this.lines.remove( uuid );
        this.updateHtml();
    },
    getLineByUUID        : function ( uuid ) {
        return this.lines.getByUUID( uuid );
    },
    hidePopup            : function ( _filter ) {
        this.filters.hidePopup( _filter );
    },
    updateHtml           : function () {
        DOM.Service.setDataSet( this.dom_element, "numberLines", this.lines.contents.length );
    },
    getDataToSave        : function ( type ) {
        return this.lines.getDataToSave( type );
    }
};
MANAGER.DistributorControllerManager = (function ( self ) {
    "use strict";
    self.findControllerByEvent = function ( event, controller_name ) {
        var _controller = controller_name;
        if ( !_controller ) {
            var _target             = event.target;
            var _parent_dom_element = DOM.Service.findParentElementWithClass( _target, "shinken-parent-event-listener", 500 );
            if ( !_parent_dom_element ) {
                return;
            }
            _controller = _parent_dom_element.dataset.controller;
        }
        return self.getController(_controller);
    };
    self.getController         = function ( _controller ) {
        switch ( _controller ) {
            case MANAGER.CONST.CONTROLLER.MASS_CHANGE:
                return CONTROLLER.MassChange;
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                return CONTROLLER.List;
            case MANAGER.CONST.CONTROLLER.SHINKEN_ELEMENT:
                return CONTROLLER.ShinkenElement;
            case MANAGER.CONST.CONTROLLER.SOURCES:
                return CONTROLLER.Source;
            case "SHINKEN-TODO":
                break;
            default:
                console.warn( "NO CONTROLLER FOUND FOR ", "[" + _controller + "]" );
        }
    };
    return self;
})( MANAGER.DistributorControllerManager || {} );
MANAGER.DistributorWindowManager           = function () {
    this.windows        = {};
    this.parent_windows = {};
};
MANAGER.DistributorWindowManager.prototype = {
    createWindow      : function ( name, is_menu ) {
        var _id          = WINDOW.CONST.ID.WINDOW_TAB + name;
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = new WINDOW.Element( name, _dom_element, is_menu );
        this.setWindow( name, _to_return );
        return _to_return;
    },
    createParentWindow: function ( name ) {
        var _to_return = new WINDOW.ElementGroup( name );
        this.setParentWindow( name, _to_return );
        return _to_return;
    },
    findWindow        : function ( name, is_menu, parent_id ) {
        if ( !name ) {
            return;
        }
        if( parent_id ){
            var _parent = this.findParentWindow(parent_id);
            if ( _parent ) {
                return  _parent.getElementByName( name );
            }
        }
        var _to_return = this.getWindow( name );
        if ( !_to_return ) {
            _to_return = this.createWindow( name, is_menu );
        }
        return _to_return;
    },
    findParentWindow  : function ( name ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getParentWindow( name );
        if ( !_to_return ) {
            _to_return = this.createParentWindow( name );
        }
        return _to_return;
    },
    setWindow         : function ( name, window ) {
        this.windows[ name ] = window;
    },
    setParentWindow   : function ( name, parent_window ) {
        this.parent_windows[ name ] = parent_window;
    },
    getWindow         : function ( name ) {
        return this.windows[ name ];
    },
    clickOnFirstWindowInParentWithName         : function ( name ) { //FOR DOCUMENTATION
        var _keys = Object.keys( this.parent_windows );
        this.parent_windows[ _keys[0] ].clickOnWindow(name);
    },
    getParentWindow   : function ( name ) {
        return this.parent_windows[ name ];
    },
    reset             : function () {
        this.windows        = {};
        this.parent_windows = {};
    }
};
MANAGER.__instance_window_distributor      = new MANAGER.DistributorWindowManager();
MANAGER.DragNDropManager = (function ( self ) {
    "use strict";
    self.last_element_hovered = null;
    self.current_parent_name  = null;
    self.type_drag_start      = null;
    self.list_element         = null;
    self.single_element_drag  = null;
    
    self.dragStartSingle  = function ( event ) {
        self.single_element_drag = DOM.Service.findParentElementWithClass( event.target, "shinken-draggable", 50 );
        this.single_element_drag.classList.add("shinken-drag-active");
        self._bounding_origin = self.single_element_drag.getBoundingClientRect();
        self._mouse_x_origin  = parseInt( event.clientX );
        self._mouse_y_origin  = parseInt( event.clientY );
        var _computed         = DOM.Service.getComputedStyle( self.single_element_drag );
        self._left_origin = parseInt( _computed[ 'left' ] );
        self._top_origin  = parseInt( _computed[ 'top' ] );
    };
    self.dragSingle       = function ( event ) {
        if ( !self.single_element_drag ) {
            return;
        }
        var _delta_x = parseInt( event.clientX ) - self._mouse_x_origin + self._left_origin;
        var _delta_y = parseInt( event.clientY ) - self._mouse_y_origin + self._top_origin;
        DOM.Service.setStyles( self.single_element_drag, { "top": _delta_y, "left": _delta_x } );
    };
    self.dragEndSingle    = function ( event ) {
        this.single_element_drag.classList.remove("shinken-drag-active");
        self.single_element_drag = null;
    };
    self.dragStartShinken = function ( e, type, parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        if ( _object.is_disabled ) {
            return false;
        }
        e.dataTransfer.setData( 'text', 'anything' );
        self.type_drag_start      = type;
        self.current_parent_name  = parent_name;
        self.list_element         = _object.dragStartShinken( type, key_name );
        self.last_element_hovered = self.list_element.getDragged().getDomElement().parentNode;
        self.last_index           = self.last_element_hovered.dataset.index;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        
        var _list_droppable = _object.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = _list_droppable[ i ].getBoundingClientRect().width - 2 + 'px';
        }
    };
    self.dragOverShinken  = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
        if ( self.current_parent_name !== parent_name ) {
            return false;
        }
        if ( self.type_drag_start !== type ) {
            return false;
        }
        var _current_index_hovered = dom_element.dataset.index;
        if ( _current_index_hovered === self.last_index ) {
            return false;
        }
        
        self.list_element.changeElementPosition( self.last_index, _current_index_hovered );
        self.last_index = _current_index_hovered;
        self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        self.last_element_hovered = dom_element;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
    };
    self.dragEndShinken   = function ( e, type ) {
        var _list_droppable = MANAGER.__instance_property_distributor.last_element_focus.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = '';
        }
        
        if ( MANAGER.__instance_property_distributor.last_element_focus.is_disabled ) {
            return false;
        }
        e.preventDefault();
        MANAGER.__instance_property_distributor.last_element_focus.resetDragging();
        
        if ( self.last_element_hovered ) {
            self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        }
        self.last_element_hovered = null;
        self.current_parent_name  = null;
        self.type_drag_start      = null;
        self.list_element         = null;
        self.pause_timeout        = null;
    };
    self.dropShinken      = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
    };
    return self;
})
( MANAGER.DragNDropManager || {} );
MANAGER.EventManager = {
    last_element_hovered           : null,
    stop_propagation               : false,
    openIframeModal                : function ( url ) {
        MANAGER.__instance_window_modal_manager.setIframe( url );
    },
    closeModal                     : function () {
        MANAGER.__instance_window_modal_manager.close();
    },
    clickOnToggleCollapse          : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, "shinken-toggle-parent", 25 );
        if ( !_parent_dom_element ) {
            return;
        }
        _parent_dom_element.classList.toggle( "shinken-collapsed" );
    },
    logout                         : function () {
        window.location = '/logout';
        sessionStorage.removeItem( "user_id" );
    },
    onFocus                        : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onFocus();
    },
    onFocusOut                     : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onFocusOut( event );
    },
    stopPropagation                : function ( event ) {
        if ( event ) {
            event.stopPropagation();
        }
        else {
            this.stop_propagation = true;
            var self              = this;
            setTimeout( function () {
                self.stop_propagation = false;
            }, 50 );
        }
    },
    clickOnRadioBtn                : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnRadioBtn( event );
    },
    clickOnButton                  : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnButton( event );
    },
    onChangeOnInputKey             : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.askComputeKeyAfterChange( event.target );
    },
    clickOnAddNewLocalMacro        : function () {
        return App.Elements.DataTab.addNewData();
    },
    clickOnDeletePropertyBtn       : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.delete();
    },
    clickDataCollapseButtonGlobal  : function () {
        App.Elements.DataTab.toggleCollapseButtonGlobal();
    },
    clickDataCollapseButton        : function ( dom_element ) {
        App.Elements.DataTab.toggleCollapseButton( dom_element );
    },
    goToDataView                   : function ( data_name ) {
        MANAGER.EventManager.clickOnWindowNavigation( null, MANAGER.__instance_element_distributor.current_element.uuid, true, WINDOW.CONST.ELEMENT.DATAS );
        var _prop = MANAGER.__instance_property_distributor.getDataWithName( data_name );
        if ( _prop && _prop.group_data ) {
            MANAGER.EventManager.clickOnDataNavigation( _prop.group_data.uuid );
        }
    },
    clickOnDataNavigation          : function ( group_uuid ) {
        App.Elements.DataTab.clickOnDataNavigation( group_uuid );
    },
    clickOnWindowNavigation        : function ( event, name, update_url, window_name ) {
        if ( !window_name ) {
            var _nav_tab = DOM.Service.findParentElementWithClass( event.target, WINDOW.CONST.CLASS.WINDOW_TAB, 10 );
            if ( !_nav_tab ) {
                return;
            }
            window_name = _nav_tab.dataset.name;
        }
        
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( name );
        
        _parent_window.clickOnWindow( window_name );
        if ( update_url ) {
            SHINKEN.HIGHWAY.goToElementTab( window_name );
        }
    },
    clickOnCheckboxInput           : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCheckboxInput( event );
    },
    onChangeOnInput                : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onChangeOnInput( event );
    },
    onResize                       : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onResize( dom_element );
    },
    onMoveRangeCursor              : function ( parent_name, ask_after_action, event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onMoveRangeCursor( null, event );
        if ( ask_after_action ) {
            MANAGER.ListenerEventManager.askAfterActionProperty( _object );
        }
    },
    clickOnBtnPlus                 : function ( parent_name, event ) {
        this.stopPropagation();
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnPlus( event );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnSelector                : function ( event, parent_name, controller_name ) {
        event.stopPropagation();
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnSelector( event, parent_name );
    },
    clickOnAllItemsSelector        : function ( parent_name, limit ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAllItemsSelector( limit );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnItemSelector            : function ( event, parent_name, element, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnItemSelector( event, parent_name, element );
    },
    clickOnDeleteItemSelector      : function ( parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnDeleteItemSelector( key_name );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnBtnInheritance          : function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnInheritance();
    },
    clickOnInput                   : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnInput( event );
    },
    muteEvent                      : function ( event ) {
        event.preventDefault();
        event.stopPropagation();
    },
    mutePropagation                : function ( event ) {
        event.stopPropagation();
    },
    clickOnToggleViewSource        : function () {
        MANAGER.__instance_source_distributor.toggleViewSource();
        
    },
    clickOnActivatedSource         : function ( name ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.toogleEnable();
    },
    clickOnActivatedDiscoverySource: function ( source_name, discovery_id ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedDiscoverySource]", "[not admin]", "refused" );
            return;
        }
        var _source    = MANAGER.__instance_source_distributor.findSource( source_name );
        var _discovery = _source[ SOURCE.CONST.FIELD.IP_RANGES ].getRangeById( discovery_id );
        _discovery.toogleEnable();
    },
    clickOnForceSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnForceSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.askForceImport();
    },
    clickOnCleanSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnCleanSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.cleanImport();
    },
    clickOnLastExecutionSource     : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnLastExecutionSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.redirectToSourceLastExecution();
    },
    clickOnWorkflowTab             : function ( name ) {
        var dom_element = document.querySelector( "#shinken-workflow-container" );
        DOM.Service.setDataSet( dom_element, 'selected', name );
        dom_element.classList.toggle( 'PATCH_IE' );
    },
    clickOpenNewWindow             : function ( event, link, id ) {
        var _path = "/elements/";
        _path += link + '/';
        _path += id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    clickOnLinkForWorkingArea      : function ( event, id ) { //NE MARCHE QUE POUR LES HOSTS
        var _path = "/elements/working_area/hosts/" + id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    keydown                        : function ( event ) {
        var _key_code = event.keyCode;
        switch ( _key_code ) {
            case SHINKEN.CONST.KEY_CODE.F1:
                if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
                    window.onhelp = function () {
                        return false;
                    };
                }
                event.preventDefault();
                event.stopPropagation();
                break;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.keydown( event, _key_code );
        }
    },
    mouseEnter                     : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseEnter( event );
        }
    },
    mouseLeave                     : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseLeave( event );
        }
    },
    onClick                        : function ( event ) {
        if ( this.stop_propagation ) {
            this.stop_propagation = false;
            return;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.onClick( event );
        }
    },
    onScroll                       : function ( dom_element_container ) {
        var _top    = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.TOP );
        var _scroll = dom_element_container[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ];
        var _bottom = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.BOTTOM );
        
        var _y = ((_bottom - _top) / 2) + _top;
        
        document.getElementById( "id-shinken-debug-1" ).innerText = _top;
        document.getElementById( "id-shinken-debug-2" ).innerText = _bottom;
        document.getElementById( "id-shinken-debug-3" ).innerText = _scroll;
        document.getElementById( "id-shinken-debug-4" ).innerText = _scroll + _top;
        document.getElementById( "id-shinken-debug-5" ).innerText = _scroll + _bottom;
        document.getElementById( "id-shinken-debug-6" ).innerText = _y;
        
        
    },
    clickOnForcedHelpButton        : function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 20 );
        var name                = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( name );
        _object.clickOnForcedHelpButton();
    },
    clickOnForcedHelpButtonCheck   : function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        MANAGER.HelpManager.setForced( 'help_title_try_checks', dom_element, true );
    },
    clickOnPaste                   : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.clickOnPaste( event );
        }
    },
    clickOnModeTab                 : function ( element, do_blink_animation ) {
        var _parent = document.getElementById( 'id-shinken-window-checks-target' );
        DOM.Service.setDataSet( _parent, 'tabSelected', element.dataset.value );
        if ( do_blink_animation ) {
            DOM.Service.askAddClass( element, 'shinken-pulsate', 2000 );
        }
        if ( element.dataset.value !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            var _elements = document.querySelectorAll( '.shinken-tab-check-col-tags' );
            for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
                _elements[ i ].classList.remove( "shinken-active" );
            }
            var _elements_tr = document.querySelectorAll( '.shinken-tr-check-override' );
            for ( var i = 0, _size = _elements_tr.length; i < _size; i++ ) {
                _elements_tr[ i ].classList.add( "shinken-hidden" );
            }
        }
        MANAGER.__instance_navigator_size.tab_data_exclude();
    },
    clickOnSetOverride             : function ( dom_uuid ) {
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE + '"]' ), true );
        }
        App.Elements.ChecksTab.getCheckOverrideData( dom_uuid );
        MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.CLICK_ON_SERVICE_OVERRIDE );
    },
    clickOnSetExclude              : function ( dom_uuid, event, ignore_if_on_status_exclude ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE + '"]' ), true );
        }
        else if ( !ignore_if_on_status_exclude ) {
            var _check_in_host = App.Elements.ChecksTab.getCheckInHostElement( dom_uuid );
            _check_in_host.changeExcludeStatus();
        }
    },
    clickOnDeleteInvalidOverride   : function ( type, name ) {
        MANAGER.__instance_override_unvalid.deleteOverride( type, name );
        App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
    },
    clickOnCleanCheckOverrides     : function ( event, check_uuid ) {
        event.stopPropagation();
        var _confirm = confirm( _( 'element.confirm_remove_override' ) );
        if ( _confirm ) {
            var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
            _check_in_page_host.cleanOverride();
            App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
        }
    },
    clickOnFocusOnDuplicateCheck   : function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckByID( check_uuid );
        _check_in_page_host.dom_element.scrollIntoView( false );
        DOM.Service.askAddClass( _check_in_page_host.dom_element.querySelector( '.shinken-tab-check-col-name' ), 'shinken-pulsate-focus', 3000 );
    },
    clickOnTryCheck                : function ( check_uuid, is_exec, is_on_poller ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.askTryCheck( is_exec, is_on_poller );
    },
    clickOnCleanTryCheck           : function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.hide_eval_check();
    },
    clickOnMultiLineObjectAdd      : function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAddLine();
    },
    clickOnDeleteLine              : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.deleteLine( dom_element );
    },
    clickOnHooksPopup              : function ( event, element ) {
        event.stopImmediatePropagation();
        var target    = element;
        var parent    = target.parentNode;
        var is_active = target.classList.contains( 'active' );
        if ( is_active ) {
            target.classList.remove( 'active' );
            parent.classList.remove( "shinken-force-display-block" );
        }
        else {
            target.classList.add( 'active' );
            parent.classList.add( "shinken-force-display-block" );
        }
    },
    clickOnCollapseButton          : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCollapseButton( event );
    },
    simulateClickOnFilter          : function ( event, header_name, value ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.simulateClickOnFilter( event, header_name, value );
    },
    clickOnForceImportInSource     : function ( source_name ) {
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.URL
                     + source_name
                     + COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                _sources.refresh();
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    }
};
OBJECT.ElementList           = function () {
    this.init();
};
OBJECT.ElementList.prototype = {
    init                 : function () {
        this.is_disabled = false;
    },
    getName              : function () {
        return this.name;
    },
    getState             : function () {
        return this.state;
    },
    getType              : function () {
        return this.type;
    },
    getItemType          : function () {
        return this.item_type ? this.item_type : '';
    },
    getLabel             : function () {
        return this.label;
    },
    setName              : function ( to_set, dom_element ) {
        this.name = to_set;
        this.setLabel( to_set, dom_element );
    },
    setLabel             : function ( to_set ) {
        this.label = to_set;
    },
    setState             : function ( to_set ) {
        this.state = to_set;
    },
    setIsDisabled        : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_disabled = !!to_set;
    },
    setIsForceToNull     : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_force_to_null = !!to_set;
    },
    setIsHiddenForAdminSi: function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_hidden_for_admin_si = !!to_set;
    },
    setUUID              : function ( to_set ) {
        this.uuid = to_set;
        this.findShinkenElement();
    },
    findShinkenElement   : function () {
        if ( this.uuid && this.item_type ) {
            var _shinken_element = MANAGER.__instance_element_distributor.getElementByDict( this );
            if ( _shinken_element ) {
                this.setShinkenElement( _shinken_element );
            }
        }
    },
    setShinkenElement    : function ( to_set ) {
        this.shinken_element = to_set;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    setItemType          : function ( to_set ) {
        this.item_type = to_set;
        this.findShinkenElement();
    },
    clone                : function () {
        var _to_return = new OBJECT.ElementList();
        var _keys      = Object.keys( this );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key               = _keys[ i ];
            _to_return[ _current_key ] = this[ _current_key ];
        }
        return _to_return;
    },
    getClass             : function () {
        var _to_return = "";
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            _to_return += " shinken-element-new";
        }
        else if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            _to_return += " shinken-element-unknown";
        }
        else if ( this.is_disabled ) {
            _to_return += " shinken-element-disabled";
        }
        return _to_return;
    },
    getError             : function () {
        if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            return 1;
        }
        if ( this.is_disabled ) {
            return 1;
        }
        return 0;
    },
    getTooltip           : function () {
        var _to_return = "";
        if ( this.is_disabled ) {
            _to_return = _( 'element.tooltip_disabled' );
        }
        switch ( this.state ) {
            case COMPONENT.CONST.TAG.STATE.NEW :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_NEW :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_new_disabled' );
                } else {
                    _to_return = _( 'element.tooltip_new' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.WORKING :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_working_disabled' );
                } else {
                    _to_return = _( 'element.tooltip_working' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.UNKNOWN :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_UNKNOWN :
                _to_return = _( 'element.tooltip_undefined' );
                break;
        }
        if ( this.is_force_to_null ) {
            if ( _to_return ) {
                _to_return += "<br>";
            }
            _to_return += SHINKEN.TOOLS.STRING.format( _( 'element.double_link_long_warning' ), this.getLabel() );
        }
        return _to_return;
    },
    getValueFinal        : function () {
        var _to_return = {};
        switch ( this.getState() ) {
            case OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN:
            case OBJECT.CONST.TEMPLATE.STATUS.NEW:
            case COMPONENT.CONST.TAG.STATE.UNKNOWN:
            case COMPONENT.CONST.TAG.STATE.NEW:
                _to_return.name   = this.name;
                _to_return.exists = false;
                break;
            default:
                _to_return.name      = this.name;
                _to_return.item_type = this.getItemType();
                _to_return._id       = this.uuid;
                _to_return.exists    = true;
                break;
        }
        return _to_return;
    }
};
CONTROLLER.Help = (function ( self ) {
    "use strict";
    self._dom_element_help = null;
    self.toggleHelp        = function ( event ) {
        event.preventDefault();
        event.stopPropagation();
        if ( !self._dom_element_help ) {
            self._dom_element_help = document.getElementById( 'id-shinken-help-pop-up' );
            self._dom_element_help.classList.remove( 'shinken-hidden' );
            return;
        }
        self._dom_element_help.classList.toggle( 'shinken-hidden' );
    };
    self.closeHelp         = function () {
        if ( !self._dom_element_help ) {
            return;
        }
        self._dom_element_help.classList.add( 'shinken-hidden' );
    };
    return self;
})( CONTROLLER.Help || {} );
MANAGER.HelpGenerator = (function ( self ) {
    "use strict";
    self.content                   = [];
    self.size                      = 0;
    self.init                      = function ( class_to_add ) {
        self.initContent();
        if ( !self.size ) {
            return;
        }
        self.buildButtonHtml();
        self.buildContentHtml( class_to_add );
        self.initEventListener();
    };
    self.initContent               = function () {
        var _found = document.querySelectorAll( ".shinken-help-container .shinken-help-content" );
        for ( var i = 0, _size_i = _found.length; i < _size_i; i++ ) {
            self.content.push( new OBJECT.Help( _found[ i ] ) );
            DOM.Service.removeElement( _found[ i ] );
        }
        self.size    = self.content.length;
        self.content = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( self.content, [ "order_tab", "name_tab", "order" ] );
    };
    self.initEventListener         = function () {
        document.addEventListener( 'keydown', function ( event ) {
            MANAGER.EventManager.keydown( event );
        } );
    };
    self.buildButtonHtml           = function () {
        var _button_f1       = DOM.Service.createElement( 'div', { class: "shinken-help-button-container", onclick: "CONTROLLER.Help.toggleHelp(event)", 'data-name': "toggle_help" } );
        _button_f1.innerHTML = '<button class="shinken-button"><table><tr><td><span class="key">F1</span></td><td>' + _( 'common.help.label' ) + '</td></tr></table></button>';
        document.body.appendChild( _button_f1 );
    };
    self.buildContentHtml          = function (class_to_add) {
        var _content_to_html  = DOM.Service.createElement( 'div', {
            id     : "id-shinken-help-pop-up",
            class  : "shinken-hidden " + class_to_add,
            onclick: "MANAGER.EventManager.stopPropagation(event)"
        } );
        var _container_html   = DOM.Service.createElement( 'div', { class: "shinken-help-container" } );
        var _container_html_2 = DOM.Service.createElement( 'div', { class: "shinken-help-container-2" } );
        var _container_html_3 = DOM.Service.createElement( 'div', { class: "shinken-help-container-3" },
            "<div class='shinken-text-centred'><div class='shinken-help-title'>" + _( 'common.help.label' ) + "</div></div>" );
        var _current_tab;
        var _current_tab_name = "";
        for ( var i = 0, _size_i = self.size; i < _size_i; i++ ) {
            if ( _current_tab_name !== self.content[ i ].tab ) {
                _current_tab_name = self.content[ i ].tab;
                _current_tab      = WINDOW.ElementService.getWindowTargetHtml( 'div', _current_tab_name, !i );
                _container_html_3.appendChild( _current_tab );
            }
            _current_tab.appendChild( self.content[ i ].getHtml() );
        }
        _content_to_html.appendChild( _container_html );
        _container_html.appendChild( _container_html_2 );
        _container_html_2.appendChild( self.buildWindowsLineHtml() );
        _container_html_2.appendChild( _container_html_3 );
        document.body.appendChild( _content_to_html );
        document.body.appendChild( _content_to_html );
    };
    self.buildWindowsLineHtml      = function () {
        var _to_return = DOM.Service.createElement( 'div', {
            class      : "shinken-help-windows-title-menu shinken-window-group",
            "data-name": "help-group",
            onclick    : "MANAGER.EventManager.clickOnWindowNavigation(event,'help-group')"
        } );
        var _tab_list  = SHINKEN.TOOLS.ARRAY.extractKeys( this.content, [ 'tab', 'name_tab' ], true, true );
        _tab_list      = SHINKEN.TOOLS.ARRAY.removeDuplicateArray( _tab_list );
        _tab_list      = self.concatDuplicationWindowID( _tab_list );
        var _current;
        for ( var i = 0, _size_i = _tab_list.length; i < _size_i; i++ ) {
            _current = _tab_list[ i ];
            _to_return.appendChild( WINDOW.ElementService.getWindowHtml( "div", _current[ 0 ], _current[ 1 ], "help-group", !i ) );
        }
        var _button_close = DOM.Service.createElement( 'div', { class: "shinken-help-close-button shinkon-times-bold", onclick: "CONTROLLER.Help.toggleHelp(event)" } );
        _to_return.appendChild( _button_close );
        return _to_return;
    };
    self.concatDuplicationWindowID = function ( tab_list ) {
        var _to_return = [];
        var _mapping   = {};
        var _current;
        var _index;
        for ( var i = 0, _size_i = tab_list.length; i < _size_i; i++ ) {
            _current = tab_list[ i ];
            if ( _mapping[ _current[ 0 ] ] ) {
                _index                    = _mapping[ _current[ 0 ] ] - 1;
                _to_return[ _index ][ 1 ] = _to_return[ _index ][ 1 ] + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE + _current[ 1 ];
            }
            else {
                _mapping[ _current[ 0 ] ] = _to_return.push( _current );
            }
        }
        return _to_return;
    };
    return self;
})( MANAGER.HelpGenerator || {} );
OBJECT.Help = function ( dom_element ) {
    this.dom_element = dom_element;
    this.tab         = dom_element.dataset.tab;
    this.order       = parseInt( dom_element.dataset.order ) || 1;
    this.order_tab   = parseInt( dom_element.dataset.tabOrder ) || 1;
    this.name_tab    = dom_element.dataset.tabName || "??";
};
OBJECT.Help.prototype = {
    getHtml: function () {
        return this.dom_element;
    }
};
WINDOW.ElementGroup           = function ( name ) {
    this.name = name;
    this.list = {};
    this.init();
};
WINDOW.ElementGroup.prototype = {
    init            : function () {
        this.dom_element = document.querySelector( '.' + WINDOW.CONST.CLASS.WINDOW_GROUP + '[data-name="' + this.name + '"]' );
        this.initWindows();
    },
    initWindows     : function () {
        var _dom_elements = this.dom_element.querySelectorAll( '.' + WINDOW.CONST.CLASS.WINDOW_TAB + '[data-group-name="' + this.name + '"]' );
        this.size         = _dom_elements.length;
        var _current;
        var _current_name;
        for ( var i = 0; i < this.size; i++ ) {
            _current                   = _dom_elements[ i ];
            _current_name              = _current.dataset.name;
            this.list[ _current_name ] = new WINDOW.Element( _current_name, _current );
        }
    },
    getActiveWindow   : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.list[ _keys[ i ] ].is_active ){
                return this.list[ _keys[ i ] ];
            }
        }
        return null;
    },
    clickOnWindow   : function ( window_name ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            _current.setActive( _current.getName() === window_name );
        }
        if ( window_name === 'datas-override' ) {
            MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.CLICK_ON_WINDOW_DATA_OVERRIDE, this.name );
        }
    },
    getElementByID  : function ( id ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getID() === id ) {
                return _current;
            }
        }
        return null;
    },
    getElementByName: function ( name ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getName() === name ) {
                return _current;
            }
        }
        return null;
    },
    setParentCounter: function ( parent ) {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].setParentCounter( parent );
        }
    }
};
WINDOW.ElementService = (function ( self ) {
    self.getWindowTargetHtml = function ( dom_tag, tab_name, is_active ) {
        var _class_to_add = is_active ? "shinken-window-target" : "shinken-window-target shinken-hidden";
        var _to_return    = DOM.Service.createElement( dom_tag, { id: "id-shinken-window-" + tab_name + "-target", class: _class_to_add } );
        return _to_return;
    };
    self.getWindowHtml       = function ( dom_tag, window_id, label, group_name, is_active ) {
        var _class_to_add = is_active ? "shinken-window-element shinken-active" : "shinken-window-element";
        var _to_return    = DOM.Service.createElement( dom_tag, {
            class            : _class_to_add,
            "data-group-name": group_name,
            "data-name"      : window_id,
            id               : "id-shinken-window-" + window_id
        }, label );
        return _to_return;
    };
    return self;
})( WINDOW.ElementService || {} );
WINDOW.Element           = function ( name, dom_element, is_menu ) {
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.Element.prototype = {
    init                      : function () {
        this.initDomElement();
        if ( this.is_menu ){
            var _dom_element_counters = this.dom_element.querySelectorAll( '.shinken-counter' );
            this.counters = {};
            var _current;
            for ( var i = 0, _size_i = _dom_element_counters.length; i < _size_i; i++ ) {
                _current = _dom_element_counters[i];
                this.counters[_current.dataset.counterType] = new SHINKEN.OBJECT.Counter();
                this.counters[_current.dataset.counterType].init(_current);
            }
        }
        else {
            this.initCounters();
        }
    },
    
    initDomElement            : function () {
        this.id                 = this.dom_element.getAttribute( 'id' );
        if ( this.is_menu ){
            return;
        }
        if ( this.dom_element.classList.contains("shinken-active")){
            this.is_active = true;
        }
        this.dom_element_target = document.getElementById( this.id + '-target' );
        if ( !this.dom_element_target ){
            console.warn("[LA STRUCTURE HTML des windows n'est pas correcte]", this.id, this.id + '-target  ==> not found'   );
        }
    },
    getName                   : function () {
        return this.name;
    },
    getID                     : function () {
        return this.id;
    },
    setHasRequired            : function ( to_set ) {
        if ( to_set ) {
            this.dom_element.querySelector( '.shinken-required-field' ).classList.remove( 'shinken-hidden' );
        }
    },
    setActive                 : function ( to_set ) {
        this.is_active = to_set;
        if ( this.is_active ) {
            this.dom_element.classList.add( 'shinken-active' );
            this.dom_element_target.classList.remove( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
            this.dom_element_target.classList.add( 'shinken-hidden' );
        }
    },
    updateCounter         : function ( name, value ) {
        this.counters[name].update("counter", value);
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.Element, SHINKEN.OBJECT.CounterInterface );
