#!/usr/bin/env bash

# We test both 27017 and 27018 ports to handle complex mong cluster (running sharding and mongos daemons) and simple mongod replicasets
# In classic Mongo installs (without any replication), the isMaster() request returns current node as master when launching the query on the 27017 port
IS_MONGO_MASTER_NODE=$(mongo --port 27017 --quiet --eval 'JSON.stringify(db.isMaster().ismaster)')
IS_MONGO_27018_MASTER_NODE=$(mongo --port 27018 --quiet --eval 'JSON.stringify(db.isMaster().ismaster)')

if [ "$IS_MONGO_MASTER_NODE" == "true" ] || [ "$IS_MONGO_27018_MASTER_NODE" == "true" ]; then
    ./lib/preupdate-checks/check-db-for-duplicates.py
    exit 0
fi