#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.brokermodule import WorkerBasedBrokerModule as BrokerExportModule

from broker_module_sla_api_worker import BrokerModuleSlaApi_Worker

properties = {
    'daemons': ['broker'],
    'type'   : 'broker_module_sla_api',
}


def get_instance(module_configuration):
    # Get your Module Class instance
    instance = BrokerModuleSlaApi(module_configuration)
    return instance


class BrokerModuleSlaApi(BrokerExportModule):
    MODULE_WORKER_CLASS = BrokerModuleSlaApi_Worker
    
    def __init__(self, module_configuration):
        super(BrokerModuleSlaApi, self).__init__(module_configuration)
        if self._nb_workers != 1:
            self.logger.get_sub_part('INITIALISATION').warning('broker_module_nb_workers can only be set to 1, ignoring configured value [%s]' % self._nb_workers)
            self._nb_workers = 1
            
        self._nb_workers = 1
        
        
    def want_brok(self, b):
        return False
