<!DOCTYPE html>
%import shinkensolutions.shinkenjson as json
%import json
% import base64
%from ...dao.def_items import ITEM_TYPE, DEF_ITEMS
%from shinken.synchronizer.dao.def_items import METADATA

%item_type = METADATA.get_metadata(item, METADATA.ITEM_TYPE)
%in_creation = METADATA.get_metadata(item, METADATA.IN_CREATION)
%name = item['sync_name']
%title=translate_service._('common.sync_conf_title')

%mod_type = ''
%for m in source.modules:
    %mod = m
    %mod_type = m.properties['type']
%end
%http_start_time = app.http_start_time
<html class="height-patch-100">
<head>
    <style type="text/css">
                @font-face {
                    font-family : 'FontAwesome';
                    src         : url('/static/{{http_start_time}}/synchronizer-collector-linker/font/fontawesome-webfont.eot?v=3.0.1');
                    src         : url('/static/{{http_start_time}}/synchronizer-collector-linker/font/fontawesome-webfont.eot?#iefix&v=3.0.1') format('embedded-opentype'),
                    url('/static/{{http_start_time}}/synchronizer-collector-linker/font/fontawesome-webfont.woff?v=3.0.1') format('woff'),
                    url('/static/{{http_start_time}}/synchronizer-collector-linker/font/fontawesome-webfont.ttf?v=3.0.1') format('truetype');
                    font-weight : normal;
                    font-style  : normal;
                }
                @font-face {
                    font-family : "Lato";
                    src         : url("/static/{{http_start_time}}/synchronizer-collector-linker/font/lato-regular.ttf") format("truetype");
                    font-weight : normal;
                    font-style  : normal;
                }
             </style>

    <script>
        var global_lang = '{{app.lang}}';
        var protect_fields__substrings_matching_fields   = {{!json.dumps(app.protect_fields__substrings_matching_fields)}};
        var protect_fields__activate_interface_encryption = {{"true" if app.protect_fields__activate_interface_encryption else "false"}};
        var current_shinken_element = '{{!base64.b64encode(json.dumps(item))}}';
        var current_shinken_user    = {{!json.dumps(user.get_raw_item_for_front)}};
        SOURCE_NAME = "{{source_name}}";
    </script>

    <script src="/static/{{http_start_time}}/synchronizer-collector-linker/js/shinken_lib/jquery.js"></script>

    <script src="/static/{{http_start_time}}/synchronizer-collector-linker/js/traductions/en.js"></script>
    <script src="/static/{{http_start_time}}/synchronizer-collector-linker/js/traductions/fr.js"></script>

    <script src="/static/{{http_start_time}}/synchronizer-collector-linker/js/shinken_lib/shinken_lib.js"></script>
    <script src="/static/{{http_start_time}}/synchronizer-collector-linker/js/js_specific/service-synchronizer-collector-linker.js"></script>


    <link href="/static/{{http_start_time}}/synchronizer-collector-linker/css/shinken_lib.css" rel="stylesheet">
    <link href="/static/{{http_start_time}}/synchronizer-collector-linker/css/synchronizer-linker.css" rel="stylesheet">

</head>
<body class="height-patch-100">
    <div class="shinken-content height-patch-100">
        <div class="shinken-content-header cover">
            <div class="area-header shinken-area-header">
                <div class="shinken-network-area-banner">
                    <table class="shinken-table-source-ip-range">
                        <tr>
                            <td>
                                <h4>
                                    <a class="shinken-link" href="/main" target="_parent">{{translate_service._('common.sources_maj')}}</a>
                                    >
                                    <a href="/main#unsortable-container-source-collector-container" target="_parent">{{translate_service._('common.collector')}}</a>
                                    >
                                </h4>
                            </td>
                            <td class="spaced">
                                <h4>
                                    <a href="/sources/{{source_name}}?tab=tab-synchronizers-list" target="_parent">{{source_name}}</a>
                                    >
                                </h4>
                            </td>
                            <td>
                                <h4>
                                    <span>{{translate_service._('common.synchronizer')}}</span>
                                </h4>
                            </td>
                            <td>
                                <h4>
                                    <div id='shinken-title-page-edition' class="shinken-between-bracket shinken-data-user text-ellipsis">
                                        {{name}}
                                    </div>
                                </h4>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            <div id="id-shinken-pop-up-close-button" class="shinkon-times-bold" onclick="backToSourceList()"></div>
        </div>
        <div id="left-column" data-type={{item_type}}>
            %include("__print_element_left_buttons_synchronizer_linker", mod=mod)
            %include("__print_right_help_bloc_synchronizer_linker", mod=mod)
        </div>
        <div id="right-column">
            %if commentary:
            <div class="shinken-tab-title tab-title-commentary-box">
                <div class="pull-right comment-header text-ellipsis commentary-box">
                    <i class="icon-comment icon-comment-patch"></i> {{commentary}}
                    <!--%include("__print_pane_comment")-->
                </div>
            </div>
            %end
            %include("__print_saving_log_synchronizer_linker", mod=mod)
            <div class="container_host_info shinken-container-host-info container_host_info_patch">
                <form id="id-shinken-form-element" data-tab-selected="generic" name='form-element' class='form-inline form-element span12 gray-back no-margin'>
                    <div class="shinken-form-container">
                        <div class="shinken-nav-content">
                            <ul class="shinken-nav-tabs">
                                %include( "__print_element_li_tab_synchronizer_linker", name='generic', label=app._('element.generic'), required=True, app=app, has_properties=False)
                            </ul>
                        </div>
                        <div class="shinken-tab-content tab-content tab-area tab-area-patch">
                            <div id="generic" class="tab-pane property-tab-pane">
                                %include( "__print_panel_top_th_synchronizer_linker", with_templates=False, app=app)
                                <div class="shinken-scroll-auto">
                                    <table class="shinken-prop-table">
                                        <tbody>
                                            %include( "property/prop-string", label=translate_service._('sync.sync_name'), item=item, name='sync_name', is_required=1)
                                            %if item.get('_suuid', ''):
                                                %include( "property/prop-string-readonly", label=translate_service._('sync.suuid'), item=item, name='_suuid')
                                            %end
                                            %include( "property/prop-string", label=translate_service._('sync.address'), item=item, name='address', placeholder=translate_service._('sync.from_name'))
                                            %include( "property/prop-string", label=translate_service._('sync.contact_name'), item=item, name='contact_name', is_required=1)
                                            %include( "property/prop-string", label=translate_service._('sync.password'), item=item, name='password', is_required=1, type_input='password')
                                            %include( "property/prop-boolean", label=translate_service._('sync.use_ssl'), item=item, name='use_ssl', default_value=False)
                                            %include( "property/prop-string", label=translate_service._('sync.prefix'), item=item, name='prefix', placeholder=translate_service._('sync.from_name'))
                                            %include( "property/prop-string", label=translate_service._('sync.notes'), item=item, name='notes', is_text_area=True)
                                            %include( "property/prop-boolean", label=translate_service._('sync.enabled'), item=item, name='enabled', default_value=True)
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            %protocol = "http"
                            <div class="shinken-source-example-conf-container">
                                <div class="shinken-source-example-conf-header">
                                    <span>{{translate_service._('common.conf_example')}}</span>
                                </div>
                                <div class="shinken-source-example-conf">
                                    <span class="shinken-source-example-conf-label">{{translate_service._('common.command_line')}} :</span>
                                    <div class="shinken-block-display">
                                        curl -u <span class="shinken-block-display-to-change">USER</span>:<span class="shinken-block-display-to-change">PASSWORD</span> '{{protocol}}://<span class="shinken-block-display-to-change">SYNCHRONIZER-IP-INTERFACE</span>:7777/shinken/listener-shinken/v1/get_sync_uuid'</span>
                                    </div>
                                    <span class="shinken-source-example-conf-label">{{app._('source.conf_example_successful_response')}} :</span>
                                    <div class="shinken-block-display">
                                        "{"data": {"suuid": "b6031a279f74358ab22cfabdacf1101e"}, "rc": 200}"
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div id="shi-tip" style="top: -500px; left: -500px;">
            <table>
                <tbody>
                    <tr>
                        <td></td>
                        <td>
                            <table>
                                <tr>
                                    <td style="width: 20px;">
                                        <div class="shi-tip-arrow" id="tooltip-arrow-top-left"></div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td>
                            <table class="shinken-width-100">
                                <tr>
                                    <td style="width: 20px;">
                                        <div class="shi-tip-arrow" id="tooltip-arrow-top-middle"></div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td>
                            <table  class="shinken-width-100">
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td style="width: 20px;">
                                        <div class="shi-tip-arrow" id="tooltip-arrow-top-right"></div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td></td>
                    </tr>
                    <tr>
                        <td><div class="shi-tip-arrow" id="tooltip-arrow-left-middle"></div></td>
                        <td colspan="3"><div class="shi-tip-text"></div></td>
                        <td><div class="shi-tip-arrow" id="tooltip-arrow-right-middle"></div></td>
                    </tr>
                    <tr>
                        <td></td>
                        <td>
                            <table>
                                <tr>
                                    <td style="width: 20px;">
                                        <div class="shi-tip-arrow" id="tooltip-arrow-bottom-left"></div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td>
                            <table class="shinken-width-100">
                                <tr>
                                    <td style="width: 20px;">
                                        <div class="shi-tip-arrow" id="tooltip-arrow-bottom-middle"></div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td>
                            <table  class="shinken-width-100">
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td style="width: 20px;">
                                        <div class="shi-tip-arrow" id="tooltip-arrow-bottom-right"></div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
</body>
</html>