#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import List

from .component_select_options import ComponentOption, ComponentOptionGroup, ComponentOptionSeparator
from ..dao.def_items import ITEM_STATE


class HelperRulesComponent(object):
    def __init__(self, app, helper):
        self.app = app
        self.helper = helper
    
    
    def get_multi_selector_html(self, selector_name, selector_html, selected_list_html="", override_list_html="", inherited_list_html=""):
        _to_return = '''
            <td class="shinken-select-container-cell">
               <div>
                   <div class="shinken-select-container" data-state-selector="0" data-name="%(selector_name)s" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()">
                       %(selector_html)s
                       %(selected_list_html)s
                       %(override_list_html)s
                       %(inherited_list_html)s
                   </div>
               </div>
            </td>
        ''' % locals()
        return _to_return
    
    
    def get_input_html_source(self, input_type, value, data_type='', data_unit='', item_prop='', autocomplete='', placeholder='', type='', add_lock=False, add_attribute="", is_protected=False, extra_class_input="", extra_class_table="",
                              with_helper_tip=False):
        focus_html = ''
        if is_protected:
            focus_html = ' onfocus="MANAGER.EventManager.onFocus(this)" onfocusout="MANAGER.EventManager.onFocusOut(event)"'
        else:
            if data_type == 'range_with_input':
                focus_html = ' onfocusout="MANAGER.EventManager.onFocusOut(event)"'
        value = value.replace("'", "&apos;")
        if value == "":
            extra_class_input += ' shinken-empty-input'
        _params = {"value": value, "_autocomplete": autocomplete, "placeholder": placeholder, "type": type, "focus": focus_html, 'extra_class_input': extra_class_input, "item_prop": item_prop}
        _to_return = []
        _to_return.append('''<table class="shinken-width-100 %s"><tr>''' % extra_class_table)
        
        if add_lock:
            _to_return.append('''    <td class="shinken-lock-cell"><span class="shinkon-lock"></span></td>''')
        _to_return.append('''   <td class="shinken-input-container-cell" %s>''' % add_attribute)
        _to_return.append('''       <div class="shinken-input-container">''')
        if with_helper_tip:
            _label = '<table><tr><td><span class="key">F1</span></td><td> %s </td></tr></table>' % self.app._('element.help')
            _to_return.append(self.helper.helper_object.get_button_html(label=_label, class_to_add="shinken-rules-select-input shinken-helper-tip", attribute_to_add='data-name="toggle_help"'))
        
        _to_return.append('''</div></td>''')
        if data_unit:
            _to_return.append('''<td>%s</td>''' % data_unit)
        _to_return.append('''</tr></table>''')
        return ' '.join(_to_return)
    
    
    def get_input_component(self, value, type="text", placeholder=""):
        _to_return = ['''%s''' % self.get_input_html_source('input', value, extra_class_input="shinken-input-with-dropdown", type=type, placeholder=placeholder)]
        return ''.join(_to_return)
    
    
    # def get_drop_down_component(self, entries, property, has_no_research=True, has_no_default=True, element_in_check_text=False, current_research_not_editable=False):
    #     return '''<div class="shinken-select-container" data-state-selector="0" data-name="main-selector">%s</div>''' % self.get_selector_html(
    #         item_prop=property,
    #         entries=entries,
    #         element_in_check_text=element_in_check_text,
    #         has_no_default=has_no_default,
    #         has_no_research=has_no_research,
    #         current_research_not_editable=current_research_not_editable,
    #     )
    
    # def get_input_with_drop_down_component(self, entries, property, value, has_no_research=False, has_no_default=True, element_in_check_text=False, current_research_not_editable=False, type="text", placeholder=""):
    #     _to_return = []
    #     _to_return.append(self.get_input_html_source('input', value, extra_class_input="shinken-input-with-dropdown", type=type, placeholder=placeholder))
    #     _to_return.append(self.get_drop_down_component(entries, property, has_no_research, has_no_default, element_in_check_text,
    #                                                    current_research_not_editable))
    #     return ''.join(_to_return)
    
    def get_selector_html(self, item_prop="", default_text="", default_text_forced="", entries=[], none_text="", element_in_check_text=False, has_plus=False, has_no_default=True, has_no_research=True, select_label="", can_have_link=False,
                          mass_change=False, current_research_not_editable=False, selected_class=""):
        _to_return = []
        
        options_list = []
        _label_plus_inheritance = '%s %s %s' % (self.app._('element.selected_values'), self.app._('element.and'), self.app._('element.inherited_from_templates_plural').lower())
        _label_plus_override = '%s %s %s' % (self.app._('element.selected_values'), self.app._('element.and'), self.app._('element.in_check').lower())
        
        if mass_change:
            _label_enter_a_value = self.app._('mass-change.input.specific-entries.enter_a_value')
            options_list.append(ComponentOption.multiselect_option_builder(item_prop, '__ENTER_VALUE_FOR_MASS_CHANGE__', 'hidden', 'inheritance', text='-- %s --' % _label_enter_a_value, label=_label_enter_a_value))
            _label_add_consistency_value = self.app._('mass-change.input.specific-entries.consistency_value')
            options_list.append(ComponentOption.multiselect_option_builder(item_prop, '__CONSISTENCY_VALUE__', 'consistency', 'inheritance', text='-- %s --' % _label_add_consistency_value, label=_label_add_consistency_value))
            select_label = '<span class="shinken-multiselect-title">%s</span>' % _label_enter_a_value
        
        if not has_no_default:
            if has_plus:
                options_list.append(ComponentOption.multiselect_option_builder(item_prop, '__PLUS_AND_INHERITANCE__', 'hidden', 'inheritance', text='-- %s --' % _label_plus_inheritance, label=_label_plus_inheritance))
            options_list.append(ComponentOption.multiselect_option_builder(item_prop, '__PLUS_AND_OVERRIDE__', 'hidden', 'inheritance', text='-- %s --' % _label_plus_override, label=_label_plus_override))
            options_list.append(ComponentOption.multiselect_option_builder(item_prop, '__INHERITANCE__', 'empty', 'inheritance', label=self.app._('element.inheritance_on')))
            options_list.append(ComponentOption.multiselect_option_builder(item_prop, '__NO_OVERRIDE__', 'hidden', 'inheritance', label=element_in_check_text))
            options_list.append(ComponentOption.multiselect_option_builder(item_prop, '__DEFAULT_NO_TEMPLATE__', 'hidden', 'inheritance', label=default_text))
            options_list.append(ComponentOption.multiselect_option_builder(item_prop, '__DEFAULT_NO_TEMPLATE_FORCED__', 'hidden', 'inheritance', label=default_text_forced))
            options_list.append(ComponentOption.multiselect_option_builder(item_prop, 'null', 'hidden', 'inheritance', label=none_text))
        
        item_types = set()
        
        is_admin = self.app.get_user_auth().is_admin()
        for entry in entries:
            if isinstance(entry, ComponentOptionSeparator):
                options_list.append(entry.buildHTML())
                continue
            elif isinstance(entry, ComponentOptionGroup):
                options_list.append(entry.buildHTML())
                continue
            if entry.item_type:
                item_types.add(entry.item_type)
            class_to_add = ('shinken-selected %s' % selected_class) if entry.selected else ''
            if entry.extra_class:
                class_to_add = "%s %s" % (class_to_add, entry.extra_class)
            if select_label and entry.selected:
                select_label = entry.label
            extra = ''
            extra_label = []
            _is_disabled = 'false'
            _is_force_to_null = 'false'
            _is_hidden_for_admin_si = 'false'
            _entry_type = 'user'
            
            state_element = [entry.state]
            if entry.is_disable():
                _is_disabled = 'true'
            if entry.is_visible():
                _entry_type = 'is-always-visible'
            if entry.is_forced_to_null():
                _is_force_to_null = 'true'
            if not is_admin and entry.is_hidden_for_admin_si():
                _is_hidden_for_admin_si = 'true'
            
            if state_element[0] != ITEM_STATE.STAGGING and not 'shinken-matching' and not 'shinken-final':
                extra_label.append(self.app._("element.%s" % state_element[0]))
            if entry.is_disable() and state_element[0] != 'unknown':
                extra_label.append(self.app._("element.disabled"))
            if entry.is_forced_to_null():
                extra_label.append(self.app._('element.double_link_short_warning'))
            if len(extra_label) > 0:
                extra = '( %s )' % ' & '.join(extra_label)
            state_element = ' '.join(state_element)
            entry.state_element = state_element
            _item_type = entry.item_type if entry.item_type else ''
            text = entry.text
            if not text:
                text = '%s %s' % (entry.label, extra)
            
            options_list.append(ComponentOption.multiselect_option_builder(item_prop, entry.value, state_element, _entry_type, id=entry.id,
                                                                           text=text, class_to_add=class_to_add,
                                                                           is_disabled=_is_disabled, is_force_to_null=_is_force_to_null,
                                                                           label=entry.label, item_type=_item_type, extra_content=entry.extra_content,
                                                                           is_hidden_for_admin_si=_is_hidden_for_admin_si))
        
        # create the selector
        selector_html = []
        # selector_html.append('''<div class="shinken-select-selector shinken-user-select-none" onclick="MANAGER.EventManager.clickOnSelector(event, '%(item_prop)s')" >''' % {"item_prop": item_prop})
        if can_have_link:
            selector_html.append('''  <span class="shinken-link-icon-container">''')
            selector_html.append('      <span class="shinken-link-icon-button"><span class="shinken-link-icon shinicon shinicon-open"></span></span>''')
            selector_html.append('''  </span>''')
        selector_html.append('''  <span class="shinken-selector-label shinken-space" >%s</span>''' % select_label)
        # selector_html.append('''  <span class="caret"></span>''')
        selector_html.append('''</div>''')
        
        # input for searching
        _size_entries = len(entries) if self.app.get_user_auth().is_admin() else len([entry for entry in entries if not entry.is_hidden_for_admin_si()])
        options_list_html = []
        options_list_html.append('''<div class="shinken-rules-select" >''')
        if not has_no_research or current_research_not_editable:
            options_list_html.append('''     <div class="rules-select-header" >''')
            options_list_html.append('''        <div class="shinken-input-search-content" data-type="searching" onclick="MANAGER.EventManager.muteEvent(event)">''')
            options_list_html.append('''            <table>''')
            options_list_html.append('''                <tr>''')
            if current_research_not_editable:
                options_list_html.append('''<td class="shinken-display-search shinken-filter-label-cell">''')
                options_list_html.append('''    <span class="shinken-label">%s : </span>''' % self.app._('element.filtered_on'))
                options_list_html.append('''</td>''')
                options_list_html.append('''<td class="shinken-display-search shinken-filter-value-cell">''')
                options_list_html.append('''    <span class="shinken-value" data-empty="%s" name="multi-search"></span>''' % self.app._("element.none"))
                options_list_html.append('''</td>''')
            else:
                options_list_html.append('''<td class="shinken-display-search shinken-filter-value-cell">''')
                options_list_html.append(
                    '''    <input class="shinken-input-search" placeholder="%s" autocomplete="off" oncut="MANAGER.EventManager.onChangeOnInput(event)" onpaste="MANAGER.EventManager.onChangeOnInput(event)" onkeyup="MANAGER.EventManager.onChangeOnInput(event)" type="text" name="multi-search"/>''' % (
                    self.app._('element.search')))
                options_list_html.append('''</td>''')
            options_list_html.append('''                    <td class="shinken-display-search shinken-filter-counter-cell">''')
            options_list_html.append('''                        <div class="shinken-counter-search"><span class="shinken-counter-current">%s</span>/<span class="shinken-counter-total">%s</span></div>''' % (_size_entries, _size_entries))
            options_list_html.append('''                    </td>''')
            options_list_html.append('''                </tr>''')
            options_list_html.append('''            </table>''')
            options_list_html.append('''        </div>''')
            options_list_html.append('''    </div>''')
        options_list_html.append('''    <div class="rules-select-content shinken-user-select-none" >''')
        if not has_no_research and not current_research_not_editable:
            options_list_html.append('''        <div class="shinken-no-search-result" onclick="MANAGER.EventManager.muteEvent(event)">%s</div>''' % self.app._('element.no_result'))
        options_list_html.append('''        %s''' % ''.join(options_list))
        options_list_html.append('''    </div>''')
        options_list_html.append('''</div>''')
        
        _to_return.append(''.join(selector_html))
        _to_return.append(''.join(options_list_html))
        
        _to_return = ''.join(_to_return)
        return _to_return
    
    
    def get_list_not_ordered_html(self, contents, class_to_add_container='', class_to_add_content='', title=''):
        # type: (List[basestring], basestring, basestring, basestring) -> basestring
        if not len(contents):
            return ""
        template = '''
        <div class="shinken-rules-container {{class_to_add_container}}">
        %if title:
            <div class="shinken-rules-title">{{title}}</div>
        %end
        <ul class="shinken-rules-container-ul">
            %for content in contents:
                <li class="shinken-rules-content {{class_to_add_content}}">{{!content}}</li>
            %end
        </ul>
        </div>
        '''
        
        return self.helper.template_format(template, contents=[i for i in contents], class_to_add_container=class_to_add_container, class_to_add_content=class_to_add_content, title=title)
