#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn


class TOOLTIP_PLACEMENT(object):
    LEFT = 'left'
    RIGHT = 'right'
    TOP = 'top'
    TOP_LEFT = 'top-left'
    TOP_RIGHT = 'top-right'
    BOTTOM = 'bottom'
    BOTTOM_LEFT = 'bottom-left'
    BOTTOM_RIGHT = 'bottom-right'


class Tooltip(object):
    HAS_CLASS = 'has_class'
    HAS_NOT_CLASS = 'has_not_class'
    
    
    def __init__(self):
        # type: ()-> NoReturn
        self._mouse_enter = '''SHINKEN_TOOLTIP.showTooltip(this)'''
        self._mouse_leave = '''SHINKEN_TOOLTIP.hideTooltip()'''
        self._placement = ''''''
        self._type = ''''''
        self._html = ''''''
        self._condition_type = ''''''
        self._condition_value = ''''''
    
    
    def set_mouse_enter(self, to_set):
        # type: (str)-> NoReturn
        self._mouse_enter = to_set
    
    
    def set_placement(self, to_set):
        # type: (str)-> NoReturn
        self._placement = '''shi-tip-placement="%s"''' % to_set
    
    
    def set_type(self, to_set):
        # type: (str)-> NoReturn
        self._type = '''shi-tip-type="%s"''' % to_set
    
    
    def set_html(self, to_set):
        # type: (str)-> NoReturn
        self._html = '''shi-tip-html="%s"''' % to_set
    
    
    def set_condition_type(self, to_set):
        # type: (str)-> NoReturn
        self._condition_type = '''shi-tip-condition-type="%s"''' % to_set
    
    
    def set_condition_value(self, to_set):
        # type: (str)-> NoReturn
        self._condition_value = '''shi-tip-condition-value="%s"''' % to_set
    
    
    def get_html(self):
        # type: ()-> str
        return '''onmouseenter="%s" onmouseleave="%s" %s %s %s %s %s''' % (self._mouse_enter, self._mouse_leave, self._placement, self._type, self._html, self._condition_type, self._condition_value)
