SHINKEN.TOOLS.TEST_AUTO_PROPERTY = (function ( self ) {
    self.DOM                        = {};
    self.TEST                       = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.line                   = function ( property_name ) {
        return document.querySelector( '.shinken-element-property-line[data-name="' + property_name + '"]' );
    };
    self._getCounterError           = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-property-label .shinken-counter.shinken-error-counter' );
    };
    self._getCounterWarning         = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-property-label .shinken-counter.shinken-warning-counter' );
    };
    self._getLock                   = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-lock-cell' );
    };
    self._getRadioBtnContainer      = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-radio-list-container' );
    };
    self._getDefaultButton          = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-range-btn-default-container .shinken-radio-btn' );
    };
    self.DOM.inheritanceButton      = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-prop-cell-template .switch-button-wrapper' );
    };
    self.DOM.inheritanceButtonValue = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-prop-cell-template .shinken-heritance-value' );
    };
    //self._getMainInput                  = function ( property_name ) {
    //    return self.DOM.line( property_name ).querySelector( '.shinken-input' );
    //};
    self._getRangeInput                    = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-range-container input' );
    };
    self._getRadioButtons                  = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-btn-radio-container' );
    };
    self._getSelector                      = function ( property_name, selector_name, under_type ) {
        var _to_return = self.DOM.line( property_name ).querySelector( '.shinken-select-container[data-name="' + selector_name + '"]' );
        if ( under_type ) {
            _to_return = _to_return.querySelector( "." + under_type );
        }
        return _to_return;
    };
    self._getOption                        = function ( property_name, selector_name, option_name ) {
        var _to_return = self.DOM.line( property_name ).querySelector( '.shinken-select-container[data-name="' + selector_name + '"]' );
        return SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR._getOption( _to_return, option_name );
    };
    self._getPlusButton                    = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.container-btn-plus' );
    };
    self._getLinkButton                 = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-link-icon-container' );
    };
    self._getTagInformation                = function ( property_name ) {
        return self.DOM.line( property_name ).querySelector( '.shinken-information-tag' );
    };
    self.DOM.flatCheckValue = function ( property_override_name ) {
        return self.DOM.line( property_override_name ).querySelector( '.shinken-flat-check-value' );
    };
    //********************************************  ACTION VIA JS OBJECT   **************************************************//
    self.selectOptionInPropertySelector    = function ( timeout, property_name, selector_name, option_name ) {
        setTimeout( function () {
            var _prop = MANAGER.__instance_property_distributor.getElement( property_name );
            if ( _prop.selectors[ selector_name ] && DOM.Service.isVisible( _prop.selectors[ selector_name ].dom_element, 20 ) ) {
                _prop.clickOnItemSelector( option_name, null, _prop.selectors[ selector_name ] );
            }
        }, timeout );
        return 1000;
    };
    //self.clickOnForcedHelpButton        = function ( timeout, property_name ) {
    //    setTimeout( function () {
    //        var _property = MANAGER.__instance_property_distributor.findElement( property_name );
    //        _property.clickOnForcedHelpButton();
    //        SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( timeout, self._getMainInput( property_name ), 'mouseenter' );
    //    }, timeout );
    //    return 500;
    //};
    self.clickOnInheritanceButton         = function ( timeout, property_name ) {
        setTimeout( function () {
            self.DOM.inheritanceButton( property_name ).click();
        }, timeout );
        return 1000;
    };
    self.setValue                         = function ( timeout, property_name, value ) {
        setTimeout( function () {
            MANAGER.__instance_property_distributor.getElement( property_name ).setValueFromUser( value );
        }, timeout );
        return property_name === PROPERTY.CONST.NAME.USE ? 2500 : 1000;
    };
    self.clickOnDefaultButton             = function ( timeout, property_name ) {
        setTimeout( function () {
            self._getDefaultButton( property_name ).click();
        }, timeout );
        return 500;
    };
    self.clickOnRadioButton               = function ( timeout, property_name, button_name ) {
        setTimeout( function () {
            self._getRadioBtnContainer( property_name ).querySelector( '.shinken-button[value="' + button_name + '"]' ).click();
        }, timeout );
        return 500;
    };
    //********************************************  GETTER   **************************************************//
    self.getSaveValue                     = function ( property_name ) {
        return MANAGER.__instance_property_distributor.getElement( property_name ).getDataToSave();
    };
    self.setValueWithSynchro              = function ( timeout, property_name, value ) {
        self.setValue( timeout, property_name, value );
        return 4000;
    };
    self.isRangeValue                     = function ( timeout, property_name, value ) {
        setTimeout( function () {
            MANAGER.__instance_property_distributor.getElement( property_name ).setValueFromUser( value );
        }, timeout );
        return property_name === PROPERTY.CONST.NAME.USE ? 2500 : 500;
    };
    self._getLineObjects                  = function ( property_name ) {
        return MANAGER.__instance_property_distributor.getElement( property_name ).getAllComponents();
    };
    //********************************************  TEST   **************************************************//
    self.TEST.inheritanceButtonValueLabel = function ( timeout, property_name, text_expected ) {
        setTimeout( function () {
            var _dom = self.DOM.inheritanceButtonValue( property_name );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom.innerText, text_expected, "validMainInputContentDisplay" );
        }, timeout );
        return 50;
    };
    self.TEST.checkValueFlatCheckValue = function ( timeout, property_name, text_expected ) {
        setTimeout( function () {
            var _dom = self.DOM.flatCheckValue( property_name );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0,_dom, text_expected, "checkValueFlatCheckValue" );
        }, timeout );
        return 50;
    };
    self.testCounter                      = function ( timeout, property_name, error_expected, warning_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.hasCounterValue( 0, self._getCounterError( property_name ), error_expected );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.hasCounterValue( 0, self._getCounterWarning( property_name ), warning_expected );
        }, timeout );
        return 100;
    };
    self.hasPlusState                     = function ( timeout, property_name, state_expected ) {
        setTimeout( function () {
            if ( !MANAGER.__instance_property_distributor.getElement( property_name ).has_plus ) {
                state_expected = COMPONENT.CONST.BTN_STATE.DISABLED;
            }
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'statePlus', "" + state_expected, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self._getPlusButton( property_name ), "DISABLED" );
                    break;
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'statePlus', "" + state_expected, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self._getPlusButton( property_name ).querySelector( '.shinken-btn-plus-option[data-value="ON"]' ), "ON" );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( self._getPlusButton( property_name ).querySelector( '.shinken-btn-plus-option[data-value="OFF"]' ), "OFF" );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'statePlus', "" + state_expected, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( self._getPlusButton( property_name ).querySelector( '.shinken-btn-plus-option[data-value="ON"]' ), "ON" );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self._getPlusButton( property_name ).querySelector( '.shinken-btn-plus-option[data-value="OFF"]' ), "OFF" );
                    break;
            }
        }, timeout );
        return 500;
    };
    self.countProperty                    = function ( timeout, number_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( MANAGER.__instance_property_distributor.elements ), number_expected, 'MANAGER.__instance_property_distributor.elements' );
        }, timeout );
        return 100;
    };
    self.countWindow                      = function ( timeout, number_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( MANAGER.__instance_window_distributor.parent_windows[ MANAGER.__instance_element_distributor.current_element.uuid ].list ), number_expected, 'MANAGER.__instance_window_distributor.parent_windows[' + MANAGER.__instance_element_distributor.current_element.uuid + '].list' );
        }, timeout );
        return 100;
    };
    self.countPropertySet                 = function ( timeout, number_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( getCurrentObjectFromProperty() ), number_expected, 'getCurrentObjectFromProperty' );
        }, timeout );
        return 100;
    };
    self.validRadioButton                 = function ( dom_element, state, inner_text ) {
        var _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE;
        switch ( state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.INHERITANCE ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE_INHERITED;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.USER_SET ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET_NONE:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.NULL ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                if ( dom_element.getAttribute( "value" ) === PROPERTY.CONST.BUTTON_LABEL.DEFAULT ) {
                    _to_test = SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE;
                }
                break;
        }
        switch ( _to_test ) {
            case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "backgroundColor", "rgb(217, 217, 217)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(51, 51, 51)" );
                break;
            case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE_INHERITED:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "backgroundColor", "rgba(128, 0, 128, 0.65)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-active' );
                break;
            case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.ACTIVE:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "backgroundColor", "rgb(100, 99, 99)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(255, 255, 255)" );
                SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-active' );
                break;
        }
        SHINKEN.TOOLS.TEST_AUTO.__isVisibleAndHasInnerText( dom_element, inner_text );
    };
    self.validTagInformation              = function ( timeout, property_name, state ) {
        setTimeout( function () {
            var _dom_tag_info = self._getTagInformation( property_name );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "tag information" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_info, "tag information" );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.validLinkButton                = function ( timeout, property_name, state, uuid_link ) {
        setTimeout( function () {
            var _dom_link_button = self._getLinkButton( property_name );
            var _dom_link     = _dom_link_button.querySelector(".shinken-link");
            var _dom_icon     = _dom_link_button.querySelector(".shinken-link-icon-button");
            
            var _test_desc = "link button";
            var _is_visble = true;
            var _uuid_link = uuid_link || "";
            var _color = "rgb(0, 0, 0)";
            
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.HIDDEN:
                    _is_visble = false;
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.USER_SET:
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.USER_SET_NEW:
                    _uuid_link = _uuid_link + '?new=1';
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.INHERITED:
                    _color = "rgb(128, 0, 128)";
                    break;
                
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_LINK_BUTTON.INHERITED_NEW:
                    _color = "rgb(128, 0, 128)";
                    _uuid_link = _uuid_link + '?new=1';
                    break;
            }
            if (!_is_visble && _uuid_link ){
                SHINKEN.TOOLS.TEST_AUTO.addError(  "Link button are not visible but he have a link" );
            }
            if (_is_visble) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_icon, 'color', _color );
                SHINKEN.TOOLS.TEST_AUTO.__containsText( _dom_link.href, _uuid_link, _test_desc );
            }
            SHINKEN.TOOLS.TEST_AUTO_DOM.visibility( 0, _dom_link_button, _test_desc, _is_visble );
            
            
            
        }, timeout );
        return 10;
    };
    self.validSavePropertyValue           = function ( timeout, property_name, value_expected, extra_label ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( self.getSaveValue( property_name ), value_expected, extra_label );
        }, timeout );
        return 10;
    };
    //self.validTooltipPropertyValue      = function ( timeout, property_name, text_expected ) {
    //    setTimeout( function () {
    //        SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( timeout, self._getMainInput( property_name ), 'mouseenter' );
    //        SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.containsText( timeout, text_expected );
    //    }, timeout );
    //    return 10;
    //};
    //self.validValidationValue           = function ( timeout, property_name, value_to_set, error_expected, warning_expected, tooltip_text_expected ) {
    //    setTimeout( function () {
    //        self.setValue( timeout, property_name, value_to_set );
    //        self.testCounter( timeout, property_name, error_expected, warning_expected );
    //        self.validTooltipPropertyValue( timeout, property_name, tooltip_text_expected );
    //    }, timeout );
    //    return 10;
    //};
    
    self.isDisabled            = function ( timeout, property_name, extra_label ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasClass( timeout, self.DOM.line( property_name ), 'shinken-disabled', false, extra_label );
        }, timeout );
        return 500;
    };
    self.isLockDisplayed       = function ( property_name, show, timeout ) {
        setTimeout( function () {
            if ( show ) {
                SHINKEN.TOOLS.TEST_AUTO.__isVisible( self._getLock( property_name ) );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self._getLock( property_name ) );
            }
        }, timeout );
        return 500;
    };
    self.isState               = function ( timeout, property_name, state ) {
        setTimeout( function () {
            switch ( state ) {
                case PROPERTY.CONST.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.line( property_name ) );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'state', state, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( MANAGER.__instance_property_distributor.getElement( property_name ), 'state', state, '[--2--]' );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.isLabelDefaultButton  = function ( timeout, property_name, inner_text ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self._getDefaultButton( property_name ), inner_text, property_name );
        }, timeout );
        return 10;
    };
    self.hasStyleDefaultButton = function ( timeout, property_name, key, value ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self._getDefaultButton( property_name ), key, value );
        }, timeout );
        return 10;
    };
    self.CONST                 = {
        UNDER_SELECTOR: {
            SELECTOR      : "shinken-select-selector",
            SELECTOR_TITLE: "shinken-multiselect-title",
            SELECTOR_LABEL: "shinken-selector-label",
            LIST_SELECT   : "shinken-list-select",
            FILTER_INPUT  : "shinken-input-search"
        }
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PROPERTY || {} );

SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST = {
    ACTION_SELECTOR_USER_SET: "rgba(30, 30, 30, 0.8)",
    STATE_BUTTON            : {
        HIDDEN          : 0,
        VISIBLE         : 1,
        ACTIVE          : 2,
        ACTIVE_INHERITED: 3,
        DISABLED        : 4
    },
    STATE_LINK_BUTTON       : {
        HIDDEN       : 0,
        USER_SET     : 1,
        USER_SET_NEW : 2,
        INHERITED    : 3,
        INHERITED_NEW: 4
    }
};