SHINKEN.TOOLS.TEST_AUTO_SOURCE = (function ( self ) {
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.getDomWrapper                    = function () {
        return document.getElementById( 'wrapper' );
    };
    self.getWindowGroupDom                = function () {
        return document.querySelector( ".shinken-source-navigation-container .shinken-window-group" );
    };
    self.getWindowsDom                    = function () {
        return self.getWindowGroupDom().querySelectorAll( ".shinken-window-element" );
    };
    self.getForceImportButton             = function () {
        return document.querySelector( ".shinken-play-import-source" );
    };
    self.getSourceName                    = function () {
        return self.getDomWrapper().dataset[ 'sourceName' ];
    };
    //********************************************  ACTION   **************************************************//
    self.switchSourceActivity             = function ( timeout, source_name, only_if_inactive ) {
        var _to_return = 2000;
        var _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout,  'switchSourceActivity', 'only_if_inactive = ' + only_if_inactive );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _source             = MANAGER.__instance_source_distributor.findSource( source_name );
            if ( only_if_inactive && _source.isActive() ){
            }
            else {
            _source.toggleEnable();
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.navigateInTab                    = function ( timeout, tab_name ) {
        setTimeout( function () {
            document.getElementById( WINDOW.CONST.ID.TAB_PANE + tab_name ).click();
        }, timeout );
        return 100;
    };
    self.forceImport                      = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.getForceImportButton() );
        }, timeout );
        return 100;
    };
    //********************************************  TEST   **************************************************//
    self.validNumberTabs                  = function ( timeout, nb_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.getWindowsDom(), nb_expected, "nb windows element" );
        }, timeout );
        return 100;
    };
    //self.validConfigurationFormProperties = function ( timeout ) {
    //    setTimeout( function () {
    //        SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( timeout, document.getElementById( 'id-shinken-configuration-form-container' ), "Formulaire de configuration" );
    //        SHINKEN.TOOLS.TEST_AUTO_PROPERTY.countProperty( timeout, 27 );
    //        SHINKEN.TOOLS.TEST_AUTO_PROPERTY.validSavePropertyValue( timeout, 'name', self.getSourceName(), "Le nom de la source" );
    //        SHINKEN.TOOLS.TEST_AUTO_PROPERTY.isDisabled( timeout, 'module_type', "la propriété module_type" );
    //        SHINKEN.TOOLS.TEST_AUTO_PROPERTY.validValidationValue( timeout, 'downtime_on_delete_element_author', "shinken-test-auto><", 1, 0, "Les caractères `~!$%^&*\"'|<>?,()=/+ sont interdits dans ce champ" );
    //        SHINKEN.TOOLS.TEST_AUTO_PROPERTY.validValidationValue( timeout, 'downtime_on_delete_element_duration', "shinken-test-auto", 1, 0, _( 'element.tooltip_no_letter_2' ) );
    //    }, timeout );
    //    return 100;
    //};
    //self.validConfigurationFormHelp       = function ( timeout ) {
    //    setTimeout( function () {
    //        var _help_container = document.getElementById( 'id-shinken-help-container' );
    //        SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( timeout, _help_container, "Aide" );
    //        SHINKEN.TOOLS.TEST_AUTO_PROPERTY.clickOnForcedHelpButton( timeout, 'name' );
    //        setTimeout( function () {
    //            SHINKEN.TOOLS.TEST_AUTO_DOM.isText( timeout, _help_container.querySelector( '.shinken-help-content-container' ), "Nom de la source affichée dans l'UI de configuration en page d'accueil. Doit être unique et d'une longueur inférieure à 40 caractères.", "Aide" );
    //        }, timeout);
    //
    //    }, timeout );
    //    return 100;
    //};
    
    self.validConfigurationFormHeader       = function ( timeout ) {
        setTimeout( function () {
            var _dom_header = document.querySelector( '#id-shinken-source-configuration-container .shinken-header-row' );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( timeout, _dom_header );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom_header, "backgroundColor", "rgba(30, 30, 30, 0.8)", "Source configuration header" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _dom_header, "height", "37px", "Source configuration header" );
        }, timeout );
        return 200;
    };
    self.validForceImportButtonStatus       = function ( timeout, state_expected ) {
        setTimeout( function () {
            var _dom = self.getForceImportButton();
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom, "Button force import" );
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.5" );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "1" );
                    break;
            }
        }, timeout );
        return 100;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SOURCE || {} );



