'use strict';

COMPONENT.ListTag           = function ( dom_element, parent_name ) {
    // dom_element
    // tags
    // tags_mapping
    // size_tags
    // dragged_tag
    this.init( dom_element, parent_name );
    
};
COMPONENT.ListTag.prototype = {
    init                          : function ( dom_element, parent_name ) {
        this.dom_element = dom_element;
        this.initTags( parent_name );
    },
    initTags                      : function ( parent_name ) {
        this.tags         = [];
        this.tags_mapping = {};
        
        var _list_tags_element = this.dom_element.querySelectorAll( '.shinken-container-tag' );
        if ( !_list_tags_element ) {
            this.size_tags = 0;
            return;
        }
        
        this.size_tags = _list_tags_element.length;
        for ( var i = 0; i < this.size_tags; i++ ) {
            this.tags[ i ]                                = new COMPONENT.Tag( _list_tags_element[ i ], parent_name );
            this.tags_mapping[ this.tags[ i ].getName() ] = i;
        }
    },
    reset                         : function () {
        this.tags         = [];
        this.tags_mapping = {};
        this.size_tags    = 0;
    },
    addTag                        : function ( parent_name, element_list ) {
        fire_element_is_modifie();
        var _tag = new COMPONENT.Tag();
        _tag.setElement( element_list );
        var _dom_to_add = _tag.buildHTMLParent( parent_name, this.size_tags, element_list.getItemType() );
        _tag.setTooltip();
        this.tags[ this.size_tags ]         = _tag;
        this.tags_mapping[ _tag.getName() ] = this.size_tags;
        DOM.Service.addElementTo( _dom_to_add, this.dom_element );
        this._computeMapping();
    },
    deleteTag                     : function ( element_list ) {
        fire_element_is_modifie();
        var _name  = element_list.getName();
        var _tag   = this.getTagByName( _name );
        var _index = this.tags_mapping[ _name ];
        DOM.Service.removeParentIfHasClassOrElement( _tag.getDomElement(), 'droppable' );
        this.tags.splice( _index, 1 );
        this._computeMapping();
    },
    _computeMapping               : function () {
        this.size_tags    = this.tags.length;
        this.tags_mapping = {};
        for ( var i = 0; i < this.size_tags; i++ ) {
            this.tags_mapping[ this.tags[ i ].getName() ] = i;
            this.tags[ i ].setIndexParentDomElement( i );
        }
        if ( this.isEmpty() ) {
            this.dom_element.classList.add( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-hidden' );
        }
    },
    addTags                       : function ( tags ) {
        this.tags      = [];
        this.size_tags = tags.length;
        var _current;
        for ( var i = 0; i < this.size_tags; i++ ) {
            _current = tags[ i ].clone();
            var _add = true;
            for ( var j = 0, _size = this.tags.length; j < _size; j++ ) {
                if ( this.tags[ j ].getName() === _current.getName() ) {
                    _add = false;
                    break;
                }
            }
            if ( _add ) {
                this.tags.push( _current );
                this.dom_element.appendChild( _current.getDomElement() );
            }
        }
        this._computeMapping();
    },
    getTagByName                  : function ( key_name ) {
        var _index = this.tags_mapping[ key_name ];
        if ( _index === undefined ) {
            return null;
        }
        return this.getTagByIndex( _index );
    },
    getTagByIndex                 : function ( index ) {
        return this.tags[ index ];
    },
    isEmpty                       : function () {
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( !this.tags[ i ].isHidden() ) {
                return false;
            }
        }
        return true;
    },
    emptyList                     : function () {
        this.reset();
        this.dom_element.innerHTML = '';
    },
    getValue                      : function () {
        var _to_return = '';
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( i ) {
                _to_return += ',';
            }
            _to_return += this.getTagByIndex( i ).getName();
        }
        return _to_return;
    },
    getTags                       : function () {
        return this.tags;
    },
    hasTag                        : function ( key_name ) {
        return this.tags_mapping[ key_name ] !== undefined;
    },
    getSizeTags                   : function () {
        return this.size_tags;
    },
    hasUserTag                    : function () {
        for ( var i = 0; i < this.size_tags; i++ ) {
            switch ( this.tags[ i ].element.name ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    break;
                default:
                    return true;
            }
        }
        return false;
    },
    getMissingItemSelectorWith    : function ( property ) {
        var _to_return = [];
        var _selected  = Object.keys( property.getSelector().list_element_selected.tags_mapping );
        var _size = _selected.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = _selected[ i ];
            if ( _current === PROPERTY.CONST.CUSTOM_SELECT.NONE ||
                 _current === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ||
                 _current === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ) {
                continue;
            }
            if ( this.tags_mapping[ _current ] === undefined ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    getExtraItemSelectorWith      : function ( property ) {
        var _to_return             = [];
        var _property_tags_mapping = property.getSelector().list_element_selected.tags_mapping;
        var _selected              = Object.keys( this.tags_mapping );
        var _size                  = _selected.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = _selected[ i ];
            if ( _property_tags_mapping[ _current ] === undefined ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    dragStartShinken              : function ( key_name ) {
        this.dragged_tag = this.getTagByName( key_name );
        this.dragged_tag.setDragging( true );
        return this;
    },
    getDragged                    : function () {
        return this.dragged_tag;
    },
    //allowDrop: function( e ) {
    //    e.preventDefault();
    //},
    resetDragging                 : function () {
        if ( this.dragged_tag ) {
            this.dragged_tag.setDragging( false );
            this.dragged_tag = null;
        }
    },
    changeElementPosition         : function ( index_1, index_2 ) {
        index_1 = parseInt( index_1 );
        index_2 = parseInt( index_2 );
        if ( index_1 < index_2 ) {
            for ( var i = index_1, _size = index_2; i < _size; i++ ) {
                this.switchElement( i, i + 1 );
            }
        }
        else if ( index_1 > index_2 ) {
            for ( var i = index_1 - 1, _size = index_2; i >= _size; i-- ) {
                this.switchElement( i, i + 1 );
            }
        }
    },
    switchElement                 : function ( index_1, index_2 ) {
        var _element_1 = this.getTagByIndex( index_1 );
        var _element_2 = this.getTagByIndex( index_2 );
        if ( !_element_1 || !_element_2 ) {
            return;
        }
        DOM.Service.switchElementParent( _element_1.getDomElement(), _element_2.getDomElement() );
        SHINKEN.TOOLS.ARRAY.swap( this.tags, index_1, index_2 );
        this.tags_mapping[ _element_1.getName() ] = index_2;
        this.tags_mapping[ _element_2.getName() ] = index_1;
    },
    disabledTagsOutOfLimit        : function ( limit ) {
        var _stop = this.size_tags;
        if ( limit >= 0 ) {
            _stop = this.size_tags - limit;
            _stop = (_stop >= 0) ? _stop : this.size_tags;
        }
        var i;
        var _current;
        for ( i = 0; i < _stop; i++ ) {
            _current = this.getTagByIndex( i );
            _current.removeClass( 'disabled' );
            _current.setMessageTooltip( '' );
        }
        for ( i = this.size_tags - 1; i >= _stop; i-- ) {
            _current = this.getTagByIndex( i );
            _current.addClass( 'disabled' );
            _current.setMessageTooltip( _( 'property_multiselect.tooltip_limit_reached' ) );
        }
    },
    getErrors                     : function ( prop_name ) {
        var _to_return = 0;
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( this.getTagByIndex( i ).isError( prop_name ) ) {
                _to_return++;
            }
        }
        return _to_return;
    },
    getWarnings                   : function ( prop_name ) {
        var _to_return = 0;
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( this.getTagByIndex( i ).isWarning( prop_name ) ) {
                _to_return++;
            }
        }
        return _to_return;
    },
    isAllElementsSelectedDisabled : function () {
        var _size = this.tags.length;
        var _current_element;
        if ( !_size ) {
            return false;
        }
        for ( var i = 0; i < _size; i++ ) {
            _current_element = this.tags[ i ].element;
            if ( !_current_element.is_disabled &&
                 _current_element.state !== COMPONENT.CONST.TAG.STATE.NEW &&
                 _current_element.state !== COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
                return false;
            }
        }
        return true;
    },
    hasInvalidElementForProduction: function () {
        var _size = this.tags.length;
        var _current_element;
        if ( !_size ) {
            return false;
        }
        for ( var i = 0; i < _size; i++ ) {
            _current_element = this.tags[ i ].element;
            if ( _current_element.is_disabled ||
                 _current_element.state === COMPONENT.CONST.TAG.STATE.NEW ||
                 _current_element.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
                return true;
            }
        }
        return false;
    },
    //********************************************  GETTER  **************************************************//
    getListToString               : function ( prop_name ) {
        var _to_return = [];
        for ( var i = 0; i < this.size_tags; i++ ) {
            _to_return.push( this.tags[ i ].getName() );
        }
        return _to_return;
    }
};

