'use strict';

MANAGER.ListenerEventManager = {
    askAfterActionProperty                     : function ( property ) {
        var self = this;
        if ( property.time_out_ask_after_action ) {
            clearTimeout( property.time_out_ask_after_action );
        }
        property.time_out_ask_after_action = setTimeout( function () {
            property.time_out_ask_after_action = null;
            self.afterActionProperty( property );
        }, 200 );
    },
    afterActionProperty                        : function ( property ) {
        this.synchronizeAfterEvent( property );
        this.afterActionGlobal( property );
    },
    afterAction                                : function ( type, param1 ) {
        switch ( type ) {
            case MANAGER.CONST.AFTER_ACTION.CLICK_ON_SERVICE_OVERRIDE:
                var property = MANAGER.__instance_property_distributor.findElement( 'use' );
                this.setDisabledBecauseOverrideOpen( property );
                break;
            case MANAGER.CONST.AFTER_ACTION.UPDATE_VIEW_ON_WINDOW_PROPERTIES:
                MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.INIT );
                var _props = MANAGER.__instance_property_distributor.getAllElementsByTabParentName( param1 );
                for ( var i = 0, _size = _props.length; i < _size; i++ ) {
                    _props[ i ].updateView();
                }
                MANAGER.__instance_element_distributor.current_element.setPhase( MANAGER.__instance_element_distributor.current_element.phase.previous_phase );
                break;
        }
    },
    setDisabledBecauseOverrideOpen             : function ( property ) {
        property.setIsDisable( true );
        var _dom_element   = property.dom_element;
        var _property_data = _dom_element.getElementsByClassName( 'shinken-prop-cell-action-content' )[ 0 ];
        _property_data.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
        _property_data.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        _property_data.setAttribute( 'shi-tip-html', SHINKEN.TOOLS.STRING.format( _( 'element.use_cannot_be_modified' ) ) );
        
        var list_dom_element_with_tooltip = _property_data.querySelectorAll( "[shi-tip-html]" );
        var _current_dom_element;
        for ( var i = 0, _size = list_dom_element_with_tooltip.length; i < _size; i++ ) {
            _current_dom_element = list_dom_element_with_tooltip[ i ];
            DOM.Service.removeAttribute( _current_dom_element, "onmouseenter" );
            DOM.Service.removeAttribute( _current_dom_element, "onmouseleave" );
        }
        
    },
    synchronizeAfterEvent                      : function ( property ) {
        if ( property.stop_synchronization ) {
            property.stop_synchronization = false;
            return;
        }
        var _object;
        var property_name = property.getName();
        if ( property.is_override ) {
            property_name = property.override_prop_name;
        }
        var _object_to_link = this.getObjectLink( property );
        var _switch_on      = true;
        var _size           = _object_to_link.length;
        var i               = 0;
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
            case PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS:
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                _switch_on = false;
            case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME:
            case PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE:
            case PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK:
            case PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK:
                for ( ; i < _object_to_link.length; i++ ) {
                    _object = MANAGER.__instance_property_distributor.findElement( _object_to_link[ i ] );
                    _object.synchronize( property, _switch_on );
                }
                break;
            case PROPERTY.CONST.NAME.USE:
                if ( property.is_mass_change ) {
                    PROPERTY.UserRightsBehaviourMassChange.askAddActionConsistency( property );
                }
                else {
                    for ( ; i < _size; i++ ) {
                        _object = MANAGER.__instance_property_distributor.findElement( _object_to_link[ i ] );
                        this.synchronizeAfterEvent( _object );
                    }
                }
                break;
            
        }
    },
    afterActionGlobal                          : function ( property ) {
        var _object;
        var property_name = property.getName();
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.SERVICE_EXCLUDES:
                if ( property.is_mass_change ) {
                    CONTROLLER.MassChange.setExcludeByName( property.getValue() );
                }
                else {
                    App.Elements.ChecksTab.updateExcludeStatus();
                }
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                _object = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
                _object.updateView();
                break;
            case PROPERTY.CONST.NAME.USE:
                var _check_nb_label = property.dom_element.querySelectorAll( ".shinken-checks-tag-label" );
                for ( var i = 0, _size_i = _check_nb_label.length; i < _size_i; i++ ) {
                    DOM.Service.removeElement( _check_nb_label[ i ] );
                }
                if ( !property.is_mass_change ) {
                    updateALLTemplateAndCheckDatas();
                }
                break;
            case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
                if ( property.isSetOrIsSetFromTemplate() ) {
                    var _list_tag = document.querySelectorAll( '.shinken-tag-modulation' );
                    for ( var i = 0, _size = _list_tag.length; i < _size; i++ ) {
                        _list_tag[ i ].classList.remove( 'shinken-hidden' );
                    }
                }
                break;
            case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
                if ( !property.is_mass_change ) {
                    App.Elements.ChecksTab.computeModulationTag();
                }
                break;
        }
        if ( property.is_override ) {
            var override_property_name = property.override_prop_name;
            var _check_in_host         = App.Elements.ChecksTab.getCheckInHostElement( property.override_check_uuid_final );
            switch ( override_property_name ) {
                case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
                case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
                    var _id          = App.Elements.ChecksTab.buildIdTagModulation( _check_in_host );
                    var _tag_needed  = App.Elements.ChecksTab.isTagModulationNeeded( _check_in_host, property );
                    var _dom_element = document.getElementById( _id );
                    if ( _tag_needed ) {
                        _dom_element.classList.remove( 'shinken-hidden' );
                    }
                    else {
                        _dom_element.classList.add( 'shinken-hidden' );
                    }
                    break;
                case PROPERTY.CONST.NAME.CONTACT_GROUPS:
                    _check_in_host.updateHtmlGroupAfterChange();
                    break;
            }
            _check_in_host.updateOverrideStatus();
            App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
        }
        if ( property.is_mass_change ) {
            var _to_set = property.getDataToSaveMassChange() ? 1 : 0;
            if ( property.is_mass_change_deleted ) {
                _to_set = 0;
            }
            property.getCounterUserSet().update( property.getNameOrUUID(), _to_set );
            if ( property.type === PROPERTY.CONST.TYPES.DATA ) {
                if ( !property.is_mass_change_deleted ) {
                    if ( property.status === PROPERTY.CONST.DATA.STATUS.NEW ) {
                        CONTROLLER.MassChange.updateDataUserCounter( property.uuid, _to_set );
                    }
                    else {
                        CONTROLLER.MassChange.updateDataUserCounter( property.name, _to_set );
                    }
                }
            }
            var _button = CONTROLLER.MassChange.steps.getNextButton();
            if ( _button.user_set.counter_final && !_button.errors.counter_final ) {
                _button.dom_element.classList.remove( "shinken-disabled" );
            }
            else {
                _button.dom_element.classList.add( "shinken-disabled" );
            }
        }
        
        if ( property_name === MANAGER.__instance_element_distributor.current_element.key_name ) {
            var property_value                                                = SHINKEN.TOOLS.STRING.replaceAll( property.getValue(), SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE, SHINKEN.TOOLS.STRING.CONST.NON_BREAK_SPACE );
            document.getElementById( 'shinken-title-page-edition' ).innerText = property_value;
            if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
                App.Elements.ChecksTab.updateCurrentElementName( property_value );
            }
            if ( MANAGER.__instance_element_distributor.current_element.is_dfe ) {
                var _message = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( property.component_input.key_validation, property.component_input.getValue() );
                _message.addMessage( COMPONENT.CONST.STATUS.BEWARE, _( 'element.tooltip_dfe_deleted_part_3' ) );
                _message.footer = _( 'element.tooltip_dfe_deleted_part_2' );
                _message.buildMessage();
                property.component_input.setMessage( _message );
            }
        }
    },
    getObjectLink                              : function ( property ) {
        var _to_return    = [];
        var property_name = property.getName();
        if ( property.is_override ) {
            property_name = property.override_prop_name;
        }
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.EDITION_CONTACTS;
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS;
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.VIEW_CONTACTS;
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS;
                break;
            case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME:
            case PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE:
            case PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK:
            case PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS;
                break;
            case PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE;
                _to_return[ 2 ] = PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK;
                _to_return[ 3 ] = PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK;
                break;
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE;
                break;
            case PROPERTY.CONST.NAME.USE:
                if ( MANAGER.__instance_element_distributor.current_element.canHaveUserRights() ) {
                    _to_return[ 0 ] = PROPERTY.CONST.NAME.VIEW_CONTACTS;
                    _to_return[ 1 ] = PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS;
                }
                break;
        }
        if ( property.is_override ) {
            for ( var i = 0, _size_return = _to_return.length; i < _size_return; i++ ) {
                _to_return[ i ] = PROPERTY.BuildOverrideName( _to_return[ i ], property );
            }
        }
        return _to_return;
    },
    //********************************************  MASS_CHANGE  **************************************************//
    clickOnDeleteItemSelectorMassChange        : function ( property, key_name ) {
        this._synchronizeMassChangesSelector( property.getSelector(), key_name, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ], PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE );
        if ( property.synchronized_elements ) {
            this.updateSynchronizedTags( property, key_name );
        }
    },
    clickOnItemSelectorMassChange              : function ( property, target_component, key_name, dom_element ) {
        switch ( target_component ) {
            case property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ]:
                property.unset();
                switch ( property.type ) {
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].cleanAllItemsSelected( "shinken-selected-mass-change" );
                        property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].cleanAllItemsSelected( "shinken-selected-mass-change" );
                        break;
                }
                break;
            case property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ]:
                this._synchronizeMassChangesSelector( target_component, key_name, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ] );
                break;
            case property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ]:
                if ( property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getLastSelectedElement().element.name === PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE ) {
                    this._synchronizeMassChangesSelector( target_component, key_name, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ] );
                }
                else {
                    this._synchronizeMassChangesSelector( target_component, key_name, property.getSelector() );
                }
                break;
            case property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ]:
                if ( target_component.getValue() === PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON ) {
                    switch ( property.last_list_element_selected ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                            property.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE, null, property.getSelector() );
                            break;
                    }
                }
                break;
            case property.getSelector():
                switch ( property.type ) {
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        this._synchronizeMassChangesSelector( target_component, key_name, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ], PROPERTY.CONST.MASS_CHANGE.ACTION.ADD );
                        break;
                }
                if ( property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] && property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() === PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON ) {
                    switch ( key_name ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                            property.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] );
                            break;
                    }
                }
                break;
            default:
                break;
        }
    },
    _synchronizeMassChangesSelector            : function ( target_component, key_name, selector, action ) {
        switch ( target_component.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                var _elem = selector.list_element.list[ selector.list_element.list_mapping[ key_name ] ];
                if ( _elem ) {
                    _elem.setSelected( action === PROPERTY.CONST.MASS_CHANGE.ACTION.ADD, "shinken-selected-mass-change" );
                }
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                if ( target_component.previous_selected_key_name ) {
                    var _previous_key_dom_element = selector.list_element.list[ selector.list_element.list_mapping[ target_component.previous_selected_key_name ] ];
                    _previous_key_dom_element.setSelected( false, "shinken-selected-mass-change" );
                }
                if ( key_name !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                    selector.list_element.list[ selector.list_element.list_mapping[ key_name ] ].setSelected( true, "shinken-selected-mass-change" );
                }
                break;
        }
    },
    _synchronizeMassChangesSelectorAfterSynchro: function ( property, property_synchro, list_to_change, is_remove ) {
        //MANAGER.__instance_property_distributor.elements["view_contacts"].selectors["main-selector"].list_element.list[9].reason_to_set
        var _action = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        var _values = [];
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                _values = property.getSplitValueUser();
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                _values = [property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue(), property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue()];
                break;
        }
        var _current_name;
        for ( var i = 0, _size_i = list_to_change.length; i < _size_i; i++ ) {
            _current_name = list_to_change[ i ].getName();
            this.setSelectedMassChange( property, _current_name, is_remove, property_synchro );
            if ( SHINKEN.TOOLS.ARRAY.contains( _values, _current_name ) ) {
                switch ( _action ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                        property.clickOnDeleteItemSelector( _current_name );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                        list_to_change[ i ].dom_element.classList.add( "shinken-tag-disabled" );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                        property.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                        break;
                }
            }
        }
    },
    setSelectedMassChange                      : function ( property, current_name, is_remove, property_synchro ) {
        var _current_list = property.getSelector().list_element;
        _current_list.list[ _current_list.list_mapping[ current_name ] ].setSelected( !is_remove, "shinken-selected-mass-change", property_synchro.getName() );
        _current_list = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].list_element;
        _current_list.list[ _current_list.list_mapping[ current_name ] ].setSelected( !is_remove, "shinken-selected-mass-change", property_synchro.getName() );
        _current_list = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].list_element;
        _current_list.list[ _current_list.list_mapping[ current_name ] ].setSelected( !is_remove, "shinken-selected-mass-change", property_synchro.getName() );
    },
    updateSynchronizedTags                     : function ( property, key_name ) {
        var _keys = Object.keys( property.synchronized_elements );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = property.synchronized_elements[ _keys[ i ] ];
            for ( var j = 0, _size_j = _current.length; j < _size_j; j++ ) {
                if ( _current[ j ].getName() === key_name ) {
                    _current[ j ].dom_element.classList.remove( "shinken-tag-disabled" );
                }
            }
        }
    }
};