'use strict';

OBJECT.CheckInPageHost            = function( shinken_element, parent, dfe_object ) {
    //dom_element
    //dom_element_command
    //is_dfe
    //name
    //uuid
    //key_dfe
    //has_error_dfe
    //has_warning_proctected_dfe
    this.element = shinken_element;
    this.init( parent );
    this.setDfeObject( dfe_object );
};
OBJECT.CheckInPageHost.prototype  = {
    init                                : function ( parent ) {
        this.uuid          = this.element.uuid;
        this.name          = this.element.service_description;
        this.parent_name   = parent.getName();
        this.parent_uuid   = parent.uuid;
        this.key_dfe       = "";
        this.is_dfe        = !!this.element.is_dfe;
        this.name_check    = this.element.service_description;
        this.has_error_dfe = false;
        this.has_warning_proctected_dfe = false;
        this.initCounters( parent );
        this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.NONE );
        this.is_bp_rule_command = false;
        if ( this.element && this.element[ PROPERTY.CONST.NAME.CHECK_COMMAND ] && this.element[ PROPERTY.CONST.NAME.CHECK_COMMAND ].split( '!' )[ 0 ] === 'bp_rule' ) {
            this.is_bp_rule_command = true;
        }
        this.getExcludeStatus();
    },
    linkDomElements                     : function () {
        this.dom_element                     = document.getElementById( 'id-shinken-check-line-' + this.getDomUUID() );
        this.dom_element_command             = this.dom_element.querySelector( '.shinken-tab-check-col-command-data' );
        this.dom_element_name                = this.dom_element.querySelector( '.shinken-tab-check-col-name' );
        this.dom_element_tags                = this.dom_element.querySelector( '.shinken-tab-check-col-tags' );
        this.dom_element_group_notification  = this.dom_element.querySelector( '.shinken-tab-check-col-contacts-groups' );
        this.dom_element_hidden              = this.dom_element.querySelector( '.shinken-check-hidden' );
        this.dom_element_dfe                 = this.dom_element.querySelector( '.shinken-tab-check-col-dfe' );
        this.dom_element_try_check_container = document.getElementById( 'tr-check-run-' + this.getDomUUID() );
        this.dom_element_try_check_close_btn = this.dom_element.querySelector( '.shinken-hide-eval' );
        this.initCountersDom();
        this.button_override = new COMPONENT.Button( this.dom_element.querySelector( '.shinken-check-override-tag.shinken-overridden' ) );
        this.button_override.initCounters();
        this.button_override.getCounterError().setLabel( _( 'element.errors' ) );
        this.button_override.getCounterWarning().setLabel( _( 'source.warnings' ) );
        //only warning and errors should be propaged
        this.button_override.getCounterError().setParent( this.getCounterError() );
        this.button_override.getCounterWarning().setParent( this.getCounterWarning() );
        
        this.tag_information = new COMPONENT.TagInformation( this.dom_element.querySelector( '.shinken-information-tag' ) );
        switch ( this.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                this.tag_information.setParams( [this.parent_name] );
                this.tag_information.setStatus( COMPONENT.CONST.TAG_INFORMATION.STATUS.CHECK_DUPLICATE );
                break;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
                break;
        }
    },
    setDfeObject                        : function ( to_set ) {
        this.dfe_object        = to_set || '';
        this.dfe_property      = this.dfe_object ? this.dfe_object.property_name : '';
        this.dfe_property_name = this.dfe_property ? this.dfe_property.substr( 1 ) : '';
        this.is_duplicate      = false;
        if ( this.dfe_object.is_duplicate && this.dfe_object.key ) {
            this.is_duplicate = true;
        }
        if ( this.is_dfe ) {
            this.has_error_dfe = false;
            this.key_dfe       = this.dfe_object.key;
            if ( this.is_duplicate ) {
                this.name = this.name_check.replace( '$KEY$', this.dfe_object.key );
            }
            else if ( this.dfe_object._messages.hasError() ) {
                this.has_error_dfe = true;
                this.name          = this.name_check.replace( '$KEY$', "<span class='shinken-error-tag'>$KEY$</span>" );
            }
            else if ( this.dfe_object.is_dfe_protected ) {
                this.has_warning_proctected_dfe = true;
                this.name                       = this.name_check.replace( '$KEY$', "<span class='shinken-warning-tag'>$KEY$</span>" );
            }
            else {
                this.name = this.name_check.replace( '$KEY$', this.dfe_object.key );
            }
            App.DFE.getDefaultArgsByCheck( this.dfe_object, this.element );
            this.getExcludeStatus();
        }
        
    },
    setStatus                           : function ( to_set, forced ) {
        if ( to_set === OBJECT.CONST.CHECK_IN_HOST.STATUS.NONE && this.is_dfe && this.status === OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE && !forced ) {
            return;
        }
        this.status = to_set;
        this.setError( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME, this.status === OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME ? 1 : 0 );
        this.buildClass();
        this.computeCounters();
    },
    getDomUUID                          : function () {
        if ( this.is_dfe ) {
            if ( this.dfe_object && this.dfe_object._messages && this.dfe_object._messages.hasError() ){
                return this.parent_uuid + '-' + this.uuid + '-' + SHINKEN.TOOLS.STRING.cleanXss(this.key_dfe);
            }
            return this.parent_uuid + '-' + this.uuid + '-' + this.key_dfe;
        }
        return this.parent_uuid + '-' + this.uuid;
    },
    
    changeExcludeStatus                 : function () {
        MANAGER.__instance_element_distributor.current_element.changeExcludeStatus( this );
        this.updateExcludeStatus();
        fire_element_is_modifie();
        App.Elements.ChecksTab.computeCheckNameIfAlreadyExist();
    },
    getExcludeStatus                    : function () {
        this.exclude_status = MANAGER.__instance_element_distributor.current_element.getExcludeStatus( this );
        if ( this.exclude_status === OBJECT.CONST.EXCLUDE_STATUS.OFF ) {
            var _service_exclude = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.SERVICE_EXCLUDES );
            if ( _service_exclude ) {
                var _exclude_by_name = _service_exclude.getFlatValue();
                if ( this.isNameMatching( _exclude_by_name ) ) {
                    this.exclude_status = OBJECT.CONST.EXCLUDE_STATUS.BY_NAME;
                }
            }
        }
        this.computeCounters();
        return this.exclude_status;
    },
    isNameMatching                      : function ( name_to_test ) {
        return SHINKEN.TOOLS.STRING.isMatchingStarRegexTab( this.name, name_to_test.split( ',' ) );
    },
    updateHtmlNameAfterChange           : function () {
        if ( !this.dom_element_name ) {
            return;
        }
        var _name                       = this.buildNameHtml();
        this.dom_element_name.innerHTML = _name.innerHTML;
    },
    updateTooltipExcludeByName          : function () {
        if ( this.exclude_status === OBJECT.CONST.EXCLUDE_STATUS.BY_NAME ) {
            var _tooltip_container = this.dom_element.querySelector( '.shinken-exclude-by-name-tooltip-container' );
            if ( _tooltip_container ) {
                var _name_flat = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.SERVICE_EXCLUDES ).getFlatValue();
                var _text      = SHINKEN.TOOLS.STRING.format( _( 'element.check_exclude_by_name_tooltip' ), _( 'help-hosts.service_excludes-title' ), _name_flat );
                _tooltip_container.setAttribute( 'shi-tip-html', _text );
            }
        }
    },
    updateHtmlGroupAfterChange          : function () {
        var _group                                    = this.buildContactGroupHtml();
        this.dom_element_group_notification.innerHTML = _group.innerHTML;
    },
    updateHtmlCommandAfterChange        : function () {
        var _command                       = this.buildCommandHtml();
        this.dom_element_command.innerHTML = _command.innerHTML;
    },
    updateExcludeStatus                 : function () {
        DOM.Service.setDataSet( this.dom_element, 'excludeStatus', this.getExcludeStatus() );
        this.updateTooltipExcludeByName();
    },
    updateHtmlAfterOverrideCommandChange: function ( property ) {
        if ( property.override_check_uuid === this.uuid ) {
            this.updateHtmlCommandAfterChange();
        }
    },
    updateHtmlAfterDataChange           : function ( dfe_object ) {
        this.updateHtmlCommandAfterChange();
        if ( dfe_object !== undefined ) {
            this.setDfeObject( dfe_object );
        }
        var _dfe                       = this.computeTDFEHtml();
        this.dom_element_dfe.innerHTML = _dfe.innerHTML;
        this.updateHtmlNameAfterChange();
    },
    deleteHtml                          : function ( container, host_in_page_host ) {
        container.removeChild( this.dom_element );
        container.removeChild( document.getElementById( 'tr-check-run-' + this.getDomUUID() ) );
        container.removeChild( document.getElementById( 'tr-check-override-' + this.getDomUUID() ) );
        MANAGER.__instance_property_distributor.deleteOverrideProp( this, host_in_page_host );
        this.errors.reset();
        this.warnings.reset();
        this.setError( '', 0 );
        this.setWarning( '', 0 );
    },
    buildDFESeparatorHtml               : function ( _to_return, is_even ) {
        var _class = is_even ? 'even' : 'odd';
        var _tr    = DOM.Service.createElement( "tr", { class: _class } );
        var _td1   = DOM.Service.createElement( "td", { class: 'shinken-separator', colspan: 2 }, '<hr>' );
        var _td3   = DOM.Service.createElement( "td", { class: 'shinken-separator', colspan: 3 }, '<hr>' );
        var _td2   = DOM.Service.createElement( "td", { class: 'shinken-tab-check-col-dfe text-center' }, '<span class="bold">' + this.element.duplicate_foreach.substr( 1 ) + '</span>' );
        _tr.appendChild( _td1 );
        _tr.appendChild( _td2 );
        _tr.appendChild( _td3 );
        _to_return.appendChild( _tr );
    },
    appendTryCheckHtml                  : function ( _to_return, is_even ) {
        var _class = "shinken-hidden no-hover";
        if ( is_even ) {
            _class += ' even';
        }
        else {
            _class += ' odd';
        }
        var _tr  = DOM.Service.createElement( "tr", {
            class: _class,
            id   : 'tr-check-run-' + this.getDomUUID()
        } );
        var _td  = DOM.Service.createElement( "td", {
            class  : 'col-check-run',
            colspan: 6,
            id     : 'td-check-run-' + this.getDomUUID()
        } );
        var _div = DOM.Service.createElement( "div", {
            class: 'result-check-content',
            id   : 'result-check-run-' + this.getDomUUID()
        }, '&nbsp;' );
        _tr.appendChild( _td );
        _td.appendChild( _div );
        _to_return.appendChild( _tr );
    },
    appendOverrideHtml                  : function ( _to_return ) {
        var _tr  = DOM.Service.createElement( "tr", {
            class: 'shinken-hidden shinken-tr-check-override',
            id   : 'tr-check-override-' + this.getDomUUID()
        } );
        var _td  = DOM.Service.createElement( "td", {
            class  : 'shinken-check-override-cell',
            colspan: 6,
            id     : 'td-check-override-' + this.getDomUUID()
        } );
        var _div = DOM.Service.createElement( "div", {
            class          : 'shinken-override-check-content shinken-unset',
            id             : 'result-check-override-' + this.getDomUUID(),
            'data-dom-uuid': this.getDomUUID()
        }, '&nbsp;' );
        _tr.appendChild( _td );
        _td.appendChild( _div );
        _to_return.appendChild( _tr );
    },
    //********************************************  GET SETTER   **************************************************//
    setObsolete                         : function ( _to_set ) {
        this.is_obsolete = _to_set;
    },
    getName                             : function () {
        return this.name;
    },
    destroy                             : function () {
        this.getCounterTotal().reset();
        MANAGER.__instance_element_distributor.current_element.unSetOverrideCheckInPageHost( this );
    },
    //********************************************  BUILD HTML   **************************************************//
    appendHtml                          : function ( _to_return, is_even ) {
        var _tr = DOM.Service.createElement( "tr", {
            id                    : 'id-shinken-check-line-' + this.getDomUUID(),
            'data-override-status': this._computeOverrideStatus(),
            'data-exclude-status' : this.exclude_status,
            'data-is-dfe'         : this.is_dfe,
            'data-controller'     : "shinken-element",
            onmouseenter          : 'MANAGER.EventManager.mouseEnter(event)',
            onmouseleave          : 'MANAGER.EventManager.mouseLeave(event)',
            onclick               : 'MANAGER.EventManager.onClick(event)'
        } );
        _tr.appendChild( this.buildNameHtml() );
        _tr.appendChild( this.buildOverrideExcludeButtonCellHtml() );
        _tr.appendChild( this.computeTDFEHtml() );
        _tr.appendChild( this.buildContactGroupHtml() );
        _tr.appendChild( this.buildCommandHtml() );
        _tr.appendChild( this.buildTryCheckHtml() );
        _tr.setAttribute( 'class', this.computeHtmlClass() );
        _to_return.appendChild( _tr );
    },
    computeHtmlClass                    : function ( is_even ) {
        var _to_return = "shinken-check-line shinken-parent-event-listener";
        _to_return += is_even ? ' even' : ' odd';
        if ( this.is_bp_rule_command ) {
            _to_return += ' shinken-is-bp-rule';
        }
        _to_return += is_even ? ' even' : ' odd';
        
        switch ( this.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE:
                _to_return += ' dfe-structure-error';
                break;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
                _to_return += ' shinken-check-hidden-container';
                if ( this.dom_element_hidden ) {
                    this.dom_element_hidden.setAttribute( 'shi-tip-html', SHINKEN.TOOLS.STRING.format( _( 'element.hidden_by' ), this.check_with_same_name ) );
                }
                break;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
                _to_return += ' shinken-check-hidden-container shinken-check-duplicate-container';
                if ( this.dom_element_hidden ) {
                    this.dom_element_hidden.setAttribute( 'shi-tip-html', SHINKEN.TOOLS.STRING.format( _( 'element.hidden_by_duplicate' ), this.parent_name_with_same_check ) );
                }
                break;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                _to_return += ' shinken-check-hidden-container shinken-unvalid';
                if ( this.dom_element_hidden ) {
                    this.dom_element_hidden.setAttribute( 'shi-tip-html', SHINKEN.TOOLS.STRING.format( _( 'element.check_duplicate_on_the_same' ), this.check_with_same_name? this.check_with_same_name.name : '???' ) );
                }
                break;
        }
        return _to_return;
    },
    computeCounters                     : function () {
        if ( this.is_dfe && !this.key_dfe ) {
            return;
        }
        if ( !this.element.is_enabled ) {
            return;
        }
        switch ( this.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                this.setTotal( this.getDomUUID(), 0 );
                break;
            default:
                switch ( this.exclude_status ) {
                    case OBJECT.CONST.EXCLUDE_STATUS.BY_ID:
                    case OBJECT.CONST.EXCLUDE_STATUS.BY_NAME:
                        this.setTotal( this.getDomUUID(), 0 );
                        break;
                    default:
                        this.setTotal( this.getDomUUID(), 1 );
                        break;
                }
                break;
        }
    },
    buildClass                          : function () {
        if ( this.dom_element ) {
            this.dom_element.setAttribute( 'class', this.computeHtmlClass() );
        }
    },
    buildNameHtml                       : function () {
        var _template = document.getElementById( "id-shinken-template-check-tab-cell-name" ).innerHTML;
        if ( this.check_with_same_name ) {
            if ( this.check_with_same_name.parent_uuid === MANAGER.__instance_element_distributor.current_element.getUUID() ) {
                _template = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_parent_name_duplicate_$$$", _( "element.hidden_by_current_label" ) );
            }
            else {
                _template = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_parent_name_duplicate_$$$", SHINKEN.TOOLS.STRING.format( _( "element.hidden_by_template_label" ), this.check_with_same_name.parent_name ) );
            }
        }
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_name_$$$", SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( this.element.type, this.element.uuid, this.name ).outerHTML );
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_modulation_$$$", App.Elements.ChecksTab.createTagModulation( this ).outerHTML );
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_UUID_$$$", this.uuid );
        var _to_return = DOM.Service.createElement( "tr", {}, _template );
        return _to_return.firstElementChild;
    },
    buildOverrideExcludeButtonCellHtml  : function () {
        var _template     = document.getElementById( "id-shinken-template-check-tab-cell-override_exclude" ).innerHTML;
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_DOM_UUID_$$$", this.getDomUUID() );
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_UUID_$$$", this.uuid );
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_DFE_NAME_$$$", this.key_dfe );
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_name_$$$", this.name );
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_TYPE_$$$", this.element.getType() );
        var _exclude_prop = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.SERVICE_EXCLUDES );
        if ( _exclude_prop ) {
            _template = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_value_service_exclude_$$$", _exclude_prop.getFlatValue() );
        }
        var _to_return = DOM.Service.createElement( "tr", {}, _template );
        return _to_return.firstElementChild;
    },
    computeTDFEHtml                     : function () {
        var _to_return = DOM.Service.createElement( "td", { class: "shinken-tab-check-col-dfe" } );
        if ( !this.is_dfe ) {
            return _to_return;
        }
        this.setError( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 0 );
        this.setWarning( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 0 );
        if ( this.is_duplicate ) {
            _to_return.appendChild( DOM.Service.createElement( "span", {
                class         : "tag tag-error shinken-pointer-cursor",
                onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()",
                onclick       : "MANAGER.EventManager.goToDataView('" + this.dfe_property + "')",
                'shi-tip-type': SHINKEN_TOOLTIP.TYPE.ERROR_BORDER,
                'shi-tip-html': _( 'element.tooltip_dfe_same_key' ) + "<br>" + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_link_on_data' ), this.dfe_property_name )
            }, this.dfe_object.key ) );
            this.setError( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 1 );
            this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE );
        }
        else if ( this.has_error_dfe ) {
            _to_return.appendChild( DOM.Service.createElement( "span", {
                class         : "tag tag-error shinken-pointer-cursor",
                onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()",
                'shi-tip-type': SHINKEN_TOOLTIP.TYPE.ERROR_BORDER,
                onclick       : "MANAGER.EventManager.goToDataView('" + this.dfe_property + "')",
                'shi-tip-html': _( 'element.tooltip_dfe_syntax_issue' ) + "<br>" + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_link_on_data' ), this.dfe_property_name )
            }, _( 'element.error' ) ) );
            this.setError( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 1 );
            this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE );
        }
        else if ( this.has_warning_proctected_dfe ) {
            _to_return.appendChild( DOM.Service.createElement( "span", {
                class         : "tag tag-warning shinken-pointer-cursor",
                onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()",
                'shi-tip-type': SHINKEN_TOOLTIP.TYPE.WARNING_BORDER,
                onclick       : "MANAGER.EventManager.goToDataView('" + this.dfe_property + "')",
                'shi-tip-html': _( 'element.tooltip_dfe_check_generated_key_encrypted' ) + "<br>" + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_link_on_data' ), this.dfe_property_name )
            }, _( 'element.warning' ) ) );
            this.setWarning( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 1 );
            this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE );
        }
        else {
            _to_return.innerHTML = this.dfe_object.key;
            if ( this.status === OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE ) {
                this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.NONE, true );
            } else {
                this.setStatus( this.status );
            }
        }
        return _to_return;
    },
    buildContactGroupHtml               : function () {
        var _text = this.element[ PROPERTY.CONST.NAME.CONTACT_GROUPS ];
        _text     = SHINKEN.TOOLS.STRING.startsWith( _text, PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ? _text.substr( 1 ) : _text;
        switch ( _text ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _text = '';
        }
        var _override_value = this.getOverrideValue( PROPERTY.CONST.NAME.CONTACT_GROUPS );
        switch ( _override_value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _override_value = '';
        }
        var _to_return = DOM.Service.createElement( "td", { class: "shinken-tab-check-col-contacts-groups" } );
        if ( !_text && !_override_value ) {
            _to_return.innerHTML = '<span class="shinken-between-bracket">' + _( 'element.same_as_host' ) + '</span>';
        }
        else {
            if ( _override_value ) {
                var _has_plus = SHINKEN.TOOLS.STRING.startsWith( _override_value, PROPERTY.CONST.STATE_VALUE_PLUS.ON );
                var _list_tag = this.buildContactGroupListTags( _to_return, _has_plus ? _override_value.substr( 1 ) : _override_value, 'override' );
                if ( _text && _has_plus ) {
                    this.buildContactGroupListTags( _to_return, _text, '', _list_tag );
                }
            }
            else {
                this.buildContactGroupListTags( _to_return, _text );
            }
            
        }
        return _to_return;
    },
    buildContactGroupListTags           : function ( to_return, values, state, list_tag ) {
        var _to_return     = list_tag || {};
        var contact_groups = values.split(',');
        var _current_contact_group;
        var _element;
        var _tag;
        for ( var i = 0, _size = contact_groups.length; i < _size; i++ ) {
            if ( _to_return[ contact_groups[ i ] ] ) {
                continue;
            }
            _to_return[ contact_groups[ i ] ] = true;
            _current_contact_group            = MANAGER.__instance_element_distributor.getElementByName( contact_groups[ i ] );
            _element                          = new OBJECT.ElementList();
            _tag                              = new COMPONENT.Tag();
            _element.setName( contact_groups[ i ] );
            _element.setType( "inheritance" );
            if ( _current_contact_group ) {
                _element.setUUID( _current_contact_group[ 'uuid' ] );
                _element.setState( state ? _current_contact_group.is_new ? state + '-new' : state : _current_contact_group[ OBJECT.CONST.ELEMENT.FIELD.STATUS ] );
                _element.setIsDisabled( !_current_contact_group.is_enabled );
                _tag.setElement( _element );
                _tag.buildHTML( "", _current_contact_group[ 'type' ] );
            }
            else {
                _element.setState( state ? state + '-' + COMPONENT.CONST.TAG.STATE.UNKNOWN : COMPONENT.CONST.TAG.STATE.UNKNOWN );
                _tag.setElement( _element );
                _tag.buildHTML();
            }
            _tag.setTooltip();
            DOM.Service.addElementTo( _tag.dom_element, to_return );
        }
        return _to_return;
    },
    buildCommandHtml                    : function () {
        var _command = this.element.check_command;
        if ( _command ) {
            var _override_value = this.getOverrideValue( PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS, this );
            if ( _override_value ) {
                _command = _command.split( '!' )[ 0 ] + '!' + _override_value;
            }
            var _splitted_data = MANAGER.__instance_macro_distributor.splitCommand( _command );
            if ( this.is_dfe ) {
                var _current;
                for ( var i = 0, _size = _splitted_data.length; i < _size; i++ ) {
                    _current = _splitted_data[ i ];
                    if ( _current.type === OBJECT.CONST.MACRO.TYPE.VALUE_DFE ) {
                        if ( this.dfe_object.args[ _current.index_dfe ] ) {
                            _current.setValue( this.dfe_object.args[ _current.index_dfe ] );
                            _current.setUnknown( false );
                        }
                        else {
                            _current.setUnknown( true );
                        }
                    }
                }
            }
            _command = MANAGER.__instance_macro_distributor.buildLabel( _splitted_data, false, this.key_dfe );
        }
        var _to_return = DOM.Service.createElement( "td", { class: "shinken-tab-check-col-command shinken-tab-check-col-command-data" }, _command );
        return _to_return;
    },
    buildTryCheckHtml                   : function () {
        var _template  = document.getElementById( "id-shinken-template-check-tab-cell-try_check" ).innerHTML;
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_DOM_UUID_$$$", this.getDomUUID() );
        var _to_return = DOM.Service.createElement( "tr", {}, _template );
        
        if ( this.is_bp_rule_command ) {
            var _div_container = _to_return.querySelector( '.shinken-buttons-try-check-container' );
            _div_container.setAttribute( 'shi-tip-html', _( 'element.no_run_bp_rule' ) );
        }
        if ( !MANAGER.__instance_element_distributor.current_element.isType( [OBJECT.CONST.ELEMENT.TYPE.HOSTS, OBJECT.CONST.ELEMENT.TYPE.CLUSTERS] ) ) {
            DOM.Service.removeElement( _to_return.querySelector( '.shinken-evaluate-check-on-sync' ) );
            DOM.Service.removeElement( _to_return.querySelector( '.shinken-evaluate-check-on-poller' ) );
        }
        else {
            if ( !MANAGER.__instance_element_distributor.current_user[ PROPERTY.CONST.NAME.ACL_TRY_CHECK_ON_SYNCHRONIZER ] ) {
                DOM.Service.removeElement( _to_return.querySelector( '.shinken-evaluate-check-on-sync' ) );
            }
            if ( !MANAGER.__instance_element_distributor.current_user[ PROPERTY.CONST.NAME.ACL_TRY_CHECK_ON_POLLER ] ) {
                DOM.Service.removeElement( _to_return.querySelector( '.shinken-evaluate-check-on-poller' ) );
            }
        }
        return _to_return.firstElementChild;
    },
    //********************************************  OVERRIDE **************************************************//
    _computeOverrideStatus                   : function () {
        if ( MANAGER.__instance_element_distributor.current_element.hasOverride( this ) ) {
            return OBJECT.CONST.OVERRIDE_STATUS.ON;
        }
        if ( MANAGER.__instance_property_distributor.hasOverride( this ) ) {
            return OBJECT.CONST.OVERRIDE_STATUS.ON;
        }
        return OBJECT.CONST.OVERRIDE_STATUS.OFF;
    },
    updateOverrideStatus                       : function () {
        var _to_set = this._computeOverrideStatus();
        DOM.Service.setDataSet( this.dom_element, 'overrideStatus', _to_set );
    },
    cleanOverride                       : function () {
        this.force_clean = true;
        MANAGER.__instance_element_distributor.current_element.cleanOverrideFor( this );
        MANAGER.__instance_property_distributor.unSetAllOverrideFor( this );
        this.updateHtmlNameAfterChange();
        this.updateHtmlGroupAfterChange();
        this.updateHtmlCommandAfterChange();
        this.updateOverrideStatus();
        fire_element_is_modifie();
    },
    getOverrideValue                    : function ( prop_name ) {
        var _to_return = MANAGER.__instance_element_distributor.current_element.getOverrideValue( prop_name, this );
        if ( !_to_return ) {
            var _name_prop_override = PROPERTY.BuildOverrideNameFromCheck( prop_name, this );
            var _prop               = MANAGER.__instance_property_distributor.getElement( _name_prop_override );
            if ( _prop ) {
                _to_return = _prop.getValue();
                if ( prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS ) {
                    _to_return = _prop.component_input.getValue();
                }
            }
        }
        if ( !_to_return && this.parent_uuid !== MANAGER.__instance_element_distributor.current_element.uuid ) {
            var _tpl   = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( this.parent_uuid );
            _to_return = _tpl.getOverrideValue( prop_name, this );
        }
        return _to_return;
    },
    //********************************************  TRY CHECK  ***********************************************//
    hide_eval_check                     : function () {
        this.dom_element_try_check_container.classList.add( 'shinken-hidden' );
        this.dom_element_try_check_close_btn.classList.add( 'shinken-hide-eval-hidden' );
    },
    askTryCheck                         : function ( is_exec, is_on_poller ) {
        switch ( this.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                return;
        }
        SHINKEN.TRY_CHECK.tryCheck( this, is_exec, is_on_poller );
    }
};
OBJECT.CheckInPageHost.FilterTags = ['order', 'is_dfe', 'dfe_property', 'name_check', 'uuid', 'has_error_dfe', 'name'];
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.CheckInPageHost, SHINKEN.OBJECT.CounterInterface );