'use strict';

PROPERTY.Data = function ( key, value, group_data ) {
    //uuid
    //name
    //dom_element
    //component_input_key
    //component_input
    //group_data
    this.value = value;
    switch ( this.value ) {
        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            this.value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            this.custom_selected = PROPERTY.CONST.CUSTOM_SELECT.NONE;
            break;
    }
    this.inherited_data = null;
    this.type           = PROPERTY.CONST.TYPES.DATA;
    this.is_valid       = true;
    this.status         = PROPERTY.CONST.DATA.STATUS.NONE;
    this.setGroupData( group_data );
    this.setName( key );
    this.buildUUID();
    this._computeIsValid();
    this.init_done = false;
};

PROPERTY.Data.prototype = {
    init                       : function () {
        this.initCounters();
        this.tab_parent_name = WINDOW.CONST.ELEMENT.DATAS;
        this.tab_parent_id   = "id-shinken-window-datas-target";
        this._initDomElements();
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, this.dom_element, this.type );
        this._computeLabelBtnInheritance( this.inherited_data );
        this._computeValuePlaceholder();
        this.component_btn_inheritance.askUpdateHTML();
        this._finalyseErrorWarning();
        this._computeState();
        if ( this.isDfeData() && this.state_inheritance && !this.getActiveInput().original_value ) {
            this.getActiveInput().original_value = this.getValueInherited();
        }
        this.getCounterTotal().update( this.uuid, 1, "", true, true );
        this.init_done = true;
    },
    initWithDomElement         : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.buildUUID();
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, this.dom_element, this.type );
        var _text_area                 = this.dom_element.querySelector( "textarea.shinken-input" );
        if ( _text_area ) {
            this.component_input = new COMPONENT.Input( _text_area, this, true );
        }
        var _input = this.dom_element.querySelector( "input.shinken-input" );
        if ( _input ) {
            this.component_input_protected = new COMPONENT.Input( _input, this, true );
            this.component_input_protected.setIsProtected( true );
        }
        this._computeLabel();
        this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.label ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
        this._computeState();
        this._finalyseErrorWarning();
        this.getCounterTotal().update( this.uuid, 1, "", true, true );
        this.init_done = true;
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfterChange        : function ( args ) {
        var _input_name = args[ 'input_name' ];
        switch ( _input_name ) {
            case "key":
                var _old_name = this.name;
                this.setLabel( this.component_input_key.getValue() );
                this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.label ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
                MANAGER.__instance_macro_distributor.renamedMacro( _old_name, this.name, this.getValue() );
                this.checkErrorWarning();
                if ( this.is_mass_change ) {
                    CONTROLLER.MassChange.ChangeDataName( this );
                }
                MANAGER.ListenerEventManager.askAfterActionProperty( this );
                break;
            case "value":
                if ( args[ 'validation_done' ] ) {
                    this.setStateInheritance( !this.getValue() );
                }
                if ( this.is_protected ) {
                    if ( this.is_mass_change ) {
                        this.setIsProtected( this.getValue() ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED : PROPERTY.CONST.PROTECTED_STATUS.PROTECTED );
                    }
                    else {
                        this.setIsProtected( PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED );
                    }
                }
                this._computeState();
                if ( !this.is_mass_change ) {
                    MANAGER.__instance_macro_distributor.changeMacro( this, this.getValue() );
                }
                break;
        }
        fire_element_is_modifie();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    askComputeAfterChange      : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.getActiveInput().askComputeAfterChange( dom_element, this, { 'input_name': 'value' } );
    },
    askComputeKeyAfterChange   : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input_key.askComputeAfterChange( dom_element, this, { 'input_name': 'key' } );
    },
    clickOnBtnInheritance      : function () {
        this.setStateInheritance( !this.state_inheritance );
        this._computeState();
        this.updateView();
        MANAGER.__instance_macro_distributor.changeMacro( this, this.state_inheritance ? this.getValueInherited() : this.getValue() );
    },
    delete                     : function () {
        delete MANAGER.__instance_property_distributor.elements[ this.is_override ? this.name : this.uuid ];
        DOM.Service.removeElement( this.dom_element );
        MANAGER.__instance_macro_distributor.deleteMacroContent( this.name );
        if ( this.is_mass_change ) {
            CONTROLLER.MassChange.removeData( this );
            this.is_mass_change_deleted = true;
        }
        else {
            App.Elements.ChecksTab.askInit( { data_change: true, property: this } );
        }
        this.resetCounters();
        MANAGER.ListenerEventManager.afterActionGlobal( this );
        fire_element_is_modifie();
    },
    onFocus                    : function () {
        if ( this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated() ) {
            this.getActiveInput().dom_element.value = "";
        }
    },
    ___onFocusOut              : function () {
        var self = this;
        setTimeout( function () {
            if ( self.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED ) {
                self.getActiveInput().dom_element.value = self.getActiveInput().original_value;
            }
        }, 500 );
    },
    //********************************************  SETTER GETTER   **************************************************//
    isLocalData                : function () {
        if ( !this.group_data ) {
            return false;
        }
        return this.group_data.type === PROPERTY.CONST.DATA.GROUP.LOCALE;
    },
    isDfeData                  : function () {
        if ( !this.group_data ) {
            return false;
        }
        return this.group_data.type === PROPERTY.CONST.DATA.GROUP.DFE;
    },
    setGroupData               : function ( to_set ) {
        if ( this.isLocalData() && to_set.type !== PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            delete MANAGER.__instance_property_distributor.elements[ this.uuid ];
            this.uuid   = this.name;
            this.status = PROPERTY.CONST.DATA.STATUS.NONE;
            MANAGER.__instance_property_distributor.setElement( this.uuid, this );
        }
        if ( this.isDfeData() ) {
            return;
        }
        this.group_data = to_set;
        if ( this.group_data ) {
            this.group_data_uuid = this.group_data.uuid;
        }
    },
    setName                    : function ( to_set ) {
        this.name = to_set;
        if ( this.name ) {
            this._computeLabel();
        }
        this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.label ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
    },
    getLabel                   : function () {
        return this.label;
    },
    setLabel                   : function ( to_set ) {
        this.label = SHINKEN.TOOLS.STRING.toUpperCase( to_set );
        if ( !this.is_override ) {
            this.name = PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL + this.label;
        }
    },
    setStatus                  : function ( to_set ) {
        this.status = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'status', this.status );
        }
    },
    getValueInherited          : function () {
        if ( !this.inherited_data ) {
            return "";
        }
        return SHINKEN.TOOLS.STRING.unescape_xss( this.inherited_data.value );
    },
    getFlatValue               : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.component_btn_inheritance.isSet() ? this.getValueInherited() : '';
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                return this.getValue();
        }
    },
    setInheritedData           : function ( to_set ) {
        this.inherited_data = to_set;
    },
    isProtected                : function () {
        return !!this.is_protected;
    },
    setIsProtected             : function ( to_set ) {
        this.is_protected = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'isProtected', this.is_protected );
        }
    },
    getActiveInput             : function () {
        if ( this.is_protected ) {
            return this.component_input_protected;
        }
        return this.component_input;
    },
    getParentName              : function () {
        return this.isLocalData() ? this.uuid : this.name;
    },
    getNameOrUUID              : function () {
        return this.uuid;
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance     : function () {
        if ( this.state_inheritance !== undefined ) {
            return;
        }
        var _value = this.getValue();
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            _value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        this.setStateInheritance( !_value );
        this.updateView();
    },
    _computeState              : function () {
        this._computeBtnInheritance();
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_override ) {
            if ( this.getValue() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.getValue() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            if ( this.is_mass_change ) {
                switch ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY_DATA:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY_DATA_OVERRIDE:
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                        break;
                }
            }
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    _computeLabel              : function () {
        var _name = this.is_override ? this.override_prop_name : this.name;
        if ( SHINKEN.TOOLS.STRING.startsWith( _name, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
            this.setLabel( _name.substr( 1 ) );
        }
        else {
            this.setLabel( _name );
        }
    },
    _computeValuePlaceholder   : function () {
        var _label = '';
        if ( this.inherited_data ) {
            if ( this.is_protected ) {
                _label = SHINKEN.TOOLS.ENCRYPTION.getLabelHidden();
            }
            else {
                _label = this.getValueInherited();
                if ( _label === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    _label = _( 'element.forced_default' );
                }
                _label += ' [ ' + _( 'element.in_template' ) + ' ' + this.inherited_data.template_name + ' ]';
            }
        }
        if ( _label ) {
            this.getActiveInput().setPlaceholder( _label );
        }
    },
    _computeLabelBtnInheritance: function ( inherited_data ) {
        if ( !inherited_data ) {
            return false;
        }
        inherited_data.is_protected = this.is_protected;
        if ( this.is_protected ) {
            inherited_data.label = SHINKEN.TOOLS.ENCRYPTION.getDefaultSpanLabel();
        }
        return this.component_btn_inheritance.setTemplateProperty( inherited_data );
    },
    _computeIsValid            : function () {
        switch ( this.name ) {
            case '_id':
            case '_ID':
            case '_SYNC_KEYS':
            case '__SYNC_IDX__':
            case '_SE_UUID':
            case '_SE_UUID_HASH':
                this.is_valid = false;
        }
    },
    _initDomElements           : function () {
        this.selectors = {};
        var _template  = this.getTemplateHTML().outerHTML;
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$label", this.label );
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$value", this.value );
        var _to_return = DOM.Service.createElement( "tbody", {}, _template );
        
        this.dom_element = _to_return.firstChild;
        this.dom_element.classList.add( PROPERTY.CONST.CLASS.SKINKEN_LINE );
        this.dom_element.classList.add( "shinken-parent-event-listener" );
        if ( !this.isLocalData() && !this.is_mass_change ) {
            this.dom_element.classList.add( "shinken-hidden" );
        }
        else {
            this.dom_element.classList.remove( "shinken-hidden" );
        }
        
        if ( MANAGER.__instance_element_distributor.current_element.work_area_status === OBJECT.CONST.ELEMENT.WORK_AREA_STATUS.PROPOSED
             || MANAGER.__instance_element_distributor.current_element.editable === "0" ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        
        this.dom_element.dataset.status    = this.status;
        this.dom_element.dataset.name      = this.uuid;
        this.dom_element.dataset.groupType = this.group_data.type;
        this._computeIsEditableKey();
        this.dom_element.dataset.isProtected = this.is_protected;
        this.dom_element.removeAttribute( 'id' );
        this.component_input_key = new COMPONENT.Input( this.dom_element.querySelector( ".shinken-input-key" ), this, true );
        this.component_input_key.setValidationRules( [PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DATA, PROPERTY.CONST.VALIDATOR.TYPE.NO_INVISIBLE_CHAR], COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS );
        this.component_input = new COMPONENT.Input( this.dom_element.querySelector( "textarea.shinken-input" ), this, true );
        this.component_input.setValidationRules( [PROPERTY.CONST.VALIDATOR.TYPE.NO_INVISIBLE_CHAR], COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS );
        this.component_input_protected = new COMPONENT.Input( this.dom_element.querySelector( "input.shinken-input" ), this, true );
        this.component_input_protected.setIsProtected( true );
        if ( this.modified_value_before_prop_use_modification ) {
            this.component_input.dom_element.value = this.modified_value_before_prop_use_modification;
            this.component_input.setValue();
            this.modified_value_before_prop_use_modification = "";
        }
        if ( this.isDfeData() ) {
            this.buildHtmlCheckDfe();
        }
        if ( this.is_mass_change ) {
            this.setMassChange( true );
        }
    },
    _computeIsEditableKey      : function () {
        this.is_editable_key = true;
        if ( this.group_data.type !== PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            this.is_editable_key = false;
        }
        else if ( this.is_protected ) {
            this.is_editable_key = false;
        }
        this.dom_element.dataset.editableKey = this.is_editable_key;
    },
    buildUUID                  : function () {
        if ( !this.group_data || (this.group_data.type !== PROPERTY.CONST.DATA.GROUP.LOCALE && this.group_data.type !== CONTROLLER.CONST.MASS_CHANGE.NAME) ) {
            this.uuid = this.name;
        }
        else {
            this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        }
    },
    ___unset                   : function () {
        this.setValueFromUser( "" );
        if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    this.getActiveInput().setPlaceholder();
                    break;
                default:
                    this.getActiveInput().setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                    break;
            }
        }
    },
    setKeyValueFromUser        : function ( value ) {
        this.component_input_key.setValueFromJs( value );
        this.askComputeKeyAfterChange();
        this._computeState();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    setValueFromUser           : function ( value ) {
        this.getActiveInput().setValueFromJs( value );
        this.askComputeAfterChange();
        this._computeState();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    //********************************************  VALIDATION  *********************************************************//
    computeErrorsSpecifics     : function () {
        this.validateValueInput();
    },
    validateValueInput         : function () {
        //if ( this.init_done && !this.getActiveInput().need_validation ) {
        //    return;
        //}
        var _to_set;
        if ( this.is_override ) {
            _to_set = COMPONENT.CONST.STATUS.NONE;
            if ( this.dom_element.classList.contains( 'shinken-disabled-and-unknown' ) ) {
                if ( !this.dom_element.classList.contains( 'inherit-service-override' ) || this.state === PROPERTY.CONST.STATE_PROPERTY.OVERRIDE ) {
                    _to_set = COMPONENT.CONST.STATUS.WARNING;
                    this.getActiveInput().getCounterWarning().update( this.getActiveInput().uuid, 1 );
                    this.getActiveInput().addShinkenTooltip( _to_set, _( 'element.cannot_edit_invalid_overriden_data' ) );
                }
            }
            this.getActiveInput().setStatus( _to_set );
        }
        else {
            if ( this.isDfeData() ) {
                this.getActiveInput().setStatus( COMPONENT.CONST.STATUS.NONE );
                var _value = this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ? this.getValueInherited() : this.getValue();
                if ( !_value && this.is_mass_change ) {
                    return;
                }
                App.DFE._duplicateSplittedValue[ this.name ] = App.DFE.validatorDFE( App.DFE.splitDFE( this.name, _value ) );
                var _message                                 = App.DFE.setOutputDFE( App.DFE._duplicateSplittedValue[ this.name ], this.name, this.group_data.label );
                _message.is_dfe                              = true;
                _message.is_dfe_protected                    = this.is_protected;
                if ( this.getActiveInput().original_value && this.getFlatValue() !== this.getActiveInput().original_value ) {
                    var _messages_deleted = App.DFE.getMessageDeletedElements( App.DFE._duplicateSplittedValue[ this.name ]._dfe_elem,
                        App.DFE.validatorDFE( App.DFE.splitDFE( this.name, this.getActiveInput().original_value ) )._dfe_elem, this.list_check_link );
                    if ( _messages_deleted ) {
                        _message.property_name = this.name;
                        _message.addMessages( _messages_deleted );
                        _message.footer = _( 'element.tooltip_dfe_deleted_part_2' );
                    }
                }
                if ( this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON ) {
                    var _status      = _message.getStatus();
                    var _parent_name = true;
                    if ( this.component_btn_inheritance.list_template_property ) {
                        _parent_name = this.component_btn_inheritance.list_template_property.template_name;
                    }
                    this.setInheritanceStatus( _status, _message.buildMessage( false, _parent_name ) );
                    this.getActiveInput().setMessage( _message );
                }
                else {
                    this.setInheritanceStatus( "", "" );
                    this.getActiveInput().setMessage( _message );
                }
            }
            if ( !this.is_mass_change ) {
                App.Elements.ChecksTab.askInit( { data_change: true, property: this } );
            }
        }
    },
    
    //********************************************  OTHER  *********************************************************//
    getTemplateHTML  : function () {
        if ( !PROPERTY.CONST.data_template_html || SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            PROPERTY.CONST.data_template_html = document.getElementById( 'shinken-element-property-line-data-template' );
        }
        return PROPERTY.CONST.data_template_html;
    },
    //********************************************  HELP    **********************************************************//
    mouseEnter       : function ( event ) {
        if ( !this.getLabel() ) {
            return;
        }
        MANAGER.HelpManager.setActive( this.name, this.getLabel(), this.isDfeData() ? 'element.tooltip_dfe_common' : 'element.help_text_data' );
        if ( this.is_mass_change ) {
            this.mouseEnterInOption( event );
        }
    },
    //********************************************  VIEW    **********************************************************//
    ___updateView    : function () {
        this.getActiveInput().updateView( this.state_inheritance, true, false, this.component_btn_inheritance.isSet() );
        this.computeErrorsSpecifics();
    },
    buildHtmlCheckDfe: function () {
        var _checks_dfe       = MANAGER.__instance_element_distributor.getAllChecksDFE();
        var _checks_candidate = SHINKEN.TOOLS.ARRAY.filterWith( _checks_dfe, PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME, this.name );
        var _size             = _checks_dfe.length;
        var _size_candidate   = _checks_candidate.length;
        
        var counter          = this._drawCounter( _size_candidate, _size );
        var label            = (_size_candidate > 1) ? _( 'element.used_by_checks' ) : _( 'element.used_by_check' );
        var columnUsedHead   = '<p style="padding-left: 8px;">' + label + counter + '</p>';
        var counter_unused   = this._drawCounter( _size - _size_candidate, _size );
        var label_unused     = (_size - _size_candidate > 1) ? _( 'element.unused_by_checks' ) : _( 'element.unused_by_check' );
        var columnUnusedHead = (_size - _size_candidate) ? '<p style="padding-left: 8px; ">' + label_unused + counter_unused + '</p>' : '';
        
        var columnUsedContent   = '';
        var columnUnusedContent = '';
        var current_check;
        
        this.list_check_link = []; // Use for compute the warning message of deleted DFE checks when user change DFE data value
        for ( var i = 0; i < _size; i++ ) {
            current_check = _checks_dfe[ i ];
            var _label    = "";
            if ( !current_check.isEnabled() ) {
                _label = current_check.getName() + "<span class='shinken-warning'>" + _( "element.disabled" ) + "</span>";
            }
            if ( current_check[ PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME ] === this.name ) {
                this.list_check_link.push( current_check.uuid );
                columnUsedContent += SHINKEN.TOOLS.buildLinkShinkenElement( current_check, _label, 'shinken-tag-check hide-if-collapse shinken-space' ).outerHTML;
            }
            else {
                columnUnusedContent += SHINKEN.TOOLS.buildLinkShinkenElement( current_check, _label, 'shinken-tag-check hide-if-collapse shinken-space' ).outerHTML;
            }
        }
        
        var _to_return = DOM.Service.createElement( "tr", { class: 'shinken-data-dfe-list-check-container shinken-collapse', onclick: 'MANAGER.EventManager.clickDataCollapseButton(this)' } );
        var _cell_1    = DOM.Service.createElement( "td", { class: 'shinken-data-dfe-list-check-used' }, columnUsedHead + columnUsedContent );
        var _cell_2    = DOM.Service.createElement( "td", { class: 'shinken-data-dfe-list-check-unused' }, columnUnusedHead + columnUnusedContent );
        var _cell_3    = DOM.Service.createElement( "td", { class: 'shinken-data-dfe-list-check-collapse' }, '<span class="shinken-dfe-collapse-btn"><span class="icon-white icon-plus-sign show-if-collapse"></span><span class="icon-white icon-minus-sign hide-if-collapse"></span></span>' );
        _to_return.appendChild( _cell_1 );
        _to_return.appendChild( _cell_2 );
        _to_return.appendChild( _cell_3 );
        
        this.dom_element.querySelector( '.shinken-element-property-line-data-table' ).appendChild( _to_return );
    },
    
    _drawCounter      : function ( value, total, className ) {
        className = (className) ? className : 'badge data-counter-active';
        var s     = '';
        if ( value != 0 ) {
            s = ' [ <span class="' + className + '">' + value + '</span> /' + total + ' ]';
        }
        else {
            s = ' [ ' + total + ' ]';
        }
        return s;
    },
    //********************************************  LIST CHECK    **********************************************************//
    setCollapseCheck  : function ( to_set ) {
        var _element = this.dom_element.querySelector( '.shinken-data-dfe-list-check-container' );
        if ( !_element ) {
            return;
        }
        if ( to_set ) {
            _element.classList.add( 'shinken-collapse' );
            _element.classList.remove( 'shinken-not-collapse' );
        }
        else {
            _element.classList.remove( 'shinken-collapse' );
            _element.classList.add( 'shinken-not-collapse' );
        }
    },
    //********************************************  SAVE     *********************************************************//
    getValue          : function () {
        return this.getActiveInput().getValue();
    },
    getDataToSaveFinal: function () {
        if ( !this.is_valid ) {
            return "";
        }
        if ( this.name === PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) {
            return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : '';
        }
        var _to_return = this.getValue();
        if ( this.is_mass_change && this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED ) {
            _to_return = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
        }
        else if ( this.is_mass_change && !_to_return ) {
            _to_return = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
        }
        else if ( _to_return === "" && this.component_btn_inheritance.isSet() ) {
            _to_return = PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        if ( this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated() ) {
            return SHINKEN.TOOLS.STRING.b64Encode( _to_return );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Data, PROPERTY.Interface );
