//priority 20
'use strict';

PROPERTY.InterfaceSelect           = function ( dom_element ) {
};
PROPERTY.InterfaceSelect.prototype = {
    initMainSelector: function () {
        this.selectors[ PROPERTY.CONST.SELECTOR.MAIN ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.SELECTOR.MAIN + '"]' ), this.type, this.is_override, this );
    },
    
    //********************************************  GETTER SETTER  **************************************************//
    ___unset                  : function () {
        this.setValueFromUser( '', '' );
        if ( this.is_mass_change && this.type === PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    this.component_input.setPlaceholder();
                    break;
                default:
                    this.component_input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                    break;
            }
        }
    },
    getSelector               : function () {
        return this.selectors[ PROPERTY.CONST.SELECTOR.MAIN ];
    },
    setLastListElementSelected: function ( to_set ) {
        this.setLastItemSelected( to_set );
        this.link_id = '';
        if ( this.last_list_element_selected ) {
            var _selected_element = this.getSelector().list_element.getListSelectElement( this.last_list_element_selected ).getElement();
            
            if ( _selected_element.uuid ) {
                this.link_id = _selected_element.uuid;
                this.link_id += _selected_element.state === COMPONENT.CONST.TAG.STATE.NEW ? "?new=1" : '';
            }
        }
        DOM.Service.setDataSet( this.dom_element, 'linkId', this.link_id );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askComputeAfterChange     : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        switch ( dom_element.name ) {
            case 'multi-search':
                this.getSelectViaDomElement( dom_element ).askComputeAfterChange( dom_element );
                break;
        }
    },
    ___hidePopup              : function ( exception ) {
        if ( exception !== this.getSelector() ) {
            this.getSelector().hidePopup();
        }
    },
    ___clickOnItemSelector    : function ( _target_component, key_name ) {
        if ( _target_component !== this.getSelector() ) {
            return;
        }
        this.setLastListElementSelected( key_name );
        this.getSelector().clickOnItemSelector( this.name, key_name );
        switch ( key_name ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                if ( this.component_input ) {
                    this.component_input.updateView( this.state_inheritance );
                }
                break;
            default:
                this.setStateInheritance( false );
                if ( this.component_input ) {
                    this.component_input.updateView( false );
                }
        }
        this.getSelector().buildLinkOpenNewTab( this.item_type, this.link_id );
        this.updateView();
        return true;
    },
    clickOnBtnInheritance     : function () {
        this.setStateInheritance( !this.state_inheritance );
        if ( this.state_inheritance ) {
            this.setLastListElementSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
        }
        else {
            if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE &&
                 (!this.getSelector().last_selected_key_name || this.getSelector().last_selected_key_name === PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ) ) {
                this.getSelector().clickOnItemSelector( this.name, PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
            this.setLastListElementSelected( this.getSelector().getLastSelectedElementName() );
        }
        this._computeState();
        if ( this.component_input ) {
            this.component_input.updateView( this.state_inheritance );
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    //********************************************  VIEW  **************************************************//
    ___updateView             : function () {
        this._computeState();
    },
    _computeLabelSelect       : function () {
        if ( this.is_disabled ) {
            return;
        }
        var _title_to_set;
        var _element_list;
        var _selected_element;
        var _add_class_inheritance_flag = false;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                _element_list                           = this.getSelector().list_element.getElement( this.last_list_element_selected );
                _title_to_set                           = this._computeInheritedLabelHtml( this.component_btn_inheritance.list_template_property[ 0 ].template_name, this.component_btn_inheritance.list_template_property[ 0 ].label );
                this.getSelector().dom_select.className = "shinken-select-selector";
                _add_class_inheritance_flag             = true;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                _element_list                           = this.getSelector().list_element.getElement( this.last_list_element_selected );
                _title_to_set                           = _element_list.getLabel();
                this.getSelector().dom_select.className = "shinken-select-selector";
                _add_class_inheritance_flag             = true;
                break;
            default:
                _selected_element = this.getSelector().getLastSelectedElement();
                if ( _selected_element ) {
                    _title_to_set                           = DOM.Service.getInnerText( _selected_element.dom_element );
                    this.getSelector().dom_select.className = "shinken-select-selector" + _selected_element.element.getClass();
                }
        }
        if ( _add_class_inheritance_flag ) {
            _title_to_set = '<span class="shinken-multiselect-title">' + _title_to_set + '</span>';
        }
        this.getSelector().setTitle( _title_to_set );
        this.checkErrorWarning();
    },
    //********************************************  VALIDATION   *********************************************************//
    computeErrorsSpecifics    : function ( force_mass_change ) {
        this.counter_temp_error += this.getSelector().getErrors( this.state, this.name );
        this.counter_temp_warning += this.getSelector().getWarnings( this.state, this.name );
        if ( !this.is_mass_change ) {
            return;
        }
        if ( !force_mass_change ) {
            var _keys = Object.keys( this.selectors );
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                this.selectors[ _keys[ i ] ].setMessage();
            }
            if ( this.is_synchro ) {
                this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].setMessage( SHINKEN.TOOLS.STRING.format( _( "mass-change.step-3.prop_synchro" ),
                    "<span class='shinken-highlight-data-user'>" + _( MANAGER.__instance_element_distributor.current_element.type + "." + this.synchro_name ) + "</span>" ) );
                return;
            }
            return;
        }
        var _need_main_element   = false;
        var _need_extra_action   = false;
        var _need_extra_element  = false;
        var _need_single_element = false;
        var _action              = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                return;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.MOVE:
                if ( !this.is_ordered ) {
                    break;
                }
                if ( this.getValue() ) {
                    _need_extra_action = true;
                    var _extra_action  = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ].getValue();
                    switch ( _extra_action ) {
                        case PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.AFTER:
                        case PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.BEFORE:
                            _need_extra_element = true;
                            break;
                    }
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                    _need_extra_element = true;
                }
                if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                    _need_single_element = true;
                }
                break;
        }
        if ( _need_main_element && !this.getValue() ) {
            var _validator = new OBJECT.Messages();
            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'mass-change.form.tooltip_required' ) );
            this.getSelector().setMessage( _validator );
        }
        if ( _need_extra_action && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ].getValue() === PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.NONE ) {
            var _validator = new OBJECT.Messages();
            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'mass-change.form.tooltip_required' ) );
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ].setMessage( _validator );
        }
        if ( _need_extra_element && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
            var _validator = new OBJECT.Messages();
            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'mass-change.form.tooltip_required' ) );
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].setMessage( _validator );
        }
        if ( _need_single_element && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue() === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
            var _validator = new OBJECT.Messages();
            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'mass-change.form.tooltip_required' ) );
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].setMessage( _validator );
        }
    },
    //********************************************  KEY EVENT   ******************************************************//
    keydown                   : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.getSelectViaDomElement( event.target ).moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.getSelectViaDomElement( event.target ).moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                var _is_auto_select_done = this.getSelectViaDomElement( event.target ).validAutoSelect();
                if ( !_is_auto_select_done && this.getSelectViaDomElement( event.target ) === this.getSelector() && this.name === PROPERTY.CONST.NAME.USE ) {
                    event.stopPropagation();
                    this.addTagWithFilterName();
                }
                event.preventDefault();
                break;
        }
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeInheritedLabel    : function ( inherited_value ) {
        var _to_return = inherited_value;
        if ( this.getName() === PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ) {
            _to_return = _( 'element.' + inherited_value );
        }
        return _to_return;
    },
    updateWithTemplateSpecific: function () {
        this.updateView();
    }
};
