'use strict';
PROPERTY.UserRightsBehaviourMassChange = (function ( self ) {
    self._timeout_add_consistenct            = null;
    //********************************************  SYNCHRONIZATION     **************************************************//
    self.synchronization                     = function ( modified_property ) {
        var _value;
        var _action      = modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        var _action_plus = modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] ? modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() : PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE;
        var _action_to_add,
            _value_to_add;
        switch ( modified_property.getName() ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                switch ( _action ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                        self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                        self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                        _value = modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue();
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), _action, _value, modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() );
                                break;
                        }
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                        _value = modified_property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ].getValue() || modified_property.last_list_element_selected;
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), _action, _value );
                                break;
                        }
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                        _value = modified_property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ].getValue() || modified_property.last_list_element_selected;
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                                if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
                                    self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, "" );
                                    self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, "" );
                                }
                                else {
                                    self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName() ), _action, _value );
                                }
                                break;
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE_ALL_EXCEPT, _value );
                                break;
                        }
                        break;
                }
                switch ( _action_plus ) {
                    case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.OFF:
                    case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE:
                        self.doActionPlusForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName() ), _action_plus, PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE );
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                switch ( _action ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                        self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                        _value = modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue();
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_SYNCHRO, modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() );
                                break;
                        }
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                        _value = modified_property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ].getValue() || modified_property.last_list_element_selected;
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), self.getActionSynchronized( PROPERTY.CONST.MASS_CHANGE.ACTION.ADD ), _value );
                                break;
                        }
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                        self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                        break;
                }
                switch ( _action_plus ) {
                    case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON:
                        self.doActionPlusForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName() ), _action_plus, PROPERTY.CONST.MASS_CHANGE.ACTION.ADD );
                        break;
                }
                break;
        }
        self.askAddActionConsistency();
    };
    self.getActionSynchronized               = function ( action ) {
        switch ( action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                return PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_SYNCHRO;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                return PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE_SYNCHRO;
        }
    };
    //********************************************  DO ACTIONS     **************************************************//
    self.doActionForAll                      = function ( properties, action, value, extra_value ) {
        for ( var i = 0, _size_i = properties.length; i < _size_i; i++ ) {
            self.doActionFor( properties[ i ], action, value, extra_value );
        }
    };
    self.doActionPlusForAll                  = function ( properties, action_plus, default_action ) {
        for ( var i = 0, _size_i = properties.length; i < _size_i; i++ ) {
            self.doActionPlusFor( properties[ i ], action_plus, default_action );
        }
    };
    self.doActionPlusFor                     = function ( property, action_plus, default_action ) {
        if ( property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() === action_plus ) {
            return;
        }
        if ( property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() === PROPERTY.CONST.MASS_CHANGE.ACTION.NONE ) {
            property.clickOnItemSelector( default_action, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
        }
        property.clickOnItemSelector( action_plus, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] );
    };
    self.doActionFor                         = function ( property, action, value, extra_value ) {
        property.clickOnItemSelector( action, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
        if ( value && value !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
            switch ( action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                    property.clickOnItemSelector( value, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ] );
                    if ( extra_value && extra_value !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                        property.clickOnItemSelector( extra_value, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ] );
                    }
                    break;
                default:
                    var _value = value.split( ',' );
                    for ( var i = 0, _size_i = _value.length; i < _size_i; i++ ) {
                        property.clickOnItemSelector( _value[ i ], null, property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ] );
                    }
            }
        }
    };
    //********************************************  CONSISTENCY     **************************************************//
    self.askAddActionConsistency             = function ( property ) {
        if ( self._timeout_add_consistenct ) {
            clearTimeout( self._timeout_add_consistenct );
        }
        self._timeout_add_consistenct = setTimeout( function () {
            self.addActionConsistency( property );
            self._timeout_add_consistenct = null;
        }, 200 );
    };
    self.addActionConsistency                = function ( property ) {
        if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
            self.addActionConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACTS );
            self.addActionConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS );
        }
        else if ( property && property.getName() === PROPERTY.CONST.NAME.USE ) {
            self.addActionConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACTS );
            self.addActionConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS );
        }
    };
    self.addActionConsistencyFor             = function ( property_name ) {
        var _action = PROPERTY.CONST.MASS_CHANGE.ACTION.NONE;
        if ( self.showConsistencyFor( property_name ) ) {
            _action = PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_CONSISTENCY;
            MANAGER.__instance_window_distributor.parent_windows[ MANAGER.__instance_element_distributor.current_element.getUUID() ].pulsateElementIfNotActive( WINDOW.CONST.ELEMENT.USER_RIGHTS );
        }
        var _property = PROPERTY.UserRightsBehaviour._prop( property_name, property_name );
        self.doActionForAll( [_property], _action );
        self.finalyseViewForConsistency( _property, _action );
    };
    self.finalyseViewForConsistency          = function ( property, action ) {
        if ( action !== PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_CONSISTENCY ) {
            return;
        }
        //ADDING TAG IN SELECT
        property.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.CONSISTENCY_VALUE, null, property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ] );
        var _main_selector = property.getSelector();
        _main_selector.getActiveListForUser().addTag( '', _main_selector.list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.CONSISTENCY_VALUE ) );
        
        var _synchronized_property = PROPERTY.UserRightsBehaviour.getSynchronizedProperty( property.synchronized_name );
        
        for ( var i = 0, _size_i = _main_selector.list_element_selected.tags.length; i < _size_i; i++ ) {
            var _dom_span       = _main_selector.list_element_selected.tags[ i ].dom_element.querySelector( ".shinken-property-synchronized" );
            _dom_span.innerHTML = _synchronized_property[ i ].getLabelViaDom();
        }
        //MOVING PROPERTY IN LAST POSITION OF THE FAMILY
        var _properties_synchro_dom = document.querySelectorAll( '.shinken-mass-change-property-step .shinken-element-property-line[data-synchronized-name="' + property.synchronized_name + '"]' );
        for ( var j = 0, _size_j = _properties_synchro_dom.length; j < _size_j - 1; j++ ) {
            if ( _properties_synchro_dom[ j ].dataset.synchroName === property.synchronized_name ) {
                DOM.Service.switchElement( _properties_synchro_dom[ j ], _properties_synchro_dom[ _size_j - 1 ] );
                break;
            }
        }
    };
    self.showConsistencyFor                  = function ( property_name ) {
        var _to_analyse = self.getPropertyForComputeConsistencyFor( property_name );
        if ( property_name === PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ) {
            _to_analyse = SHINKEN.TOOLS.ARRAY.concat( _to_analyse, self.getPropertyForComputeConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACTS ) );
        }
        for ( var i = 0, _size_i = _to_analyse.length; i < _size_i; i++ ) {
            if ( !_to_analyse[ i ].getDataToSave() ) {
                continue;
            }
            var _action = _to_analyse[ i ].selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_SYNCHRO:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE_SYNCHRO:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    return true;
            }
        }
        return false;
    };
    self.getPropertyForComputeConsistencyFor = function ( property_name ) {
        var _to_return = [];
        if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
            _to_return = SHINKEN.TOOLS.ARRAY.filterWith( MANAGER.__instance_property_distributor.getAllElements(), 'synchronized_name', property_name );
            _to_return.push( MANAGER.__instance_property_distributor.getElement( property_name ) );
            _to_return.push( MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ) );
        }
        else {
            _to_return.push( MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ) );
        }
        return _to_return;
    };
    return self;
})( PROPERTY.UserRightsBehaviourMassChange || {} );

PROPERTY.UserRightsBehaviour = (function ( self ) {
    self.has_everybody_default    = null;
    self._timeout_synchronization = {};
    //********************************************  SYNCHRONIZATION     **************************************************//
    self.askSynchronization       = function ( modified_property ) {
        if ( self._timeout_synchronization[ modified_property.getName() ] ) {
            clearTimeout( self._timeout_synchronization[ modified_property.getName() ] );
        }
        self._timeout_synchronization[ modified_property.getName() ] = setTimeout( function () {
            self.synchronization( modified_property );
            self._timeout_synchronization[ modified_property.getName() ] = false;
        }, 200 );
    };
    self.synchronization          = function ( modified_property ) {
        if ( modified_property.is_mass_change ) {
            return PROPERTY.UserRightsBehaviourMassChange.synchronization( modified_property );
        }
        var _flat_value = modified_property.getFlatValue();
        var _properties = self.getSynchronizedProperty( modified_property.getName() );
        var i;
        var _size_i;
        switch ( modified_property.getName() ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                if ( modified_property.getName() === PROPERTY.CONST.NAME.VIEW_CONTACTS ) {
                    if ( self.isViewEveryone() ) {
                        return;
                    }
                    self.askSynchronization( MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ) );
                }
                else if ( self.isViewEveryone() && !_flat_value ) {
                    return;
                }
                switch ( modified_property.last_list_element_selected ) {
                    //case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                        for ( i = 0, _size_i = _properties.length; i < _size_i; i++ ) {
                            _properties[ i ].clickOnItemSelector( modified_property.last_list_element_selected, null, _properties[ i ].getSelector() );
                        }
                        return;
                }
                this.addMissing( modified_property );
                if ( modified_property.state_plus === COMPONENT.CONST.BTN_STATE.OFF ) {
                    this.synchronizePlus( modified_property );
                }
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
                var _property = _properties[ 0 ];
                switch ( _property.getName() ) {
                    case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                        if ( self.isViewEveryone() ) {
                            return;
                        }
                        break;
                    case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                        if ( self.isViewEveryone() && !_property.getFlatValue() ) {
                            return;
                        }
                        break;
                }
                _property.synchronizeAtMinimum( modified_property );
                break;
        }
    };
    self.addMissing               = function ( modified_property, synchronized_property ) {
        var _flat_value    = modified_property.getFlatValue();
        var _value_present = SHINKEN.TOOLS.STRING.splitMultiselectValueWithNoPlus( _flat_value );
        var _size_i,
            i;
        var _properties    = synchronized_property ? [synchronized_property] : self.getSynchronizedProperty( modified_property.getName() );
        var _missing       = [];
        for ( i = 0, _size_i = _properties.length; i < _size_i; i++ ) {
            _missing = SHINKEN.TOOLS.ARRAY.concatUniqueIfNotPresentIn( _missing, SHINKEN.TOOLS.STRING.splitMultiselectValueWithNoPlus( _properties[ i ].getFlatValue() ), _value_present );
        }
        for ( i = 0, _size_i = _missing.length; i < _size_i; i++ ) {
            self.addValueTo( modified_property, _missing[ i ] );
        }
    };
    self.addValueTo               = function ( property, value ) {
        switch ( value ) {
            case '':
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                return;
        }
        var _element = property.getSelector().validOrCreateTag( value, property.name );
        if ( _element.is_selected && property.state !== PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
            return;
        }
        DOM.Service.askAddClass( property.dom_element, "shinken-synchronization", 2000 );
        property.clickOnItemSelector( _element.getName(), null, property.getSelector() );
        self.makeAnimationFor( property, value );
    };
    self.makeAnimationFor         = function ( property, value ) {
        var _synchronized_property = self.getSynchronizedProperty( property.getName() );
        var _current;
        var _current_tag;
        for ( var i = 0, _size_i = _synchronized_property.length; i < _size_i; i++ ) {
            _current     = _synchronized_property[ i ];
            _current_tag = _current.getSelector().pulsateTag( value );
        }
        MANAGER.__instance_window_distributor.parent_windows[ MANAGER.__instance_element_distributor.current_element.getUUID() ].pulsateElementIfNotActive( WINDOW.CONST.ELEMENT.USER_RIGHTS );
    };
    self.synchronizePlus          = function ( modified_property ) {
        var _properties = self.getSynchronizedProperty( modified_property.getName() );
        for ( var i = 0, _size_i = _properties.length; i < _size_i; i++ ) {
            if ( _properties[ i ].getName() === PROPERTY.CONST.NAME.VIEW_CONTACTS && self.isViewEveryone() ) {
                return;
            }
            if ( modified_property.state_plus !== _properties[ i ].state_plus ) {
                _properties[ i ].clickOnBtnPlus();
            }
        }
    };
    //********************************************  GETTER SETTER     **************************************************//
    self.isViewEveryone           = function () {
        if ( !self.has_everybody_default ) {
            return false;
        }
        var _view_user_group_value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ).getFlatValue();
        if ( _view_user_group_value && _view_user_group_value !== PROPERTY.CONST.STATE_VALUE_PLUS.ON ) {
            return false;
        }
        var _view_user_value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.VIEW_CONTACTS ).getFlatValue();
        return !_view_user_value || _view_user_value === PROPERTY.CONST.STATE_VALUE_PLUS.ON || _view_user_value === 'everyone';
    };
    self._prop                    = function ( property_name, synchro_name ) {
        if ( synchro_name ) {
            return MANAGER.__instance_property_distributor.findElement( property_name, false, false, false, synchro_name );
        }
        return MANAGER.__instance_property_distributor.getElement( property_name );
    };
    self.getSynchronizedProperty  = function ( property_name, is_synchro ) {
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                return [self._prop( PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS, is_synchro ), self._prop( PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS, is_synchro )];
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                return [self._prop( PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS, is_synchro ), self._prop( PROPERTY.CONST.NAME.EDITION_CONTACTS, is_synchro )];
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
                return [self._prop( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS, is_synchro )];
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
                return [self._prop( PROPERTY.CONST.NAME.VIEW_CONTACTS, is_synchro )];
        }
    };
    return self;
})( PROPERTY.UserRightsBehaviour || {} );