%group_name = ""
%group_name_label = ""
%if 'is_mass_change' not in locals():
    %is_mass_change=False
%end
%if is_mass_change:
    %group_name = "mass-change"
    %group_name_label = "-mass-change"
    %list_tab_for_element = ['generic']
%end

<form id="id-shinken-form-element" data-has-template="0" data-type={{item_type}} name='form-element' class='form-element no-margin form-inline gray-back '>
    <div class="shinken-form-container">
        %if is_mass_change:
        <table class="shinken-mass-change-navigation">
            <tr class="shinken-window-group" data-name="{{group_name}}" onclick="MANAGER.EventManager.clickOnWindowNavigation(event,'{{group_name}}')">
                %for current_tab in list_tab_for_element:
                %include( "__print_element_td_tab", app=app, name=current_tab , label=app._('element.%s' % current_tab), group_name=group_name, has_properties=True )
                %end
            </tr>
        </table>
        %else:
        %include( "__print_element_li_tab", app=app, list=list_tab_for_element, has_properties=False)
        %end
        <div class="shinken-tab-content tab-content tab-area">
            <div {{!helper.get_window_target_div('generic', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        %if not is_mass_change:
                            {{!helper.get_string_input(item, 'timeperiod_name', item_type, is_disabled=is_disabled_name, required=True)}}
                            {{!helper.get_bool_input(item, 'enabled', item_type, is_disabled=is_disabled, default=True)}}
                        %end
                        {{!helper.get_string_input(item, 'pack', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type_1', title=app._('timeperiods.group_days'))}}
                            {{!helper.get_multiple_line_object(item, 'monday', item_type, type="period_day_type", is_disabled=is_disabled, separator_line_html="-#-", separator_line_saved="-#-", separator_key_value_saved="~#~", mass_change=is_mass_change)}}
                            {{!helper.get_multiple_line_object(item, 'tuesday', item_type, type="period_day_type", is_disabled=is_disabled, separator_line_html="-#-", separator_line_saved="-#-", separator_key_value_saved="~#~", mass_change=is_mass_change)}}
                            {{!helper.get_multiple_line_object(item, 'wednesday', item_type, type="period_day_type", is_disabled=is_disabled, separator_line_html="-#-", separator_line_saved="-#-", separator_key_value_saved="~#~", mass_change=is_mass_change)}}
                            {{!helper.get_multiple_line_object(item, 'thursday', item_type, type="period_day_type", is_disabled=is_disabled, separator_line_html="-#-", separator_line_saved="-#-", separator_key_value_saved="~#~", mass_change=is_mass_change)}}
                            {{!helper.get_multiple_line_object(item, 'friday', item_type, type="period_day_type", is_disabled=is_disabled, separator_line_html="-#-", separator_line_saved="-#-", separator_key_value_saved="~#~", mass_change=is_mass_change)}}
                            {{!helper.get_multiple_line_object(item, 'saturday', item_type, type="period_day_type", is_disabled=is_disabled, separator_line_html="-#-", separator_line_saved="-#-", separator_key_value_saved="~#~", mass_change=is_mass_change)}}
                            {{!helper.get_multiple_line_object(item, 'sunday', item_type, type="period_day_type", is_disabled=is_disabled, separator_line_html="-#-", separator_line_saved="-#-", separator_key_value_saved="~#~", mass_change=is_mass_change)}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type_1', title=app._('timeperiods.group_advanced'))}}
                            {{!helper.get_multiple_line_object(item, 'advanced_time_periods', item_type, type="period_advanced_type",is_disabled=is_disabled, separator_line_saved="-#-", separator_key_value_saved="~#~", separator_line_html="BACK_TO_LINE", separator_key_value_html=" ", hide_import_key=1, mass_change=is_mass_change)}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type_1', title=app._('timeperiods.group_exclude'))}}
                            {{!helper.get_multiselect_input(item, 'exclude', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        </tbody>
                    </table>
                </div>
            </div>
            %if not is_mass_change:
            %if display_changes:
            <div {{!helper.get_window_target_div('changes', group_name_label, selected_tab)}} >
                %include("__print_pane_change", locals=locals())
            </div>
            %end
            %end
        </div>
    </div>
</form>