%import re
%from ...dao.def_items import ITEM_TYPE, DEF_ITEMS, METADATA

%if item_type == ITEM_TYPE.SERVICESCLUSTERS:
    %default = 'cluster'
    %same_as_object_trad=app._('element.same_as_cluster')
    %same_as_object_key='same_as_cluster'
%elif item_type == ITEM_TYPE.SERVICESCLUSTERTPLS:
    %default = 'cluster'
    %same_as_object_trad=app._('element.same_as_cluster')
    %same_as_object_key='same_as_cluster'
%elif item_type == ITEM_TYPE.SERVICESHOSTTPLS:
    %default = 'host'
    %same_as_object_trad=app._('element.same_as_host')
    %same_as_object_key='same_as_host'
%elif item_type == ITEM_TYPE.SERVICESHOSTS:
    %default = 'host'
    %same_as_object_trad=app._('element.same_as_host')
    %same_as_object_key='same_as_host'
%else:
    %default = 'cluster or host'
    %same_as_object_trad=app._('element.same_as_host')
    %same_as_object_key='same_as_host'
%end

%window_uuid = METADATA.get_metadata(shinken_element_original, METADATA.WINDOW_UUID)

%window_uuid_label = "-%s" % window_uuid

%# is the element globally editable or just the name that is restricted
%is_disabled = shinken_element_overridden.get('editable', '1') == '0'
%is_admin_si = user.get('is_admin','0') != '1'

<div class="shinken-check-override-container" >
    <div class="shinken-close-override-tab shinken-text-right" onclick="MANAGER.EventManager.clickOnSetOverride('{{window_uuid}}')" >
        <span class="shinkon-times"></span>
    </div>
    <div class="shinken-override-title">{{app._('element.check_override_title')}}</div>
    <table class="shinken-check-override-navigation">
        <tr class="shinken-window-group" data-name="{{window_uuid}}" onclick="MANAGER.EventManager.clickOnWindowNavigation(event,'{{window_uuid}}')">
            %include( "__print_element_td_tab", app=app, name='generic-override' , label=app._('element.generic'), group_name=window_uuid, extra_class='shinken-active', has_properties=True)
            %include( "__print_element_td_tab", app=app, name='datas-override' , label=app._('element.datas'), group_name=window_uuid, extra_class='', has_properties=True)
            %include( "__print_element_td_tab", app=app, name='monitoring-override' , label=app._('element.monitoring'), group_name=window_uuid, extra_class='', has_properties=True)
            %include( "__print_element_td_tab", app=app, name='notifications-override' , label=app._('element.notifications') , group_name=window_uuid, extra_class='', has_properties=True)
            %include( "__print_element_td_tab", app=app, name='advanced-override' , label=app._('element.advanced') , group_name=window_uuid, extra_class='', has_properties=True )
        </tr>
    </table>
    <div class="shinken-check-override-table-container">
        <table class="shinken-check-override-table">
        <tr class="shinken-check-override-table-header">
            <th class="shinken-check-override-table-header-property" >{{app._('element.property')}}</th>
            <th class="shinken-check-override-table-header-value">{{app._('element.value_overridden')}}</th>
            <th class="shinken-check-override-table-header-check-value">{{app._('element.value_check')}}</th>
        </tr>
        <tr class="shinken-check-override-table-separator">
            <th colspan="3"><div class="shinken-separator"><hr></div></th>
        </tr>
        <tbody {{!helper.get_window_target_div('generic-override', window_uuid_label, 'generic-override', extra_class="shinken-prop-table")}} >
            {{!helper.get_string_input(shinken_element_overridden, 'service_description', item_type, is_disabled=True, shinken_element_original=shinken_element_original)}}
            {{!helper.get_multiselect_input(shinken_element_overridden, 'use', item_type, ITEM_TYPE.SERVICETPLS, is_disabled=True,  shinken_element_original=shinken_element_original)}}
            {{!helper.get_slider_input(shinken_element_overridden, 'business_impact', item_type, is_disabled=is_disabled, default=same_as_object_trad, data_min=0, data_max=5, data_type='range_business_impact', shinken_element_original=shinken_element_original )}}
            {{!helper.get_string_input(shinken_element_overridden, 'notes_url', item_type, is_disabled=is_disabled, shinken_element_original=shinken_element_original)}}
            {{!helper.get_multiple_line_object(shinken_element_overridden, 'notes_multi_url', item_type, type="notes_multi_url", is_disabled=is_disabled, shinken_element_original=shinken_element_original, separator_line_saved="~#~", separator_key_value_html="~=", separator_key_value_saved="~=", separator_line_html="~#~")}}
        </tbody>
        <tbody {{!helper.get_window_target_div('datas-override', window_uuid_label, 'generic-override', extra_class="shinken-prop-table")}} >
            %for data_prop in data_on_check:
                {{ !helper.get_data_property_html(shinken_element_overridden, item_type, data_prop, shinken_element_original=shinken_element_original, is_disabled=is_disabled) }}
            %end

            %for data_prop in data_not_on_check:
                {{ !helper.get_data_property_html(shinken_element_overridden, item_type, data_prop, shinken_element_original=shinken_element_original, is_disabled=is_disabled, extra_class='shinken-disabled-and-unknown') }}
            %end

            %if not data_on_check and not data_not_on_check:
                <tr class="shinken-no-data-line"><td colspan="3"><h3 class="shinken-label">{{app._('element.no_data_for_check')}}</h3></td></tr>
            %end
        </tbody>
        <tbody {{!helper.get_window_target_div('monitoring-override', window_uuid_label, 'generic-override', extra_class="shinken-prop-table")}} >
            {{!helper.get_select_input(shinken_element_overridden, 'maintenance_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, default=same_as_object_trad, shinken_element_original=shinken_element_original )}}

            {{!helper.get_property_group('type1', title=app._('element.title_checking_status_element'))}}
            {{!helper.get_property_sub_group_start('type1', title=app._('element.title_active'))}}
            {{!helper.get_bool_input(shinken_element_overridden, 'active_checks_enabled', item_type, default=True, is_disabled=is_disabled or is_admin_si, shinken_element_original=shinken_element_original )}}
            {{!helper.get_command_input(shinken_element_overridden, 'check_command', item_type, ITEM_TYPE.COMMANDS, is_disabled=(True if is_disabled else 2), shinken_element_original=shinken_element_original )}}
            {{!helper.get_select_input(shinken_element_overridden, 'check_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, default=same_as_object_trad, none_text='%s'% same_as_object_trad, shinken_element_original=shinken_element_original)}}
            {{!helper.get_string_input(shinken_element_overridden, 'max_check_attempts', item_type, is_disabled=is_disabled, shinken_element_original=shinken_element_original)}}
            {{!helper.get_string_input(shinken_element_overridden, 'check_interval', item_type, is_disabled=is_disabled, shinken_element_original=shinken_element_original)}}
            {{!helper.get_string_input(shinken_element_overridden, 'retry_interval', item_type, is_disabled=is_disabled, shinken_element_original=shinken_element_original)}}
            {{!helper.get_string_input(shinken_element_overridden, 'check_running_timeout', item_type, is_disabled=is_disabled, default=same_as_object_trad, shinken_element_original=shinken_element_original)}}
            {{!helper.get_string_input(shinken_element_overridden, 'warning_threshold_cpu_usage', item_type, is_disabled=is_disabled, default=same_as_object_trad, shinken_element_original=shinken_element_original)}}
            {{!helper.get_property_sub_group_end()}}
            {{!helper.get_property_sub_group_start('type1', title=app._('element.title_passive'))}}
            {{!helper.get_bool_input(shinken_element_overridden, 'passive_checks_enabled', item_type, is_disabled=is_disabled or is_admin_si, default=True, shinken_element_original=shinken_element_original )}}
            {{!helper.get_bool_input(shinken_element_overridden, 'check_freshness', item_type, is_disabled=is_disabled or is_admin_si, default=False, shinken_element_original=shinken_element_original )}}
            {{!helper.get_string_input(shinken_element_overridden, 'freshness_threshold', item_type, is_disabled=is_disabled, shinken_element_original=shinken_element_original)}}
            {{!helper.get_property_sub_group_end()}}

            {{!helper.get_property_group('type1', title=app._('element.title_collected_data'))}}
            {{!helper.get_property_sub_group_start('type1', title=app._('element.metrology'))}}
            {{!helper.get_bool_input(shinken_element_overridden, 'process_perf_data', item_type, is_disabled=is_disabled or is_admin_si, default=True, shinken_element_original=shinken_element_original )}}
            {{!helper.get_property_sub_group_end()}}
            {{!helper.get_property_sub_group_start('type1', title=app._('element.sla'))}}
            {{!helper.get_slider_input(shinken_element_overridden, 'sla_warning_threshold', item_type, is_disabled=is_disabled, data_unit='%', data_type='range_with_input', data_digits=3, shinken_element_original=shinken_element_original)}}
            {{!helper.get_slider_input(shinken_element_overridden, 'sla_critical_threshold', item_type, is_disabled=is_disabled, data_unit='%', data_type='range_with_input', data_digits=3, shinken_element_original=shinken_element_original)}}
            {{!helper.get_property_sub_group_end()}}

        </tbody>
        <tbody {{!helper.get_window_target_div('notifications-override', window_uuid_label, 'generic-override', extra_class="shinken-prop-table")}} >
            {{!helper.get_bool_input(shinken_element_overridden, 'notifications_enabled', item_type, is_disabled=is_disabled, default=same_as_object_trad, shinken_element_original=shinken_element_original )}}
            {{!helper.get_multiselect_input(shinken_element_overridden, 'contacts', item_type, ITEM_TYPE.CONTACTS, is_disabled=is_disabled, default=same_as_object_key,  shinken_element_original=shinken_element_original)}}
            {{!helper.get_multiselect_input(shinken_element_overridden, 'contact_groups', item_type, ITEM_TYPE.CONTACTGROUPS, is_disabled=is_disabled, default=same_as_object_key,  shinken_element_original=shinken_element_original)}}
            {{!helper.get_string_input(shinken_element_overridden, 'notification_interval', item_type, is_disabled=is_disabled, default=same_as_object_trad, shinken_element_original=shinken_element_original)}}
            {{!helper.get_select_input(shinken_element_overridden, 'notification_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, default=same_as_object_trad, none_text='%s' % same_as_object_trad, shinken_element_original=shinken_element_original)}}
            {{!helper.get_string_input(shinken_element_overridden, 'notification_options', item_type, is_disabled=is_disabled, default=same_as_object_trad, shinken_element_original=shinken_element_original)}}
            {{!helper.get_string_input(shinken_element_overridden, 'first_notification_delay', item_type, is_disabled=is_disabled, default=same_as_object_trad, shinken_element_original=shinken_element_original)}}
            {{!helper.get_multiselect_input(shinken_element_overridden, 'escalations', item_type, ITEM_TYPE.ESCALATIONS, is_disabled=is_disabled, default=same_as_object_key,  shinken_element_original=shinken_element_original)}}
        </tbody>
        <tbody {{!helper.get_window_target_div('advanced-override', window_uuid_label, 'generic-override', extra_class="shinken-prop-table")}} >
            <tr>
                <td colspan="3">
                    <table class="shinken-prop-table">
                        <tbody>
                            {{!helper.get_bool_input(shinken_element_overridden, 'is_volatile', item_type, is_disabled=is_disabled, default=False, shinken_element_original=shinken_element_original )}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type1', title=app._('element.title_setting_flapping'))}}
                            {{!helper.get_bool_input(shinken_element_overridden, 'flap_detection_enabled', item_type, is_disabled=is_disabled, default=True, shinken_element_original=shinken_element_original )}}
                            {{!helper.get_string_input(shinken_element_overridden, 'flap_detection_options', item_type, is_disabled=is_disabled, default='o,w,c,u', shinken_element_original=shinken_element_original)}}
                            {{!helper.get_slider_input(shinken_element_overridden, 'low_flap_threshold', item_type, is_disabled=is_disabled, data_unit='%', shinken_element_original=shinken_element_original )}}
                            {{!helper.get_slider_input(shinken_element_overridden, 'high_flap_threshold',item_type, is_disabled=is_disabled, data_unit='%', shinken_element_original=shinken_element_original )}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type1', title=app._('element.title_modulation'))}}
                            {{!helper.get_multiselect_input(shinken_element_overridden, 'business_impact_modulations', item_type, ITEM_TYPE.BUSINESSIMPACTMODULATIONS, is_disabled=is_disabled, default=same_as_object_key ,  shinken_element_original=shinken_element_original)}}
                            {{!helper.get_multiselect_input(shinken_element_overridden, 'macromodulations', item_type, ITEM_TYPE.MACROMODULATIONS, default='none', is_disabled=is_disabled, shinken_element_original=shinken_element_original)}}
                            {{!helper.get_multiselect_input(shinken_element_overridden, 'resultmodulations', item_type, ITEM_TYPE.RESULTMODULATIONS, default=same_as_object_key, is_disabled=is_disabled, shinken_element_original=shinken_element_original)}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type1', title=app._('element.title_event_handler'))}}
                            {{!helper.get_bool_input(shinken_element_overridden, 'event_handler_enabled', item_type, is_disabled=is_disabled, default=False, shinken_element_original=shinken_element_original )}}
                            {{!helper.get_command_input(shinken_element_overridden, 'event_handler', item_type, ITEM_TYPE.COMMANDS, is_disabled=True, shinken_element_original=shinken_element_original )}}
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
    </div>
</div>