%import urllib
%rebase( "layout_skonf", page_id="logger_control", title=app._('logger_control.title'))

<link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/logger_control/css/logger_control.css">

<div class="elements-panel">
    %for daemon_type, logger_control_info in logger_control_infos.iteritems():
        <h1>{{daemon_type}}</h1>
        %for daemon_info in logger_control_info:
            <h2>{{daemon_info['name']}} ( {{'https' if daemon_info['use_ssl'] else 'http'}}://{{daemon_info['address']}}:{{daemon_info['port']}} )</h2>

            <table>
                <thead>
                    <tr>
                        <th>name</th>
                        <th>enable</th>
                    </tr>
                </thead>
                <tbody>
                    %for log_info in daemon_info['all_log_info']:
                        <tr>
                            <td>{{log_info['name']}}</td>
                            <td>{{log_info['enable']}} <a href="/enable_log?{{urllib.urlencode({'daemon_name':daemon_info['name'], 'logger_id':log_info['id'], 'enable' : '0' if log_info['enable'] else '1'})}}"> change it</a></td>
                        </tr>
                    %end
                </tbody>
            </table>
        %end
    %end
</div >