//////////////////////////////////////////////////////////////////////////////////////////////
//                                                InlineSpinner
//    it will manage one spinner life
//////////////////////////////////////////////////////////////////////////////////////////////
var spinners_chars = [ "⣷", "⣯", "⣟", "⡿", "⢿", "⣻", "⣽", "⣾" ];

var SPINNNER_STATE_CLEAN         = 0;
var SPINNNER_STATE_FAST          = 1;
var SPINNNER_STATE_SLOW          = 2;
var SPINNNER_STATE_OK            = 3;
var SPINNNER_STATE_ERROR         = 4;
var SPINNNER_STATE_ERROR_TIMEOUT = 5;
var SPINNNER_STATE_ERROR_AUTH    = 6;


var SOURCE_STATE = {
    NEW   : "new",
    CHANGE: "change",
    IMPORT: ""
};

function InlineSpinner ( dom_container, parent_dom_container ) {
    this.spinner_idx              = 0;
    this.spinner_fast_update_time = 100;
    this.spinner_low_update_time  = 500;
    this.dom_container            = dom_container;
    this.parent_dom_container     = parent_dom_container;
    // By default nothing is printed
    this.set_clean( 'clean' );
};


// We can have some state class on our dom object, and when we are adding a new one, we remove all the others
InlineSpinner.prototype._set_dom_class = function ( klass ) {
    var all_possible_states = [ 'ok', 'error', 'pending', 'running', 'clean' ];
    for ( var i = 0; i < all_possible_states.length; i++ ) {
        this.dom_container.removeClass( all_possible_states[ i ] );
    }
    this.dom_container.addClass( klass );
};


InlineSpinner.prototype.set_clean = function () {
    if ( this.state === SPINNNER_STATE_CLEAN ) {
        return;
    }
    this.setState( SPINNNER_STATE_CLEAN );
    this._set_dom_class( 'clean' );
    this.tick();
};
InlineSpinner.prototype.set_low   = function () {
    if ( this.state === SPINNNER_STATE_SLOW ) {
        return;
    }
    
    this.setState( SPINNNER_STATE_SLOW );
    this._set_dom_class( 'pending' );
    this.tick();
    
};
InlineSpinner.prototype.set_fast  = function () {
    if ( this.state === SPINNNER_STATE_FAST ) {
        return;
    }
    this.setState( SPINNNER_STATE_FAST );
    this._set_dom_class( 'running' );
    this.tick();
};
InlineSpinner.prototype.set_ok    = function () {
    if ( this.state === SPINNNER_STATE_OK ) {
        return;
    }
    
    this.setState( SPINNNER_STATE_OK );
    this._set_dom_class();
    this._set_dom_class( 'ok' );
    this.tick();
};

InlineSpinner.prototype.set_error = function () {
    this.setState( SPINNNER_STATE_ERROR );
    this._set_dom_class( 'error' );
    this.tick();
};

InlineSpinner.prototype.set_error_auth = function () {
    this.setState( SPINNNER_STATE_ERROR_AUTH );
    this._set_dom_class( 'error-auth' );
    this.tick();
};

InlineSpinner.prototype.set_error_timeout = function () {
    this.setState( SPINNNER_STATE_ERROR_TIMEOUT );
    this._set_dom_class( 'error-timeout' );
    this.tick();
};

InlineSpinner.prototype.setState = function ( to_set ) {
    this.state = to_set;
    this.parent_dom_container.attr( 'data-state', this.state );
};


InlineSpinner.prototype.tick = function () {
    var self = this;
    
    // Maybe we are stopping: clean and do not call us again
    if ( this.state === SPINNNER_STATE_CLEAN ) {
        this.dom_container.html( '🔎' );
        return;
    }
    
    // Ok and ERROR are printing the result, but do not need any more loop
    if ( this.state === SPINNNER_STATE_OK ) {
        this.dom_container.html( '√' );
        return;
    }
    else if ( this.state === SPINNNER_STATE_ERROR ) {
        this.dom_container.html( 'Х' );
        return;
    }
    else if ( this.state === SPINNNER_STATE_ERROR_TIMEOUT ) {
        //this.dom_container.html( '🔎' );
        this.dom_container.html( '?' );
        return;
    }
    else if ( this.state === SPINNNER_STATE_ERROR_AUTH ) {
        this.dom_container.html( '🔐' );
        return;
    }
    this.spinner_idx += 1;
    this.spinner_idx %= spinners_chars.length;
    this.dom_container.html( spinners_chars[ this.spinner_idx ] );
    var next_tick = 1000;
    if ( this.state === SPINNNER_STATE_SLOW ) {
        next_tick = this.spinner_low_update_time;
    }
    if ( this.state === SPINNNER_STATE_FAST ) {
        next_tick = this.spinner_fast_update_time;
    }
    
    setTimeout( function () {
        self.tick();
    }, next_tick );
};


//////////////////////////////////////////////////////////////////////////////////////////////
//                                                JobInstance
//    it will manage one specific job, and the display of this job on the page
//////////////////////////////////////////////////////////////////////////////////////////////

// From analyzer controller
JOB_STATE_PENDING       = 1;
JOB_STATE_RUNNING       = 2;
JOB_STATE_OK            = 3;
JOB_STATE_ERROR         = 4;
JOB_STATE_ERROR_TIMEOUT = 5;
JOB_STATE_ERROR_AUTH    = 6;

function JobInstance ( host_uuid ) {
    this.host_uuid = host_uuid;
    this.state     = null;
    
    // When we are create, the dom is already loaded
    this.dom_row = $( '.analyze-object[data-host-uuid="' + host_uuid + '"]' );
    //console.log( 'DOM ROW', this.host_uuid, this.dom_row );
    
    var spinner_dom_container     = this.dom_row.find( '.job-state-spinner' );
    this.diff_state_dom_container = this.dom_row.find( '.diff-state' );
    this.new_state_dom_container  = this.dom_row.find( '.new-state' );
    
    this.spinner = new InlineSpinner( spinner_dom_container, this.dom_row );
    
    
    this.templates_dom_container = this.dom_row.find( '.col.templates' );  // Where we will display templates when OK
    
    this.show_results_icon_dom = this.dom_row.find( '.analyze-show-detail-btn' ); // Button to show details
    
    // Detail row
    this.analyse_details_dom_row = $( '.analyze-object-details-row[data-host-uuid="' + host_uuid + '"]' );
    this.analyse_details_dom     = this.analyse_details_dom_row.find( '.analyze-object-details' );
    
}


JobInstance.prototype.set_pending = function () {
    // Do not set twice
    if ( this.state === JOB_STATE_PENDING ) {
        return;
    }
    this.state = JOB_STATE_PENDING;
    this.spinner.set_low();
};

JobInstance.prototype._show_results_icon = function () {
    this.show_results_icon_dom.addClass( 'shown' );
};
JobInstance.prototype._hide_results_icon = function () {
    this.show_results_icon_dom.removeClass( 'shown' );
};

function _toggle_results_details ( element ) {
    var _state = parseInt( element.dataset.state );
    switch ( _state ) {
        case SPINNNER_STATE_CLEAN:
        case SPINNNER_STATE_FAST:
        case SPINNNER_STATE_SLOW:
            break;
        case SPINNNER_STATE_OK:
        case SPINNNER_STATE_ERROR:
        case SPINNNER_STATE_ERROR_TIMEOUT:
        case SPINNNER_STATE_ERROR_AUTH:
            var _uuid_host          = element.dataset.hostUuid;
            var _detail_dom_element = document.querySelector( '.analyze-object-details-row[data-host-uuid="' + _uuid_host + '"]' );
            _detail_dom_element.classList.toggle( 'shown' );
            break;
    }
}

JobInstance.prototype._set_row_style_as_done    = function () {
    this.dom_row.addClass( 'shinken-done' );
};
JobInstance.prototype._set_row_style_as_started = function () {
    this.dom_row.removeClass( 'shinken-done' );
};


JobInstance.prototype._fill_ok_job_details = function ( job_result ) {
    var data_keys = [];
    for ( var key in job_result.analyze_result ) {
        // skip loop if the property is from prototype
        if ( !job_result.analyze_result.hasOwnProperty( key ) ) {
            continue;
        }
        // We do not want to show some values that the user won't understand
        if ( key === '_SYNC_KEYS' || key === '_AGENT_UUID' || key === '_id' || key === 'source_order' || key === 'imported_from' || key === 'import_date' || key === '@metadata' ) {
            continue;
        }
        data_keys.push( key );
    }
    // Put properties first, then DATA
    data_keys.sort( function ( a, b ) {
        if ( a[ 0 ] === '_' && b[ 0 ] !== '_' ) {
            return 1;
        }
        if ( a[ 0 ] !== '_' && b[ 0 ] === '_' ) {
            return -1;
        }
        return (a <= b);
        
    } );
    var html = '<ul>';
    for ( var j = 0; j < data_keys.length; j++ ) {
        var key = data_keys[ j ];
        html += '<li><div class="result-key">' + key + ':</div><div class="result-value">' + job_result.analyze_result[ key ] + '</div></li>';
    }
    html += '</ul>';
    this.analyse_details_dom.html( html );
};



JobInstance.prototype._fill_error_job_details = function ( job_result ) {
    this.analyse_details_dom.html( job_result.analyze_log );
};

JobInstance.prototype.set_ok = function ( job_result ) {
    // Do not set twice
    if ( this.state === JOB_STATE_OK ) {
        return;
    }
    this.state = JOB_STATE_OK;
    this.spinner.set_ok();
    //console.log( 'JOB RESULT', job_result );
    // Also print the templates founded
    this.templates_dom_container.html( job_result.analyze_result.use );
    this._set_row_style_as_done();
    // Also show the results icons to show more details
    this._show_results_icon();
    
    // Also fill the detail output
    this._fill_ok_job_details( job_result );
};


JobInstance.prototype.set_error = function ( job_result ) {
    // Do not set twice
    if ( this.state >= JOB_STATE_ERROR ) {
        return;
    }
    //console.log( 'job::set error', this.host_uuid );
    this.state = job_result.status;
    if ( this.state == JOB_STATE_ERROR ) {
        this.spinner.set_error();
    }
    else if ( this.state == JOB_STATE_ERROR_TIMEOUT ) {
        this.spinner.set_error_timeout();
    }
    else if ( this.state == JOB_STATE_ERROR_AUTH ) {
        this.spinner.set_error_auth();
    }
    
    this._set_row_style_as_done();
    this._show_results_icon();
    
    // Also fill the job log errors on the detail row
    this._fill_error_job_details( job_result );
};


JobInstance.prototype.set_running = function () {
    // Do not set twice
    if ( this.state === JOB_STATE_RUNNING ) {
        return;
    }
    this.state = JOB_STATE_RUNNING;
    this.spinner.set_fast();
};

JobInstance.prototype.set_diff_state = function ( diff_state ) {
    if ( this.state !== JOB_STATE_OK ) {
        return;
    }
    if ( diff_state === SOURCE_STATE.CHANGE ) {
        this.diff_state_dom_container.show();
    }
    else if ( diff_state === SOURCE_STATE.NEW ) {
        this.new_state_dom_container.show();
    }
};

// The analyzer did fail in a wait, clean all
JobInstance.prototype.hard_reset = function () {
    this.spinner.set_clean();
};
JobInstance.prototype.clean_all  = function () {
    this.spinner.set_clean();
    this._hide_results_icon();
    this._set_row_style_as_started();
};

//////////////////////////////////////////////////////////////////////////////////////////////
//                                                AnalyzerManager
//    is the object that launch new jobs and let the others parts know about results
//    and when it's done.
//////////////////////////////////////////////////////////////////////////////////////////////
function analyze_show_results_details () {
    $( '#analyzer-long-results' ).show();
}


function analyzerManager () {
    this.hosts_in_analyze               = [];  // Current list of the hosts that are NOT FINISH to analyze
    this.hosts_analyze_done             = [];  // Current list of the hosts that have been analyzed and wait for diff
    this.job_uuids_in_progress          = {};
    this.job_uuids_in_progress_inverted = {};
    
    this.jobs_in_errors = [];
    this.jobs_ok        = [];
    
    this.is_in_analyze      = false;  // We cannot have 2 analyze ask in the same time
    this.tick_lock          = false;  // We should not ask 2 times in // for the results, or we will have massive coherency issues, so lock it
    this.look_for_diff_lock = false;  // We should not ask 2 times in diffs
    
    this.spinners            = [ "⣷", "⣯", "⣟", "⡿", "⢿", "⣻", "⣽", "⣾" ];
    this.spinner_idx         = 0;
    this.spinner_update_time = 100; // 100ms by default
    
    this.all_jobs = {};
    for ( var i = 0; i < g_host_uuids_to_analyze.length; i++ ) {
        var host_entry                        = g_host_uuids_to_analyze[ i ];
        this.all_jobs[ host_entry.host_uuid ] = new JobInstance( host_entry.host_uuid );
    }
    
    this._is_analysis_in_progress               = false;
    this._is_source_was_disabled_during_analyze = true;
    
    this.dom_analyze_btn             = $( '#analyze-button' ).parent();
    this.dom_analyze_working_counter = $( '#analyze-working-counter' );
    this.dom_analyze_alert_message   = $( '#analyse-results-cont .shinken-alert' );
}

analyzerManager.prototype._get_overload_parameters = function () {
    var res        = {};
    var all_inputs = $( '#analyzer-launch-form .analyze-parameter-overload-input' );
    for ( var i = 0; i < all_inputs.length; i++ ) {
        var input = $( all_inputs[ i ] );
        if ( input.val() !== '' ) {
            res[ input.attr( 'name' ) ] = input.val();
        }
    }
    return res;
};

analyzerManager.prototype.cleanAllOldDatas = function () {
    var _keys = Object.keys( this.all_jobs );
    
    var _size = _keys.length;
    if ( !_size ) {
        return;
    }
    
    var _current;
    for ( var i = 0; i < _size; i++ ) {
        _current = this.all_jobs[ _keys[ i ] ];
        _current.analyse_details_dom.empty();
        _current._hide_results_icon();
        _current.diff_state_dom_container.hide();
        _current.new_state_dom_container.hide();
        _current.templates_dom_container.empty();
    }
};
analyzerManager.prototype.launch_analyze   = function () {
    this.uuid                     = App.Scope.generateUuid();
    this._is_analysis_in_progress = true;
    
    // Already working, do not stack any more
    if ( this.is_in_analyze ) {
        return;
    }
    this.cleanAllOldDatas();
    
    var _all_lines = $( '.analyze-object' );
    var to_analyze = {};
    
    for ( var i = 0; i < _all_lines.length; i++ ) {
        var _line                               = $( _all_lines[ i ] );
        var host_state                          = _line.data( 'host_state' );
        to_analyze[ _line.data( 'host-uuid' ) ] = host_state;
    }
    var hosts_uuid = Object.keys( to_analyze );
    // If we did select no element, bail out
    if ( hosts_uuid.length === 0 ) {
        return;
    }
    
    // Ok we will work
    this.hosts_in_analyze = hosts_uuid;
    this._enter_in_analyze();
    
    var overload_parameters = this._get_overload_parameters();
    
    // ask the back to do the job, and get our batch_id from it, we will be in_analyze until all this job is done
    $.ajax( {
        context: this,
        type   : "post",
        data   : { 'hosts_to_analyze': JSON.stringify( to_analyze ), 'overload_parameters': JSON.stringify( overload_parameters ), 'analyzer_name': 'server-analyzer', 'launch_batch_uuid': this.uuid },
        url    : COMMUNICATION.QUERY.GET.SOURCE.ANALYZER.LAUNCH_BATCH + '?ts=' + DATE_TIME.getTimestampNow(),
        success: this._launch_analyze_success_callback,
        error  : this._launch_analyze_error_callback
    } );
};

analyzerManager.prototype._launch_analyze_success_callback = function ( data ) {
    // Get gt a list of (host_uuid, job_uuid)
    if ( !data.source_is_enabled ) {
        this._prohibit_analysis();
    }
    for ( var i = 0; i < data.jobs.length; i++ ) {
        var host_uuid                                   = data.jobs[ i ][ 0 ];
        var job_uuid                                    = data.jobs[ i ][ 1 ];
        this.job_uuids_in_progress[ host_uuid ]         = job_uuid;
        this.job_uuids_in_progress_inverted[ job_uuid ] = host_uuid;
    }
};

analyzerManager.prototype._launch_analyze_error_callback = function ( data, txt ) {
    //form_error( data, 'launch_analyze' );
    this._hard_reset();
};

analyzerManager.prototype._show_alert_message   = function () {
    this.dom_analyze_alert_message.removeClass( 'hide' );
};
analyzerManager.prototype._hide_alert_message   = function () {
    this.dom_analyze_alert_message.addClass( 'hide' );
};
analyzerManager.prototype._disabled_btn_analyze = function () {
    this.dom_analyze_btn.addClass( 'shinken-content-disabled' );
};
analyzerManager.prototype._enabled_btn_analyze  = function () {
    this.dom_analyze_btn.removeClass( 'shinken-content-disabled' );
};

analyzerManager.prototype._enter_in_analyze = function () {
    this.is_in_analyze = true;
    this._start_spinner();
    this._update_working_counter();
    this._disabled_btn_analyze();
    
    // And start all our jobs now
    for ( var host_uuid in this.all_jobs ) {
        // skip loop if the property is from prototype
        if ( !this.all_jobs.hasOwnProperty( host_uuid ) ) {
            continue;
        }
        this.all_jobs[ host_uuid ].set_pending();
    }
    
};


// We did fail, and we must to exit and clean all
analyzerManager.prototype._hard_reset                   = function () {
    // Standard exit
    this._exit_in_analyze();
    
    // But also hard reset of all the lines
    for ( var host_uuid in this.all_jobs ) {
        // skip loop if the property is from prototype
        if ( !this.all_jobs.hasOwnProperty( host_uuid ) ) {
            continue;
        }
        this.all_jobs[ host_uuid ].hard_reset();
    }
    this.all_jobs = {};
};
analyzerManager.prototype._clean_all                    = function () {
    // Standard exit
    this._exit_in_analyze();
    
    // But also hard reset of all the lines
    for ( var host_uuid in this.all_jobs ) {
        // skip loop if the property is from prototype
        if ( !this.all_jobs.hasOwnProperty( host_uuid ) ) {
            continue;
        }
        this.all_jobs[ host_uuid ].clean_all();
    }
};
analyzerManager.prototype._clean_all_jobs_as_at_startup = function () {
    this._clean_all();
};

analyzerManager.prototype._exit_in_analyze = function () {
    this.is_in_analyze                  = false;
    // Reset structures too
    this.hosts_in_analyze               = [];
    this.job_uuids_in_progress          = {};
    this.job_uuids_in_progress_inverted = {};
    this.jobs_in_errors                 = [];
    this.jobs_ok                        = [];
    this.hosts_analyze_done             = [];
    this._update_working_counter();
    this._enabled_btn_analyze();
    this._is_analysis_in_progress = false;
};

analyzerManager.prototype._display_diff_get_results_success_callback = function ( diff_results ) {
    // Update the menu values if possible, to show the user that it did change things
    ask_menu_update();
    for ( var i = 0; i < diff_results.length; i++ ) {
        var diff       = diff_results[ i ];
        var host_uuid  = diff[ '_id' ];
        var diff_state = diff[ 'private_state' ];
        this._set_job_in_diff_state( host_uuid, diff_state );
    }
    
    this.look_for_diff_lock = false;
    this._exit_in_analyze();
    this.refreshLastExecutionTab();
    setTimeout( function () {
        MANAGER.__instance_source_distributor.findSource( 'server-analyzer' ).askForRefresh();
        SHINKEN.TOOLS.LOADER.hide();
    }, 2000 );
    
    
};

analyzerManager.prototype.refreshLastExecutionTab = function () {
    
    
    var _url = SHINKEN.HIGHWAY.getPathWithParamsWithoutOrigin();
    $.ajax( {
        context: this,
        type   : "get",
        url    : _url,
        success: function ( data ) {
            var _div_temp                                                          = DOM.Service.createElement( 'div', {}, data );
            var _div_to_add                                                        = _div_temp.querySelector( "#tab-pane-summary-old-run-target" );
            document.getElementById( "tab-pane-summary-old-run-target" ).innerHTML = _div_to_add.innerHTML;
            initLastRun();
        },
        error  : function ( data ) {
            console.error( "The refresh of the last run tab has failed" );
        }
    } );
};

analyzerManager.prototype._display_diff = function () {
    // if we are already in a look_for_diff (post can be long), do not stack them
    if ( this.look_for_diff_lock ) {
        return;
    }
    this.look_for_diff_lock = true;
    // ask for each job ok if there is a diff or new to show
    SHINKEN.TOOLS.LOADER.show( _( "source.look_for_diff" ), true );
    $.ajax( {
        context: this,
        type   : "post",
        data   : { 'job_results': JSON.stringify( this.jobs_ok ), 'analyzer_name': 'server-analyzer' },
        url    : '/api/analyzers/get_analyze_diffs?ts=' + Date.now(),
        success: this._display_diff_get_results_success_callback,
        error  : this._analyze_get_results_error_callback
    } );
};

analyzerManager.prototype._start_spinner = function () {
    var myself = this;
    setTimeout( function () {
        myself._update_spinner();
    }, this.spinner_update_time );
};

analyzerManager.prototype._update_spinner = function () {
    var cont = $( '#analyze-working-spinner' );
    this.spinner_idx += 1;
    this.spinner_idx %= this.spinners.length;
    
    // If we are not in analyze, clean the span and do not loop over
    if ( this.is_in_analyze === false ) {
        cont.html( '' );
    }
    else {
        cont.html( this.spinners[ this.spinner_idx ] );
        // And loop over :)
        var myself = this;
        setTimeout( function () {
            myself._update_spinner();
        }, this.spinner_update_time );
    }
    
};

analyzerManager.prototype._set_job_running = function ( host_uuid ) {
    this.all_jobs[ host_uuid ].set_running();
};

analyzerManager.prototype._set_job_ok = function ( host_uuid, job_result ) {
    this.all_jobs[ host_uuid ].set_ok( job_result );
};

analyzerManager.prototype._set_job_error = function ( host_uuid, job_result ) {
    this.all_jobs[ host_uuid ].set_error( job_result );
};

analyzerManager.prototype._set_job_in_diff_state = function ( host_uuid, diff_state ) {
    this.all_jobs[ host_uuid ].set_diff_state( diff_state );
};


// We get a bunch of results like this:
//analyze = {
//            'host_uuid': host_uuid,
//            'analyze_state': 'OK',
//            'analyze_data': {},
//        }
// With state in : OK, PENDING, IN_PROGRESS, ERROR
analyzerManager.prototype.consume_analyze_results = function ( analyze_results ) {
    //console.log( 'GET analyze results', analyze_results );
    var to_del = [];
    for ( var i = 0; i < this.hosts_in_analyze.length; i++ ) {
        var host_uuid   = this.hosts_in_analyze[ i ];
        var host_result = null;
        for ( var j = 0; j < analyze_results.length; j++ ) {
            var tmp_result = analyze_results[ j ];
            if ( tmp_result.object_uuid === host_uuid ) {
                host_result = tmp_result;
                break;
            }
        }
        // TODO: what is we are missing a host from a result? why it is missing?
        if ( host_result === null ) {
            continue;
        }
        var analyze_status = host_result.status;
        // We have 2 states that means finish: OK & ERROR
        if ( analyze_status >= JOB_STATE_OK ) {
            to_del.push( host_uuid );
            if ( analyze_status >= JOB_STATE_ERROR ) {  // if error, keep it aside
                this.jobs_in_errors.push( host_result );
                this._set_job_error( host_uuid, host_result );
            }
            else {
                this.jobs_ok.push( host_result );
                this.hosts_analyze_done.push( host_uuid );
                this._set_job_ok( host_uuid, host_result );
            }
        }
        
        if ( analyze_status === JOB_STATE_RUNNING ) {
            this._set_job_running( host_uuid );
        }
    }
    
    for ( var i = 0; i < to_del.length; i++ ) {
        this.hosts_in_analyze.remove( to_del[ i ] );
    }
    // We can now update the button counter text
    this._update_working_counter();
    
    // If we did finish our job, we are done with our analyze jobs
    if ( this.hosts_in_analyze.length === 0 ) {
        if ( this.jobs_ok.length > 0 ) {
            // ask diffs for analyzed objects
            this._display_diff();
        }
        else {
            this._exit_in_analyze();
        }
    }
};


analyzerManager.prototype._update_working_counter = function () {
    //console.log( 'UPDATE WORKING COUNTER WITH' + this.hosts_in_analyze.length );
    if ( this.hosts_in_analyze.length === 0 ) {
        this.dom_analyze_working_counter.hide();
        return;
    }
    this.dom_analyze_working_counter.show();
    this.dom_analyze_working_counter.html( ' - ' + _( 'validator.state-running' ) + ': ' + this.hosts_in_analyze.length );
};

analyzerManager.prototype._prohibit_analysis = function () {
    this._clean_all_jobs_as_at_startup();
    this._disabled_btn_analyze();
    this._show_alert_message();
    this.dom_analyze_btn.attr( 'shi-tip-html', _( 'element.tooltip_analyzer_disabled' ) );
    this._is_source_was_disabled_during_analyze = true;
};
analyzerManager.prototype._allow_analysis    = function () {
    this._enabled_btn_analyze();
    this._hide_alert_message();
    this.dom_analyze_btn.attr( 'shi-tip-html', '' );
    this._is_source_was_disabled_during_analyze = false;
};


analyzerManager.prototype._analyze_get_results_success_callback = function ( analyze_results ) {
    //console.log( 'analyze get result batch', this );
    if ( !analyze_results.source_is_enabled ) {
        this._prohibit_analysis();
    }
    else {
        this.consume_analyze_results( analyze_results.data );
    }
    
    // We have our results, we can release the next tick
    this.tick_lock = false;
};

analyzerManager.prototype._analyze_get_results_error_callback = function ( data, txt ) {
    SHINKEN.TOOLS.LOADER.hide();
    this.tick_lock          = false;
    this.look_for_diff_lock = false;
    this._hard_reset();
};

analyzerManager.prototype._is_alive_source_success_callback = function ( data, textStatus, jqXHR ) {
    if ( data && data[ 'server-analyzer' ] && data[ 'server-analyzer' ][ 'enabled' ] ) {
        this._allow_analysis();
    }
};
analyzerManager.prototype._is_alive_source_error_callback   = function ( jqXHR, textStatus, errorThrown ) {
    console.error( "[Error]", jqXHR, textStatus, errorThrown );
};

analyzerManager.prototype.tick = function () {
    if ( this._is_source_was_disabled_during_analyze ) {
        $.ajax( {
            context: this,
            url    : COMMUNICATION.QUERY.GET.SOURCE.LIST.URL + '?ts=' + DATE_TIME.getTimestampNow(),
            success: this._is_alive_source_success_callback,
            error  : this._is_alive_source_error_callback
        } );
    }
    
    // ne vennez pas me casser les bonbons avec un ! pour le false, c'est illissible comme caractere, alors que false tu peux pas le rater meme a 3h du mat en debugage
    if ( this.is_in_analyze === false ) {
        return;
    }
    
    // if we are already in a tick (get can be long), do not stack them
    if ( this.tick_lock ) {
        return;
    }
    this.tick_lock = true;
    
    var jobs_uuids_to_get = [];
    for ( var i = 0; i < this.hosts_in_analyze.length; i++ ) {
        var host_uuid = this.hosts_in_analyze[ i ];
        // WARNING: maybe the analyze did start, but we did not receive the job uuid (the POST query is still in progress)
        // if so, skip this tick
        var job_uuid = this.job_uuids_in_progress[ host_uuid ];
        if ( typeof job_uuid === 'undefined' ) {
            this.tick_lock = false;
            return;
        }
        jobs_uuids_to_get.push( this.job_uuids_in_progress[ host_uuid ] );
    }
    // ask the back to do the job, and get our batch_id from it, we will be in_analyze until all this job is done
    $.ajax( {
        context: this,
        type   : "post",
        data   : { 'launch_batch_uuid': __instance_analyzer_manager.uuid },
        url    : COMMUNICATION.QUERY.GET.SOURCE.ANALYZER.GET_RESULTS + '?ts=' + DATE_TIME.getTimestampNow(),
        success: this._analyze_get_results_success_callback,
        error  : this._analyze_get_results_error_callback
    } );
    
    // NOTE: tick_lock will be unlock in the callback, until it finish, we cannot realease the lock
};
var __instance_analyzer_manager;

function launch_analyze () {
    __instance_analyzer_manager.launch_analyze();
}

function analyzer_beforeunload () {
    if ( __instance_analyzer_manager._is_analysis_in_progress ) {
        return _( 'source.analyzer_modal_leave_page' );
    }
    return null;
}

function _analyzer_unload_success_callback ( data, textStatus, jqXHR ) {
    console.info( "[Success]", data, textStatus, jqXHR );
}

function _analyzer_unload_error_callback ( jqXHR, textStatus, errorThrown ) {
    console.error( "[Error]", jqXHR, textStatus, errorThrown );
}

function analyzer_unload () {
    if ( __instance_analyzer_manager && __instance_analyzer_manager._is_analysis_in_progress ) {
        $.ajax( {
            type   : "post",
            data   : { 'launch_batch_uuid': __instance_analyzer_manager.uuid },
            url    : COMMUNICATION.QUERY.GET.SOURCE.ANALYZER.STOP_ANALYSE_BATCH + '?ts=' + DATE_TIME.getTimestampNow(),
            success: _analyzer_unload_success_callback,
            error  : _analyzer_unload_error_callback
        } );
    }
}

// Every 1s we ask for the analyzer manager to update itself


// We want to show/hide analyze parameter blocks
function toggle_analyze_parameter_overload () {
    var _dom_element = document.getElementById( 'analyzer-launch-form-cont' );
    _dom_element.classList.toggle( 'shinken-collapsed' );
}

function updateThisInputValue ( input ) {
    input.setAttribute( "value", input.value );
}