%from ...dao.def_items import ITEM_TYPE, DEF_ITEMS
%from shinken.synchronizer.dao.def_items import METADATA

%if 'working_area' not in locals():
%working_area=False
%end

%item_type = METADATA.get_metadata(item, METADATA.ITEM_TYPE)
%in_creation = METADATA.get_metadata(item, METADATA.IN_CREATION)
%name = item['discovery_name']
%title=app._('source.network_range')

%mod_type = ''
%for m in source.modules:
    %mod = m
    %mod_type = m.properties['type']
%end

%type = 'collector' if source.my_type == 'source' else source.my_type

%if 'working_area' not in locals():
%working_area=False
%end
%presence_protection = False
%protected_fields = False
%is_disabled = False
%display_changes = False
%selected_tab =  'generic'

%rebase( "elements_base", title=title,  css=['elements/css/jquery-ui.css', 'elements/css/elements.css'])
%list_tab_for_element = ['generic']

<script>
    SOURCE_NAME = "{{source_name}}";
</script>
<script src="/static/{{app.http_start_time}}/sources/js/configuration_source_controller.js"></script>
<link href="/static/{{app.http_start_time}}/css/source/network-range.css" rel="stylesheet">
<div class="shinken-content-header cover">
    <div class="area-header shinken-area-header">
        <div class="shinken-network-area-banner">
            <table class="shinken-table-source-ip-range">
                <tr>
                    <td>
                        <div class="shinken-path-link-container">
                            <a class="shinken-link shinken-path-link" href="/main" target="_parent">
                                {{app._('main.sources_maj')}}
                            </a>
                            >
                            %if type == 'collector':
                                <a class="shinken-path-link" href="/main#unsortable-container-source-collector-container" target="_parent">
                                    {{app._('source.collector')}}
                                </a>
                            %elif type == 'analyzer':
                                <a class="shinken-path-link" href="/main#unsortable-container-source-analyzer-container" target="_parent">
                                    {{app._('source.analyzer')}}
                                </a>
                            %end
                            >
                        </div>
                    </td>
                    <td class="spaced">
                        <div class="shinken-path-link-container">
                            <a class="shinken-path-link" href="/sources/{{source_name}}?tab=tab-network-scan" target="_parent">
                                {{source_name}}
                            </a>
                            >
                        </div>
                    </td>
                    <td>
                        <div class="shinken-network-label-network-range">{{app._('source.network_range')}}</div>
                    </td>
                    <td>
                        <div id='shinken-title-page-edition' class="shinken-between-bracket shinken-data-user text-ellipsis">
                            {{name}}
                        </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div id="id-shinken-pop-up-close-button" class="shinkon-times-bold" onclick="backToSourceList()"></div>
</div>
<div id="left-column" data-type={{item_type}}>
    %include("__print_element_left_buttons_source_discover", app=app)
    %include("__print_right_help_bloc", changes=display_changes, app=app)
</div>
<div id="right-column">
    %include( "__print_saving_log")
    <div class="container_host_info shinken-container-host-info">
        <form id="id-shinken-form-element" name='form-element' class='form-inline form-element span12 gray-back no-margin'>
            <div class="shinken-form-container">
                %include( "__print_element_li_tab", app=app, list=list_tab_for_element, has_properties=False)
                <div class="shinken-tab-content tab-content tab-area">
                    <div id="id-shinken-window-generic-target" class="shinken-tab-pane  property-tab-pane" data-name="generic">
                        %include( "__print_panel_top_th", with_templates=False, app=app)
                        <div class="shinken-scroll-auto">
                            <table class="shinken-prop-table">
                                {{!app.helper.get_string_input(item, 'discovery_name', item_type, is_disabled=is_disabled, required=True, is_discovery=True )}}
                                {{!app.helper.get_string_input(item, 'iprange', item_type, is_disabled=is_disabled, required=True, is_discovery=True )}}
                                %if source_name != 'server-analyzer':
                                    {{!app.helper.get_string_input(item, 'port_range', item_type, is_disabled=is_disabled, is_discovery=True, default=app._('discovery.port_range_placeholder') )}}
                                %end
                                {{!app.helper.get_string_input(item, 'notes', item_type, is_disabled=is_disabled, is_discovery=True, input_type="textarea" )}}
                                {{!app.helper.get_bool_input(item, 'enabled', item_type, is_disabled=is_disabled, default=True)}}
                                %if source_name != 'server-analyzer':
                                    {{!app.helper.get_string_input(item, 'extra_option', item_type, is_disabled=is_disabled, is_discovery=True, input_type="textarea"  )}}
                                %end
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>