#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.property import BoolProp
from shinken.misc.type_hint import TYPE_CHECKING
from shinken.util import to_bool

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional
    from shinken.log import PartLogger
    

_bprop = BoolProp()


def read_bool_in_configuration(conf, key_name, default_value, conf_error_stats=None, log_fct=None):
    # type: (object, unicode, bool, Optional[dict], PartLogger) -> bool
    val = getattr(conf, key_name, default_value)
    if isinstance(val, basestring):
        val = to_bool(val)
    
    return val


def read_int_in_configuration(conf, key_name, default_value, conf_error_stats=None, log_fct=None):
    # type: (object, unicode, unicode, Optional[dict], PartLogger) -> int
    val = getattr(conf, key_name, default_value)
    try:
        val = int(val)
    except:
        if log_fct:
            log_fct.error("%s has incorrect value[%s], resetting to default value [%s]" % (key_name, val, default_value))
        if conf_error_stats is not None:
            conf_error_stats.update({key_name: {'conf_value': val, 'default_value': default_value}})
        val = default_value
    return val


def read_float_in_configuration(conf, key_name, default_value):
    try:
        return float(getattr(conf, key_name, default_value))
    except ValueError:
        return default_value


def read_string_in_configuration(conf, key_name, default_value):
    return getattr(conf, key_name, default_value)


def read_list_in_configuration(conf, key_name, default_value):
    raw_list = getattr(conf, key_name, default_value).split(',')
    return [i.strip() for i in raw_list]
