#!/bin/bash

function display_help() {
    printf "revert-patch [options]\n"
    printf "This script will revert the patch PATCH${PATCH_VERSION} for the shinken version v${SHINKEN_VERSION}-release.${PATCH_LANG,,}\n"
    printf "Options:\n"
    printf "  --help          -h    : will display this help\n"
    printf "  --force               : removes the need to hit a key when required during revert. All daemons will be restarted\n"
    printf "\n"
}

force=""

while [ $# -ge 1 ]; do
    case "$1" in
    -h | --help)
        display_help # Call your function
        # no shifting needed here, we're done.
        exit 0
        ;;
    --force)
        #  It's better to assign a string, than a number like "verbose=1"
        #  because if you're debugging script with "bash -x" code like this:
        #    if [ "$verbose" ] ...
        #  You will see:
        #    if [ "verbose" ] ...
        force="--force"
        shift
        ;;
    --) # End of all options
        shift
        break
        ;;
    -*)
        echo "Error: Unknown option: $1" >&2
        display_help
        exit 1
        ;;
    *) # No more options
        break
        ;;
    esac
done

if [[ ! -f lib/install_lib/common.sh ]]; then
    printf "\033[31m Error: please launch the patch from its directory\033[0m\n"
    exit 2
fi

. lib/install_lib/common.sh

if [[ "$force" != "" ]]; then
    printf -- "\n${YELLOW}NOTE: FORCE MODE ENABLED${RESET}\n"
fi

run_python common.py --check-version

restore_all_patch_valid_rights

print_step "Patch information" "1" "7"
init_patch_name_and_location "$PATCH_ID"
display_uninstall_acceptance_banner "$force"
# If the patch was not apply, cannot revert
run_python common.py --patch-is-installed


print_step "Shinken make a configuration backup" "2" "7"
run_python common.py --backup-config --backup-path "${OUTPUT_FOLDER}/BACKUP_CONFIGURATION_PRE_UNPATCH---${PATCH_ID}---/"

print_step "Stopping Shinken daemons" "3" "7"
run_python common.py --stop "${force}"


print_step "Restore selinux rules" "4" "7"
run_python common.py --remove-selinux-rules


print_step "Restore files from backup" "5" "7"
run_python common.py --revert-patch --id "$PATCH_ID"


print_step "Restart Shinken daemons" "6" "7"
run_python common.py --start "${force}"


print_step "Restart external daemons : ${EXTERNAL_DAEMONS}" "7" "7"
if [[ ${EXTERNAL_DAEMONS} == "" ]]; then
    printf -- "\n${YELLOW}There is no external daemons to restart${RESET}\n\n"
fi

for external_daemon in ${EXTERNAL_DAEMONS}; do
    run_python common.py --restart --service-list "${external_daemon}" "${force}"
done

printf -- "\n$YELLOW Your shinken installation was restored into version v${SHINKEN_VERSION}-release.${PATCH_LANG,,} whitout any patch.$RESET\n\n"
