#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

import cPickle
import hashlib
import os


class PatchNewHashListException(BaseException):
    pass


class PatchNewHashList(object):
    def __init__(self, filename):
        self.hash_list = {}
        
        self._dat_file_name = filename
        self._load_dat_file()
    
    
    def _load_dat_file(self):
        try:
            with open(self._dat_file_name, 'rb') as dat_file:
                self.hash_list = cPickle.loads(dat_file.read())
        except:
            self.hash_list = {}
            self.save_dat_file()
    
    
    def save_dat_file(self):
        if not os.path.exists(self._dat_file_name):
            os.makedirs(os.path.dirname(self._dat_file_name))
        with open(self._dat_file_name, 'wb') as f:
            f.write(cPickle.dumps(self.hash_list))
    
    
    def get_hash_list_for_file(self, file_name):
        # type: (str) -> set
        return self.hash_list.get(file_name, set())
    
    
    def add_hash_for_file(self, file_hash, file_name):
        # type: (str, str) -> None
        _set = self.get_hash_list_for_file(file_name)
        _set.add(file_hash)
        self.hash_list[file_name] = _set
    
    
    @staticmethod
    def get_hash_for_file(file_to_hash):
        # type: (str) -> str
        
        if isinstance(file_to_hash, unicode):
            file_to_hash = file_to_hash.strip().encode('utf-8')
        else:
            file_to_hash = file_to_hash.strip()
        
        try:
            return hashlib.sha256(file_to_hash.strip()).hexdigest()
        except Exception as e:
            pass
