#!/usr/bin/python

# -*- coding: utf-8 -*-
#
# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com

import json
import time

from shinken.log import logger

# Global value that will be changed by the main app
app = None


def show_about():
    # First we look for the user sid
    # so we bail out if it's a false one
    user = app.get_user_auth()
    
    if not user:
        app.bottle.redirect("/user/login")
    
    return {'app': app, 'valid_user': True, 'user': user}


def api_key():
    app.response.content_type = 'application/json'
    # First we look for the user sid
    # so we bail out if it's a false one
    user = app.get_user_auth()
    if not user:
        return app.bottle.abort(401)
    
    hosts = app.datamgr.get_hosts()
    nb_clusters = len([h for h in hosts if h.got_business_rule])
    nb_hosts = len(hosts) - nb_clusters
    is_key_valid = app.enterprise_valid
    nodes_limit = app.enterprise_nodes_limit
    is_testing = app.enterprise_testing
    customer_name = app.customer
    customer_email = app.customer_email
    
    now = int(time.time())
    if app.is_format_valid and not app.is_duplicated_trial and now > app.key_creation_time + app.key_duration:
        is_key_valid = True
    
    d = {}
    d['nb_clusters'] = nb_clusters
    d['nb_hosts'] = nb_hosts
    d['is_key_valid'] = is_key_valid
    d['nodes_limit'] = nodes_limit
    d['is_testing'] = d['is_trial'] = is_testing
    d['customer_name'] = customer_name
    d['customer_email'] = customer_email
    d['duration'] = app.key_duration
    d['creation_time'] = app.key_creation_time
    d['is_duplicated_trial'] = app.is_duplicated_trial
    d['is_format_valid'] = app.is_format_valid
    d['is_present'] = app.is_present
    
    logger.debug("api_key %s" % d)
    return json.dumps(d)


pages = {
    show_about: {'routes': ['/about'], 'view': 'about', 'static': False, 'wrappers': []},
    api_key   : {'routes': ['/api/key'], 'view': None, 'static': False, 'wrappers': ['auth', 'json']},
}
