%helper = app.helper
%datamgr = app.datamgr
%import time, datetime, calendar
%from datetime import date, timedelta

%#rebase layout globals(), title='Reporting', user=user, app=app, refresh=False

%ALL_STATES = ['ok', 'warn', 'crit', 'unknown', 'missing', 'inactive']
%MODE_TO_GET = { 'history_sla' : ['history', 'sla'], 'history' : ['history'], 'sla' : ['sla'] }

%date_string_begin = app.helper.print_date_locate(reporting_data['timestamp_begin'])
%date_string_end = app.helper.print_date_locate(reporting_data['timestamp_end'])
%s_period = app._('reporting.for_the_period') % (date_string_begin, date_string_end)
%modes = MODE_TO_GET[current_search['data_type']]
<html>
    <head>
        <style type="text/css">
            @font-face {
                font-family : "shinicon";
                src         : url("/static/{{app.http_start_time}}/font/shinicon.woff") format("woff"),
                url("/static/{{app.http_start_time}}/font/shinicon.ttf") format("truetype");
                font-weight : normal;
                font-style  : normal;
            }
            @font-face {
                font-family: "shinkenicons";
                src:
                url("/static/{{app.http_start_time}}/font/shinkenicons.woff") format("woff"),
                url("/static/{{app.http_start_time}}/font/shinkenicons.ttf")  format("truetype");
                font-weight: normal;
                font-style: normal;
                }
        </style>

        <link href="/static/{{app.http_start_time}}/sla/css/reporting-web.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/bootstrap.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/shinicon.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/shinkon.css" rel="stylesheet">
        <link href="/static/{{app.http_start_time}}/css/shinken-tooltip.css" rel="stylesheet">

        <script src="/static/{{app.http_start_time}}/js/shinken-tooltip.js"></script>

        <script src="/static/{{app.http_start_time}}/js/jquery.js"></script>
        <script src="/static/{{app.http_start_time}}/js/bootstrap.js"></script>
        <script>
            $( '[data-toggle="tooltip"]' ).tooltip();
        </script>
    </head>
    <title>
        {{app._('reporting.title') % (app._('reporting.%s'%(current_search['type'].replace('/','_'))), current_search['filter'].decode('utf-8'))}}
    </title>
<body class="report">

%include _report-nav-bar locals()

<div class="report-content">

%include _report-header locals()
%include _report-total locals()

<div class='report-elements'>
    %for item in reporting_data['by_item']:
        %item_result = item['result']
        %item_name = ''
        %if item.get('sdesc', None) is None:
            %item_name = item['hname']
        %else:
            %item_name = "%s/%s"%(item['hname'],item['sdesc'])
        %end

        %if len(item['by_day']) == 0:
            <table class="report-element">
                <tr >
                    <td class="report-element-name">
                         {{item_name}} - {{app._('reporting.no_data')}}
                    </td>
                </tr>
            </table>
            %continue
        %end

        <table class="report-element">
            <tr >
                <td class="report-element-spacing" colspan="2"></td>
            </tr>
            <tr >
                <td class="report-element-name" colspan="2"></td>
            </tr>
            <tr >
                <td class="report-element-info">
                    <img src="{{app.helper.get_item_icon(item['item'])}}"/>
                    <div>{{item_name}}</div>
                </td>
                <td class="report-element-sla">
                    %include _report-daily-sla-table locals()
                </td>
            </tr>
        </table>
    %end
</div>

</div>
</body>
</html>
