%helper = app.helper
%datamgr = app.datamgr
%import time, datetime
%title = app._('reporting.form_title')
%include mainmenu globals()

%default_warning_threshold = '%.3f' % DEFAULT_SLA_THRESHOLDS[0]
%default_critical_threshold = '%.3f' % DEFAULT_SLA_THRESHOLDS[1]

<link href="/static/{{app.http_start_time}}/sla/css/reporting-form.css" rel="stylesheet">
<div class='offset2 shinken-offset2'>

    %type_cluster = "value='%s' " % FILTER_TYPE.NORMAL_CLUSTER
    %type_hosttags = "value='%s' " % FILTER_TYPE.NORMAL_HOST_TEMPLATE
    %type_host = "value='%s' " % FILTER_TYPE.NORMAL_HOST
    %type_service_description = "value='%s' " % FILTER_TYPE.NORMAL_CHECK
    %type_hostgroups = "value='%s' " % FILTER_TYPE.NORMAL_HOSTGROUP

    %type_string = previous_search.get('type')
    %if type_string == FILTER_TYPE.NORMAL_CLUSTER:
        %type_cluster = type_cluster + "selected "
    %elif type_string == FILTER_TYPE.NORMAL_HOST_TEMPLATE:
        %type_hosttags = type_hosttags + "selected "
    %elif type_string == FILTER_TYPE.NORMAL_HOST:
        %type_host = type_host + "selected "
    %elif type_string == FILTER_TYPE.NORMAL_CHECK:
        %type_service_description = type_service_description + "selected "
    %elif type_string == FILTER_TYPE.NORMAL_HOSTGROUP:
        %type_hostgroups = type_hostgroups + "selected "
    %end

    %content_filter = previous_search.get('filter')
    %if content_filter is None:
        %content_filter = ""
    %end

    %content_dateBegin = previous_search.get('dateBegin')
    %if content_dateBegin is None:
        %content_dateBegin = ""
    %end

    %content_dateEnd = previous_search.get('dateEnd')
    %if content_dateEnd is None:
        %content_dateEnd = ""
    %end

    %content_warning_threshold = previous_search.get('warning_threshold')
    %if content_warning_threshold is None:
        %content_warning_threshold = ""
    %end

    %content_critical_threshold = previous_search.get('critical_threshold')
    %if content_critical_threshold is None:
        %content_critical_threshold = ""
    %end

    %content_display_report_threshold = previous_search.get('display_report_threshold')
    %if content_display_report_threshold is None:
        %content_display_report_threshold = "checked"
    %else:
        %content_display_report_threshold = 'checked' if content_display_report_threshold == 'True' else ''
    %end

    %content_display_element_threshold = previous_search.get('display_element_threshold')
    %if content_display_element_threshold is None:
        %content_display_element_threshold = "checked"
    %else:
        %content_display_element_threshold = 'checked' if content_display_element_threshold == 'True' else ''
    %end


    %select_ack_on = ""
    %select_ack_off = ""
    %select_ack_both = ""
    %content_ack = previous_search.get('ack')
    %if content_ack == "on":
        %select_ack_on = "checked"
    %elif content_ack == "off":
        %select_ack_off = "checked"
    %else:
        %select_ack_both = "checked"
    %end

    %select_downtime_on = ""
    %select_downtime_off = ""
    %select_downtime_both = ""
    %content_downtime = previous_search.get('downtime')
    %if content_downtime == "on":
        %select_downtime_on = "checked"
    %elif content_downtime == "off":
        %select_downtime_off = "checked"
    %else:
        %select_downtime_both = "checked"
    %end

    %if err:
        <div class='alert alert-critical' style='color:white;'>
            {{err}}
        </div>
    %end

    <h3 class='well'>{{app._('reporting.form_header')}}</h3>
    <form class='form-horizontal' action='/generate-reporting' method='GET'>
        <div class='well'>
            <div class="shinken-part-title">{{app._('reporting.element_type_label')}}</div>

            <div class="control-group">
                <label class="control-label">{{app._('reporting.filtre_by')}}</label>
                <div class="controls">
                    <select name='type'>
                        <option {{type_host}}>{{app._('reporting.normal_host_')}}</option>
                        <option {{type_cluster}}>{{app._('reporting.normal_cluster_')}}</option>
                        <option {{type_hosttags}}>{{app._('reporting.normal_host_template_')}}</option>
                        <option {{type_service_description}}>{{app._('reporting.normal_check_')}}</option>
                        <option {{type_hostgroups}}>{{app._('reporting.normal_hostgroup_')}}</option>
                    </select>
                </div>
            </div>

            <div class="control-group">
                <label class="control-label">{{app._('reporting.filtre_value')}}</label>
                <div class="controls">
                    <input type="text" required value="{{content_filter}}" name="filter">
                </div>
            </div>

            %if user.acl_in_tab_history == 'history_sla':
                <div class="control-group">
                    <label class="control-label">{{app._('reporting.data_to_display')}}</label>
                    <div class="controls">
                        <select name='data_type'>
                            %old_data_type = previous_search.get('data_type','')
                            %for _type in ['history_sla', 'history', 'sla']:
                                %selected = 'selected ' if old_data_type == _type else ''
                                %value = "<option value='%s' %s>%s</option>" % (_type, selected, app._('reporting.%s'%_type))
                                {{!value}}
                            %end
                        </select>
                    </div>
                </div>
            %else:
                <input class="hide" type="text" value="{{user.acl_in_tab_history}}" name="data_type"/>
            %end
        </div>

        <div class='well'>
            <div class="shinken-part-title">{{app._('reporting.select_period')}}</div>
            <div class="control-group">
                <label class="control-label">{{app._('reporting.period_from')}}</label>
                <div class="controls">
                    <input type="date" value="{{content_dateBegin}}" name="dateBegin" required placeholder="yyyy-mm-dd">
                </div>
            </div>

            <div class="control-group">
                <label class="control-label">{{app._('reporting.period_to')}}</label>
                <div class="controls">
                    <input type="date" value="{{content_dateEnd}}" name="dateEnd" required placeholder="yyyy-mm-dd">
                </div>
            </div>
        </div>


        <div class='well'>
            <div class="shinken-part-title">{{app._('reporting.select_sla_thresholds')}}</div>

            <table class="shinken-table-setting-threshold">
                <tr>
                    <th class="shinken-column-threshold shinken-column-report-threshold">{{app._('reporting.report_threshold_label')}}</th>
                    <th class="shinken-column-threshold shinken-column-element-threshold">{{app._('reporting.report_elements_threshold_label')}}</th>
                </tr>
                <tr>
                    <td class="shinken-column-report-threshold">
                        <div class="control-group">
                            <label class="control-label">{{app._('reporting.warning_threshold')}} {{app._('reporting.in_percent')}}</label>
                            <div class="controls">
                                <input type="text" value="{{content_warning_threshold}}" name="warning_threshold" placeholder="{{default_warning_threshold}}">
                            </div>
                        </div>
                    </td>
                    <td class="shinken-column-element-threshold">
                        <div >
                            <div class="control-group">
                                <label class="control-label">{{app._('reporting.display_treshold')}}</label>
                                <div class="controls">
                                    <input type="checkbox" name="display_element_threshold" title="display_element_threshold" {{content_display_element_threshold}} id="display_element_threshold">
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="shinken-column-report-threshold">
                        <div class="control-group">
                            <label class="control-label">{{app._('reporting.critical_threshold')}} {{app._('reporting.in_percent')}}</label>
                            <div class="controls">
                                <input type="text" value="{{content_critical_threshold}}" name="critical_threshold" placeholder="{{default_critical_threshold}}">
                            </div>
                        </div>
                    </td>
                    <td rowspan="3"></td>
                </tr>
                <tr>
                    <td class="shinken-column-report-threshold">
                        <div class="control-group">
                            <label class="control-label">{{app._('reporting.display_treshold')}}</label>
                            <div class="controls">
                                <input type="checkbox" name="display_report_threshold" title="display_report_threshold" {{content_display_report_threshold}} id="display_report_threshold">

                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="shinken-column-report-threshold">
                        <div class="shinken-help-report-treshold-container"> <span class="shinkon shinkon-warning"></span> {{app._('reporting.help_report_threshold')}}</div>
                    </td>
                </tr>
            </table>
        </div>

        <div class='well'>
            <button class='btn' style='float:right' name="web" action='submit'>{{app._('reporting.submit')}}</button>
            <button class='btn' style='float:left' name="csv" action='submit'>{{app._('reporting.generate_csv')}}</button>
        </div>
    </form>
</div>


%rebase layout globals(), user=user, app=app, refresh=False
