/*Copyright (C) 2009-2011 :
 Gabes Jean, naparuba@gmail.com
 Gerhard Lausser, Gerhard.Lausser@consol.de
 Gregory Starck, g.starck@gmail.com
 Hartmut Goebel, h.goebel@goebel-consult.de
 Andreas Karfusehr, andreas@karfusehr.de

 This file is part of Shinken.

 Shinken is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Shinken is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with Shinken.  If not, see <http://www.gnu.org/licenses/>.
 */

var __height;
var __width;



var labelType,
    useGradients,
    nativeTextSupport,
    animate,
    dragFlag = 0;
(function () {
    var ua                  = navigator.userAgent,
        iStuff              = ua.match( /iPhone/i ) || ua.match( /iPad/i ),
        typeOfCanvas        = typeof HTMLCanvasElement,
        nativeCanvasSupport = (typeOfCanvas == 'object' || typeOfCanvas == 'function'),
        textSupport         = nativeCanvasSupport && (typeof document.createElement( 'canvas' )
                                                                     .getContext( '2d' ).fillText == 'function');
    //I'm setting this based on the fact that ExCanvas provides text support for IE
    //and that as of today iPhone/iPad current text support is lame
    labelType         = (!nativeCanvasSupport || (textSupport && !iStuff)) ? 'Native' : 'HTML';
    nativeTextSupport = labelType == 'Native';
    useGradients      = nativeCanvasSupport;
    animate           = !(iStuff || !nativeCanvasSupport);
})();

var Log = {
    elem: false, write: function ( text ) {
        if ( !this.elem ) {
            this.elem = document.getElementById( 'log' );
        }
        this.elem.innerHTML = text;
    }
};

if ( typeof levelDistance === 'undefined' ) {
    var levelDistance = 145;
}

function dump ( arr, level ) {
    var dumped_text = "";
    if ( !level ) {
        level = 0;
    }
    
    //The padding given at the beginning of the line.
    var level_padding = "";
    for ( var j = 0; j < level + 1; j++ ) {
        level_padding += "    ";
    }
    
    if ( typeof(arr) == 'object' ) { //Array/Hashes/Objects
        for ( var item in arr ) {
            var value = arr[ item ];
            
            if ( typeof(value) == 'object' ) { //If it is an array,
                dumped_text += level_padding + "'" + item + "' ...\n";
                dumped_text += dump( value, level + 1 );
            }
            else {
                dumped_text += level_padding + "'" + item + "' => \"" + value + "\"\n";
            }
        }
    }
    else { //Stings/Chars/Numbers etc.
        dumped_text = "===>" + arr + "<===(" + typeof(arr) + ")";
    }
    return dumped_text;
}

var rgraph = null;

function change_rgraph_root ( root ) {
    rgraph.onClick( root, {
        Move: {}
    } );
}

var positions = {};

var focus = null;

var images = {};

function get_now () {
    return Math.floor( Date.now() / 1000 );
}

var last_draw = get_now();

var can_follow = true;

function follow_link ( event, url ) {
    event.stopPropagation();
    if ( can_follow ) {
        window.open( url, '_blank' );
    }
    can_follow = true;
}

function on_drag_link () {
    can_follow = false;
}

//Simulating events won't work in IE without this polyfill (fixes IE > 8)

(function () {
    
    if ( typeof window.MouseEvent === "function" ) {
        return false;
    }
    
    function MouseEvent ( type ) {
        var evt = document.createEvent( 'MouseEvent' );
        evt.initEvent( type, true, false );
        return evt;
    }
    
    MouseEvent.prototype = window.Event.prototype;
    window.MouseEvent    = MouseEvent;
})();

function simulate_mouseup () {
    var my_event = new MouseEvent( 'mouseup' );
    var canvas   = rgraph.canvas.element;
    canvas.dispatchEvent( my_event );
    dragFlag = 0;
}

function pointer_move () {
    dragFlag = 1;
}

function pointer_grab () {
    dragFlag                   = 0;
    document.body.style.cursor = "move";
}

function pointer_default () {
    document.body.style.cursor = "default";
}

/***************** Function used in the init_graph method, mainly *****************/
/* Ok, for the circles, w need a particules system, and not recreate them too
 much, but only once by iem, enven when it move! */
var context;
var particles          = [];
var particules_by_name = {};//new Hash();

// We should NOT create 1000 particules again and again
// but remeber them to "transalte" them if need (graph rewrite)
function create_or_update_particule ( name, x, y, color, size ) {
    if ( particules_by_name[ name ] !== undefined ) {
        p          = particules_by_name[ name ];
        p.position = { x: x, y: y };
        p.shift    = { x: x, y: y };
        p.angle    = 0;
        p.size     = 1 * (1 + (size - 2 / 5));
        p.active   = true;
    }
    else { // New particule :)
        var color_code = 'gray';
        if ( color === 'red' ) {
            color_code = '#E60000';
        }
        if ( color === 'orange' ) {
            color_code = '#F6A039';
        }
        
        var particle = {
            active  : true, // position to print
            position: { x: x, y: y }, // position of the center
            shift   : { x: x, y: y }, size: 1.2 * (1 + (size - 2 / 5)), // make the size large of the particule change too
            angle   : 0, speed: 0.06, fillColor: color_code, orbit: 40 * (1 + ((size - 2) / 4)) // make the orbit bigger for important elements
        };
        particles.push( particle );
        particules_by_name[ name ] = particle;
    }
}

function clean_particule ( name ) {
    if ( particules_by_name[ name ] !== undefined ) {
        p        = particules_by_name[ name ];
        p.active = false;
    }
}

function clean_particule_all () {
    for ( var i = 0, l = particles.length; i < l; i++ ) {
        clean_particule( i );
    }
    particles          = [];
    particules_by_name = {};
}


function panel_error_clean ( element ) {
    var elemContent = element.querySelector( '.content' );
    if ( elemContent ) {
        elemContent.innerHTML = '';
    }
}

function panel_error_toggle ( elemPanel, has_problem ) {
    var elemContent       = document.querySelector( '.infoviscont' ),
        elemContentDiv    = document.querySelector( '.infoviscont > div' ),
        elemContentHeight = parseInt( elemContent.style.height, 10 ),
        elemPanelHeight   = 135,
        newHeight         = null;
    
    //console.log( 'jli [RGraph] panel_error_toggle - has_problem:', has_problem, ' - show:', (elemPanel.dataset.isShow) )
    
    if ( elemContent ) {
        if ( has_problem ) { // Show
            if ( elemPanel.dataset.isShow == 0 ) {
                newHeight                = (elemContentHeight - elemPanelHeight);
                elemPanel.dataset.isShow = 1;
            }
        }
        else { // Hide
            if ( elemPanel.dataset.isShow == 1 ) {
                newHeight                = (elemContentHeight + elemPanelHeight);
                elemPanel.dataset.isShow = 0;
            }
        }
        
        if ( newHeight ) {
            // elemContent.style.height    = newHeight + 'px';
            // elemContentDiv.style.height = newHeight + 'px';
            // rgraph.controller.height = newHeight;
            
            
            resize_rgraph( null, newHeight );
        }
    }
    else {
        console.error( 'Element not found', elemPanel );
    }
}

function panel_error_draw ( data ) {
    if ( !data ) {
        return false;
    }
    
    var elemPanel = document.getElementById( "container-error-panel" );
    
    
    
    panel_error_clean( elemPanel );
    panel_error_render_title( elemPanel );
    
    var has_problem = false;
    for ( var i = 0, l = data.length; i < l; i++ ) {
        var item             = data[ i ];
        var has_color_cercle = item && item.hasOwnProperty( 'data' ) && item[ 'data' ].hasOwnProperty( 'circle' ) && item[ 'data' ][ 'circle' ];
        //has_problem = item && item.hasOwnProperty( 'data' ) && item[ 'data' ].hasOwnProperty( 'is_problem' ) && item[ 'data' ][ 'is_problem' ];
        
        if ( has_color_cercle != 'none' ) {
            has_problem = true;
            panel_error_render_content( elemPanel, item );
        }
    }
    
    panel_error_toggle( elemPanel, has_problem );
}

function panel_error_render_title ( element ) {
    var elemTitle = element.querySelector( '.title' );
    if ( elemTitle ) {
        //elemTitle.innerHTML = _( 'screens.problems' ) + ':';
        elemTitle.innerHTML = _( 'error.error' ) + ':';
    }
    else {
        //console.error( 'Element not found', elemTitle );
    }
}

function panel_error_render_content ( element, item ) {
    //console.log( 'jli [RGraph] panel_error_render_content', element[ "id" ], positions );
    var elemContent = element.querySelector( '.content' );
    if ( elemContent ) {
        var elemItem = '<div class="item-container">' +
                       '<div class="item-title" onclick="javascript:select_root(\'' + item[ "id" ] + '\');" >' + item[ "data" ][ "infos" ] + '</div>' +
                       '</div>';
        elemContent.innerHTML += elemItem;
    }
    else {
        console.error( 'Element not found', elemContent );
    }
}

function panel_error_refresh ( data ) {
    panel_error_draw( data );
}

/***************** End function used in the init_graph method, mainly *****************/

function init_graph ( root, jsgraph, width, height, inject ) {
    
    if ( typeof $jit === "undefined" ) {
        // Still not load $jit? racing problems are a nightmare :)
        // Ok, we retry in the next second...
        setTimeout( function () {
            init_graph( root, jsgraph, width, height, inject );
        }, 1000 );
        return;
    }
    __height = height;
    __width  = width;
    //init data
    //If a node in this JSON structure
    //has the "$type" or "$dim" parameters
    //defined it will override the "type" and
    //"dim" parameters globally defined in the
    //RGraph constructor.
    
    // Main printing loop for particules, graph is print only when need,
    // but particules are print each loop
    function loop () {
        // Only start 1s after the last draw
        var now = get_now();
        if ( now < last_draw + 0.1 ) {
            return;
        }
        var local_size;
        var pos_x;
        var pos_y;
        // Number of cut we want in our orbital spinner
        var NB_PART = 3;
        for ( var i = 0, len = particles.length; i < len; i++ ) {
            var particle = particles[ i ];
            
            // If the particule is disabled, bail out
            if ( !particle.active ) {
                continue;
            }
            
            // Offset the angle to keep the spin going
            particle.angle += particle.speed;
            
            // Apply position
            particle.position.x = particle.shift.x + Math.cos( i + particle.angle ) * (particle.orbit);
            particle.position.y = particle.shift.y + Math.sin( i + particle.angle ) * (particle.orbit);
            
            // Compute a local size to make a up/down size effect
            local_size = (Math.cos( particle.angle ) - Math.sin( particle.angle ) + 2 * particle.size) / 2;
            local_size = Math.abs( particle.size );
            
            for ( var j = 0; j < 2 * NB_PART; j++ ) {
                
                pos_x = particle.shift.x + Math.cos( i + particle.angle + j * Math.PI / NB_PART ) * (particle.orbit);
                pos_y = particle.shift.y + Math.sin( i + particle.angle + j * Math.PI / NB_PART ) * (particle.orbit);
                
                // If it's a odd value, print a color one
                if ( j % 2 === 0 ) {
                    // Draw the color spiner
                    context.beginPath();
                    context.fillStyle = particle.fillColor;
                    context.arc( pos_x, pos_y, local_size / 2, 0, Math.PI * 2, true );
                    context.fill();
                }
                else { // print a cleaning particule
                    context.beginPath();
                    context.fillStyle = back_color; // define in the widget_depgraph.tpl //default to '#EFECE5';
                    context.arc( pos_x, pos_y, (local_size / 2), 0, Math.PI * (2), true );
                    context.fill();
                }
            }
            
        }
    }
    
    // A node should be print if it's a important one
    // like an host, or a service near or with a huge business
    // impact, or a root problem.
    function should_be_print ( node ) {
        var b               = true;
        var elt_type        = 'service';
        var business_impact = 2;
        var state_id        = 0;
        var is_problem      = false;
        
        /* We can have some missing data, so just add dummy info */
        if ( typeof(node.data.elt_type) != 'undefined' ) {
            elt_type        = node.data.elt_type;
            business_impact = node.data.business_impact;
            state_id        = node.data.status;
            is_problem      = node.data.is_problem;
        }
        
        // For distant service, we should tag them with no label
        // but important one should be still tags of course.
        // should saw root problem too
        if ( node._depth == 0 ) {
        }
        else if ( node._depth == 1 ) {
        }
        else if ( node._depth >= 2 ) {
            if ( elt_type == 'service' && business_impact <= 2 ) {
                if ( state_id == 0 || !is_problem ) {
                    b = false;
                }
            }
        }
        
        // Hard hook on services show, because if they are here, it must be important
        if ( elt_type == 'service' ) {
            b = true;
        }
        
        //	alert('Should be print '+node.id+ ' '+b);
        return b;
    }
    
    $jit.RGraph.Plot.EdgeTypes.implement( {
        'dashed': {
            'render': function ( edge, canvas ) {
                var nodeFrom = edge.nodeFrom.getPos().getc(),
                    nodeTo   = edge.nodeTo.getPos().getc();
                var dx       = (nodeTo.x - nodeFrom.x);
                var dy       = (nodeTo.y - nodeFrom.y);
                var dist     = Math.sqrt( dx * dx + dy * dy );
                dx           = dx / dist;
                dy           = dy / dist;
                var dim      = 5;
                canvas.path( 'stroke', function ( ctx ) {
                    for ( var i = 0; i < dist; i += 2 * dim ) {
                        ctx.moveTo( nodeFrom.x + i * dx, nodeFrom.y + i * dy );
                        ctx.lineTo( nodeFrom.x + (i + dim) * dx, nodeFrom.y + (i + dim) * dy );
                    }
                } );
            }
        }
    } );
    //init nodetypes
    //Here we implement custom node rendering types for the RGraph
    //Using this feature requires some javascript and canvas experience.
    $jit.RGraph.Plot.NodeTypes.implement( {
        'custom': {
            'render': function ( node, canvas ) {
                //console.log( 'jli [RGraph] custom::render' );
                //console.log( 'jli [RGraph] custom::render - node:', node );
                //console.log( 'jli [RGraph] custom::render - canvas:', canvas );
                // Reset the last draw so the particles won't span now, but will wait a bit
                last_draw                 = get_now();
                node.data.business_impact = 3;
                /*First we need to know where the node is, so we can draw
                 in the correct place for the GLOBAL canvas*/
                var pos              = node.getPos().getc();
                positions[ node.id ] = pos;
                var base_size        = 24;
                
                var ctx = canvas.getCtx();
                
                // Look if we really need to render this node
                if ( !should_be_print( node ) ) {
                    var color = node.data.circle;
                    // Remember to clean the particule if need
                    clean_particule( node.id );
                    ctx.beginPath();
                    ctx.fillStyle = color;
                    ctx.arc( pos.x, pos.y, 1, 0, Math.PI * (2), true );
                    ctx.fill();
                    return;
                }
                context = ctx;
                
                // We are getting the image in the dom because it's already loaded and so
                // it will always be insert before the state image (so in the layer under)
                var imgcloud = document.getElementById( 'aroundcluster' );
                
                //imgcloud.width = 128;
                //imgcloud.height = 128;
                
                var src = node.data.img_src;
                if ( typeof(src) == 'undefined' ) {
                    var img__ = document.getElementById( 'img_state_ok' );
                    src       = img__.src;
                }
                
                function insert_tocanvas () {
                    var elt_type = 'service';
                    /* We can have some missing data, so just add dummy info */
                    if ( typeof(node.data.elt_type) != 'undefined' ) {
                        elt_type = node.data.elt_type;
                    }
                    
                    /* We scale the image. Thanks html5 canvas.*/
                    
                    if ( elt_type == 'service' ) {
                        img = document.getElementById( 'imgservice' );
                    }
                    
                    img.width  = 48;//size;
                    img.height = 48;//size;
                    /* If we got a value for the circle */
                    if ( typeof(node.data.img_src) != 'undefined' ) {
                        color = node.data.circle;
                        
                        
                        //console.log( 'jli [RGraph] custom::render :: draw cercle = ', ( color != 'none' && node.data.is_problem ),' - name:', node.name,' - circle:', node.data.circle, ' - is_problem:', node.data.is_problem   );
                        
                        if ( color != 'none' ) {
                            create_or_update_particule( node.id, pos.x, pos.y, color, node.data.business_impact - 1 );
                        }
                        
                        /*
                         else {
                         // If we didn't print the circle, we can add one for the
                         // root, so the user will show it.
                         // DO NOT PUT THE node.id here, because we need this particule to folow the root
                         // whatever its name is ;)
                         if ( node.id == rgraph.root ) {
                         create_or_update_particule ( 'graphrootforwebui', pos.x, pos.y, 'gray', node.data.business_impact - 1 );
                         }
                         }
                         */
                    }
                    // If we got a business rule, we don't want central img, only the state
                    if ( node.data.got_business_rule ) {
                        ctx.drawImage( imgcloud, pos.x - imgcloud.width / 2, pos.y - imgcloud.height / 2, imgcloud.width, imgcloud.height );
                    }
                    else {
                        //Ok, we draw the image, and we set it in the middle of the node :)
                        ctx.drawImage( img, pos.x - img.width / 2, pos.y - img.width / 2, img.width, img.height );
                    }
                    var lstate = node.data.state;
                    
                    // They are already in the dom
                    if ( typeof lstate != 'undefined' ) {
                        var imgstate = document.getElementById( 'img_state_' + lstate );
                        ctx.drawImage( imgstate, pos.x, pos.y, img.width / 1.5, img.height / 1.5 );
                    }
                    if ( !node.data.authorized ) {
                        var imgauthorized = document.getElementById( 'img_unauthorized' );
                        ctx.drawImage( imgauthorized, pos.x - img.width / 1.7, pos.y, img.width / 1.5, img.height / 1.5 );
                    }
                    
                    var _summary = null;
                    switch ( node.data.context ) {
                        case 'DOWNTIME':
                            _summary = 'img_state_downtime';
                            break;
                        case 'INHERITED-DOWNTIME':
                            _summary = 'img_state_inherited-downtime';
                            break;
                        case 'PARTIAL-DOWNTIME':
                            _summary = 'img_state_partial-downtime';
                            break;
                        case 'ACKNOWLEDGED':
                            _summary = 'img_state_acknowledged';
                            break;
                        case 'INHERITED-ACKNOWLEDGED':
                            _summary = 'img_state_inherited-acknowledged';
                            break;
                        case 'PARTIAL-ACKNOWLEDGED':
                            _summary = 'img_state_partial-acknowledged';
                            break;
                        case 'FLAPPING':
                            _summary = 'img_state_flapping';
                            break;
                        case 'PARTIAL-FLAPPING':
                            _summary = 'img_state_partial-flapping';
                            break;
                        default:
                            _summary = null;
                    }
                    
                    if ( _summary != null ) {
                        var imgsummary = document.getElementById( _summary );
                        if ( !imgsummary ) {
                            console.log( imgsummary );
                        }
                        ctx.drawImage( imgsummary, pos.x - img.width / 1.5, pos.y - img.height / 1.5, img.width / 1.5, img.height / 1.5 );
                    }
                }
                
                // Maybe it is in cache, maybe not
                var img = images[ src ];
                if ( typeof(img) == 'undefined' ) {
                    var img = new Image();
                    
                    function wrap () {
                        images[ src ] = img;
                        insert_tocanvas();
                    }
                    
                    img.onload = wrap;//insert_tocanvas;
                    img.src    = src;
                    
                }
                else {
                    insert_tocanvas();
                }
                
                
                /* We can have some missing data, so just add dummy info */
                //if ( typeof(node.data.img_src) == 'undefined' ) {
                //} else {
                //    size = base_size * (1 + (node.data.business_impact - 2) / 3);
                //    size = Math.max ( base_size, size );
                //}
                
                // Now inject if need the
                
            }
        }
    } );
    
    //init RGraph
    /*var */
    rgraph = new $jit.RGraph( {
        'injectInto': 'infovis-' + inject,
        'width'     : width,
        'height'    : height, //Optional: Add a background canvas
        //that draws some concentric circles.
        'background': false, //Add navigation capabilities:
        //zooming by scrolling and panning.
        Navigation  : {
            enable: true, panning: true, zooming: 20
        }, //Nodes and Edges parameters
        //can be overridden if defined in
        //the JSON input data.
        //This way we can define different node
        //types individually.
        Node        : {
            color: 'green', 'overridable': true, type: 'custom'
        }, Edge     : {
            color: 'SeaGreen', lineWidth: 0.5, 'overridable': true
        },
        
        //Add tooltips
        Tips: {
            enable: true, onShow: function ( tip, node ) {
                var html      = "<div class=\"tip-title well\" style='padding: 10px;margin-bottom: 10px;'>" + node.data[ 'infos-hover' ] + "</div>";
                tip.innerHTML = html;
            }
        },
        
        //Set polar interpolation.
        //Default's linear.
        interpolation   : 'linear',//polar',
        //Change the transition effect from linear
        //to elastic.
        //transition: $jit.Trans.Elastic.ea,
        //Change other animation parameters.
        duration        : 1000, fps: 30, //Change father-child distance.
        levelDistance   : levelDistance, //This method is called right before plotting
        //an edge. This method is useful to change edge styles
        //individually.
        onBeforePlotLine: function ( adj ) {
            src = adj.nodeFrom;
            dst = adj.nodeTo;
            
            // If one of the line border is a no print node
            // print this line in very few pixels
            if ( !should_be_print( src ) || !should_be_print( dst ) ) {
                adj.data.$lineWidth = 0.3;
            }
            else {
                adj.data.$lineWidth = 2;
            }
        },
        
        onBeforeCompute: function ( node ) {
            // Make right column relations list.
            var html = node.data.infos;
            
            $jit.id( 'inner-details-' + inject ).innerHTML = html;
        },
        
        //Add node click handler and some styles.
        //This method is called only once for each node/label crated.
        onCreateLabel: function ( domElement, node ) {
            var __elt_type = 'hosts';
            if ( node.data.elt_type == 'service' ) {
                __elt_type = 'checks';
            }
            
            var checks_class = 'tip-title well graph-title';
            var title_class  = node.data.is_in_cluster || node.data.got_business_rule ? checks_class + " in-cluster" : checks_class;
            // Hack: we dont use a <a href = ...></a> for link because we need to inhib the click during a drag and drop
            var _html        = "<div class='" + title_class + "' style='' onclick='follow_link(event,\"/#" + node.data.url + "/\")'><span>" + node.name +
                               "<span class='fake-link' ondragstart=on_drag_link() draggable='true'> " +
                               "<i class='icon-eye-open'></i></span></span></div>";
            if ( __elt_type == 'hosts' && node.data.authorized ) {
                _html = "<div style='text-align:center'><div>" + _html + "</div>";
                
                if ( typeof node.data.checks != 'undefined' && !node.data.got_business_rule ) {
                    _html += "<div class='" + checks_class + "' style='margin-top:55px;' onclick='follow_link(event,\"/#" + node.data.url + "/checks\")'>";
                    _html += '<center style="margin-top: -3px;margin-bottom: 1px;"><span>Checks</span></center><div>';
                    var badge_class = node.data.checks.CRITICAL > 0 ? "badge-critical" : "badge-critical-empty";
                    _html += "<span class='fake-link' onclick='follow_link(event,\"/#" + node.data.url + "/checks?listDetailFilter=%255B%257B%2522status%2522%253A%255B%2522critical%2522%255D%257D%255D \")'>";
                    _html += '<div class="check-badge ' + badge_class + '">' + node.data.checks.CRITICAL + '</div>';
                    _html += '</span>';
                    badge_class     = node.data.checks.WARNING > 0 ? "badge-warning" : "badge-warning-empty";
                    _html += "<span class='fake-link' onclick='follow_link(event,\"/#" + node.data.url + "/checks?listDetailFilter=%255B%257B%2522status%2522%253A%255B%2522warning%2522%255D%257D%255D \")'>";
                    _html += '<div class="check-badge ' + badge_class + '">' + node.data.checks.WARNING + '</div>';
                    _html += '</span>';
                    badge_class     = node.data.checks.UNKNOWN > 0 ? "badge-unknown" : "badge-unknown-empty";
                    _html += "<span class='fake-link' onclick='follow_link(event,\"/#" + node.data.url + "/checks?listDetailFilter=%255B%257B%2522status%2522%253A%255B%2522unknown%2522%255D%257D%255D \")'>";
                    _html += '<div class="check-badge ' + badge_class + '">' + node.data.checks.UNKNOWN + '</div>';
                    _html += '</span>';
                    badge_class     = node.data.checks.OK > 0 ? "badge-ok" : "badge-ok-empty";
                    _html += "<span class='fake-link' onclick='follow_link(event,\"/#" + node.data.url + "/checks?listDetailFilter=%255B%257B%2522status%2522%253A%255B%2522ok%2522%255D%257D%255D \")'>";
                    _html += '<div class="check-badge ' + badge_class + '">' + node.data.checks.OK + '</div></div></div>';
                    _html += '</span>';
                }
                
                _html += "</div>";
            }
            
            domElement.innerHTML = _html;
            domElement.onclick   = function () {
                select_root( node.id );
            };
            var style            = domElement.style;
            style.minHeight      = '80px';
            style.cursor         = 'pointer';
            style.fontSize       = "0.8em";
            style.color          = '#5e5e5e';
        },
        
        //This method is called when rendering/moving a label.
        //This is method is useful to make some last minute changes
        //to node labels like adding some position offset.
        onPlaceLabel: function ( domElement, node ) {
            var style        = domElement.style;
            var left         = parseInt( style.left );
            var w            = domElement.offsetWidth;
            style.left       = (left - w / 2) + 'px';
            var t            = parseInt( style.top.replace( 'px', '' ) );
            //t += 18;
            t -= 50;
            style.top        = t + 'px';
            style.fontWeight = 'bold';
            
            // If the node should not be print
            // do not print it :)
            if ( !should_be_print( node ) ) {
                style.display = 'none';
            }
        }
    } );
    //load graph.
    //alert('Loading graph'+jsgraph);
    
    rgraph.loadJSON( jsgraph, 0 );
    rgraph.root = root;
    // Force the drag to stop when the mouse leaves the canvas
    rgraph.canvas.element.addEventListener( "mouseleave", simulate_mouseup );
    rgraph.canvas.element.addEventListener( "mousedown", pointer_grab );
    rgraph.canvas.element.addEventListener( "mousemove", pointer_move );
    rgraph.canvas.element.addEventListener( "mouseup", pointer_default );
    
    //compute positions and plot
    rgraph.refresh();
    rgraph.controller.onBeforeCompute( rgraph.graph.getNode( rgraph.root ) );
    Log.write( '' );
    //end
    
    __depgraph_loop_interval = setInterval( loop, 1000 / 60 );
    focus                    = positions[ rgraph.root ];
}

var __depgraph_loop_interval;
var __number_try = 5;

function refresh ( uuid, levels ) {
    if ( levels === undefined ) {
        levels = 5;
    }
    __number_try--;
    var current_root;
    var jqxhr = $.getJSON( '/refresh_depgraph/' + uuid + '?levels=' + levels, function ( data ) {
        if ( !rgraph ) {
            return;
        }
        rgraph.loadJSON( data, 0 );
        //set name node root
        current_root = find_root( uuid, data );
        rgraph.root  = current_root.name;
        
        clean_particule_all();
        panel_error_refresh( data );
        rgraph.refresh();
        __number_try = 5;
        
    } ).fail( function ( txt, txt2 ) {
        console.warn( "error" + txt.status, txt, txt2 );
        var _status = txt.status;
        switch ( _status ) {
            case 404:
                window.location.reload();
                break;
            default:
                if ( __number_try ) {
                    setTimeout( function () {
                        refresh( uuid, levels );
                    }, 3000 );
                }
                else {
                    window.location.reload();
                }
                break;
        }
    } );
}

function find_root ( uuid, data ) {
    var _current_node;
    for ( var i = 0, _data_size = data.length; i < _data_size; i++ ) {
        _current_node = data[ i ];
        if ( _current_node.data.uuid === uuid ) {
            return _current_node;
        }
    }
    return undefined;
}

function select_root ( id ) {
    if ( dragFlag === 1 ) {
        return;
    }
    var c = rgraph.canvas;
    
    var sx = c.scaleOffsetX;
    var sy = c.scaleOffsetY;
    
    // reinit positions
    c.translate( -c.translateOffsetX * 1 / sx, -c.translateOffsetY * 1 / sy );
    c.scale( 1 / sx, 1 / sy );
    
    // Here we focus on the root, now focus on the new element pos
    var new_pos = positions[ id ];
    
    var nx = (new_pos.x - focus.x);
    var ny = (new_pos.y - focus.y);
    
    c.translate( -nx, -ny );
    
    c.scale( sx, sy );
}


function resize_rgraph ( new_width, new_height ) {
    if ( !new_width ) {
        new_width = __width;
    }
    rgraph.canvas.resize( new_width, new_height, true );
    var _element          = document.querySelector( '.infoviscont' );
    _element.style.width  = new_width + 'px';
    _element.style.height = new_height + 'px';
    
}