<!DOCTYPE html>
%#Set default values
%if not 'js' in locals(): js = []
%if not 'title' in locals(): title = 'No title'
%if not 'css' in locals(): css = []
%if not 'print_menu' in locals(): print_menu = True
%if not 'print_header' in locals(): print_header = True
%if not 'print_footer' in locals(): print_footer = True
%if not 'refresh' in locals(): refresh = False
%if not 'user' in locals(): user = None
%if not 'app' in locals(): app = None

%# If not need, disable the top right banner
%if not 'top_right_banner_state' in locals(): top_right_banner_state = 0

%# For the menu selection
%if not 'menu_part' in locals(): menu_part = ''

%# Workflow selection

<head>

%if app:
      <script>
	// Set the default global lang, and as soon as possible
	var global_lang = '{{app.lang}}';
      </script>
%end

%if title:
    <title>{{title}}</title>
%end

<style type="text/css">
    @font-face {
        font-family: 'FontAwesome';
        src: url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?v=3.0.1');
        src: url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?#iefix&v=3.0.1') format('embedded-opentype'),
        url('/static/{{app.http_start_time}}/font/fontawesome-webfont.woff?v=3.0.1') format('woff'),
        url('/static/{{app.http_start_time}}/font/fontawesome-webfont.ttf?v=3.0.1') format('truetype');
        font-weight: normal;
        font-style: normal;
}

        @font-face {
        font-family: "Lato-Light";
        src:
        url("/static/ui/assets/styles/fonts/lato-light.woff") format("woff"),
        url("/static/ui/assets/styles/fonts/lato-light.ttf") format("truetype");
        font-weight: normal;
        font-style: normal;
        }
        @font-face {
        font-family: "Lato";
        src:
        url("/static/ui/assets/styles/fonts/lato-regular.woff") format("woff"),
        url("/static/ui/assets/styles/fonts/lato-regular.ttf") format("truetype");
        font-weight: normal;
        font-style: normal;
        }
        @font-face {
        font-family: "shinkenicons";
        src:
        url("/static/{{app.http_start_time}}/font/shinkenicons.woff") format("woff"),
        url("/static/{{app.http_start_time}}/font/shinkenicons.ttf")  format("truetype");
        font-weight: normal;
        font-style: normal;
        }

	body{
	margin:0px;
	}
    </style>

    <!-- ENTERPRISE -->

    <link href="/static/{{app.http_start_time}}/cv_mysql/css/dark.fixes.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/cv_mysql/css/bootstrap-select.min.css" rel="stylesheet">


    <link href="/static/{{app.http_start_time}}/css/bootstrap.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/font-awesome.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/custom/layout.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/custom/badger.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/elements/jquery.meow.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/elements/header-element.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/custom/deptree.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/custom/buttons.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/elements/jquery.pageslide.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/shinkon.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/shinken-tooltip.css" rel="stylesheet">

    <!-- css3 effect for pulse is not available on IE It's not real comment, if so it will not work. -->

    <!--[IF !IE]> -->
    <link href="/static/{{app.http_start_time}}/css/elements/pulse.css" rel="stylesheet">
    <!-- <![ENDIF]-->

    <!-- Canvas and gauge ones -->
    <link href="/static/{{app.http_start_time}}/css/shinken-gauge.css" rel="stylesheet">

    %# And now for css files
      %for p in css:
    <link rel="stylesheet" type="text/css" href="/static/{{app.http_start_time}}/{{p}}">
      %end

    <style type="text/css">
      body {
      padding:0px;

      /*  padding-bottom: 40px;*/
      }
      .sidebar-nav {
        padding: 9px 0;
      }
    </style>

    <!-- Le javascript
    ================================================== -->
    <!-- WAS Placed at the end of the document so the pages load faster -->
    <!-- but then we a't call $ in our html page. So we will loose a bit loading speed (just
	 for the first launch, not a big deal) but then we can call jquery in our page -->
    <script src="/static/{{app.http_start_time}}/js/jquery.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery-ui-1.8.17.custom.min.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinkenui.js"></script>
    <script src="/static/{{app.http_start_time}}/js/bootstrap.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery.pageslide.js"></script>
    <!-- Warnign, this version of datepicker came from http://dl.dropbox.com/u/143355/datepicker/datepicker.html -->
    <script src="/static/{{app.http_start_time}}/js/bootstrap-datepicker.js"></script>
    <!-- Warnign, this version of typeahead came from https://gist.github.com/1866577 -->
    <script src="/static/{{app.http_start_time}}/js/bootstrap-typeahead.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery.meow.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery-jsonp-2.2.1.min.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery.hotkeys.js"></script>
    <!-- From http://joequery.github.com/Stupid-Table-Plugin/ -->
    <script src="/static/{{app.http_start_time}}/js/jquery-stupidtable.min.js"></script>
    <script src="/static/{{app.http_start_time}}/js/spin.min.js"></script>

    <!--Shinken ones-->
    %if refresh:
    <script src="/static/{{app.http_start_time}}/js/shinken-refresh.js"></script>
    %end
    <script src="/static/{{app.http_start_time}}/js/shinken-actions.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-greeting.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-opacity.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-modals.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-tooltip.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-canvas.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-gauge.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-treemap.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-aggregation.js"></script>

    <!-- Traduction ones -->
    <script src="/static/{{app.http_start_time}}/js/traductions/en.js"></script>
    <script src="/static/{{app.http_start_time}}/js/traductions/fr.js"></script>
    <script src="/static/{{app.http_start_time}}/js/traductions/main.js"></script>


    <!-- ENTERPRISE -->
    <script src="/static/{{app.http_start_time}}/cv_mysql/js/bootstrap-select.min.js"></script>
    <script src="/static/{{app.http_start_time}}/cv_mysql/js/realms.js"></script>
    <script src="/static/{{app.http_start_time}}/cv_mysql/js/iframeResizer.contentWindow.min.js"></script>

    %# End of classic js import. Now call for specific ones
      %for p in js:
    <script type="text/javascript" src="/static/{{app.http_start_time}}/{{p}}"></script>
      %end

    </head>
    <body>
    <div id="wrap" class="container-fluid">
      <div class="row-fluid container">
        <div id="content" class="span12 row-fluid">
		      %include
        </div><!--/span-->
      </div><!--/row-->
    </div><!--/.fluid-container-->
  <!-- The modal div that will be shown when we want, and after put in it the data we want -->
  <div class="modal fade" id="modal"></div>
  </body>
</html>
