#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

# Set by state_controller.py
app = None  # type: ..synchronizerdaemon.Synchronizer


class BusinessException(Exception):
    code = 400  # type: int
    text = ''  # type: basestring
    
    
    def __init__(self, code=None, text=None):
        self.code = code or self.code
        self.text = text or self.text


class UnauthorizedSaveException(BusinessException):
    def __init__(self, code=403, text=None):
        text = text or app._("element.unauthorized_save")
        super(UnauthorizedSaveException, self).__init__(code, text)


class AlreadyDeletedException(BusinessException):
    pass


class ItemNotFoundException(BusinessException):
    code = 404


class WorkAreaInfoUnknownStatus(BusinessException):
    pass


class ItemNotValid(BusinessException):
    code = "element-not-valide"


class MassiveChangeError(BusinessException):
    missing_values = []
    
    
    def __init__(self, code=None, text=None, missing_values=None):
        super(MassiveChangeError, self).__init__(code, text)
        if missing_values:
            self.missing_values = missing_values


class SaveException(BusinessException):
    def __init__(self, code, text):
        self.code = code
        self.text = text
