#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2020
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, List, Str, NoReturn, Optional


class PROPERTY_USER_RIGHTS(object):
    VIEW_CONTACTS = 'view_contacts'
    EDITION_CONTACTS = 'edition_contacts'
    NOTIFICATION_CONTACTS = 'notification_contacts'
    VIEW_CONTACT_GROUPS = 'view_contact_groups'
    EDITION_CONTACT_GROUPS = 'edition_contact_groups'
    NOTIFICATION_CONTACT_GROUPS = 'notification_contact_groups'
    LIST = [VIEW_CONTACTS, EDITION_CONTACTS, NOTIFICATION_CONTACTS, VIEW_CONTACT_GROUPS, EDITION_CONTACT_GROUPS, NOTIFICATION_CONTACT_GROUPS]
    
    
    @staticmethod
    def get_synchronized_property(property_name):
        # type: (Str) -> List
        if property_name == PROPERTY_USER_RIGHTS.VIEW_CONTACTS:
            return [PROPERTY_USER_RIGHTS.NOTIFICATION_CONTACTS, PROPERTY_USER_RIGHTS.EDITION_CONTACTS]
        if property_name == PROPERTY_USER_RIGHTS.VIEW_CONTACT_GROUPS:
            return [PROPERTY_USER_RIGHTS.NOTIFICATION_CONTACT_GROUPS, PROPERTY_USER_RIGHTS.EDITION_CONTACT_GROUPS]
        if property_name in (PROPERTY_USER_RIGHTS.NOTIFICATION_CONTACTS, PROPERTY_USER_RIGHTS.EDITION_CONTACTS):
            return [PROPERTY_USER_RIGHTS.VIEW_CONTACTS]
        if property_name in (PROPERTY_USER_RIGHTS.NOTIFICATION_CONTACT_GROUPS, PROPERTY_USER_RIGHTS.EDITION_CONTACT_GROUPS):
            return [PROPERTY_USER_RIGHTS.VIEW_CONTACT_GROUPS]
        return []
