#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

import json

from .object.messages import ValidatorMessages

SUCCESS_RESPONSE_CODE = 200
WARNING_RESPONSE_CODE = 202
ERROR_RESPONSE_CODE = 202
CRITICAL_ERROR_RESPONSE_CODE = 400


class FrontEndSaveResponse(object):
    def __init__(self, validation_message, return_code=SUCCESS_RESPONSE_CODE, has_changes=False, message_has_changes=False, delete=None, has_item_in_staging=False, default_text='', was_reject=False):
        # type: (ValidatorMessages, int, bool, bool, str, bool, str, bool) -> None
        self.return_code = return_code
        self.has_changes = has_changes
        self.message_has_changes = message_has_changes
        self.return_text = ''
        self.validation = validation_message
        self.delete = delete
        self.has_item_in_staging = has_item_in_staging
        self.default_text = default_text
        self.was_reject = was_reject
    
    
    def get_response(self, text=''):
        # take the error code if not already customized
        if self.return_code == SUCCESS_RESPONSE_CODE:
            if self.validation.has_critical():
                self.return_code = CRITICAL_ERROR_RESPONSE_CODE
            elif self.validation.has_error():
                self.return_code = ERROR_RESPONSE_CODE
            elif self.validation.has_warning():
                self.return_code = WARNING_RESPONSE_CODE
        
        response = {
            'rc'                 : self.return_code,
            'text'               : text if text else self.validation.get_html(default_text=self.default_text),
            'has_changes'        : self.has_changes,
            'message_has_changes': self.message_has_changes,
            'has_critical' : self.validation.has_critical(),
            'has_error'          : self.validation.has_error(),
            'has_warning'        : self.validation.has_warning(),
            'delete'             : self.delete,
            'has_item_in_staging': self.has_item_in_staging,
            'was_reject'         : self.was_reject,
        }
        return json.dumps(response)
