#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
import re
from .component_select_options import ComponentOption, ComponentSelectOptions, ComponentOptionSeparator, ComponentOptionGroup
from ..dao.def_items import ITEM_TYPE

_selector_cache = {}


class MassActionStagging:
    DEFAULT = "DEFAULT"
    LIST = [DEFAULT, "massive_change", "enable", "disable", "delete", "clone", "create_from", "import", "changes"]
    
    
    def __init__(self, selected_value, app, helper_object):
        self.entries = [ComponentOption('mass-action', True, i, selected_value == i, 0, label=app._('mass-actions.%s' % i), extra_class='shinken-counter-parent',
                                        extra_content=helper_object.get_counter_html(id='mass-action-%s' % i, class_to_add="shinken-between-space-bracket")) for i in MassActionStagging.LIST]


class MassActionElementWithWorkArea:
    DEFAULT = "DEFAULT"
    LIST_GROUP_1 = [DEFAULT, "massive_change", "enable", "disable", "delete", "clone", "create_from", "import", "changes", "submit", "unlock"]
    LIST_GROUP_2 = ["apply", "reject"]
    
    def __init__(self, selected_value, app, helper_object):
        self.entries_1 = [ComponentOption('mass-action-work-area', True, i, selected_value == i, 0, label=app._('mass-actions.%s' % i), extra_class='shinken-counter-parent',
                                        extra_content=helper_object.get_counter_html(id='mass-action-work-area-%s' % i, class_to_add="shinken-between-space-bracket")) for i in MassActionElementWithWorkArea.LIST_GROUP_1]
        self.entries_2 = [ComponentOption('mass-action-work-area', True, i, False, 0, label=app._('mass-actions.%s' % i), extra_class='shinken-counter-parent',
                                        extra_content=helper_object.get_counter_html(id='mass-action-work-area-%s' % i, class_to_add="shinken-between-space-bracket")) for i in MassActionElementWithWorkArea.LIST_GROUP_2]


class HelperList(object):
    def __init__(self, app, helper):
        self.app = app
        self.helper = helper
    
    
    def get_list_select_input_html(self, list_values, property, value, extra_class_filled='', separator=[], separator_for_split=[], placeholder=None, need_caret=True, with_helper_tip=False):
        _to_return = []
        if property != 'poller_tag' and _selector_cache.get(property, None):
            _to_return = _selector_cache[property]
        else:
            if not placeholder:
                placeholder = "-- %s --" % self.app._('element.all')
            _splited_value = re.split(r"([^|&()]+)+", value)
            for i, unique_value in enumerate(_splited_value):
                if not unique_value or any(c in unique_value for c in separator_for_split):
                    continue
                for value_listed in list_values:
                    if value_listed.value == unique_value:
                        if value_listed.label.startswith('--') and value_listed.label.endswith('--'):
                            _splited_value[i] = value_listed.label
                        break
            value = ''.join(_splited_value)
            _to_return.append('''<div class="shinken-list-select-input shinken-list-filter-container shinken-parent-event-listener %s" '''),
            _to_return.append('''data-controller="list-all" data-separator="%s" ''' % '$^$'.join(separator))
            _to_return.append('''data-type="input-string-with-dropdown" data-name="%s">''' % property)
            _to_return.append('%s')
            _to_return.append(self.helper.helper_component.get_drop_down_component(list_values, property))
            if need_caret:
                _to_return.append('''<span class="shinken-caret-container"><span class="shinken-caret caret"></span></span>''')
            _to_return.append('''</div>''')
            _to_return = ''.join(_to_return)
            if property in ('type', 'status', 'type_element', 'working_area_status', 'realm', 'can_edit', 'poller_tag', 'sources') or not list_values:
                _selector_cache[property] = _to_return
        _to_return = _to_return % (extra_class_filled, self.helper.helper_component.get_input_html('input', value, extra_class_input="shinken-input-with-dropdown", type="text", autocomplete="autocomplete='off'", placeholder=placeholder, with_helper_tip=with_helper_tip))
        return _to_return
    
    
    def get_mass_action_html(self, type):
        _options = ComponentSelectOptions(self.helper.helper_component)
        if type == "working_area/hosts" or type == "my_working_area/hosts" or type == "hosts" or type == "elements":
            _work_area = MassActionElementWithWorkArea(MassActionElementWithWorkArea.DEFAULT, self.app, self.helper.helper_object)
            _group_1 = ComponentOptionGroup("id-shinken-actions-host-working-area", "<span >%s - </span><span>%s</span>" % (self.app._('type.%s' % ITEM_TYPE.HOSTS), self.app._('element.only_in_working_area')))
            _group_1.setContents(_work_area.entries_1)
            _group_2 = ComponentOptionGroup("id-shinken-actions-host-staging", "<span >%s - </span><span>%s</span>" % (self.app._('type.%s' % ITEM_TYPE.HOSTS), self.app._('element.only_in_staging')) )
            _group_2.setContents(_work_area.entries_2)
            _options.addContent(_group_1)
            _options.addContent(_group_2)
            if type == "elements":
                _group_3 = ComponentOptionGroup("id-shinken-actions-staging", "<span >%s - </span><span>%s</span>" % (self.app._('element.others'), self.app._('element.only_in_staging')))
                _group_3.setContents(MassActionStagging(MassActionStagging.DEFAULT, self.app, self.helper.helper_object).entries)
                _group_3.insertContent(0, ComponentOptionSeparator())
                _options.addContent(_group_3)
                # delete mass change
                _group_1.removeContent(2)
                _group_3.removeContent(3)
        else:
            _options.setContents(MassActionStagging(MassActionStagging.DEFAULT, self.app, self.helper.helper_object).entries)
        
        _to_return = []
        _to_return.append('''<div id="id-shinken-select-mass-action" class="shinken-select-container" data-name="mass-action" data-state-selector="0" data-object-type="mass-action" data-type="select-single">''')
        _to_return.append('''   %s''' % _options.buildHTML())
        _to_return.append('''</div>''')
        return ' '.join(_to_return)
