'use strict';
SHINKEN.OBJECT.ShinkenObject           = function () {
};
SHINKEN.OBJECT.ShinkenObject.prototype = {
    setShinkenDebug  : function ( to_set ) {
        this.is_shinken_debug = to_set;
        var _components       = this.getComponents();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            if ( _components[ i ] ) {
                _components[ i ].setShinkenDebug( to_set );
            }
        }
    },
    isShinkenDebugOn : function () {
        return this.is_shinken_debug;
    },
    getComponents    : function () {
        return [];
    },
    setNeedValidation: function ( to_set ) {
        this.need_validation = to_set;
        var _components      = this.getComponents();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            _components[ i ].setNeedValidation( to_set );
        }
    },
};
SHINKEN.TOOLS.STRING             = (function ( self ) {
    "use strict";
    self.CONST = {
        REGEX                   : {
            HTML_TAG        : /<(?:.|\n)*?>/gm,
            ESCAPE_CHARACTER: /\x1b/g
        },
        WHITE_SPACE             : ' ',
        NON_BREAK_SPACE         : '\u00a0',
        INVISIBLE_CHAR          : '\u200b',
        COMMA                   : ',',
        CHAR_CODE_BACK_TO_LINE  : 10,
        CHAR_CODE_INVISIBLE_CHAR: 8203
    };
    
    self.capitalize                      = function ( str ) {
        if ( !str ) {
            return "";
        }
        return str.charAt( 0 ).toUpperCase() + str.substring( 1 ).toLowerCase();
    };
    self.toUpperCase                     = function ( str ) {
        return str.toUpperCase();
    };
    self.isUpperCase                     = function ( str ) {
        if ( !str ) {
            return false;
        }
        return str === self.toUpperCase( str );
    };
    self.extractBetween                  = function ( string, start_tag, end_tag ) {
        if ( !string ) {
            return string;
        }
        var _start = string.indexOf( start_tag );
        if ( _start === -1 ) {
            return string;
        }
        _start   = _start + start_tag.length;
        var _end = string.indexOf( end_tag, _start );
        if ( _end === -1 ) {
            return string;
        }
        return string.substring( _start, _end );
    };
    self.replaceAll                      = function ( string, target, replacement ) {
        return string.split( target ).join( replacement || '' );
    };
    self.replaceWithRegex                = function ( text_to_change, regex, change_with ) {
        return text_to_change.replace( regex, change_with );
    };
    self.extractStringIfBeginningBy      = function ( str, search ) {
        var _to_return = false;
        if ( str.startsWith( search ) ) {
            _to_return = str.substr( search.length, str.length );
        }
        return _to_return;
    };
    self.splitMultiselectValueWithNoPlus = function ( str ) {
        var _to_return = SHINKEN.TOOLS.STRING.replaceAll( str, PROPERTY.CONST.STATE_VALUE_PLUS.ON + ",", "" );
        _to_return     = SHINKEN.TOOLS.STRING.replaceAll( _to_return, PROPERTY.CONST.STATE_VALUE_PLUS.ON, '' );
        return _to_return.split( ',' );
    };
    self.contains                        = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        return string.indexOf( to_find ) !== -1;
    };
    self.containsAny                     = function ( string, to_find_any_of ) {
        for ( var _i = 0; _i < to_find_any_of.length; _i++ ) {
            if ( to_find_any_of[ _i ] && self.contains( string, to_find_any_of[ _i ] ) ) {
                return true;
            }
        }
        return false;
    };
    self.containsCharCode                = function ( string, char_code ) {
        if ( !string ) {
            return false;
        }
        var _codes = this.getCharCodes( string );
        return SHINKEN.TOOLS.ARRAY.contains( _codes, char_code );
    };
    self.containsIgnoreCase              = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        
        var _string_to_lower_case  = string.toLowerCase();
        var _to_find_to_lower_case = to_find.toLowerCase();
        return self.contains( _string_to_lower_case, _to_find_to_lower_case );
    };
    self.cleanMultipleSpaces             = function ( string ) {
        string = self.trim( string );
        return self.replaceWithRegex( string, /\s\s+/g, self.CONST.WHITE_SPACE );
    };
    self.removeXss                       = function ( string ) {
        string = string || "";
        string = string.replace( /&/g, "" );
        string = string.replace( /</g, "" );
        string = string.replace( />/g, "" );
        string = string.replace( /"/g, "" );
        string = string.replace( /'/g, "" );
        string = string.replace( /\//g, "" );
        return string;
    };
    self.cleanXss                        = function ( string ) {
        string = string || "";
        string = string.replace( /&/g, "&amp;" );
        string = string.replace( /</g, "&lt;" );
        string = string.replace( />/g, "&gt;" );
        string = string.replace( /"/g, "&quot;" );
        string = string.replace( /'/g, "&#x27;" );
        string = string.replace( /\//g, "&#x2F;" );
        return string;
    };
    self.cleanJavaScript                   = function ( string ) {
        var index_open = string.indexOf("<script>");
        var index_close = string.indexOf("</script>");
        if ( index_open === -1 || index_close === -1 || index_close < index_open ){
            return string;
        }
        index_close = index_close + "</script>".length;
        return self.cleanJavaScript(string.substring(0, index_open) + string.substring(index_close, string.length ));
    };
    self.uncleanBeforecleanXss           = function ( string ) {
        var _string = self.unescape_xss( string );
        return self.cleanXss( _string );
    };
    self.unescape_xss                    = function ( string ) {
        string = string || "";
        string = string.replace( /&amp;/g, '&' );
        string = string.replace( /&lt;/g, '<' );
        string = string.replace( /&gt;/g, '>' );
        string = string.replace( /&quot;/g, '"' );
        string = string.replace( /&#x27;/g, "'" );
        string = string.replace( /&#x2F;/g, "/" );
        return string;
    };
    self.getRandomInt                    = function ( max ) {
        return Math.floor( Math.random() * Math.floor( max ) );
    };
    self.trim                            = function ( string ) {
        return string.trim();
    };
    self.trimExtented                    = function ( string ) {
        var _to_return = string.trim();
        if ( _to_return === string ) {
            return string;
        }
        return self.trimExtented( _to_return );
    };
    self.format                          = function () {
        var s = arguments[ 0 ];
        for ( var i = 0; i < arguments.length - 1; i++ ) {
            var reg = new RegExp( "\\{" + i + "\\}", "gm" );
            s       = s.replace( reg, arguments[ i + 1 ] );
        }
        return s;
    };
    self.getNumberOccurence              = function ( string, to_find ) {
        if ( to_find.length <= 0 ) {
            return (string.length + 1);
        }
        
        var n    = 0;
        var pos  = 0;
        var step = to_find.length;
        
        while ( true ) {
            pos = string.indexOf( to_find, pos );
            if ( pos >= 0 ) {
                ++n;
                pos += step;
            }
            else {
                break;
            }
        }
        return n;
    };
    self.startsWith                      = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        return string.substr( 0, to_find.length ) === to_find;
    };
    self.endsWith                        = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        var _start_index = string.length - to_find.length;
        return string.substr( _start_index ) === to_find;
    };
    self.buildS4                         = function () {
        return Math.floor( (1 + Math.random()) * 0x10000 )
                   .toString( 16 )
                   .substring( 1 );
    };
    self.buildUUID                       = function () {
        return self.buildS4() + self.buildS4() + '-' + self.buildS4() + '-' + self.buildS4() + '-' +
               self.buildS4() + '-' + self.buildS4() + self.buildS4() + self.buildS4();
    };
    self.getCharCodes                    = function ( string ) {
        var _size      = string.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = string.charCodeAt( i );
        }
        return _to_return;
    };
    self.b64Encode                       = function ( str ) {
        return btoa( encodeURIComponent( str ).replace( /%([0-9A-F]{2})/g, function ( match, p1 ) {
            return String.fromCharCode( parseInt( p1, 16 ) );
        } ) );
    };
    self.b64Decode                       = function ( str ) {
        return decodeURIComponent( Array.prototype.map.call( atob( str ), function ( c ) {
            return '%' + ('00' + c.charCodeAt( 0 ).toString( 16 )).slice( -2 );
        } ).join( '' ) );
    };
    self.utf8Encode                      = function ( str ) {
        return encodeURIComponent( str );
    };
    self.utf8decode                      = function ( str ) {
        return decodeURIComponent( str );
    };
    self.isEmpty                         = function ( string ) {
        if ( !string ) {
            return true;
        }
        var s = string.replace( /\s/g, '' );
        return s.length === 0;
    };
    self.isEmptyHtml                     = function ( string ) {
        if ( !string ) {
            return true;
        }
        var dom = DOM.Service.createElement( 'div', '', string );
        return self.isEmpty( dom.innerText );
    };
    self.indexesOf                       = function ( string, to_find ) {
        var _to_return = [];
        
        var _length         = string.length;
        var _length_to_find = to_find.length;
        
        var _current;
        for ( var i = 0; i <= _length - _length_to_find; i++ ) {
            _current = string.substring( i, i + _length_to_find );
            if ( _current === to_find ) {
                _to_return.push( i );
            }
        }
        return _to_return;
    };
    self.indexesOfNotBetween             = function ( string, to_find, to_ignore ) {
        var _to_return = self.indexesOf( string, to_find );
        return self.splicesindexesOfNotBetween( _to_return, to_ignore );
    };
    self.splicesindexesOfNotBetween      = function ( indexes, to_ignore ) {
        var _to_return = indexes;
        var _current_index;
        for ( var i = _to_return.length - 1; i >= 0; i-- ) {
            _current_index = _to_return[ i ];
            for ( var j = 0, _size_j = to_ignore.length; j < _size_j; j = j + 2 ) {
                if ( _current_index > to_ignore[ j ] && _current_index < to_ignore[ j + 1 ] ) {
                    _to_return.splice( i, 1 );
                    break;
                }
            }
        }
        return _to_return;
    };
    self.extraTextNotBetween             = function ( text, indexes_to_ignore ) {
        var _to_return = [];
        if ( !Array.isArray( indexes_to_ignore ) || !indexes_to_ignore.length ) {
            return _to_return;
        }
        var _split = self.splitWithIndexes( text, indexes_to_ignore, 1 );
        var _keep  = true;
        for ( var i = 0, _size_i = _split.length; i < _size_i; i++ ) {
            if ( _keep ) {
                _to_return.push( _split[ i ] );
            }
            _keep = !_keep;
        }
        return _to_return;
    };
    self.isInteger                       = function ( string ) {
        var pattern = /^\d+$/;
        return pattern.test( string );
    };
    self.splitWithIndexes                = function ( string, indexes, size_split_label ) {
        var _to_return = [];
        if ( !size_split_label ) {
            size_split_label = 1;
        }
        var _size_index = indexes.length;
        if ( !_size_index ) {
            _to_return[ 0 ] = string;
            return _to_return;
        }
        
        for ( var i = 0; i <= _size_index; i++ ) {
            if ( i === 0 ) {
                _to_return[ i ] = string.substring( 0, indexes[ i ] );
            }
            else if ( i === _size_index ) {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label );
            }
            else {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label, indexes[ i ] );
            }
        }
        
        return _to_return;
        
    };
    self.prefix_by_zero                  = function ( str, max ) {
        str = str.toString();
        return str.length < max ? self.prefix_by_zero( "0" + str, max ) : str;
    };
    self.getSubStringUntil               = function ( string, start, end ) {
        var _size = string.length;
        return string.substr( start, _size - end );
    };
    self.getAllIndexOf                   = function ( string, to_find, to_return, start_index ) {
        if ( !to_return ) {
            to_return   = [];
            start_index = 0;
        }
        var _index = string.substr( start_index ).indexOf( to_find );
        if ( _index !== -1 ) {
            to_return.push( _index + start_index );
            return self.getAllIndexOf( string, to_find, to_return, _index + to_find.length + start_index );
        }
        return to_return;
    };
    self.escapeRegExp                    = function ( string ) {
        return string.replace( /[.*+?^${}()|[\]\\]/g, '\\$&' );
    };
    self.isMatchingStarRegexTab          = function ( to_test, tab_to_test ) {
        for ( var i = 0, _size_i = tab_to_test.length; i < _size_i; i++ ) {
            if ( self.isMatchingStarRegex( to_test, tab_to_test[ i ].trim() ) ) {
                return true;
            }
        }
        return false;
    };
    self.isMatchingStarRegex             = function ( to_test, regex_star ) {
        var _contains_star = self.getAllIndexOf( regex_star, "*" );
        if ( !_contains_star.length ) {
            return to_test.trim() === regex_star.trim();
        }
        var _replaced = SHINKEN.TOOLS.STRING.replaceAll( regex_star, "**", "*" );
        if ( regex_star !== _replaced ) {
            return self.isMatchingStarRegex( to_test, _replaced );
        }
        regex_star         = self.escapeRegExp( regex_star );
        var _current       = new RegExp( SHINKEN.TOOLS.STRING.replaceAll( SHINKEN.TOOLS.STRING.trim( regex_star ), "\\*", ".*" ) );
        var _current_match = to_test.match( _current );
        if ( _current_match && _current_match[ 0 ] === to_test ) {
            return true;
        }
        return false;
    };
    return self;
})( SHINKEN.TOOLS.STRING || {} );
SHINKEN.TOOLS.STRING.PARENTHESIS = (function ( self ) {
    "use strict";
    self.isValid          = function ( indexes_opening, indexes_closing ) {
        var _size_open  = indexes_opening.length;
        var _size_close = indexes_closing.length;
        if ( _size_open !== _size_close ) {
            return _( "validator.parenthesis.not_same_number" );
        }
        for ( var i = 0; i < _size_open; i++ ) {
            if ( indexes_opening[ i ] > indexes_closing[ i ] ) {
                return _( "validator.parenthesis.not_good_order" );
            }
        }
    };
    self.getActiveIndexes = function ( indexes_opening, indexes_closing ) {
        var _to_return = [];
        var _size      = indexes_opening.length;
        var _concat    = [];
        for ( var i = 0; i < _size; i++ ) {
            _concat.push( { index: indexes_opening[ i ], is_open: true } );
        }
        for ( var i = 0; i < _size; i++ ) {
            _concat.push( { index: indexes_closing[ i ], is_open: false } );
        }
        _concat = SHINKEN.TOOLS.ARRAY.sortArray( _concat, "index" );
        if ( !_concat.length ) {
            return _to_return;
        }
        _to_return.push( _concat[ 0 ].index );
        var _current;
        var _search_close = 1;
        for ( var i = 1, _size_i = _concat.length; i < _size_i; i++ ) {
            _current = _concat[ i ];
            if ( _search_close ) {
                if ( _current.is_open ) {
                    _search_close++;
                }
                else {
                    _search_close--;
                    if ( !_search_close ) {
                        _to_return.push( _current.index );
                    }
                }
            }
            else {
                _to_return.push( _current.index );
                _search_close++;
            }
        }
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.PARENTHESIS || {} );
SHINKEN.TOOLS.MD5 = (function ( self ) {
    "use strict";
    self.MD5 = function ( d ) {
        var result = M( V( Y( X( d ), 8 * d.length ) ) );
        return result.toLowerCase();
    };
    
    function M ( d ) {
        for ( var _, m = "0123456789ABCDEF", f = "", r = 0; r < d.length; r++ ) {
            _ = d.charCodeAt( r ), f += m.charAt( _ >>> 4 & 15 ) + m.charAt( 15 & _ );
        }
        return f;
    }
    
    function X ( d ) {
        for ( var _ = Array( d.length >> 2 ), m = 0; m < _.length; m++ ) {
            _[ m ] = 0;
        }
        for ( m = 0; m < 8 * d.length; m += 8 ) {
            _[ m >> 5 ] |= (255 & d.charCodeAt( m / 8 )) << m % 32;
        }
        return _;
    }
    
    function V ( d ) {
        for ( var _ = "", m = 0; m < 32 * d.length; m += 8 ) {
            _ += String.fromCharCode( d[ m >> 5 ] >>> m % 32 & 255 );
        }
        return _;
    }
    
    function Y ( d, _ ) {
        d[ _ >> 5 ] |= 128 << _ % 32, d[ 14 + (_ + 64 >>> 9 << 4) ] = _;
        for ( var m = 1732584193, f = -271733879, r = -1732584194, i = 271733878, n = 0; n < d.length; n += 16 ) {
            var h = m,
                t = f,
                g = r,
                e = i;
            f = md5_ii( f = md5_ii( f = md5_ii( f = md5_ii( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_ff( f = md5_ff( f = md5_ff( f = md5_ff( f, r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 0 ], 7, -680876936 ), f, r, d[ n + 1 ], 12, -389564586 ), m, f, d[ n + 2 ], 17, 606105819 ), i, m, d[ n + 3 ], 22, -1044525330 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 4 ], 7, -176418897 ), f, r, d[ n + 5 ], 12, 1200080426 ), m, f, d[ n + 6 ], 17, -1473231341 ), i, m, d[ n + 7 ], 22, -45705983 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 8 ], 7, 1770035416 ), f, r, d[ n + 9 ], 12, -1958414417 ), m, f, d[ n + 10 ], 17, -42063 ), i, m, d[ n + 11 ], 22, -1990404162 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 12 ], 7, 1804603682 ), f, r, d[ n + 13 ], 12, -40341101 ), m, f, d[ n + 14 ], 17, -1502002290 ), i, m, d[ n + 15 ], 22, 1236535329 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 1 ], 5, -165796510 ), f, r, d[ n + 6 ], 9, -1069501632 ), m, f, d[ n + 11 ], 14, 643717713 ), i, m, d[ n + 0 ], 20, -373897302 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 5 ], 5, -701558691 ), f, r, d[ n + 10 ], 9, 38016083 ), m, f, d[ n + 15 ], 14, -660478335 ), i, m, d[ n + 4 ], 20, -405537848 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 9 ], 5, 568446438 ), f, r, d[ n + 14 ], 9, -1019803690 ), m, f, d[ n + 3 ], 14, -187363961 ), i, m, d[ n + 8 ], 20, 1163531501 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 13 ], 5, -1444681467 ), f, r, d[ n + 2 ], 9, -51403784 ), m, f, d[ n + 7 ], 14, 1735328473 ), i, m, d[ n + 12 ], 20, -1926607734 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 5 ], 4, -378558 ), f, r, d[ n + 8 ], 11, -2022574463 ), m, f, d[ n + 11 ], 16, 1839030562 ), i, m, d[ n + 14 ], 23, -35309556 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 1 ], 4, -1530992060 ), f, r, d[ n + 4 ], 11, 1272893353 ), m, f, d[ n + 7 ], 16, -155497632 ), i, m, d[ n + 10 ], 23, -1094730640 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 13 ], 4, 681279174 ), f, r, d[ n + 0 ], 11, -358537222 ), m, f, d[ n + 3 ], 16, -722521979 ), i, m, d[ n + 6 ], 23, 76029189 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 9 ], 4, -640364487 ), f, r, d[ n + 12 ], 11, -421815835 ), m, f, d[ n + 15 ], 16, 530742520 ), i, m, d[ n + 2 ], 23, -995338651 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 0 ], 6, -198630844 ), f, r, d[ n + 7 ], 10, 1126891415 ), m, f, d[ n + 14 ], 15, -1416354905 ), i, m, d[ n + 5 ], 21, -57434055 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 12 ], 6, 1700485571 ), f, r, d[ n + 3 ], 10, -1894986606 ), m, f, d[ n + 10 ], 15, -1051523 ), i, m, d[ n + 1 ], 21, -2054922799 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 8 ], 6, 1873313359 ), f, r, d[ n + 15 ], 10, -30611744 ), m, f, d[ n + 6 ], 15, -1560198380 ), i, m, d[ n + 13 ], 21, 1309151649 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 4 ], 6, -145523070 ), f, r, d[ n + 11 ], 10, -1120210379 ), m, f, d[ n + 2 ], 15, 718787259 ), i, m, d[ n + 9 ], 21, -343485551 ), m = safe_add( m, h ), f = safe_add( f, t ), r = safe_add( r, g ), i = safe_add( i, e );
        }
        return Array( m, f, r, i );
    }
    
    function md5_cmn ( d, _, m, f, r, i ) {
        return safe_add( bit_rol( safe_add( safe_add( _, d ), safe_add( f, i ) ), r ), m );
    }
    
    function md5_ff ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & m | ~_ & f, d, _, r, i, n );
    }
    
    function md5_gg ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & f | m & ~f, d, _, r, i, n );
    }
    
    function md5_hh ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ ^ m ^ f, d, _, r, i, n );
    }
    
    function md5_ii ( d, _, m, f, r, i, n ) {
        return md5_cmn( m ^ (_ | ~f), d, _, r, i, n );
    }
    
    function safe_add ( d, _ ) {
        var m = (65535 & d) + (65535 & _);
        return (d >> 16) + (_ >> 16) + (m >> 16) << 16 | 65535 & m;
    }
    
    function bit_rol ( d, _ ) {
        return d << _ | d >>> 32 - _;
    }
    
    return self;
})( SHINKEN.TOOLS.MD5 || {} );
String.prototype.startsWith = String.prototype.startsWith || function ( pattern ) {
    return this.indexOf( pattern ) === 0;
};
String.prototype.endsWith   = String.prototype.endsWith || function ( pattern ) {
    var d = this.length - pattern.length;
    return d >= 0 && this.lastIndexOf( pattern ) === d;
};
SHINKEN.TOOLS.CLASS = (function ( self ) {
    "use strict";
    self.CONST        = {
        COMPONENT: {
            SELECT: "component-select"
        }
    };
    self.addPrototype = function ( object_to_add_in, object_to_add_from ) {
        var _current;
        var _keys = Object.keys( object_to_add_from.prototype );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = _keys[ i ];
            if ( !object_to_add_in.prototype[ _current ] ) {
                object_to_add_in.prototype[ _current ] = object_to_add_from.prototype[ _current ];
            }
        }
    };
    return self;
})( SHINKEN.TOOLS.CLASS || {} );
SHINKEN.COMMUNICATION = (function( self ) {
    
    self.handleResponse = function( status ) {
        switch ( status ) {
            case COMMUNICATION.CODE.UNAUTHORIZED:
                SHINKEN.HIGHWAY.goTo( '/user/login?error=Utilisateur%20invalide,%20êtes-vous%20connecté%20?' );
                break;
            default:
                break;
        }
    };
    
    return self;
})( SHINKEN.NAVIGATOR || {} );
SHINKEN.OBJECT.Counter           = function ( dom_element, show_if_null ) {
    this.is_string              = false;
    this.is_label_before        = false;
    this.has_animation          = false;
    this.label                  = "";
    this.show_if_null           = !!show_if_null;
    this.elements_mapping       = {};
    this.counter_final          = 0;
    this.counter_parent         = null;
    this.uuid                   = SHINKEN.TOOLS.STRING.buildUUID();
    this.timeout_html           = null;
    this.toggle_parent_activity = false;
    this.target_dom_element     = null;
    if ( dom_element ) {
        this.init( dom_element );
    }
};
SHINKEN.OBJECT.Counter.prototype = {
    init               : function ( dom_element, update_with_dom ) {
        this.dom_element = dom_element;
        this.setDiscreet( !this.dom_element );
        if ( this.dom_element ) {
            this.dom_element_label = dom_element.querySelector( '.shinken-counter-label' );
            var _name_parent       = this.dom_element.dataset.parent;
            if ( _name_parent ) {
                this.counter_parent = MANAGER.__instance_counter_distributor.findCounter( _name_parent );
            }
            var _label = this.dom_element_label.querySelector( '.shinken-counter-extra-label' );
            if ( _label ) {
                this.label           = _label.outerHTML;
                this.is_label_before = !!this.dom_element_label.dataset.isBefore;
            }
            var _is_string = this.dom_element_label.dataset.isString;
            if ( _is_string ) {
                this.is_string = true;
            }
            if ( this.dom_element.dataset.showIfNull ) {
                this.show_if_null = true;
            }
            if ( this.dom_element.dataset.isDiscreet ) {
                this.setDiscreet( true );
            }
            if ( update_with_dom ) {
                this.initValueWithDom();
            }
        }
    },
    initValueWithDom   : function () {
        if ( !this.dom_element ) {
            return;
        }
        if ( !this.dom_element.dataset.number ) {
            return;
        }
        this.update( "init_with_dom", parseInt( this.dom_element.dataset.number ) );
    },
    getValue           : function () {
        return this.counter_final;
    },
    has                : function ( name ) {
        return !!this.elements_mapping[ name ];
    },
    setDiscreet        : function ( to_set ) {
        this.is_discreet = to_set;
    },
    reset              : function () {
        this.elements_mapping = {};
        this.counter_final    = 0;
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        this._updateHTML();
    },
    showForParent      : function ( show ) {
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, show ? this.counter_final : 0 );
        }
    },
    update             : function ( name, nb_counter, tooltip, retry_update_html, is_force ) {
        if ( !nb_counter ) {
            delete this.elements_mapping[ name ];
        }
        else {
            if ( !is_force && this.elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this.elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltip( tooltip );
        }
        this.counter_final = this.is_string ? "" : 0;
        var _keys          = Object.keys( this.elements_mapping );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counter_final = this.counter_final + this.elements_mapping[ _keys[ i ] ];
        }
        if ( this.target_dom_element ) {
            DOM.Service.setDataSet( this.target_dom_element, 'number', this.counter_final || 0 );
        }
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        return this._askUpdateHTML( retry_update_html );
    },
    setParent          : function ( to_set ) {
        this.counter_parent = to_set;
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        this._updateHTML();
    },
    setTargetDomElement: function ( to_set ) {
        this.target_dom_element = to_set;
        if ( this.target_dom_element ) {
            DOM.Service.setDataSet( this.target_dom_element, 'number', this.counter_final || 0 );
        }
    },
    setLabel           : function ( to_set, is_before ) {
        this.label           = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this.is_label_before = !!is_before;
    },
    isString           : function ( to_set ) {
        this.is_string = to_set;
    },
    _askUpdateHTML     : function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        var self          = this;
        this.timeout_html = setTimeout( function () {
            self._updateHTML( retry_update_html );
            this.timeout_html = null;
        }, 50 );
    },
    _updateHTML        : function ( retry_update_html ) {
        if ( this.is_discreet ) {
            return false;
        }
        if ( !this.dom_element_label ) {
            if ( retry_update_html ) {
                var self = this;
                setTimeout( function () {
                    self._updateHTML();
                }, 100 );
            }
            return false;
        }
        if ( this.counter_final ) {
            this.dom_element_label.innerHTML = this.label ? this.is_label_before ? this.label + " " + this.counter_final : this.counter_final + " " + this.label : this.counter_final;
            DOM.Service.setDataSet( this.dom_element, 'number', this.counter_final );
        }
        else if ( this.show_if_null ) {
            this.dom_element_label.innerHTML = '0';
            DOM.Service.setDataSet( this.dom_element, 'number', '0' );
        }
        else {
            this.dom_element_label.innerHTML = '';
            DOM.Service.setDataSet( this.dom_element, 'number', '' );
        }
        
        if ( this.has_animation ) {
            var _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-pulsate-parent', 10 );
            if ( _parent_dom_element ) {
                DOM.Service.askAddClass( _parent_dom_element, 'shinken-pulsate', 2000 );
            }
        }
        if ( this.toggle_parent_activity ) {
            var _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-counter-parent', 10 );
            if ( _parent_dom_element ) {
                if ( this.counter_final ) {
                    _parent_dom_element.classList.add( 'shinken-active' );
                }
                else {
                    _parent_dom_element.classList.remove( 'shinken-active' );
                }
            }
        }
        return true;
    },
    setTooltip         : function ( label, type ) {
        if ( !label ) {
            return;
        }
        this.dom_element.setAttribute( 'onmouseenter', 'SHINKEN_TOOLTIP.showTooltip(this)' );
        this.dom_element.setAttribute( 'onmouseleave', 'SHINKEN_TOOLTIP.hideTooltip()' );
        this.dom_element.setAttribute( 'shi-tip-html', label );
        this.dom_element.setAttribute( 'shi-tip-type', type );
    }
};
SHINKEN.OBJECT.CounterInterface           = function () {
};
SHINKEN.OBJECT.CounterInterface.prototype = {
    initCounters            : function ( parent, update_with_dom ) {
        this.errors        = new SHINKEN.OBJECT.Counter();
        this.errors.type   = "errors";
        this.warnings      = new SHINKEN.OBJECT.Counter();
        this.warnings.type = "warnings";
        this.user_set      = new SHINKEN.OBJECT.Counter();
        this.user_set.type = "user_set";
        this.total         = new SHINKEN.OBJECT.Counter();
        this.total.type    = "total";
        this.initCountersDom( update_with_dom );
        if ( parent ) {
            this.setParentCounter( parent );
        }
    },
    initCountersDom         : function ( update_with_dom ) {
        if ( this.dom_element ) {
            this.errors.init( this.dom_element.querySelector( '.shinken-error-counter' ), update_with_dom );
            this.warnings.init( this.dom_element.querySelector( '.shinken-warning-counter' ), update_with_dom );
            this.user_set.init( this.dom_element.querySelector( '.shinken-user-set-counter' ), update_with_dom );
            this.total.init( this.dom_element.querySelector( '.shinken-window-total-counter' ), update_with_dom );
        }
    },
    initCounterValuesWithDom: function () {
        this.errors.initValueWithDom();
        this.warnings.initValueWithDom();
        this.user_set.initValueWithDom();
        this.total.initValueWithDom();
    },
    resetCounters           : function () {
        this.warnings.reset();
        this.errors.reset();
        this.user_set.reset();
        this.total.reset();
    },
    hideCountersForParent   : function () {
        this.warnings.showForParent( false );
        this.errors.showForParent( false );
        this.user_set.showForParent( false );
        this.total.showForParent( false );
    },
    showCountersForParent   : function () {
        this.warnings.showForParent( true );
        this.errors.showForParent( true );
        this.user_set.showForParent( true );
        this.total.showForParent( true );
    },
    hasError                : function () {
        return !!this.errors.counter_final;
    },
    hasWarning              : function () {
        return !!this.warnings.counter_final;
    },
    setError                : function ( data_name, nb ) {
        this.errors.update( data_name, nb );
    },
    setWarning              : function ( data_name, nb ) {
        this.warnings.update( data_name, nb );
    },
    setUserSet              : function ( data_name, nb ) {
        this.user_set.update( data_name, nb );
    },
    setTotal                : function ( data_name, nb ) {
        this.total.update( data_name, nb );
    },
    getCounterError         : function () {
        return this.errors;
    },
    getCounterWarning       : function () {
        return this.warnings;
    },
    getCounterUserSet       : function () {
        return this.user_set;
    },
    getCounterTotal         : function () {
        return this.total;
    },
    setParentCounter        : function ( to_set ) {
        if ( to_set ) {
            this.getCounterError().setParent( to_set.getCounterError() );
            this.getCounterWarning().setParent( to_set.getCounterWarning() );
            this.getCounterUserSet().setParent( to_set.getCounterUserSet() );
            this.getCounterTotal().setParent( to_set.getCounterTotal() );
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
            this.getCounterUserSet().setParent();
            this.getCounterTotal().setParent();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterface, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.NAVIGATOR = (function ( self ) {
    "use strict";
    
    var navigator = {
        isChrome : false,
        isFireFox: false,
        isIE     : false,
        isHidden : false
    };
    
    
    setInterval( function () {
        setDocumentHidden();
    }, 2000 );
    
    function setDocumentHidden () {
        navigator.isHidden = document.hidden;
    }
    
    self.isNavigator          = function ( type ) {
        return navigator[ type ];
    };
    self.isNavigatorHidden    = function () {
        return navigator.isHidden;
    };
    self.init                 = function ( nb_try ) {
        var _navigator_class = '';
        if ( window.navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            navigator.isFireFox = true;
           _navigator_class = 'shinken-navigator-is-firefox';
        }
        else if ( window.navigator.userAgent.indexOf( 'Chrome' ) !== -1 ) {
            navigator.isChrome = true;
           _navigator_class = 'shinken-navigator-is-chrome';
        }
        else if ( window.navigator.userAgent.indexOf( 'Trident' ) !== -1 ) {
            navigator.isIE = true;
           _navigator_class = 'shinken-navigator-is-IE';
        }
        if ( document.body ) {
            document.body.classList.add( _navigator_class );
        }
        else if ( nb_try ) {
            setTimeout( function () {
                nb_try = nb_try - 1;
                SHINKEN.NAVIGATOR.init( nb_try );
            }, 1000 );
        }
    };
    self.shinken_beforeunload = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_beforeunload();
            default:
                return '';
        }
    };
    self.shinken_unload       = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_unload();
            default:
                return '';
        }
    };
    
    
    return self;
})( SHINKEN.NAVIGATOR || {} );
SHINKEN.NAVIGATOR.init( 50 );
SHINKEN.TOOLS.ARRAY = (function ( self ) {
    "use strict";
    
    self.concat                     = function ( array_1, array_2 ) {
        var toReturn = array_1.concat( array_2 );
        return toReturn;
    };
    self.concatUnique               = function ( array_1, array_2, key_for_unique ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            toReturn[ i ] = array_1[ i ];
        }
        _size = array_2.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !key_for_unique ) {
                self.addElement( toReturn, array_2[ i ] );
            }
            else if ( !self.containsElementWith( toReturn, array_2[ i ][ key_for_unique ], key_for_unique ) ) {
                toReturn.push( array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.concatUniqueIfNotPresentIn = function ( array_1, array_2, array_3 ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_1[ i ] ) ) {
                toReturn[ i ] = array_1[ i ];
            }
        }
        _size = array_2.length;
        for ( i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_2[ i ] ) ) {
                self.addElement( toReturn, array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.sortNumber                 = function ( array ) {
        if ( !array ) {
            return array;
        }
        return array.sort( function ( a, b ) {
            return a - b;
        } );
    };
    self.sortArray                  = function ( array, comparator_value, first_index_to_sort, reverse ) {
        if ( reverse === undefined ) {
            reverse = false;
        }
        
        if ( !array ) {
            return array;
        }
        if ( !comparator_value ) {
            return array.sort();
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        if ( first_index_to_sort ) {
            fix_array = array.slice( 0, first_index_to_sort );
            to_sort   = array.slice( first_index_to_sort, size );
        }
        to_sort.sort( function ( a, b ) {
            if ( a[ comparator_value ] < b[ comparator_value ] ) {
                return reverse ? 1 : -1;
            }
            else if ( a[ comparator_value ] > b[ comparator_value ] ) {
                return reverse ? -1 : 1;
            }
            return 0;
        } );
        return fix_array.concat( to_sort );
    };
    self.sortArrayMultiple          = function ( array, comparator_values ) {
        if ( !array ) {
            return array;
        }
        if ( !comparator_values ) {
            return array;
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        to_sort.sort(
            function ( a, b ) {
                return self._comparator( a, b, comparator_values, 0 );
            }
        );
        return fix_array.concat( to_sort );
    };
    self.getMapValues               = function ( map ) {
        if ( !map ) {
            return null;
        }
        return Object.keys( map ).map( function ( e ) {
            return map[ e ];
        } );
    };
    self._comparator                = function ( a, b, comparators, index ) {
        if ( index >= comparators.length ) {
            return 0;
        }
        if ( a[ comparators[ index ] ] < b[ comparators[ index ] ] ) {
            return -1;
        }
        else if ( a[ comparators[ index ] ] > b[ comparators[ index ] ] ) {
            return 1;
        }
        return self._comparator( a, b, comparators, (index + 1) );
    };
    self.filterWith                 = function ( array, key, value ) {
        if ( !array || !key || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var toReturn = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.filterWithDeeply           = function ( array, keys, value ) {
        if ( !array || !keys || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _to_return = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( self.findValueDeeply( _current, keys ) === value ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    };
    self.findValueDeeply            = function ( dict, keys ) {
        if ( !dict || !keys ) {
            return null;
        }
        var _size = keys.length;
        if ( _size < 1 ) {
            return null;
        }
        var _to_return = dict[ keys[ 0 ] ];
        if ( _size === 1 ) {
            return _to_return;
        }
        return self.findValueDeeply( _to_return, SHINKEN.TOOLS.ARRAY.clone( keys ).splice( -1, 1 ) );
    };
    self.findFirstElementWith       = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return _current;
            }
        }
        return null;
    };
    self.findFirstIndexWith         = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return i;
            }
        }
        return -1;
    };
    self.getLengthWith              = function ( array, key, value ) {
        var _filtered = self.filterWith( array, key, value );
        if ( !_filtered ) {
            return 0;
        }
        return _filtered.length;
    };
    self.extractKey                 = function ( array, key, ignoreEmpty ) {
        if ( !array || !key ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current && !ignoreEmpty ) {
                toReturn[ i ] = null;
            }
            else {
                if ( _current[ key ] || !ignoreEmpty ) {
                    toReturn[ i ] = _current[ key ];
                }
            }
        }
        return toReturn;
    };
    self.extractKeys                = function ( array, keys ) {
        var _keys_size = keys.length;
        if ( !array || !_keys_size ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current ) {
                toReturn[ i ] = self.initEmptyArray( _keys_size );
            }
            else {
                toReturn[ i ] = [];
                for ( var j = 0; j < _keys_size; j++ ) {
                    toReturn[ i ].push( _current[ keys[ j ] ] );
                }
            }
        }
        return toReturn;
    };
    self.removeDuplicate            = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( toReturn.indexOf( _current ) !== -1 ) {
                continue;
            }
            toReturn.push( _current );
        }
        return toReturn;
    };
    self.removeDuplicateArray       = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        var _to_add;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            _to_add  = true;
            for ( var j = 0, _size_j = toReturn.length; j < _size_j; j++ ) {
                if ( self.areEquals( toReturn[ j ], _current ) ) {
                    _to_add = false;
                }
            }
            if ( _to_add ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.hasSameKeyContent          = function ( array1, array2, key ) {
        if ( !key ) {
            return false;
        }
        if ( !array1 && !array2 ) {
            return true;
        }
        if ( !array1 || !array2 ) {
            return false;
        }
        
        var _extract1 = self.extractKey( array1, key );
        var _extract2 = self.extractKey( array2, key );
        if ( _extract1 === null && _extract2 === null ) {
            return true;
        }
        else if ( _extract1 === null || _extract2 === null ) {
            return false;
        }
        
        var _size1 = _extract1.length;
        var _size2 = _extract2.length;
        
        if ( _size1 !== _size2 ) {
            return false;
        }
        
        for ( var i = 0; i < _extract1; i++ ) {
            if ( _extract1[ i ] !== _extract2[ i ] ) {
                return false;
            }
        }
        return true;
    };
    self.getElementFromTo           = function ( array, indexBegin, indexEnd ) {
        return array.slice( indexBegin, indexEnd );
    };
    self.getElement                 = function ( array, key, value_to_find ) {
        var _size = self.getLength( array );
        var _current_element;
        for ( var i = 0; i < _size; i++ ) {
            _current_element = array[ i ];
            if ( _current_element[ key ] === value_to_find ) {
                return _current_element;
            }
        }
    };
    self.reverseArrayClone          = function ( array ) {
        var toReturn = Array.prototype.slice.call( array );
        toReturn.reverse();
        return toReturn;
    };
    self.initEmptyArray             = function ( length ) {
        var toReturn = [];
        for ( var i = 0; i <= length; i++ ) {
            toReturn.push( null );
        }
        return toReturn;
    };
    self.initIntegerArray           = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i );
        }
        return toReturn;
    };
    self.initIntegerArrayToString   = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i + "" );
        }
        return toReturn;
    };
    self.indexOf                    = function ( array, key, value ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ][ key ];
            if ( _current && _current === value ) {
                return i;
            }
        }
        return -1;
    };
    self.indexOfCollection          = function ( array, to_find ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            if ( array[ i ] === to_find ) {
                return i;
            }
        }
        return -1;
    };
    self.search                     = function ( array, key, value ) {
        var index = self.indexOf( array, key, value );
        if ( index === -1 ) {
            return null;
        }
        return array[ index ];
    };
    self.join                       = function ( array, separator ) {
        if ( Array.isArray( array ) ) {
            return array.join( separator );
        }
        return array.toString();
    };
    self.getLength                  = function ( array ) {
        if ( array ) {
            return array.length;
        }
        return 0;
    };
    self.clone                      = function ( array ) {
        return array.slice( 0 );
    };
    self.swap                       = function ( array, index_1, index_2 ) {
        if ( !array ) {
            return;
        }
        var b            = array[ index_1 ];
        array[ index_1 ] = array[ index_2 ];
        array[ index_2 ] = b;
        return array;
    };
    self.contains                   = function ( array, toSearch ) {
        if ( !array ) {
            return false;
        }
        return array.indexOf( toSearch ) !== -1;
    };
    self.addElement                 = function ( array, toAdd ) {
        if ( self.contains( array, toAdd ) ) {
            return -1;
        }
        return array.push( toAdd );
    };
    self.removeElement              = function ( array, toRemove ) {
        var index = array.indexOf( toRemove );
        if ( index === -1 ) {
            return false;
        }
        array.splice( index, 1 );
        return true;
    };
    self.parseToArray               = function ( obj ) {
        if ( !obj ) {
            return null;
        }
        
        var _keys      = Object.keys( obj );
        var _size      = _keys.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = obj[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.containsElementWith        = function ( array, toSearch, key ) {
        if ( !array ) {
            return false;
        }
        if ( !key ) {
            return false;
        }
        
        var _size = array.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( array[ i ][ key ] === toSearch ) {
                return true;
            }
        }
        return false;
    };
    self.areEquals                  = function ( array1, array2 ) {
        return JSON.stringify( array1 ) === JSON.stringify( array2 );
    };
    self.getMedianIndex             = function ( array, round_up ) {
        if ( !array ) {
            return SHINKEN.TOOLS.ARRAY.NOT_FOUND;
        }
        return round_up ? Math.ceil( array.length / 2 ) : Math.floor( array.length / 2 );
    };
    self.getFirstPartOf             = function ( array ) {
        return array.slice( 0, self.getMedianIndex( array ) + 1 );
    };
    self.getLastPartOf              = function ( array ) {
        return array.slice( self.getMedianIndex( array ), array.length );
    };
    return self;
})( SHINKEN.TOOLS.ARRAY || {} );
SHINKEN.TOOLS.ARRAY.NOT_FOUND = -1;
DOM.BodyService = (function( self ) {
    "use strict";
    
    var __body_element;
    var __list_to_remove = {};
    var __time_out_add;
    
    self.load = function() {
        if ( !__body_element ) {
            __body_element = document.querySelector( 'body' );
        }
    };
    self.hasChildWithID = function( id ) {
        var _child = self.getDomElement().querySelector( "#" + id );
        return _child;
    };
    self.askAddClass = function ( to_add, time_out ) {
        self.getDomElement().classList.add(to_add);
        if ( time_out ) {
            __list_to_remove[ to_add ] = true;
            clearTimeout( __time_out_add );
            __time_out_add = setTimeout( function () {
                var _keys = Object.keys( __list_to_remove );
                for( var i = 0, _size = _keys.length ; i < _size; i++ ) {
                    self.getDomElement().classList.remove(_keys[i]);
                }
                __list_to_remove = {};
            }, time_out );
        }
    };
    self.removeClass = function ( to_remove ) {
        self.getDomElement().classList.remove(to_remove);
        __list_to_remove[ to_remove ] = false;
    };
    self.addChild       = function( dom_element ) {
        DOM.Service.addElementTo( dom_element, self.getDomElement() );
    };
    self.getDomElement  = function() {
        if ( !__body_element ) {
            self.load();
        }
        return __body_element;
    };
    self.cleanDomElement  = function() {
        __body_element = null;
    };
    return self;
})( DOM.BodyService || {} );
DOM.ScrollService = (function ( self ) {
    "use strict";
    
    self.getMiddleScrollPosition       = function ( dom_element_container ) {
        var _top    = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.TOP );
        var _bottom = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.BOTTOM );
        
        return ((_bottom - _top) / 2) + _top;
    };
    self.getFirstVisibleDom            = function ( dom_element_container, css_selector_children, move_down ) {
        var _position = DOM.Service.getBoundingClientRect( dom_element_container, move_down ? DOM.CONST.STYLE.TOP : DOM.CONST.STYLE.BOTTOM );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _position, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFromMiddle = function ( dom_element_container, css_selector_children, move_down ) {
        var _middle_pos = DOM.ScrollService.getMiddleScrollPosition( dom_element_container );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _middle_pos, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFrom       = function ( list, position, move_down, dom_element_container ) {
        var _size  = list.length;
        var _index = move_down ? _size - 1 : 0;
        var _delta = move_down ? -1 : 1;
        
        var _closer_index     = _index;
        var _last_closer_diff = 9999;
        var _current;
        for ( ; _index < _size && _index >= 0; _index = _index + _delta ) {
            _current = list[ _index ];
            if ( !DOM.Service.isVisible( _current ) ) {
                continue;
            }
            if ( !DOM.Service.isFullyVisibleInParent( _current, dom_element_container ) ) {
                continue;
            }
            var _median = DOM.Service.getBoundingClientRect( _current, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
            if ( Math.abs( _median - position ) < _last_closer_diff ) {
                _last_closer_diff = Math.abs( _median - position );
                _closer_index     = _index;
                continue;
            }
            else {
                break;
            }
        }
        return list[ _closer_index ];
    };
    self.isVisible                     = function ( dom_element_container, dom_element_to_test, marge, action_type ) {
        if ( !dom_element_to_test ) {
            return false;
        }
        marge               = marge || 0;
        var _rect_to_test   = dom_element_to_test.getBoundingClientRect();
        var _rect_container = dom_element_container.getBoundingClientRect();
        
        if ( action_type ) {
            if ( _rect_to_test.bottom - _rect_container.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
            }
            if ( _rect_container.bottom - _rect_to_test.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_TOP;
            }
            return true;
        }
        else {
            return _rect_to_test.bottom - _rect_container.top >= marge && _rect_container.bottom - _rect_to_test.top >= marge;
        }
    };
    self.bindWith                      = function ( dom_element, dom_element_to_bind_with, previous_position_vertical, action_type ) {
        switch ( action_type ) {
            case DOM.CONST.ATTRIBUTE.SCROLL_TOP:
            case DOM.CONST.ATTRIBUTE.SCROLL_DOWN:
                if ( self.isVisible( dom_element, dom_element_to_bind_with, 3 * DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT ), action_type ) ) {
                    return;
                }
                else {
                    var _delta = DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT );
                    if ( previous_position_vertical ) {
                        _delta = previous_position_vertical - DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                    }
                    self.changeVerticaly( dom_element, _delta, action_type );
                }
                break;
        }
    };
    self.changeVerticaly               = function ( dom_element, delta, action_type ) {
        dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] = Math.ceil( dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] - delta );
    };
    
    return self;
})( DOM.ScrollService || {} );
DOM.Service = (function ( self ) {
    "use strict";
    
    var __previous_scrollLeft = 0;
    
    self.hasKeyInDataSet                   = function ( element, key ) {
        return typeof element.dataset[ key ] !== "undefined";
    };
    self.findParentElementWithDataSet      = function ( element, key, deepLimit ) {
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( self.hasKeyInDataSet( element, key ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithDataSet( element.parentElement, key, deepLimit );
    };
    self.findParentElementWithClass        = function ( element, class_tag, deepLimit ) {
        if ( deepLimit < 0 || !element ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    };
    self.createElement                     = function ( tag, attributes, innerHTML ) {
        var toReturn = document.createElement( tag );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                toReturn.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        if ( innerHTML ) {
            toReturn.innerHTML = innerHTML;
        }
        return toReturn;
    };
    self.cloneElement                      = function ( dom_element_to_clone, attributes ) {
        var _to_return = dom_element_to_clone.cloneNode( true );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                _to_return.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        return _to_return;
    };
    self.addTooltip                        = function ( element, attributes ) {
        if ( !attributes ) {
            return;
        }
        element.setAttribute( 'onmouseenter', "SHINKEN_TOOLTIP.showTooltip(this)" );
        element.setAttribute( 'onmouseleave', "SHINKEN_TOOLTIP.hideTooltip()" );
        var _keys = Object.keys( attributes );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            element.setAttribute( _keys[ i ], attributes[ _keys[ i ] ] );
        }
        return element;
    };
    self.bindElementOnScroll               = function ( elementScrolled, elementToBind, name_property, callback ) {
        elementScrolled.addEventListener( DOM_CONSTANT.SCROLL.EVENT, function () {
            var scrollPos         = elementScrolled.getData( name_property );
            var _do_callback      = scrollPos !== __previous_scrollLeft;
            __previous_scrollLeft = scrollPos;
            elementToBind.setData( name_property, scrollPos );
            if ( _do_callback && callback ) {
                callback();
            }
        } );
    };
    self.removeElement                     = function ( element ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        
        try {
            var _to_return = parent.removeChild( element );
            return _to_return;
        }
        catch ( e ) {
            return false;
        }
    };
    self.removeParentIfHasClassOrElement   = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        if ( !parent ) {
            return;
        }
        
        if ( parent.classList.contains( class_to_test ) ) {
            var _grand_parent = parent.parentNode;
            if ( !_grand_parent ) {
                return;
            }
            _grand_parent.removeChild( parent );
        }
        
        return parent.removeChild( element );
    };
    self.setDataSet                        = function ( element, attr, value ) {
        if ( !element ) {
            return;
        }
        element.dataset[ attr ] = value;
        element.classList.toggle( "IE-PATCH" );
    };
    self.getInnerText                      = function ( element ) {
        if ( !element ) {
            return;
        }
        return element.innerText.trim();
    };
    self.askAddClass                       = function ( element, to_add, time_out ) {
        element.classList.add( to_add );
        if ( time_out ) {
            setTimeout( function () {
                element.classList.remove( to_add );
            }, time_out );
        }
    };
    self.removeElementIfHasClass           = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        if ( !element.classList.contains( class_to_test ) ) {
            return false;
        }
        var parent = element.parentNode;
        return parent.removeChild( element );
    };
    self.addElementAtIndex                 = function ( element, parent, index ) {
        if ( !parent || !element ) {
            return;
        }
        if ( !index ) {
            index = 0;
        }
        if ( parent.childElementCount <= index ) {
            self.addElementTo( element, parent );
        } else {
            self.insertElementBefore(element, parent.children[index])
        }
    };
    self.addElementTo                      = function ( element, parent ) {
        if ( parent && element ) {
            parent.appendChild( element );
        }
    };
    self.addElementAfterTo                 = function ( element, target ) {
        var _next = target.nextSibling.nextSibling;
        if ( _next ) {
            target.parentNode.insertBefore( element, _next );
        }
        else {
            self.addElementTo( element, target.parentNode );
        }
    };
    self.switchElementParent                     = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        parent_1.removeChild( element_1 );
        parent_2.removeChild( element_2 );
        
        parent_1.appendChild( element_2 );
        parent_2.appendChild( element_1 );
    };
    self.switchElement                     = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        var _index_1 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_1.children, element_1 );
        var _index_2 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_2.children, element_2 );
        self.insertElementBefore( element_2, element_1 );
        self.addElementAtIndex(element_1, parent_2, _index_2);
    };
    self.insertElementBefore               = function ( element_existing, element_to_insert ) {
        if ( !element_existing || !element_to_insert ) {
            return;
        }
        var _parent = element_existing.parentNode;
        _parent.insertBefore( element_to_insert, element_existing );
    };
    self.getValueDataSet                   = function ( dom_element, key ) {
        return dom_element.dataset[ key ];
    };
    self.setStyle                          = function ( dom_element, key, value ) {
        if ( !dom_element || !key ) {
            return;
        }
        
        switch ( key ) {
            case DOM.CONST.STYLE.LEFT:
            case DOM.CONST.STYLE.TOP:
            case DOM.CONST.STYLE.HEIGHT:
            case DOM.CONST.STYLE.WIDTH:
            case DOM.CONST.STYLE.MAX_HEIGHT:
            case DOM.CONST.STYLE.MAX_WIDTH:
                if ( !isNaN( value ) ) {
                    value = value + 'px';
                }
                dom_element.style[ key ] = value;
                break;
            default:
                dom_element.style[ key ] = value;
        }
    };
    self.setStyles                         = function ( dom_element, styles ) {
        var keys = Object.keys( styles );
        for ( var i = 0, size = keys.length; i < size; i++ ) {
            self.setStyle( dom_element, keys[ i ], styles[ keys[ i ] ] );
        }
    };
    self.addClasses                        = function ( dom_element, class_to_add ) {
        if ( typeof class_to_add === 'string' ) {
            class_to_add = class_to_add.split( ' ' );
        }
        for ( var i = 0, _size_i = class_to_add.length; i < _size_i; i++ ) {
            dom_element.classList.add( class_to_add[ i ] );
        }
    };
    self.removeClasses                     = function ( dom_element, class_to_remove ) {
        if ( typeof class_to_remove === 'string' ) {
            class_to_remove = class_to_remove.split( ' ' );
        }
        for ( var i = 0, _size_i = class_to_remove.length; i < _size_i; i++ ) {
            dom_element.classList.remove( class_to_remove[ i ] );
        }
    };
    self.getBoundingClientRect             = function ( dom_element, key ) {
        if ( !dom_element ) {
            return;
        }
        var _rect = dom_element.getBoundingClientRect();
        if ( !key ) {
            return _rect;
        }
        if ( key === DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM ) {
            return parseInt( (_rect[ DOM.CONST.STYLE.TOP ] + _rect[ DOM.CONST.STYLE.BOTTOM ]) / 2 );
        }
        return parseInt( _rect[ key ] );
    };
    self.hasScrollHeight                   = function ( dom_element ) {
        var _height = self.getBoundingClientRect( dom_element, 'height' );
        return _height < dom_element.scrollHeight;
    };
    self.setHtmlOrHide                     = function ( dom_element, to_set ) {
        if ( !dom_element ) {
            return;
        }
        if ( to_set ) {
            dom_element.innerHTML = to_set;
            dom_element.classList.remove( 'shinken-hidden' );
        }
        else {
            dom_element.classList.add( 'shinken-hidden' );
        }
    };
    self.replaceChild                      = function ( element_to_replace, element_replace_with ) {
        var _parent_node = element_to_replace.parentNode;
        _parent_node.replaceChild( element_replace_with, element_to_replace );
    };
    self.empty                             = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        while ( dom_element.firstChild ) {
            dom_element.removeChild( dom_element.firstChild );
        }
    };
    self.removeAttribute                   = function ( dom_element, attribute_name ) {
        dom_element.removeAttribute( attribute_name );
    };
    self.getComputedStyle                  = function ( dom_element, key ) {
        if ( !dom_element ) {
            return {};
        }
        var _to_return = dom_element.currentStyle || getComputedStyle( dom_element );
        if ( key ) {
            _to_return = _to_return[ key ];
            if ( SHINKEN.TOOLS.STRING.endsWith( _to_return, 'px' ) ) {
                _to_return = parseInt( _to_return );
            }
        }
        return _to_return;
    };
    self.getHeight                         = function ( dom_element ) {
        if ( !dom_element ) {
            return 0;
        }
        return dom_element.offsetHeight;
    };
    self.isVisible                         = function ( elem, deepness ) {
        if ( !elem ) {
            return false;
        }
        if ( !deepness ) {
            deepness = 0;
        }
        if ( !(elem instanceof Element) ) {
            throw Error( 'DomUtil: elem is not an element.' );
        }
        var styles = self.getComputedStyle( elem );
        if ( styles.display === 'none' ) {
            return false;
        }
        if ( styles.visibility !== 'visible' && styles.visibility !== 'inherit' ) {
            return false;
        }
        if ( styles.opacity < 0.1 ) {
            return false;
        }
        if ( elem.parentElement && deepness > 0 ) {
            return self.isVisible( elem.parentElement, deepness-- );
        }
        return true;
    };
    self.isFullyVisibleInParent            = function ( dom_element, dom_parent ) {
        var _parent_rect  = self.getBoundingClientRect( dom_parent );
        var _element_rect = self.getBoundingClientRect( dom_element );
        if ( _element_rect[ DOM.CONST.STYLE.TOP ] < _parent_rect[ DOM.CONST.STYLE.TOP ] ) {
            return false;
        }
        if ( _element_rect[ DOM.CONST.STYLE.BOTTOM ] > _parent_rect[ DOM.CONST.STYLE.BOTTOM ] ) {
            return false;
        }
        return true;
    };
    self.setInputValue                     = function ( dom_element, to_set ) {
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            dom_element.setAttribute( 'value', to_set );
            dom_element.classList.toggle( "IE-PATCH" );
            dom_element.value = to_set;
            return;
        }
        dom_element.value = to_set;
    };
    self.hasFocus                          = function ( dom_element ) {
        return dom_element === document.activeElement;
    };
    self.generateDomElementFromString      = function ( string ) {
        var _to_return = self.createElement( "div", "", string );
        return _to_return.children;
    };
    self.hasHrefHost                       = function ( url ) {
        var _dom_url = self.createElement( "a", { href: url } );
        return !!_dom_url.host;
    };
    self.isMatchingMedianDomElementTopWith = function ( list, y ) {
        var _median_index = SHINKEN.TOOLS.ARRAY.getMedianIndex( list, true );
        if ( _median_index === SHINKEN.TOOLS.ARRAY.NOT_FOUND ) {
            return DOM.CONST.VALUE.NONE;
        }
        var _median  = list[ _median_index ];
        var _compare = self.compareCoordinates( _median, null, y );
        if ( _compare === 0 ) {
            return _median;
        }
        return _compare;
    };
    self.compareCoordinates                = function ( dom_element, x, y ) {
        var _rect = self.getBoundingClientRect( dom_element );
        if ( x ) {
            if ( _rect.left < x ) {
                return -1;
            }
            if ( _rect.left + _rect.width > x ) {
                return 1;
            }
        }
        if ( y ) {
            if ( _rect.top > y ) {
                return -1;
            }
            if ( _rect.top + _rect.height < y ) {
                return 1;
            }
        }
        return 0;
    };
    self.show                              = function ( dom_element ) {
        dom_element.classList.remove( "shinken-hidden" );
    };
    self.hide                              = function ( dom_element ) {
        dom_element.classList.add( "shinken-hidden" );
    };
    self.setEditable                       = function ( edit_content, dom_container, dom_to_edit ) {
        dom_to_edit.contentEditable = edit_content;
        if ( edit_content === true ) {
            self.focusAtTheEnd( dom_to_edit );
        }
        self.setDataSet( dom_container, 'statusEdit', edit_content ? "1" : "0" );
    };
    self.focusAtTheEnd                     = function ( dom_element ) {
        dom_element.focus();
        var range = document.createRange();
        range.selectNodeContents( dom_element );
        range.collapse( false );
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange( range );
    };
    
    return self;
})( DOM.Service || {} );
DOM.CONST = {
    STYLE                   : {
        LEFT      : 'left',
        RIGHT     : 'right',
        TOP       : 'top',
        BOTTOM    : 'bottom',
        HEIGHT    : 'height',
        MAX_HEIGHT: 'max-height',
        MAX_WIDTH : 'max-width',
        WIDTH     : 'width',
        Z_INDEX   : 'z-index',
        DISPLAY   : 'display'
    },
    ATTRIBUTE               : {
        SCROLL_DOWN: 'scrollDown',
        SCROLL_TOP : 'scrollTop',
        SCROLL_LEFT: 'scrollLeft'
    },
    VALUE                   : {
        NONE: 'none'
    },
    SPECIAL                 : {
        MEDIAN_TOP_BOTTOM: 'MEDIAN_TOP_BOTTOM'
    },
    WAITING_TIME_BEFORE_EXEC: {
        INPUT: 200
    }
};
SHINKEN.TOOLS.KEY = (function ( self ) {
    "use strict";
    
    self.simulateKey    = function ( key_code ) {
    };
    return self;
})( SHINKEN.TOOLS.KEY || {} );
SHINKEN.TOOLS.NUMBER = (function ( self ) {
    "use strict";
    self.roundTo                 = function ( number, precision ) {
        if ( !precision ) {
            precision = 0;
        }
        var _number = Number( number );
        return _number.toFixed( precision );
    };
    self.parseFloat              = function ( number ) {
        if ( typeof  number === "string" ) {
            number = number.replace( ',', '.' );
        }
        return parseFloat( number );
    };
    self.percent                 = function ( number ) {
        return self.roundTo( number * 100, 2 );
    };
    self.getRandom               = function ( min, max ) {
        return Math.floor( Math.random() * (max - min + 1) + min );
    };
    self.percent_no_extem        = function ( number ) {
        var toReturn = self.percent( number );
        if ( toReturn === '100.00' ) {
            toReturn = 100;
            if ( number !== 1 ) //IN ORDER TO NOT BE AT 100% WHEN THE PERCENT IS ROUNDED
            {
                toReturn = 99.99;
            }
        }
        else if ( toReturn === '-100.00' ) {
            toReturn = -100;
        }
        else if ( toReturn === '0.00' ) {
            toReturn = 0;
        }
        return toReturn;
    };
    self.getPathIconSla          = function ( sla_percent, critical_threshold, warning_threshold ) {
        sla_percent        = parseFloat( sla_percent );
        critical_threshold = parseFloat( critical_threshold );
        warning_threshold  = parseFloat( warning_threshold );
        var _path          = "";
        if ( sla_percent < critical_threshold ) {
            _path = "assets/images/widget/sla/storm.svg";
        }
        else if ( sla_percent >= critical_threshold && sla_percent < warning_threshold ) {
            _path = "assets/images/widget/sla/cloud.svg";
        }
        else {
            _path = 'assets/images/widget/sla/sun.svg';
        }
        return _path;
    };
    self.getDateToFormatedNumber = function ( number_date ) {
        if ( number_date > 9 ) {
            return number_date;
        }
        return "0" + number_date;
    };
    return self;
})( SHINKEN.TOOLS.NUMBER || {} );
SHINKEN.TOOLS.LOADER = (function( self ) {
    "use strict";
    var _ID_LOADER_TOOLS = "shinken-loader-container";
    var __loader_dom_element;
    var __loader_dom_element_message;
    var __loader_dom_element_icon;
    self.show             = function( message, has_icon ) {
        if ( !__loader_dom_element ){
            __loader_dom_element = DOM.Service.createElement( 'div', { id: _ID_LOADER_TOOLS } );
            var __loader_text = DOM.Service.createElement( 'div', { class: "shinken-loading-text" } );
            __loader_dom_element_message= DOM.Service.createElement( 'div', { class: "shinken-loading-text-content" } );
            __loader_dom_element_icon = DOM.Service.createElement( 'div', { id: "checking-loader" } );
            var _loader_dom_element_icon_content = DOM.Service.createElement( 'div', { class: "floatingBarsG text-center" } );
            for ( var i = 0 ; i < 9 ; i++ ){
                DOM.Service.addElementTo( DOM.Service.createElement( 'div', { class: "shinken-block rotate-0" + i } ), _loader_dom_element_icon_content);
            }
            DOM.Service.addElementTo( __loader_text, __loader_dom_element);
            DOM.Service.addElementTo( _loader_dom_element_icon_content, __loader_dom_element_icon);
            DOM.Service.addElementTo( __loader_dom_element_message, __loader_text);
            DOM.Service.addElementTo( __loader_dom_element_icon, __loader_text);
            DOM.BodyService.addChild(__loader_dom_element);
        }
        if ( has_icon ){
            __loader_dom_element_icon.classList.remove('hidden');
        } else {
            __loader_dom_element_icon.classList.add('hidden');
        }
        __loader_dom_element_message.innerHTML = message;
        __loader_dom_element.classList.remove('hidden');
    };
    self.hide             = function() {
        __loader_dom_element.classList.add('hidden');
    }
    return self;
})( SHINKEN.TOOLS.ARRAY || {} );
var CLIPBOARD_SERVICE = (function ( self ) {
    "use strict";
    self.dom_textarea     = document.querySelector( "#id-shinken-copy-clipboard-container" );
    self.dom_parent       = null;
    self.dom_button       = null;
    self.dom_text_to_copy = null;
    
    self.TYPE      = {};
    self.TYPE.TEXT = 'text';
    self.TYPE.HTML = 'html';
    
    self.setContent       = function ( dom_element, type ) {
        initDomElement( dom_element );
        if ( !self.dom_parent || !self.dom_text_to_copy ) {
            displayResult( false );
            return;
        }
        var _value;
        
        switch ( type ) {
            case self.TYPE.TEXT:
                _value = DOM.Service.getInnerText( self.dom_text_to_copy );
                break;
            case self.TYPE.HTML:
                _value = self.dom_text_to_copy.outerHTML;
                break;
        }
        
        setValueTextArea( _value );
        self.dom_textarea.select();
        var status = false;
        try {
            status = document.execCommand( 'copy' );
            displayResult( status );
            setValueTextArea( '' );
        }
        catch ( err ) {
            console.log( 'Unable to copy.' );
        }
    };
    self.buildHtmlButtons = function ( hasCopyButton, hasEditButton ) {
        var table_buttons = DOM.Service.createElement( "table", { class: "shinken-copy-buttons-container" } );
        var line_buttons  = DOM.Service.createElement( "tr", {} );
        
        if ( hasCopyButton ) {
            var button_copy_cell            = DOM.Service.createElement( "td", { class: "shinken-btn-copy-cell" } );
            var button_copy                 = DOM.Service.createElement( "td", {
                class             : "shinken-btn-copy shinken-btn-copy-text",
                onclick           : 'CLIPBOARD_SERVICE.setContent(this, CLIPBOARD_SERVICE.TYPE.TEXT)',
                'data-status-copy': '0',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_text_copy' )
            } );
            var icon_button_copy            = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinicon shinicon-copy" } );
            var success_message_button_copy = DOM.Service.createElement( "span", { class: "shinken-copy-success-message" }, _( 'copy_service.copySuccess' ) );
            var error_message_button_copy   = DOM.Service.createElement( "span", { class: "shinken-copy-error-message" }, _( 'copy_service.copyFail' ) );
            
            button_copy.appendChild( icon_button_copy );
            button_copy.appendChild( success_message_button_copy );
            button_copy.appendChild( error_message_button_copy );
            button_copy_cell.appendChild( button_copy );
            line_buttons.appendChild( button_copy_cell );
        }
        if ( hasEditButton ) {
            var button_edit_cell = DOM.Service.createElement( "td", { class: "shinken-btn-edit-cell" } );
            var button_edit      = DOM.Service.createElement( "td", {
                class             : "shinken-btn-copy",
                onclick           : 'MANAGER.EventManager.clickOnPaste(event)',
                'data-status-copy': '0',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_edition' )
            } );
            var icon_button_edit = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinken-icons-url shinken-icons-url-write" } );
            
            button_edit.appendChild( icon_button_edit );
            button_edit_cell.appendChild( button_edit );
            line_buttons.appendChild( button_edit_cell );
        }
        table_buttons.appendChild( line_buttons );
        return table_buttons;
    };
    
    function initDomElement ( dom_element ) {
        setDomButton( dom_element );
        self.dom_parent = findParentElementWithClass( dom_element, "shinken-parent-text-to-copy", 5 );
        if ( !self.dom_parent ) {
            return;
        }
        self.dom_text_to_copy = self.dom_parent.querySelector( ".shinken-text-to-copy" );
    }
    
    function setDomButton ( to_set ) {
        self.dom_button = to_set;
    }
    
    function setValueTextArea ( to_set ) {
        if ( !self.dom_textarea ) {
            self.dom_textarea = document.querySelector( "#id-shinken-copy-clipboard-container" );
        }
        self.dom_textarea.value = to_set;
    }
    
    function getTextAreaFocus () {
        if ( !self.dom_textarea ) {
            self.dom_textarea = document.querySelector( "#id-shinken-copy-clipboard-container" );
        }
    }
    
    function displayResult ( status ) {
        self.dom_button.dataset[ 'statusCopy' ] = status ? '1' : '2';
        self.dom_button.classList.toggle( "IE-PATCH" );
        
        var _tmp_button = self.dom_button;
        setTimeout( function () {
            _tmp_button.dataset[ 'statusCopy' ] = '0';
            _tmp_button.classList.toggle( "IE-PATCH" );
        }, 2000 );
    }
    
    function findParentElementWithClass ( element, class_to_find, deepLimit ) {
        if ( !element ) {
            return null;
        }
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( element.classList.contains( class_to_find ) ) {
            return element;
        }
        deepLimit--;
        return findParentElementWithClass( element.parentElement, class_to_find, deepLimit );
    }
    
    return self;
    
})( {} );
COMPONENT.InterfaceLine = function () {
};
COMPONENT.InterfaceLine.prototype = {
    init                            : function ( parent, element ) {
        this.inputs    = {};
        this.selectors = {};
        this.uuid      = SHINKEN.TOOLS.STRING.buildUUID();
        DOM.Service.setDataSet( element, 'uuid', this.uuid );
        DOM.Service.setDataSet( element, 'name', this.uuid );
        this.parent_name = parent.getParentName();
        this.initCounters( parent );
        this.initSpecific();
        this.initDomElement( element );
        this.initSpecificEnd();
    },
    initDomElement                  : function ( element ) {
        this.dom_element          = element;
        this.dom_element_cfg_file = element.querySelector( '.shinken-cfg-line-value .shinken-cfg-file-value' );
        
        var _keys = Object.keys( this.inputs );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.addInput( _current_key );
        }
        _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key                   = _keys[ i ];
            this.selectors[ _current_key ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + _current_key + '"]' ), this.selectors[ _current_key ], false, this );
            this.selectors[ _current_key ].computeTitle();
        }
    },
    initSpecificEnd                 : function ( parent ) {
        var self = this;
        setTimeout( function () {
            var _keys = Object.keys( self.inputs );
            for( var i = 0, _size = _keys.length ; i < _size; i++ ) {
                self.inputs[_keys[i]].validateValueInput();
            }
        }, 10 );
    },
    clickOnSelector                 : function ( dom_element ) {
        var _target = DOM.Service.findParentElementWithClass( dom_element, "shinken-select-container", 10 ).dataset.name;
        var _keys   = Object.keys( this.selectors );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.selectors[ _keys[ i ] ];
            if ( _keys[ i ] === _target ) {
                _current.clickOnSelector();
            }
            else {
                _current.hidePopup();
            }
        }
    },
    ___clickOnItemSelector          : function ( key_name, dom_element ) {
        if ( !dom_element ) {
            return;
        }
        var _current = this.getSelectorViaChildrenDomElement( dom_element );
        _current.clickOnItemSelector( "", key_name );
        _current.computeTitle();
    },
    askComputeAfterChange           : function ( dom_element, parent_prop_object ) {
        var _keys = Object.keys( this.inputs );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.inputs[ _keys[ i ] ];
            if ( _current.dom_element === dom_element ) {
                _current.askComputeAfterChange( dom_element, parent_prop_object );
                return;
            }
        }
    },
    delete                          : function () {
        this.resetCounters();
        DOM.Service.removeElement( this.dom_element );
    },
    getSelectorViaChildrenDomElement: function ( dom_element ) {
        var _selector = DOM.Service.findParentElementWithClass( dom_element, "shinken-select-container", 30 );
        if ( !_selector ) {
            return null;
        }
        var _keys = Object.keys( this.selectors );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.selectors[ _keys[ i ] ];
            if ( _keys[ i ] === _selector.dataset.name ) {
                return _current;
            }
        }
        return null;
    },
    getListElement                  : function ( event ) {
        return this.getSelectorViaChildrenDomElement( event.target ).getListElement();
    },
    getParentName                   : function () {
        return this.parent_name;
    },
    getValue                        : function () {
    },
    getCfgValue                     : function () {
    },
    setValueFromUser                : function ( value ) {
        console.warn( "", "[note implemented for ]", this.constructor );
    },
    addInput                        : function ( _current_key ) {
        this.inputs[ _current_key ] = new COMPONENT.Input( this.dom_element.querySelector( "." + _current_key + " .shinken-input" ), this );
    },
    computeErrorsSpecifics          : function ( property_state ) {
        var _keys = Object.keys( this.inputs );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.inputs[ _keys[ i ] ];
            switch ( property_state ) {
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                    _current.hideCountersForParent();
                    break;
                default:
                    _current.showCountersForParent();
            }
        }
    },
    updateCfgDomElement             : function () {
        if ( !this.dom_element_cfg_file ) {
            return;
        }
        this.dom_element_cfg_file.innerHTML = this.getCfgValue().trim() || "&nbsp;";
    },
    hidePopup                       : function () {
        var _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.selectors[ _keys[ i ] ].hidePopup();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLine, SHINKEN.OBJECT.CounterInterface );
COMPONENT.getInterfaceLinePrototype = function ( object, name_constructor ) {
    var _current;
    var _keys = Object.keys( COMPONENT.InterfaceLine.prototype );
    for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
        _current = _keys[ i ];
        if ( !object.prototype[ _current ] ) {
            object.prototype[ _current ] = COMPONENT.InterfaceLine.prototype[ _current ];
        }
    }
    
    object.prototype.constructor = name_constructor;
};
PROPERTY.InterfaceSelect           = function ( dom_element ) {
};
PROPERTY.InterfaceSelect.prototype = {
    initMainSelector: function () {
        this.selectors[ PROPERTY.CONST.SELECTOR.MAIN ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.SELECTOR.MAIN + '"]' ), this.type, this.is_override, this );
    },
    
    ___unset                  : function () {
        this.setValueFromUser( '', '' );
        if ( this.is_mass_change && this.type === PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    this.component_input.setPlaceholder();
                    break;
                default:
                    this.component_input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                    break;
            }
        }
    },
    getSelector               : function () {
        return this.selectors[ PROPERTY.CONST.SELECTOR.MAIN ];
    },
    setLastListElementSelected: function ( to_set ) {
        this.setLastItemSelected( to_set );
        this.link_id = '';
        if ( this.last_list_element_selected ) {
            var _selected_element = this.getSelector().list_element.getListSelectElement( this.last_list_element_selected ).getElement();
            
            if ( _selected_element.uuid ) {
                this.link_id = _selected_element.uuid;
                this.link_id += _selected_element.state === COMPONENT.CONST.TAG.STATE.NEW ? "?new=1" : '';
            }
        }
        DOM.Service.setDataSet( this.dom_element, 'linkId', this.link_id );
    },
    askComputeAfterChange     : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        switch ( dom_element.name ) {
            case 'multi-search':
                this.getSelectViaDomElement( dom_element ).askComputeAfterChange( dom_element );
                break;
        }
    },
    ___hidePopup              : function ( exception ) {
        if ( exception !== this.getSelector() ) {
            this.getSelector().hidePopup();
        }
    },
    ___clickOnItemSelector    : function ( _target_component, key_name ) {
        if ( _target_component !== this.getSelector() ) {
            return;
        }
        this.setLastListElementSelected( key_name );
        this.getSelector().clickOnItemSelector( this.name, key_name );
        switch ( key_name ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                if ( this.component_input ) {
                    this.component_input.updateView( this.state_inheritance );
                }
                break;
            default:
                this.setStateInheritance( false );
                if ( this.component_input ) {
                    this.component_input.updateView( false );
                }
        }
        this.getSelector().buildLinkOpenNewTab( this.item_type, this.link_id );
        this.updateView();
        return true;
    },
    clickOnBtnInheritance     : function () {
        this.setStateInheritance( !this.state_inheritance );
        if ( this.state_inheritance ) {
            this.setLastListElementSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
        }
        else {
            if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE &&
                 (!this.getSelector().last_selected_key_name || this.getSelector().last_selected_key_name === PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ) ) {
                this.getSelector().clickOnItemSelector( this.name, PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
            this.setLastListElementSelected( this.getSelector().getLastSelectedElementName() );
        }
        this._computeState();
        if ( this.component_input ) {
            this.component_input.updateView( this.state_inheritance );
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    ___updateView             : function () {
        this._computeState();
    },
    _computeLabelSelect       : function () {
        if ( this.is_disabled ) {
            return;
        }
        var _title_to_set;
        var _element_list;
        var _selected_element;
        var _add_class_inheritance_flag = false;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                _element_list                           = this.getSelector().list_element.getElement( this.last_list_element_selected );
                _title_to_set                           = this._computeInheritedLabelHtml( this.component_btn_inheritance.list_template_property[ 0 ].template_name, this.component_btn_inheritance.list_template_property[ 0 ].label );
                this.getSelector().dom_select.className = "shinken-select-selector";
                _add_class_inheritance_flag             = true;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                _element_list                           = this.getSelector().list_element.getElement( this.last_list_element_selected );
                _title_to_set                           = _element_list.getLabel();
                this.getSelector().dom_select.className = "shinken-select-selector";
                _add_class_inheritance_flag             = true;
                break;
            default:
                _selected_element = this.getSelector().getLastSelectedElement();
                if ( _selected_element ) {
                    _title_to_set                           = DOM.Service.getInnerText( _selected_element.dom_element );
                    this.getSelector().dom_select.className = "shinken-select-selector" + _selected_element.element.getClass();
                }
        }
        if ( _add_class_inheritance_flag ) {
            _title_to_set = '<span class="shinken-multiselect-title">' + _title_to_set + '</span>';
        }
        this.getSelector().setTitle( _title_to_set );
        this.checkErrorWarning();
    },
    computeErrorsSpecifics    : function ( force_mass_change ) {
        this.counter_temp_error += this.getSelector().getErrors( this.state, this.name );
        this.counter_temp_warning += this.getSelector().getWarnings( this.state, this.name );
        if ( !this.is_mass_change ) {
            return;
        }
        if ( !force_mass_change ) {
            var _keys = Object.keys( this.selectors );
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                this.selectors[ _keys[ i ] ].setMessage();
            }
            if ( this.is_synchro ) {
                this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].setMessage( SHINKEN.TOOLS.STRING.format( _( "mass-change.step-3.prop_synchro" ),
                    "<span class='shinken-highlight-data-user'>" + _( MANAGER.__instance_element_distributor.current_element.type + "." + this.synchro_name ) + "</span>" ) );
                return;
            }
            return;
        }
        var _need_main_element   = false;
        var _need_extra_action   = false;
        var _need_extra_element  = false;
        var _need_single_element = false;
        var _action              = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                return;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.MOVE:
                if ( !this.is_ordered ) {
                    break;
                }
                if ( this.getValue() ) {
                    _need_extra_action = true;
                    var _extra_action  = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ].getValue();
                    switch ( _extra_action ) {
                        case PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.AFTER:
                        case PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.BEFORE:
                            _need_extra_element = true;
                            break;
                    }
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                    _need_extra_element = true;
                }
                if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                    _need_single_element = true;
                }
                break;
        }
        if ( _need_main_element && !this.getValue() ) {
            var _validator = new OBJECT.Messages();
            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'mass-change.form.tooltip_required' ) );
            this.getSelector().setMessage( _validator );
        }
        if ( _need_extra_action && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ].getValue() === PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.NONE ) {
            var _validator = new OBJECT.Messages();
            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'mass-change.form.tooltip_required' ) );
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ].setMessage( _validator );
        }
        if ( _need_extra_element && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
            var _validator = new OBJECT.Messages();
            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'mass-change.form.tooltip_required' ) );
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].setMessage( _validator );
        }
        if ( _need_single_element && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue() === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
            var _validator = new OBJECT.Messages();
            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'mass-change.form.tooltip_required' ) );
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].setMessage( _validator );
        }
    },
    keydown                   : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.getSelectViaDomElement( event.target ).moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.getSelectViaDomElement( event.target ).moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                var _is_auto_select_done = this.getSelectViaDomElement( event.target ).validAutoSelect();
                if ( !_is_auto_select_done && this.getSelectViaDomElement( event.target ) === this.getSelector() && this.name === PROPERTY.CONST.NAME.USE ) {
                    event.stopPropagation();
                    this.addTagWithFilterName();
                }
                event.preventDefault();
                break;
        }
    },
    _computeInheritedLabel    : function ( inherited_value ) {
        var _to_return = inherited_value;
        if ( this.getName() === PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ) {
            _to_return = _( 'element.' + inherited_value );
        }
        return _to_return;
    },
    updateWithTemplateSpecific: function () {
        this.updateView();
    }
};
PROPERTY.Interface = function () {
};
PROPERTY.Interface.prototype = {
    initDomElement         : function ( element ) {
        this.name             = element.dataset.name;
        this.type             = element.dataset.type;
        this.default_value    = element.dataset.defaultValue;
        this.selectors        = {};
        this.dom_element      = element;
        this.default_label    = element.dataset.defaultLabel;
        this.none_label       = element.dataset.noneLabel;
        this.item_type        = element.dataset.itemType;
        this.link_id          = element.dataset.linkId;
        this.unit             = element.dataset.unit;
        this.custom_selected  = element.dataset.customSelected;
        this.is_not_heritable = element.dataset.isPropNotHeritable;
        this.is_synchro       = !!element.dataset.isSynchro;
        if ( this.is_synchro ) {
            this.synchro_name      = element.dataset.synchroName;
            this.synchronized_name = element.dataset.synchronizedName;
        }
        this.hide_import_key = parseInt( element.dataset.hideImportKey );
        this.state_plus      = parseInt( element.dataset.statePlus );
        this.has_plus        = this.state_plus !== COMPONENT.CONST.BTN_STATE.DISABLED;
        this.is_ordered      = !!parseInt( this.dom_element.dataset.isOrdered );
        this.is_disabled     = element.classList.contains( 'shinken-disabled' );
        this.computeTabId();
        this.initCounters();
        this.setOverride( element.dataset.override );
        this.setMassChange( element.dataset.isMassChange );
        
        this.setIsRequired( element.dataset.isRequired );
        this.tag_information = new COMPONENT.TagInformation( element.querySelector( ".shinken-prop-cell-label .shinken-information-tag" ) );
        this._finalyseErrorWarning();
    },
    _initWithCustomSelect  : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.setStateInheritance( false );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                        this.setStateInheritance( true );
                        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                        this.setStateInheritance( true );
                        this.changeNoOverrideButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.setStateInheritance( false );
                        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                switch ( this.last_list_element_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                        if ( !this.component_btn_inheritance.isSet() ) {
                            this.setStateInheritance( false );
                            this.state_inheritance = false;
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT );
                        }
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                        if ( !this.component_btn_inheritance.isSet() ) {
                            this.setStateInheritance( false );
                            this.state_inheritance = false;
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
                        }
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        if ( this.component_btn_inheritance.isSet() ) {
                            this.setStateInheritance( true );
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
                        }
                        break;
                }
                
                if ( this.last_list_element_selected ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                        this.setLastItemSelected( this.component_btn_inheritance.isSet() ? PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT );
                        if ( this.is_override ) {
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE );
                        }
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                        this.setLastItemSelected( this.custom_selected );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                        this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                        this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE );
                        break;
                    
                    default:
                        var _last_element_selected = this.getSelector().list_element.getFirstSelectedElement();
                        if ( !_last_element_selected ) {
                            return;
                        }
                        this.setLastItemSelected( _last_element_selected.element.name );
                        this.getSelector().last_selected_key_name = this.last_list_element_selected;
                }
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.setStateInheritance( false );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                        this.setStateInheritance( true );
                        break;
                }
                break;
        }
    },
    _finalyseErrorWarning  : function () {
        if ( this.type === PROPERTY.CONST.TYPES.DATA && !this.is_override && !this.is_mass_change ) {
            this.setParentCounter( this.group_data );
        }
        else {
            this.setParentCounter( this.getWindow() );
        }
    },
    askCheckErrorWarning   : function () {
        if ( this.ask_check_error_warning ) {
            clearTimeout( this.ask_check_error_warning );
        }
        var self                     = this;
        this.ask_check_error_warning = setTimeout( function () {
            self.checkErrorWarning();
            self.ask_check_error_warning = null;
        }, 500 );
    },
    checkErrorWarning      : function ( force_mass_change ) {
        this.computeErrors( force_mass_change );
        this.setErrors();
    },
    computeErrors          : function ( force_mass_change ) {
        this.counter_temp_error   = 0;
        this.counter_temp_warning = 0;
        this.computeErrorsSpecifics( force_mass_change );
    },
    setErrors              : function () {
        this.setErrorsSpecific();
        var _key = this.uuid ? this.uuid : this.name;
        this.setError( _key, this.counter_temp_error );
        this.setWarning( _key, this.counter_temp_warning );
        this.getCounterError().setTooltip( this.counter_error_tooltip, SHINKEN_TOOLTIP.TYPE.ERROR_BORDER );
        this.getCounterWarning().setTooltip( this.counter_warning_tooltip, SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
    },
    computeErrorsSpecifics : function () {
    },
    setErrorsSpecific      : function () {
    },
    clickOnBtnInheritance  : function () {
        this.setStateInheritance( !this.state_inheritance );
        this._computeState();
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.DATA:
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.component_input.updateView( this.state_inheritance, true, this.component_btn_inheritance.isSet() );
                break;
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    specificTreatment      : function () {
    },
    onFocus                : function () {
    },
    onFocusOut             : function ( dom_element ) {
        this.___onFocusOut( dom_element );
    },
    clickOnSelector        : function ( event ) {
        event.stopPropagation();
        if ( this.is_disabled ) {
            return false;
        }
        var _target_component = this.getSelectViaDomElement( event.target );
        _target_component.clickOnSelector( event.target );
        this.hidePopup( _target_component );
    },
    clickOnItemSelector    : function ( key_name, dom_element, target_component ) {
        if ( this.is_disabled ) {
            return false;
        }
        if ( !target_component ) {
            target_component = this.getSelectViaDomElement( dom_element );
        }
        if ( target_component.__class === SHINKEN.TOOLS.CLASS.CONST.COMPONENT.SELECT && target_component !== this.getSelector() ) {
            target_component.clickOnItemSelector( this.name, key_name );
        }
        this.clickOnItemSelector_end( target_component, key_name, dom_element );
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    clickOnItemSelector_end: function ( target_component, key_name, dom_element ) {
        if ( this.is_mass_change ) {
            MANAGER.ListenerEventManager.clickOnItemSelectorMassChange( this, target_component, key_name, dom_element );
        }
        if ( target_component.__class === SHINKEN.TOOLS.CLASS.CONST.COMPONENT.SELECT && target_component !== this.getSelector() ) {
            target_component.computeTitle( true );
            this.updateView();
            return;
        }
        this.___clickOnItemSelector( target_component, key_name, dom_element );
    },
    clickOnInput           : function () {
        this.hidePopup();
    },
    clickOnCheckboxInput   : function ( name ) {
        this.___clickOnCheckboxInput( name );
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    clickOnRadioBtn        : function ( dom_element, value ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( typeof value === "undefined" ) {
            value = dom_element.value;
        }
        this.___clickOnRadioBtn( value );
        fire_element_is_modifie();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    keydown                : function ( event, key_code ) {
    },
    updateWithTemplate     : function ( templates, is_update ) {
        if ( is_update ) {
            this.cleanBeforeUpdate();
        }
        if ( this.is_not_heritable || !templates ) {
            this._initWithCustomSelect();
            this._computeState();
            this.updateView();
            return;
        }
        var _template_properties = templates.getProperties( this.name );
        this.updateAllTemplatesCustomTags( _template_properties );
        var _has_template = this.component_btn_inheritance.setTemplateProperty( _template_properties );
        var _label;
        var _template;
        var _inherited_label;
        if ( _has_template ) {
            switch ( this.type ) {
                case PROPERTY.CONST.TYPES.MULTI_SELECT:
                    _template            = _template_properties[ 0 ];
                    this.inherited_value = _template.value;
                    switch ( this.inherited_value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _template.label  = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE ).getLabel();
                            _inherited_label = this._computeInheritedLabelHtml( _template.template_name, _template.label );
                            this.getSelector().list_element.getListSelectElement( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ).updateHtmlLabel( _inherited_label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.BOOLEAN:
                    this.inherited_value            = _template_properties[ 0 ].value;
                    this.inherited_value            = this._computeInheritedLabel( this.inherited_value );
                    _template_properties[ 0 ].label = this.inherited_value;
                    this.component_radio_list.getRadioButton( PROPERTY.CONST.DEFAULT_BUTTON_LABEL ).setInheritedLabel( this.inherited_value );
                    break;
                
                case PROPERTY.CONST.TYPES.RANGE:
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                    this.inherited_value = _template_properties[ 0 ].value;
                    switch ( this.inherited_value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            this.inherited_value = this.default_value;
                    }
                    _label = this._computeInheritedLabel( this.inherited_value );
                    this.component_btn_default.setInheritedLabel( _label );
                    
                    _template_properties[ 0 ].label = _label;
                    if ( this.type === PROPERTY.CONST.TYPES.RANGE_WITH_INPUT ) {
                        this.component_input_range.component_input.setPlaceholder( _label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                    this.inherited_value = _template_properties[ 0 ].value;
                    _label               = this._computeInheritedLabel( this.inherited_value );
                    this.component_btn_default.setInheritedLabel( _label );
                    _template_properties[ 0 ].label = _label;
                    this.component_checkbox.setCheckedInheritance( this.inherited_value );
                    break;
                case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                    this.inherited_value = _template_properties[ 0 ].value;
                    this.component_btn_default.setInheritedLabel( this.inherited_value );
                    _template_properties[ 0 ].label = this.inherited_value;
                    this.computeInheritanceCheckbox();
                    break;
                
                case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                    _template            = _template_properties[ 0 ];
                    this.inherited_value = _template.value;
                    _template.label      = this._computeInheritedLabel( this.inherited_value );
                    switch ( _template.value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _template.label = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE ).getLabel();
                            break;
                    }
                    if ( this.inherited_value ) {
                        _inherited_label = this._computeInheritedLabelHtml( _template.template_name, _template.label, "--" );
                        this.getSelector().list_element.getListSelectElement( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ).updateHtmlLabel( _inherited_label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                    _template               = _template_properties[ 0 ];
                    this.inherited_value    = _template.value;
                    var _elements_command   = this.inherited_value.split( '!' );
                    this.inherited_cmd_name = _elements_command[ 0 ];
                    this.inherited_cmd_args = _elements_command.splice( 1 ).join( '!' );
                    
                    _template.label = this._computeInheritedLabel( this.inherited_value );
                    switch ( _template.value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _template.label = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE ).getLabel();
                            break;
                    }
                    if ( this.is_override ) {
                        _label = this.inherited_cmd_args + ' [ ' + _( 'element.in_template' ) + ' ' + _template.template_name + ' ]';
                        this.component_input.setPlaceholder( _label );
                    }
                    else if ( this.inherited_value ) {
                        _inherited_label = this._computeInheritedLabelHtml( _template.template_name, _template.label );
                        this.getSelector().list_element.getListSelectElement( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ).updateHtmlLabel( _inherited_label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.STRING_INPUT:
                case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                    _template = _template_properties[ 0 ];
                    if ( this.is_protected ) {
                        _label                          = PROPERTY.CONST.DATA.PROTECTED_PLACEHOLDER;
                        _template_properties[ 0 ].value = SHINKEN.TOOLS.ENCRYPTION.getDefaultLabel();
                    }
                    else {
                        if ( _template.value === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                            _label = _( 'element.forced_default' );
                            if ( this.default_value ) {
                                _label += " " + this.default_value;
                            }
                        }
                        else {
                            _label = _template.value;
                        }
                        _label += ' [' + _( 'element.in_template' ) + ' ' + _template.template_name + ']';
                    }
                    this.component_input.setPlaceholder( _label );
                    break;
                case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                    _template = _template_properties[ 0 ];
                    this._updateCfgInheritedLabel( _template.value );
                    break;
            }
        }
        else {
            switch ( this.type ) {
                case PROPERTY.CONST.TYPES.RANGE:
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                    this.inherited_value = this.default_value;
                    if ( this.state_inheritance ) {
                        this.component_input_range.setValue( this.inherited_value );
                    }
                    break;
            }
        }
        this._computeBtnInheritance();
        this.component_btn_inheritance.askUpdateHTML();
        this._initWithCustomSelect();
        this.updateWithTemplateSpecific();
    },
    cleanBeforeUpdate      : function () {
    },
    
    updateWithTemplateSpecific  : function () {
    },
    updateAllTemplatesCustomTags: function ( _template_properties ) {
    },
    setStateInheritance         : function ( to_set ) {
        this.state_inheritance = to_set;
        this.component_btn_inheritance.setState( this.state_inheritance ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.OFF );
        this.setStateInheritanceSpecific();
    },
    setStateInheritanceSpecific : function () {
    },
    getName                     : function () {
        return this.name;
    },
    getLabelViaDom              : function () {
        return this.dom_element.querySelector( '.shinken-property-label .shinken-label' ).innerText;
    },
    getNameOrUUID               : function () {
        return this.getName();
    },
    getParentName               : function () {
        return this.name;
    },
    getState                    : function () {
        return this.state;
    },
    setInheritanceStatus        : function ( to_set, message ) {
        DOM.Service.setDataSet( this.dom_element, 'inheritanceStatus', to_set );
        this.setInheritanceStatusTooltip( to_set, message );
    },
    setInheritanceStatusTooltip : function ( status, to_set ) {
        var _element = this.dom_element.querySelector( '.shinken-status-tag[data-status="' + status + '"]' );
        if ( _element ) {
            _element.setAttribute( 'shi-tip-html', to_set );
        }
    },
    setMassChange               : function ( _to_set ) {
        this.is_mass_change = !!_to_set;
        if ( this.is_mass_change ) {
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangeActionState" );
            if ( this.type === PROPERTY.CONST.TYPES.MULTI_SELECT ) {
                if ( this.is_ordered ) {
                    this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangeActionExtraState" );
                }
                this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ]  = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangeActionExtraElement" );
                this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangeActionSingleElement" );
                if ( this.has_plus ) {
                    this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangePlusActionState" );
                }
            }
        }
    },
    setOverride                 : function ( _to_set ) {
        this.is_override = !!_to_set;
        if ( !_to_set ) {
            return;
        }
        this.override_prop_name        = this.dom_element.dataset.overridePropName;
        this.override_check_uuid       = this.dom_element.dataset.overrideElementUuid;
        this.override_check_name       = this.dom_element.dataset.overrideElementName;
        this.override_dfe_name         = this.dom_element.dataset.overrideDfeName;
        var _parents                   = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-override-check-content', 20 );
        this.override_check_uuid_final = _parents.dataset.domUuid;
        
        var help_title   = this.override_prop_name;
        var prop_is_data = SHINKEN.TOOLS.STRING.startsWith( this.override_prop_name, '_' );
        if ( !prop_is_data ) {
            help_title = _( 'help-services.' + this.override_prop_name + "-title" );
        }
        MANAGER.HelpManager.setTitle( this.name, help_title + ' (override)' );
        if ( this.is_disabled ) {
            if ( this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
                MANAGER.HelpManager.setContent( this.name, 'help-services.check_command-content-override' );
            }
            else {
                MANAGER.HelpManager.setContent( this.name, 'element.help_lock_property' );
            }
        }
        else {
            if ( prop_is_data ) {
                MANAGER.HelpManager.setContent( this.name, 'element.help_text_data' );
            }
            else {
                
                MANAGER.HelpManager.setContent( this.name, 'help-services.' + this.override_prop_name + "-content" );
            }
        }
        var _import_key_html = DOM.Service.createElement( 'div', {}, _( 'element.import_key' ) + ' : service_overrides' );
        if ( !this.is_disabled ) {
            var _example_html_title = DOM.Service.createElement( 'div', { class: 'shinken-example' }, _( 'common.example' ) );
            var _example_html       = DOM.Service.createElement( 'div', { class: 'shinken-example' }, 'service_overrides <span class="shinken-data-user">' + _( 'common.check_name' ) + '</span>,' + this.override_prop_name + '&nbsp;<span class="shinken-data-user">' + _( 'common.override_value' ) + '</span>' );
            DOM.Service.addElementTo( _example_html_title, _import_key_html );
            DOM.Service.addElementTo( _example_html, _import_key_html );
        }
        MANAGER.HelpManager.setImportKey( this.name, _import_key_html.innerHTML );
    },
    setState                    : function ( _to_set ) {
        this.state = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'state', this.state );
        this.computeStateInheritance();
        DOM.Service.setDataSet( this.dom_element, 'stateInheritance', this.component_btn_inheritance.getState() );
        if ( this.has_plus ) {
            DOM.Service.setDataSet( this.dom_element, 'statePlus', this.state_plus );
        }
        if ( !this.is_mass_change ) {
            switch ( this.state ) {
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    this.setUserSet( this.name, 0 );
                    break;
                default:
                    this.setUserSet( this.name, 1 );
                    break;
            }
        }
        fire_element_is_modifie();
    },
    computeStateInheritance     : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                this.setStateInheritance( true );
                break;
            default:
                this.setStateInheritance( false );
                break;
        }
    },
    setLastItemSelected         : function ( _to_set ) {
        this.last_list_element_selected = _to_set;
    },
    getValueInherited           : function () {
        console.warn( "getValueInherited", "[Not managed for type]", this.type );
    },
    getValueFinalOverride       : function () {
        if ( !this.is_override ) {
            return "";
        }
        var _to_return = this.getValue();
        if ( !_to_return ) {
            _to_return = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.override_check_uuid )[ this.override_prop_name ];
        }
        return _to_return;
    },
    getFlatValue                : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.component_btn_inheritance.isSet() ? this.getValueInherited() : this.default_value;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return this.default_value;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                if ( this.getValueInherited() ) {
                    return this.getValue() + "," + this.getValueInherited();
                }
                else {
                    return this.getValue();
                }
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET_MASS_CHANGE_PLUS_ONLY:
                return this.getValue();
        }
    },
    getValue                    : function () {
        var _to_return = "";
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                _to_return = this.component_input.getValue();
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                _to_return = this.getDataToSaveFinal();
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                _to_return = this.getSelector().getValue();
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
                    _to_return = '';
                }
                else if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ) {
                    _to_return = PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                }
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET_MASS_CHANGE_PLUS_ONLY:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                        _to_return = PROPERTY.CONST.STATE_VALUE_PLUS.ON + _to_return;
                }
                break;
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    case PROPERTY.CONST.STATE_PROPERTY.NO_OVERRIDE:
                        return '';
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                        return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                    default:
                        return this.component_input_range.getValue();
                }
            case PROPERTY.CONST.TYPES.BOOLEAN:
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    case PROPERTY.CONST.STATE_PROPERTY.NO_OVERRIDE:
                        return '';
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                        return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                    default:
                        return this.component_radio_list.getValue();
                }
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                _to_return = this.getSelector().getValue();
                if ( _to_return === "" ) {
                    return '';
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
                    return '';
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    return _to_return;
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE ) {
                    return _to_return;
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ) {
                    return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                }
                
                _to_return += '!' + this.component_input.getValue();
                
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                _to_return = this.value;
                break;
        }
        return _to_return;
    },
    setValue                    : function ( _to_set ) {
        this.value = _to_set;
    },
    isSet                       : function () {
        var _to_return = this.getValue();
        return !!_to_return;
    },
    isStateOverride             : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return true;
        }
        return false;
    },
    setIsDisable                : function ( to_set ) {
        if ( to_set && !this.is_disabled ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        else if ( !to_set && this.is_disabled ) {
            this.dom_element.classList.remove( 'shinken-disabled' );
        }
        this.is_disabled = to_set;
    },
    computeTabId                : function () {
        var _tab_parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, this.is_override ? 'shinken-prop-table' : 'property-tab-pane', 50 );
        if ( _tab_parent_dom_element ) {
            this.tab_parent_id   = _tab_parent_dom_element.id;
            this.tab_parent_name = _tab_parent_dom_element.dataset.name;
        }
    },
    setIsRequired               : function ( to_set ) {
        this.is_required = to_set;
        if ( this.is_required && this.tab_parent_id ) {
            this.getWindow().setHasRequired( true );
        }
    },
    unset                       : function () {
        if ( this.is_mass_change ) {
            var _keys = Object.keys( this.selectors );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                switch ( _current_key ) {
                    case PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA:
                    case PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE:
                        this.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE, null, this.selectors[ _current_key ] );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS:
                        this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE, null, this.selectors[ _current_key ] );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA:
                        this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.NONE, null, this.selectors[ _current_key ] );
                        break;
                }
            }
        }
        this.___unset();
    },
    setValueFromUser            : function () {
        console.warn( "setValueFromUser", "[TYPE NOT MANAGED]", this.type );
    },
    getSelectViaDomElement      : function ( dom_element ) {
        var _dom_target = DOM.Service.findParentElementWithClass( dom_element, "shinken-select-container", 20 );
        return this.selectors[ _dom_target.dataset.name ];
    },
    getWindow                   : function () {
        if ( this.is_override ) {
            return MANAGER.__instance_window_distributor.findWindow( this.tab_parent_name, false, this.override_check_uuid_final );
        }
        return MANAGER.__instance_window_distributor.findWindow( this.tab_parent_name, false, MANAGER.__instance_element_distributor.current_element.uuid );
    },
    isDifferentValue            : function ( value1, value2 ) {
        return value1 !== value2 && SHINKEN.TOOLS.STRING.unescape_xss( value1 ) !== SHINKEN.TOOLS.STRING.unescape_xss( value2 );
    },
    _computeBtnInheritance      : function () {
    
    },
    _computeState               : function () {
    
    },
    _computeValueForSynchronize : function () {
        var _to_return;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                var _state_default = this.component_btn_default.getState();
                _to_return         = this.component_input_range.getValue();
                if ( _state_default ) {
                    _to_return = this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON ? this.inherited_value : this.component_btn_default.getValue();
                }
                break;
        }
        return _to_return;
    },
    _computeInheritedLabelHtml  : function ( template_name, inherited_value, separator ) {
        if ( !separator ) {
            separator = "";
        }
        return "<span class='shinken-space'>" + separator + " " + SHINKEN.TOOLS.STRING.cleanXss( inherited_value ) + "   " + "<span class='shinken-between-bracket'>" + _( 'element.in_template' ) + " " + template_name + "</span> " + separator + "</span>";
    },
    _computeLabelSelect         : function () {
        if ( this.is_disabled ) {
            return;
        }
        var _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.selectors[ _keys[ i ] ].computeTitle();
        }
    },
    hidePopup                   : function ( exception ) {
        var _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.selectors[ _keys[ i ] ] !== exception ) {
                this.selectors[ _keys[ i ] ].hidePopup();
            }
        }
        this.___hidePopup( exception );
    },
    updateView                  : function () {
        var _keys = Object.keys( this.selectors );
        var _current_dataset;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_dataset = this.selectors[ _keys[ i ] ].getDataSetLink();
            if ( _current_dataset ) {
                DOM.Service.setDataSet( this.dom_element, _current_dataset, this.selectors[ _keys[ i ] ].getValue() );
            }
        }
        this.___updateView();
    },
    remove                      : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
        }
        MANAGER.__instance_property_distributor.removeElement( this.name );
    },
    setParentCounter            : function ( to_set ) {
        if ( to_set ) {
            switch ( this.type ) {
                case PROPERTY.CONST.TYPES.DATA:
                    this.getCounterUserSet().setParent( to_set.getCounterUserSet() );
                    this.getCounterTotal().setParent( to_set.getCounterTotal() );
                    this.getCounterError().setParent( to_set.getCounterError() );
                    this.getCounterWarning().setParent( to_set.getCounterWarning() );
                    break;
                default:
                    if ( this.is_override || this.is_mass_change ) {
                        this.getCounterUserSet().setParent( to_set.getCounterUserSet() );
                    }
                    this.getCounterError().setParent( to_set.getCounterError() );
                    this.getCounterWarning().setParent( to_set.getCounterWarning() );
                    break;
            }
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
            this.getCounterUserSet().setParent();
            this.getCounterTotal().setParent();
        }
    },
    isFlatValueOn               : function () {
    },
    getDataToSave               : function () {
        if ( this.is_mass_change ) {
            return this.getDataToSaveMassChange();
        }
        if ( this.state_inheritance && !this.state_plus ) {
            return "";
        }
        return this.getDataToSaveFinal();
    },
    getDataToSaveMassChange     : function () {
        var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE_SYNCHRO:
                _action = PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_SYNCHRO:
                _action = PROPERTY.CONST.MASS_CHANGE.ACTION.ADD;
                break;
        }
        var _has_target     = false;
        var _need_value     = true;
        var _manage_plus    = true;
        var _to_return      = {};
        _to_return.action   = _action;
        _to_return.category = this.tab_parent_name;
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                return '';
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.MOVE:
                if ( this.is_ordered ) {
                    var _action_extra       = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ].getLastSelectedElement().element.name;
                    _to_return.extra_action = _action_extra;
                    switch ( _action_extra ) {
                        case PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.AFTER:
                        case PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.BEFORE:
                            _has_target = true;
                            break;
                    }
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                switch ( this.type ) {
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        _need_value = false;
                        if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                            _to_return.target = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValueToSave();
                            _to_return.value  = { 'links': [this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValueToSave()] };
                        }
                        else {
                            _to_return.value = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
                        }
                        break;
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                if ( this.type === PROPERTY.CONST.TYPES.DATA ) {
                    _need_value       = false;
                    _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY;
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_IS_SET_ON_ITEM_OVERRIDE:
                _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_IS_SET_ON_ITEM;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_EXISTS_ON_ITEM_OVERRIDE:
                _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_EXISTS_ON_ITEM;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY_DATA_OVERRIDE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY_DATA:
                _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY;
                _need_value       = false;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_OR_CREATE:
                switch ( this.type ) {
                    case PROPERTY.CONST.TYPES.DATA:
                        _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.SET;
                        break;
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.SET;
                _to_return.value  = PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                _need_value       = false;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_CONSISTENCY:
                _need_value = false;
                break;
        }
        if ( _need_value ) {
            var _value_set = false;
            switch ( this.last_list_element_selected ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    _to_return.value = this.last_list_element_selected;
                    _value_set       = true;
                    _manage_plus     = false;
                    break;
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                    _to_return.value = PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                    _value_set       = true;
                    _manage_plus     = false;
                    break;
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                    _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY;
                    _value_set        = true;
                    break;
            }
            if ( !_value_set ) {
                _to_return.value = this.getDataToSaveFinal();
            }
        }
        if ( _has_target ) {
            _to_return.target = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValueToSave();
        }
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.MOVE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_OR_CREATE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_IS_SET_ON_ITEM:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_IS_SET_ON_ITEM_OVERRIDE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_EXISTS_ON_ITEM:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_EXISTS_ON_ITEM_OVERRIDE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                if ( _to_return.value === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                    _to_return = "";
                }
                break;
        }
        if ( this.has_plus && _manage_plus ) {
            var _value_plus = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue();
            switch ( _value_plus ) {
                case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON:
                case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.OFF:
                    if ( !_to_return.value || _to_return.value === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                        _to_return          = {};
                        _to_return.action   = PROPERTY.CONST.MASS_CHANGE.ACTION.SET;
                        _to_return.value    = {};
                        _to_return.category = this.tab_parent_name;
                    }
                    _to_return.value.has_plus = _value_plus === PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON;
                    break;
            }
        }
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.DATA:
                if ( _to_return && this.is_protected ) {
                    _to_return.is_protected = true;
                }
        }
        if ( _to_return ) {
            _to_return.index = this.indexOfDisplay;
        }
        return _to_return;
    },
    synchronize                 : function ( property, switch_type ) {
        switch ( this.getName() ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                if ( this.is_mass_change ) {
                    return this.synchronizeAtMaximumMassChange( property );
                }
                if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
                    return PROPERTY.UserRightsBehaviour.askSynchronization( property );
                }
        }
        switch_type ? this.synchronizeAtMinimum( property ) : this.synchronizeAtMaximum( property );
    },
    synchronizeAtMinimum        : function ( property ) {
    },
    synchronizeAtMaximum        : function ( property ) {
    },
    mouseEnter                  : function ( event ) {
        if ( this.is_override ) {
            var _title   = _( 'help-services.' + this.name_flat + "-title" );
            var _content = _( 'help-services.' + this.name_flat + "-content" );
            
            MANAGER.HelpManager.setActive( this.name, _title, _content );
        }
        else {
            MANAGER.HelpManager.setActive( this.name );
        }
        if ( this.is_synchro ) {
            SHINKEN_TOOLTIP.showTooltip( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].dom_element );
        }
        if ( event ) {
            this.mouseEnterInOption( event );
        }
    },
    mouseEnterInOption          : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-option", 10 );
        if ( _parent_dom_element ) {
            var _target_component = this.getSelectViaDomElement( event.target );
            if ( _target_component ) {
                var _list = _target_component.getListElement( event );
                _list.updateLastAutoSelectIndex( _list.list_mapping[ _parent_dom_element.dataset.keyName ], COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOUSE );
            }
        }
    },
    mouseLeave                  : function () {
        MANAGER.HelpManager.askSetInactive( this.name );
        if ( this.is_synchro ) {
            SHINKEN_TOOLTIP.hideTooltip();
        }
    },
    onClick                     : function () {
        if ( !this.dom_element_help_btn ) {
            this.dom_element_help_btn = this.dom_element.querySelector( '.shinken-tag-help' );
        }
        if ( this.dom_element_help_btn.classList.contains( 'shinken-active' ) ) {
            return;
        }
        this.clickOnForcedHelpButton();
    },
    clickOnForcedHelpButton     : function () {
        if ( this.name.length === 1 && this.name.startsWith( '_' ) ) {
            return;
        }
        if ( !this.dom_element_help_btn ) {
            this.dom_element_help_btn = this.dom_element.querySelector( '.shinken-tag-help' );
        }
        MANAGER.HelpManager.setForced( this.name, this.dom_element_help_btn );
    }
};
PROPERTY.BuildSynchroName           = function ( property_target_name, property_synchronized_name ) {
    return property_target_name + "-SYNCHRO-" + property_synchronized_name;
};
PROPERTY.BuildOverrideName          = function ( property_name, property ) {
    return "override-" + property.override_check_uuid_final + '-' + property_name;
};
PROPERTY.BuildOverrideNameFromCheck = function ( property_name, check_host ) {
    if ( property_name === PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS ) {
        property_name = PROPERTY.CONST.NAME.CHECK_COMMAND;
    }
    return "override-" + check_host.getDomUUID() + '-' + property_name;
};
PROPERTY.Abstract = function () {
};
PROPERTY.Abstract.prototype = {
    ___updateView          : function () {
    },
    ___unset               : function () {
    },
    getSelector            : function () {
    },
    ___clickOnItemSelector : function ( _target_component, key_name ) {
    },
    ___clickOnCheckboxInput: function ( name ) {
    },
    ___clickOnRadioBtn     : function ( value ) {
    },
    ___onFocusOut          : function ( dom_element ) {
    },
    ___hidePopup           : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Interface, PROPERTY.Abstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Interface, SHINKEN.OBJECT.CounterInterface );
SOURCE.Sources           = function ( type ) {
    this.type               = type;
    this.timer_auto_refresh = null;
    this.init();
};
SOURCE.Sources.prototype = {
    init                   : function ( data ) {
        this.stopAutoRefresh();
        this.list_source         = [];
        this.list_source_mapping = {};
        
        if ( !data ) {
            return;
        }
        
        var _size = data.length;
        var _current;
        var _name;
        for ( var i = 0; i < _size; i++ ) {
            _current              = data[ i ];
            this.list_source[ i ] = new SOURCE.Source( _current );
            this.list_source[ i ].loadDomElements();
            _name                             = this.list_source[ i ].getName();
            this.list_source_mapping[ _name ] = i;
        }
    },
    sanatizeObject         : function () {
        this.reorderRanking();
    },
    updateData             : function ( data ) {
        var _keys = Object.keys( data );
        var _size = _keys.length;
        var _current_name;
        var _current_source;
        for ( var i = 0; i < _size; i++ ) {
            _current_name   = _keys[ i ];
            _current_source = this.getSource( _keys[ i ] );
            if ( _current_source ) {
                _current_source.updateData( data[ _keys[ i ] ] );
            }
            else {
                SHINKEN.HIGHWAY.refreshCurrentPage();
            }
        }
    },
    resetExisting          : function () {
        for ( var i = 0, _size_i = this.list_source.length; i < _size_i; i++ ) {
            this.list_source[ i ].resetExisting();
        }
    },
    removeNonExistingSource: function () {
        for ( var i = 0, _size_i = this.list_source.length; i < _size_i; i++ ) {
            if ( !this.list_source[ i ].is_existing ) {
                SHINKEN.HIGHWAY.refreshCurrentPage();
            }
        }
    },
    refresh                : function () {
        if ( SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
            return;
        }
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.REFRESH.URL
                     + COMMUNICATION.QUERY.GET.SOURCE.REFRESH.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                self.resetExisting();
                self.updateData( data );
                if ( self.needReorder( false ) ) {
                    MANAGER.__instance_source_distributor.reorderAllSourceDom();
                    self.sendNewOrderToBackend();
                }
                self.removeNonExistingSource();
            },
            error  : function ( data, txt ) {
                console.error( 'Refresh source', 'Got bad result for' + data, txt );
                SHINKEN.COMMUNICATION.handleResponse( data.status );
            }
        } );
    },
    stopAutoRefresh        : function ( data ) {
        if ( this.timer_auto_refresh ) {
            clearInterval( this.timer_auto_refresh );
            this.timer_auto_refresh = null;
        }
        
    },
    startAutoRefresh       : function ( data ) {
        this.stopAutoRefresh();
        var self                = this;
        this.timer_auto_refresh = setInterval( function () {
            self.refresh();
        }, 1000 );
    },
    addAllSource           : function ( sources ) {
        this.list_source = [];
        var _size        = sources.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current                                       = sources[ i ];
            this.list_source[ i ]                          = _current;
            this.list_source_mapping[ _current.getName() ] = i;
        }
    },
    getSource              : function ( name ) {
        return this.getObjectByName( name );
    },
    getObjectByName        : function ( name ) {
        var _index = this.list_source_mapping[ name ];
        if ( _index === undefined ) {
            return null;
        }
        return this.getObjectByIndex( _index );
    },
    getObjectByIndex       : function ( index ) {
        return this.list_source[ index ];
    },
    getSourceByType        : function ( type ) {
        var _to_return = [];
        var _current;
        var _size      = this.list_source.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = this.list_source[ i ];
            if ( _current[ SOURCE.CONST.FIELD.TYPE ] === type ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    reorderRanking         : function () {
        if ( !this.needReorder( true ) ) {
            return;
        }
        
        return this.sendNewOrderToBackend();
    },
    sendNewOrderToBackend  : function () {
        var _size = this.list_source.length;
        var order = '';
        for ( var i = 0; i < _size; i++ ) {
            if ( i ) {
                order += ',';
            }
            order += this.list_source[ i ].getName();
        }
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.SET_ORDER.URL
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ORDER.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ORDER.OPTIONS.ORDER
                     + order,
            success: function ( data ) {
                return true;
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
                return false;
            }
        } );
    },
    changeSourcePosition   : function ( source_1, source_2 ) {
        var _index_1 = this.list_source_mapping[ source_1.getName() ];
        var _index_2 = this.list_source_mapping[ source_2.getName() ];
        
        if ( _index_1 < _index_2 ) {
            for ( var i = _index_1; i < _index_2; i++ ) {
                this.switchSource( this.list_source[ i ], this.list_source[ i + 1 ] );
            }
        }
        else {
            for ( var i = _index_1 - 1; i >= _index_2; i-- ) {
                this.switchSource( this.list_source[ i ], this.list_source[ i + 1 ] );
            }
            
        }
        
    },
    switchSource           : function ( source_1, source_2 ) {
        var _index_dom_element;
        if ( this[ SOURCE.CONST.FIELD.TYPE ] === SOURCE.CONST.TYPES.ALL ) {
            _index_dom_element = 0;
        }
        else {
            _index_dom_element = 1;
        }
        var _index_1 = this.list_source_mapping[ source_1.getName() ];
        var _index_2 = this.list_source_mapping[ source_2.getName() ];
        
        if ( _index_1 > _index_2 ) {
            DOM.Service.insertElementBefore( source_2.getDomElement( _index_dom_element ), source_1.getDomElement( _index_dom_element ) );
        }
        else {
            DOM.Service.insertElementBefore( source_1.getDomElement( _index_dom_element ), source_2.getDomElement( _index_dom_element ) );
        }
        
        SHINKEN.TOOLS.ARRAY.swap( this.list_source, _index_1, _index_2 );
        
        if ( this.type === SOURCE.CONST.TYPES.ALL ) {
            source_1.setOrder( _index_2 + 1 );
            source_2.setOrder( _index_1 + 1 );
        }
        
        this.list_source_mapping[ source_1.getName() ] = _index_2;
        this.list_source_mapping[ source_2.getName() ] = _index_1;
    },
    needReorder            : function ( force_set_order ) {
        var _size = this.list_source.length;
        var _need = false;
        if ( !_size ) {
            return;
        }
        for ( var i = 0; i < _size; i++ ) {
            if ( this.list_source[ i ].getOrder() === i + 1 ) {
                continue;
            }
            if ( force_set_order ) {
                this.list_source[ i ].setOrder( i + 1 );
            }
            _need = true;
        }
        return _need;
    },
    reorderDomElement      : function () {
        var _size = this.list_source.length;
        
        var _sources = [];
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = {
                'order' : this.list_source[ i ].getOrder(),
                'source': this.list_source[ i ]
            };
            _sources.push( _current );
        }
        _sources = SHINKEN.TOOLS.ARRAY.sortArray( _sources, 'order' );
        
        for ( var i = _size; i > 0; i-- ) {
            this.changeSourcePosition( _sources[ i - 1 ][ 'source' ], this.list_source[ 0 ] );
        }
    }
};
SHINKEN.HIGHWAY = (function( self ) {
    "use strict";
    self.goToParentUrl                  = function() {
        var _floors        = location.pathname.split( '/' );
        var _new_path_name = "";
        var _size          = _floors.length;
        for ( var i = 1; i < _size - 1; i++ ) {
            _new_path_name += "/";
            _new_path_name += _floors[ i ];
        }
        switch ( _new_path_name ) {
            case "":
            case "/elements/my_working_area":
            case "/elements/working_area":
            case "/elements":
            case "/analyzers":
            case "/tagger":
            case "/elements/add":
                _new_path_name = "/main";
                break;
            case "/sources":
                _new_path_name = "/main";
                var _params    = this.getParams();
                if ( _params[ 'conf-id' ] || _params[ 'synchronizer-id' ] ) {
                    delete _params[ 'conf-id' ];
                    delete _params[ 'synchronizer-id' ];
                    delete _params[ 'source-name' ];
                    _new_path_name = this.getPathWithoutOrigin() + window.SHINKEN.HIGHWAY.buildParamsToUrl( _params );
                }
                break;
            case "/elements/add/working_area":
                _new_path_name = "/elements/working_area/hosts";
                break;
            case "/sources/server-analyzer/discovery":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
            case "/sources/server-analyzer/discovery/add":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery/add":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
        }
        switch ( location.pathname ) {
            case "/elements/add/cluster":
            case "/elements/add/clustertpl":
            case "/elements/add/hosttpl":
            case "/elements/add/hostgroup":
            case "/elements/add/serviceshost":
            case "/elements/add/serviceshosttpl":
            case "/elements/add/servicescluster":
            case "/elements/add/servicesclustertpl":
            case "/elements/add/servicetpl":
            case "/elements/add/contact":
            case "/elements/add/contacttpl":
            case "/elements/add/contactgroup":
            case "/elements/add/escalation":
            case "/elements/add/notificationway":
            case "/elements/add/command":
            case "/elements/add/businessimpactmodulation":
            case "/elements/add/macromodulation":
            case "/elements/add/resultmodulation":
            case "/elements/add/timeperiod":
                _new_path_name = "/elements/" + _floors[ _size - 1 ] + 's';
                break;
        }
        window.location = location.origin + _new_path_name;
    };
    self.goToElementTab                 = function( tab_name ) {
        var _path     = self.getPath();
        var _params   = self.getParams();
        var _old_name = _params[ 'tab' ];
        if ( _old_name === tab_name ) {
            return;
        }
        _params[ 'tab' ]       = tab_name;
        var _new_params_string = self.buildParamsToUrl( _params );
        self.changeUrl( _path + _new_params_string );
    };
    self.changeUrl                      = function( new_url ) {
        window.history.pushState( "object or string", "Title", new_url );
    };
    self.getPath                        = function() {
        return location.origin + this.getPathWithoutOrigin();
    };
    self.getPathWithoutOrigin           = function() {
        return location.pathname;
    };
    self.getPathWithParamsWithoutOrigin = function() {
        return location.pathname + self.buildParamsToUrl( self.getParams() );
    };
    self.buildParamsToUrl               = function( params ) {
        var _keys = Object.keys( params );
        var _size = _keys.length;
        if ( !_size ) {
            return '';
        }
        var _to_return = COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
        for ( var i = 0; i < _size; i++ ) {
            if ( i ) {
                _to_return += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD;
            }
            _to_return += _keys[ i ] + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + params[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.getParams                      = function( param ) {
        var vars = {};
        window.location.href.replace( location.hash, '' ).replace(
            /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
            function( m, key, value ) { // callback
                vars[ key ] = value !== undefined ? value : '';
            }
        );
        
        if ( param ) {
            return vars[ param ] ? vars[ param ] : null;
        }
        return vars;
    };
    self.is                             = function( type ) {
        switch ( type ) {
            case COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT: //PATCH BUG 4022 TO REMOVE
                return location.pathname === "/elements/elements";
            case COMMUNICATION.PAGE_TYPE.LIST_WORKING_AREA:
                return location.pathname === "/elements/working_area/hosts" || location.pathname === "/elements/my_working_area/hosts";
        }
    };
    self.getListType     = function () {
        var _to_return = self.getPath().split("/");
        return _to_return[_to_return.length - 1];
    };
    self.goTo                           = function( url, event ) {
        if ( event ) {
            event.stopPropagation();
            event.preventDefault();
        }
        if ( event && event.ctrlKey ) {
            window.open( url, '_blank' );
        }
        else {
            window.location = url;
        }
    };
    self.refreshCurrentPage             = function() {
        location.reload();
    };
    self.removeItemIdFromHistory    = function ( item_id ) {
        var histories = App.HistoryManager.histories();
        for ( var i = histories.length - 1; i >= 0; i-- ) {
            var _previousUrl = histories[ i ];
            if ( SHINKEN.TOOLS.STRING.contains( _previousUrl, item_id ) ) {
                histories.splice( i, 1 );
            }
        }
        App.HistoryManager.setHandlers();
    };
    return self;
})( SHINKEN.HIGHWAY || {} );
App.Elements.ChecksTab = (function ( self ) {
    "use strict";
    var __list_host_in_page_host;
    var __container_list_check;
    
    var __ask_init_timeout               = null;
    var __ask_update_override_cfg_format = null;
    
    self.askInit = function ( option ) {
        if ( !MANAGER.__instance_loading.isReady() ) {
            return;
        }
        if ( self.__ask_init_timeout ) {
            clearTimeout( self.__ask_init_timeout );
        }
        self.__ask_init_timeout = setTimeout( function () {
            if ( option && option.data_change ) {
                if ( !__list_host_in_page_host ) {
                    return;
                }
                _updateHtmlAfterDataChange( option.property );
                self.__ask_init_timeout = null;
            }
            else if ( option && option.override_command_change ) {
                if ( !__list_host_in_page_host ) {
                    return;
                }
                _updateHtmlAfterOverrideCommandChange( option.property );
                self.__ask_init_timeout = null;
            }
        }, 500 );
        
    };
    
    self.init = function () {
        if ( !MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            return;
        }
        __container_list_check = document.getElementById( 'id-shinken-check-list' );
        MANAGER.__instance_macro_distributor.recomputeLabelForEachMacro();
        _init2();
    };
    
    function _init2 () {
        DOM.Service.empty( document.getElementById( "id-shinken-check-list" ) );
        __list_host_in_page_host      = [];
        var _nb_checks_final          = 0;
        __list_host_in_page_host[ 0 ] = new OBJECT.HostInPageHost( MANAGER.__instance_element_distributor.current_element );
        __list_host_in_page_host[ 0 ].setChecks( MANAGER.__instance_element_distributor.getCheckForCurrentElement() );
        _nb_checks_final += __list_host_in_page_host[ 0 ].size_checks_host;
        for ( var i = 0; i < MANAGER.__instance_element_distributor.list_templates.size_computed; i++ ) {
            __list_host_in_page_host[ i + 1 ] = new OBJECT.HostInPageHost( null, MANAGER.__instance_element_distributor.list_templates.list_template_computed[ i ] );
            __list_host_in_page_host[ i + 1 ].setChecks( MANAGER.__instance_element_distributor.getCheckForElement( __list_host_in_page_host[ i + 1 ].uuid ) );
            _nb_checks_final += __list_host_in_page_host[ i + 1 ].size_checks_host;
            if ( i === 0 ) {
                __list_host_in_page_host[ i + 1 ].is_first_template = true;
            }
        }
        self.computeCheckNameIfAlreadyExist();
        for ( var i = 0, _size = __list_host_in_page_host.length; i < _size; i++ ) {
            __list_host_in_page_host[ i ].appendHtml();
        }
        
        if ( !_nb_checks_final ) {
            var _to_add_empty = DOM.Service.createElement( 'h3', { class: 'shinken-any-check-message text-middle' }, _( 'element.no_check_hooked' ) );
            __container_list_check.appendChild( _to_add_empty );
        }
        self.updateUnvalidOverride();
        self.buildOverrideCfgFormatHtml();
    }
    
    self.updateUnvalidOverride = function () {
        MANAGER.__instance_override_unvalid.init();
        if ( MANAGER.__instance_override_unvalid.size ) {
            DOM.Service.addElementTo( MANAGER.__instance_override_unvalid.buildHtml(), __container_list_check );
        }
    };
    
    self.updateExcludeStatus = function () {
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            __list_host_in_page_host[ i ].updateExcludeStatus();
        }
    };
    
    function _updateHtmlAfterOverrideCommandChange ( property ) {
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            __list_host_in_page_host[ i ].updateHtmlAfterOverrideCommandChange( property );
        }
    }
    
    function _updateHtmlAfterDataChange ( data ) {
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            __list_host_in_page_host[ i ].updateHtmlAfterDataChange( data );
        }
        if ( data.isDfeData() ) {
            self.updateUnvalidOverride();
        }
        self.computeCheckNameIfAlreadyExist();
    }
    
    self.computeModulationTag = function () {
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            __list_host_in_page_host[ i ].computeModulationTag();
        }
    };
    
    self.computeCheckNameIfAlreadyExist = function () {
        var _mapping_check_name     = {};
        var _current_host;
        var _current_check;
        var _size_host_in_page_host = __list_host_in_page_host.length;
        for ( var i = 0; i < _size_host_in_page_host; i++ ) {
            _current_host = __list_host_in_page_host[ i ];
            for ( var j = 0; j < _current_host.size_checks_host; j++ ) {
                _current_check = _current_host.checks_host[ j ];
                if ( _mapping_check_name[ _current_check.name ] ) {
                    _current_check.check_with_same_name = _mapping_check_name[ _current_check.name ];
                    if ( _current_host.uuid === _mapping_check_name[ _current_check.name ].parent_uuid && _current_check.is_dfe === _mapping_check_name[ _current_check.name ].is_dfe ) {
                        _current_check.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME );
                        _mapping_check_name[ _current_check.name ].setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME );
                        _mapping_check_name[ _current_check.name ].check_with_same_name = _mapping_check_name[ _current_check.name ];
                    }
                    else if ( _current_check.uuid === _mapping_check_name[ _current_check.name ].uuid ) {
                        _current_check.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE );
                    }
                    else {
                        _current_check.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME );
                    }
                }
                else {
                    if ( _current_check.exclude_status !== OBJECT.CONST.EXCLUDE_STATUS.BY_ID ) {
                        _mapping_check_name[ _current_check.name ] = _current_check;
                    }
                    _current_check.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.NONE );
                }
            }
            _current_host.updateTagHtml();
        }
    };
    
    self.updateCurrentElementName   = function ( to_set ) {
        if ( __list_host_in_page_host[ 0 ].dom_element ) {
            __list_host_in_page_host[ 0 ].dom_element.querySelector( ".shinken-host-in-page-host-title .shinken-template" ).innerText = to_set;
        }
    };
    self.buildOverrideCfgFormatHtml = function () {
        var _dom_container = DOM.Service.createElement( "div", { class: "shinken-override-cfg-format-container" } );
        
        var _dom_separator_container = DOM.Service.createElement( "div", { class: "shinken-separator-container" } );
        var _to_add                  = DOM.Service.createElement( "div", { class: "shinken-separator-title" }, _( 'element.override_cfg_format' ) );
        _dom_separator_container.appendChild( _to_add );
        var _text                       = getCfgFormatOverrideForCurrentElement();
        var _dom_format_value_container = DOM.Service.createElement( "div", { class: "shinken-override-cfg-format-value-container shinken-parent-text-to-copy" } );
        var _dom_format_value           = DOM.Service.createElement( "div", { class: "shinken-override-cfg-format-value shinken-text-to-copy" }, _text );
        
        _dom_container.appendChild( _dom_separator_container );
        _dom_format_value_container.appendChild( CLIPBOARD_SERVICE.buildHtmlButtons( true, false ) );
        _dom_format_value_container.appendChild( _dom_format_value );
        _dom_container.appendChild( _dom_format_value_container );
        
        DOM.Service.addElementTo( _dom_container, __container_list_check );
    };
    self.askUpdateOverrideFormatCfg = function () {
        if ( self.__ask_update_override_cfg_format ) {
            clearTimeout( self.__ask_update_override_cfg_format );
        }
        self.__ask_update_override_cfg_format = setTimeout( function () {
            self.updateOverrideFormatCfg();
        }, 300 );
        
    };
    self.updateOverrideFormatCfg    = function () {
        var dom_override_cfg_format       = document.querySelector( '.shinken-override-cfg-format-container .shinken-override-cfg-format-value-container .shinken-override-cfg-format-value' );
        dom_override_cfg_format.innerHTML = getCfgFormatOverrideForCurrentElement();
    };
    self.getCheckInHostElement      = function ( check_uuid, dfe_name ) {
        var _to_return;
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            _to_return = __list_host_in_page_host[ i ].getCheckInHostElement( check_uuid, dfe_name );
            if ( _to_return ) {
                return _to_return;
            }
        }
        return null;
    };
    self.getAllCheckByID            = function ( check_uuid, dfe_name ) {
        var _to_return = [];
        var _to_add;
        var _size      = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            _to_add = __list_host_in_page_host[ i ].getCheckByID( check_uuid, dfe_name );
            if ( _to_add ) {
                _to_return.push( _to_add );
            }
        }
        return _to_return;
    };
    self.getCheckByID               = function ( check_uuid, dfe_name ) {
        var _to_return;
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            _to_return = __list_host_in_page_host[ i ].getCheckByID( check_uuid, dfe_name );
            if ( _to_return ) {
                return _to_return;
            }
        }
        return null;
    };
    self.getListHostInPageHost      = function () {
        return __list_host_in_page_host;
    };
    
    
    self.buildIdTagModulation         = function ( check_host ) {
        return "id-tag-modulation-" + check_host.getDomUUID();
    };
    self.isTagModulationNeededForProp = function ( check_host, property_name, property ) {
        if ( property ) {
            var _value_property = MANAGER.__instance_property_distributor.findElement( PROPERTY.BuildOverrideName( property_name, property ) ).getDataToSave();
            switch ( _value_property ) {
                case "":
                    break;
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    return false;
                default:
                    return true;
            }
        }
        var _return_override = MANAGER.__instance_element_distributor.current_element.hasOverrideModulation( check_host, property_name );
        if ( _return_override > OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE ) {
            return true;
        }
        else if ( _return_override === OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED ) {
            return false;
        }
        
        var _return_check = check_host.element.getTypeModulation( property_name );
        switch ( _return_check ) {
            case OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED:
            case OBJECT.CONST.ELEMENT.MODULATION.TYPE.PLUS:
                return false;
            case OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING:
            case OBJECT.CONST.ELEMENT.MODULATION.TYPE.ERROR:
                return true;
        }
        if ( check_host.parent_uuid !== MANAGER.__instance_element_distributor.current_element.uuid ) {
            var _tpl = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( check_host.parent_uuid );
            if ( _tpl.hasOverrideModulation( check_host, property_name ) ) {
                return true;
            }
        }
        
        var _on_current_element = MANAGER.__instance_property_distributor.getElement( property_name ).getValueAndValueInherited();
        if ( _on_current_element && _on_current_element !== PROPERTY.CONST.STATE_VALUE_PLUS.ON ) {
            return true;
        }
        return false;
    };
    self.isTagModulationNeeded        = function ( check_host, property ) {
        if ( self.isTagModulationNeededForProp( check_host, PROPERTY.CONST.NAME.MACRO_MODULATIONS, property ) ) {
            return true;
        }
        if ( self.isTagModulationNeededForProp( check_host, PROPERTY.CONST.NAME.RESULT_MODULATIONS, property ) ) {
            return true;
        }
        return false;
    };
    self.createTagModulation          = function ( check_host ) {
        var _check_macro_mod_type  = check_host.element.getTypeModulation( PROPERTY.CONST.NAME.MACRO_MODULATIONS );
        var _check_result_mod_type = check_host.element.getTypeModulation( PROPERTY.CONST.NAME.RESULT_MODULATIONS );
        var _id                    = self.buildIdTagModulation( check_host );
        var _class                 = "shinken-tag-modulation";
        if ( !self.isTagModulationNeeded( check_host ) ) {
            _class += ' shinken-hidden';
        }
        var _attributes = {};
        if ( _check_macro_mod_type === OBJECT.CONST.ELEMENT.MODULATION.TYPE.ERROR || _check_result_mod_type === OBJECT.CONST.ELEMENT.MODULATION.TYPE.ERROR ) {
            _class += ' error';
            _attributes.onmouseenter      = "SHINKEN_TOOLTIP.showTooltip(this)";
            _attributes.onmouseleave      = "SHINKEN_TOOLTIP.hideTooltip()";
            _attributes[ 'shi-tip-html' ] = _( 'element.tooltip_modulation_bad_config' );
            check_host.setError( 'shinken-modulation', 1 );
        }
        else {
            check_host.setError( 'shinken-modulation', 0 );
        }
        _attributes.class   = _class;
        _attributes.id      = _id;
        var _tab_modulation = DOM.Service.createElement( 'div', _attributes, _( 'element.modulation' ) );
        var _to_return      = DOM.Service.createElement( 'div', { class: "shinken-tag-modulation-container" } );
        _to_return.appendChild( _tab_modulation );
        return _to_return;
    };
    
    self.initOverrideWindows                     = function ( dom_element, _check_in_host ) {
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( _check_in_host.getDomUUID() );
        _parent_window.setParentCounter( _check_in_host.button_override );
    };
    self.initOverrideProperties                  = function ( dom_element, _check_in_host ) {
        MANAGER.__instance_element_distributor.current_element.removeParentCounter( _check_in_host );
        
        var _elements = dom_element.querySelectorAll( '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE );
        var _current;
        var _name;
        var _current_property;
        var _user_value;
        var _saved_value;
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _current          = _elements[ i ];
            _name             = _current.dataset.name;
            _current_property = MANAGER.__instance_property_distributor.findElement( _name, false, '', _current );
            _current_property.updateWithTemplate();
            _user_value  = MANAGER.__instance_element_distributor.current_element.getOverrideValue( _current_property.override_prop_name, _check_in_host );
            _saved_value = _current_property.getValue();
            if ( !_user_value ) {
                _user_value = "";
            }
            if ( _current_property.isDifferentValue( _user_value, _saved_value ) ) {
                _current_property.setValueFromUser( _user_value );
            }
            if ( _current_property.override_prop_name === PROPERTY.CONST.NAME.RESULT_MODULATIONS ) {
                _current_property.getSelector().setMaximumSelected( PROPERTY.CONST.MAX_SELECTABLE_ITEMS.RESULT_MODULATIONS );
                _current_property.updateView();
            }
            if ( _current_property.type === PROPERTY.CONST.TYPES.DATA ) {
                _current_property.updateView();
            }
            if ( _current_property.type === PROPERTY.CONST.TYPES.MULTI_SELECT && _current_property.has_plus && _current.querySelector( '.shinken-value-from-check' ) ) {
                _current_property.finalActionAfterOverrideLoading();
            }
            
        }
        MANAGER.__instance_element_distributor.current_element.cleanOverrideFor( _check_in_host );
    };
    self.updateWarningAndErrorForMultiLineObject = function ( check_in_host ) {
        var _props = MANAGER.__instance_property_distributor.getAllOverridePropByCheckId( check_in_host.getDomUUID() );
        for ( var i = 0, _size_i = _props.length; i < _size_i; i++ ) {
            if ( _props[ i ].type === PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT ) {
                for ( var j = 0, _size_j = _props[ i ].lines_object.length; j < _size_j; j++ ) {
                    var _keys = Object.keys( _props[ i ].lines_object[ j ].inputs );
                    var _current_key;
                    for ( var k = 0, _size = _keys.length; k < _size; k++ ) {
                        _current_key = _keys[ k ];
                        MANAGER.EventManager.onChangeOnInput( { target: _props[ i ].lines_object[ j ].inputs[ _current_key ].dom_element } );
                    }
                }
            }
        }
        
    };
    self.getCheckOverrideData                    = function ( dom_uuid ) {
        if ( !MANAGER.__instance_loading.isReady() ) {
            console.warn( "[NOT READY]" );
            return;
        }
        MANAGER.__instance_loading.setIsReady( false );
        
        var _check_in_host = self.getCheckInHostElement( dom_uuid );
        if ( !_check_in_host ) {
            console.error( "NO ELEMENT FOUND FOR THIS UUID", "[SHOULD NOT HAPPEN]", "[DATA SHOULD BE CORRUPTED]", dom_uuid );
            MANAGER.__instance_loading.setIsReady( true );
            return;
        }
        if ( _check_in_host.status === OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE ) {
            console.error( "CANNOT OPEN OVERRIDE WITH A WRONG DFE STRUCTURE" );
            MANAGER.__instance_loading.setIsReady( true );
            return;
        }
        var _type_check               = _check_in_host.element.type;
        var _id_result_check_override = "result-check-override-" + dom_uuid;
        var _container                = document.getElementById( _id_result_check_override );
        var _parent                   = _container.parentElement.parentElement;
        var _parent_cell_button_name  = 'id-col-tags-' + _type_check + '-' + dom_uuid;
        var _parent_cell_button       = document.getElementById( _parent_cell_button_name );
        
        if ( !_parent.classList.contains( 'shinken-hidden' ) ) {
            _parent.classList.add( 'shinken-hidden' );
            _parent_cell_button.classList.remove( 'shinken-active' );
            MANAGER.__instance_loading.setIsReady( true );
            return;
        }
        var _check_line          = DOM.Service.findParentElementWithDataSet( _parent_cell_button, 'overrideStatus', 10 );
        var _try_check_container = _check_line.nextSibling;
        if ( !_try_check_container.classList.contains( 'hide' ) ) {
            var _check_list       = document.querySelector( '#id-shinken-check-list' );
            _check_list.scrollTop = _check_list.scrollTop + _try_check_container.offsetHeight;
        }
        
        if ( !_container.classList.contains( 'shinken-unset' ) ) {
            _parent.classList.remove( 'shinken-hidden' );
            _parent_cell_button.classList.add( 'shinken-active' );
            MANAGER.__instance_loading.setIsReady( true );
            return;
        }
        var current_host_uuid = MANAGER.__instance_element_distributor.current_element.uuid;
        var current_host_type = MANAGER.__instance_element_distributor.current_element.type;
        
        var path = COMMUNICATION.QUERY.GET.OVERRIDE.BASE + current_host_type;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.SLASH + current_host_uuid;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.SLASH + _type_check;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.SLASH + _check_in_host.uuid;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.SLASH + _check_in_host.element.host_type;
        
        var _get_separator_added = false;
        if ( MANAGER.__instance_element_distributor.current_element.is_new ) {
            path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER + "item_state=new";
            _get_separator_added = true;
        }
        
        if ( MANAGER.__instance_element_distributor.current_element.is_creation ) {
            path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
            path += 'in_creation' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + "1";
            _get_separator_added = true;
        }
        
        if ( _check_in_host.is_dfe ) {
            path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
            path += 'name' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + _check_in_host.name;
            path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD;
            path += 'dfe_name' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + SHINKEN.TOOLS.STRING.utf8Encode( _check_in_host.key_dfe );
            _get_separator_added = true;
        }
        else {
            path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
            path += 'name' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + _check_in_host.element.service_description;
            _get_separator_added = true;
        }
        
        if ( _check_in_host.force_clean ) {
            path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
            path += 'force_clean' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + "1";
            _get_separator_added = true;
        }
        switch ( _check_in_host.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
                return;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
                path += 'force_disable' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + "1";
                _get_separator_added = true;
                break;
        }
        
        path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
        var tpl = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE );
        path += 'tpl' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + tpl.getValue();
        
        path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD + 'editable' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + MANAGER.__instance_element_distributor.current_element.editable;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD + 'dom-uuid' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + SHINKEN.TOOLS.STRING.utf8Encode( dom_uuid );
        if ( !__is_working_area__ ) {
            path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD + 'item-state' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + 'stagging';
        }
        $.ajax( {
            url     : path,
            dataType: "text",
            success : function ( data ) {
                _container.innerHTML = data;
                _parent.classList.remove( 'shinken-hidden' );
                _container.classList.remove( 'shinken-unset' );
                _parent_cell_button.classList.add( 'shinken-active' );
                self.initOverrideWindows( _container, _check_in_host );
                self.initOverrideProperties( _container, _check_in_host );
                App.Elements.ChecksTab.updateWarningAndErrorForMultiLineObject( _check_in_host );
                MANAGER.__instance_loading.setIsReady( true );
            },
            error   : function ( rc, state, error ) {
                console.error( 'getCheckOverrideData data', 'Got bad result ' + rc.status );
                var data = "";
                switch ( rc.status ) {
                    case 404:
                        data = DOM.Service.createElement( 'span', { class: "span12 alert alert-error" }, _( 'element.service_override_missing_host_or_check' ) );
                        break;
                    
                    default:
                        data = DOM.Service.createElement( 'span', { class: "span12 alert alert-error" }, _( 'element.service_override_bad_request' ) );
                        break;
                    
                }
                DOM.Service.addElementTo( data, _container );
                _parent.classList.remove( 'shinken-hidden' );
                _container.classList.remove( 'shinken-unset' );
                _parent_cell_button.classList.add( 'shinken-active' );
                MANAGER.__instance_loading.setIsReady( true );
            }
        } );
    };
    
    
    return self;
})( App.Elements.ChecksTab || {} );
App.Elements.DataTab = (function ( self ) {
    "use strict";
    var _dom_element_navigation;
    var _dom_element_content_parent;
    var _dom_element_content;
    var __modified_property_data;
    var _current_group_uuid;
    
    var __group_datas = [];
    
    
    
    self.init = function () {
        if ( !MANAGER.__instance_element_distributor.current_element.has_data ) {
            return;
        }
        _initInstance();
        _createLocalData();
        _createTemplatesData();
        _createDFEData();
        
        var _all_datas = MANAGER.__instance_property_distributor.getAllDatasSorted();
        _all_datas     = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( _all_datas, [ 'group_data_uuid', 'name' ] );
        _computeNavigationHTML( _all_datas );
        self.computeDatasHTML( _all_datas );
        self.clickOnDataNavigation( __group_datas[ 0 ].uuid );
    };
    
    self.reset                      = function () {
        __modified_property_data = [];
        var _datas               = MANAGER.__instance_property_distributor.getAllDatasSorted();
        var _current;
        if ( _datas ) {
            for ( var i = 0, _size_data = _datas.length; i < _size_data; i++ ) {
                _current = _datas[ i ];
                if ( _current.component_input.hasBeenChanged() ) {
                    __modified_property_data[ _current.name ] = _current;
                }
                _current.delete();
            }
        }
        var _size_group_data = __group_datas.length;
        for ( var i = 0; i < _size_group_data; i++ ) {
            _current = __group_datas[ i ];
            DOM.Service.removeElement( _current.dom_element );
        }
        __group_datas = [];
    };
    self.clickOnDataNavigation      = function ( group_uuid ) {
        _current_group_uuid = group_uuid;
        self.filterDataDisplayed();
        self.setActiveGroup();
    };
    self.setActiveGroup             = function () {
        var _current;
        var _size = __group_datas.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = __group_datas[ i ];
            if ( _current.uuid === _current_group_uuid ) {
                _current.dom_element.classList.add( "shinken-active" );
                if ( _current.type === PROPERTY.CONST.DATA.GROUP.DFE ) {
                    _dom_element_content_parent.classList.add( 'shinken-data-is-dfe-view' );
                    _dom_element_content_parent.classList.add( 'shinken-collapse' );
                    _dom_element_content_parent.classList.remove( 'shinken-not-collapse' );
                    self.changeAllDataCollapsing( true );
                }
                else {
                    _dom_element_content_parent.classList.remove( 'shinken-data-is-dfe-view' );
                }
            }
            else {
                _current.dom_element.classList.remove( "shinken-active" );
            }
        }
    };
    self.getGroupWithName             = function ( group_name ) {
        var _current;
        var _size = __group_datas.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = __group_datas[ i ];
            if( _current['group_name'] === group_name ){
                return _current;
            }
        }
        return null;
    };
    self.toggleCollapseButtonGlobal = function () {
        var _is_collapse = _dom_element_content_parent.classList.contains( 'shinken-collapse' );
        if ( _is_collapse ) {
            _dom_element_content_parent.classList.add( 'shinken-not-collapse' );
            _dom_element_content_parent.classList.remove( 'shinken-collapse' );
        }
        else {
            _dom_element_content_parent.classList.add( 'shinken-collapse' );
            _dom_element_content_parent.classList.remove( 'shinken-not-collapse' );
        }
        self.changeAllDataCollapsing( !_is_collapse );
    };
    self.changeAllDataCollapsing    = function ( _is_collapse ) {
        var _datas = MANAGER.__instance_property_distributor.getAllDatasSorted();
        var _size  = _datas.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( _datas[ i ].group_data && _datas[ i ].group_data.uuid === _current_group_uuid ) {
                _datas[ i ].setCollapseCheck( _is_collapse );
            }
        }
    };
    self.toggleCollapseButton       = function ( dom_element ) {
        var _is_collapse = dom_element.classList.contains( 'shinken-collapse' );
        if ( _is_collapse ) {
            dom_element.classList.add( 'shinken-not-collapse' );
            dom_element.classList.remove( 'shinken-collapse' );
        }
        else {
            dom_element.classList.add( 'shinken-collapse' );
            dom_element.classList.remove( 'shinken-not-collapse' );
        }
    };
    self.filterDataDisplayed        = function () {
        var _current;
        var _datas          = MANAGER.__instance_property_distributor.getAllDatasSorted();
        var _size_displayed = 0;
        for ( var i = 0, _size = _datas.length; i < _size; i++ ) {
            _current = _datas[ i ];
            if ( _current.is_override ) {
                continue;
            }
            if ( _current.group_data.uuid === _current_group_uuid ) {
                _current.dom_element.classList.remove( 'shinken-hidden' );
                _current.updateView();
                _size_displayed++;
            }
            else {
                _current.dom_element.classList.add( 'shinken-hidden' );
            }
        }
        if ( !_size_displayed ) {
            _dom_element_content_parent.classList.add( 'shinken-no-data-found' );
        }
        else {
            _dom_element_content_parent.classList.remove( 'shinken-no-data-found' );
        }
    };
    
    var _initInstance = function () {
        _dom_element_navigation     = document.getElementById( 'shinken-data-tab-nav' );
        _dom_element_content        = document.getElementById( 'shinken-data-tab-content' );
        _dom_element_content_parent = document.getElementById( 'data-tab-content' );
    };
    
    var _createDFEData         = function () {
        var _current;
        var _current_check;
        var _current_dfe_name;
        var _current_label;
        var _element_use = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE );
        if ( !_element_use ) { //??
            return;
        }
        var _all_template_used = MANAGER.__instance_element_distributor.list_templates.list_template_computed;
        for ( var i = 0, _size_i = _all_template_used.length + 1; i < _size_i; i++ ) {
            if ( !i ) {
                _current       = MANAGER.__instance_element_distributor.current_element;
                _current_label = "";
            }
            else {
                _current       = _all_template_used[ i - 1 ];
                _current_label = _current.getName();
            }
            if ( !_current.size_dfe_check ) {
                continue;
            }
            
            var _group_data = new WINDOW.DataGroup( PROPERTY.CONST.DATA.GROUP.DFE, _current_label );
            __group_datas.push( _group_data );
            
            for ( var j = 0, _size_j = _current.checks.length; j < _size_j; j++ ) {
                _current_check = _current.checks[ j ];
                if ( !_current_check.is_dfe ) {
                    continue;
                }
                _current_dfe_name = _current_check[ PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME ];
                var _to_add       = new PROPERTY.Data( _current_dfe_name, MANAGER.__instance_element_distributor.current_element[ _current_dfe_name ], _group_data );
                if ( !_to_add.is_valid ) {
                    continue;
                }
                var _existing = MANAGER.__instance_property_distributor.getDataWithName( _current_dfe_name );
                if ( _existing ) {
                    _existing.setGroupData( _group_data );
                    _to_add.setInheritedData( _existing.inherited_data );
                    if ( _existing.modified_value_before_prop_use_modification ) {
                        _to_add.modified_value_before_prop_use_modification = _existing.modified_value_before_prop_use_modification;
                    }
                }
                else {
                    MANAGER.__instance_property_distributor.setElement( _to_add.uuid, _to_add );
                }
            }
        }
    };
    var _createLocalData       = function () {
        var _group_data = new WINDOW.DataGroup( PROPERTY.CONST.DATA.GROUP.LOCALE );
        __group_datas.push( _group_data );
        var _datas = MANAGER.__instance_element_distributor.current_element.getAllData();
        var _keys  = Object.keys( _datas );
        var _to_add;
        var _current_key;
        var _size  = _keys.length;
        for ( var i = 0; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _to_add      = new PROPERTY.Data( _current_key, _datas[ _current_key ], _group_data );
            if ( !_to_add.is_valid ) {
                continue;
            }
            MANAGER.__instance_property_distributor.setElement( _to_add.uuid, _to_add );
            if ( __modified_property_data[ _current_key ] ) {
                _to_add.modified_value_before_prop_use_modification = __modified_property_data[ _current_key ].component_input.current_value;
                delete __modified_property_data[ _current_key ];
            }
        }
        var _keys = Object.keys( __modified_property_data );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( __modified_property_data[ _keys[ i ] ].status === PROPERTY.CONST.DATA.STATUS.NEW ) {
                _to_add = __modified_property_data[ _keys[ i ] ];
                _to_add.setGroupData( _group_data );
                _to_add.modified_value_before_prop_use_modification = _to_add.component_input.current_value;
            }
            else {
                _to_add                                             = new PROPERTY.Data( __modified_property_data[ _keys[ i ] ].name, '', _group_data );
                _to_add.modified_value_before_prop_use_modification = __modified_property_data[ _keys[ i ] ].component_input.current_value;
            }
            MANAGER.__instance_property_distributor.setElement( _to_add.uuid, _to_add );
        }
    };
    var _createTemplatesData   = function () {
        for ( var i = 0; i < MANAGER.__instance_element_distributor.list_templates.size_computed; i++ ) {
            _createTemplateData( MANAGER.__instance_element_distributor.list_templates.list_template_computed[ i ] );
        }
    };
    var _createTemplateData    = function ( template ) {
        var _current_key;
        var _current_data;
        var _group_data = new WINDOW.DataGroup( PROPERTY.CONST.DATA.GROUP.INHERITED, template.name );
        __group_datas.push( _group_data );
        var _keys = Object.keys( template.datas );
        var _size = _keys.length;
        for ( var i = 0; i < _size; i++ ) {
            _current_key  = _keys[ i ];
            _current_data = template.datas[ _current_key ];
            if ( !_current_data.data.is_valid ) {
                continue;
            }
            var _existing = MANAGER.__instance_property_distributor.getDataWithName( _current_key );
            
            if ( _existing ) {
                if ( !_existing.isLocalData() ) {
                    continue;
                }
                else {
                    _existing.setGroupData( _group_data );
                    _existing.setInheritedData( _current_data );
                }
            }
            else {
                _current_data.data.setGroupData( _group_data );
                _current_data.data.setInheritedData( _current_data );
                _current_data.data.setValue( "" );
                MANAGER.__instance_property_distributor.setElement( _current_data.data.uuid, _current_data.data );
            }
            
        }
        
    };
    var _computeNavigationHTML = function ( datas ) {
        var _current;
        var _size = __group_datas.length;
        
        var dom_template = document.getElementById( 'data-li-title-templates' );
        var dom_dfe      = document.getElementById( 'data-li-title-foreach-dfe' );
        dom_template.classList.add( 'shinken-hidden' );
        dom_dfe.classList.add( 'shinken-hidden' );
        
        for ( var i = 0; i < _size; i++ ) {
            _current = __group_datas[ i ];
            switch ( _current.type ) {
                case PROPERTY.CONST.DATA.GROUP.LOCALE:
                    _dom_element_navigation.insertBefore( _current.buildHTMLNav(), dom_template );
                    break;
                case PROPERTY.CONST.DATA.GROUP.INHERITED:
                    dom_template.classList.remove( 'shinken-hidden' );
                    _dom_element_navigation.insertBefore( _current.buildHTMLNav(), dom_dfe );
                    break;
                default:
                    dom_dfe.classList.remove( 'shinken-hidden' );
                    _dom_element_navigation.appendChild( _current.buildHTMLNav() );
            }
            _current.initCountersDom();
        }
    };
    self.computeDatasHTML      = function ( all_datas ) {
        var _size = all_datas.length;
        for ( var i = 0; i < _size; i++ ) {
            all_datas[ i ].init();
            _dom_element_content.appendChild( all_datas[ i ].dom_element );
        }
    };
    
    self.addNewData = function () {
        var __group_data = __group_datas[ 0 ];
        var _name        = PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL;
        var _to_add      = new PROPERTY.Data( _name, "", __group_data );
        _to_add.init();
        _to_add.setStatus( PROPERTY.CONST.DATA.STATUS.NEW );
        _dom_element_content.insertBefore( _to_add.dom_element, _dom_element_content.firstChild );
        MANAGER.__instance_property_distributor.setElement( _to_add.uuid, _to_add );
        self.clickOnDataNavigation( __group_data.uuid );
        return _to_add;
    };
    
    
    
    self.getCheckCandidate = function ( template ) {
        var _to_return;
        var _index_template = -1;
        if ( template.uuid === MANAGER.__instance_element_distributor.current_element.uuid ) {
            _to_return = MANAGER.__instance_element_distributor.current_element.checks;
        }
        else {
            _to_return      = template.checks;
            _index_template = MANAGER.__instance_element_distributor.list_templates.getIndexForCompute( template );
        }
        var _current_template;
        for ( var i = _index_template + 1; i < MANAGER.__instance_element_distributor.list_templates.size_computed; i++ ) {
            _current_template = MANAGER.__instance_element_distributor.list_templates.list_template_computed[ i ];
            for ( var j = 0, _size_j = _current_template.checks.length; j < _size_j; j++ ) {
                _to_return.push( _current_template.checks[ j ] );
            }
        }
        return _to_return;
    };
    
    
    return self;
    
})( App.Elements.DataTab || {} );
COMPONENT.BtnInheritance           = function ( parent_name, dom_element_parent, type_property, is_order_kept ) {
    this.init( parent_name, dom_element_parent, type_property );
};
COMPONENT.BtnInheritance.prototype = {
    init: function ( parent_name, dom_element_parent, type_property ) {
        this.parent_name         = parent_name;
        this.state               = COMPONENT.CONST.BTN_STATE.DISABLED;
        this.name_template       = null;
        this.from_template       = null;
        this.dom_element_parent  = dom_element_parent;
        this.dom_container       = null;
        this.dom_container_tbody = null;
        this.has_arborescence    = false;
        this.type_property       = type_property;
    },
    
    buildHTML            : function () {
        this.dom_container = this.dom_element_parent.querySelector( '.from-template' );
        if ( !this.dom_container ) {
            return;
        }
        this.dom_container.innerHTML = '';
        this.dom_element             = DOM.Service.createElement( 'div', {
            class  : 'switch-button-wrapper',
            onclick: 'MANAGER.EventManager.clickOnBtnInheritance("' + this.parent_name + '")'
        } );
        var _btn                     = DOM.Service.createElement( 'div', { class: 'switch-button' } );
        var _on_label                = DOM.Service.createElement( 'span', { class: 'switch-button-label on' }, _( 'element.inheritance_on' ) );
        var _off_label               = DOM.Service.createElement( 'span', { class: 'switch-button-label off' }, _( 'element.inheritance_off' ) );
        
        var _attr_table       = { class: 'table-inheritance' };
        var _attr_col_content = { class: 'col-content' };
        if ( this.has_arborescence ) {
            _attr_table       = { class: 'table-inheritance-with-arborescence' };
            _attr_col_content = { class: 'col-content', colspan: '2', rowspan: '2' };
        }
        
        var table = DOM.Service.createElement( 'table', _attr_table );
        var thead = DOM.Service.createElement( 'thead', {} );
        var tbody = DOM.Service.createElement( 'tbody', { class: 'switch-button-value' } );
        
        var _line_1      = DOM.Service.createElement( 'tr', {} );
        var _col_btn     = DOM.Service.createElement( 'td', { class: 'col-btn', colspan: '2' } );
        var _col_content = DOM.Service.createElement( 'td', _attr_col_content );
        
        DOM.Service.addElementTo( _col_btn, _line_1 );
        DOM.Service.addElementTo( _col_content, _line_1 );
        DOM.Service.addElementTo( _line_1, thead );
        
        if ( this.has_arborescence ) {
            var _line_2       = DOM.Service.createElement( 'tr', { class: 'switch-button-wrapper-line' } );
            var _col_arbo_2_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-1 ' } );
            var _col_arbo_2_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-2 ' } );
            DOM.Service.addElementTo( _col_arbo_2_1, _line_2 );
            DOM.Service.addElementTo( _col_arbo_2_2, _line_2 );
            DOM.Service.addElementTo( _line_2, thead );
        }
        
        DOM.Service.addElementTo( _btn, this.dom_element );
        DOM.Service.addElementTo( _on_label, _col_content );
        DOM.Service.addElementTo( _off_label, _col_content );
        DOM.Service.addElementTo( this.dom_element, _col_btn );
        
        DOM.Service.addElementTo( thead, table );
        DOM.Service.addElementTo( tbody, table );
        DOM.Service.addElementTo( table, this.dom_container );
        
        this.dom_container_tbody = tbody;
    },
    buildFromTemplateLine: function () {
        this.dom_container_tbody.innerHTML = '';
        
        var _line        = DOM.Service.createElement( 'tr' );
        var _col_content = DOM.Service.createElement( 'td', { class: 'col-content', colspan: '4' } );
        
        
        var _label_text;
        var _label;
        var _id_tpl   = this.list_template_property.template_id;
        var _name_tpl = this.list_template_property.template_name;
        var _selected_prop;
        var _selected;
        var _shinken_element;
        switch ( this.type_property ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                var _tags = this.list_template_property[ 0 ].getTags();
                for ( var i = 0; i < this.list_template_property[ 0 ].size_tags; i++ ) {
                    DOM.Service.addElementTo( _tags[ i ].getDomElement(), _col_content );
                }
                var _clear = DOM.Service.createElement( 'div', { class: 'clear' } );
                DOM.Service.addElementTo( _clear, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                _selected_prop   = MANAGER.__instance_property_distributor.getElement( this.list_template_property[ 0 ].name );
                var _split       = this.list_template_property[ 0 ].value.split( "!" );
                _shinken_element = MANAGER.__instance_element_distributor.getElementByName( _split[ 0 ] );
                _selected        = _selected_prop.getSelector().list_element.getElement( _split[ 0 ] );
                
                _label_text = this.list_template_property[ 0 ].label;
                _label_text = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss(_label_text)
                if ( _shinken_element ) {
                    _label_text = SHINKEN.TOOLS.buildLinkShinkenElement( _shinken_element ).outerHTML;
                    for ( var i = 1, _size_i = _split.length; i < _size_i; i++ ) {
                        _label_text += "!" + SHINKEN.TOOLS.STRING.uncleanBeforecleanXss(_split[ i ]);
                    }
                }
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                _selected_prop = MANAGER.__instance_property_distributor.getElement( this.list_template_property[ 0 ].name );
                _selected      = _selected_prop.getSelector().list_element.getElement( this.list_template_property[ 0 ].value );
                _label_text    = _selected ? _selected.label : this.list_template_property[ 0 ].value;
                if ( _selected && _selected.shinken_element ) {
                    _label_text = SHINKEN.TOOLS.buildLinkShinkenElement( _selected.shinken_element ).outerHTML;
                }
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.BOOLEAN:
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
            case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                _label_text      = this.list_template_property[ 0 ].label;
                if ( this.list_template_property[ 0 ].value === PROPERTY.CONST.CUSTOM_SELECT.NONE ){
                    _label_text = _( 'element.forced_default' ) + '(' + _label_text + ')'
                }
                _label           = DOM.Service.createElement( 'span' );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                _label_text = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss(this.list_template_property[ 0 ].value);
                if ( _label_text === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    _label_text = _( 'element.forced_default' );
                    var _prop   = MANAGER.__instance_property_distributor.getElement( this.list_template_property[ 0 ].name );
                    if ( _prop && _prop.default_value ) {
                        _label_text += " " + _prop.default_value;
                    }
                }
                _label           = DOM.Service.createElement( 'div', { class: "shinken-heritance-value" } );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                _id_tpl   = this.list_template_property[ 0 ].template_id;
                _name_tpl = this.list_template_property[ 0 ].template_name;
                break;
            case PROPERTY.CONST.TYPES.DATA:
                if ( this.list_template_property.is_protected ){
                    _label_text = SHINKEN.TOOLS.ENCRYPTION.getDefaultSpanLabel();
                }
                else {
                    _label_text = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss(this.list_template_property.label);
                }
                if ( _label_text === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    _label_text = _( 'element.forced_default' );
                }
                _label           = DOM.Service.createElement( 'div', { class: "shinken-heritance-value" } );
                _label.innerHTML = _label_text;
                DOM.Service.addElementTo( _label, _col_content );
                break;
            
        }
        var _template_link = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( shinken_link_tpl, _id_tpl, _name_tpl ).outerHTML;
        var _info          = DOM.Service.createElement( 'span', { class: "shinken-inheritance-template-name" }, '&nbsp;<span class="shinken-between-bracket">' + _( 'source.tag' ) + '&nbsp;' + _template_link + '</span>' );
        DOM.Service.addElementTo( _info, _col_content );
        
        DOM.Service.addElementTo( _col_content, _line );
        DOM.Service.addElementTo( _line, this.dom_container_tbody );
    },
    askUpdateHTML        : function () {
        var self = this;
        if ( this.timer_ask_html ) {
            clearTimeout( this.timer_ask_html );
        }
        this.timer_ask_html = setTimeout( function () {
            self.timer_ask_html = null;
            
            self.updateHTML();
        }, COMPONENT.CONST.BTN_INHERITANCE.TIMER_DELAY_BUILD_HTML );
    },
    updateHTML           : function () {
        if ( !this.isSet() ) {
            if ( this.dom_container ) {
                this.dom_container.innerHTML = '';
                this.dom_container           = null;
            }
            return;
        }
        this.buildHTML();
        
        if ( this.has_arborescence ) {
            this.list_arborescence.buildFromTemplateArbo( this.list_template_property, this.dom_container_tbody );
        }
        else {
            this.buildFromTemplateLine();
        }
    },
    
    setHasArborescence: function ( _to_set ) {
        this.has_arborescence = _to_set;
        if ( _to_set ) {
            this.list_arborescence = new COMPONENT.InheritanceArborescence( this.parent_name, this.dom_element_parent );
        }
    },
    
    getDomElement: function () {
        return this.dom_element;
    },
    
    isSet        : function () {
        return this.state !== COMPONENT.CONST.BTN_STATE.DISABLED;
    },
    getTags      : function () {
        var _to_return = [];
        if ( this.has_arborescence ) {
            var _current;
            var _size = this.list_template_property.length;
            for ( var i = 0; i < _size; i++ ) {
                _current = this.list_template_property[ i ];
                if ( !_current.is_stopped ) {
                    _to_return = _to_return.concat( _current.getTags() );
                }
            }
        }
        else {
            var _template = this.list_template_property[ 0 ];
            _to_return    = _template.getTags();
        }
        return _to_return;
    },
    getState     : function () {
        return this.state;
    },
    setState     : function ( state ) {
        if ( !this.isSet() ) {
            return;
        }
        this.state = state;
        fire_element_is_modifie();
    },
    getValueFinal: function () {
        if ( !this.isSet() ) {
            return "";
        }
        if ( !this.list_template_property || !this.list_template_property[ 0 ] ) {
            return "";
        }
        return this.list_template_property[ 0 ].value;
    },
    
    toggleState: function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
        }
        return this.state;
    },
    
    setTemplateProperty: function ( to_set ) {
        this.list_template_property = to_set;
        
        if ( !this.list_template_property ) {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
            return false;
        }
        
        if ( !this.isSet() ) {
            this.state = COMPONENT.CONST.BTN_STATE.INIT;
        }
        return true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.BtnInheritance, SHINKEN.OBJECT.ShinkenObject );
COMPONENT.Button           = function ( dom_element, name ) {
    this.state = COMPONENT.CONST.BTN_STATE.OFF;
    this.name  = name;
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init             : function ( dom_element ) {
        this.dom_element = dom_element;
        this.value       = this.dom_element.value;
        this._computeState();
    },
    setState         : function ( to_set ) {
        this.state = to_set;
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.dom_element.classList.remove( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE );
                this.dom_element.classList.remove( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_DISABLED );
                break;
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_DISABLED );
                break;
        }
    },
    getValue         : function () {
        return this.value;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    _computeState    : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    appendToHtml     : function ( _dom_value_to_append ) {
        this.dom_element.appendChild( _dom_value_to_append );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Button, SHINKEN.OBJECT.CounterInterface );
COMPONENT.Checkbox           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.Checkbox.prototype = {
    init                 : function ( dom_element ) {
        this.dom_element        = dom_element;
        this.checkbox_user      = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-user" ) );
        this.checkbox_inherited = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-inherited" ) );
        this.checkbox_default   = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-default" ) );
    },
    setCheckedUser       : function ( to_set ) {
        this.checkbox_user.setChecked( to_set );
    },
    setCheckedInheritance: function ( to_set ) {
        this.checkbox_inherited.setChecked( to_set );
    },
    isCheckedUser        : function () {
        return this.checkbox_user.isChecked();
    },
    isCheckedInheritance : function () {
        return this.checkbox_inherited.isChecked();
    },
    isCheckedDefault     : function () {
        return this.checkbox_default.isChecked();
    }
};
COMPONENT.InheritanceArborescence           = function ( parent_name, dom_element_parent ) {
    this.init( parent_name, dom_element_parent );
};
COMPONENT.InheritanceArborescence.prototype = {
    init                  : function ( parent_name, dom_element_parent ) {
        this.parent_name        = parent_name;
        this.dom_element_parent = dom_element_parent;
        this.dom_element        = null;
    },
    buildFromTemplateArbo : function ( list_template_property, dom_element ) {
        this.list_template_property = list_template_property;
        this.dom_element            = dom_element;
        this.dom_element.innerHTML  = '';
        
        var _size = this.list_template_property.length;
        var _template_property;
        for ( var i = 0; i < _size; i++ ) {
            _template_property = this.list_template_property[ i ];
            
            if ( _template_property.is_stopped ) {
                var _nbSkippedTemplate = _size - i - 1;
                if ( _nbSkippedTemplate ) {
                    _template_property.setIsLast( false );
                }
                
                this.addRowStopped( this.dom_element );
                this.addRowFromTemplateName( _template_property, this.dom_element, {
                    is_stopped    : true,
                    is_arbo_dashed: {
                        top   : true,
                        bottom: true
                    }
                } );
                this.addRowTemplate( _template_property, this.dom_element );
                this.addRowSkippedTemplate( _nbSkippedTemplate, this.dom_element );
                break;
            }
            
            this.addRowFromTemplateName( _template_property, this.dom_element, { is_stopped: false } );
            this.addRowTemplate( _template_property, this.dom_element );
        }
    },
    askUpdateHTML         : function () {
        var self = this;
        if ( this.timer_ask_html ) {
            clearTimeout( this.timer_ask_html );
        }
        this.timer_ask_html = setTimeout( function () {
            self.timer_ask_html = null;
            self.updateHTML();
        }, COMPONENT.CONST.BTN_INHERITANCE.TIMER_DELAY_BUILD_HTML );
    },
    addRowTitle           : function ( target, options ) {
        options                 = options || {};
        options.title           = options.title || '';
        options.attr            = options.attr || {};
        options.tag             = options.tag || 'div';
        options.is_arbo_connect = options.is_arbo_connect || false;
        options.is_arbo_dashed  = options.is_arbo_dashed || {};
        options.is_stopped      = options.is_stopped || false;
        options.is_last         = options.is_last || false;
        
        var _class_line_1       = {};
        var _class_col_arbo_1_1 = '';
        var _class_col_arbo_1_2 = '';
        var _class_col_arbo_2_1 = '';
        
        if ( options.is_stopped ) {
            _class_line_1 = { class: 'stopped' };
        }
        
        if ( options.is_arbo_dashed.top === true ) {
            _class_col_arbo_1_1 = 'dashed';
        }
        if ( options.is_arbo_dashed.right === true ) {
            _class_col_arbo_1_2 = 'dashed arbo';
        }
        if ( options.is_arbo_dashed.bottom === true ) {
            _class_col_arbo_2_1 = 'dashed';
        }
        
        _class_col_arbo_1_2 += options.is_arbo_connect ? ' arbo' : '';
        _class_col_arbo_2_1 += options.is_last ? ' end' : '';
        
        var _line_1       = DOM.Service.createElement( 'tr', _class_line_1 );
        var _line_2       = DOM.Service.createElement( 'tr', {} );
        var _col_arbo_1_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-1-1 ' + _class_col_arbo_1_1 } );
        var _col_arbo_1_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-1-2 ' + _class_col_arbo_1_2 } );
        var _col_arbo_2_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-1 ' + _class_col_arbo_2_1 } );
        var _col_arbo_2_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-2 ' } );
        var _col_title    = DOM.Service.createElement( 'td', { class: 'col-content', colspan: '2', rowspan: '2' } );
        var _title        = DOM.Service.createElement( options.tag, options.attr, options.title );
        
        DOM.Service.addElementTo( _col_arbo_1_1, _line_1 );
        DOM.Service.addElementTo( _col_arbo_1_2, _line_1 );
        DOM.Service.addElementTo( _col_arbo_2_1, _line_2 );
        DOM.Service.addElementTo( _col_arbo_2_2, _line_2 );
        DOM.Service.addElementTo( _col_title, _line_1 );
        DOM.Service.addElementTo( _title, _col_title );
        DOM.Service.addElementTo( _line_1, target );
        DOM.Service.addElementTo( _line_2, target );
    },
    addRowSkippedTemplate : function ( size, target ) {
        if ( !size ) {
            return;
        }
        
        var _title = _( 'element.and' ) + ' ' + size + ' ';
        _title += (size > 1) ? _( 'element.skipped_templates' ) : _( 'element.skipped_template' );
        
        this.addRowTitle( target, {
            title         : _title,
            is_stopped    : true,
            is_arbo_dashed: {
                top   : true,
                right : true,
                bottom: true
            },
            is_last       : true
        } );
    },
    addRowFromTemplateName: function ( _template_property, target, options ) {
        options    = options || {};
        var _title = '<span class="shinken-between-bracket">' + _( 'source.tag' ) + "&nbsp;" + SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( shinken_link_tpl, _template_property.template_id, _template_property.template_name ).outerHTML + '</span>';
        if ( options.is_stopped ) {
            _title = _( 'element.skipped_template' ) + ' ' + _template_property.template_name;
        }
        options.title = _title;
        this.addRowTitle( target, options );
    },
    addRowStopped         : function ( target ) {
        this.addRowTitle( target, {
            title          : _( 'element.inheritance_stopped' ),
            attr           : { class: 'tag' },
            is_arbo_connect: true,
            is_arbo_dashed : {
                bottom: true
            }
        } );
    },
    addRowTemplate        : function ( _template_property, target ) {
        var _class_line_1       = {};
        var _class_col_arbo_1_1 = '';
        var _class_col_arbo_1_2 = '';
        var _class_col_arbo_2_1 = '';
        var _class_col_arbo_2_2 = '';
        
        if ( _template_property.is_stopped ) {
            _class_line_1 = { class: 'stopped' };
            _class_col_arbo_1_1 += ' dashed';
            _class_col_arbo_1_2 += ' dashed';
            _class_col_arbo_2_1 += ' dashed';
        }
        if ( _template_property.is_last ) {
            _class_col_arbo_2_1 += ' end';
        }
        
        var _line_1       = DOM.Service.createElement( 'tr', _class_line_1 );
        var _line_2       = DOM.Service.createElement( 'tr', {} );
        var _col_arbo_1_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-1-1 ' + _class_col_arbo_1_1 } );
        var _col_arbo_1_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-1-2 arbo ' + _class_col_arbo_1_2 } );
        var _col_arbo_2_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-1 ' + _class_col_arbo_2_1 } );
        var _col_arbo_2_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-2 ' + _class_col_arbo_2_2 } );
        var _col_icon     = DOM.Service.createElement( 'td', { class: 'col-icon', rowspan: '2' } );
        var _col_content  = DOM.Service.createElement( 'td', { class: 'col-content', rowspan: '2' } );
        
        var _class_icon = (_template_property.hasPlus()) ? 'token-plus' : 'token-stop';
        var _icon       = DOM.Service.createElement( 'div', { class: _class_icon } );
        
        var _tags = _template_property.getTags();
        for ( var i = 0; i < _template_property.size_tags; i++ ) {
            DOM.Service.addElementTo( _icon, _col_icon );
            DOM.Service.addElementTo( _tags[ i ].getDomElement(), _col_content );
        }
        
        DOM.Service.addElementTo( _col_arbo_1_1, _line_1 );
        DOM.Service.addElementTo( _col_arbo_1_2, _line_1 );
        DOM.Service.addElementTo( _col_arbo_2_1, _line_2 );
        DOM.Service.addElementTo( _col_arbo_2_2, _line_2 );
        DOM.Service.addElementTo( _col_icon, _line_1 );
        DOM.Service.addElementTo( _col_content, _line_1 );
        DOM.Service.addElementTo( _line_1, target );
        DOM.Service.addElementTo( _line_2, target );
    },
    getDomElement         : function () {
        return this.dom_element;
    }
};
COMPONENT.InputRange           = function ( dom_element, property ) {
    this.init( dom_element, property );
};
COMPONENT.InputRange.prototype = {
    init                 : function ( dom_element, property ) {
        this.type_range      = dom_element.dataset.type;
        this.dom_input_range = dom_element.querySelector( ".shinken-range-container input" );
        switch ( property.type ) {
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                this.component_input = new COMPONENT.Input( dom_element.querySelector( ".shinken-input" ), property );
                if ( property.is_mass_change ) {
                    this.component_input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                }
                this.value = this.dom_input_range.dataset.lastValueFromUser;
                break;
            
            default:
                this.component_label_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-label-input-range" ) );
                this.value                 = parseInt( this.dom_input_range.dataset.lastValueFromUser ) + "";
                break;
        }
        this.value_from_user = property.is_mass_change ? '' : this.value;
        this.min             = this.dom_input_range.getAttribute( 'min' );
        this.max             = this.dom_input_range.getAttribute( 'max' );
        this.unit            = dom_element.dataset.unit;
        this.property_name   = property.getName();
        this.is_mass_change  = property.is_mass_change;
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( dom_element, parent || this );
    },
    setValue             : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = false;
        }
        this.value                 = to_set;
        this.dom_input_range.value = to_set;
        if ( this.component_input ) {
            if ( updateInputField && this.component_input.getValue() !== to_set ) {
                this.updateInput();
            }
            else if ( !updateInputField ) {
                this.emptyInput();
            }
        }
        else {
            this.updateLabel();
        }
    },
    setValueFromUser     : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = true;
        }
        if ( to_set === null || to_set === undefined ) {
            to_set = this.dom_input_range.value;
            if ( this.component_input && to_set !== "0" && to_set !== "100" ) {
                to_set += ".000";
            }
        }
        to_set               = to_set + '';
        this.value_from_user = to_set;
        this.setValue( to_set, updateInputField );
    },
    updateInput          : function () {
        this.component_input.dom_element.value = this.value;
        this.component_input.setValue();
        this.component_input.validateValueInput();
    },
    emptyInput           : function () {
        this.component_input.dom_element.value = '';
        this.component_input.setValue();
        this.component_input.resetCounters();
        this.component_input.setStatus( COMPONENT.CONST.STATUS.NONE );
        this.component_input.validateValueInput();
    },
    updateLabel          : function () {
        var _to_set;
        if ( this.is_mass_change && this.value === '' ) {
            _to_set = _( "mass-change.label.enter_a_value" );
        }
        else {
            switch ( this.type_range ) {
                case PROPERTY.CONST.TYPES.RANGE:
                    _to_set = this.value + this.unit;
                    break;
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                    _to_set = _( "element.business_impact_" + this.value );
                    break;
            }
        }
        this.component_label_input.updateLabel( _to_set );
    },
    getValue             : function () {
        return this.value;
    },
    getValueFromUser     : function () {
        return this.value_from_user;
    },
    getComponents        : function () {
        var _to_return = [];
        if ( this.component_input ) {
            _to_return.push( this.component_input );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputRange, SHINKEN.OBJECT.CounterInterface );
COMPONENT.InputWithDropDown           = function ( dom_element, parent, use_quotes, type ) {
    this.init( dom_element, parent, use_quotes, type );
};
COMPONENT.InputWithDropDown.prototype = {
    init                       : function ( dom_element, parent, use_quotes, type ) {
        this.parent = parent;
        this.initCounters( parent );
        this.type            = type;
        this.dom_element     = dom_element;
        this.uuid            = SHINKEN.TOOLS.STRING.buildUUID();
        this.input           = new COMPONENT.Input( this.dom_element.querySelector( '.shinken-input' ), parent || this, true );
        this.select          = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, false, true );
        this.separators      = this.dom_element.dataset.separator.split( "$^$" );
        this.separator_regex = new RegExp( "[" + this.separators.join( "" ) + "]" );
        if ( use_quotes == undefined ) {
            use_quotes = false;
        }
        this.use_quotes = !!use_quotes;
    },
    keydown                    : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.select.moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.select.moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.select.validSelectedOrFirstElement();
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, key_code ) ) {
                    event.preventDefault();
                    event.stopPropagation();
                }
        }
    },
    askComputeAfterChange      : function ( dom_element, parent ) {
        this.input.askComputeAfterChange( dom_element, parent || this );
    },
    clickOnItemSelector        : function ( parent_name, key_name, event ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _previous_value     = this.input.getValue();
        var first_part          = _previous_value.substring( 0, this.first_separator );
        var second_part         = _previous_value.substring( this.last_separator, _previous_value.length );
        var _is_specific_option = false;
        if ( event ) {
            var _parent_dom = DOM.Service.findParentElementWithDataSet( event.target, 'type', 10 );
            if ( _parent_dom && _parent_dom.dataset.type === 'is-always-visible' ) {
                _is_specific_option = true;
            }
        }
        if ( _is_specific_option ) {
            this.input.setValueFromJs( key_name );
        }
        else {
            this.input.setValueFromJs( first_part + key_name + second_part );
        }
        this.setCurrentFilter( true );
    },
    clickOnInput               : function () {
        this.setCurrentFilter();
    },
    setIsProtected             : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? "password" : this.type );
    },
    setPlaceholder             : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        this.placeholder = to_set;
        this.input.setPlaceholder( to_set );
    },
    setValidationRules         : function ( _to_set ) {
        this.input.setValidationRules( _to_set );
    },
    hasBeenChanged             : function () {
        return this.current_value !== this.original_value;
    },
    getParentName              : function () {
        return this.parent.getParentName();
    },
    getComponents              : function () {
        return [ this.input ];
    },
    getValue                   : function () {
        return this.input.getValue();
    },
    setValueFromJs             : function ( to_set ) {
        this.input.setValueFromJs( to_set );
    },
    getFinalValue              : function () {
        if ( this.timeout_ask_compute_after_change ) {
            clearTimeout( this.timeout_ask_compute_after_change );
            this.computeAfterChange();
        }
        return this.getValue();
    },
    setCurrentFilter           : function ( focus_on_last_separator, bypass_do_filter, validation_done ) {
        if ( this.select.list_element.list.length > 0 ) {
            this.select.openSelector();
        }
        var _value           = this.input.getValue();
        var _previous_filter = this.current_filter ? this.current_filter : "";
        var _cursor_position = this.input.dom_element.selectionStart;
        this.first_separator = 0;
        this.last_separator  = _value.length;
        
        var _in_quotes = false;
        for ( var i = 0; i < _cursor_position; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.first_separator = i + 1;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        for ( i = _cursor_position; i < _value.length; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.last_separator = i;
                break;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        
        if ( (this.first_separator) >= this.last_separator ) {
            this.current_filter = "";
        }
        else {
            this.current_filter = _value.substring( this.first_separator, this.last_separator ).trim();
        }
        if ( focus_on_last_separator ) {
            this.input.restoreCursorLocation( this.last_separator );
        }
        
        if ( SHINKEN.TOOLS.STRING.startsWith( this.current_filter, "=" ) ) {
            this.current_filter = this.current_filter.substring( 1 );
        }
        if ( this.use_quotes ) {
            this.current_filter = this.current_filter.replace( /"/g, '' );
        }
        this.select.setResearchDisplay( this.current_filter );
        if ( !bypass_do_filter || this.current_filter !== _previous_filter ) {
            this.select.doFilter( this.current_filter );
        }
        if ( !validation_done ) {
            this.validateValueInput();
        }
    },
    hasAutoSelect              : function () {
        return this.select.hasAutoSelect();
    },
    getDataSetLink             : function () {
        return this.select.getDataSetLink();
    },
    getListElement             : function () {
        return this.select.getListElement();
    },
    getStatus                  : function () {
        return this.input.getStatus();
    },
    addValidationRule          : function ( to_add, type ) {
        this.input.addValidationRule( to_add, type );
    },
    computeAfterChange         : function ( validation_done ) {
        this.setCurrentFilter( false, !this.input.need_validation, validation_done );
    },
    hidePopup                  : function () {
        this.select.hidePopup();
    },
    validSelectedOrFirstElement: function () {
        this.select.validSelectedOrFirstElement();
    },
    validateValueInput         : function () {
        this.input.validateValueInput();
    },
    finishActionBeforeReload   : function () {
        this.input.finishActionBeforeReload();
    },
    doActionAfterChange        : function () {
        this.computeAfterChange();
    },
    isReallyInQuotes           : function ( in_quotes ) {
        return this.use_quotes ? in_quotes : false;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputWithDropDown, SHINKEN.OBJECT.CounterInterface );
COMPONENT.Input           = function ( dom_element, parent, no_auto_valid, extra_key_validation ) {
    this.init( dom_element, parent, extra_key_validation );
};
COMPONENT.Input.prototype = {
    init                    : function ( dom_element, parent, extra_key_validation ) {
        this.initCounters( parent );
        this.dom_element             = dom_element;
        this.uuid                    = SHINKEN.TOOLS.STRING.buildUUID();
        this.current_value           = this.dom_element.getAttribute( 'value' );
        this.type                    = this.dom_element.getAttribute( 'type' );
        this.original_value          = this.current_value;
        this.placeholder_no_template = this.dom_element.placeholder;
        this.placeholder             = this.dom_element.placeholder;
        this.is_resizable            = this.dom_element.tagName === 'TEXTAREA';
        this.need_validation         = true;
        this.key_validation          = {
            "prop_name"     : parent? parent.getParentName() : '',
            "component_name": extra_key_validation || ''
        };
    },
    getDomValue             : function () {
        return this.dom_element.value;
    },
    setValueFromJs          : function ( to_set ) {
        this.current_value = to_set;
        this.computeNeedValidation();
        if ( this.need_validation ) {
            this.updateView( false, true, true );
        }
    },
    setValue                : function ( keep_cursor_pos ) {
        this.computeNeedValidation();
        this.current_value = this.getDomValue();
        this.askComputeHeight();
    },
    setStatus               : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    getStatus               : function () {
        return this.status;
    },
    setIsProtected          : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ? "password" : "shinken-password" : this.type );
    },
    setPlaceholder          : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        to_set = SHINKEN.TOOLS.STRING.unescape_xss(to_set);
        this.placeholder             = to_set;
        this.dom_element.placeholder = this.placeholder;
    },
    getValue                : function () {
        return this.current_value;
    },
    hasBeenChanged          : function () {
        return this.current_value !== this.original_value;
    },
    setTooltip              : function ( to_set ) {
        this.dom_element.setAttribute( 'shi-tip-html', to_set );
    },
    setExtraTooltip         : function ( to_set ) {
        this.extra_tooltip = to_set;
    },
    addShinkenTooltip       : function ( type, message ) {
        if ( this.extra_tooltip && this.hasBeenChanged() ) {
            if ( message ) {
                message += "<br>";
            }
            
            message += this.extra_tooltip;
            if ( type === "shinken-success-border" ) {
                type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
            }
            SHINKEN_TOOLTIP.showTooltip( this.dom_element );
        }
        this.dom_element.setAttribute( 'onmouseenter', "SHINKEN_TOOLTIP.showTooltip(this)" );
        this.dom_element.setAttribute( 'onmouseleave', "SHINKEN_TOOLTIP.hideTooltip()" );
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', message );
        
        message ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
        
    },
    setMessage              : function ( message ) {
        var _status  = COMPONENT.CONST.STATUS.NONE;
        this.message = message;
        if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [ 0, 0 ];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", message ? message.buildMessage() : "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    restoreCursorLocation   : function ( location ) {
        this.dom_element.focus();
        if ( location ) {
            this.last_cursor_location = location;
        }
        if ( !this.last_cursor_location ) {
            this.last_cursor_location = this.current_value.length;
        }
        this.dom_element.selectionStart = this.last_cursor_location;
        this.dom_element.selectionEnd   = this.last_cursor_location;
    },
    saveCursorLocation      : function () {
        this.last_cursor_location = this.getCursorLocation();
    },
    getCursorLocation       : function () {
        return this.dom_element.selectionStart;
    },
    updateView              : function ( is_inherited, update, keep_cursor_pos, has_inheritance ) {
        if ( has_inheritance !== undefined ) {
            this.has_inheritance = !!has_inheritance;
        }
        var _to_write = this.current_value;
        if ( this.current_value === 'null' && this.has_inheritance ) {
            _to_write = '';
        }
        
        if ( is_inherited ) {
            this.setStatus( COMPONENT.CONST.STATUS.NONE );
            this.resetCounters();
        }
        else {
            this.validateValueInput();
        }
        if ( keep_cursor_pos ) {
            this.saveCursorLocation();
        }
        
        if ( update ) {
            this.computeNeedValidation();
            DOM.Service.setInputValue( this.dom_element, is_inherited ? '' : _to_write );
        }
        else {
            this.current_value = this.getDomValue();
        }
        if ( this.dom_element.value ) {
            this.dom_element.classList.remove( 'shinken-empty-input' );
        }
        else {
            this.dom_element.classList.add( 'shinken-empty-input' );
        }
        this.askComputeHeight();
        if ( keep_cursor_pos ) {
            this.restoreCursorLocation();
        }
    },
    askComputeHeight : function () {
        var self = this;
        if ( self.timeout_ask_compute_height ) {
            clearTimeout( self.timeout_ask_compute_height );
        }
        self.timeout_ask_compute_height = setTimeout( function () {
            if ( self.is_resizable && DOM.Service.hasScrollHeight( self.dom_element ) && DOM.Service.getBoundingClientRect( self.dom_element, 'height' ) < 150 ) {
                self.dom_element.style.height = Math.min( 150, self.dom_element.scrollHeight + 6 ) + 'px';
            }
        }, 200 );
    },
    askComputeAfterChange   : function ( dom_element, parent, arg ) {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.computeAfterChange( dom_element, parent, arg );
        }, 200 );
    },
    finishActionBeforeReload: function () {
        if ( this.timeout_ask_compute_after_change ) {
            this.computeAfterChange();
        }
    },
    computeAfterChange      : function ( dom_element, parent, args ) {
        this.setValue();
        if (!args ){
            args = {};
        }
        args['validation_done'] = this.validateValueInput();
        args['input_object'] = this;
        if ( parent ) {
            parent.doActionAfterChange( args );
        }
    },
    validateValueInput      : function ( forced, ignore_focus ) {
        if ( !SHINKEN.TOOLS.SHINKEN_VALIDATOR ) {
            return false;
        }
        if ( this.need_validation || forced ) {
            var _validation_rules = this.getValidationRules( ignore_focus );
            var _validator;
            if ( _validation_rules ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( _validation_rules, SHINKEN.TOOLS.STRING.trimExtented( this.getValue() ) );
            }
            else {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( this.key_validation, this.getValue() );
            }
            this.setMessage( _validator );
            this.need_validation = false;
            return true;
        }
        return false;
    },
    addValidationRule       : function ( to_add, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                if ( !this.validation_rules ) {
                    this.validation_rules = [];
                }
                this.validation_rules.push( to_add );
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                if ( !this.validation_rules_not_focus ) {
                    this.validation_rules_not_focus = [];
                }
                this.validation_rules_not_focus.push( to_add );
                break;
        }
        
    },
    setValidationRules      : function ( to_set, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                this.validation_rules = to_set;
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                this.validation_rules_not_focus = to_set;
                break;
        }
    },
    computeNeedValidation   : function () {
        if ( this.need_validation ) {
            return;
        }
        if ( this.current_value !== this.getDomValue() ) {
            this.need_validation = true;
        }
    },
    getValidationRules      : function ( ignore_focus ) {
        if ( !this.validation_rules && !this.validation_rules_not_focus ) {
            return null;
        }
        if ( ignore_focus ) {
            return this.validation_rules_not_focus || this.validation_rules;
        }
        if ( !this.hasFocus() && this.validation_rules_not_focus ) {
            return this.validation_rules_not_focus;
        }
        return this.validation_rules;
    },
    hasFocus                : function () {
        return DOM.Service.hasFocus( this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Input, SHINKEN.OBJECT.CounterInterface );
COMPONENT.Label           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.Label.prototype = {
    init       : function ( dom_element ) {
        this.dom_element = dom_element;
        this.label       = dom_element.outerText;
    },
    updateLabel: function ( to_set ) {
        this.label                 = to_set;
        this.dom_element.innerHTML = this.label;
    }
};
COMPONENT.KeyValueLine           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.KeyValueLine.prototype = {
    initSpecific    : function () {
        this.inputs[ 'shinken-key-line' ]   = 0;
        this.inputs[ 'shinken-value-line' ] = 1;
    },
    initSpecificEnd : function () {
        this.inputs[ 'shinken-key-line' ].key_validation += "KEY_" + this.inputs[ 'shinken-key-line' ].key_validation;
    },
    getValue        : function () {
        if ( !this.inputs[ 'shinken-value-line' ].getValue() ) {
            this.updateCfgDomElement();
            return "";
        }
        var _to_return = this.inputs[ 'shinken-key-line' ].getValue();
        _to_return += this.separator_key_value_saved;
        _to_return += this.inputs[ 'shinken-value-line' ].getValue();
        this.updateCfgDomElement();
        return _to_return;
    },
    setValueFromUser: function ( value ) {
        switch ( this.getParentName() ) {
            case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                var _last_index = value.length - 1;
                this.setValue( value[ _last_index ] );
                value.splice( _last_index, 1 );
                this.setKey( SHINKEN.TOOLS.ARRAY.join( value, this.separator_key_value_html ) );
                break;
            default:
                console.warn("key_value_line.js", "setValueFromUser  : [note implemented for ]", this.getParentName() );
        }
    },
    setKey          : function ( to_set ) {
        this.inputs[ 'shinken-key-line' ].setValueFromJs(to_set);
    },
    setValue        : function ( to_set ) {
        this.inputs[ 'shinken-value-line' ].setValueFromJs(to_set);
    },
    getCfgValue     : function () {
        return SHINKEN.TOOLS.STRING.cleanXss(this.inputs[ 'shinken-key-line' ].getValue()) + this.separator_key_value_html + SHINKEN.TOOLS.STRING.cleanXss(this.inputs[ 'shinken-value-line' ].getValue());
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.KeyValueLine, 'COMPONENT.KeyValueLine' );
COMPONENT.OutputRule           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.OutputRule.prototype = {
    initSpecific            : function ( dom_element ) {
        this.inputs[ 'shinken-input-container-cell' ] = 0;
        this.selectors[ 'shinken-matching' ]          = PROPERTY.CONST.TYPES.SINGLE_SELECT;
        this.selectors[ 'shinken-final' ]             = PROPERTY.CONST.TYPES.SINGLE_SELECT;
    },
    setValueFromUser        : function ( _data ) {
        var _size = _data.length;
        switch ( _size ) {
            case 1:
                this.setMatchingValueFromUser( _data[ 0 ] );
                break;
            case 2:
                this.setMatchingValueFromUser( _data[ 0 ] );
                this.setStatutFinal( _data[ 1 ] );
                break;
        }
    },
    setRegexpInput          : function ( to_set ) {
        this.inputs[ 'shinken-input-container-cell' ].setValueFromJs(to_set);
    },
    setStatutMatching       : function ( to_set ) {
        if ( this.selectors[ 'shinken-matching' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'shinken-matching' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'shinken-matching' ].computeTitle();
        }
    },
    setStatutFinal          : function ( to_set ) {
        if ( this.selectors[ 'shinken-final' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'shinken-final' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'shinken-final' ].computeTitle();
        }
    },
    getValue                : function () {
        var _to_return = this.selectors[ 'shinken-matching' ].getValue();
        if ( this.inputs[ 'shinken-input-container-cell' ].getValue() ) {
            _to_return += "/";
            _to_return += this.inputs[ 'shinken-input-container-cell' ].getValue();
            _to_return += "/";
        }
        _to_return += this.separator_key_value_saved + this.selectors[ 'shinken-final' ].getValue();
        return _to_return;
    },
    setMatchingValueFromUser: function ( data ) {
        var _indexes = SHINKEN.TOOLS.STRING.getAllIndexOf( data, '/' );
        var _size    = _indexes.length;
        
        if ( !_size ) {
            this.setStatutMatching( data );
            return;
        }
        this.setStatutMatching( data.substring( 0, _indexes[ 0 ] ).trim() );
        var _regex_value;
        switch ( _size ) {
            case 1:
                _regex_value = data.substring( _indexes[ 0 ] + 1 );
                break;
            case 2:
                _regex_value = data.substring( _indexes[ 0 ] + 1, _indexes[ 1 ] );
                break;
            default:
                _regex_value = data.substring( _indexes[ 0 ], _indexes[ _size - 1 ] );
                break;
        }
        this.setRegexpInput( _regex_value );
    },
    getCfgValue             : function () {
        return SHINKEN.TOOLS.STRING.cleanXss(this.getValue());
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.OutputRule, 'COMPONENT.OutputRule' );
COMPONENT.TimePeriodDayLine           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.TimePeriodDayLine.prototype = {
    initSpecific    : function () {
        this.inputs[ 'shinken-value-line' ] = 0;
        this.selectors[ 'week' ]            = PROPERTY.CONST.TYPES.SINGLE_SELECT;
        this.selectors[ 'month' ]           = PROPERTY.CONST.TYPES.SINGLE_SELECT;
    },
    getValue        : function () {
        var _to_return = this.inputs[ 'shinken-value-line' ].getValue();
        if ( !_to_return ) {
            this.updateCfgDomElement();
            return _to_return;
        }
        _to_return += this.separator_key_value_saved;
        _to_return += this.selectors[ 'week' ].getValue();
        var _month = this.selectors[ 'month' ].getValue();
        if ( _month !== PROPERTY.CONST.TIMEPERIOD.NO_MONTH ) {
            _to_return += this.separator_key_value_saved;
            _to_return += _month;
        }
        this.updateCfgDomElement();
        return _to_return;
    },
    setValueFromUser: function ( value ) {
        var _elements = value.split( this.separator_key_value_saved );
        var _size     = _elements.length;
        this.setInputValue( _elements[ 0 ] );
        this.setWeek( _elements[ 1 ] );
        if ( _size === 3 ) {
            this.setWeek( _elements[ 2 ] );
        }
    },
    setInputValue   : function ( to_set ) {
        this.inputs[ 'shinken-value-line' ].setValueFromJs(to_set);
    },
    setWeek         : function ( to_set ) {
        if ( this.selectors[ 'week' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'week' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'week' ].computeTitle();
        }
    },
    setMonth        : function ( to_set ) {
        if ( this.selectors[ 'month' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'month' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'month' ].computeTitle();
        }
    },
    getCfgValue     : function () {
        var _to_return = this.parent_name + this.separator_key_value_html + this.selectors[ 'week' ].getValue();
        var _month     = this.selectors[ 'month' ].getValue();
        if ( _month !== PROPERTY.CONST.TIMEPERIOD.NO_MONTH ) {
            _to_return += this.separator_key_value_html + _month;
        }
        _to_return += this.separator_key_value_html + SHINKEN.TOOLS.STRING.cleanXss(this.inputs[ 'shinken-value-line' ].getValue());
        return _to_return;
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.TimePeriodDayLine, 'COMPONENT.TimePeriodDayLine' );
COMPONENT.UrlLine           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.UrlLine.prototype = {
    initSpecific    : function ( dom_element ) {
        this.inputs[ 'shinken-name-urlmulti' ] = 0;
        this.inputs[ 'shinken-url-urlmulti' ]  = 1;
        this.selectors[ 'icon-url' ]           = PROPERTY.CONST.TYPES.SINGLE_SELECT;
        this.selectors[ 'popupping' ]          = PROPERTY.CONST.TYPES.SINGLE_SELECT;
    },
    setValueFromUser: function ( _data ) {
        var _size = _data.length;
        switch ( _size ) {
            case 1:
                this.setName( _data[ 0 ] );
                this.setUrl( _data[ 0 ] );
                break;
            case 2:
                this.setName( _data[ 0 ] );
                this.setUrl( _data[ 1 ] );
                break;
            case 4:
                var _name = _data[ 0 ] ? _data[ 0 ] : _data[ 1 ];
                this.setName( _name );
                this.setUrl( _data[ 1 ] );
                this.setIcon( _data[ 2 ].trim() );
                this.setDisplayType( _data[ 3 ].trim() );
                break;
            default:
                return;
        }
    },
    setName         : function ( to_set ) {
        this.inputs[ 'shinken-name-urlmulti' ].setValueFromJs(to_set);
    },
    setUrl          : function ( to_set ) {
        this.inputs[ 'shinken-url-urlmulti' ].setValueFromJs(to_set);
    },
    setIcon         : function ( to_set ) {
        if ( this.selectors[ 'icon-url' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'icon-url' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'icon-url' ].computeTitle();
        }
    },
    setDisplayType  : function ( to_set ) {
        if ( this.selectors[ 'popupping' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'popupping' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'popupping' ].computeTitle();
        }
    },
    getValue        : function ( is_display_cfg ) {
        var _url = this.inputs[ 'shinken-url-urlmulti' ].getValue();
        if ( !is_display_cfg && !_url ) {
            return '';
        }
        var _to_return = '';
        _to_return += this.inputs[ 'shinken-name-urlmulti' ].getValue();
        _to_return += this.separator_key_value_saved;
        _to_return += _url;
        _to_return += this.separator_key_value_saved;
        _to_return += this.selectors[ 'icon-url' ].getValue();
        _to_return += this.separator_key_value_saved;
        _to_return += this.selectors[ 'popupping' ].getValue();
        return _to_return;
    },
    addInput        : function ( _current_key ) {
        this.inputs[ _current_key ] = new COMPONENT.Input( this.dom_element.querySelector( "." + _current_key + " .shinken-input" ), this, false, _current_key );
    },
    getCfgValue     : function () {
        return SHINKEN.TOOLS.STRING.cleanXss(this.getValue( true ));
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.UrlLine, 'COMPONENT.UrlLine' );
COMPONENT.ListSelectElement           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.ListSelectElement.prototype = {
    init               : function ( dom_element ) {
        this.is_filtered   = false;
        this.reason_to_set = [];
        if ( dom_element ) {
            this.dom_element = dom_element;
            this.dom_title   = dom_element.querySelector( '.' + 'shinken-option-title' );
            this.initElement();
            this.is_selected = dom_element.classList.contains( 'shinken-selected' );
        }
    },
    initElement        : function () {
        this.element = new OBJECT.ElementList();
        this.element.setName( this.dom_element.dataset.keyName, this.dom_element );
        this.element.setLabel( this.dom_element.dataset.keyLabel );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setUUID( this.dom_element.dataset.uuid );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsHiddenForAdminSi( this.dom_element.dataset.isHiddenForAdminSi );
    },
    getElement         : function () {
        return this.element;
    },
    getDomElement      : function () {
        return this.dom_element;
    },
    getName            : function () {
        return this.element.getName();
    },
    getLabel           : function () {
        return this.element.getLabel();
    },
    getState           : function () {
        return this.element.getState();
    },
    getTextContent     : function () {
        return this.dom_title.textContent;
    },
    getTextContentShort: function () {
        return this.dom_title.dataset.label;
    },
    setSelected        : function ( _to_set, extra_class, reason ) {
        if ( !reason ) {
            reason = "shinken-main-selector";
        }
        if ( _to_set ) {
            SHINKEN.TOOLS.ARRAY.addElement( this.reason_to_set, reason );
            this.dom_element.classList.add( 'shinken-selected' );
            if ( extra_class ) {
                DOM.Service.addClasses( this.dom_element, extra_class );
            }
        }
        else {
            SHINKEN.TOOLS.ARRAY.removeElement( this.reason_to_set, reason );
            if ( this.reason_to_set.length ) {
                return;
            }
            this.dom_element.classList.remove( 'shinken-selected' );
            this.dom_element.classList.remove( 'shinken-select-focused' );
            this.dom_element.classList.remove( 'shinken-select-no-events' );
            if ( extra_class ) {
                DOM.Service.removeClasses( this.dom_element, extra_class );
            }
        }
        this.is_selected = _to_set;
    },
    isSelected         : function () {
        return this.is_selected;
    },
    setIsFiltered      : function ( to_set ) {
        this.is_filtered = to_set;
        if ( to_set ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
    },
    doFilter           : function ( filter ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin && this.element.is_hidden_for_admin_si ) {
            return false;
        }
        if ( !filter ) {
            this.setIsFiltered( false );
            return this.element.type === OBJECT.CONST.ELEMENT_LIST.TYPE.USER;
        }
        if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this.element.getName(), filter ) ) {
            this.setIsFiltered( false );
            return true;
        }
        else {
            this.setIsFiltered( true );
            return false;
        }
    },
    updateHtmlLabel    : function ( label ) {
        this.element.setLabel( label );
        this.dom_element.innerHTML = this.getLabel();
    }
};
COMPONENT.ListSelect           = function ( dom_element, parent_name, allow_multiple_select ) {
    this.init( dom_element, parent_name, allow_multiple_select );
};
COMPONENT.ListSelect.prototype = {
    init                                : function ( dom_element, parent_name, allow_multiple_select ) {
        allow_multiple_select = !!allow_multiple_select;
        this.dom_element      = dom_element;
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element_counter_research      = dom_element.querySelector( '.shinken-counter-current' );
        this.dom_element_counter_total         = dom_element.querySelector( '.shinken-counter-total' );
        this.dom_element_input_research        = dom_element.querySelector( '.shinken-input-search' );
        this.dom_element_display_research      = dom_element.querySelector( '.shinken-display-search .shinken-value' );
        this.dom_element_select_content        = dom_element.querySelector( '.list-select-content' );
        this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        this.state                             = COMPONENT.CONST.BTN_STATE.OFF;
        this.parent_name                       = parent_name;
        this.allow_multiple_select             = allow_multiple_select;
        this.initListElement();
    },
    initListElement                     : function () {
        this.list                     = [];
        this.list_mapping             = {};
        this.nbr_in_list_after_filter = 0;
        var _list_element             = this.dom_element.querySelectorAll( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION );
        this.size_list                = _list_element.length;
        for ( var i = 0; i < this.size_list; i++ ) {
            this.list[ i ]                                = new COMPONENT.ListSelectElement( _list_element[ i ] );
            this.list_mapping[ this.list[ i ].getName() ] = i;
        }
    },
    toggleStateSelectedInList           : function ( key_name, class_to_add ) {
        var _index               = this.list_mapping[ key_name ];
        var _list_select_element = this.list[ _index ];
        _list_select_element.setSelected( !_list_select_element.is_selected, class_to_add );
        return _list_select_element.getElement();
    },
    unselectAllElement                  : function ( extra_class ) {
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            _current.setSelected( false, extra_class );
        }
    },
    doChangeFilterSelect                : function () {
    
    },
    addNewElementUnknown                : function ( key_name, prop_name ) {
        var _to_add    = DOM.Service.createElement( 'div', {
                class               : COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION,
                "data-state"        : "unknown",
                "data-key-name"     : key_name,
                "data-key-label"    : key_name,
                "data-type"         : "user",
                "data-is-disabled"  : "false",
                "data-force-to-null": "false",
                "data-uuid"         : "",
                onclick             : "MANAGER.EventManager.clickOnItemSelector('event','" + prop_name + "', this)"
            },
            "<span class='shinken-space'>" + key_name + " ( " + _( 'element.unknown' ) + " )" + "</span>"
        );
        var _to_return = new COMPONENT.ListSelectElement( _to_add );
        this.addNewElement( key_name, _to_return );
        return _to_return;
    },
    addNewElement                       : function ( key_name, list_select_element ) {
        this.list[ this.size_list ]              = list_select_element;
        this.list_mapping[ key_name ]            = this.size_list;
        this.dom_element_counter_total.innerHTML = parseInt( this.dom_element_counter_total.innerHTML ) + 1;
        this.size_list++;
        this.dom_element_select_content.appendChild( list_select_element.dom_element );
    },
    getElement                          : function ( key_name ) {
        var _index = this.list_mapping[ key_name ];
        if ( _index === undefined ) {
            return null;
        }
        return this.list[ _index ].getElement();
    },
    getListSelectElement                : function ( key_name ) {
        var _index = this.list_mapping[ key_name ];
        return this.list[ _index ];
    },
    getSelectedElements                 : function () {
        var _to_return = [];
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                _to_return.push( _current_element );
            }
        }
        return _to_return;
    },
    getFirstSelectedElement             : function ( exclude_hidden ) {
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                if ( exclude_hidden && _current_element.dom_element.classList.contains( "shinken-hidden" ) ) {
                    continue;
                }
                return _current_element;
            }
        }
        return null;
    },
    setState                            : function ( state ) {
        this.state = state;
        this.setLastAutoSelectElement( false );
        return this.state;
    },
    focusOnResearchInput                : function () {
        if ( this.dom_element_input_research ) {
            this.dom_element_input_research.focus();
            if ( this.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.doFilter( this.current_filter );
            }
        }
    },
    setResearchDisplay                  : function ( value ) {
        if ( this.dom_element_display_research ) {
            this.dom_element_display_research.innerHTML = value;
        }
    },
    toggleState                         : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
            default:
                console.error( "Error::toggleState is outside its perimeter" );
        }
        return this.state;
    },
    doFilter                            : function ( filter ) {
        if ( this.current_filter && filter === this.current_filter ) {
            return;
        }
        this.current_filter           = filter;
        this.nbr_in_list_after_filter = 0;
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            if ( _current.doFilter( filter ) ) {
                this.nbr_in_list_after_filter++;
            }
        }
        if ( filter ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        if ( this.nbr_in_list_after_filter ) {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        else {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        if ( this.dom_element_counter_research ) {
            this.dom_element_counter_research.innerHTML = this.nbr_in_list_after_filter;
        }
        this.setLastAutoSelectElement( false );
        
    },
    cleanFilter                         : function () {
        this.dom_element_input_research.value = "";
        this.doFilter( '' );
    },
    addNewElementList                   : function ( value ) {
        var _to_add = new COMPONENT.ListSelectElement( _list_element[ i ] );
    },
    hasAutoSelect                       : function () {
        return this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND;
    },
    setLastAutoSelectElement            : function ( to_set, action_type, avoid ) {
        if ( to_set ) {
            DOM.ScrollService.bindWith( this.dom_element_select_content, this.list[ this.current_index_auto_select_element ].dom_element, this.previous_position_vertical, action_type );
            this.list[ this.current_index_auto_select_element ].dom_element.classList.add( 'shinken-select-focused' );
        }
        else {
            if ( !avoid ) {
                this.previous_position_vertical = 0;
            }
            if ( this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND ) {
                if ( !avoid ) {
                    this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.list[ this.current_index_auto_select_element ].dom_element, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                }
                this.list[ this.current_index_auto_select_element ].dom_element.classList.remove( 'shinken-select-focused' );
            }
            this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        }
    },
    selectSelectedOrFirstFilteredElement: function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            this.updateLastAutoSelectIndex( SHINKEN.TOOLS.ARRAY.findFirstIndexWith( this.list, "is_filtered", false ), COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.KEY_INPUT );
        }
    },
    validAutoSelect                     : function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            return false;
        }
        this.list[ this.current_index_auto_select_element ].dom_element.click();
        this.setLastAutoSelectElement( false );
        return true;
    },
    moveAutoSelectCursor                : function ( move_down ) {
        if ( this.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            return;
        }
        if ( !this.size_list ) {
            return;
        }
        var action_type = move_down ? COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN : COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP;
        var _dom_target = this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ? null : this.list[ this.current_index_auto_select_element ].dom_element;
        
        if ( !DOM.ScrollService.isVisible( this.dom_element_select_content, _dom_target, 0, action_type ) ) {
            var _dom_element;
            if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
                _dom_element = DOM.ScrollService.getFirstVisibleDom( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            else {
                _dom_element = DOM.ScrollService.getCloserVisibleDomFromMiddle( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            if ( _dom_element ) {
                this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.dom_element_select_content, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                this.updateLastAutoSelectIndex( this.list_mapping[ _dom_element.dataset.keyName ], action_type, true );
            }
            return;
        }
        var _current_counter = this.current_index_auto_select_element;
        var _current;
        var _found           = false;
        
        while ( move_down ? _current_counter < this.size_list : _current_counter >= COMPONENT.CONST.NOT_FOUND ) {
            move_down ? _current_counter++ : _current_counter--;
            _current = this.list[ _current_counter ];
            if ( !_current ) {
                this.updateLastAutoSelectIndex( this.current_index_auto_select_element, action_type );
                continue;
            }
            var _display = DOM.Service.getComputedStyle( _current.dom_element, DOM.CONST.STYLE.DISPLAY );
            if ( _display === DOM.CONST.VALUE.NONE ) {
                continue;
            }
            if ( _current.isSelected() && !this.allow_multiple_select ) {
                continue;
            }
            _found = true;
            break;
        }
        if ( _found ) {
            this.updateLastAutoSelectIndex( _current_counter, action_type );
        }
    },
    updateLastAutoSelectIndex           : function ( index, action_type, avoid ) {
        var _type = "";
        switch ( action_type ) {
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOUSE:
                if ( this.prevent_mouse_enter ) {
                    return;
                }
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN:
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
                this.prevent_mouse_enter = true;
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP:
                this.prevent_mouse_enter = true;
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_TOP;
                break;
        }
        if ( this.prevent_mouse_enter ) {
            var _self = this;
            if ( this.timeout_mouse_down ) {
                clearTimeout( this.timeout_mouse_down );
            }
            this.timeout_mouse_down = setTimeout( function () {
                _self.prevent_mouse_enter = false;
                _self.timeout_mouse_down  = null;
            }, 200 );
        }
        this.setLastAutoSelectElement( false, _type, avoid );
        this.current_index_auto_select_element = index;
        this.setLastAutoSelectElement( true, _type );
    }
};
COMPONENT.ListTag           = function ( dom_element, parent_name ) {
    this.init( dom_element, parent_name );
    
};
COMPONENT.ListTag.prototype = {
    init                          : function ( dom_element, parent_name ) {
        this.dom_element = dom_element;
        this.initTags( parent_name );
    },
    initTags                      : function ( parent_name ) {
        this.tags         = [];
        this.tags_mapping = {};
        
        var _list_tags_element = this.dom_element.querySelectorAll( '.shinken-container-tag' );
        if ( !_list_tags_element ) {
            this.size_tags = 0;
            return;
        }
        
        this.size_tags = _list_tags_element.length;
        for ( var i = 0; i < this.size_tags; i++ ) {
            this.tags[ i ]                                = new COMPONENT.Tag( _list_tags_element[ i ], parent_name );
            this.tags_mapping[ this.tags[ i ].getName() ] = i;
        }
    },
    reset                         : function () {
        this.tags         = [];
        this.tags_mapping = {};
        this.size_tags    = 0;
    },
    addTag                        : function ( parent_name, element_list ) {
        fire_element_is_modifie();
        var _tag = new COMPONENT.Tag();
        _tag.setElement( element_list );
        var _dom_to_add = _tag.buildHTMLParent( parent_name, this.size_tags, element_list.getItemType() );
        _tag.setTooltip();
        this.tags[ this.size_tags ]         = _tag;
        this.tags_mapping[ _tag.getName() ] = this.size_tags;
        DOM.Service.addElementTo( _dom_to_add, this.dom_element );
        this._computeMapping();
    },
    deleteTag                     : function ( element_list ) {
        fire_element_is_modifie();
        var _name  = element_list.getName();
        var _tag   = this.getTagByName( _name );
        var _index = this.tags_mapping[ _name ];
        DOM.Service.removeParentIfHasClassOrElement( _tag.getDomElement(), 'droppable' );
        this.tags.splice( _index, 1 );
        this._computeMapping();
    },
    _computeMapping               : function () {
        this.size_tags    = this.tags.length;
        this.tags_mapping = {};
        for ( var i = 0; i < this.size_tags; i++ ) {
            this.tags_mapping[ this.tags[ i ].getName() ] = i;
            this.tags[ i ].setIndexParentDomElement( i );
        }
        if ( this.isEmpty() ) {
            this.dom_element.classList.add( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-hidden' );
        }
    },
    addTags                       : function ( tags ) {
        this.tags      = [];
        this.size_tags = tags.length;
        var _current;
        for ( var i = 0; i < this.size_tags; i++ ) {
            _current = tags[ i ].clone();
            var _add = true;
            for ( var j = 0, _size = this.tags.length; j < _size; j++ ) {
                if ( this.tags[ j ].getName() === _current.getName() ) {
                    _add = false;
                    break;
                }
            }
            if ( _add ) {
                this.tags.push( _current );
                this.dom_element.appendChild( _current.getDomElement() );
            }
        }
        this._computeMapping();
    },
    getTagByName                  : function ( key_name ) {
        var _index = this.tags_mapping[ key_name ];
        if ( _index === undefined ) {
            return null;
        }
        return this.getTagByIndex( _index );
    },
    getTagByIndex                 : function ( index ) {
        return this.tags[ index ];
    },
    isEmpty                       : function () {
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( !this.tags[ i ].isHidden() ) {
                return false;
            }
        }
        return true;
    },
    emptyList                     : function () {
        this.reset();
        this.dom_element.innerHTML = '';
    },
    getValue                      : function () {
        var _to_return = '';
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( i ) {
                _to_return += ',';
            }
            _to_return += this.getTagByIndex( i ).getName();
        }
        return _to_return;
    },
    getTags                       : function () {
        return this.tags;
    },
    hasTag                        : function ( key_name ) {
        return this.tags_mapping[ key_name ] !== undefined;
    },
    getSizeTags                   : function () {
        return this.size_tags;
    },
    hasUserTag                    : function () {
        for ( var i = 0; i < this.size_tags; i++ ) {
            switch ( this.tags[ i ].element.name ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    break;
                default:
                    return true;
            }
        }
        return false;
    },
    getMissingItemSelectorWith    : function ( property ) {
        var _to_return = [];
        var _selected  = Object.keys( property.getSelector().list_element_selected.tags_mapping );
        var _size = _selected.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = _selected[ i ];
            if ( _current === PROPERTY.CONST.CUSTOM_SELECT.NONE ||
                 _current === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ||
                 _current === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ) {
                continue;
            }
            if ( this.tags_mapping[ _current ] === undefined ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    getExtraItemSelectorWith      : function ( property ) {
        var _to_return             = [];
        var _property_tags_mapping = property.getSelector().list_element_selected.tags_mapping;
        var _selected              = Object.keys( this.tags_mapping );
        var _size                  = _selected.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = _selected[ i ];
            if ( _property_tags_mapping[ _current ] === undefined ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    dragStartShinken              : function ( key_name ) {
        this.dragged_tag = this.getTagByName( key_name );
        this.dragged_tag.setDragging( true );
        return this;
    },
    getDragged                    : function () {
        return this.dragged_tag;
    },
    resetDragging                 : function () {
        if ( this.dragged_tag ) {
            this.dragged_tag.setDragging( false );
            this.dragged_tag = null;
        }
    },
    changeElementPosition         : function ( index_1, index_2 ) {
        index_1 = parseInt( index_1 );
        index_2 = parseInt( index_2 );
        if ( index_1 < index_2 ) {
            for ( var i = index_1, _size = index_2; i < _size; i++ ) {
                this.switchElement( i, i + 1 );
            }
        }
        else if ( index_1 > index_2 ) {
            for ( var i = index_1 - 1, _size = index_2; i >= _size; i-- ) {
                this.switchElement( i, i + 1 );
            }
        }
    },
    switchElement                 : function ( index_1, index_2 ) {
        var _element_1 = this.getTagByIndex( index_1 );
        var _element_2 = this.getTagByIndex( index_2 );
        if ( !_element_1 || !_element_2 ) {
            return;
        }
        DOM.Service.switchElementParent( _element_1.getDomElement(), _element_2.getDomElement() );
        SHINKEN.TOOLS.ARRAY.swap( this.tags, index_1, index_2 );
        this.tags_mapping[ _element_1.getName() ] = index_2;
        this.tags_mapping[ _element_2.getName() ] = index_1;
    },
    disabledTagsOutOfLimit        : function ( limit ) {
        var _stop = this.size_tags;
        if ( limit >= 0 ) {
            _stop = this.size_tags - limit;
            _stop = (_stop >= 0) ? _stop : this.size_tags;
        }
        var i;
        var _current;
        for ( i = 0; i < _stop; i++ ) {
            _current = this.getTagByIndex( i );
            _current.removeClass( 'disabled' );
            _current.setMessageTooltip( '' );
        }
        for ( i = this.size_tags - 1; i >= _stop; i-- ) {
            _current = this.getTagByIndex( i );
            _current.addClass( 'disabled' );
            _current.setMessageTooltip( _( 'property_multiselect.tooltip_limit_reached' ) );
        }
    },
    getErrors                     : function ( prop_name ) {
        var _to_return = 0;
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( this.getTagByIndex( i ).isError( prop_name ) ) {
                _to_return++;
            }
        }
        return _to_return;
    },
    getWarnings                   : function ( prop_name ) {
        var _to_return = 0;
        for ( var i = 0; i < this.size_tags; i++ ) {
            if ( this.getTagByIndex( i ).isWarning( prop_name ) ) {
                _to_return++;
            }
        }
        return _to_return;
    },
    isAllElementsSelectedDisabled : function () {
        var _size = this.tags.length;
        var _current_element;
        if ( !_size ) {
            return false;
        }
        for ( var i = 0; i < _size; i++ ) {
            _current_element = this.tags[ i ].element;
            if ( !_current_element.is_disabled &&
                 _current_element.state !== COMPONENT.CONST.TAG.STATE.NEW &&
                 _current_element.state !== COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
                return false;
            }
        }
        return true;
    },
    hasInvalidElementForProduction: function () {
        var _size = this.tags.length;
        var _current_element;
        if ( !_size ) {
            return false;
        }
        for ( var i = 0; i < _size; i++ ) {
            _current_element = this.tags[ i ].element;
            if ( _current_element.is_disabled ||
                 _current_element.state === COMPONENT.CONST.TAG.STATE.NEW ||
                 _current_element.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
                return true;
            }
        }
        return false;
    },
    getListToString               : function ( prop_name ) {
        var _to_return = [];
        for ( var i = 0; i < this.size_tags; i++ ) {
            _to_return.push( this.tags[ i ].getName() );
        }
        return _to_return;
    }
};
COMPONENT.Select           = function ( dom_element, type, is_override, parent, datasetLink, allow_multiple_select ) {
    this.type                  = type;
    this.is_override           = is_override;
    this.allow_multiple_select = !!allow_multiple_select;
    this.init( dom_element, parent );
    this.setDataSetLink( datasetLink );
    this.__class = SHINKEN.TOOLS.CLASS.CONST.COMPONENT.SELECT;
};
COMPONENT.Select.prototype = {
    
    init                          : function ( dom_element, parent ) {
        this.dom_element             = dom_element;
        this.dom_select              = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR );
        this.dom_link_icon_container = this.dom_select.querySelector( '.shinken-link-icon-container' );
        this.dom_link_icon_button    = this.dom_select.querySelector( '.shinken-link-icon-button' );
        var _dom_list_select         = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST );
        this.list_element            = new COMPONENT.ListSelect( _dom_list_select, parent.getParentName(), this.allow_multiple_select );
        this.initSearchElement();
        this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        if ( this.type === PROPERTY.CONST.TYPES.MULTI_SELECT ) {
            var _dom_list_selected       = dom_element.querySelector( '.shinken-list-selected-in-select' );
            var _dom_list_inherited      = dom_element.querySelector( '.list-inherited' );
            var _dom_list_override       = dom_element.querySelector( '.shinken-list-override' );
            this.list_element_selected   = new COMPONENT.ListTag( _dom_list_selected, parent.name );
            this.list_elements_inherited = new COMPONENT.ListTag( _dom_list_inherited );
            this.list_element_override   = new COMPONENT.ListTag( _dom_list_override );
        }
        this.initCounters( parent );
    },
    initSearchElement             : function () {
        var _dom = this.dom_element.querySelector( ".shinken-input-search" );
        if ( _dom ) {
            this.component_input_search = new COMPONENT.Input( _dom );
        }
    },
    updateWithTemplateSpecific    : function ( tags ) {
        this.list_elements_inherited.addTags( tags );
    },
    hidePopup                     : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    openSelector                  : function () {
        if ( this.list_element.state === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.clickOnSelector();
        }
    },
    clickOnSelector               : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
        this.list_element.focusOnResearchInput();
    },
    clickOnItemSelector           : function ( parent_name, key_name, class_to_add ) {
        this.setLastSelectedElementName( key_name );
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                var _element = this.list_element.toggleStateSelectedInList( key_name, class_to_add );
                this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.getActiveListForUser().addTag( parent_name, _element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.clickOnItemSelector( key_name );
                break;
        }
    },
    clickOnDeleteItemSelector     : function ( key_name ) {
        var _element = this.list_element.toggleStateSelectedInList( key_name );
        this.getActiveListForUser().deleteTag( _element );
    },
    askComputeAfterChange         : function ( dom_element ) {
        switch ( dom_element.name ) {
            case 'multi-search':
                this.component_input_search.askComputeAfterChange( dom_element, this );
                break;
        }
    },
    doActionAfterChange           : function ( args ) {
        this.doFilter( this.component_input_search.getValue() );
    },
    dragStartShinken              : function ( type_element, key_name ) {
        switch ( type_element ) {
            case PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM:
                return this.getActiveListForUser().dragStartShinken( key_name );
        }
    },
    resetDragging                 : function () {
        this.list_element_selected.resetDragging();
    },
    setTitle                      : function ( _to_set ) {
        var _dom_text       = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        this.title          = _to_set;
        _dom_text.innerHTML = this.title;
    },
    setResearchDisplay            : function ( _to_set ) {
        this.list_element.setResearchDisplay( _to_set );
    },
    isSet                         : function () {
        return !this.getActiveListForUser().isEmpty();
    },
    cleanAllTags                  : function () {
        this.getActiveListForUser().emptyList();
    },
    getActiveListForUser          : function () {
        if ( this.is_override ) {
            return this.list_element_override;
        }
        else {
            return this.list_element_selected;
        }
    },
    cleanAllItemsSelected         : function ( extra_class ) {
        this.list_element.unselectAllElement( extra_class );
    },
    getValue                      : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                return this.getActiveListForUser().getValue();
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                return this.getLastSelectedElementName();
        }
    },
    getValueToSave                : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                return this.getTagsValueToSave();
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                if ( this.last_selected_key_name ) {
                    return this.getLastSelectedElement().getElement().getValueFinal();
                }
                return;
        }
    },
    getTagsValueToSave            : function () {
        var _to_return = [];
        var _tags      = this.getActiveListForUser().getTags();
        for ( var i = 0, size = _tags.length; i < size; i++ ) {
            _to_return.push( _tags[ i ].getValueFinal() );
        }
        return _to_return;
    },
    computeTitle                  : function ( add_extra, extra_label ) {
        if ( this.last_selected_key_name === undefined ) {
            var _selected = this.list_element.getSelectedElements();
            if ( _selected[ 0 ] !== undefined ) {
                this.setLastSelectedElementName( _selected[ 0 ].element.name );
            }
        }
        var _selected_element = this.getLastSelectedElement();
        var _title_to_set     = '';
        if ( _selected_element ) {
            _title_to_set = _selected_element.element.getLabel();
        }
        if ( extra_label ) {
            _title_to_set += extra_label;
        }
        this.setTitle( _title_to_set );
    },
    getLastSelectedElement        : function () {
        return this.list_element.getListSelectElement( this.last_selected_key_name );
    },
    getLastSelectedElementName    : function () {
        return this.last_selected_key_name || '';
    },
    setLastSelectedElementName    : function ( to_set ) {
        if ( this.last_selected_key_name ) {
            this.previous_selected_key_name = this.last_selected_key_name;
        }
        this.last_selected_key_name = to_set;
    },
    hasTag                        : function ( name ) {
        return !this.list_element_selected.hasTag( name ) || !this.list_elements_inherited.hasTag( name );
    },
    getMissingItemSelectorWith    : function ( property ) {
        return this.list_element_selected.getMissingItemSelectorWith( property );
    },
    getExtraItemSelectorWith      : function ( property ) {
        return this.list_element_selected.getExtraItemSelectorWith( property );
    },
    setMaximumSelected            : function ( to_set ) {
        this.maximum_selected = to_set;
    },
    getMaximumSelected            : function () {
        return this.maximum_selected;
    },
    isLimitReached                : function () {
        return (this.getActiveListForUser().getSizeTags() + this.list_elements_inherited.getSizeTags() - this.maximum_selected);
    },
    isLimitReachedForSelected     : function () {
        return (this.getActiveListForUser().getSizeTags() - this.maximum_selected);
    },
    disabledTagsOutOfLimit        : function ( limit ) {
        this.list_elements_inherited.disabledTagsOutOfLimit( limit );
    },
    getErrors                     : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterError().counter_final;
        return _to_return;
    },
    getWarnings                   : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterWarning().counter_final;
        return _to_return;
    },
    setMessage                    : function ( message ) {
        var _status = COMPONENT.CONST.STATUS.NONE;
        if ( typeof message === 'string' ) {
            _status = COMPONENT.CONST.STATUS.INFO;
        }
        else if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [ 0, 0 ];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.INFO:
                this.addShinkenTooltip( "", message );
                break;
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    addShinkenTooltip             : function ( type, message ) {
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', message );
        message ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setStatus                     : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    setDataSetLink                : function ( to_set ) {
        this.dataSetLink = to_set;
        if ( this.dataSetLink ) {
            this.computeTitle();
        }
    },
    getDataSetLink                : function () {
        return this.dataSetLink;
    },
    getListElement                : function () {
        return this.list_element;
    },
    doFilter                      : function ( filter ) {
        this.list_element.doFilter( filter );
    },
    doChangeFilterSelect          : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.doChangeFilterSelect();
                break;
        }
    },
    cleanFilter                   : function () {
        this.list_element.cleanFilter();
    },
    validOrCreateTag              : function ( name_element, prop_name ) {
        var _existing = this.list_element.getListSelectElement( name_element );
        if ( _existing ) {
            return _existing;
        }
        return this.list_element.addNewElementUnknown( name_element, prop_name );
    },
    buildLinkOpenNewTab           : function ( link, id ) {
        var _span_link                         = '<span class="shinken-link-icon-button"><span class="shinken-link-icon shinicon shinicon-open"></span></span>';
        this.dom_link_icon_container.innerHTML = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( link, id, _span_link, "shinken-link" ).outerHTML;
    },
    pulsateTag                    : function ( name ) {
        var _existing = this.getActiveListForUser().getTagByName( name );
        if ( _existing ) {
            _existing.pulsateTag();
        }
        else if ( this.list_elements_inherited ) {
            _existing = this.list_elements_inherited.getTagByName( name );
            if ( _existing ) {
                _existing.pulsateTag();
            }
        }
    },
    hasAutoSelect                 : function () {
        return this.list_element.hasAutoSelect();
    },
    moveAutoSelectCursor          : function ( move_down ) {
        this.list_element.moveAutoSelectCursor( move_down );
    },
    validAutoSelect               : function () {
        return this.list_element.validAutoSelect();
    },
    isAllElementsSelectedDisabled : function () {
        return this.getActiveListForUser().isAllElementsSelectedDisabled();
    },
    hasInvalidElementForProduction: function () {
        return this.getActiveListForUser().hasInvalidElementForProduction();
    },
    validSelectedOrFirstElement   : function () {
        this.list_element.selectSelectedOrFirstFilteredElement();
        this.validAutoSelect();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Select, SHINKEN.OBJECT.CounterInterface );
COMPONENT.RadioList           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.RadioList.prototype = {
    init           : function ( dom_element ) {
        this.mapping_radio_button = {};
        this.initRadioList( dom_element );
    },
    initRadioList  : function ( dom_element ) {
        var _list_dom_radio_button = dom_element.querySelectorAll( '.shinken-radio-btn' );
        var _current_button;
        
        for ( var i = 0, size_list_button = _list_dom_radio_button.length; i < size_list_button; i++ ) {
            _current_button                                         = new COMPONENT.Button( _list_dom_radio_button[ i ] );
            this.mapping_radio_button[ _current_button.getValue() ] = _current_button;
            if ( _current_button.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.active_button = _current_button;
            }
        }
        
    },
    clickOnRadioBtn: function ( value ) {
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this.active_button = this.getRadioButton( value );
        this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
    },
    getRadioButton : function ( value ) {
        return this.mapping_radio_button[ value ];
    },
    getValue       : function () {
        return this.active_button.getValue();
    },
    isDefaultOn    : function () {
        var _button = this.getRadioButton( PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
        if ( _button ) {
            return _button.isOn();
        }
        return false;
    },
};
COMPONENT.TagInformation           = function ( dom_element ) {
    this.params = [];
    if ( dom_element ) {
        this.status = dom_element.dataset.status;
        this.initDomElement( dom_element );
    }
    else {
        this.buildHtml();
        this.status = '';
    }
};
COMPONENT.TagInformation.prototype = {
    initDomElement: function ( dom_element ) {
        this.dom_element       = dom_element;
        this.dom_element_label = this.dom_element.querySelector( '.shinken-label-information' );
    },
    setStatus     : function ( to_set ) {
        if ( this.status === to_set ) {
            return;
        }
        this.status                     = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
        var _tooltip                    = "";
        var _tooltip_type               = "";
        var _innerHTML                  = "";
        switch ( this.status ) {
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.ALL_DISABLED:
                _tooltip      = _( 'element.information_only_disable_tags_tooltip' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.WARNING_BORDER;
                _innerHTML    = _( 'element.information_only_disable_tags' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.ALL_DISABLED_OVERRIDE:
                _tooltip      = _( 'element.information_only_disable_tags_override_tooltip' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.WARNING_BORDER;
                _innerHTML    = _( 'element.information_only_disable_tags' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER:
                _tooltip      = _( 'element.error-will-not-through-arbiter-tooltip' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.ERROR_BORDER;
                _innerHTML    = _( 'element.error-will-not-through-arbiter' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.USER_GROUP_COHERENCY:
                _tooltip      = _( 'element.beware_user_groups_coherency' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
                _innerHTML    = _( 'element.error-will-not-through-arbiter' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.IN_SHELL:
                _tooltip      = _( 'element.tooltip_shell' );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
                _innerHTML    = _( 'element.beware' );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.CHECK_DUPLICATE:
                _tooltip      = SHINKEN.TOOLS.STRING.format( _( 'element.check_duplicate_on_the_same' ), this.params[ 0 ] );
                _tooltip_type = SHINKEN_TOOLTIP.TYPE.ERROR_BORDER;
                _innerHTML    = _( 'element.error-will-not-through-arbiter' );
                break;
            default:
                break;
        }
        this.dom_element.setAttribute( 'shi-tip-html', _tooltip );
        this.dom_element.setAttribute( 'shi-tip-type', _tooltip_type );
        this.dom_element_label.innerHTML = _innerHTML;
    },
    buildHtml     : function () {
        var _to_return = DOM.Service.createElement( 'span', { class: 'shinken-information-tag', onmouseenter: 'SHINKEN_TOOLTIP.showTooltip(this)', onmouseleave: 'SHINKEN_TOOLTIP.hideTooltip()' } );
        DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: 'shinken-label-information' } ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: 'shinken-tag-mark' }, '?' ), _to_return );
        this.initDomElement( _to_return );
    },
    setParams     : function ( to_set ) {
        this.params = to_set;
    }
};
COMPONENT.Tag           = function ( dom_element, parent_name ) {
    this.init( dom_element, parent_name );
};
COMPONENT.Tag.prototype = {
    init                    : function ( dom_element, parent_name ) {
        if ( dom_element ) {
            this.dom_element = dom_element;
            this.initElement( parent_name );
        }
    },
    initElement             : function ( parent_name ) {
        this.element = new OBJECT.ElementList();
        this.element.setName( this.dom_element.dataset.keyName );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setUUID( this.dom_element.dataset.uuid );
        if ( parent_name === PROPERTY.CONST.NAME.EDITION_CONTACTS && this.dom_element.classList.contains( 'shinken-tag-disabled' ) ) {
            this.text_tooltip = _( 'element.tooltip_edition_contact_not_expert' );
        }
        this.setTooltip();
    },
    setTooltip              : function ( text_tooltip ) {
        var _text = text_tooltip || this.element.getTooltip() || this.text_tooltip || '';
        this.dom_element.querySelector( 'tbody' ).setAttribute( "shi-tip-html", _text );
    },
    getDomElement           : function () {
        return this.dom_element;
    },
    isDefaultTag            : function () {
        return this.element.getName() === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
    },
    isNullTag               : function () {
        return this.element.getName() === PROPERTY.CONST.CUSTOM_SELECT.NONE;
    },
    getName                 : function () {
        return this.element.getName();
    },
    getLabel                : function () {
        return this.element.getLabel() || this.getName();
    },
    updateTagWithNoneTags   : function ( to_set ) {
        this.element.setLabel( to_set, this.dom_element );
        this.buildHTML();
    },
    setLabel                : function ( to_set ) {
        this.element.setLabel( to_set, this.dom_element.querySelector( '.title' ) );
        this.dom_element.querySelector( '.title' ).innerHTML = to_set;
    },
    getState                : function () {
        return this.element.getState();
    },
    setState                : function ( to_set ) {
        this.element.setState( to_set );
        DOM.Service.setDataSet( this.dom_element, 'state', to_set );
    },
    getType                 : function () {
        return this.element.getType();
    },
    setElement              : function ( to_set ) {
        this.element = to_set;
    },
    isDeletable             : function () {
        return (this.getType() !== 'inheritance');
    },
    isHidden                : function () {
        return this.element.getState() === COMPONENT.CONST.TAG.STATE.HIDDEN;
    },
    clone                   : function () {
        var _to_return         = new COMPONENT.Tag();
        _to_return.dom_element = this.dom_element.cloneNode( true );
        _to_return.element     = this.element.clone();
        return _to_return;
    },
    setIndexParentDomElement: function ( index ) {
        if ( !this.dom_element ) {
            return;
        }
        var _parent = DOM.Service.findParentElementWithClass( this.dom_element, 'droppable', 3 );
        if ( !_parent ) {
            return;
        }
        _parent.dataset.index = index;
    },
    
    pulsateTag : function () {
        DOM.Service.askAddClass( this.dom_element, "shinken-pulsate", 2000 );
    },
    setDragging: function ( _to_set ) {
        this.is_dragging = _to_set;
        var self         = this;
        setTimeout( function () {
            if ( _to_set ) {
                self.dom_element.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.DISCREET );
            }
            else {
                self.dom_element.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.DISCREET );
            }
        }, 0 );
    },
    
    setMessageTooltip: function ( message ) {
        this.dom_element.querySelector( 'tbody' ).setAttribute( "shi-tip-html", message );
    },
    addClass         : function ( label ) {
        this.dom_element.classList.add( label );
    },
    removeClass      : function ( label ) {
        this.dom_element.classList.remove( label );
    },
    isError          : function ( prop_name ) {
        if ( prop_name === PROPERTY.CONST.NAME.USE ) {
            return this.element.getState() === OBJECT.CONST.TEMPLATE.STATUS.BADLOOP;
        }
        if ( this.element.getState() === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            return true;
        }
        if ( this.element.getState() === COMPONENT.CONST.TAG.STATE.IT_SELF ) {
            return true;
        }
        return false;
    },
    isWarning        : function ( prop_name ) {
        if ( prop_name === PROPERTY.CONST.NAME.USE ) {
            return false;
        }
        var _to_return = this.element.is_disabled || this.element.is_force_to_null;
        if ( !_to_return ) {
            if ( this.element.shinken_element ) {
                _to_return = this.element.shinken_element.is_new;
            }
            else if ( this.element.state === COMPONENT.CONST.TAG.STATE.NEW ) {
                _to_return = true;
            }
        }
        return _to_return;
    },
    buildHTMLParent  : function ( parent_name, index, link ) {
        var _to_return = DOM.Service.createElement( 'div', {
            class       : 'droppable',
            'data-index': index,
            ondrop      : 'MANAGER.DragNDropManager.dropShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '", "' + parent_name + '", this)',
            ondragend   : 'MANAGER.DragNDropManager.dragEndShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '")',
            ondragover  : 'MANAGER.DragNDropManager.dragOverShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '", "' + parent_name + '", this)'
        } );
        this.buildHTML( parent_name, link );
        DOM.Service.addElementTo( this.dom_element, _to_return );
        return _to_return;
    },
    buildHTML        : function ( parent_name, link, full_link ) {
        var dom_param = {
            class               : 'shinken-container-tag',
            'data-key-name'     : this.getName(),
            'data-state'        : this.getState(),
            'data-is-disabled'  : this.element.is_disabled,
            'data-force-to-null': this.element.is_force_to_null,
            'data-type'         : this.getType()
        };
        
        if ( parent_name && this.getType() === OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            dom_param[ 'class' ]       = 'shinken-container-tag ' + MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGABLE;
            dom_param[ 'draggable' ]   = true;
            dom_param[ 'ondragstart' ] = 'MANAGER.DragNDropManager.dragStartShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '", "' + parent_name + '", "' + this.getName() + '")';
        }
        if ( parent_name === PROPERTY.CONST.NAME.EDITION_CONTACTS ) {
            if ( !this.element.shinken_element ) {
                this.element.findShinkenElement();
            }
            if ( this.element.shinken_element && !this.element.shinken_element.is_admin && !this.element.shinken_element.is_expert ) {
                dom_param[ 'class' ] = dom_param[ 'class' ] + ' shinken-tag-disabled';
                this.text_tooltip    = _( 'element.tooltip_edition_contact_not_expert' );
            }
        }
        
        var _line        = DOM.Service.createElement( 'tr', { class: 'text-break-all-pre-line' } );
        var _col_content = DOM.Service.createElement( 'td', { class: 'content' } );
        var _col_cube    = DOM.Service.createElement( 'td', { class: 'shinken-tag-cube' } );
        var _title;
        if ( this.element.shinken_element ) {
            _title = SHINKEN.TOOLS.buildLinkShinkenElement( this.element.shinken_element );
        }
        else if ( this.getState() === COMPONENT.CONST.TAG.STATE.INHERITED && full_link ) {
            _title = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( full_link[ 0 ] || '', full_link[ 1 ] || '', this.getLabel() );
        }
        else {
            var _final_id = this.element.uuid;
            switch ( this.element.state ) {
                case COMPONENT.CONST.TAG.STATE.NEW :
                case COMPONENT.CONST.TAG.STATE.OVERRIDE_NEW :
                    _final_id = this.element.uuid + '?new=1';
                    break;
            }
            _title = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( link, _final_id, this.getLabel() );
        }
        var _tbody = DOM.Service.createElement( 'tbody' ); // Tag
        _tbody.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
        _tbody.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        _tbody.setAttribute( "shi-tip-html", '' );
        _tbody.setAttribute( "shi-tip-placement", "bottom" );
        
        this.dom_element = DOM.Service.createElement( 'table', dom_param ); // Tag
        
        var _temp_table =  DOM.Service.createElement( 'table' );
        var _temp_tr =  DOM.Service.createElement( 'tr' );
        var _temp_td =  DOM.Service.createElement( 'td' );
        DOM.Service.addElementTo( _temp_table, _col_content );
        DOM.Service.addElementTo( _temp_tr, _temp_table );
        DOM.Service.addElementTo( _temp_td, _temp_tr );
        DOM.Service.addElementTo( _title, _temp_td );
        if ( this.isDeletable() ) {
            var _temp_td_2 =  DOM.Service.createElement( 'td' );
            var _to_close = DOM.Service.createElement( 'span', {
                class  : 'shinken-close-icon',
                onclick: 'MANAGER.EventManager.clickOnDeleteItemSelector("' + parent_name + '","' + this.getName() + '")'
            }, 'x' );
            DOM.Service.addElementTo( _temp_td_2, _temp_tr );
            DOM.Service.addElementTo( _to_close, _temp_td_2 );
        }
        DOM.Service.addElementTo( _col_content, _line );
        DOM.Service.addElementTo( _col_cube, _line );
        DOM.Service.addElementTo( _line, _tbody );
        DOM.Service.addElementTo( _tbody, this.dom_element );
    },
    getValueFinal    : function () {
        return this.element.getValueFinal();
    }
};
SHINKEN_LIST.MassAction           = function ( dom_element ) {
    this.name = SHINKEN_LIST.CONST.MASS_ACTION.NAME;
    this.init( dom_element );
};
SHINKEN_LIST.MassAction.prototype = {
    init: function ( dom_element ) {
        this.dom_element = dom_element;
        
        var _dom_button              = this.dom_element.querySelector( '#btn-action-launch' );
        var _dom_button_with_comment = this.dom_element.querySelector( '#btn-action-launch-add-comment' );
        
        this.component_select                     = new COMPONENT.Select( this.dom_element.querySelector( '#id-shinken-select-mass-action' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this );
        this.component_button_launch              = new COMPONENT.Button( _dom_button );
        this.component_button_launch_with_comment = new COMPONENT.Button( _dom_button_with_comment );
    },
    
    clickOnSelector              : function () {
        this.component_select.clickOnSelector();
    },
    clickOnItemSelector          : function ( event, parent_name, dom_element ) {
        var _key_name = dom_element.dataset.keyName;
        this.component_select.clickOnItemSelector( parent_name, _key_name );
        var _current_counter = MANAGER.__instance_counter_distributor.findCounter( dom_element.dataset.state + '-' + _key_name );
        this.computeTitleSelect( _current_counter );
        this._enabledButtonAction( _key_name );
    },
    computeTitleSelect           : function ( _current_counter ) {
        if ( _current_counter && _current_counter.counter_final ) {
            this.component_select.computeTitle( false, ' <span class="shinken-counter-label shinken-between-bracket">' + _current_counter.counter_final + '</span>' );
        }
        else {
            this.component_select.clickOnItemSelector( "", "ALL" );
            this.component_select.computeTitle();
            this._disabledButtonAction();
        }
    },
    getSelectedAction            : function () {
        return this.component_select.getSelectedAction();
    },
    resetMassAction              : function () {
        this._disabledButtonAction();
        close_comment_to_launch_select_action( true );
    },
    hidePopup                    : function () {
        this.component_select.hidePopup();
    },
    _enabledButtonAction         : function ( key_name ) {
        this.component_button_launch.setState( COMPONENT.CONST.BTN_STATE.OFF );
        var _state = COMPONENT.CONST.BTN_STATE.DISABLED;
        switch ( key_name ) {
            case ACTIONS.SUBMIT:
            case ACTIONS.REJECT:
                _state = COMPONENT.CONST.BTN_STATE.OFF;
                break;
        }
        this.component_button_launch_with_comment.setState( _state );
    },
    _disabledButtonAction        : function () {
        this.component_button_launch.setState( COMPONENT.CONST.BTN_STATE.DISABLED );
        this.component_button_launch_with_comment.setState( COMPONENT.CONST.BTN_STATE.DISABLED );
    },
    getParentName                : function () {
        return this.name;
    },
    reinitCounter: function ( name ) {
        var _current_counter = MANAGER.__instance_counter_distributor.findCounter( SHINKEN_LIST.CONST.MASS_ACTION.WORK_AREA_NAME + '-' + name );
        if ( _current_counter ){
            _current_counter.reset();
        }
        _current_counter = MANAGER.__instance_counter_distributor.findCounter( SHINKEN_LIST.CONST.MASS_ACTION.NAME + '-' + name );
        if ( _current_counter ){
            _current_counter.reset();
        }
    },
    updateMassActonCountSelect: function ( data ) {
        var _list_action = Object.keys( data );
        var _size_action = _list_action.length;
        var _current_action_name;
        var _current_counter;
        var _current_actions;
        var _size;
        
        for ( var i = 0; i < _size_action; i++ ) {
            _current_action_name = _list_action[ i ];
            _current_actions     = data[ _current_action_name ];
            _size                = _current_actions.length;
            this.reinitCounter(_current_action_name);
            for ( var j = 0; j < _size; j++ ) {
                if ( _current_actions[ j ][ 0 ].dataset.itemType === OBJECT.CONST.ELEMENT.TYPE.HOSTS ) {
                    _current_counter = MANAGER.__instance_counter_distributor.findCounter( SHINKEN_LIST.CONST.MASS_ACTION.WORK_AREA_NAME + '-' + _current_action_name );
                }
                else {
                    _current_counter = MANAGER.__instance_counter_distributor.findCounter( SHINKEN_LIST.CONST.MASS_ACTION.NAME + '-' + _current_action_name );
                }
                if ( _current_counter ) {
                    _current_counter.toggle_parent_activity = true;
                    _current_counter.update( _current_actions[ j ][ 0 ].id, 1 );
                }
            }
            if ( _current_action_name === this.component_select.last_selected_key_name ) {
                this.computeTitleSelect( _current_counter );
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.MassAction, SHINKEN.OBJECT.CounterInterface );
SHINKEN_LIST.Filter           = function ( dom_element, type ) {
    this.setType( type );
    this.init( dom_element );
};
SHINKEN_LIST.Filter.prototype = {
    init                   : function ( dom_element ) {
        this.dom_element = dom_element;
        this.name        = this.dom_element.dataset.name;
        this._is_active  = false;
        if ( this.dom_element.dataset.type ) {
            this.setType( this.dom_element.dataset.type );
        }
        this.initComponents();
    },
    initComponents         : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                this.component = new COMPONENT.Select( this.dom_element, PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case SHINKEN_LIST.CONST.FILTER.TYPE.INPUT_STRING_ARRAY:
                this.component = new COMPONENT.Input( this.dom_element.querySelector( ".shinken-input" ), this );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.component = new COMPONENT.InputWithDropDown( this.dom_element, this, true );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_NOT_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS );
                break;
        }
    },
    setType                : function ( to_set ) {
        switch ( to_set ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                to_set = PROPERTY.CONST.TYPES.SINGLE_SELECT;
                break;
        }
        this.type = to_set;
    },
    getUuid                : function () {
        return this.name;
    },
    isValid                : function () {
        return (this.name && this.type);
    },
    isSet                  : function () {
        this._computeState();
        return this.isActive();
    },
    getParentName          : function () {
        return this.name;
    },
    getValue               : function () {
        return this.component.getValue();
    },
    getName                : function () {
        return this.name;
    },
    getFinalValue          : function () {
        return this.component.getFinalValue();
    },
    setActive              : function ( to_set ) {
        to_set = !!to_set;
        if ( to_set ) {
            this.dom_element.classList.add( 'shinken-active' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
        }
        this._is_active = to_set;
    },
    isActive               : function () {
        return !!this._is_active;
    },
    setValue               : function ( to_set ) {
        this.component.setValueFromJs( to_set );
    },
    getListElement         : function () {
        return this.component.getListElement();
    },
    getComponents          : function () {
        return [ this.component ];
    },
    initWhenInputReady     : function () {
        var self = this;
        setTimeout( function () {
            self.component.validateValueInput();
            self._computeState();
            DOM.Service.setDataSet( self.dom_element, 'inputStatus', self.component.getStatus() );
        }, 300 );
    },
    clickOnSelector        : function () {
        this.component.clickOnSelector();
    },
    clickOnItemSelector    : function ( key_name, dom_element, selector, event ) {
        this.component.clickOnItemSelector( '', key_name, event );
        this._computeState();
        this.hidePopup();
        
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                this.component.computeTitle();
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                var forced = !(key_name !== '');
                CONTROLLER.List.getFilterAndReload( forced );
                break;
        }
    },
    doChangeFilterSelect   : function () {
        this.component.doChangeFilterSelect();
    },
    askComputeAfterChange  : function ( dom_element, parent, args ) {
        this.component.askComputeAfterChange( dom_element, parent || this, args );
    },
    doActionAfterChange    : function ( args ) {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                return;
        }
        this.component.computeAfterChange();
        this._computeState();
        DOM.Service.setDataSet( this.dom_element, 'inputStatus', this.component.getStatus() );
        switch ( args.controller_name ) {
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                CONTROLLER.List.updateCleanButtonStatus();
                break;
        }
    },
    clickChangeFilterSelect: function () {
        this.component.clickChangeFilterSelect();
    },
    clickOnInput           : function () {
        this.component.clickOnInput();
    },
    hidePopup              : function () {
        this.setNeedValidation( true );
        this.doActionAfterChange({});
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                this.component.hidePopup();
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.component.hidePopup();
                break;
        }
    },
    _computeState          : function () {
        var _value = this.getValue();
        if ( _value === SHINKEN_LIST.CONST.FILTER.ALL ) {
            _value = false;
        }
        this.setActive( !!_value );
    },
    validateValueInput     : function () {
        this.component.validateValueInput();
    },
    keydown                : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.ENTER:
                if ( this.component.hasAutoSelect() ) {
                    event.stopPropagation();
                    event.preventDefault();
                    this.component.validSelectedOrFirstElement();
                }
                else {
                    this.component.finishActionBeforeReload();
                    CONTROLLER.List.getFilterAndReload( true );
                }
                break;
            default:
                this.component.keydown( event, key_code );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Filter, SHINKEN.OBJECT.CounterInterface );
SHINKEN_LIST.Filters           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Filters.prototype = {
    init                 : function ( dom_element ) {
        this.initContents( dom_element.querySelectorAll( '.shinken-list-filter' ) );
    },
    initContents         : function ( dom_elements ) {
        this.contents = {};
        var _current;
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            _current = new SHINKEN_LIST.Filter( dom_elements[ i ], this.type );
            if ( _current.isValid() ) {
                this.contents[ _current.getName() ] = _current;
            }
        }
    },
    getFilter            : function ( name ) {
        return this.contents[ name ];
    },
    getActiveFilters     : function () {
        var _to_return = [];
        var _keys      = Object.keys( this.contents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( this.contents[ _current_key ].isSet() ) {
                _to_return.push( this.contents[ _current_key ] );
            }
        }
        return _to_return;
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( dom_element, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getFilter( _parent_dom_element.dataset.name ).askComputeAfterChange( dom_element, parent || this, { 'type': _type } );
                break;
        }
    },
    clickOnSelector      : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                var _to_return = this.getFilter( _parent_dom_element.dataset.name );
                _to_return.clickOnSelector( _parent_dom_element );
                return _to_return;
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _option             = DOM.Service.findParentElementWithDataSet( event.target, 'keyName', 10 );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getFilter( _parent_dom_element.dataset.name ).clickOnItemSelector( _option.dataset.keyName, _parent_dom_element, false, event );
                break;
        }
    },
    hidePopup            : function ( exception ) {
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( exception !== this.contents[ _keys[ i ] ] ) {
                this.contents[ _keys[ i ] ].hidePopup();
            }
        }
    }
};
SHINKEN_LIST.Header           = function ( type, dom_element ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Header.prototype = {
    init: function ( dom_element ) {
        this.dom_element = dom_element;
        if ( dom_element ) {
            this.name  = dom_element.dataset.headerName;
            this.label = dom_element.innerText;
        }
    }
};
SHINKEN_LIST.Line           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Line.prototype = {
    init                  : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_filtered = this.dom_element.classList.contains( "shinken-is-filtered" ) ? SHINKEN_LIST.CONST.FILTER.STATUS.ON : SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        this.is_collapse = false;
        this.uuid        = this.dom_element.dataset.uuid;
        
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.host    = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidItem ) );
                this.parent  = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidParent ) );
                this.check   = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeCheck, this.dom_element.dataset.uuidCheck ) );
                this.dfe_key = this.dom_element.dataset.dfeKey;
                break;
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.parent_uuid           = this.dom_element.dataset.uuidParent;
                this.parent_select_element = DOM.Service.findParentElementWithClass( this.dom_element, this.dom_element.dataset.parentSelectClass, 20 );
                break;
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.uuid = this.dom_element.dataset.name;
                break;
        }
        this.initIsSelected();
        this.initCellsValue();
    },
    initIsSelected        : function () {
        if ( this.dom_element.classList.contains( "shinken-selected-disabled" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        else if ( this.dom_element.classList.contains( "shinken-selected" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
        }
        else {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_selected_counter = new SHINKEN.OBJECT.Counter();
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                if ( !this.parent_uuid ) {
                    this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_element_selected );
                }
                this.updateSelectionCounter();
                if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                    this.initCounters( CONTROLLER.MassChange.steps.get().button_next, true );
                }
                break;
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_checks_selected );
                break;
        }
    },
    initCellsValue        : function () {
        this.cell_value = {};
        var _cells      = this.dom_element.querySelectorAll( ".shinken-list-cell" );
        var _current;
        for ( var i = 0, _size_i = _cells.length; i < _size_i; i++ ) {
            _current = _cells[ i ];
            if ( _current.dataset.filterValueArray ) {
                this.cell_value[ _current.dataset.filter ] = _current.dataset.filterValueArray.split( "," );
            }
            else if ( _current.dataset.filterValue ) {
                this.cell_value[ _current.dataset.filter ] = _current.dataset.filterValue;
            }
            else {
                if ( _current.dataset.filter ) {
                    this.cell_value[ _current.dataset.filter ] = DOM.Service.getInnerText( _current );
                }
                else {
                    this.cell_value[ i ] = DOM.Service.getInnerText( _current );
                }
            }
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.cell_value[ 'data_name_array' ] = this.uuid;
                break;
        }
    },
    applyFilter           : function ( filters ) {
        var _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        for ( var i = 0, _size_i = filters.length; i < _size_i; i++ ) {
            var _value_filter = filters[ i ].getValue();
            var _value_cell   = this.cell_value[ filters[ i ].getName() ];
            switch ( _value_cell ) {
                case SHINKEN_LIST.CONST.FILTER.HAS_CHILDREN:
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN;
                    continue;
            }
            var _type_filter = filters[ i ].type;
            switch ( _type_filter ) {
                case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                    if ( _value_filter === SHINKEN_LIST.CONST.FILTER.ALL ) {
                        break;
                    }
                    else if ( _value_filter === SHINKEN_LIST.CONST.FILTER.NOT_EMPTY ) {
                        if ( Array.isArray( _value_cell ) ) {
                            if ( SHINKEN.TOOLS.ARRAY.contains( _value_cell, SHINKEN_LIST.CONST.FILTER.EMPTY ) ) {
                                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                            }
                        }
                        else if ( _value_cell === SHINKEN_LIST.CONST.FILTER.EMPTY ) {
                            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                        }
                        break;
                    }
                    if ( Array.isArray( _value_cell ) ) {
                        if ( !SHINKEN.TOOLS.ARRAY.contains( _value_cell, _value_filter ) ) {
                            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                        }
                    }
                    else if ( _value_cell !== _value_filter ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
                case PROPERTY.CONST.TYPES.STRING_INPUT:
                    if ( !SHINKEN.TOOLS.STRING.containsIgnoreCase( _value_cell, _value_filter ) ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
                case SHINKEN_LIST.CONST.FILTER.TYPE.INPUT_STRING_ARRAY:
                    var _list  = _value_filter.split( "," );
                    var _found = false;
                    for ( var j = 0, _size_j = _list.length; j < _size_j; j++ ) {
                        if ( _list[ j ] === _value_cell ) {
                            _found = true;
                            break;
                        }
                    }
                    if ( !_found ) {
                        _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                    }
                    break;
            }
        }
        this.setFilter( _filter );
    },
    setFilter             : function ( to_set ) {
        this.is_filtered = to_set;
        switch ( this.is_filtered ) {
            case SHINKEN_LIST.CONST.FILTER.STATUS.ON:
                this.dom_element.classList.add( "shinken-is-filtered" );
                break;
            case SHINKEN_LIST.CONST.FILTER.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-is-filtered" );
                break;
        }
    },
    isFiltered            : function () {
        return this.is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.ON;
    },
    getUUID               : function () {
        return this.uuid;
    },
    toggleSelect          : function () {
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
                break;
        }
    },
    setIsSelected         : function ( to_set ) {
        if ( this.is_filtered ) {
            return;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return;
        }
        this.is_selected = to_set;
        this.updateSelectionCounter();
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.dom_element.classList.add( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.add( "shinken-selected-parent" );
                }
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.remove( "shinken-selected-parent" );
                }
                break;
        }
        
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                switch ( this.is_selected ) {
                    case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                        this.showCountersForParent();
                        break;
                    default:
                        this.hideCountersForParent();
                        break;
                }
        }
        
    },
    updateSelectionCounter: function () {
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.is_selected_counter.update( this.uuid, this.isSelected() ? 1 : 0 );
                break;
        }
    },
    setDataSet            : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        if ( if_key ) {
            if ( if_function === "matching_regex" ) {
                if ( !SHINKEN.TOOLS.STRING.isMatchingStarRegexTab( this.cell_value[ if_key ], if_values ) ) {
                    data_value = else_data_value;
                }
            }
            else {
                if ( !SHINKEN.TOOLS.STRING.containsAny( this.cell_value[ if_key ], if_values ) ) {
                    data_value = else_data_value;
                }
            }
        }
        DOM.Service.setDataSet( this.dom_element, datakey, data_value );
    },
    isSelected            : function () {
        return this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
    },
    isSelectedOrFiltered  : function () {
        if ( this.is_filtered ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        return this.is_selected;
    },
    getData               : function ( key ) {
        return this.dom_element.dataset[ key ];
    },
    getCellValue          : function ( key ) {
        return this.cell_value[ key ];
    },
    changeElementValue    : function ( key, to_set ) {
        if ( this.getCellValue( key ) !== undefined ) {
            this.dom_element.querySelector( '.shinken-list-cell[data-filter="' + key + '"]' ).innerHTML = to_set;
        }
    },
    toggleCollapse        : function ( childrens ) {
        this.setIsCollapsed( !this.is_collapse );
        for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
            childrens[ i ].setIsCollapsed( this.is_collapse );
        }
    },
    setIsCollapsed        : function ( to_set, childrens ) {
        this.is_collapse = to_set;
        if ( this.is_collapse ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
        if ( childrens ) {
            for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
                childrens[ i ].setIsCollapsed( this.is_collapse );
            }
        }
    },
    getDataToSave         : function ( type ) {
        var _to_return;
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                switch ( type ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                        _to_return       = {};
                        _to_return.value = this.isSelected() ? true : false;
                        if ( this.dom_element.dataset.originalSelected === "1" ) {
                            _to_return.value = !_to_return.value;
                        }
                        _to_return.check_link = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        break;
                    default:
                        _to_return      = [];
                        _to_return[ 0 ] = this.host.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 1 ] = this.parent.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 2 ] = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 3 ] = this.dfe_key;
                        break;
                }
            
        }
        return _to_return;
    },
    getDataToExport       : function ( headers ) {
        var _to_return = [];
        var _current;
        for ( var i = 0, _size_i = headers.length; i < _size_i; i++ ) {
            _to_return.push( this.getCellValue( headers[ i ] ) || "" );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.CounterInterface );
SHINKEN_LIST.FACTORY_HTML.Line = function ( uuid, line_data, headers ) {
    var _to_return = DOM.Service.createElement( "tr", { class: "shinken-list-line", "data-uuid": uuid } );
    for ( var i = 0, _size_i = line_data.length; i < _size_i; i++ ) {
        DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-filter": headers[ i ].name }, line_data[ i ] ), _to_return );
    }
    return _to_return;
};
SHINKEN_LIST.Lines           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Lines.prototype = {
    init                      : function ( dom_element ) {
        this.initContents( dom_element.querySelectorAll( '.shinken-list-line' ) );
    },
    initContents              : function ( dom_elements ) {
        this.contents        = [];
        this.mapping         = {};
        this.mapping_parents = {};
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.add( dom_elements[ i ] );
        }
    },
    addMappingParent          : function ( parent_uuid, uuid ) {
        if ( !parent_uuid ) {
            if ( !this.mapping_parents[ uuid ] ) {
                this.mapping_parents[ uuid ] = [];
            }
        }
        else {
            if ( !this.mapping_parents[ parent_uuid ] ) {
                this.mapping_parents[ parent_uuid ] = [];
            }
            this.mapping_parents[ parent_uuid ].push( this.mapping[ uuid ] );
        }
    },
    removeMappingParent       : function ( parent_uuid, _to_remove ) {
        if ( parent_uuid ) {
            SHINKEN.TOOLS.ARRAY.removeElement( this.mapping_parents[ parent_uuid ], _to_remove );
        }
    },
    add                       : function ( dom_element ) {
        var _to_add = new SHINKEN_LIST.Line( dom_element, this.type );
        this.contents.push( _to_add );
        this.mapping[ _to_add.getUUID() ] = _to_add;
        this.addMappingParent( _to_add.parent_uuid, _to_add.uuid );
    },
    remove                    : function ( uuid ) {
        var _to_remove = this.mapping[ uuid ];
        delete this.mapping[ uuid ];
        this.removeMappingParent( _to_remove.parent_uuid, _to_remove );
        SHINKEN.TOOLS.ARRAY.removeElement( this.contents, _to_remove );
    },
    getByUUID                 : function ( uuid ) {
        return this.mapping[ uuid ];
    },
    toggleCollapse            : function ( uuid ) {
        this.mapping[ uuid ].toggleCollapse( this.mapping_parents[ uuid ] );
    },
    setIsCollapseAllData      : function ( to_set ) {
        var _keys = Object.keys( this.mapping_parents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.mapping[ _current_key ].setIsCollapsed( to_set, this.mapping_parents[ _current_key ] );
        }
    },
    setSelectAllData          : function ( to_set ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setIsSelected( to_set );
        }
    },
    getNbSelected             : function () {
        return this.getSelected().length;
    },
    getSelected               : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].isSelected() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getNotSelected               : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].is_selected !== SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    setAllLinesDataSet        : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
        }
    },
    isAllActiveLineSelected   : function () {
        var _nb_active = 0;
        var _current;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ].isSelectedOrFiltered();
            switch ( _current ) {
                case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                    _nb_active++;
                    break;
                case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                    return false;
            }
        }
        return !!_nb_active;
    },
    applyFilter               : function ( filters ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].applyFilter( filters );
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.filterParentWithNoChildren();
                break;
        }
    },
    filterParentWithNoChildren: function () {
        var _current;
        var _filter;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered !== SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN ) {
                continue;
            }
            if ( _current.parent_uuid ) {
                continue;
            }
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            for ( var j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
                if ( this.contents[ j ].parent_uuid === _current.getUUID() && this.contents[ j ].is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.OFF ) {
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
                    break;
                }
            }
            _current.setFilter( _filter );
        }
    },
    hideAllLines              : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setFilter( SHINKEN_LIST.CONST.FILTER.STATUS.ON );
        }
    },
    getNotFiltered               : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( !this.contents[ i ].isFiltered() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getDataToSave             : function ( type ) {
        var _to_return = type === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE ? {} : [];
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.isSelected() ) {
                switch ( this.type ) {
                    case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                        switch ( type ) {
                            case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                                _current_data = _current.getDataToSave( type );
                                if ( !_to_return[ _current.host.getUUID() ] ) {
                                    _to_return[ _current.host.getUUID() ] = [];
                                }
                                _to_return[ _current.host.getUUID() ].push( _current_data );
                                break;
                            
                            default:
                                _to_return.push( _current.getDataToSave( type ) );
                                break;
                        }
                        break;
                    default:
                        _to_return.push( _current.getDataToSave( type ) );
                        break;
                }
            }
        }
        return _to_return;
    },
    getDataToExport: function (headers) {
        var _to_return = [];
        var _to_add;
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered){
                continue;
            }
            _to_return.push(_current.getDataToExport(headers));
        }
        return _to_return;
    }
};
SHINKEN_LIST.Set           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
    this.edit_mode = false;
};
SHINKEN_LIST.Set.prototype = {
    init                 : function ( dom_element ) {
        this.dom_element = dom_element;
        this.initHeaders( this.dom_element.querySelectorAll( '.shinken-list-header' ) );
        this.filters               = new SHINKEN_LIST.Filters( dom_element, this.type );
        this.lines                 = new SHINKEN_LIST.Lines( dom_element, this.type );
        this.is_all_data_selected  = this.dom_element.classList.contains( "shinken-selected" ) ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        this.is_all_data_collapsed = false;
        this.updateHtml();
    },
    initHeaders          : function ( dom_elements ) {
        this.headers = [];
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.headers[ i ] = new SHINKEN_LIST.Header( this.type, dom_elements[ i ] );
        }
    },
    askComputeAfterChange: function ( dom_element ) {
        this.filters.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange  : function ( args ) {
        var _type = args['type'];
        switch ( _type ) {
            case 'shinken-list-filter':
                this.lines.applyFilter( this.filters.getActiveFilters() );
                this.setSelectAllStatus();
                break;
            case 'shinken-hide-all-element':
                this.lines.hideAllLines();
                break;
        }
    },
    clickOnCheckboxInput : function ( name ) {
        if ( name === "shinken-all-elements" ) {
            this.selectAllData( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ? SHINKEN_LIST.CONST.SELECTION.STATUS.OFF : SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
            return;
        }
        this.lines.mapping[ name ].toggleSelect();
        this.setSelectAllStatus();
    },
    clickOnCollapseButton: function ( uuid ) {
        if ( uuid === "shinken-all-elements" ) {
            this.collapseAllData( !this.is_all_data_collapsed );
            return;
        }
        this.setIsCollapseAllData( false );
        this.lines.toggleCollapse( uuid );
    },
    clickOnSelector      : function ( event ) {
        var _filter = this.filters.clickOnSelector( event );
        this.hidePopup( _filter );
    },
    clickOnItemSelector  : function ( event ) {
        this.filters.clickOnItemSelector( event );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        this.doActionAfterChange( {'type' : _parent_dom_element.dataset.objectType} );
    },
    setIsCollapseAllData : function ( to_set ) {
        this.is_all_data_collapsed = to_set;
        if ( this.is_all_data_collapsed ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
    },
    collapseAllData      : function ( to_set ) {
        this.setIsCollapseAllData( to_set );
        this.lines.setIsCollapseAllData( this.is_all_data_collapsed );
    },
    setSelectAllStatus   : function ( to_set ) {
        if ( to_set === undefined ) {
            to_set = this.lines.isAllActiveLineSelected() ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_all_data_selected = to_set;
        if ( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
            this.dom_element.classList.add( "shinken-selected" );
        }
        else {
            this.dom_element.classList.remove( "shinken-selected" );
        }
    },
    selectAllData        : function ( to_set ) {
        this.setSelectAllStatus( to_set );
        this.lines.setSelectAllData( this.is_all_data_selected );
    },
    getSelectedLines     : function () {
        return this.lines.getSelected();
    },
    getFirstSelectedLine : function () {
        var _to_return = this.getSelectedLines();
        if ( _to_return.length ) {
            return _to_return[ 0 ];
        }
        return null;
    },
    getNotSelectedLines  : function () {
        return this.lines.getNotSelected();
    },
    setAllLinesDataSet   : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        return this.lines.setAllLinesDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
    },
    addLine              : function ( dom_element ) {
        this.lines.add( dom_element );
        this.updateHtml();
    },
    removeLine           : function ( uuid ) {
        this.lines.remove( uuid );
        this.updateHtml();
    },
    getLineByUUID        : function ( uuid ) {
        return this.lines.getByUUID( uuid );
    },
    getSum               : function ( header_name ) {
        var _to_return = 0;
        var _lines     = this.lines.getNotFiltered();
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _to_return += parseInt( _lines[ i ].getCellValue( header_name ) || 0 );
        }
        return _to_return;
    },
    getSumBy             : function ( header_name, header_value ) {
        var _to_return = {};
        var _lines     = this.lines.getNotFiltered();
        var _current;
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _current = _lines[ i ].getCellValue( header_name );
            if ( !_to_return[ _current ] ) {
                _to_return[ _current ] = 0;
            }
            _to_return[ _current ] += parseInt( _lines[ i ].getCellValue( header_value ) || 0 );
        }
        return _to_return;
    },
    toggleEditionMode    : function () {
        this.edit_mode = !this.edit_mode;
        this.selectAllData(this.edit_mode? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF);
    },
    
    hidePopup            : function ( _filter ) {
        this.filters.hidePopup( _filter );
    },
    updateHtml           : function () {
        DOM.Service.setDataSet( this.dom_element, "numberLines", this.lines.contents.length );
    },
    getDataToSave        : function ( type ) {
        return this.lines.getDataToSave( type );
    },
    getDataToExport: function () {
        var _to_return = [];
        var _headers_name = [];
        var _headers_label = [];
        for ( var i = 0, _size_i = this.headers.length; i < _size_i; i++ ) {
            _headers_name.push(this.headers[i].name);
            _headers_label.push(this.headers[i].label);
        }
        _to_return.push(_headers_label);
        return SHINKEN.TOOLS.ARRAY.concat(_to_return, this.lines.getDataToExport(_headers_name));
    }
};
MANAGER.DistributorButtonManager           = function () {
    this.buttons = {};
};
MANAGER.DistributorButtonManager.prototype = {
    createButton: function ( name ) {
        var _id          = 'id-shinken-btn-' + name;
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = new COMPONENT.Button( _dom_element, name );
        _to_return.initCounters();
        this.setButton( name, _to_return );
        return _to_return;
    },
    delete      : function ( name ) {
        delete this.buttons[ name ];
    },
    findButton  : function ( name ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getButton( name );
        if ( !_to_return ) {
            _to_return = this.createButton( name );
        }
        return _to_return;
    },
    setButton   : function ( name, button ) {
        this.buttons[ name ] = button;
    },
    getButton   : function ( name ) {
        return this.buttons[ name ];
    },
    reset       : function () {
        this.buttons        = {};
    }
};
MANAGER.__instance_button_distributor      = new MANAGER.DistributorButtonManager();
MANAGER.DistributorControllerManager = (function ( self ) {
    "use strict";
    self.findControllerByEvent = function ( event, controller_name ) {
        var _controller = controller_name;
        if ( !_controller ) {
            var _target             = event.target;
            var _parent_dom_element = DOM.Service.findParentElementWithClass( _target, "shinken-parent-event-listener", 500 );
            if ( !_parent_dom_element ) {
                return;
            }
            _controller = _parent_dom_element.dataset.controller;
        }
        return self.getController(_controller);
    };
    self.getController         = function ( _controller ) {
        switch ( _controller ) {
            case MANAGER.CONST.CONTROLLER.MASS_CHANGE:
                return CONTROLLER.MassChange;
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                return CONTROLLER.List;
            case MANAGER.CONST.CONTROLLER.SHINKEN_ELEMENT:
                return CONTROLLER.ShinkenElement;
            case MANAGER.CONST.CONTROLLER.SOURCES:
                return CONTROLLER.Source;
            case "SHINKEN-TODO":
                break;
            default:
                console.warn( "NO CONTROLLER FOUND FOR ", "[" + _controller + "]" );
        }
    };
    return self;
})( MANAGER.DistributorControllerManager || {} );
MANAGER.DistributorCounterManager           = function () {
    this.counters = {};
};
MANAGER.DistributorCounterManager.prototype = {
    createCounter: function ( name ) {
        var _id          = 'id-shinken-' + name + '-counter';
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = new SHINKEN.OBJECT.Counter();
        _to_return.init( _dom_element );
        this.setCounter( name, _to_return );
        return _to_return;
    },
    delete       : function ( name ) {
        delete this.counters[ name ];
    },
    findCounter  : function ( name, reset ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getCounter( name );
        if ( reset && _to_return ){
            delete this.counters[ name ];
            _to_return= null;
        }
        if ( !_to_return ) {
            _to_return = this.createCounter( name );
        }
        return _to_return;
    },
    setCounter   : function ( name, button ) {
        this.counters[ name ] = button;
    },
    getCounter   : function ( name ) {
        return this.counters[ name ];
    },
    reset        : function () {
        this.counters = {};
    }
};
MANAGER.__instance_counter_distributor      = new MANAGER.DistributorCounterManager();
MANAGER.DistributorElementManager           = function () {
    this.current_element = null;
    this.current_user    = null;
    this.elements        = {};
    this.mapping_by_name = {};
    this.list_templates;
};
MANAGER.DistributorElementManager.prototype = {
    createElement                 : function ( datas ) {
        var _to_return = new OBJECT.ShinkenElement();
        _to_return.updateData( datas );
        this.addElement( _to_return );
        return _to_return;
    },
    findElement                   : function ( se_uuid, datas ) {
        if ( !se_uuid ) {
            return;
        }
        var _to_return = this.getElement( se_uuid );
        if ( !_to_return ) {
            _to_return = this.createElement( datas );
        }
        else {
            _to_return.updateData( datas );
        }
        return _to_return;
    },
    getElementByDict              : function ( object ) {
        return this.getElement( OBJECT.ShinkenElement.generateSEUUID( object[ OBJECT.CONST.ELEMENT.FIELD.ITEM_TYPE ], object[ OBJECT.CONST.ELEMENT.FIELD.UUID ] ) );
    },
    getElementByName              : function ( name ) {
        return this.getElement( this.mapping_by_name[ name ] );
    },
    getTypeElementWithName              : function ( shinken_element_type, shinken_element_name ) {
        var _keys = Object.keys( this.elements );
        var _current_key;
        for( var i = 0, _size = _keys.length ; i < _size; i++ ) {
            _current_key = _keys[i];
            if ( this.elements[_current_key].type !== shinken_element_type ){
                continue;
            }
            if ( this.elements[_current_key].name_element !== shinken_element_name ){
                continue;
            }
            return this.elements[_current_key];
        }
        return null;
    },
    getElement                    : function ( se_uuid ) {
        return this.elements[ se_uuid ];
    },
    addElement                    : function ( element ) {
        this.elements[ element.getSEUUID() ]      = element;
        this.mapping_by_name[ element.getName() ] = element.getSEUUID();
    },
    setCurrentElement             : function ( element ) {
        this.current_element = element;
        this.addElement( element );
        element.dom_form = document.getElementById( 'id-shinken-form-element' );
    },
    setCurrentUser                : function ( element ) {
        this.current_user = element;
        this.addElement( element );
    },
    getAllElements                : function () {
        return SHINKEN.TOOLS.ARRAY.parseToArray( this.elements );
    },
    getAllElementsOfTypeCheck     : function () {
        var _to_return   = [];
        var all_elements = SHINKEN.TOOLS.ARRAY.parseToArray( this.elements );
        for ( var i = 0, _size_i = all_elements.length; i < _size_i; i++ ) {
            if ( all_elements[ i ].isCheck() ) {
                _to_return.push( all_elements[ i ] );
            }
        }
        return _to_return;
    },
    getCheckForCurrentElement     : function () {
        return this.getCheckForElement( this.current_element.uuid, true );
    },
    getCheckForElement            : function ( host_uuid, is_current ) {
        if ( is_current ) {
            return this.current_element.getValidCheck();
        }
        return this.list_templates.getTemplateByUuid( host_uuid ).getValidCheck();
    },
    getAllChecksDFE               : function () {
        var _to_return = [];
        var _keys      = Object.keys( this.elements );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.getElement( _keys[ i ] );
            if ( _current.is_obsolete || !_current.is_dfe ) {
                continue;
            }
            _to_return.push( _current );
        }
        return _to_return;
    },
    setAllChecksElementsToObsolete: function () {
        var _keys = Object.keys( this.elements );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.getElement( _keys[ i ] );
            if ( _current.isCheck() ) {
                _current.is_obsolete = true;
            }
        }
    },
    getElementValueOfLink         : function ( link ) {
        if ( typeof link === 'string' ) {
            return link;
        }
        var _to_return = "";
        var _current;
        for ( var i = 0, _size_i = link.links.length; i < _size_i; i++ ) {
            _current = this.getElement( link.links[ i ]._id );
            if ( _to_return ) {
                _to_return += ",";
            }
            if ( _current ) {
                _to_return += _current.getName();
            }
            else {
                _to_return += link.links[ i ].name;
            }
        }
        return _to_return;
    },
    getNumberShinkenElement       : function () {
        var _keys = Object.keys( this.elements );
        return _keys.length;
    }
};
MANAGER.__instance_element_distributor      = new MANAGER.DistributorElementManager();
MANAGER.DistributorFilterManager           = function () {
    this.filters            = {};
    this.last_element_focus = null;
};
MANAGER.DistributorFilterManager.prototype = {
    createElement       : function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        var _filter = new SHINKEN_LIST.Filter( dom_element );
        if ( _filter.isValid() ) {
            this.setElement( _filter.getParentName(), _filter );
            return _filter;
        }
    },
    findElement         : function ( name, focusing, selector, dom_element ) {
        var _to_return = this.getElement( name );
        if ( !_to_return ) {
            _to_return = this.createElement( dom_element );
        }
        if ( focusing ) {
            this.setLastInstanceFocus( _to_return );
        }
        return _to_return;
    },
    setElement          : function ( name, filter ) {
        this.filters[ name ] = filter;
    },
    getElement          : function ( name ) {
        return this.filters[ name ];
    },
    getAllElements      : function () {
        return SHINKEN.TOOLS.ARRAY.parseToArray( this.filters );
    },
    setLastInstanceFocus: function ( _to_set ) {
        if ( _to_set === null || typeof (_to_set) === "undefined" ) {
            return;
        }
        
        if ( this.last_element_focus && this.last_element_focus !== _to_set ) {
            this.hidePopups();
        }
        this.last_element_focus = _to_set;
        this.last_element_focus.dom_element.classList.add( "shinken-focus" );
        this.last_element_focus.validateValueInput();
    },
    getLastInstanceFocus: function () {
        return this.last_element_focus;
    },
    hidePopups          : function () {
        if ( this.last_element_focus !== null && typeof (this.last_element_focus) !== "undefined" ) {
            this.last_element_focus.dom_element.classList.remove( "shinken-focus" );
            this.last_element_focus.component.input.validateValueInput();
            this.last_element_focus.component.doActionAfterChange( { 'dom_element': this.last_element_focus } );
            this.last_element_focus.hidePopup();
            this.last_element_focus = null;
        }
    }
};
MANAGER.__instance_filter_distributor      = new MANAGER.DistributorFilterManager();
MANAGER.DistributorMacroManager           = function () {
    this.macros = {};
};
MANAGER.DistributorMacroManager.prototype = {
    construct                 : function ( string ) {
        if ( !this.isMacro( string ) ) {
            return string;
        }
        var _macro = this.findMacro( string );
        return _macro;
    },
    recomputeLabelForEachMacro: function () {
        var _keys = Object.keys( this.macros );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.macros[ _keys[ i ] ].init( true );
        }
    },
    isMacro                   : function ( string ) {
        if ( !SHINKEN.TOOLS.STRING.startsWith( string, '$' ) ) {
            return false;
        }
        if ( !SHINKEN.TOOLS.STRING.endsWith( string, '$' ) ) {
            return false;
        }
        return true;
    },
    findMacro                 : function ( name ) {
        var _to_return = this.getMacro( name );
        if ( !_to_return ) {
            _to_return          = new OBJECT.Macro( name );
            this.macros[ name ] = _to_return;
            _to_return.init();
        }
        return _to_return;
    },
    getMacro                  : function ( name ) {
        return this.macros[ name ];
    },
    findMacroByHostKey        : function ( name ) {
        var _name       = '$' + OBJECT.CONST.MACRO.TYPE.HOST_LOCAL + name.substr( 1 ) + '$';
        var _to_return  = this.findMacro( _name );
        _to_return.type = OBJECT.CONST.MACRO.TYPE.HOST_LOCAL; //TODO... A VOIR
        return _to_return;
    },
    changeMacro               : function ( property, value ) {
        if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            var _macro = this.findMacroByHostKey( property.name );
            _macro.setValue( value, property );
            this.recomputeLabelForEachMacro();
        }
    },
    deleteMacroContent        : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            var _macro = this.findMacroByHostKey( name );
            _macro.setValue( '' );
            _macro.setU = OBJECT.CONST.MACRO.TYPE.UNKNOWN;
        }
    },
    renamedMacro              : function ( old_name, new_name, value ) {
        if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            var _macro  = this.findMacroByHostKey( old_name );
            _macro.type = OBJECT.CONST.MACRO.TYPE.UNKNOWN;
            _macro      = this.findMacroByHostKey( new_name );
            _macro.setValue( value );
            this.recomputeLabelForEachMacro();
        }
    },
    splitCommand              : function ( colCommand ) {
        var _current;
        var _to_return = [];
        var _splitted  = colCommand.split( REGEXS.parse_arguments );
        var _size      = _splitted.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = this.construct( _splitted[ i ] );
            if ( _current ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    hasMacro                  : function ( value ) {
        var _current;
        var _splitted = value.split( REGEXS.parse_arguments );
        var _size     = _splitted.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = this.construct( _splitted[ i ] );
            if ( _current ) {
                if ( typeof _current !== 'string' ) {
                    return true;
                }
            }
        }
        return false;
    },
    buildLabel                : function ( _split_data, skip_container, key_dfe ) {
        var _to_return = "";
        var _current;
        for ( var i = 0, _size = _split_data.length; i < _size; i++ ) {
            _current = _split_data[ i ];
            if ( typeof _current === 'string' ) {
                if ( i ) {
                    _to_return += _current;
                }
                else {
                    var split_command    = _current.split( '!' );
                    var _current_command = MANAGER.__instance_element_distributor.getTypeElementWithName( 'commands', split_command[ 0 ] );
                    if ( _current_command ) {
                        _to_return += SHINKEN.TOOLS.buildLinkShinkenElement( _current_command ).outerHTML;
                        for ( var j = 1, _size_j = split_command.length; j < _size_j; j++ ) {
                            _to_return += '!' + SHINKEN.TOOLS.STRING.cleanXss(split_command[ j ]);
                        }
                    }
                    else {
                        _to_return += SHINKEN.TOOLS.STRING.cleanXss(_current);
                    }
                }
            }
            else {
                _to_return += _current.getValue();
            }
        }
        if ( !skip_container ) {
            var _class = "shinken-macro-container";
            _class += !_to_return ? ' shinken-hidden' : '';
            _to_return = "<div class='" + _class + "'>" + _to_return + "</div>";
        }
        if ( key_dfe ) {
            _to_return = SHINKEN.TOOLS.STRING.replaceAll( _to_return, OBJECT.CONST.MACRO.TYPE.DFE_KEY, key_dfe );
        }
        else {
            var _text       = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_not_found' ), '$KEY$' );
            var _to_replace = '<span class="shinken-macro-warning value" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"  onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="' + _text + '">$KEY$</span>';
            _to_return      = SHINKEN.TOOLS.STRING.replaceAll( _to_return, OBJECT.CONST.MACRO.TYPE.DFE_KEY, _to_replace );
        }
        return _to_return;
    }
};
MANAGER.__instance_macro_distributor      = new MANAGER.DistributorMacroManager();
MANAGER.DistributorPropertyManager           = function () {
    this.init();
};
MANAGER.DistributorPropertyManager.prototype = {
    init                           : function () {
        this.reset();
    },
    reset                          : function () {
        this.elements           = {};
        this.last_element_focus = null;
    },
    createNewPropertyFrom          : function ( property, synchronized_name ) {
        if ( !property ) {
            return;
        }
        property.synchronized_elements = {};
        var _to_add                    = DOM.Service.cloneElement( property.dom_element,
            {
                "data-name"             : PROPERTY.BuildSynchroName( property.getName(), synchronized_name ),
                "data-is-synchro"       : true,
                "data-synchro-name"     : synchronized_name,
                "data-synchronized-name": property.getName(),
                "data-is-consistency"   : synchronized_name === property.getName()
            } );
        DOM.Service.addElementAfterTo( _to_add, property.dom_element );
    },
    createElement                  : function ( name, selector, dom_element, synchronized_name ) {
        var _to_return = null;
        
        if ( !selector ) {
            if ( synchronized_name ) {
                this.createNewPropertyFrom( this.getElement( name ), synchronized_name );
                selector = '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE + '[data-name=' + PROPERTY.BuildSynchroName( name, synchronized_name ) + ']';
            }
            else {
                selector = '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE + '[data-name=' + name + ']';
            }
        }
        var _dom_element = dom_element;
        if ( !dom_element ) {
            try {
                var _dom_element = document.querySelector( selector );
            }
            catch ( e ) {
                console.log( 'Invalid name property' );
            }
        }
        
        if ( !_dom_element ) {
            return _to_return;
        }
        
        if ( !MANAGER.__instance_element_distributor.current_user ) {
            return _to_return;
        }
        
        var _type = _dom_element.dataset.type;
        switch ( _type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                _to_return = new PROPERTY.MultiSelect( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.BOOLEAN:
                _to_return = new PROPERTY.Boolean( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT:
                _to_return = new PROPERTY.StringInput( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                _to_return = new PROPERTY.Range( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                _to_return = new PROPERTY.SingleSelect( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                _to_return = new PROPERTY.CheckboxSample( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                _to_return = new PROPERTY.SingleSelectWithInput( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.DATA:
                _to_return = new PROPERTY.Data();
                _to_return.initWithDomElement( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                _to_return = new PROPERTY.CheckboxMulti( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                _to_return = new PROPERTY.MultiLine( _dom_element );
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                _to_return = new PROPERTY.StringInputWithDropDown( _dom_element );
                break;
            default:
                console.error( '[MANAGER.DistributorPropertyManager] This property type of [' + name + '] is not managed yet!', _type );
        }
        if ( synchronized_name ) {
            this.elements[ PROPERTY.BuildSynchroName( name, synchronized_name ) ] = _to_return;
            MANAGER.HelpManager.cloneMapping( name, PROPERTY.BuildSynchroName( name, synchronized_name ) );
        }
        else {
            this.elements[ name ] = _to_return;
        }
        return _to_return;
    },
    findElement                    : function ( name, focusing, selector, dom_element, synchronized_name ) {
        if ( !name ) {
            return;
        }
        if ( name.startsWith( '@' ) ) { // Temp TODO test //sert a filtrer certain champs non visuel
            return;
        }
        var _to_return = this.getElement( name, synchronized_name );
        if ( !_to_return ) {
            _to_return = this.createElement( name, selector, dom_element, synchronized_name );
        }
        if ( focusing === -1 ) {
            this.setLastIntanceFocus();
        }
        else if ( focusing ) {
            this.setLastIntanceFocus( _to_return );
        }
        return _to_return;
    },
    getElement                     : function ( name, synchronized_name ) {
        if ( synchronized_name ) {
            return this.elements[ PROPERTY.BuildSynchroName( name, synchronized_name ) ];
        }
        return this.elements[ name ];
    },
    setElement                     : function ( name, element ) {
        this.elements[ name ] = element;
    },
    indexElementByDisplay          : function () {
        var _elements = document.querySelectorAll( '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE );
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            this.findElement( _elements[ i ].dataset.name ).indexOfDisplay = i;
        }
    },
    getAllElements                 : function () {
        return SHINKEN.TOOLS.ARRAY.parseToArray( this.elements );
    },
    getAllElementsByTabParentName  : function ( tab_parent_name ) {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "tab_parent_name", tab_parent_name );
        return _to_return;
    },
    getDataWithName                : function ( name_data ) {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "type", PROPERTY.CONST.TYPES.DATA );
        if ( !_to_return ) {
            return null;
        }
        var _current;
        for ( var i = 0, _size = _to_return.length; i < _size; i++ ) {
            _current = _to_return[ i ];
            if ( _current.getName() === name_data ) {
                return _current;
            }
        }
        return null;
    },
    getAllDatasSorted              : function () {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "type", PROPERTY.CONST.TYPES.DATA );
        _to_return     = SHINKEN.TOOLS.ARRAY.sortArray( _to_return, "name" );
        return _to_return;
    },
    getAllOverrideProp             : function () {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "is_override", true );
        return _to_return;
    },
    getAllOverridePropByCheckId    : function ( uuid ) {
        var _to_return = this.getAllElements();
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "override_check_uuid_final", uuid );
        return _to_return;
    },
    getAllDataOverridePropByCheckId: function ( uuid ) {
        var _to_return = this.getAllOverridePropByCheckId( uuid );
        _to_return     = SHINKEN.TOOLS.ARRAY.filterWith( _to_return, "type", PROPERTY.CONST.TYPES.DATA );
        return _to_return;
    },
    getFirstOverridePropWithName   : function ( property_override_name ) { //FOR DOCUMENTATION
        var _to_return = this.getAllOverrideProp();
        for ( var i = 0, _size_i = _to_return.length; i < _size_i; i++ ) {
            if ( _to_return[ i ].override_prop_name === property_override_name ) {
                return _to_return[ i ];
            }
        }
        return null;
    },
    setLastIntanceFocus            : function ( _to_set ) {
        if ( this.last_element_focus && this.last_element_focus !== _to_set ) {
            if ( this.last_element_focus.do_after_action_after_loosing_focus ) {
                MANAGER.ListenerEventManager.afterActionProperty( this.last_element_focus );
                this.last_element_focus.do_after_action_after_loosing_focus = false;
            }
            this.hidePopups();
        }
        this.last_element_focus = _to_set;
    },
    hasOverride                    : function ( check_in_page_host ) {
        var _overrides_prop = this.getAllOverrideProp();
        var _to_return      = false;
        var _current;
        var _current_value;
        for ( var i = 0, _size = _overrides_prop.length; i < _size; i++ ) {
            _current       = _overrides_prop[ i ];
            _current_value = _current.getValue();
            if ( !_current_value || _current_value === PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE ) {
                continue;
            }
            if ( _current.override_check_uuid_final === check_in_page_host.getDomUUID() ) {
                _to_return = true;
                if ( check_in_page_host.is_dfe ) {
                    _current.is_not_linked = false;
                }
            }
        }
        return _to_return;
    },
    deleteOverrideProp             : function ( check_in_page_host, host_in_page_host ) {
        var _datas = this.getAllElements();
        var _current_property;
        for ( var i = 0, _size_datas = _datas.length; i < _size_datas; i++ ) {
            _current_property = _datas[ i ];
            if ( _current_property.override_check_name === check_in_page_host.name ) {
                this.removeElement( _current_property.name, check_in_page_host, host_in_page_host );
            }
        }
    },
    removeElement                  : function ( name, check_in_page_host, host_in_page_host ) {
        var _to_remove = this.getElement( name );
        if ( _to_remove ) {
            if ( _to_remove.is_override && host_in_page_host && check_in_page_host ) {
                MANAGER.__instance_element_distributor.current_element.addOverrideByProperty( _to_remove, check_in_page_host, host_in_page_host );
            }
            delete this.elements[ name ];
        }
    },
    finalyzeModel                  : function () {
        var _object = this.getElement( PROPERTY.CONST.NAME.RESULT_MODULATIONS );
        if ( _object ) {
            _object.getSelector().setMaximumSelected( PROPERTY.CONST.MAX_SELECTABLE_ITEMS.RESULT_MODULATIONS );
        }
        var _object = this.getElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
        if ( _object && PROPERTY.UserRightsBehaviour.has_everybody_default === null ) {
            PROPERTY.UserRightsBehaviour.has_everybody_default = _object.default_value === 'everyone';
        }
    },
    unSetAllOverrideFor            : function ( check_in_page_host ) {
        var properties = this.getAllOverridePropByCheckId( check_in_page_host.getDomUUID() );
        var _size      = properties.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = properties[ i ];
            if ( _current.state !== PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                _current.unset();
            }
        }
    },
    hidePopups                     : function () {
        if ( this.last_element_focus ) {
            this.last_element_focus.hidePopup();
            this.last_element_focus = null;
        }
    },
    finalyzeView                   : function () {
        MANAGER.__instance_element_distributor.list_templates.finalyzeView();
        
        var _object = this.getElement( PROPERTY.CONST.NAME.RESULT_MODULATIONS );
        if ( _object ) {
            _object.updateView();
        }
        var _object = this.getElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
        if ( _object ) {
            _object.updateView();
        }
        var _object = this.getElement( PROPERTY.CONST.NAME.ENABLED );
        if ( _object ) {
            _object.updateView();
        }
    }
};
MANAGER.__instance_property_distributor      = new MANAGER.DistributorPropertyManager();
MANAGER.DistributorSourceManager           = function () {
    this.sources   = {};
    this.view_type = SOURCE.CONST.VIEW_TYPES.DETAIL;
    this.dom_element_module_type;
};
MANAGER.DistributorSourceManager.prototype = {
    toggleViewSource       : function () {
        this.view_type = (this.view_type === SOURCE.CONST.VIEW_TYPES.DETAIL) ? SOURCE.CONST.VIEW_TYPES.ALL : SOURCE.CONST.VIEW_TYPES.DETAIL;
        DOM.Service.setDataSet( this.getDomElementModuleType(), 'displayAll', this.view_type );
    },
    getDomElementModuleType: function () {
        if ( !this.dom_element_module_type ) {
            this.dom_element_module_type = document.getElementById( "modules-type-area" );
        }
        return this.dom_element_module_type;
    },
    createSource           : function ( type ) {
        var _to_return = new SOURCE.Sources( type );
        
        this.sources[ type ] = _to_return;
        
        return _to_return;
    },
    findSource             : function ( name ) {
        var _list_all_sources = this.findSources( SOURCE.CONST.TYPES.ALL );
        return _list_all_sources.getSource( name );
    },
    findSources            : function ( type ) {
        if ( !type ) {
            return;
        }
        
        var _to_return = this.getSource( type );
        
        if ( !_to_return ) {
            _to_return = this.createSource( type );
            switch ( type ) {
                case SOURCE.CONST.TYPES.ALL:
                    break;
                case SOURCE.CONST.TYPES.COLLECTOR:
                case SOURCE.CONST.TYPES.LISTENER:
                case SOURCE.CONST.TYPES.ANALYZER:
                    _to_return.addAllSource( this.sources[ SOURCE.CONST.TYPES.ALL ].getSourceByType( type ) );
                    break;
            }
        }
        return _to_return;
    },
    getSource              : function ( type ) {
        return this.sources[ type ];
    },
    reorderAllSourceDom    : function () {
        var _dom_element = document.getElementById( 'modules-type-area' );
        _dom_element.classList.add( "shinken-animate-order" );
        setTimeout( function () {
            _dom_element.classList.remove( "shinken-animate-order" );
        }, 3000 );
        
        this.reorderSourceDom( SOURCE.CONST.TYPES.ALL );
        this.reorderSourceDom( SOURCE.CONST.TYPES.ANALYZER );
        this.reorderSourceDom( SOURCE.CONST.TYPES.LISTENER );
        this.reorderSourceDom( SOURCE.CONST.TYPES.COLLECTOR );
    },
    reorderSourceDom       : function ( type ) {
        var _current = this.findSources( type );
        if ( !_current ) {
            return;
        }
        _current.reorderDomElement();
    }
};
MANAGER.__instance_source_distributor      = new MANAGER.DistributorSourceManager();
MANAGER.DistributorWindowManager           = function () {
    this.windows        = {};
    this.parent_windows = {};
};
MANAGER.DistributorWindowManager.prototype = {
    createWindow                      : function ( name, is_menu, has_properties ) {
        var _id          = WINDOW.CONST.ID.WINDOW_TAB + name;
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = has_properties ? new WINDOW.ElementWithProperties( name, _dom_element, is_menu ) : new WINDOW.Element( name, _dom_element, is_menu );
        this.setWindow( name, _to_return );
        return _to_return;
    },
    createParentWindow: function ( name ) {
        var _to_return = new WINDOW.ElementGroup( name );
        this.setParentWindow( name, _to_return );
        return _to_return;
    },
    findWindow                        : function ( name, is_menu, parent_id, has_properties ) {
        if ( !name ) {
            return;
        }
        if( parent_id ){
            var _parent = this.findParentWindow(parent_id);
            if ( _parent ) {
                return  _parent.getElementByName( name );
            }
        }
        var _to_return = this.getWindow( name );
        if ( !_to_return ) {
            _to_return = this.createWindow( name, is_menu, has_properties );
        }
        return _to_return;
    },
    findParentWindow  : function ( name ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getParentWindow( name );
        if ( !_to_return ) {
            _to_return = this.createParentWindow( name );
        }
        return _to_return;
    },
    setWindow         : function ( name, window ) {
        this.windows[ name ] = window;
    },
    setParentWindow   : function ( name, parent_window ) {
        this.parent_windows[ name ] = parent_window;
    },
    getWindow         : function ( name ) {
        return this.windows[ name ];
    },
    clickOnFirstWindowInParentWithName         : function ( name ) { //FOR DOCUMENTATION
        var _keys = Object.keys( this.parent_windows );
        this.parent_windows[ _keys[0] ].clickOnWindow(name);
    },
    getParentWindow   : function ( name ) {
        return this.parent_windows[ name ];
    },
    reset             : function () {
        this.windows        = {};
        this.parent_windows = {};
    }
};
MANAGER.__instance_window_distributor      = new MANAGER.DistributorWindowManager();
MANAGER.DragNDropManager = (function ( self ) {
    "use strict";
    self.last_element_hovered = null;
    self.current_parent_name  = null;
    self.type_drag_start      = null;
    self.list_element         = null;
    self.single_element_drag  = null;
    
    self.dragStartSingle  = function ( event ) {
        self.single_element_drag = DOM.Service.findParentElementWithClass( event.target, "shinken-draggable", 50 );
        this.single_element_drag.classList.add("shinken-drag-active");
        self._bounding_origin = self.single_element_drag.getBoundingClientRect();
        self._mouse_x_origin  = parseInt( event.clientX );
        self._mouse_y_origin  = parseInt( event.clientY );
        var _computed         = DOM.Service.getComputedStyle( self.single_element_drag );
        self._left_origin = parseInt( _computed[ 'left' ] );
        self._top_origin  = parseInt( _computed[ 'top' ] );
    };
    self.dragSingle       = function ( event ) {
        if ( !self.single_element_drag ) {
            return;
        }
        var _delta_x = parseInt( event.clientX ) - self._mouse_x_origin + self._left_origin;
        var _delta_y = parseInt( event.clientY ) - self._mouse_y_origin + self._top_origin;
        DOM.Service.setStyles( self.single_element_drag, { "top": _delta_y, "left": _delta_x } );
    };
    self.dragEndSingle    = function ( event ) {
        this.single_element_drag.classList.remove("shinken-drag-active");
        self.single_element_drag = null;
    };
    self.dragStartShinken = function ( e, type, parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        if ( _object.is_disabled ) {
            return false;
        }
        e.dataTransfer.setData( 'text', 'anything' );
        self.type_drag_start      = type;
        self.current_parent_name  = parent_name;
        self.list_element         = _object.dragStartShinken( type, key_name );
        self.last_element_hovered = self.list_element.getDragged().getDomElement().parentNode;
        self.last_index           = self.last_element_hovered.dataset.index;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        
        var _list_droppable = _object.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = _list_droppable[ i ].getBoundingClientRect().width + 'px';
        }
    };
    self.dragOverShinken  = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
        if ( self.current_parent_name !== parent_name ) {
            return false;
        }
        if ( self.type_drag_start !== type ) {
            return false;
        }
        var _current_index_hovered = dom_element.dataset.index;
        if ( _current_index_hovered === self.last_index ) {
            return false;
        }
        
        self.list_element.changeElementPosition( self.last_index, _current_index_hovered );
        self.last_index = _current_index_hovered;
        self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        self.last_element_hovered = dom_element;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
    };
    self.dragEndShinken   = function ( e, type ) {
        var _list_droppable = MANAGER.__instance_property_distributor.last_element_focus.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = '';
        }
        
        if ( MANAGER.__instance_property_distributor.last_element_focus.is_disabled ) {
            return false;
        }
        e.preventDefault();
        MANAGER.__instance_property_distributor.last_element_focus.resetDragging();
        
        if ( self.last_element_hovered ) {
            self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        }
        self.last_element_hovered = null;
        self.current_parent_name  = null;
        self.type_drag_start      = null;
        self.list_element         = null;
        self.pause_timeout        = null;
    };
    self.dropShinken      = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
    };
    return self;
})
( MANAGER.DragNDropManager || {} );
MANAGER.DragNDropSourceManager = {
    
    dragged_source: null,
    source_all    : MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL ),
    pause_timeout : null,
    
    dragStartSource: function( event, source_name ) {
        if ( MANAGER.__instance_source_distributor.view_type !== SOURCE.CONST.VIEW_TYPES.ALL ) {
            return;
        }
        event.dataTransfer.setData( 'text', 'anything' );
        this.source_all.stopAutoRefresh();
        this.dragged_source = this.source_all.getSource( source_name );
        this.dragged_source.dragStartSource();
    },
    dragOverSource : function( event, source_name ) {
        if ( MANAGER.__instance_source_distributor.view_type !== SOURCE.CONST.VIEW_TYPES.ALL ) {
            return;
        }
        event.preventDefault();
        
        if ( this.pause_timeout ) {
            return;
        }
        var _source_overred = this.source_all.getSource( source_name );
        if ( this.dragged_source.getOrder() === _source_overred.getOrder() ) {
            return;
        }
        this.source_all.changeSourcePosition( this.dragged_source, _source_overred );
        
        
        
        var self           = this;
        self.pause_timeout = setTimeout( function() {
            self.pause_timeout = null;
        }, 500 );
    },
    dropSource     : function( event ) {
        if ( MANAGER.__instance_source_distributor.view_type !== SOURCE.CONST.VIEW_TYPES.ALL ) {
            return;
        }
        event.preventDefault();
        this.source_all.sendNewOrderToBackend();
    },
    dragEndSource  : function( event ) {
        if ( MANAGER.__instance_source_distributor.view_type !== SOURCE.CONST.VIEW_TYPES.ALL ) {
            return;
        }
        event.preventDefault();
        this.dragged_source.resetDragging();
        this.dragged_source = null;
        MANAGER.__instance_source_distributor.reorderAllSourceDom();
        this.source_all.startAutoRefresh();
    }
};
MANAGER.EventManager = {
    last_element_hovered           : null,
    stop_propagation               : false,
    openIframeModal                : function ( url ) {
        MANAGER.__instance_window_modal_manager.setIframe( url );
    },
    closeModal                     : function () {
        MANAGER.__instance_window_modal_manager.close();
    },
    clickOnToggleCollapse          : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, "shinken-toggle-parent", 25 );
        if ( !_parent_dom_element ) {
            return;
        }
        _parent_dom_element.classList.toggle( "shinken-collapsed" );
    },
    logout                         : function () {
        window.location = '/logout';
        sessionStorage.removeItem( "user_id" );
    },
    onFocus                        : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onFocus();
    },
    onFocusOut                     : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onFocusOut( event );
    },
    stopPropagation                : function ( event ) {
        if ( event ) {
            event.stopPropagation();
        }
        else {
            this.stop_propagation = true;
            var self              = this;
            setTimeout( function () {
                self.stop_propagation = false;
            }, 50 );
        }
    },
    clickOnRadioBtn                : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnRadioBtn( event );
    },
    clickOnButton                  : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnButton( event );
    },
    onChangeOnInputKey             : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.askComputeKeyAfterChange( event.target );
    },
    clickOnAddNewLocalMacro        : function () {
        return App.Elements.DataTab.addNewData();
    },
    clickOnDeletePropertyBtn       : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.delete();
    },
    clickDataCollapseButtonGlobal  : function () {
        App.Elements.DataTab.toggleCollapseButtonGlobal();
    },
    clickDataCollapseButton        : function ( dom_element ) {
        App.Elements.DataTab.toggleCollapseButton( dom_element );
    },
    goToDataView                   : function ( data_name ) {
        MANAGER.EventManager.clickOnWindowNavigation( null, MANAGER.__instance_element_distributor.current_element.uuid, true, WINDOW.CONST.ELEMENT.DATAS );
        var _prop = MANAGER.__instance_property_distributor.getDataWithName( data_name );
        if ( _prop && _prop.group_data ) {
            MANAGER.EventManager.clickOnDataNavigation( _prop.group_data.uuid );
        }
    },
    clickOnDataNavigation          : function ( group_uuid ) {
        App.Elements.DataTab.clickOnDataNavigation( group_uuid );
    },
    clickOnWindowNavigation        : function ( event, name, update_url, window_name ) {
        if ( !window_name ) {
            var _nav_tab = DOM.Service.findParentElementWithClass( event.target, WINDOW.CONST.CLASS.WINDOW_TAB, 10 );
            if ( !_nav_tab ) {
                return;
            }
            window_name = _nav_tab.dataset.name;
        }
        
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( name );
        
        _parent_window.clickOnWindow( window_name );
        if ( update_url ) {
            SHINKEN.HIGHWAY.goToElementTab( window_name );
        }
    },
    clickOnCheckboxInput           : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCheckboxInput( event );
    },
    onChangeOnInput                : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onChangeOnInput( event );
    },
    onResize                       : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onResize( dom_element );
    },
    onMoveRangeCursor              : function ( parent_name, ask_after_action, event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onMoveRangeCursor( null, event );
        if ( ask_after_action ) {
            MANAGER.ListenerEventManager.askAfterActionProperty( _object );
        }
    },
    clickOnBtnPlus                 : function ( parent_name, event ) {
        this.stopPropagation();
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnPlus( event );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnSelector                : function ( event, parent_name, controller_name ) {
        event.stopPropagation();
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnSelector( event, parent_name );
    },
    clickOnAllItemsSelector        : function ( parent_name, limit ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAllItemsSelector( limit );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnItemSelector            : function ( event, parent_name, element, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnItemSelector( event, parent_name, element );
    },
    clickOnDeleteItemSelector      : function ( parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnDeleteItemSelector( key_name );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnBtnInheritance          : function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnInheritance();
    },
    clickOnInput                   : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnInput( event );
    },
    muteEvent                      : function ( event ) {
        event.preventDefault();
        event.stopPropagation();
    },
    mutePropagation                : function ( event ) {
        event.stopPropagation();
    },
    clickOnToggleViewSource        : function () {
        MANAGER.__instance_source_distributor.toggleViewSource();
        
    },
    clickOnActivatedSource         : function ( name ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.toggleEnable();
    },
    clickOnActivatedDiscoverySource: function ( source_name, discovery_id ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedDiscoverySource]", "[not admin]", "refused" );
            return;
        }
        var _source    = MANAGER.__instance_source_distributor.findSource( source_name );
        var _discovery = _source[ SOURCE.CONST.FIELD.IP_RANGES ].getRangeById( discovery_id );
        _discovery.toggleEnable();
    },
    clickOnForceSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnForceSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.askForceImport();
    },
    clickOnCleanSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnCleanSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.cleanImport();
    },
    clickOnLastExecutionSource     : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnLastExecutionSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.redirectToSourceLastExecution();
    },
    clickOnWorkflowTab             : function ( name ) {
        var dom_element = document.querySelector( "#shinken-workflow-container" );
        DOM.Service.setDataSet( dom_element, 'selected', name );
        dom_element.classList.toggle( 'PATCH_IE' );
    },
    clickOpenNewWindow             : function ( event, link, id ) {
        var _path = "/elements/";
        _path += link + '/';
        _path += id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    clickOnLinkForWorkingArea      : function ( event, id ) { //NE MARCHE QUE POUR LES HOSTS
        var _path = "/elements/working_area/hosts/" + id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    keydown                        : function ( event ) {
        var _key_code = event.keyCode;
        switch ( _key_code ) {
            case SHINKEN.CONST.KEY_CODE.F1:
                if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
                    window.onhelp = function () {
                        return false;
                    };
                }
                event.preventDefault();
                event.stopPropagation();
                break;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.keydown( event, _key_code );
        }
    },
    mouseEnter                     : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseEnter( event );
        }
    },
    mouseLeave                     : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseLeave( event );
        }
    },
    onClick                        : function ( event ) {
        if ( this.stop_propagation ) {
            this.stop_propagation = false;
            return;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.onClick( event );
        }
    },
    onScroll                       : function ( dom_element_container ) {
        var _top    = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.TOP );
        var _scroll = dom_element_container[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ];
        var _bottom = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.BOTTOM );
        
        var _y = ((_bottom - _top) / 2) + _top;
        
        document.getElementById( "id-shinken-debug-1" ).innerText = _top;
        document.getElementById( "id-shinken-debug-2" ).innerText = _bottom;
        document.getElementById( "id-shinken-debug-3" ).innerText = _scroll;
        document.getElementById( "id-shinken-debug-4" ).innerText = _scroll + _top;
        document.getElementById( "id-shinken-debug-5" ).innerText = _scroll + _bottom;
        document.getElementById( "id-shinken-debug-6" ).innerText = _y;
        
        
    },
    clickOnForcedHelpButton        : function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 20 );
        var name                = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( name );
        _object.clickOnForcedHelpButton();
    },
    clickOnForcedHelpButtonCheck   : function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        MANAGER.HelpManager.setForced( 'help_title_try_checks', dom_element, true );
    },
    clickOnPaste                   : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.clickOnPaste( event );
        }
    },
    clickOnModeTab                 : function ( element, do_blink_animation ) {
        var _parent = document.getElementById( 'id-shinken-window-checks-target' );
        DOM.Service.setDataSet( _parent, 'tabSelected', element.dataset.value );
        if ( do_blink_animation ) {
            DOM.Service.askAddClass( element, 'shinken-pulsate', 2000 );
        }
        if ( element.dataset.value !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            var _elements = document.querySelectorAll( '.shinken-tab-check-col-tags' );
            for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
                _elements[ i ].classList.remove( "shinken-active" );
            }
            var _elements_tr = document.querySelectorAll( '.shinken-tr-check-override' );
            for ( var i = 0, _size = _elements_tr.length; i < _size; i++ ) {
                _elements_tr[ i ].classList.add( "shinken-hidden" );
            }
        }
        MANAGER.__instance_navigator_size.tab_data_exclude();
    },
    clickOnSetOverride             : function ( dom_uuid ) {
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE + '"]' ), true );
        }
        App.Elements.ChecksTab.getCheckOverrideData( dom_uuid );
        MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.CLICK_ON_SERVICE_OVERRIDE );
    },
    clickOnSetExclude              : function ( dom_uuid, event, ignore_if_on_status_exclude ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE + '"]' ), true );
        }
        else if ( !ignore_if_on_status_exclude ) {
            var _check_in_host = App.Elements.ChecksTab.getCheckInHostElement( dom_uuid );
            _check_in_host.changeExcludeStatus();
        }
    },
    clickOnDeleteInvalidOverride   : function ( type, name ) {
        MANAGER.__instance_override_unvalid.deleteOverride( type, name );
        App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
    },
    clickOnCleanCheckOverrides     : function ( event, check_uuid ) {
        event.stopPropagation();
        var _confirm = confirm( _( 'element.confirm_remove_override' ) );
        if ( _confirm ) {
            var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
            _check_in_page_host.cleanOverride();
            App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
        }
    },
    clickOnFocusOnDuplicateCheck   : function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckByID( check_uuid );
        _check_in_page_host.dom_element.scrollIntoView( false );
        DOM.Service.askAddClass( _check_in_page_host.dom_element.querySelector( '.shinken-tab-check-col-name' ), 'shinken-pulsate-focus', 3000 );
    },
    clickOnTryCheck                : function ( check_uuid, is_exec, is_on_poller ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.askTryCheck( is_exec, is_on_poller );
    },
    clickOnCleanTryCheck           : function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.hide_eval_check();
    },
    clickOnMultiLineObjectAdd      : function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAddLine();
    },
    clickOnDeleteLine              : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.deleteLine( dom_element );
    },
    clickOnHooksPopup              : function ( event, element ) {
        event.stopImmediatePropagation();
        var target    = element;
        var parent    = target.parentNode;
        var is_active = target.classList.contains( 'active' );
        if ( is_active ) {
            target.classList.remove( 'active' );
            parent.classList.remove( "shinken-force-display-block" );
        }
        else {
            target.classList.add( 'active' );
            parent.classList.add( "shinken-force-display-block" );
        }
    },
    clickOnCollapseButton          : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCollapseButton( event );
    },
    simulateClickOnFilter          : function ( event, header_name, value ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.simulateClickOnFilter( event, header_name, value );
    },
    clickOnForceImportInSource     : function ( source_name ) {
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.URL
                     + source_name
                     + COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                _sources.refresh();
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    }
};
MANAGER.HelpManager = {
    status                : MANAGER.CONST.HELP.STATUS.INACTIVE,
    active_name           : null,
    forced_name           : null,
    title                 : "",
    content               : "",
    mapping_label         : {},
    dom_element           : null,
    dom_element_title     : null,
    dom_element_content   : null,
    dom_element_import_key: null,
    dom_button_forced     : null,
    default_content       : _( 'element.help_hover' ),
    timer_set_inactive    : null,
    setStatus             : function ( to_set ) {
        this.status = to_set;
        this.initDomElement();
        this.buildHtml();
    },
    setActive             : function ( name, label, key_content, import_key ) {
        if ( this.timer_set_inactive ) {
            clearTimeout( this.timer_set_inactive );
        }
        if ( this.active_name === name ) {
            return;
        }
        this.active_name = name;
        this.createTextsIfMissing( name, label, key_content, import_key );
        this.setStatus( MANAGER.CONST.HELP.STATUS.ACTIVE );
        
        if ( CONTROLLER.MassChange ) {
            CONTROLLER.MassChange.computeSizesHelp();
        }
        else {
            CONTROLLER.ShinkenElement.computeSizesHelp();
        }
    },
    askSetInactive        : function ( name ) {
        if ( this.timer_set_inactive ) {
            clearTimeout( this.timer_set_inactive );
        }
        var _self               = this;
        this.timer_set_inactive = setTimeout( function () {
            _self.setInactive( name );
        }, 400 );
    },
    setInactive           : function ( name ) {
        if ( this.active_name !== name ) {
            return;
        }
        this.active_name = null;
        this.setStatus( this.forced_name ? MANAGER.CONST.HELP.STATUS.FORCED : MANAGER.CONST.HELP.STATUS.INACTIVE );
        this.timer_set_inactive = null;
        if ( CONTROLLER.MassChange ) {
            CONTROLLER.MassChange.computeSizesHelp();
        }
        else {
            CONTROLLER.ShinkenElement.computeSizesHelp();
        }
    },
    setForced             : function ( name, dom_element, forced ) {
        if ( this.forced_name === name && (name !== 'help_title_try_checks' || forced) ) {
            this.forced_name = false;
            this.dom_tag_help_button.classList.remove( 'shinken-active' );
        }
        else {
            if ( this.dom_tag_help_button ) {
                this.dom_tag_help_button.classList.remove( 'shinken-active' );
            }
            
            this.dom_tag_help_button = dom_element;
            this.forced_name         = name;
            if ( this.dom_tag_help_button ) {
                this.dom_tag_help_button.classList.add( 'shinken-active' );
            }
        }
        this.buildHtml();
    },
    cloneMapping              : function ( name_to_clone, new_mapping ) {
        if ( !this.mapping_label[ name_to_clone ] ) {
            this.setTitle(name_to_clone);
            this.setContent(name_to_clone);
            this.setImportKey(name_to_clone);
        }
        this.mapping_label[ new_mapping ] = this.mapping_label[ name_to_clone ];
    },
    setTitle              : function ( name_property, to_set ) {
        if ( !this.mapping_label[ name_property ] ) {
            this.mapping_label[ name_property ] = {};
        }
        if ( !to_set ) {
            to_set = _( 'help-' + MANAGER.__instance_element_distributor.current_element.getHelpType() + '.' + name_property + "-title" );
        }
        this.mapping_label[ name_property ].title = to_set;
    },
    setContent            : function ( name_property, to_set ) {
        if ( !this.mapping_label[ name_property ] ) {
            this.mapping_label[ name_property ] = {};
        }
        if ( !to_set ) {
            to_set = 'help-' + MANAGER.__instance_element_distributor.current_element.getHelpType() + '.' + name_property + "-content";
        }
        this.mapping_label[ name_property ].content = _( to_set );
        switch ( name_property ) {
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.MONDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.TUESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.WEDNESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.THURSDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.FRIDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SATURDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SUNDAY:
            case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                this.mapping_label[ name_property ].content += _( "help-timeperiods.day-specific-content" );
                break;
        }
    },
    setImportKey          : function ( name_property, to_set ) {
        if ( !this.mapping_label[ name_property ] ) {
            this.mapping_label[ name_property ] = {};
        }
        if ( !to_set ) {
            to_set = _( 'element.import_key' ) + ' : ' + name_property;
        }
        var _prop = MANAGER.__instance_property_distributor.getElement( name_property );
        if ( _prop && _prop.hide_import_key ) {
            to_set = "";
        }
        this.mapping_label[ name_property ].import_key = to_set;
    },
    clean                 : function () {
        DOM.Service.setHtmlOrHide( this.dom_element_title, '' );
        DOM.Service.setHtmlOrHide( this.dom_element_import_key, '' );
        DOM.Service.setHtmlOrHide( this.dom_element_content, '' );
    },
    buildHtml             : function () {
        var _texts = this.getTexts();
        if ( _texts ) {
            DOM.Service.setHtmlOrHide( this.dom_element_title, _texts.title );
            DOM.Service.setHtmlOrHide( this.dom_element_import_key, _texts.import_key );
            DOM.Service.setHtmlOrHide( this.dom_element_content, _texts.content );
        }
    },
    getHelpToDisplay      : function () {
        switch ( this.status ) {
            case MANAGER.CONST.HELP.STATUS.ACTIVE:
                return this.active_name;
            case MANAGER.CONST.HELP.STATUS.FORCED:
                return this.forced_name;
        }
        return false;
    },
    resetDomElement       : function () {
        this.dom_element            = null;
        this.dom_element_title      = null;
        this.dom_element_content    = null;
        this.dom_element_import_key = null;
        this.forced_name            = null;
        this.active_name            = null;
    },
    initDomElement        : function ( dom_element ) {
        if ( !dom_element && this.dom_element ) {
            return;
        }
        if ( !dom_element ) {
            dom_element = document;
        }
        this.dom_element = dom_element.querySelector( '#id-shinken-help-container' );
        if ( this.dom_element ) {
            this.dom_element_title      = this.dom_element.querySelector( '.shinken-help-name' );
            this.dom_element_content    = this.dom_element.querySelector( '.shinken-help-content-container' );
            this.dom_element_import_key = this.dom_element.querySelector( '.shinken-help-import-key' );
        }
    },
    createTextsIfMissing  : function ( name_property, title, key_translate_content, import_key ) {
        if ( this.mapping_label[ name_property ] ) {
            return;
        }
        this.setTitle( name_property, title );
        this.setContent( name_property, key_translate_content );
        this.setImportKey( name_property, import_key );
    },
    getTexts              : function () {
        var _name_property = this.getHelpToDisplay();
        var _to_return;
        if ( _name_property ) {
            _to_return = this.mapping_label[ _name_property ];
        }
        else {
            _to_return            = {};
            _to_return.title      = '';
            _to_return.import_key = '';
            _to_return.content    = this.default_content;
            
        }
        return _to_return;
    }
    
};
MANAGER.ListenerEventManager = {
    askAfterActionProperty                     : function ( property ) {
        var self = this;
        if ( property.time_out_ask_after_action ) {
            clearTimeout( property.time_out_ask_after_action );
        }
        property.time_out_ask_after_action = setTimeout( function () {
            property.time_out_ask_after_action = null;
            self.afterActionProperty( property );
        }, 200 );
    },
    afterActionProperty                        : function ( property ) {
        this.synchronizeAfterEvent( property );
        this.afterActionGlobal( property );
    },
    afterAction                                : function ( type, param1 ) {
        switch ( type ) {
            case MANAGER.CONST.AFTER_ACTION.CLICK_ON_SERVICE_OVERRIDE:
                var property = MANAGER.__instance_property_distributor.findElement( 'use' );
                this.setDisabledBecauseOverrideOpen( property );
                break;
            case MANAGER.CONST.AFTER_ACTION.UPDATE_VIEW_ON_WINDOW_PROPERTIES:
                MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.INIT );
                var _props = MANAGER.__instance_property_distributor.getAllElementsByTabParentName( param1 );
                for ( var i = 0, _size = _props.length; i < _size; i++ ) {
                    _props[ i ].updateView();
                }
                MANAGER.__instance_element_distributor.current_element.setPhase( MANAGER.__instance_element_distributor.current_element.phase.previous_phase );
                break;
        }
    },
    setDisabledBecauseOverrideOpen             : function ( property ) {
        property.setIsDisable( true );
        var _dom_element   = property.dom_element;
        var _property_data = _dom_element.getElementsByClassName( 'shinken-prop-cell-action-content' )[ 0 ];
        _property_data.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
        _property_data.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        _property_data.setAttribute( 'shi-tip-html', SHINKEN.TOOLS.STRING.format( _( 'element.use_cannot_be_modified' ) ) );
        
        var list_dom_element_with_tooltip = _property_data.querySelectorAll( "[shi-tip-html]" );
        var _current_dom_element;
        for ( var i = 0, _size = list_dom_element_with_tooltip.length; i < _size; i++ ) {
            _current_dom_element = list_dom_element_with_tooltip[ i ];
            DOM.Service.removeAttribute( _current_dom_element, "onmouseenter" );
            DOM.Service.removeAttribute( _current_dom_element, "onmouseleave" );
        }
        
    },
    synchronizeAfterEvent                      : function ( property ) {
        if ( property.stop_synchronization ) {
            property.stop_synchronization = false;
            return;
        }
        var _object;
        var property_name = property.getName();
        if ( property.is_override ) {
            property_name = property.override_prop_name;
        }
        var _object_to_link = this.getObjectLink( property );
        var _switch_on      = true;
        var _size           = _object_to_link.length;
        var i               = 0;
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
            case PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS:
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                _switch_on = false;
            case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME:
            case PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE:
            case PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK:
            case PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK:
                for ( ; i < _object_to_link.length; i++ ) {
                    _object = MANAGER.__instance_property_distributor.findElement( _object_to_link[ i ] );
                    _object.synchronize( property, _switch_on );
                }
                break;
            case PROPERTY.CONST.NAME.USE:
                if ( property.is_mass_change ) {
                    PROPERTY.UserRightsBehaviourMassChange.askAddActionConsistency( property );
                }
                else {
                    for ( ; i < _size; i++ ) {
                        _object = MANAGER.__instance_property_distributor.findElement( _object_to_link[ i ] );
                        this.synchronizeAfterEvent( _object );
                    }
                }
                break;
            
        }
    },
    afterActionGlobal                          : function ( property ) {
        var _object;
        var property_name = property.getName();
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.SERVICE_EXCLUDES:
                if ( property.is_mass_change ) {
                    CONTROLLER.MassChange.setExcludeByName( property.getValue() );
                }
                else {
                    App.Elements.ChecksTab.updateExcludeStatus();
                }
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                _object = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
                _object.updateView();
                break;
            case PROPERTY.CONST.NAME.USE:
                var _check_nb_label = property.dom_element.querySelectorAll( ".shinken-checks-tag-label" );
                for ( var i = 0, _size_i = _check_nb_label.length; i < _size_i; i++ ) {
                    DOM.Service.removeElement( _check_nb_label[ i ] );
                }
                if ( !property.is_mass_change ) {
                    updateALLTemplateAndCheckDatas();
                }
                break;
            case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
                if ( property.isSetOrIsSetFromTemplate() ) {
                    var _list_tag = document.querySelectorAll( '.shinken-tag-modulation' );
                    for ( var i = 0, _size = _list_tag.length; i < _size; i++ ) {
                        _list_tag[ i ].classList.remove( 'shinken-hidden' );
                    }
                }
                break;
            case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
                if ( !property.is_mass_change ) {
                    App.Elements.ChecksTab.computeModulationTag();
                }
                break;
        }
        if ( property.is_override ) {
            var override_property_name = property.override_prop_name;
            var _check_in_host         = App.Elements.ChecksTab.getCheckInHostElement( property.override_check_uuid_final );
            switch ( override_property_name ) {
                case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
                case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
                    var _id          = App.Elements.ChecksTab.buildIdTagModulation( _check_in_host );
                    var _tag_needed  = App.Elements.ChecksTab.isTagModulationNeeded( _check_in_host, property );
                    var _dom_element = document.getElementById( _id );
                    if ( _tag_needed ) {
                        _dom_element.classList.remove( 'shinken-hidden' );
                    }
                    else {
                        _dom_element.classList.add( 'shinken-hidden' );
                    }
                    break;
                case PROPERTY.CONST.NAME.CONTACT_GROUPS:
                    _check_in_host.updateHtmlGroupAfterChange();
                    break;
            }
            _check_in_host.updateOverrideStatus();
            App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
        }
        if ( property.is_mass_change ) {
            var _to_set = property.getDataToSaveMassChange() ? 1 : 0;
            if ( property.is_mass_change_deleted ) {
                _to_set = 0;
            }
            property.getCounterUserSet().update( property.getNameOrUUID(), _to_set );
            if ( property.type === PROPERTY.CONST.TYPES.DATA ) {
                if ( !property.is_mass_change_deleted ) {
                    if ( property.status === PROPERTY.CONST.DATA.STATUS.NEW ) {
                        CONTROLLER.MassChange.updateDataUserCounter( property.uuid, _to_set );
                    }
                    else {
                        CONTROLLER.MassChange.updateDataUserCounter( property.name, _to_set );
                    }
                }
            }
            var _button = CONTROLLER.MassChange.steps.getNextButton();
            if ( _button.user_set.counter_final && !_button.errors.counter_final ) {
                _button.dom_element.classList.remove( "shinken-disabled" );
            }
            else {
                _button.dom_element.classList.add( "shinken-disabled" );
            }
        }
        
        if ( property_name === MANAGER.__instance_element_distributor.current_element.key_name ) {
            var property_value                                                = SHINKEN.TOOLS.STRING.replaceAll( property.getValue(), SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE, SHINKEN.TOOLS.STRING.CONST.NON_BREAK_SPACE );
            document.getElementById( 'shinken-title-page-edition' ).innerText = property_value;
            if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
                App.Elements.ChecksTab.updateCurrentElementName( property_value );
            }
            if ( MANAGER.__instance_element_distributor.current_element.is_dfe ) {
                var _message = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( property.component_input.key_validation, property.component_input.getValue() );
                _message.addMessage( COMPONENT.CONST.STATUS.BEWARE, _( 'element.tooltip_dfe_deleted_part_3' ) );
                _message.footer = _( 'element.tooltip_dfe_deleted_part_2' );
                _message.buildMessage();
                property.component_input.setMessage( _message );
            }
        }
    },
    getObjectLink                              : function ( property ) {
        var _to_return    = [];
        var property_name = property.getName();
        if ( property.is_override ) {
            property_name = property.override_prop_name;
        }
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.EDITION_CONTACTS;
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS;
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.VIEW_CONTACTS;
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS;
                break;
            case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD;
                break;
            case PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME:
            case PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE:
            case PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK:
            case PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS;
                break;
            case PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE;
                _to_return[ 2 ] = PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK;
                _to_return[ 3 ] = PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK;
                break;
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                _to_return[ 0 ] = PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE;
                _to_return[ 1 ] = PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE;
                break;
            case PROPERTY.CONST.NAME.USE:
                if ( MANAGER.__instance_element_distributor.current_element.canHaveUserRights() ) {
                    _to_return[ 0 ] = PROPERTY.CONST.NAME.VIEW_CONTACTS;
                    _to_return[ 1 ] = PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS;
                }
                break;
        }
        if ( property.is_override ) {
            for ( var i = 0, _size_return = _to_return.length; i < _size_return; i++ ) {
                _to_return[ i ] = PROPERTY.BuildOverrideName( _to_return[ i ], property );
            }
        }
        return _to_return;
    },
    clickOnDeleteItemSelectorMassChange        : function ( property, key_name ) {
        this._synchronizeMassChangesSelector( property.getSelector(), key_name, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ], PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE );
        if ( property.synchronized_elements ) {
            this.updateSynchronizedTags( property, key_name );
        }
    },
    clickOnItemSelectorMassChange              : function ( property, target_component, key_name, dom_element ) {
        switch ( target_component ) {
            case property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ]:
                property.unset();
                switch ( property.type ) {
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].cleanAllItemsSelected( "shinken-selected-mass-change" );
                        property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].cleanAllItemsSelected( "shinken-selected-mass-change" );
                        break;
                }
                break;
            case property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ]:
                this._synchronizeMassChangesSelector( target_component, key_name, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ] );
                break;
            case property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ]:
                if ( property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getLastSelectedElement().element.name === PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE ) {
                    this._synchronizeMassChangesSelector( target_component, key_name, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ] );
                }
                else {
                    this._synchronizeMassChangesSelector( target_component, key_name, property.getSelector() );
                }
                break;
            case property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ]:
                if ( target_component.getValue() === PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON ) {
                    switch ( property.last_list_element_selected ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                            property.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE, null, property.getSelector() );
                            break;
                    }
                }
                break;
            case property.getSelector():
                switch ( property.type ) {
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        this._synchronizeMassChangesSelector( target_component, key_name, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ], PROPERTY.CONST.MASS_CHANGE.ACTION.ADD );
                        break;
                }
                if ( property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] && property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() === PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON ) {
                    switch ( key_name ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                            property.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] );
                            break;
                    }
                }
                break;
            default:
                break;
        }
    },
    _synchronizeMassChangesSelector            : function ( target_component, key_name, selector, action ) {
        switch ( target_component.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                var _elem = selector.list_element.list[ selector.list_element.list_mapping[ key_name ] ];
                if ( _elem ) {
                    _elem.setSelected( action === PROPERTY.CONST.MASS_CHANGE.ACTION.ADD, "shinken-selected-mass-change" );
                }
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                if ( target_component.previous_selected_key_name ) {
                    var _previous_key_dom_element = selector.list_element.list[ selector.list_element.list_mapping[ target_component.previous_selected_key_name ] ];
                    _previous_key_dom_element.setSelected( false, "shinken-selected-mass-change" );
                }
                if ( key_name !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                    selector.list_element.list[ selector.list_element.list_mapping[ key_name ] ].setSelected( true, "shinken-selected-mass-change" );
                }
                break;
        }
    },
    _synchronizeMassChangesSelectorAfterSynchro: function ( property, property_synchro, list_to_change, is_remove ) {
        var _action = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        var _values = [];
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                _values = property.getSplitValueUser();
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                _values = [property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue(), property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue()];
                break;
        }
        var _current_name;
        for ( var i = 0, _size_i = list_to_change.length; i < _size_i; i++ ) {
            _current_name = list_to_change[ i ].getName();
            this.setSelectedMassChange( property, _current_name, is_remove, property_synchro );
            if ( SHINKEN.TOOLS.ARRAY.contains( _values, _current_name ) ) {
                switch ( _action ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                        property.clickOnDeleteItemSelector( _current_name );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                        list_to_change[ i ].dom_element.classList.add( "shinken-tag-disabled" );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                        property.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                        break;
                }
            }
        }
    },
    setSelectedMassChange                      : function ( property, current_name, is_remove, property_synchro ) {
        var _current_list = property.getSelector().list_element;
        _current_list.list[ _current_list.list_mapping[ current_name ] ].setSelected( !is_remove, "shinken-selected-mass-change", property_synchro.getName() );
        _current_list = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].list_element;
        _current_list.list[ _current_list.list_mapping[ current_name ] ].setSelected( !is_remove, "shinken-selected-mass-change", property_synchro.getName() );
        _current_list = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].list_element;
        _current_list.list[ _current_list.list_mapping[ current_name ] ].setSelected( !is_remove, "shinken-selected-mass-change", property_synchro.getName() );
    },
    updateSynchronizedTags                     : function ( property, key_name ) {
        var _keys = Object.keys( property.synchronized_elements );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = property.synchronized_elements[ _keys[ i ] ];
            for ( var j = 0, _size_j = _current.length; j < _size_j; j++ ) {
                if ( _current[ j ].getName() === key_name ) {
                    _current[ j ].dom_element.classList.remove( "shinken-tag-disabled" );
                }
            }
        }
    }
};
var __shinken_debug_time_start = Date.now();
var __shinken_debug            = SHINKEN.HIGHWAY.getParams( 'shinken_debug' );
document.addEventListener( "DOMContentLoaded", function ( e ) {
    test_user_change();
    if ( __shinken_debug ) {
        MANAGER.__instance_loading.addDebug( 'Dom is ready', MANAGER.__instance_loading.getDebugTimer() );
    }
    if ( MANAGER.WindowModalManager ) {
        MANAGER.__instance_window_modal_manager = new MANAGER.WindowModalManager();
    }
    try {
        if ( typeof current_shinken_user !== 'undefined' ) {
            var _shinken_user = new OBJECT.ShinkenElement();
            _shinken_user.updateData( current_shinken_user );
            MANAGER.__instance_element_distributor.setCurrentUser( _shinken_user );
        }
        if ( document.getElementById( 'shinken-id-navigation-table' ) ) {
            setInterval( ask_menu_update, 30000 );
        }
        doActionWhenDomReady();
    }
    catch ( e ) {
        console.warn( "NO ACTION EXPECTED WHEN DOM READY", e );
    }
} );
MANAGER.LoadingManager           = function () {
    this.is_ready = false;
};
MANAGER.LoadingManager.prototype = {
    isReady      : function () {
        return this.is_ready;
    },
    setIsReady   : function ( to_set ) {
        this.is_ready = to_set;
        if ( __shinken_debug ) {
            MANAGER.__instance_loading.addDebug( 'JS is ready', MANAGER.__instance_loading.getDebugTimer() );
        }
        if ( this.is_ready ) {
            if ( SHINKEN.HIGHWAY.getParams( 'shinken_doc' ) ) {
                doActionWhenReadyDocumentation();
            }
            if ( SHINKEN.HIGHWAY.getParams( 'shinken_test_auto' ) ) {
                setTimeout( function () {
                    doActionWhenReadyTestAuto();
                }, 500 );
            }
        }
        if ( __shinken_debug ) {
            MANAGER.__instance_loading.addDebug( 'Template number', MANAGER.__instance_element_distributor.list_templates.size );
            MANAGER.__instance_loading.addDebug( 'Template number computed', MANAGER.__instance_element_distributor.list_templates.size_computed );
            MANAGER.__instance_loading.addDebug( 'Shinken element', MANAGER.__instance_element_distributor.getNumberShinkenElement() );
        }
    },
    addDebug     : function ( label, value ) {
        if ( !__shinken_debug ) {
            return;
        }
        var _dom_row        = DOM.Service.createElement( 'tr', {} );
        var _dom_label_cell = DOM.Service.createElement( 'td', {}, label );
        var _dom_value_cell = DOM.Service.createElement( 'td', {}, value );
        
        _dom_row.appendChild( _dom_label_cell );
        _dom_row.appendChild( _dom_value_cell );
        
        document.getElementById( 'id-shinken-debug-table' ).appendChild( _dom_row );
    },
    getDebugTimer: function () {
        if ( !__shinken_debug ) {
            return;
        }
        return Date.now() - __shinken_debug_time_start + ' ms';
    },
    showLoading  : function ( progress_state ) {
        var loading_text = document.getElementById( "loading_text" );
        if ( loading_text ) {
            loading_text.innerHTML = progress_state;
        }
        var container_loading_bar = document.getElementById( "container_loading_bar" );
        if ( container_loading_bar ) {
            container_loading_bar.classList.remove( "hide" );
        }
        var loading_page = document.getElementById( "loading_page" );
        if ( loading_page ) {
            loading_page.classList.remove( "hide" );
        }
    },
    removeLoading: function () {
        var container_loading_bar = document.getElementById( "container_loading_bar" );
        if ( container_loading_bar ) {
            container_loading_bar.classList.add( "hide" );
        }
        var loading_page = document.getElementById( "loading_page" );
        if ( loading_page ) {
            loading_page.classList.add( "hide" );
        }
        var loading_text = document.getElementById( "loading_text" );
        if ( loading_text ) {
            loading_text.innerHTML = "";
        }
    }
};
MANAGER.__instance_loading = new MANAGER.LoadingManager();
function test_user_change () {
    if ( !MANAGER.__instance_element_distributor.current_user ) {
        setTimeout( function () {
            test_user_change();
        }, 1000 );
        return;
    }
    var user_log_id_local = MANAGER.__instance_element_distributor.current_user.uuid || '';
    var user_stock        = sessionStorage.getItem( "user_id" );
    if ( user_log_id_local ) {
        if ( !user_stock ) {
            sessionStorage.setItem( "user_id", user_log_id_local );
        }
        else if ( user_log_id_local != user_stock ) {
            setTimeout( function () {
                alert( App.Scope.format( _( 'element.the_user_changed' ), MANAGER.__instance_element_distributor.current_user.contact_name ) );
            }, 1 );
            sessionStorage.setItem( "user_id", user_log_id_local );
        }
    }
}
document.onwheel = SHINKEN_TOOLTIP.hideTooltip;
document.addEventListener( "DOMContentLoaded", function ( e ) {
    MANAGER.__instance_navigator_size.run();
} );
MANAGER.NavigatorSizeManager           = function () {
    this._interval;
    this._check_top_shinken_content = true;
    this.init_done                  = false;
};
MANAGER.NavigatorSizeManager.prototype = {
    run                 : function () {
        setTimeout( function () {
            MANAGER.__instance_navigator_size.checkSizes();
        }, 100 );
        this._interval = setInterval( function () {
            MANAGER.__instance_navigator_size.checkSizes();
        }, 4000 );
    },
    initDomElements     : function () {
        this.dom_element_shinken_navigation_table = document.getElementById( 'shinken-id-navigation-table' );
        this.dom_element_shinken_menu_top_bar     = document.querySelector( '.shinken-menu-top-bar' );
        this.dom_element_shinken_content          = document.querySelector( '.shinken-content' );
        var _width_button_log                     = document.querySelector( '.shinken-quit-cell' ).getBoundingClientRect().width;
        var _width_logo_shinken                   = document.querySelector( '.shinken-logo-cell' ).getBoundingClientRect().width;
        var _width_back_button                    = document.querySelector( '.shinken-arrow-back-block-cell' ).getBoundingClientRect().width;
        this.width_nav_bar_used                   = _width_button_log + _width_back_button + _width_logo_shinken;
        this.init_done                            = true;
    },
    checkSizes          : function () {
        this._menu_elements();
        if ( this._check_top_shinken_content ) {
            this._top_shinken_content();
        }
        if ( CONTROLLER.MassChange && CONTROLLER.MassChange.steps ) {
            CONTROLLER.MassChange.computeSizes();
        }
        if ( CONTROLLER.ShinkenElement ) {
            CONTROLLER.ShinkenElement.computeSizes();
        }
    },
    tab_data_exclude    : function () {
        var _dom_element = document.querySelector( "#checks.shinken-host-check-window-container" );
        if ( _dom_element ) {
            if ( _dom_element.dataset.tabSelected === "2" ) {
                var _prop_exclude = document.getElementById( 'id-shinken-exclude-property-container' );
                if ( _prop_exclude ) {
                    var _height                                                                 = _prop_exclude.getBoundingClientRect().height;
                    _dom_element.querySelector( '.shinken-scroll-without-header' ).style.height = "calc(100% - " + _height + "px)";
                }
            }
            else {
                _dom_element.querySelector( '.shinken-scroll-without-header' ).style.height = "100%";
            }
        }
    },
    _menu_elements      : function () {
        if ( !this.dom_element_shinken_navigation_table ) {
            return;
        }
        var _rect = this.dom_element_shinken_navigation_table.getBoundingClientRect();
        
        if ( _rect.width + this.width_nav_bar_used > window.innerWidth ) {
            var _data_responsive = parseInt( this.dom_element_shinken_menu_top_bar.dataset.responsive );
            if ( _data_responsive < 4 ) {
                DOM.Service.setDataSet( this.dom_element_shinken_menu_top_bar, "responsive", _data_responsive + 1 );
                this._menu_elements();
            }
        }
        else {
            setTimeout( function () {
                DOM.BodyService.askAddClass("shinken-menu-ready");
            }, 10 )
        }
    },
    _top_shinken_content: function () {
        this._check_top_shinken_content = false;
        if ( !this.dom_element_shinken_content || !this.dom_element_shinken_menu_top_bar ) {
            return;
        }
        var _height                                      = this.dom_element_shinken_menu_top_bar.getBoundingClientRect().height;
        this.dom_element_shinken_content.style.top       = _height + 'px';
        this.dom_element_shinken_content.style.height    = 'calc(100% - ' + _height + 'px)';
        this.dom_element_shinken_content.style.maxHeight = 'calc(100% - ' + _height + 'px)';
    },
    resizeDone          : function () {
        if ( !this.init_done ) {
            this.initDomElements();
        }
        if ( !this._interval ) {
            return;
        }
        DOM.Service.setDataSet( this.dom_element_shinken_menu_top_bar, "responsive", 0 );
        this._check_top_shinken_content                          = true;
        this.checkSizes();
        if( CONTROLLER.List ){
            CONTROLLER.List.resizeDone();
        }
    }
};
MANAGER.__instance_navigator_size = new MANAGER.NavigatorSizeManager();
function action_when_resizing () {
    MANAGER.__instance_navigator_size.resizeDone();
    var _dom_area_header        = $( '.shinken-area-header' );
    var _dom_form               = $( '#id-shinken-form-element' );
    var _dom_right_column       = $( '#right-column' );
    var _dom_left_column        = $( '#left-column' );
    var _dom_element_list_panel = $( '.elements-list-panel' );
    
    /**********************
     * Resize LIST
     *********************/
    App.Scope.adjustHeight( $( '#top-list-container' ), _dom_element_list_panel, $( '.elements-panel' ), false );
    App.Scope.adjustHeight( $( '.header-background' ), $( '.body-background' ), _dom_element_list_panel );
    
    /*******************************
     * Resize Page Edition element
     *******************************/
    /**************************************
     * Page Edition element - Resize HELP
     **************************************/
    var _dom_info_area     = $( '.info-area' );
    var _dom_info_box_help = $( '.info-box.help' );
    var _dom_action_area   = $( '.action-area' );
    
    /*******************************
     * Resize Page Production
     *******************************/
    App.Scope.adjustHeight( $( '.main-header' ), $( '.main-content' ), $( '#main-right' ) );
    App.Scope.adjustHeight( _dom_action_area, $( '#left-panel-error' ), _dom_left_column );
    
    /*******************************
     * Resize Page Source and Tagger
     *******************************/
    App.Scope.adjustHeightMulti( $( '.table-head-js' ), $( '.table-body-js' ), $( '.table-shinken-js' ), false );
    
    /*******************************
     * Reposition Add Comment pop-up
     *******************************/
    var _element_add_comment_specific = document.getElementById( "comment-to-submit-for-staging" );
    if ( _element_add_comment_specific && _element_add_comment_specific.classList.contains( "active" ) ) {
        document.getElementById( "element-btn-submit-to-stagging-add-comment" ).click();
    }
    var _element_add_comment_list = document.getElementById( "comment-to-action-launch" );
    if ( _element_add_comment_list && _element_add_comment_list.classList.contains( "active" ) ) {
        var _element = document.querySelector( "#btn-action-launch-add-comment .label-button-mass-action" );
        if ( _element ) {
            _element.click();
        }
    }
}
$( window ).resize( action_when_resizing );
$( document ).ready( function () {
    $( window ).trigger( 'resize' );
} );
MANAGER.OverrideUnvalidManager           = function () {
};
MANAGER.OverrideUnvalidManager.prototype = {
    init                  : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
        }
        this.overrides         = {};
        this.size              = 0;
        var _unvalid_overrides = this.findAllUnvalidOverride();
        var _to_add;
        for ( var i = 0, _size_i = _unvalid_overrides.length; i < _size_i; i++ ) {
            _to_add = new OBJECT.ServiceOverrideUnvalid( i, _unvalid_overrides[ i ] );
            this.addOverride( _to_add );
        }
        this.computeSize();
    },
    addOverride           : function ( override_unvalid ) {
        switch ( override_unvalid.type ) {
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK:
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK_FINAL:
                var _check_name = override_unvalid.getCheckName();
                if ( !this.overrides[ _check_name ] ) {
                    this.overrides[ _check_name ] = new OBJECT.ServiceOverrideUnvalids( _check_name );
                    this.overrides[ _check_name ].setType( override_unvalid.type );
                }
                this.overrides[ _check_name ].addUnvalidOverride( override_unvalid );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_CHECK_INACTIVE:
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_INACTIVE:
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_NOT_USED:
                var _check_uuid = override_unvalid.getCheckUuid();
                if ( !this.overrides[ _check_uuid ] ) {
                    this.overrides[ _check_uuid ] = new OBJECT.ServiceOverrideUnvalids( _check_uuid );
                    this.overrides[ _check_uuid ].setType( override_unvalid.type );
                    this.overrides[ _check_uuid ].setCheck( MANAGER.__instance_element_distributor.getElement( 'core-service-' + _check_uuid ) );
                    this.overrides[ _check_uuid ].setHost( MANAGER.__instance_element_distributor.getElement( 'core-host-' + override_unvalid.getHostUuid() ) );
                }
                this.overrides[ _check_uuid ].addUnvalidOverride( override_unvalid );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT:
                var _check_uuid = override_unvalid.getCheckUuid();
                var _dfe_key    = override_unvalid.getDfeKey();
                var _key        = _check_uuid + "-" + _dfe_key;
                if ( !this.overrides[ _key ] ) {
                    this.overrides[ _key ] = new OBJECT.ServiceOverrideUnvalids( _check_uuid );
                    this.overrides[ _key ].setType( override_unvalid.type );
                    this.overrides[ _key ].setCheck( MANAGER.__instance_element_distributor.getElement( 'core-service-' + _check_uuid ) );
                    this.overrides[ _key ].setHost( MANAGER.__instance_element_distributor.getElement( 'core-host-' + override_unvalid.getHostUuid() ) );
                    this.overrides[ _key ].setDfeKey( _dfe_key );
                }
                this.overrides[ _key ].addUnvalidOverride( override_unvalid );
                break;
        }
    },
    buildHtml             : function () {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-override-disabled-container" } );
        DOM.Service.addElementTo( this.buildHtmlSeparator(), _to_return );
        var _tobuild = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( SHINKEN.TOOLS.ARRAY.getMapValues( this.overrides ), [ "type", "name" ] );
        for ( var i = 0, _size_i = _tobuild.length; i < _size_i; i++ ) {
            DOM.Service.addElementTo( _tobuild[ i ].buildHtml(), _to_return );
        }
        this.dom_element = _to_return;
        return _to_return;
    },
    buildHtmlSeparator    : function () {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-separator-override-disabled" } );
        var _text      = _( 'element.override_disabled' );
        var _to_add    = DOM.Service.createElement( "div", { class: "shinken-host-in-page-host-title" }, _text );
        var _hr        = DOM.Service.createElement( "hr", { class: 'shinken-hr-sample' } );
        _to_return.appendChild( _to_add );
        _to_return.appendChild( _hr );
        return _to_return;
    },
    deleteOverride        : function ( type, name ) {
        this.overrides[ name ].delete();
        delete this.overrides[ name ];
        this.computeSize();
        if ( !this.size ) {
            DOM.Service.removeElement( this.dom_element );
        }
        fire_element_is_modifie();
    },
    computeSize           : function ( type, name ) {
        this.size = Object.keys( this.overrides ).length;
        MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.CHECKS, false, MANAGER.__instance_element_distributor.current_element.uuid ).setWarning( "unvalid-override-manager", MANAGER.__instance_override_unvalid.size );
        var any_check_message = document.querySelector( '.shinken-any-check-message' );
        if ( any_check_message ) {
            if ( this.size ) {
                any_check_message.classList.remove( 'text-middle' );
            }
            else {
                any_check_message.classList.add( 'text-middle' );
            }
        }
    },
    findAllUnvalidOverride: function () {
        var _to_return = [];
        var _overrides = MANAGER.__instance_element_distributor.current_element.override;
        if ( _overrides ) {
            var _list_host_in_page_host = App.Elements.ChecksTab.getListHostInPageHost();
            var _current;
            var _size_host              = _list_host_in_page_host.length;
            for ( var i = 0, _size = _overrides.overrides.length; i < _size; i++ ) {
                _current               = _overrides.overrides[ i ];
                _current.is_not_linked = true;
                for ( var j = 0; j < _size_host; j++ ) {
                    if ( _list_host_in_page_host[ j ].isOverrideLinkTo( _current ) ) {
                        _current.is_not_linked = false;
                        break;
                    }
                }
                if ( _current.is_not_linked ) {
                    if ( !_current.check_name ) {
                        var _check = MANAGER.__instance_element_distributor.getElement( "core-service-" + _current.check_uuid );
                        if ( _check ) {
                            _current.check_name = _check.getName();
                        }
                        _current.computeCompleteDefinition();
                    }
                    _to_return.push( _current );
                }
            }
        }
        
        var _prop_override = MANAGER.__instance_property_distributor.getAllOverrideProp();
        _prop_override     = SHINKEN.TOOLS.ARRAY.sortArray( _prop_override, "name" );
        for ( var i = 0, _size_override = _prop_override.length; i < _size_override; i++ ) {
            _current = _prop_override[ i ];
            if ( _current.is_not_linked ) {
                _current.complete_definition = 'service_overrides ' + _current.override_check_name + ',' + _current.override_prop_name + ' ' + _current.getDataToSaveFinal();
                _current.check_name          = _current.override_check_name;
                _current.property            = _current.override_prop_name;
                _current.label               = _current.getDataToSaveFinal();
                _to_return.push( _current );
            }
        }
        return _to_return;
    }
};
MANAGER.__instance_override_unvalid      = new MANAGER.OverrideUnvalidManager();
MANAGER.WindowModalManager           = function () {
    this.dom_element         = document.getElementById( 'id-shinken-window-modal' );
    this.dom_element_content = this.dom_element.querySelector( '.shinken-window-modal-content' );
    this.dom_element_close = this.dom_element.querySelector( '#id-shinken-window-modal-close' );
};
MANAGER.WindowModalManager.prototype = {
    setContent: function ( to_set ) {
        this.dom_element_content.innerHTML = to_set;
        this.dom_element.classList.remove( "shinken-hidden" );
    },
    showCloseContainer: function () {
        this.dom_element_close.classList.remove( "shinken-hidden" );
    },
    setIframe : function ( url_to_set ) {
        var _to_set = '<iframe src="' + url_to_set + '"></iframe>';
        this.setContent( _to_set );
    },
    close     : function () {
        this.dom_element_content.innerHTML = '';
        this.dom_element.classList.add( "shinken-hidden" );
        this.dom_element_close.classList.add( "shinken-hidden" );
    }
};
MANAGER.__instance_window_modal_manager; //INIT IN LOADING MANAGER
MANAGER.WorkFlowManager = {
    dom_element_body: null,
    state           : null,
    setState        : function( state ) {
        this.state = state;
        DOM.Service.setDataSet( this.getDomElement(), 'stateWorkFlow', state );
        var save_in_staging         = (this.state === MANAGER.CONST.STATE.WORK_FLOW.STAGING ? '1' : '0');
        var params                  = SHINKEN.HIGHWAY.getParams();
        params[ 'save_in_staging' ] = save_in_staging;
        SHINKEN.HIGHWAY.changeUrl( SHINKEN.HIGHWAY.getPath() + SHINKEN.HIGHWAY.buildParamsToUrl( params ) );
    },
    getState        : function() {
        if ( !this.state ) {
            this.state = this.getDomElement().dataset.stateWorkFlow;
        }
        return this.state;
    },
    clickOnTabArea  : function( to_set ) {
        this.setState( to_set );
        if ( CONTROLLER.List ) {
            CONTROLLER.List.mass_action.computeTitleSelect();
        }
        $( window ).trigger( 'resize' );
    },
    getDomElement   : function() {
        if ( !this.dom_element_body ) {
            this.dom_element_body = document.querySelector( 'body' );
        }
        return this.dom_element_body;
    }
};
SHINKEN.MODAL = (function( self ) {
    "use strict";
    
    var getDomElementAnchor = function() {
        if ( !self.dom_element_anchor ) {
            self.dom_element_anchor = document.getElementsByClassName( self.MODAL_ANCHOR )[ 0 ];
        }
        return self.dom_element_anchor;
    };
    
    var move        = function( xpos, ypos ) {
        self.getElement().style.top  = ypos + 'px';
        self.getElement().style.left = xpos + 'px';
    };
    var startMoving = function( container, evt ) {
        evt                    = evt || window.event;
        var modal              = self.getElement();
        var bounding_modal     = modal.getBoundingClientRect();
        var bounding_container = container.getBoundingClientRect();
        var posX               = evt.clientX;
        var posY               = evt.clientY;
        var divTop             = bounding_modal.top;
        var divLeft            = bounding_modal.left;
        var eWi                = parseInt( bounding_modal.width );
        var eHe                = parseInt( bounding_modal.height );
        var cTop               = parseInt( bounding_container.top );
        var cLeft              = parseInt( bounding_container.left );
        var cWi                = parseInt( bounding_container.width );
        var cHe                = parseInt( bounding_container.height );
        var diffX              = posX - divLeft;
        var diffY              = posY - divTop;
        document.onmousemove   = function( evt ) {
            evt      = evt || window.event;
            var posX = evt.clientX,
                posY = evt.clientY,
                aX   = posX - diffX,
                aY   = posY - diffY;
            if ( aX < cLeft ) {
                aX = cLeft;
            }
            if ( aY < cTop ) {
                aY = cTop;
            }
            if ( aX + eWi > cWi + cLeft ) {
                aX = cWi - eWi + cLeft;
            }
            if ( aY + eHe > cHe + cTop ) {
                aY = cHe - eHe + cTop;
            }
            move( aX, aY );
        };
    };
    var stopMoving  = function( container ) {
        document.onmousemove = function() {
        };
    };
    
    self.MODAL_ID           = "shinken-modal";
    self.MODAL_ANCHOR       = "shinken-modal-anchor";
    self.dom_element        = null;
    self.dom_element_anchor = null;
    self.is_visible         = false;
    
    self.toggle     = function() {
        self.is_visible ? self.hide() : self.show();
    };
    self.show       = function() {
        self.is_visible = true;
        SHINKEN.DOM.show( self.getElement() );
    };
    self.hide       = function() {
        self.is_visible = false;
        SHINKEN.DOM.hide( self.getElement() );
    };
    self.getElement = function() {
        if ( !self.dom_element ) {
            self.dom_element = document.getElementById( self.MODAL_ID );
        }
        return self.dom_element;
    };
    
    self.setDraggable = function( isDraggable, container ) {
        if ( isDraggable ) {
            getDomElementAnchor().onmousedown = function( e ) {
                startMoving( container, e );
            };
            getDomElementAnchor().onmouseup   = function( e ) {
                stopMoving( container );
            };
        }
        else {
            getDomElementAnchor().onmousedown = null;
            getDomElementAnchor().onmouseup   = null;
        }
    };
    self.createHtmlAndAddToBody = function() {
        var _html = '<div id="shinken-modal" class="shinken-modal" tabindex="-1" role="dialog" style="display: none;" data-backdrop="false">' +
                    '    <div class="modal-header shinken-modal-anchor">' +
                    '        <button type="button" class="btn btn-close-modal" onclick="javascript:SHINKEN.MODAL.hide();">' +
                    '            <i class="shinkon-times-bold"></i>' +
                    '        </button>' +
                    '        <h3 id="saving-log-modal-header" class="saving-log-modal-header"></h3>' +
                    '    </div>' +
                    '    <div id="saving-log-modal-body" class="modal-body"></div>' +
                    '</div>'
        var _to_return = DOM.Service.createElement("div", "shinken-modal-container", _html);
        DOM.BodyService.getDomElement().appendChild(_to_return);
    };
    
    return self;
})( SHINKEN.MODAL || {} );
OBJECT.CheckInPageHost            = function( shinken_element, parent, dfe_object ) {
    this.element = shinken_element;
    this.init( parent );
    this.setDfeObject( dfe_object );
};
OBJECT.CheckInPageHost.prototype  = {
    init                                : function ( parent ) {
        this.uuid          = this.element.uuid;
        this.name          = this.element.service_description;
        this.parent_name   = parent.getName();
        this.parent_uuid   = parent.uuid;
        this.key_dfe       = "";
        this.is_dfe        = !!this.element.is_dfe;
        this.name_check    = this.element.service_description;
        this.has_error_dfe = false;
        this.has_warning_proctected_dfe = false;
        this.initCounters( parent );
        this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.NONE );
        this.is_bp_rule_command = false;
        if ( this.element && this.element[ PROPERTY.CONST.NAME.CHECK_COMMAND ] && this.element[ PROPERTY.CONST.NAME.CHECK_COMMAND ].split( '!' )[ 0 ] === 'bp_rule' ) {
            this.is_bp_rule_command = true;
        }
        this.getExcludeStatus();
    },
    linkDomElements                     : function () {
        this.dom_element                     = document.getElementById( 'id-shinken-check-line-' + this.getDomUUID() );
        this.dom_element_command             = this.dom_element.querySelector( '.shinken-tab-check-col-command-data' );
        this.dom_element_name                = this.dom_element.querySelector( '.shinken-tab-check-col-name' );
        this.dom_element_tags                = this.dom_element.querySelector( '.shinken-tab-check-col-tags' );
        this.dom_element_group_notification  = this.dom_element.querySelector( '.shinken-tab-check-col-contacts-groups' );
        this.dom_element_hidden              = this.dom_element.querySelector( '.shinken-check-hidden' );
        this.dom_element_dfe                 = this.dom_element.querySelector( '.shinken-tab-check-col-dfe' );
        this.dom_element_try_check_container = document.getElementById( 'tr-check-run-' + this.getDomUUID() );
        this.dom_element_try_check_close_btn = this.dom_element.querySelector( '.shinken-hide-eval' );
        this.initCountersDom();
        this.button_override = new COMPONENT.Button( this.dom_element.querySelector( '.shinken-check-override-tag.shinken-overridden' ) );
        this.button_override.initCounters();
        this.button_override.getCounterError().setLabel( _( 'element.errors' ) );
        this.button_override.getCounterWarning().setLabel( _( 'source.warnings' ) );
        this.button_override.getCounterError().setParent( this.getCounterError() );
        this.button_override.getCounterWarning().setParent( this.getCounterWarning() );
        
        this.tag_information = new COMPONENT.TagInformation( this.dom_element.querySelector( '.shinken-information-tag' ) );
        switch ( this.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                this.tag_information.setParams( [this.parent_name] );
                this.tag_information.setStatus( COMPONENT.CONST.TAG_INFORMATION.STATUS.CHECK_DUPLICATE );
                break;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
                break;
        }
    },
    setDfeObject                        : function ( to_set ) {
        this.dfe_object        = to_set || '';
        this.dfe_property      = this.dfe_object ? this.dfe_object.property_name : '';
        this.dfe_property_name = this.dfe_property ? this.dfe_property.substr( 1 ) : '';
        this.is_duplicate      = false;
        if ( this.dfe_object.is_duplicate && this.dfe_object.key ) {
            this.is_duplicate = true;
        }
        if ( this.is_dfe ) {
            this.has_error_dfe = false;
            this.key_dfe       = this.dfe_object.key;
            if ( this.is_duplicate ) {
                this.name = this.name_check.replace( '$KEY$', this.dfe_object.key );
            }
            else if ( this.dfe_object._messages.hasError() ) {
                this.has_error_dfe = true;
                this.name          = this.name_check.replace( '$KEY$', "<span class='shinken-error-tag'>$KEY$</span>" );
            }
            else if ( this.dfe_object.is_dfe_protected ) {
                this.has_warning_proctected_dfe = true;
                this.name                       = this.name_check.replace( '$KEY$', "<span class='shinken-warning-tag'>$KEY$</span>" );
            }
            else {
                this.name = this.name_check.replace( '$KEY$', this.dfe_object.key );
            }
            App.DFE.getDefaultArgsByCheck( this.dfe_object, this.element );
            this.getExcludeStatus();
        }
        
    },
    setStatus                           : function ( to_set, forced ) {
        if ( to_set === OBJECT.CONST.CHECK_IN_HOST.STATUS.NONE && this.is_dfe && this.status === OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE && !forced ) {
            return;
        }
        this.status = to_set;
        this.setError( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME, this.status === OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME ? 1 : 0 );
        this.buildClass();
        this.computeCounters();
    },
    getDomUUID                          : function () {
        if ( this.is_dfe ) {
            if ( this.dfe_object && this.dfe_object._messages && this.dfe_object._messages.hasError() ){
                return this.parent_uuid + '-' + this.uuid + '-' + SHINKEN.TOOLS.STRING.cleanXss(this.key_dfe);
            }
            return this.parent_uuid + '-' + this.uuid + '-' + this.key_dfe;
        }
        return this.parent_uuid + '-' + this.uuid;
    },
    
    changeExcludeStatus                 : function () {
        MANAGER.__instance_element_distributor.current_element.changeExcludeStatus( this );
        this.updateExcludeStatus();
        fire_element_is_modifie();
        App.Elements.ChecksTab.computeCheckNameIfAlreadyExist();
    },
    getExcludeStatus                    : function () {
        this.exclude_status = MANAGER.__instance_element_distributor.current_element.getExcludeStatus( this );
        if ( this.exclude_status === OBJECT.CONST.EXCLUDE_STATUS.OFF ) {
            var _service_exclude = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.SERVICE_EXCLUDES );
            if ( _service_exclude ) {
                var _exclude_by_name = _service_exclude.getFlatValue();
                if ( this.isNameMatching( _exclude_by_name ) ) {
                    this.exclude_status = OBJECT.CONST.EXCLUDE_STATUS.BY_NAME;
                }
            }
        }
        this.computeCounters();
        return this.exclude_status;
    },
    isNameMatching                      : function ( name_to_test ) {
        return SHINKEN.TOOLS.STRING.isMatchingStarRegexTab( this.name, name_to_test.split( ',' ) );
    },
    updateHtmlNameAfterChange           : function () {
        if ( !this.dom_element_name ) {
            return;
        }
        var _name                       = this.buildNameHtml();
        this.dom_element_name.innerHTML = _name.innerHTML;
    },
    updateTooltipExcludeByName          : function () {
        if ( this.exclude_status === OBJECT.CONST.EXCLUDE_STATUS.BY_NAME ) {
            var _tooltip_container = this.dom_element.querySelector( '.shinken-exclude-by-name-tooltip-container' );
            if ( _tooltip_container ) {
                var _name_flat = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.SERVICE_EXCLUDES ).getFlatValue();
                var _text      = SHINKEN.TOOLS.STRING.format( _( 'element.check_exclude_by_name_tooltip' ), _( 'help-hosts.service_excludes-title' ), _name_flat );
                _tooltip_container.setAttribute( 'shi-tip-html', _text );
            }
        }
    },
    updateHtmlGroupAfterChange          : function () {
        var _group                                    = this.buildContactGroupHtml();
        this.dom_element_group_notification.innerHTML = _group.innerHTML;
    },
    updateHtmlCommandAfterChange        : function () {
        var _command                       = this.buildCommandHtml();
        this.dom_element_command.innerHTML = _command.innerHTML;
    },
    updateExcludeStatus                 : function () {
        DOM.Service.setDataSet( this.dom_element, 'excludeStatus', this.getExcludeStatus() );
        this.updateTooltipExcludeByName();
    },
    updateHtmlAfterOverrideCommandChange: function ( property ) {
        if ( property.override_check_uuid === this.uuid ) {
            this.updateHtmlCommandAfterChange();
        }
    },
    updateHtmlAfterDataChange           : function ( dfe_object ) {
        this.updateHtmlCommandAfterChange();
        if ( dfe_object !== undefined ) {
            this.setDfeObject( dfe_object );
        }
        var _dfe                       = this.computeTDFEHtml();
        this.dom_element_dfe.innerHTML = _dfe.innerHTML;
        this.updateHtmlNameAfterChange();
    },
    deleteHtml                          : function ( container, host_in_page_host ) {
        container.removeChild( this.dom_element );
        container.removeChild( document.getElementById( 'tr-check-run-' + this.getDomUUID() ) );
        container.removeChild( document.getElementById( 'tr-check-override-' + this.getDomUUID() ) );
        MANAGER.__instance_property_distributor.deleteOverrideProp( this, host_in_page_host );
        this.errors.reset();
        this.warnings.reset();
        this.setError( '', 0 );
        this.setWarning( '', 0 );
    },
    buildDFESeparatorHtml               : function ( _to_return, is_even ) {
        var _class = is_even ? 'even' : 'odd';
        var _tr    = DOM.Service.createElement( "tr", { class: _class } );
        var _td1   = DOM.Service.createElement( "td", { class: 'shinken-separator', colspan: 2 }, '<hr>' );
        var _td3   = DOM.Service.createElement( "td", { class: 'shinken-separator', colspan: 3 }, '<hr>' );
        var _td2   = DOM.Service.createElement( "td", { class: 'shinken-tab-check-col-dfe text-center' }, '<span class="bold">' + this.element.duplicate_foreach.substr( 1 ) + '</span>' );
        _tr.appendChild( _td1 );
        _tr.appendChild( _td2 );
        _tr.appendChild( _td3 );
        _to_return.appendChild( _tr );
    },
    appendTryCheckHtml                  : function ( _to_return, is_even ) {
        var _class = "shinken-hidden no-hover";
        if ( is_even ) {
            _class += ' even';
        }
        else {
            _class += ' odd';
        }
        var _tr  = DOM.Service.createElement( "tr", {
            class: _class,
            id   : 'tr-check-run-' + this.getDomUUID()
        } );
        var _td  = DOM.Service.createElement( "td", {
            class  : 'col-check-run',
            colspan: 6,
            id     : 'td-check-run-' + this.getDomUUID()
        } );
        var _div = DOM.Service.createElement( "div", {
            class: 'result-check-content',
            id   : 'result-check-run-' + this.getDomUUID()
        }, '&nbsp;' );
        _tr.appendChild( _td );
        _td.appendChild( _div );
        _to_return.appendChild( _tr );
    },
    appendOverrideHtml                  : function ( _to_return ) {
        var _tr  = DOM.Service.createElement( "tr", {
            class: 'shinken-hidden shinken-tr-check-override',
            id   : 'tr-check-override-' + this.getDomUUID()
        } );
        var _td  = DOM.Service.createElement( "td", {
            class  : 'shinken-check-override-cell',
            colspan: 6,
            id     : 'td-check-override-' + this.getDomUUID()
        } );
        var _div = DOM.Service.createElement( "div", {
            class          : 'shinken-override-check-content shinken-unset',
            id             : 'result-check-override-' + this.getDomUUID(),
            'data-dom-uuid': this.getDomUUID()
        }, '&nbsp;' );
        _tr.appendChild( _td );
        _td.appendChild( _div );
        _to_return.appendChild( _tr );
    },
    setObsolete                         : function ( _to_set ) {
        this.is_obsolete = _to_set;
    },
    getName                             : function () {
        return this.name;
    },
    destroy                             : function () {
        this.getCounterTotal().reset();
        MANAGER.__instance_element_distributor.current_element.unSetOverrideCheckInPageHost( this );
    },
    appendHtml                          : function ( _to_return, is_even ) {
        var _tr = DOM.Service.createElement( "tr", {
            id                    : 'id-shinken-check-line-' + this.getDomUUID(),
            'data-override-status': this._computeOverrideStatus(),
            'data-exclude-status' : this.exclude_status,
            'data-is-dfe'         : this.is_dfe,
            'data-controller'     : "shinken-element",
            onmouseenter          : 'MANAGER.EventManager.mouseEnter(event)',
            onmouseleave          : 'MANAGER.EventManager.mouseLeave(event)',
            onclick               : 'MANAGER.EventManager.onClick(event)'
        } );
        _tr.appendChild( this.buildNameHtml() );
        _tr.appendChild( this.buildOverrideExcludeButtonCellHtml() );
        _tr.appendChild( this.computeTDFEHtml() );
        _tr.appendChild( this.buildContactGroupHtml() );
        _tr.appendChild( this.buildCommandHtml() );
        _tr.appendChild( this.buildTryCheckHtml() );
        _tr.setAttribute( 'class', this.computeHtmlClass() );
        _to_return.appendChild( _tr );
    },
    computeHtmlClass                    : function ( is_even ) {
        var _to_return = "shinken-check-line shinken-parent-event-listener";
        _to_return += is_even ? ' even' : ' odd';
        if ( this.is_bp_rule_command ) {
            _to_return += ' shinken-is-bp-rule';
        }
        _to_return += is_even ? ' even' : ' odd';
        
        switch ( this.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE:
                _to_return += ' dfe-structure-error';
                break;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
                _to_return += ' shinken-check-hidden-container';
                if ( this.dom_element_hidden ) {
                    this.dom_element_hidden.setAttribute( 'shi-tip-html', SHINKEN.TOOLS.STRING.format( _( 'element.hidden_by' ), this.check_with_same_name ) );
                }
                break;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
                _to_return += ' shinken-check-hidden-container shinken-check-duplicate-container';
                if ( this.dom_element_hidden ) {
                    this.dom_element_hidden.setAttribute( 'shi-tip-html', SHINKEN.TOOLS.STRING.format( _( 'element.hidden_by_duplicate' ), this.parent_name_with_same_check ) );
                }
                break;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                _to_return += ' shinken-check-hidden-container shinken-unvalid';
                if ( this.dom_element_hidden ) {
                    this.dom_element_hidden.setAttribute( 'shi-tip-html', SHINKEN.TOOLS.STRING.format( _( 'element.check_duplicate_on_the_same' ), this.check_with_same_name? this.check_with_same_name.name : '???' ) );
                }
                break;
        }
        return _to_return;
    },
    computeCounters                     : function () {
        if ( this.is_dfe && !this.key_dfe ) {
            return;
        }
        if ( !this.element.is_enabled ) {
            return;
        }
        switch ( this.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                this.setTotal( this.getDomUUID(), 0 );
                break;
            default:
                switch ( this.exclude_status ) {
                    case OBJECT.CONST.EXCLUDE_STATUS.BY_ID:
                    case OBJECT.CONST.EXCLUDE_STATUS.BY_NAME:
                        this.setTotal( this.getDomUUID(), 0 );
                        break;
                    default:
                        this.setTotal( this.getDomUUID(), 1 );
                        break;
                }
                break;
        }
    },
    buildClass                          : function () {
        if ( this.dom_element ) {
            this.dom_element.setAttribute( 'class', this.computeHtmlClass() );
        }
    },
    buildNameHtml                       : function () {
        var _template = document.getElementById( "id-shinken-template-check-tab-cell-name" ).innerHTML;
        if ( this.check_with_same_name ) {
            if ( this.check_with_same_name.parent_uuid === MANAGER.__instance_element_distributor.current_element.getUUID() ) {
                _template = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_parent_name_duplicate_$$$", _( "element.hidden_by_current_label" ) );
            }
            else {
                _template = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_parent_name_duplicate_$$$", SHINKEN.TOOLS.STRING.format( _( "element.hidden_by_template_label" ), this.check_with_same_name.parent_name ) );
            }
        }
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_name_$$$", SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( this.element.type, this.element.uuid, this.name ).outerHTML );
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_modulation_$$$", App.Elements.ChecksTab.createTagModulation( this ).outerHTML );
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_UUID_$$$", this.uuid );
        var _to_return = DOM.Service.createElement( "tr", {}, _template );
        return _to_return.firstElementChild;
    },
    buildOverrideExcludeButtonCellHtml  : function () {
        var _template     = document.getElementById( "id-shinken-template-check-tab-cell-override_exclude" ).innerHTML;
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_DOM_UUID_$$$", this.getDomUUID() );
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_UUID_$$$", this.uuid );
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_DFE_NAME_$$$", this.key_dfe );
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_name_$$$", this.name );
        _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_TYPE_$$$", this.element.getType() );
        var _exclude_prop = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.SERVICE_EXCLUDES );
        if ( _exclude_prop ) {
            _template = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_value_service_exclude_$$$", _exclude_prop.getFlatValue() );
        }
        var _to_return = DOM.Service.createElement( "tr", {}, _template );
        return _to_return.firstElementChild;
    },
    computeTDFEHtml                     : function () {
        var _to_return = DOM.Service.createElement( "td", { class: "shinken-tab-check-col-dfe" } );
        if ( !this.is_dfe ) {
            return _to_return;
        }
        this.setError( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 0 );
        this.setWarning( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 0 );
        if ( this.is_duplicate ) {
            _to_return.appendChild( DOM.Service.createElement( "span", {
                class         : "tag tag-error shinken-pointer-cursor",
                onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()",
                onclick       : "MANAGER.EventManager.goToDataView('" + this.dfe_property + "')",
                'shi-tip-type': SHINKEN_TOOLTIP.TYPE.ERROR_BORDER,
                'shi-tip-html': _( 'element.tooltip_dfe_same_key' ) + "<br>" + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_link_on_data' ), this.dfe_property_name )
            }, this.dfe_object.key ) );
            this.setError( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 1 );
            this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE );
        }
        else if ( this.has_error_dfe ) {
            _to_return.appendChild( DOM.Service.createElement( "span", {
                class         : "tag tag-error shinken-pointer-cursor",
                onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()",
                'shi-tip-type': SHINKEN_TOOLTIP.TYPE.ERROR_BORDER,
                onclick       : "MANAGER.EventManager.goToDataView('" + this.dfe_property + "')",
                'shi-tip-html': _( 'element.tooltip_dfe_syntax_issue' ) + "<br>" + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_link_on_data' ), this.dfe_property_name )
            }, _( 'element.error' ) ) );
            this.setError( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 1 );
            this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE );
        }
        else if ( this.has_warning_proctected_dfe ) {
            _to_return.appendChild( DOM.Service.createElement( "span", {
                class         : "tag tag-warning shinken-pointer-cursor",
                onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()",
                'shi-tip-type': SHINKEN_TOOLTIP.TYPE.WARNING_BORDER,
                onclick       : "MANAGER.EventManager.goToDataView('" + this.dfe_property + "')",
                'shi-tip-html': _( 'element.tooltip_dfe_check_generated_key_encrypted' ) + "<br>" + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_link_on_data' ), this.dfe_property_name )
            }, _( 'element.warning' ) ) );
            this.setWarning( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE, 1 );
            this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE );
        }
        else {
            _to_return.innerHTML = this.dfe_object.key;
            if ( this.status === OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE ) {
                this.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.NONE, true );
            } else {
                this.setStatus( this.status );
            }
        }
        return _to_return;
    },
    buildContactGroupHtml               : function () {
        var _text = this.element[ PROPERTY.CONST.NAME.CONTACT_GROUPS ];
        _text     = SHINKEN.TOOLS.STRING.startsWith( _text, PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ? _text.substr( 1 ) : _text;
        switch ( _text ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _text = '';
        }
        var _override_value = this.getOverrideValue( PROPERTY.CONST.NAME.CONTACT_GROUPS );
        switch ( _override_value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _override_value = '';
        }
        var _to_return = DOM.Service.createElement( "td", { class: "shinken-tab-check-col-contacts-groups" } );
        if ( !_text && !_override_value ) {
            _to_return.innerHTML = '<span class="shinken-between-bracket">' + _( 'element.same_as_host' ) + '</span>';
        }
        else {
            if ( _override_value ) {
                var _has_plus = SHINKEN.TOOLS.STRING.startsWith( _override_value, PROPERTY.CONST.STATE_VALUE_PLUS.ON );
                var _list_tag = this.buildContactGroupListTags( _to_return, _has_plus ? _override_value.substr( 1 ) : _override_value, 'override' );
                if ( _text && _has_plus ) {
                    this.buildContactGroupListTags( _to_return, _text, '', _list_tag );
                }
            }
            else {
                this.buildContactGroupListTags( _to_return, _text );
            }
            
        }
        return _to_return;
    },
    buildContactGroupListTags           : function ( to_return, values, state, list_tag ) {
        var _to_return     = list_tag || {};
        var contact_groups = values.split(',');
        var _current_contact_group;
        var _element;
        var _tag;
        for ( var i = 0, _size = contact_groups.length; i < _size; i++ ) {
            if ( _to_return[ contact_groups[ i ] ] ) {
                continue;
            }
            _to_return[ contact_groups[ i ] ] = true;
            _current_contact_group            = MANAGER.__instance_element_distributor.getElementByName( contact_groups[ i ] );
            _element                          = new OBJECT.ElementList();
            _tag                              = new COMPONENT.Tag();
            _element.setName( contact_groups[ i ] );
            _element.setType( "inheritance" );
            if ( _current_contact_group ) {
                _element.setUUID( _current_contact_group[ 'uuid' ] );
                _element.setState( state ? _current_contact_group.is_new ? state + '-new' : state : _current_contact_group[ OBJECT.CONST.ELEMENT.FIELD.STATUS ] );
                _element.setIsDisabled( !_current_contact_group.is_enabled );
                _tag.setElement( _element );
                _tag.buildHTML( "", _current_contact_group[ 'type' ] );
            }
            else {
                _element.setState( state ? state + '-' + COMPONENT.CONST.TAG.STATE.UNKNOWN : COMPONENT.CONST.TAG.STATE.UNKNOWN );
                _tag.setElement( _element );
                _tag.buildHTML();
            }
            _tag.setTooltip();
            DOM.Service.addElementTo( _tag.dom_element, to_return );
        }
        return _to_return;
    },
    buildCommandHtml                    : function () {
        var _command = this.element.check_command;
        if ( _command ) {
            var _override_value = this.getOverrideValue( PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS, this );
            if ( _override_value ) {
                _command = _command.split( '!' )[ 0 ] + '!' + _override_value;
            }
            var _splitted_data = MANAGER.__instance_macro_distributor.splitCommand( _command );
            if ( this.is_dfe ) {
                var _current;
                for ( var i = 0, _size = _splitted_data.length; i < _size; i++ ) {
                    _current = _splitted_data[ i ];
                    if ( _current.type === OBJECT.CONST.MACRO.TYPE.VALUE_DFE ) {
                        if ( this.dfe_object.args[ _current.index_dfe ] ) {
                            _current.setValue( this.dfe_object.args[ _current.index_dfe ] );
                            _current.setUnknown( false );
                        }
                        else {
                            _current.setUnknown( true );
                        }
                    }
                }
            }
            _command = MANAGER.__instance_macro_distributor.buildLabel( _splitted_data, false, this.key_dfe );
        }
        var _to_return = DOM.Service.createElement( "td", { class: "shinken-tab-check-col-command shinken-tab-check-col-command-data" }, _command );
        return _to_return;
    },
    buildTryCheckHtml                   : function () {
        var _template  = document.getElementById( "id-shinken-template-check-tab-cell-try_check" ).innerHTML;
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_DOM_UUID_$$$", this.getDomUUID() );
        var _to_return = DOM.Service.createElement( "tr", {}, _template );
        
        if ( this.is_bp_rule_command ) {
            var _div_container = _to_return.querySelector( '.shinken-buttons-try-check-container' );
            _div_container.setAttribute( 'shi-tip-html', _( 'element.no_run_bp_rule' ) );
        }
        if ( !MANAGER.__instance_element_distributor.current_element.isType( [OBJECT.CONST.ELEMENT.TYPE.HOSTS, OBJECT.CONST.ELEMENT.TYPE.CLUSTERS] ) ) {
            DOM.Service.removeElement( _to_return.querySelector( '.shinken-evaluate-check-on-sync' ) );
            DOM.Service.removeElement( _to_return.querySelector( '.shinken-evaluate-check-on-poller' ) );
        }
        else {
            if ( !MANAGER.__instance_element_distributor.current_user[ PROPERTY.CONST.NAME.ACL_TRY_CHECK_ON_SYNCHRONIZER ] ) {
                DOM.Service.removeElement( _to_return.querySelector( '.shinken-evaluate-check-on-sync' ) );
            }
            if ( !MANAGER.__instance_element_distributor.current_user[ PROPERTY.CONST.NAME.ACL_TRY_CHECK_ON_POLLER ] ) {
                DOM.Service.removeElement( _to_return.querySelector( '.shinken-evaluate-check-on-poller' ) );
            }
        }
        return _to_return.firstElementChild;
    },
    _computeOverrideStatus                   : function () {
        if ( MANAGER.__instance_element_distributor.current_element.hasOverride( this ) ) {
            return OBJECT.CONST.OVERRIDE_STATUS.ON;
        }
        if ( MANAGER.__instance_property_distributor.hasOverride( this ) ) {
            return OBJECT.CONST.OVERRIDE_STATUS.ON;
        }
        return OBJECT.CONST.OVERRIDE_STATUS.OFF;
    },
    updateOverrideStatus                       : function () {
        var _to_set = this._computeOverrideStatus();
        DOM.Service.setDataSet( this.dom_element, 'overrideStatus', _to_set );
    },
    cleanOverride                       : function () {
        this.force_clean = true;
        MANAGER.__instance_element_distributor.current_element.cleanOverrideFor( this );
        MANAGER.__instance_property_distributor.unSetAllOverrideFor( this );
        this.updateHtmlNameAfterChange();
        this.updateHtmlGroupAfterChange();
        this.updateHtmlCommandAfterChange();
        this.updateOverrideStatus();
        fire_element_is_modifie();
    },
    getOverrideValue                    : function ( prop_name ) {
        var _to_return = MANAGER.__instance_element_distributor.current_element.getOverrideValue( prop_name, this );
        if ( !_to_return ) {
            var _name_prop_override = PROPERTY.BuildOverrideNameFromCheck( prop_name, this );
            var _prop               = MANAGER.__instance_property_distributor.getElement( _name_prop_override );
            if ( _prop ) {
                _to_return = _prop.getValue();
                if ( prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS ) {
                    _to_return = _prop.component_input.getValue();
                }
            }
        }
        if ( !_to_return && this.parent_uuid !== MANAGER.__instance_element_distributor.current_element.uuid ) {
            var _tpl   = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( this.parent_uuid );
            _to_return = _tpl.getOverrideValue( prop_name, this );
        }
        return _to_return;
    },
    hide_eval_check                     : function () {
        this.dom_element_try_check_container.classList.add( 'shinken-hidden' );
        this.dom_element_try_check_close_btn.classList.add( 'shinken-hide-eval-hidden' );
    },
    askTryCheck                         : function ( is_exec, is_on_poller ) {
        switch ( this.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                return;
        }
        SHINKEN.TRY_CHECK.tryCheck( this, is_exec, is_on_poller );
    }
};
OBJECT.CheckInPageHost.FilterTags = ['order', 'is_dfe', 'dfe_property', 'name_check', 'uuid', 'has_error_dfe', 'name'];
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.CheckInPageHost, SHINKEN.OBJECT.CounterInterface );
OBJECT.ElementCheckbox           = function ( dom_element ) {
    this.init( dom_element );
};
OBJECT.ElementCheckbox.prototype = {
    init      : function ( dom_element ) {
        this.dom_element    = dom_element;
        this.is_checked     = dom_element.classList.contains( 'shinken-checked' );
    },
    setChecked: function ( to_set ) {
        if ( to_set === '0' ) {
            to_set = false;
        }
        this.is_checked = !!to_set;
        this.updateView();
    },
    isChecked : function () {
        return this.is_checked;
    },
    getValue  : function () {
        return this.is_checked ? '1' : '0';
    },
    updateView: function () {
        if ( this.is_checked ) {
            this.dom_element.classList.add( 'shinken-checked' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-checked' );
        }
    }
};
OBJECT.ElementList           = function () {
    this.init();
};
OBJECT.ElementList.prototype = {
    init                 : function () {
        this.is_disabled = false;
    },
    getName              : function () {
        return this.name;
    },
    getState             : function () {
        return this.state;
    },
    getType              : function () {
        return this.type;
    },
    getItemType          : function () {
        return this.item_type ? this.item_type : '';
    },
    getLabel             : function () {
        return this.label;
    },
    setName              : function ( to_set, dom_element ) {
        this.name = to_set;
        this.setLabel( to_set, dom_element );
    },
    setLabel             : function ( to_set ) {
        this.label = to_set;
    },
    setState             : function ( to_set ) {
        this.state = to_set;
    },
    setIsDisabled        : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_disabled = !!to_set;
    },
    setIsForceToNull     : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_force_to_null = !!to_set;
    },
    setIsHiddenForAdminSi: function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_hidden_for_admin_si = !!to_set;
    },
    setUUID              : function ( to_set ) {
        this.uuid = to_set;
        this.findShinkenElement();
    },
    findShinkenElement   : function () {
        if ( this.uuid && this.item_type ) {
            var _shinken_element = MANAGER.__instance_element_distributor.getElementByDict( this );
            if ( _shinken_element ) {
                this.setShinkenElement( _shinken_element );
            }
        }
    },
    setShinkenElement    : function ( to_set ) {
        this.shinken_element = to_set;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    setItemType          : function ( to_set ) {
        this.item_type = to_set;
        this.findShinkenElement();
    },
    clone                : function () {
        var _to_return = new OBJECT.ElementList();
        var _keys      = Object.keys( this );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key               = _keys[ i ];
            _to_return[ _current_key ] = this[ _current_key ];
        }
        return _to_return;
    },
    getClass             : function () {
        var _to_return = "";
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            _to_return += " shinken-element-new";
        }
        else if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            _to_return += " shinken-element-unknown";
        }
        else if ( this.is_disabled ) {
            _to_return += " shinken-element-disabled";
        }
        return _to_return;
    },
    getError             : function () {
        if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.IT_SELF ) {
            return 1;
        }
        if ( this.is_disabled ) {
            return 1;
        }
        return 0;
    },
    getTooltip           : function () {
        var _to_return = "";
        if ( this.is_disabled ) {
            _to_return = _( 'element.tooltip_disabled' );
        }
        switch ( this.state ) {
            case COMPONENT.CONST.TAG.STATE.NEW :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_NEW :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_new_disabled' );
                } else {
                    _to_return = _( 'element.tooltip_new' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.WORKING :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_working_disabled' );
                } else {
                    _to_return = _( 'element.tooltip_working' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.UNKNOWN :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_UNKNOWN :
                _to_return = _( 'element.tooltip_undefined' );
                break;
            case COMPONENT.CONST.TAG.STATE.IT_SELF :
                _to_return = _( 'element.tooltip_it_self' );
                break;
        }
        if ( this.is_force_to_null ) {
            if ( _to_return ) {
                _to_return += "<br>";
            }
            _to_return += SHINKEN.TOOLS.STRING.format( _( 'element.double_link_long_warning' ), this.getLabel() );
        }
        return _to_return;
    },
    getValueFinal        : function () {
        var _to_return = {};
        switch ( this.getState() ) {
            case OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN:
            case OBJECT.CONST.TEMPLATE.STATUS.NEW:
            case COMPONENT.CONST.TAG.STATE.UNKNOWN:
            case COMPONENT.CONST.TAG.STATE.NEW:
                _to_return.name   = this.name;
                _to_return.exists = false;
                break;
            default:
                _to_return.name      = this.name;
                _to_return.item_type = this.getItemType();
                _to_return._id       = this.uuid;
                _to_return.exists    = true;
                break;
        }
        return _to_return;
    }
};
OBJECT.HostInPageHost           = function ( shinken_element, tpl_element ) {
    this.element          = shinken_element;
    this.tpl_element      = tpl_element;
    this.is_current       = !!shinken_element;
    this.size_checks      = 0;
    this.size_checks_host = 0;
    this.uuid             = shinken_element ? shinken_element.uuid : tpl_element.uuid;
    this.initCounters( MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.CHECKS, false, MANAGER.__instance_element_distributor.current_element.uuid ) );
    this.getCounterTotal().show_if_null = true;
};
OBJECT.HostInPageHost.prototype = {
    getElement                          : function () {
        return this.is_current ? this.element : this.tpl_element;
    },
    getCheckByID                        : function ( check_uuid, dfe_name ) {
        var _current;
        var _to_test = check_uuid;
        if ( dfe_name ) {
            _to_test = check_uuid + '-' + dfe_name;
        }
        var _to_compare = "";
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            _current    = this.checks_host[ i ];
            _to_compare = _current.is_dfe ? _current.uuid + '-' + _current.key_dfe : _current.uuid;
            if ( _to_compare === _to_test ) {
                return _current;
            }
        }
        return null;
    },
    getCheckInHostElement               : function ( check_uuid, dfe_name ) {
        var _current;
        var _to_test = check_uuid;
        if ( dfe_name ) {
            _to_test = check_uuid + '-' + dfe_name;
        }
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            _current = this.checks_host[ i ];
            if ( _current.getDomUUID() === _to_test ) {
                return _current;
            }
        }
        return null;
    },
    getName                             : function () {
        return this.is_current ? this.element.getName() : this.tpl_element.name;
    },
    getLink                             : function () {
        return this.is_current ? this.element.getName() : this.tpl_element.getLink();
    },
    getTypeName                         : function () {
        var _to_return = this.is_current ? '' : 'tpl';
        switch ( MANAGER.__instance_element_distributor.current_element.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
                _to_return = 'type.cluster' + _to_return;
                break;
            default:
                _to_return = 'type.host' + _to_return;
                break;
        }
        return _( _to_return );
    },
    isOverrideLinkTo                    : function( override ) {
        var _current;
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            _current = this.checks_host[ i ];
            if ( override.is( _current ) ) {
                return true;
            }
        }
        return false;
    },
    setChecks                           : function ( to_set ) {
        var _to_add_final = {};
        this.checks       = to_set;
        this.size_checks  = this.checks.length;
        this.checks_host  = [];
        for ( var i = 0; i < this.size_checks; i++ ) {
            if ( to_set[ i ].is_dfe ) {
                var _dfe_object = App.DFE.getSplittedDataUnique( to_set[ i ].duplicate_foreach );
                for ( var j = 0; j < _dfe_object.length; j++ ) {
                    if ( to_set[ i ].isEnabled() ) {
                        this.checks_host.push( new OBJECT.CheckInPageHost( to_set[ i ], this, _dfe_object[ j ] ) );
                    }
                    else {
                        var _not_used = new OBJECT.CheckInPageHost( to_set[ i ], this, _dfe_object[ j ] );
                        MANAGER.__instance_element_distributor.current_element.setCheckInPageHostOnOverride( _not_used );
                    }
                }
            }
            else if ( to_set[ i ].isEnabled() ) {
                var _to_add                   = new OBJECT.CheckInPageHost( to_set[ i ], this );
                _to_add_final[ _to_add.name ] = _to_add;
            }
            else { //NEEDED TO SET THE CHECK_IN_PAGE_HOST IN OVERRIDE
                var _not_used = new OBJECT.CheckInPageHost( to_set[ i ], this );
                MANAGER.__instance_element_distributor.current_element.setCheckInPageHostOnOverride( _not_used );
            }
        }
        var _keys = Object.keys( _to_add_final );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.checks_host.push( _to_add_final[ _keys[ i ] ] );
        }
        this.checks_host      = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( this.checks_host, OBJECT.CheckInPageHost.FilterTags );
        this.size_checks_host = this.checks_host.length;
    },
    updateExcludeStatus                 : function () {
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].updateExcludeStatus();
        }
        this.updateTagHtml();
    },
    updateHtmlAfterOverrideCommandChange: function ( property ) {
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].updateHtmlAfterOverrideCommandChange( property );
        }
    },
    updateHtmlAfterDataChange           : function ( data ) {
        if ( data.isDfeData() ) {
            return this.updateHtmlAfterDfeDataChange( data );
        }
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].updateHtmlAfterDataChange();
        }
    },
    computeModulationTag                : function () {
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].updateHtmlNameAfterChange();
        }
    },
    updateHtmlAfterDfeDataChange        : function ( data ) {
        var _current;
        for ( var i = 0; i < this.size_checks; i++ ) {
            _current = this.checks[ i ];
            if ( !_current.isEnabled() ) {
                continue;
            }
            if ( !_current.is_dfe ) {
                continue;
            }
            if ( data.name !== _current.duplicate_foreach ) {
                continue;
            }
            var _dfe_object  = App.DFE.getSplittedDataUnique( _current.duplicate_foreach );
            var _current_dom = this.dom_element_table_check.querySelector( '[data-dfe-key="' + _dfe_object[ 0 ].property_name + '"]' );
            var _existing    = SHINKEN.TOOLS.ARRAY.filterWith( this.checks_host, 'uuid', _current.uuid );
            
            for ( var k = 0; k < _existing.length; k++ ) {
                _existing[ k ].setObsolete( true );
            }
            for ( var j = 0; j < _dfe_object.length; j++ ) {
                var _found = false;
                for ( var k = 0; k < _existing.length; k++ ) {
                    if ( _dfe_object[ j ].key === _existing[ k ].key_dfe ) {
                        _found = _existing[ k ];
                        _existing[ k ].setDfeObject( _dfe_object[ j ] );
                        _existing[ k ].setObsolete( false );
                    }
                }
                if ( !_found ) {
                    var _check_new = new OBJECT.CheckInPageHost( _current, this, _dfe_object[ j ] );
                    this.checks_host.push( _check_new );
                    this.size_checks_host = this.checks_host.length;
                    this.buildCheck( _check_new, false, _current_dom );
                    _check_new.linkDomElements();
                }
                else {
                    _found.updateHtmlAfterDataChange( _dfe_object[ j ] );
                }
            }
            for ( var k = 0; k < _existing.length; k++ ) {
                if ( _existing[ k ].is_obsolete ) {
                    _existing[ k ].deleteHtml( _current_dom, this );
                }
            }
        }
        this.size_checks_host = this.checks_host.length;
        
        for ( var i = this.size_checks_host - 1; i >= 0; i-- ) {
            if ( this.checks_host[ i ].is_obsolete ) {
                this.checks_host[ i ].destroy();
                this.checks_host.splice( i, 1 );
            }
        }
        this.size_checks_host = this.checks_host.length;
    },
    linkDomElements                     : function () {
        this.dom_element             = document.getElementById( 'id-host-in-page-host-' + this.uuid );
        this.dom_element_table_check = this.dom_element.querySelector( '.shinken-table-checks' );
        this.initCountersDom();
    },
    appendHtml                          : function () {
        if ( !this.size_checks_host ) {
            return;
        }
        var _to_return      = DOM.Service.createElement( "div", { class: "shinken-container-host-in-page-host", id: 'id-host-in-page-host-' + this.uuid } );
        var _to_add_error   = DOM.Service.createElement( "span", {
            class: "shinken-error-counter shinken-counter shinken-counter-label shinken-hidden", title: _( 'element.title_panel_errors' ), 'data-number': ''
        }, '<span class="shinken-counter-label"></span>' );
        var _to_add_warning = DOM.Service.createElement( "span", {
            class: "shinken-warning-counter shinken-counter shinken-counter-label shinken-hidden", title: _( 'element.title_panel_warnings' ), 'data-number': ''
        }, '<span class="shinken-counter-label"></span>' );
        _to_return.appendChild( _to_add_error );
        _to_return.appendChild( _to_add_warning );
        _to_return.appendChild( this.buildHeader() );
        _to_return.appendChild( this.buildContent() );
        _to_return.appendChild( this.buildFooter() );
        var _container = document.getElementById( "id-shinken-check-list" );
        if ( this.is_first_template ) {
            _container.appendChild( this.buildSeparator( _( 'element.from_templates' ) ) );
        }
        _container.appendChild( _to_return );
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].linkDomElements();
        }
        this.linkDomElements( _container );
    },
    buildSeparator                      : function ( _text ) {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-separator-container" } );
        var _to_add    = DOM.Service.createElement( "div", { class: "shinken-separator-title" }, _text );
        var _hr        = DOM.Service.createElement( "hr", { class: 'shinken-hr-sample' } );
        _to_return.appendChild( _to_add );
        _to_return.appendChild( _hr );
        return _to_return;
    },
    buildHeader                         : function () {
        var _to_return = DOM.Service.createElement( "div", { class: "header" } );
        var _text      = this.is_current ? _( 'element.directly_attached' ) : _( 'element.attached_on' );
        _text += "<span class='shinken-template shinken-space'>" + this.getLink() + "</span>";
        _text += "<span class='shinken-between-space-bracket shinken-nb-checks'><span class='shinken-pulsate-parent shinken-window-total-counter shinken-counter' data-number=''><span class='shinken-counter-label'></span></span>" + _( "element.checks" ) + "</span>";
        var _to_add    = DOM.Service.createElement( "h3", { class: "shinken-host-in-page-host-title" }, _text );
        _to_return.appendChild( _to_add );
        return _to_return;
    },
    buildContent                        : function () {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-container-table-checks" } );
        var _table     = DOM.Service.createElement( "table", { class: "shinken-table-checks" } );
        var _thead     = DOM.Service.createElement( "thead" );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-name" }, _( 'element.name' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-tags" }, _( 'element.override' ) + " / " + _( 'element.exclude' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-dfe" }, _( 'element.duplicate_foreach' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-contacts-groups" }, _( 'element.tab_check_contact_group_header' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-command" }, _( 'serviceshosts.check_command' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-try-check" }, _( 'element.try_check' ) ) );
        _table.appendChild( _thead );
        this.buildChecks( _table );
        _to_return.appendChild( _table );
        return _to_return;
    },
    buildChecks                         : function ( container ) {
        var _current_dfe = '';
        var _is_even     = false;
        var _tbody;
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            if ( !this.checks_host[ i ].element.duplicate_foreach ) {
                this.buildCheck( this.checks_host[ i ], _is_even, container );
            }
            else {
                if ( _current_dfe !== this.checks_host[ i ].element.duplicate_foreach ) {
                    _current_dfe = this.checks_host[ i ].element.duplicate_foreach;
                    if ( _tbody ) {
                        container.appendChild( _tbody );
                    }
                    _tbody   = DOM.Service.createElement( "tbody", { 'data-dfe-key': _current_dfe, class: 'shinken-dfe-check-container' } );
                    _is_even = false;
                    this.checks_host[ i ].buildDFESeparatorHtml( _tbody, _is_even );
                }
                this.buildCheck( this.checks_host[ i ], _is_even, _tbody );
            }
            _is_even = !_is_even;
        }
        if ( _tbody ) {
            container.appendChild( _tbody );
        }
    },
    buildCheck                          : function ( check_in_page_host, _is_even, container ) {
        check_in_page_host.appendHtml( container, _is_even );
        check_in_page_host.appendOverrideHtml( container, _is_even );
        check_in_page_host.appendTryCheckHtml( container, _is_even );
    },
    buildFooter                         : function () {
        return DOM.Service.createElement( "div", { class: "footer" } );
    },
    updateTagHtml                       : function () {
        if ( !this.tpl_element ) {
            return;
        }
        var _use   = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE );
        var _tag   = _use.getSelector().list_element_selected.getTagByName( this.tpl_element.name );
        var _icons = "";
        if ( __list_image_for_tpl[ _tag.getName() ] ) {
            _icons = DOM.Service.createElement( 'img', { class: 'shinken-use-icon-img', onerror: '$(this).hide()', src: "/static/" + http_start_time + "/images/sets/" + _tag.getName() + "/tag.png" } ).outerHTML;
        }
        var _label_html = DOM.Service.createElement( 'span', { class: 'shinken-tag-label' }, _icons + _tag.getName() );
        if ( this.getCounterTotal().counter_final ) {
            var _checks_template_size = DOM.Service.createElement( 'span', { class: 'shinken-checks-tag-label' }, SHINKEN.TOOLS.STRING.format( _( 'element.use_check' + (this.getCounterTotal().counter_final > 1 ? 's' : '') ), this.getCounterTotal().counter_final ) );
            DOM.Service.addElementTo( _checks_template_size, _label_html );
        }
        _tag.setLabel( _label_html.outerHTML );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.HostInPageHost, SHINKEN.OBJECT.CounterInterface );
OBJECT.ListTemplate           = function ( data ) {
    this.init( data );
};
OBJECT.ListTemplate.prototype = {
    init               : function ( data ) {
        this.list_template         = [];
        this.list_template_mapping = {};
        this.list_use_by_name      = {};
        if ( !data ) {
            this.size = 0;
            return;
        }
        this.initData( data );
        this.computeListUseFinal();
        this.buildTemplateStatus();
        this.buildComputedList();
    },
    initData           : function ( data ) {
        this.size = data.length;
        var object;
        for ( var i = 0; i < this.size; i++ ) {
            object                                         = new OBJECT.Template( data[ i ] );
            this.list_template[ i ]                        = object;
            this.list_template_mapping[ object.getUuid() ] = i;
        }
    },
    computeListUseFinal: function () {
        var _current;
        for ( var i = this.size - 1; i >= 0; i-- ) {
            _current = this.list_template[ i ];
            this._computeUse( _current );
        }
    },
    buildTemplateStatus: function () {
        var _current;
        var _current_tested;
        
        for ( var i = 1; i < this.size; i++ ) {
            _current = this.list_template[ i ];
            for ( var j = 0; j < i; j++ ) {
                _current_tested = this.list_template[ j ];
                
                if ( this.list_use_by_name[ _current_tested.getName() ][ _current.getName() ] ) {
                    _current.setStatus( OBJECT.CONST.TEMPLATE.STATUS.USELESS, _current_tested.getName() );
                    break;
                }
            }
        }
    },
    buildComputedList  : function () {
        this.list_template_computed = [];
        var _current;
        for ( var i = 0; i < this.size; i++ ) {
            _current = this.list_template[ i ];
            if ( _current.isStatus( OBJECT.CONST.TEMPLATE.STATUS.USEFUL ) ) {
                this.list_template_computed.push( _current );
            }
        }
        this.size_computed = this.list_template_computed.length;
    },
    getTemplateByTag   : function ( tag ) {
        var _to_return;
        _to_return = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( tag.element.uuid );
        
        if ( !_to_return ) {
            _to_return = MANAGER.__instance_element_distributor.list_templates.getTemplateByName( tag.element.name );
        }
        return _to_return;
    },
    getTemplateByUuid  : function ( uuid ) {
        var _index = this.list_template_mapping[ uuid ];
        if ( _index === undefined ) {
            return null;
        }
        return this.getTemplateByIndex( _index );
    },
    getTemplateByName  : function ( name ) {
        if ( !name ) {
            return null;
        }
        return SHINKEN.TOOLS.ARRAY.findFirstElementWith( this.list_template, OBJECT.CONST.TEMPLATE.FIELD.NAME, name );
    },
    getTemplateByIndex : function ( index ) {
        return this.list_template[ index ];
    },
    isEmpty            : function () {
        return !this.size;
    },
    _computeUse        : function ( template ) {
        var _level_template_already_used;
        var _current_name_template_use;
        var _keys_already_used;
        var _size_already_used;
        var _current_template;
        
        var _name = template.getName();
        if ( !this.list_use_by_name[ _name ] ) {
            this.list_use_by_name[ _name ] = {};
        }
        if ( !template.isEnabled() ) {
            return;
        }
        var _current_use      = template[ OBJECT.CONST.TEMPLATE.FIELD.USE ];
        var _size_current_use = _current_use.length;
        
        for ( var i = 0; i < _size_current_use; i++ ) {
            _current_name_template_use = _current_use[ i ];
            if ( this.list_use_by_name[ _name ][ _current_name_template_use ] ) {
                this.list_use_by_name[ _name ][ _current_name_template_use ] = 1;
                continue;
            }
            this.list_use_by_name[ _name ][ _current_name_template_use ] = 1;
            
            if ( !this.list_use_by_name[ _current_name_template_use ] ) {
                continue;
            }
            
            _keys_already_used = Object.keys( this.list_use_by_name[ _current_name_template_use ] );
            _size_already_used = _keys_already_used.length;
            
            for ( var j = 0; j < _size_already_used; j++ ) {
                _level_template_already_used = this.list_use_by_name[ _current_name_template_use ][ _keys_already_used[ j ] ];
                if ( this.list_use_by_name[ _name ][ _keys_already_used[ j ] ] ) {
                    continue;
                }
                this.list_use_by_name[ _name ][ _keys_already_used[ j ] ] = _level_template_already_used + 1;
            }
            _current_template = this.getTemplateByName( _current_name_template_use );
            template.completeTemplateWithUse( _current_template );
        }
    },
    getIndexForCompute      : function ( template ) {
        for ( var i = 0; i < this.size_computed; i++ ) {
            if ( template.uuid === this.list_template_computed[i].uuid ){
                return i;
            }
        }
        return -1;
    },
    getProperties: function ( name ) {
        var _to_return    = [];
        var _stop_compute = false;
        var _current;
        var _current_property;
        
        for ( var i = 0; i < this.size_computed; i++ ) {
            _current = this.list_template_computed[ i ];
            
            _current_property = _current.properties[ name ];
            
            if ( !_current_property ) {
                continue;
            }
            
            if ( !_current_property.isEmpty() ) {
                _to_return.push( _current_property );
            }
            
            if ( _stop_compute ) {
                _current_property.setIsStopped( true );
                continue;
            }
            if ( !_current_property.hasPlus() ) {
                _stop_compute = true;
            }
        }
        
        
        var _size = _to_return.length;
        if ( _size ) {
            _to_return[ _size - 1 ].setIsLast( true );
        }
        else {
            _to_return = null;
        }
        return _to_return;
    },
    finalyzeView : function () {
        var _current;
        var _current_state;
        var _current_template;
        var _use = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE );
        if ( !_use ) {
            return;
        }
        for ( var i = 0; i < _use.getSelector().list_element_selected.size_tags; i++ ) {
            _current          = _use.getSelector().list_element_selected.getTagByIndex( i );
            _current_state    = _current.getState();
            _current_template = this.getTemplateByTag( _current );
            if ( _current_state === COMPONENT.CONST.TAG.STATE.HIDDEN ) {
                continue;
            }
            if ( _current_state === COMPONENT.CONST.TAG.STATE.NEW && _current_template.status === OBJECT.CONST.TEMPLATE.STATUS.USEFUL ) {
                _current.setState( OBJECT.CONST.TEMPLATE.STATUS.NEW );
            }
            else {
                if ( !_current.element.item_type ) {
                    _current.element.setItemType( _current_template.item_type );
                }
                _current.setState( _current_template.status );
                _current.setTooltip( _current_template.status_tooltip );
            }
        }
        _use.checkErrorWarning();
    }
};
OBJECT.Macro           = function ( name, value, type ) {
    name                   = name.toUpperCase();
    this.name              = name;
    this.key               = name.substr( 1, name.length - 2 );
    this.property          = null;
    this.value             = value;
    this.final_value       = value;
    this.type              = type;
    this.macro_used        = {};
    this.is_loop           = false;
    this.is_protected      = false;
    this.is_unknown        = false;
    this.is_herited        = false;
    this.is_double_dollar  = !this.key;
    this.is_force_to_empty = false;
};
OBJECT.Macro.prototype = {
    init                 : function ( forced ) {
        if ( this.value && !forced ) {
            return;
        }
        if ( forced ) {
            if ( !this.is_loop ) {
                var _keys = Object.keys( this.macro_used );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    _current_key = _keys[ i ];
                    this.macro_used[ _current_key ].init( forced );
                }
            }
            this.macro_used = {};
            this.is_loop    = false;
        }
        if ( SHINKEN.TOOLS.STRING.startsWith( this.key, OBJECT.CONST.MACRO.TYPE.HOST_LOCAL ) ) {
            this.type       = OBJECT.CONST.MACRO.TYPE.HOST_LOCAL;
            var _key        = "_" + this.key.substr( OBJECT.CONST.MACRO.TYPE.HOST_LOCAL.length );
            var _local_data = MANAGER.__instance_property_distributor.getDataWithName( _key );
            if ( !_local_data ) {
                this.setUnknown( true );
                return;
            }
            this.setUnknown( false );
            if ( _local_data.isProtected() ) {
                this.is_protected = true;
                return;
            }
            var _value = '';
            switch ( _local_data.state ) {
                case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                    _value = _local_data.getValue();
                    break;
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    this.is_herited = true;
                    _value          = _local_data.getValueInherited();
                    break;
            }
            this.setValue( _value );
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( this.key, OBJECT.CONST.MACRO.TYPE.SERVICE_LOCAL ) ) {
            this.type = OBJECT.CONST.MACRO.TYPE.SERVICE_LOCAL;
            return;
        }
        else if ( this.key === 'VALUE' ) {
            this.type      = OBJECT.CONST.MACRO.TYPE.VALUE_DFE;
            this.index_dfe = 0;
            return;
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( this.key, 'VALUE' ) ) {
            var _index = parseInt( this.key.replace( 'VALUE', '' ) );
            if ( isNaN( _index ) ) {
                this.type = this.getTypeMacrosNotLocal( this.key );
            }
            else {
                this.type      = OBJECT.CONST.MACRO.TYPE.VALUE_DFE;
                this.index_dfe = _index - 1;
            }
            return;
        }
        else if ( this.name === OBJECT.CONST.MACRO.TYPE.DFE_KEY ) {
            this.type = OBJECT.CONST.MACRO.TYPE.DFE_KEY;
            return;
        }
        else {
            this.type = this.getTypeMacrosNotLocal( this.key );
            return;
        }
    },
    hasUsedInLoop        : function ( to_set ) {
        var _keys = Object.keys( this.macro_used );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.macro_used[ _keys[ i ] ].is_loop ) {
                return true;
            }
        }
        return false;
    },
    setUnknown           : function ( to_set ) {
        this.is_unknown = to_set;
    },
    setValue             : function ( to_set, property ) {
        this.setUnknown( !to_set );
        if ( property ) {
            this.is_herited = property.state_inheritance;
        }
        switch ( this.type ) {
            case OBJECT.CONST.MACRO.TYPE.VALUE_DFE:
            case OBJECT.CONST.MACRO.TYPE.HOST_LOCAL:
                this.final_value = "";
                this.value       = to_set;
                if ( to_set === undefined ) {
                    return;
                }
                var _splitted = MANAGER.__instance_macro_distributor.splitCommand( to_set );
                var _current;
                
                for ( var i = 0, _size = _splitted.length; i < _size; i++ ) {
                    _current = _splitted[ i ];
                    if ( typeof _current === 'string' ) {
                        this.final_value += SHINKEN.TOOLS.STRING.cleanXss( _current );
                    }
                    else {
                        this.macro_used[ _current.name ] = _current;
                        if ( _current.macro_used[ this.name ] ) {
                            this.macro_used[ _current.name ] = _current;
                            this.is_loop                     = true;
                            _current.is_loop                 = true;
                            return;
                        }
                        else {
                            for ( var macro in _current.macro_used ) {
                                this.macro_used[ macro ] = _current.macro_used[ macro ];
                            }
                        }
                        this.final_value += _current.getValue();
                    }
                }
                break;
            case OBJECT.CONST.MACRO.TYPE.HOST_PROPERTY:
                this.value       = to_set;
                this.final_value = to_set;
                break;
            default:
                this.value = to_set;
        }
    },
    getValue             : function () {
        var _to_return = this.final_value;
        if ( this.is_force_to_empty ) {
            return "";
        }
        if ( this.is_double_dollar ) {
            return "$";
        }
        if ( this.is_unknown || this.type === OBJECT.CONST.MACRO.TYPE.UNKNOWN || (this.type === OBJECT.CONST.MACRO.TYPE.VALUE_DFE && !this.final_value) ) {
            _to_return = DOM.Service.createElement( "span",
                {
                    class         : "shinken-macro-warning value",
                    onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                    'shi-tip-html': SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_not_found' ), this.name ),
                    onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()"
                }, this.name );
            return _to_return.outerHTML;
        }
        switch ( this.type ) {
            case OBJECT.CONST.MACRO.TYPE.DFE_KEY:
                return OBJECT.CONST.MACRO.TYPE.DFE_KEY;
            case OBJECT.CONST.MACRO.TYPE.SERVICE_LOCAL:
            case OBJECT.CONST.MACRO.TYPE.HOST_PROPERTY:
            case OBJECT.CONST.MACRO.TYPE.GLOBAL:
            case OBJECT.CONST.MACRO.TYPE.GLOBAL_INTERPRETED:
            case OBJECT.CONST.MACRO.TYPE.SERVICE_PROPERTY:
                _to_return = DOM.Service.createElement( "span",
                    {
                        class         : "shinken-macro-warning value",
                        onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                        'shi-tip-html': SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_not_evaluated' ), this.name ),
                        onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()"
                    }, this.name );
                return _to_return.outerHTML;
        }
        if ( this.is_loop || this.is_protected ) {
            _to_return = DOM.Service.createElement( "span",
                {
                    class       : "shinken-macro-error value",
                    onmouseenter: "SHINKEN_TOOLTIP.showTooltip(this)",
                    onmouseleave: "SHINKEN_TOOLTIP.hideTooltip()"
                }, this.name );
            if ( this.is_loop ) {
                _to_return.setAttribute( "shi-tip-html", SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_infinity_loop' ), this.name ) );
            }
            else if ( this.is_protected ) {
                _to_return.setAttribute( "shi-tip-html", _( 'element.password_protected' ) );
                _to_return.classList.add( "shinken-macro-protected" );
            }
            return _to_return.outerHTML;
        }
        if ( this.is_herited ) {
            _to_return = "<span class='shinken-macro-inherited'>" + _to_return + "</span>";
        }
        return _to_return;
    },
    getTypeMacrosNotLocal: function ( key ) {
        var _list_names_properties;
        var _current_type_name;
        var _key_types_macros = Object.keys( OBJECT.CONST.MACRO.TYPE );
        for ( var i = 0, _size_types = _key_types_macros.length; i < _size_types; i++ ) {
            _current_type_name     = OBJECT.CONST.MACRO.TYPE[ _key_types_macros[ i ] ];
            _list_names_properties = all_macros_name_not_resolved[ _current_type_name ];
            if ( !_list_names_properties ) {
                continue;
            }
            
            for ( var j = 0, _size_macro_name = _list_names_properties.length; j < _size_macro_name; j++ ) {
                if ( key === _list_names_properties[ j ] ) {
                    return _current_type_name;
                }
                
            }
        }
        return OBJECT.CONST.MACRO.TYPE.UNKNOWN;
    }
};
OBJECT.Messages = function ( footer ) {
    this.messages_error   = [];
    this.messages_warning = [];
    this.messages_beware  = [];
    this.messages_info    = [];
    this.is_dfe           = false;
    this.is_dfe_protected = false;
    this.footer           = footer;
    this.no_duplicate     = false;
};
OBJECT.MESSAGE            = {
    ICON       : {
        ERROR  : '<span class="shinken-icon-error shinkon-warning"></span>',
        WARNING: '<span class="shinken-icon-warning shinkon-warning"></span>',
        BEWARE : '<span class="shinken-icon-warning shinkon-warning-light"></span>'
    },
    MAX_ERROR  : 5,
    MAX_WARNING: 5
};
OBJECT.Messages.prototype = {
    addMessage         : function ( type_message, text ) {
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.messages_error.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.messages_warning.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.messages_beware.push( new OBJECT.Message( type_message, text ) );
                break;
            default:
                this.messages_info.push( new OBJECT.Message( type_message, text ) );
                break;
        }
    },
    addMessages        : function ( messages ) {
        if ( !messages ) {
            return;
        }
        var _size = messages.length;
        var _current_message;
        for ( var i = 0; i < _size; i++ ) {
            _current_message = messages[ i ];
            this.addMessage( _current_message._type, _current_message._text );
        }
    },
    hasMessage         : function () {
        return this.hasError() || this.hasWarning() || this.hasBeware() || this.hasInfo();
    },
    hasError           : function () {
        return this.messages_error.length > 0;
    },
    hasWarning         : function () {
        return this.messages_warning.length > 0;
    },
    hasBeware          : function () {
        return this.messages_beware.length > 0;
    },
    hasInfo            : function () {
        return this.messages_info.length > 0;
    },
    getStatus          : function () {
        if ( this.hasError() ) {
            return COMPONENT.CONST.STATUS.ERROR;
        }
        if ( this.hasWarning() ) {
            return COMPONENT.CONST.STATUS.WARNING;
        }
        if ( this.hasBeware() ) {
            return COMPONENT.CONST.STATUS.BEWARE;
        }
        return COMPONENT.CONST.STATUS.NONE;
    },
    buildMessage       : function ( is_default, template_name ) {
        
        var _status = this.getStatus();
        if ( _status === COMPONENT.CONST.STATUS.NONE ) {
            return '';
        }
        var _to_return          = '<div class="shinken-tooltip-message text-left">';
        var _show_extra_message = false;
        if ( this.hasError() ) {
            _show_extra_message = true;
            _to_return += '<span class="text-underline">' + _( 'element.tooltip_message_invalid_syntax' ) + '</span><br>';
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'element.tooltip_message_tag_error' ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_error, OBJECT.MESSAGE.MAX_ERROR );
            _to_return += '</ol>';
        }
        if ( this.hasWarning() ) {
            _show_extra_message = true;
            _to_return += OBJECT.MESSAGE.ICON.WARNING + _( 'element.tooltip_message_tag_warning' ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_warning, OBJECT.MESSAGE.MAX_WARNING );
            _to_return += '</ol>';
        }
        if ( !this.is_dfe_protected && _show_extra_message && this.is_dfe ) {
            var _format_to_follow        = is_default ? _( 'element.tooltip_dfe_common_default_value' ) : _( 'element.tooltip_dfe_common' );
            var _note_to_update_template = template_name ? '<div class=\'container-legend \'>' + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_common_go_tpl' ), template_name ) + '</div>' : "";
            _to_return                   = _to_return +
                                           '<div class=\'container-legend\'>' + _format_to_follow + '</div>' +
                                           _note_to_update_template;
            
        }
        if ( this.hasBeware() && this.is_dfe ) {
            if ( !this.is_dfe_protected && _show_extra_message ) {
                _to_return += '<hr>';
            }
            _to_return += '<ol>' + OBJECT.MESSAGE.ICON.BEWARE + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_deleted_part_1' ), this.property_name );
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
            _to_return += '</ol>';
        }
        else if ( this.hasBeware() ) {
            _to_return += OBJECT.MESSAGE.ICON.BEWARE + _( 'element.tooltip_message_tag_warning' ) + '<br>';
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
        }
        if ( this.footer ) {
            _to_return += this.footer;
        }
        
        _to_return += '</div>';
        return _to_return;
    },
    buildMessageForList: function ( list, max ) {
        var _to_return = '';
        var _size      = Math.min( list.length, max );
        var _to_add;
        var _duplicate = {};
        for ( var i = 0; i < _size; i++ ) {
            _to_add = list[ i ].buildHtml();
            if ( this.no_duplicate ) {
                var _md5 = SHINKEN.TOOLS.MD5.MD5( _to_add );
                if ( _duplicate[ _md5 ] ) {
                    continue;
                }
                _duplicate[ _md5 ] = true;
            }
            _to_return += _to_add;
        }
        return _to_return;
    }
};
OBJECT.Message = function ( type, text ) {
    this._type = type;
    this._text = text;
};
OBJECT.Message.prototype = {
    buildHtml: function () {
        return '<li class=\'' + this._type + '\'>' + this._text + '</li>';
    }
};
OBJECT.CONST.PHASE = {
    RUNNING                 : 0,
    REFRESHING              : 1,
    INIT                    : 2,
    EDITING                 : 3,
    SAVING                  : 4,
    WAITING_FOR_START_IMPORT: 5,
    WAITING_FOR_IMPORT      : 6,
    WAITING_FOR_MERGE       : 7,
    WAITING_FOR_UPDATE      : 8,
    READY                   : 9,
    WAITING_FOR_READY       : 10,
    SLEEPING                : 11
};
OBJECT.Phase           = function () {
    this.previous_phase = null;
    this.current_phase  = OBJECT.CONST.PHASE.INIT;
    this.next_phase     = null;
};
OBJECT.Phase.prototype = {
    setPhase           : function ( to_set ) {
        this.previous_phase = this.current_phase;
        this.current_phase  = to_set;
        this.next_phase     = null;
    },
    setPhaseWithTimeOut: function ( to_set, timeout ) {
        if ( !timeout ) {
            timeout = 0;
        }
        var self = this;
        setTimeout( function () {
            self.previous_phase = this.current_phase;
            self.current_phase  = to_set;
        }, timeout );
    },
    isPhase            : function ( to_test ) {
        return this.current_phase === to_test;
    }
};
OBJECT.ServiceExcludes           = function ( datas ) {
    this.datas    = datas;
    this.excludes = [];
    this.size     = 0;
    this.init();
};
OBJECT.ServiceExcludes.prototype = {
    init               : function () {
        if ( this.datas ) {
            this.raw_value = this.datas.raw_value;
            this.initExcludeElement();
        }
    },
    initExcludeElement : function () {
        var _size = this.datas.links.length;
        for ( var i = 0; i < _size; i++ ) {
            this.addExclude( null, this.datas.links[ i ] );
        }
    },
    changeExcludeStatus: function ( check_in_page_host ) {
        var _existing = false;
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.excludes[ i ].is( check_in_page_host ) ) {
                _existing = i;
                break;
            }
        }
        if ( _existing !== false ) {
            this.excludes.splice( _existing, 1 );
            this.size = this.excludes.length;
            return OBJECT.CONST.EXCLUDE_STATUS.OFF;
        }
        else {
            this.addExclude( check_in_page_host );
            return OBJECT.CONST.EXCLUDE_STATUS.BY_ID;
        }
    },
    addExclude         : function ( check_in_page_host, data ) {
        var _to_return = new OBJECT.ServiceExclude( check_in_page_host, data );
        this.excludes.push( _to_return );
        this.size = this.excludes.length;
        return _to_return;
    },
    getExcludeStatus   : function ( check_in_page_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.excludes[ i ].is( check_in_page_host ) ) {
                return OBJECT.CONST.EXCLUDE_STATUS.BY_ID;
            }
        }
        return OBJECT.CONST.EXCLUDE_STATUS.OFF;
    },
    getDataToSave      : function () {
        var _to_return = {};
        
        _to_return.has_plus  = false;
        _to_return.raw_value = '';
        _to_return.links     = [];
        
        for ( var i = 0; i < this.size; i++ ) {
            _to_return.links.push( this.excludes[ i ].getDataToSave() );
        }
        return _to_return;
    }
};
OBJECT.ServiceExclude           = function ( check_in_page_host, data ) {
    this.check_in_page_host = check_in_page_host;
    this.data               = data;
    if ( data ) {
        this.check_uuid = data._id;
    }
    this.init();
};
OBJECT.ServiceExclude.prototype = {
    init         : function ( check_in_page_host ) {
    },
    getDataToSave: function () {
        if ( !this.check_in_page_host ) {
            console.warn( "An exclude will be lost ==> ", this.data );
            return this.data;
        }
        var _to_return       = {};
        _to_return.name      = this.check_in_page_host.name;
        _to_return.exists    = true;
        _to_return._id       = this.check_in_page_host.uuid;
        _to_return.item_type = this.check_in_page_host.element.getType();
        if ( this.check_in_page_host.is_dfe ) {
            _to_return.dfe_key = this.check_in_page_host.key_dfe;
        }
        return _to_return;
    },
    is           : function ( check_in_host ) {
        var _to_return = false;
        if ( this.check_in_page_host ) {
            return check_in_host.getDomUUID() === this.check_in_page_host.getDomUUID();
        }
        if ( check_in_host.is_dfe && this.check_name === check_in_host.name ) {
            _to_return = true;
        }
        else if ( this.check_uuid === check_in_host.uuid ) {
            if ( check_in_host.is_dfe ) {
                _to_return = this.dfe_key === check_in_host.key_dfe;
            }
            else {
                _to_return = true;
            }
        }
        else if ( this.check_name && this.check_name === check_in_host.name ) {
            _to_return = true;
        }
        if ( _to_return ) {
            this.check_in_page_host = check_in_host;
        }
        return _to_return;
    }
};
OBJECT.ServiceOverrideUnvalids           = function ( name ) {
    this.__class   = "ServiceOverrideUnvalids";
    this.name      = name;
    this.overrides = [];
};
OBJECT.ServiceOverrideUnvalids.prototype = {
    addUnvalidOverride  : function ( override ) {
        this.overrides.push( override );
    },
    setType             : function ( to_set ) {
        this.type = to_set;
    },
    setCheck            : function ( to_set ) {
        this.check = to_set;
    },
    setHost             : function ( to_set ) {
        this.host = to_set;
    },
    setDfeKey           : function ( to_set ) {
        this.key_dfe = to_set;
    },
    getHostName         : function () {
        if ( this.host ) {
            return this.host.getName();
        }
        return "";
    },
    getCheckName        : function () {
        if ( this.check ) {
            return this.check.getName();
        }
        return "";
    },
    buildHtml           : function () {
        var _to_return = DOM.Service.createElement( 'div', { class: 'shinken-container-host-in-page-host shinken-container-unvalid-override' } );
        var div_footer = DOM.Service.createElement( 'div', { class: 'footer' } );
        
        DOM.Service.addElementTo( this.buildHtmlHeader(), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'div', { class: 'shinken-container-table-checks' }, this.buildHtmlContent().outerHTML ), _to_return );
        DOM.Service.addElementTo( div_footer, _to_return );
        this.dom_element = _to_return;
        return _to_return;
    },
    buildHtmlContent    : function () {
        var _to_return = DOM.Service.createElement( 'div', { class: 'container-table' } );
        var table_html = DOM.Service.createElement( 'table', { class: 'shinken-table-checks' } );
        
        DOM.Service.addElementTo( this.buildHtmlTableHeader(), table_html );
        DOM.Service.addElementTo( this.buildHtmlTableBody(), table_html );
        DOM.Service.addElementTo( table_html, _to_return );
        return _to_return;
    },
    buildHtmlTableBody  : function () {
        var _to_return = DOM.Service.createElement( 'tbody' );
        for ( var i = 0, _size_i = this.overrides.length; i < _size_i; i++ ) {
            DOM.Service.addElementTo( this.overrides[ i ].buildHtml(), _to_return );
        }
        return _to_return.hasChildNodes() ? _to_return : null;
    },
    buildHtmlHeader     : function () {
        var _to_return = DOM.Service.createElement( 'div', { class: 'header' } );
        var _table     = DOM.Service.createElement( 'table', {} );
        var _tr        = DOM.Service.createElement( 'tr', {} );
        var _td_delete = DOM.Service.createElement( 'td', {
            class: "shinken-delete-btn-cell", onclick: "MANAGER.EventManager.clickOnDeleteInvalidOverride('" + this.type + "','" + this.name + "')"
        }, "<span class='shinken-btn shinkon shinkon-broom'></span>" );
        var _td_title  = DOM.Service.createElement( 'td', { class: "shinken-title-cell" } );
        var _text      = "";
        switch ( this.type ) {
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_CHECK_INACTIVE:
                _text = SHINKEN.TOOLS.STRING.format( this.host.isTemplate() ? _( 'element.unvalids_override_inactive_check_title_tpl' ) : _( 'element.unvalids_override_inactive_check_title_host' ), SHINKEN.TOOLS.buildLinkShinkenElement( this.check ).outerHTML, SHINKEN.TOOLS.buildLinkShinkenElement( this.host ).outerHTML );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_INACTIVE:
                _text = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_inactive_template_title' ), this.overrides[ 0 ].override.check_name, SHINKEN.TOOLS.buildLinkShinkenElement( this.host ).outerHTML );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_NOT_USED:
                _text = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_not_used_template_title' ), this.overrides[ 0 ].override.check_name, this.getHostName() );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT:
                _text      = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_unknown_check_dfe_title' ), SHINKEN.TOOLS.buildLinkShinkenElement( this.check ).outerHTML, this.key_dfe );
                _td_delete = DOM.Service.createElement( 'td', {
                    class: "shinken-delete-btn-cell", onclick: "MANAGER.EventManager.clickOnDeleteInvalidOverride('" + this.type + "','" + this.name + '-' + this.key_dfe + "')"
                }, "<span class='shinken-btn shinkon shinkon-broom'></span>" );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK:
                _text = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_unknown_check_title' ), this.name );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK_FINAL:
                _text = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_unknown_check_final_title' ), this.name );
                break;
        }
        var _text = DOM.Service.createElement( 'span', { class: 'shinken-title' }, _text );
        DOM.Service.addElementTo( DOM.Service.createElement( 'div', { class: 'shinken-title-unvalid-override' }, _text.outerHTML ), _td_title );
        DOM.Service.addElementTo( _td_delete, _tr );
        DOM.Service.addElementTo( _td_title, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _to_return );
        return _to_return;
    },
    buildHtmlTableHeader: function () {
        var _to_return = DOM.Service.createElement( 'thead', { class: 'bold' } );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: "shinken-unvalid-override-col shinken-col-property shinken-space" }, _( 'element.column_property_data' ) ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: "shinken-unvalid-override-col shinken-col-value shinken-space" }, _( 'element.value' ) ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: "shinken-unvalid-override-col shinken-col-definition shinken-space" }, _( 'element.column_complete_definition' ) ), _to_return );
        return _to_return;
    },
    delete              : function () {
        for ( var i = 0, _size_i = this.overrides.length; i < _size_i; i++ ) {
            this.overrides[ i ].delete();
        }
        DOM.Service.removeElement( this.dom_element );
    }
    
};
OBJECT.ServiceOverrideUnvalid           = function ( index, override ) {
    this.__class  = "ServiceOverrideUnvalid";
    this.override = override;
    this.index    = index;
    this.init();
};
OBJECT.ServiceOverrideUnvalid.prototype = {
    init        : function () {
        this.computeType();
    },
    computeType : function () {
        this.type = this.override.has_already_been_linked ? OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK_FINAL : OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK;
        if ( this.override.host_uuid && this.override.host_uuid !== MANAGER.__instance_element_distributor.current_element.uuid ) {
            if ( !MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( this.override.host_uuid ) ) {
                this.type = OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_NOT_USED;
                return;
            }
            var _host = MANAGER.__instance_element_distributor.getElement( 'core-host-' + this.override.host_uuid );
            if ( _host && !_host.isEnabled() ) {
                this.type = OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_INACTIVE;
                return;
            }
        }
        if ( this.override.check_uuid ) {
            var _check = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.override.check_uuid );
            if ( _check && !_check.isEnabled() ) {
                this.type = OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_CHECK_INACTIVE;
                return;
            }
        }
        if ( this.override.old_check_in_page_host && this.override.old_check_in_page_host.element.is_dfe ) {
            this.type = OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT;
        }
    },
    getCheckName: function () {
        return this.override.getCheckName();
    },
    getCheckUuid: function () {
        switch ( this.type ) {
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT:
                return this.override.old_check_in_page_host.element.getUUID();
            
        }
        return this.override.check_uuid;
    },
    getHostUuid : function () {
        switch ( this.type ) {
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT:
                return this.override.old_check_in_page_host.element.host_uuid;
            
        }
        if ( this.override.host_uuid ) {
            return this.override.host_uuid;
        }
        if ( this.override.check_in_page_host ) {
            return this.override.check_in_page_host.element.host_uuid;
        }
        return MANAGER.__instance_element_distributor.current_element.getUUID();
    },
    getDfeKey   : function () {
        return this.override.old_check_in_page_host.key_dfe;
    },
    buildHtml   : function () {
        var _to_return = DOM.Service.createElement( 'tr', { class: 'shinken-check-line shinken-override-unvalid' } );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: 'shinken-unvalid-override-col shinken-col-property shinken-space' }, this.override.property ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: 'shinken-unvalid-override-col shinken-col-value shinken-space' }, this.override.label_complete ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: 'shinken-unvalid-override-col shinken-col-definition shinken-space' }, this.override.complete_definition ), _to_return );
        return _to_return;
    },
    delete      : function () {
        MANAGER.__instance_element_distributor.current_element.override.cleanOverride( this.override );
    }
};
OBJECT.CONST.OVERRIDE_UNVALID           = {
    TYPE: {
        LINK_CHECK_INACTIVE   : "1_link_check_inactive",
        LINK_TEMPLATE_INACTIVE: "3_link_template_inactive",
        LINK_TEMPLATE_NOT_USED: "2_link_template_not_used",
        LINK_DFE_NOT_PRESENT  : "4_link_dfe_not_present",
        UNLINK_FINAL          : "5_unlinked_final",
        UNLINK                : "6_unlinked"
    }
};
OBJECT.ServiceOverrides           = function ( datas ) {
    this.datas      = datas;
    this.has_errors = false;
    this.raw_value  = '';
    this.overrides  = [];
    this.size       = 0;
    this.init();
};
OBJECT.ServiceOverrides.prototype = {
    init                        : function () {
        if ( this.datas ) {
            this.error      = this.datas.error;
            this.has_error  = this.datas.has_error;
            this.has_errors = this.datas.has_errors;
            this.raw_value  = this.datas.raw_value;
            this.initOverrideElement();
        }
    },
    initOverrideElement         : function () {
        var _size = this.datas.links.length;
        for ( var i = 0; i < _size; i++ ) {
            this.addOverride( this.datas.links[ i ], this );
        }
    },
    addOverrideByProperty       : function ( property, check_in_page_host, host_in_page_host ) {
        var _override_value = property.getDataToSave();
        if ( !_override_value ) {
            return;
        }
        var _to_add               = new OBJECT.ServiceOverride();
        _to_add.is_check_existing = false;
        _to_add.dfe_key           = check_in_page_host.key_dfe;
        _to_add.check_name        = check_in_page_host.name;
        _to_add.check_uuid        = check_in_page_host.uuid;
        _to_add.check_type        = check_in_page_host.element.getType();
        _to_add.property          = property.override_prop_name;
        if ( _to_add.key === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
            _to_add.key = PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS;
        }
        _to_add.setValue( _override_value );
        _to_add.has_already_been_linked = true;
        _to_add.host_uuid               = host_in_page_host.uuid;
        _to_add.host_type               = MANAGER.__instance_element_distributor.getElement( "core-host-" + host_in_page_host.uuid ).getType();
        _to_add.is_host_existing        = false;
        _to_add.computeCompleteDefinition();
        
        this.overrides.push( _to_add );
        this.size = this.overrides.length;
    },
    addOverride                 : function ( to_add ) {
        var _to_return = new OBJECT.ServiceOverride( to_add );
        this.overrides.push( _to_return );
        this.size = this.overrides.length;
        return _to_return;
    },
    validate                    : function () {
        for ( var i = 0; i < this.size; i++ ) {
            this.overrides[ i ].validate();
        }
    },
    unSetOverrideCheckInPageHost: function ( check_in_page_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( check_in_page_host ) {
                if ( this.overrides[ i ].check_in_page_host && this.overrides[ i ].check_in_page_host.getDomUUID() === check_in_page_host.getDomUUID() ) {
                    this.overrides[ i ].setCheckInPageHost( null );
                }
            }
            else {
                this.overrides[ i ].setCheckInPageHost( null );
            }
        }
    },
    hasOverride                 : function ( check_in_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.overrides[ i ].is( check_in_host ) ) {
                return true;
            }
        }
        return false;
    },
    setCheckInPageHostOnOverride: function ( check_in_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            this.overrides[ i ].is( check_in_host );
        }
        return false;
    },
    getOverrideValue            : function ( prop_name, check_in_host ) {
        if ( prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
            prop_name = PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS;
        }
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.overrides[ i ].property === prop_name && this.overrides[ i ].is( check_in_host ) ) {
                return this.overrides[ i ].value;
            }
        }
        return null;
    },
    removeParentCounter         : function ( check_in_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.overrides[ i ].is( check_in_host ) ) {
                return this.overrides[ i ].resetCounters();
            }
        }
    },
    hasOverrideModulation       : function ( check_host, property_name ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( !this.overrides[ i ].is( check_host ) ) {
                continue;
            }
            if ( this.overrides[ i ].property !== property_name ) {
                continue;
            }
            switch ( this.overrides[ i ].value ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED;
                case PROPERTY.CONST.STATE_VALUE_PLUS:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.PLUS;
                default:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING;
            }
        }
        return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE;
    },
    cleanOverrideFor            : function ( _check_in_host ) {
        for ( var i = this.size - 1; i >= 0; i-- ) {
            if ( this.overrides[ i ].is( _check_in_host ) ) {
                this.overrides[ i ].resetCounters();
                this.overrides.splice( i, 1 );
            }
        }
        this.size = this.overrides.length;
        return this.size;
    },
    cleanOverride               : function ( override ) {
        for ( var i = this.size - 1; i >= 0; i-- ) {
            if ( this.overrides[ i ] === override ) {
                this.overrides.splice( i, 1 );
                break;
            }
        }
        this.size = this.overrides.length;
    },
    getDataToSave               : function ( override_values ) {
        var _size_override = override_values.length;
        var _current_element;
        var _to_add;
        var _host_element;
        var _current;
        var _to_return     = {};
        
        _to_return.has_errors = this.has_errors;
        _to_return.has_error  = this.has_error;
        _to_return.error      = this.error;
        _to_return.raw_value  = this.raw_value;
        _to_return.links      = [];
        
        for ( var i = 0; i < this.size; i++ ) {
            _current = this.overrides[ i ].getDataToSave();
            if ( _current && _current.check_link && !_current.check_link.exists && !_current.check_link.name ) {
                continue;
            }
            _to_return.links.push( _current );
        }
        
        for ( var i = 0; i < _size_override; i++ ) {
            _current         = override_values[ i ];
            _current_element = MANAGER.__instance_element_distributor.getElement( "core-service-" + _current.override_check_uuid );
            _host_element    = MANAGER.__instance_element_distributor.getElement( "core-host-" + _current_element.host_uuid );
            _to_add          = {};
            _to_add.key      = _current.override_prop_name;
            if ( _current.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
                _to_add.key = PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS;
            }
            _to_add.value                   = _current.getDataToSave();
            _to_add.host_link               = {};
            _to_add.check_link              = {};
            _to_add.host_link.exists        = true;
            _to_add.check_link.exists       = true;
            _to_add.check_link.item_type    = _current_element.type;
            _to_add.check_link._id          = _current_element.getUUID();
            _to_add.check_link.name         = _current.override_check_name;
            _to_add.host_link._id           = _host_element.getUUID();
            _to_add.host_link.item_type     = _host_element.getType();
            _to_add.host_link.name          = _host_element.getName();
            _to_add.has_already_been_linked = true;
            
            if ( _current_element.is_dfe ) {
                _to_add.dfe_key = _current.override_dfe_name;
            }
            
            _to_return.links.push( _to_add );
        }
        if ( !_to_return.links.length ) {
            _to_return = null;
        }
        return _to_return;
    }
};
OBJECT.ServiceOverride           = function ( data ) {
    this.__class             = "ServiceOverride";
    this.is_check_existing   = false;
    this.is_host_existing    = false;
    this.is_not_linked       = false;
    this.complete_definition = "";
    this.initCounters();
    if ( data ) {
        this.init( data );
    }
};
OBJECT.ServiceOverride.prototype = {
    init                     : function ( data ) {
        this.property = data.key;
        this.setValue( data.value );
        this.setValueWithLink( data.value_with_link );
        this.check_name              = data.check_link.name;
        this.is_check_existing       = data.check_link.exists;
        this.check_uuid              = data.check_link._id;
        this.dfe_key                 = data.dfe_key;
        this.check_type              = data.check_link.item_type;
        this.has_already_been_linked = data.has_already_been_linked || false;
        if ( this.check_uuid ) {
            this.has_already_been_linked = true;
        }
        if ( data.host_link ) {
            this.host_uuid        = data.host_link._id;
            this.host_type        = data.host_link.item_type;
            this.is_host_existing = data.host_link.exists;
        }
        this.computeCompleteDefinition();
    },
    setValue                 : function ( to_set ) {
        this.value          = to_set;
        this.label          = this.value;
        this.label_complete = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss( this.value );
        if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.property ) ) {
            this.label          = SHINKEN.TOOLS.ENCRYPTION.getDefaultLabel();
            this.label_complete = SHINKEN.TOOLS.ENCRYPTION.getDefaultSpanLabel();
        }
    },
    setValueWithLink         : function ( to_set ) {
        this.value_with_link = to_set;
    },
    getCheckName             : function () {
        if ( !this.check_name && this.check_uuid ) {
            var _element = MANAGER.__instance_element_distributor.getElement( 'core-service-' + this.check_uuid );
            if ( !_element ) {
                return;
            }
            this.check_name = _element.getName();
        }
        if ( this.dfe_key ) {
            return this.check_name.replace( '$KEY$', this.dfe_key );
        }
        return this.check_name;
    },
    setCheckInPageHost       : function ( to_set ) {
        if ( this.check_in_page_host ) {
            this.resetCounters();
            this.old_check_in_page_host = this.check_in_page_host;
        }
        this.check_in_page_host = to_set;
    },
    isOnSame                 : function ( override ) {
        if ( this.check_uuid === override.check_uuid && this.property === override.property ) {
            return true;
        }
        if ( (!this.check_uuid || !override.check_uuid) && this.check_name === override.check_name && this.property === override.property ) {
            return true;
        }
        return false;
    },
    is                       : function ( check_in_host ) {
        var _to_return = false;
        if ( this.check_in_page_host ) {
            return check_in_host.getDomUUID() === this.check_in_page_host.getDomUUID();
        }
        else if ( check_in_host.is_dfe && this.check_name === check_in_host.name && !this.has_already_been_linked ) {
            _to_return = true;
        }
        else if ( this.check_uuid === check_in_host.uuid ) {
            if ( check_in_host.is_dfe ) {
                _to_return = this.dfe_key === check_in_host.key_dfe;
            }
            else {
                _to_return = true;
            }
        }
        else if ( this.check_name && this.check_name === check_in_host.name && !this.has_already_been_linked ) {
            _to_return = true;
        }
        
        this.setCheckInPageHost( _to_return ? check_in_host : null );
        return _to_return;
    },
    findCheck                : function () {
        var _to_return = null;
        if ( this.check_uuid ) {
            _to_return = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.check_uuid );
        }
        else if ( this.host_uuid ) { //DFE CASE, WE MAKE THE BEST WE CAN, BECAUSE WE ARE NOT ABLE TO KNOW WHICH CHECK WE ARE TALKING ABOUT
            var _checks = MANAGER.__instance_element_distributor.getCheckForElement( this.host_uuid );
            for ( var i = 0, _size_i = _checks.length; i < _size_i; i++ ) {
                if ( _checks[ i ].is_dfe ) {
                    _to_return = _checks[ i ];
                    break;
                }
            }
        }
        else if ( this.check_name ) {//CASE OF UNLINK OVERRIDE
            if ( this.check_in_page_host && this.check_in_page_host.name === this.check_name ) {
                _to_return = this.check_in_page_host.element;
            }
            else {
                var _checks = MANAGER.__instance_element_distributor.getAllElementsOfTypeCheck();
                for ( var i = 0, _size_i = _checks.length; i < _size_i; i++ ) {
                    if ( _checks[ i ].getName() === this.check_name ) {
                        _to_return = _checks[ i ];
                        break;
                    }
                }
            }
        }
        return _to_return;
    },
    getDataToSave            : function () {
        var _to_return = {};
        _to_return.key = this.property;
        switch ( this.value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _to_return.value = this.value;
                break;
            default:
                _to_return.value = this.value_with_link ? this.value_with_link : this.value;
                break;
        }
        
        _to_return.check_link  = {};
        _to_return.host_link   = {};
        this.is_check_existing = !!this.is_check_existing;
        if ( !this.is_check_existing && this.check_in_page_host ) {
            this.is_check_existing = true;
            this.check_uuid        = this.check_in_page_host.element.getUUID();
        }
        _to_return.check_link.exists = this.is_check_existing;
        if ( this.is_check_existing && MANAGER.__instance_element_distributor.getElement( "core-service-" + this.check_uuid ) ) {
            var _check                      = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.check_uuid );
            _to_return.check_link._id       = this.check_uuid;
            _to_return.check_link.item_type = _check.getType();
            _to_return.check_link.name      = _check.getName();
            _to_return.host_link._id        = _check.host_uuid || this.host_uuid;
            _to_return.host_link.item_type  = _check.host_type || this.host_type;
            _to_return.host_link.name       = _check.host_name;
            _to_return.host_link.exists     = true;
            if ( _check.is_dfe ) {
                _to_return.dfe_key         = this.dfe_key;
                _to_return.check_link.name = this.getCheckName();
                if ( this.check_in_page_host ) {
                    _to_return.dfe_key         = this.check_in_page_host.key_dfe;
                    _to_return.check_link.name = this.check_in_page_host.name;
                    if ( this.check_in_page_host.is_obsolete ) {
                        _to_return.check_link.exists = false;
                    }
                }
                else if ( this.old_check_in_page_host ) {
                    _to_return.dfe_key         = this.old_check_in_page_host.key_dfe;
                    _to_return.check_link.name = this.old_check_in_page_host.name;
                }
            }
        }
        else {
            _to_return.check_link.name = this.check_name;
        }
        
        _to_return.has_already_been_linked = this.has_already_been_linked;
        return _to_return;
        
    },
    computeCompleteDefinition: function () {
        this.complete_definition = OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES + SHINKEN.TOOLS.STRING.CONST.NON_BREAK_SPACE +
                                   SHINKEN.TOOLS.STRING.CONST.NON_BREAK_SPACE + this.getCheckName() +
                                   SHINKEN.TOOLS.STRING.CONST.COMMA + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE +
                                   this.property + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE + this.label_complete;
    },
    validate                 : function () {
        if ( !this.check_in_page_host ) {
            return;
        }
        if ( !this.check_in_page_host.element.isEnabled() ) {
            return;
        }
        this.getCounterError().setParent( this.check_in_page_host.button_override.getCounterError() );
        this.getCounterWarning().setParent( this.check_in_page_host.button_override.getCounterWarning() );
        switch ( this.value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                return;
        }
        
        var _validator;
        var _current_select;
        var _current_type = PROPERTY.getTypeByName( this.property, this.check_in_page_host.element.getType() );
        switch ( _current_type ) {
            case PROPERTY.CONST.TYPES.DATA:
                var _check = this.findCheck();
                if ( _check && !_check[ this.property ] ) {
                    _validator = new OBJECT.Messages();
                    _validator.addMessage( COMPONENT.CONST.STATUS.WARNING, 'unknown' );
                }
                break;
            case PROPERTY.CONST.TYPES.STRING_INPUT :
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN :
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init( { override_prop_name: this.property, is_override: true }, this.value );
                break;
            case PROPERTY.CONST.TYPES.RANGE :
                var _check = this.findCheck();
                if ( _check ) {
                    if ( this.property === PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD ) {
                        var _value_low        = parseInt( this.value );
                        var _value_high_check = MANAGER.__instance_element_distributor.current_element.getOverrideValue( PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD, this.check_in_page_host );
                        if ( !_value_high_check ) {
                            _value_high_check = parseInt( _check[ PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ] );
                            if ( isNaN( _value_high_check ) ) {
                                return;
                            }
                        }
                        else {
                            _value_high_check = parseInt( _value_high_check );
                        }
                        if ( _value_low > _value_high_check ) {
                            _validator = new OBJECT.Messages();
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'bad_flap' );
                        }
                    }
                    else if ( this.property === PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ) {
                        var _value_high      = parseInt( this.value );
                        var _value_low_check = MANAGER.__instance_element_distributor.current_element.getOverrideValue( PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD, this.check_in_page_host );
                        if ( !_value_low_check ) {
                            _value_low_check = parseInt( _check[ PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD ] );
                            if ( isNaN( _value_low_check ) ) {
                                return;
                            }
                        }
                        else {
                            _value_low_check = parseInt( _value_low_check );
                        }
                        if ( _value_low_check > _value_high ) {
                            _validator = new OBJECT.Messages();
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'bad_flap' );
                        }
                    }
                }
                break;
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT :
                var _check = this.findCheck();
                if ( _check ) {
                    if ( this.property === PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD ) {
                        var _value_low        = parseFloat( this.value );
                        var _value_high_check = MANAGER.__instance_element_distributor.current_element.getOverrideValue( PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD, this.check_in_page_host );
                        if ( !_value_high_check ) {
                            _value_high_check = parseFloat( _check[ PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD ] );
                            if ( isNaN( _value_high_check ) ) {
                                return;
                            }
                        }
                        else {
                            _value_high_check = parseFloat( _value_high_check );
                            if ( _value_high_check < 0 ) {
                                _value_high_check = 0;
                            }
                            else if ( _value_high_check > 100 ) {
                                _value_high_check = 100;
                            }
                        }
                        if ( _value_low > _value_high_check ) {
                            _validator = new OBJECT.Messages();
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'bad_sla' );
                        }
                    }
                    else if ( this.property === PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD ) {
                        var _value_high      = parseFloat( this.value );
                        var _value_low_check = MANAGER.__instance_element_distributor.current_element.getOverrideValue( PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD, this.check_in_page_host );
                        if ( !_value_low_check ) {
                            _value_low_check = parseFloat( _check[ PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD ] );
                            if ( isNaN( _value_low_check ) ) {
                                return;
                            }
                        }
                        else {
                            _value_low_check = parseFloat( _value_low_check );
                            if ( _value_low_check < 0 ) {
                                _value_low_check = 0;
                            }
                            else if ( _value_low_check > 100 ) {
                                _value_low_check = 100;
                            }
                        }
                        if ( _value_low_check > _value_high ) {
                            _validator = new OBJECT.Messages();
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'bad_sla' );
                        }
                    }
                }
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT :
                switch ( this.property ) {
                    case PROPERTY.CONST.NAME.CHECK_PERIOD:
                    case PROPERTY.CONST.NAME.MAINTENANCE_PERIOD:
                    case PROPERTY.CONST.NAME.NOTIFICATION_PERIOD:
                        _current_select = MANAGER.__instance_element_distributor.getElementByName( this.value );
                        _validator      = new OBJECT.Messages();
                        if ( _current_select ) {
                            if ( !_current_select.isEnabled() ) {
                                _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'disabled' );
                            }
                        }
                        else {
                            _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'unknown' );
                        }
                }
                break;
            case PROPERTY.CONST.TYPES.MULTI_SELECT :
                var _name_table = "";
                switch ( this.property ) {
                    case PROPERTY.CONST.NAME.CONTACT_GROUPS:
                        _name_table = 'contactgroups';
                        break;
                    case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
                        _name_table = 'businessimpactmodulations';
                        break;
                    default:
                        _name_table = this.property;
                }
                _validator  = new OBJECT.Messages();
                var _values = this.value;
                if ( SHINKEN.TOOLS.STRING.startsWith( this.value, PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ) {
                    _values = _values.substr( 1 );
                }
                _values = _values.split( ',' );
                for ( var i = 0, _size_i = _values.length; i < _size_i; i++ ) {
                    _current_select = MANAGER.__instance_element_distributor.getElementByName( _values[ i ] );
                    if ( _current_select ) {
                        if ( !_current_select.isEnabled() || _current_select.is_new ) {
                            _validator.addMessage( COMPONENT.CONST.STATUS.WARNING, 'disabled' );
                        }
                    }
                    else {
                        _validator.addMessage( COMPONENT.CONST.STATUS.ERROR, 'unknown' );
                    }
                }
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                switch ( this.property ) {
                    case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                        _validator = this._validateMultiUrl();
                        break;
                }
                break;
        }
        if ( _validator ) {
            if ( _validator.hasError() ) {
                switch ( _current_type ) {
                    case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        this.setError( this.property, _validator.messages_error.length );
                        break;
                    default:
                        this.setError( this.property, 1 );
                        break;
                }
            }
            else if ( _validator.hasWarning() ) {
                switch ( _current_type ) {
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        this.setWarning( this.property, _validator.messages_warning.length );
                        break;
                    default:
                        this.setWarning( this.property, 1 );
                        break;
                }
            }
        }
        if ( this.is_not_linked ) {
            this.setCheckInPageHost( null );
        }
    },
    _validateMultiUrl        : function () {
        var _lines     = this.value.split( PROPERTY.CONST.NOTES_URL.SEPERATOR.ENTRY );
        var _current;
        var _datas;
        var _validator = new OBJECT.Messages();
        for ( var i = 0, _size = _lines.length; i < _size; i++ ) {
            _current = _lines[ i ];
            _datas   = _current.split( PROPERTY.CONST.NOTES_URL.SEPERATOR.KEY_VALUE );
            SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( [ PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK ], _datas[ 0 ], _validator );
            SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( [ PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK_URL, PROPERTY.CONST.VALIDATOR.TYPE.URL ], _datas[ 1 ], _validator );
        }
        return _validator;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.ServiceOverride, SHINKEN.OBJECT.CounterInterface );
OBJECT.ShinkenElement                    = function () {
    this.name_element = '';
    this.type         = '';
    this.is_enabled   = true;
    this.phase        = OBJECT.CONST.ELEMENT.PHASE.INIT;
};
OBJECT.ShinkenElement.prototype          = {
    FIELD                       : OBJECT.CONST.ELEMENT.FIELD,
    init                        : function () {
    },
    updateData                  : function ( datas ) {
        if ( !datas ) {
            return;
        }
        var _keys     = Object.keys( datas );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, datas[ _currentKey ] );
        }
        this.computeName();
    },
    setPhase                    : function ( to_set ) {
        var self = this;
        switch ( to_set ) {
            case OBJECT.CONST.ELEMENT.PHASE.EDITING:
                if ( this.phase === OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED ) {
                    return;
                }
                break;
        }
        this.phase = to_set;
        switch ( this.phase ) {
            case OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED:
                var _all_properties = MANAGER.__instance_property_distributor.getAllElements();
                for ( var i = 0, _size = _all_properties.length; i < _size; i++ ) {
                    _all_properties[ i ].checkErrorWarning();
                }
                break;
        }
    },
    setType                     : function ( to_set ) {
        this.type = to_set;
    },
    getType                     : function () {
        return this.type;
    },
    getHelpType                 : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                return OBJECT.CONST.ELEMENT.TYPE.HOSTS;
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                return OBJECT.CONST.ELEMENT.TYPE.CLUSTERS;
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                return "services";
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
                return OBJECT.CONST.ELEMENT.TYPE.CONTACTS;
        }
        return this.type;
    },
    isType                      : function ( types ) {
        if ( typeof types === 'string' ) {
            types = [types];
        }
        for ( var i = 0, _size_i = types.length; i < _size_i; i++ ) {
            if ( this.type === types[ i ] ) {
                return true;
            }
        }
        return false;
    },
    isNew                       : function () {
        return this.is_new;
    },
    isCheck                     : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                return true;
        }
        return false;
    },
    isCluster                   : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                return true;
        }
        return false;
    },
    isTemplate                  : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
                return true;
        }
        return false;
    },
    canHaveData                 : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_DATA:
                return true;
        }
        return false;
    },
    canHaveCheck                : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                return true;
        }
        return false;
    },
    canHaveUserRights           : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                return true;
        }
        return false;
    },
    canHaveTemplate             : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                return true;
        }
        return false;
    },
    setData                     : function ( key, value ) {
        switch ( key ) {
            case this.FIELD.ID:
                this.setUUID( value );
                break;
            case this.FIELD.SERVICE_OVERRIDES:
                this.setOverride( value );
                break;
            case this.FIELD.SERVICE_EXCLUDES_BY_ID:
                this.setExclude( value );
                break;
            case this.FIELD.ENABLED:
                this.setEnabled( value );
                break;
            case this.FIELD.SOURCES:
            case this.FIELD.IMPORT_DATE:
            case this.FIELD.USE:
                this[ key ] = value;
                break;
            case this.FIELD.SYNC_KEYS:
            case this.FIELD.LAST_MODIFICATION:
            case '_SE_UUID':
            case '_SE_UUID_HASH':
                break;
            case '@metadata':
                this.setMetadata( value );
                break;
            case 'duplicate_foreach':
                this[ key ]           = value;
                this.is_dfe           = true;
                this.is_dfe_protected = SHINKEN.TOOLS.ENCRYPTION.isProtectedField( value );
                break;
            case this.FIELD.WORK_AREA_INFO:
                this.setWorkAreaData( value );
                break;
            default:
                this[ key ] = value;
            
        }
    },
    setMetadata                 : function ( to_set ) {
        this.setType( to_set.type );
        this.host_uuid = to_set.host_uuid;
        if ( !this.host_uuid && MANAGER.__instance_element_distributor && MANAGER.__instance_element_distributor.current_element ) {
            switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
                    if ( this.type === OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST ) {
                        this.host_uuid = MANAGER.__instance_element_distributor.current_element.uuid;
                    }
                    break;
                case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                    if ( this.type === OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST ) {
                        this.host_uuid = MANAGER.__instance_element_distributor.current_element.uuid;
                    }
                    break;
            }
        }
        this.host_type   = to_set.host_type;
        this.is_new      = to_set.new;
        this.is_creation = to_set.in_creation || false;
        this.has_data    = to_set.has_data;
        this.setStatus( to_set.state );
    },
    setUUID                     : function ( to_set ) {
        this.uuid = to_set;
    },
    setEnabled                  : function ( to_set ) {
        if ( to_set === '1' ) {
            this.is_enabled = true;
        }
        else if ( to_set === '0' ) {
            this.is_enabled = false;
        }
    },
    setStatus                   : function ( to_set ) {
        this[ OBJECT.CONST.ELEMENT.FIELD.STATUS ] = to_set;
        if ( to_set === OBJECT.CONST.ELEMENT.STATUS.NEW ) {
            this.is_new = true;
        }
    },
    cleanChecks                 : function () {
        if ( !this.canHaveCheck() ) {
            return;
        }
        this.checks         = [];
        this.size_dfe_check = 0;
    },
    addCheck                    : function ( to_add ) {
        this.checks.push( to_add );
        if ( to_add.is_dfe ) {
            this.size_dfe_check++;
        }
    },
    isEnabled                   : function () {
        return this.is_enabled;
    },
    setWorkAreaData             : function ( data ) {
        this.work_area_status = data[ 'status' ];
    },
    getName                     : function () {
        return this.name_element;
    },
    getUUID                     : function () {
        return this.uuid;
    },
    getSEUUID                   : function () {
        return OBJECT.ShinkenElement.generateSEUUID( this.type, this.uuid );
    },
    getAllData                  : function () {
        var _to_return = {};
        var keys       = Object.keys( this );
        var _current;
        for ( var i = 0, _size = keys.length; i < _size; i++ ) {
            _current = keys[ i ];
            if ( SHINKEN.TOOLS.STRING.startsWith( _current, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                _to_return[ _current ] = this[ _current ];
            }
        }
        delete _to_return[ "_SYNC_KEYS" ];
        return _to_return;
    },
    computeKeyName              : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
                this.key_name = 'host_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.HOST_GROUPS:
                this.key_name = 'hostgroup_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
                this.key_name = 'service_description';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.COMMANDS:
                this.key_name = 'command_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_GROUPS:
                this.key_name = 'contactgroup_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                this.key_name = 'name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
                this.key_name = 'contact_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.ESCALATIONS:
                this.key_name = 'escalation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_BUSINESS_IMPACT:
                this.key_name = 'business_impact_modulation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_DATA:
                this.key_name = 'macromodulation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_RESULT:
                this.key_name = 'resultmodulation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.NOTIFICATION_WAYS:
                this.key_name = 'notificationway_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.TIME_PERIODS:
                this.key_name = 'timeperiod_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.DISCOVERY:
                this.key_name = 'discovery_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.SYNCHRONIZER_LINKER:
                this.key_name = PROPERTY.CONST.NAME.SYNC_NAME;
                break;
            default:
                console.error( "[type not managed] ==>", this.type );
        }
    },
    computeName                 : function () {
        this.computeKeyName();
        this.name_element = this[ this.key_name ];
    },
    getValuesSplitted           : function ( property_name ) {
        var _to_return = [];
        if ( !this[ property_name ] ) {
            return _to_return;
        }
        var _modulation_list;
        var _modulation_name;
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
                _modulation_name = PROPERTY.CONST.NAME.RESULTMODULATION_NAME;
                break;
            case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
                _modulation_name = PROPERTY.CONST.NAME.MACROMODULATION_NAME;
                break;
            default:
                _to_return = SHINKEN.TOOLS.STRING.startsWith( this[ property_name ], PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ? this[ property_name ].substr( 1 ) : this[ property_name ];
                _to_return = _to_return.split( ',' );
                break;
        }
        if ( _modulation_name ) {
            _modulation_list = this[ property_name ];
            _to_return       = [];
            if ( typeof _modulation_list !== 'string' ) {
                for ( var i = 0, _size_i = _modulation_list.length; i < _size_i; i++ ) {
                    _to_return.push( _modulation_list[ i ][ _modulation_name ] );
                }
            }
            else {
                _to_return = _modulation_list.split( ',' );
            }
        }
        
        return _to_return;
    },
    getValidCheck               : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.checks.length; i < _size_i; i++ ) {
            if ( !this.checks[ i ].is_obsolete ) {
                _to_return.push( this.checks[ i ] );
            }
        }
        return _to_return;
    },
    buildBaseUrl                : function () {
        var _to_return = "item_id=" + this.getUUID();
        _to_return += "&item_type=" + this.getType();
        _to_return += "&item_state=stagging";
        return _to_return;
    },
    getTypeModulation           : function ( modulation_name ) {
        if ( !this[ modulation_name ] ) {
            return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE;
        }
        switch ( this[ modulation_name ] ) {
            case PROPERTY.CONST.STATE_VALUE_PLUS.ON:
                return OBJECT.CONST.ELEMENT.MODULATION.TYPE.PLUS;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED;
        }
        var _current;
        for ( var i = 0, _size = this[ modulation_name ].length; i < _size; i++ ) {
            _current = this[ modulation_name ][ i ];
            if ( _current.missing || _current.invalid ) {
                return OBJECT.CONST.ELEMENT.MODULATION.TYPE.ERROR;
            }
        }
        return OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING;
    },
    getDataToSave               : function ( type ) {
        var _to_return = {};
        switch ( type ) {
            case OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK:
                _to_return[ OBJECT.CONST.ELEMENT.FIELD.ITEM_TYPE ] = this.getType();
                _to_return[ OBJECT.CONST.ELEMENT.FIELD.ID ]        = this.getUUID();
                _to_return[ "exists" ]                             = true;
                _to_return[ "name" ]                               = this.getName();
                break;
        }
        return _to_return;
    },
    setExclude                  : function ( to_set ) {
        this.exclude = new OBJECT.ServiceExcludes( to_set );
    },
    changeExcludeStatus         : function ( check_in_page_host ) {
        if ( !this.exclude ) {
            this.exclude = new OBJECT.ServiceExcludes();
        }
        var _to_return       = this.exclude.changeExcludeStatus( check_in_page_host );
        var _other_candidate = App.Elements.ChecksTab.getAllCheckByID( check_in_page_host.uuid, check_in_page_host.key_dfe );
        for ( var i = 0, _size_i = _other_candidate.length; i < _size_i; i++ ) {
            _other_candidate[ i ].updateExcludeStatus();
        }
        return _to_return;
    },
    getExcludeStatus            : function ( check_in_page_host ) {
        if ( !this.exclude ) {
            return OBJECT.CONST.EXCLUDE_STATUS.OFF;
        }
        return this.exclude.getExcludeStatus( check_in_page_host );
    },
    setOverride                 : function ( to_set ) {
        this.override = new OBJECT.ServiceOverrides( to_set );
    },
    addOverrideByProperty       : function ( property, check_in_page_host, host_in_page_host ) {
        if ( !this.override ) {
            this.override = new OBJECT.ServiceOverrides();
        }
        this.override.addOverrideByProperty( property, check_in_page_host, host_in_page_host );
    },
    hasOverride                 : function ( check_in_page_host ) {
        if ( !this.override ) {
            return false;
        }
        return this.override.hasOverride( check_in_page_host );
    },
    setCheckInPageHostOnOverride: function ( check_in_page_host ) {
        if ( !this.override ) {
            return false;
        }
        return this.override.setCheckInPageHostOnOverride( check_in_page_host );
    },
    removeParentCounter         : function ( check_in_page_host ) {
        if ( !this.override || !check_in_page_host ) {
            return;
        }
        this.override.removeParentCounter( check_in_page_host );
    },
    getOverrideValue            : function ( prop_name, check_in_page_host ) {
        if ( !this.override || !check_in_page_host ) {
            return null;
        }
        return this.override.getOverrideValue( prop_name, check_in_page_host );
    },
    
    hasOverrideModulation       : function ( check_host, property_name ) {
        if ( !this.override ) {
            return false;
        }
        return this.override.hasOverrideModulation( check_host, property_name );
    },
    cleanOverrideFor            : function ( _check_in_host ) {
        if ( !this.override ) {
            return;
        }
        var _nb_override = this.override.cleanOverrideFor( _check_in_host );
        if ( !_nb_override ) {
            delete this.override;
        }
        return _nb_override;
    },
    validateOverride            : function () {
        if ( !this.override ) {
            return;
        }
        this.override.validate();
    },
    unSetOverrideCheckInPageHost: function ( check_in_page_host ) {
        if ( !this.override ) {
            return;
        }
        this.override.unSetOverrideCheckInPageHost( check_in_page_host );
    }
};
OBJECT.ShinkenElement.generateSEUUID     = function ( type, uuid ) {
    return "core-" + OBJECT.ShinkenElement.generateSEUUIDType( type ) + "-" + uuid;
};
OBJECT.ShinkenElement.generateSEUUIDType = function ( type ) {
    switch ( type ) {
        case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
        case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            return "host";
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
            return "service";
        case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
            return "contact";
    }
    return SHINKEN.TOOLS.STRING.getSubStringUntil( type, 0, 1 );
};
OBJECT.ShinkenElementFactory = function ( data ) {
    var _to_return = new OBJECT.ShinkenElement();
    _to_return.updateData(data);
    return _to_return;
};
OBJECT.CONST.STEP = {
    ERROR: -1,
    _0   : 0,
    _1   : 1,
    _2   : 2,
    _3   : 3,
    _4   : 4,
    _5   : 5
};
OBJECT.Steps           = function ( nb_step ) {
    this.init( nb_step );
};
OBJECT.Steps.prototype = {
    init           : function ( nb_step ) {
        this.max_step = nb_step;
        this.contents = [];
        this.current  = 0;
        for ( var i = 0; i <= this.max_step; i++ ) {
            this.contents[ i ] = new OBJECT.Step( i );
        }
    },
    initDomElements: function ( shinken_id ) {
        this.dom_element = document.getElementById( shinken_id );
        for ( var i = 0; i <= this.max_step; i++ ) {
            this.get( i ).initDomElement( shinken_id );
        }
    },
    setDomReady    : function ( to_set ) {
        this.get( this.current ).setDomReady( to_set );
    },
    isDomReady     : function () {
        return this.get( this.current ).is_dom_ready;
    },
    setCurrent     : function ( index ) {
        this.previous = this.current;
        this.current  = index;
        DOM.Service.setDataSet( this.dom_element, 'currentStep', this.current );
    },
    get            : function ( index ) {
        if ( index === undefined ) {
            index = this.current;
        }
        return this.contents[ index ];
    },
    getNextButton  : function () {
        return this.get( this.current ).button_next;
    }
};
OBJECT.Step           = function ( index ) {
    this.index        = index;
    this.button_next  = null;
    this.is_dom_ready = false;
    this.dom_element  = null;
    this.dom_id       = null;
};
OBJECT.Step.prototype = {
    init          : function () {
    },
    setDomReady   : function ( to_set ) {
        this.is_dom_ready = to_set;
        if ( this.is_dom_ready ) {
            this.dom_element = document.getElementById( this.dom_id );
            this.button_next = MANAGER.__instance_button_distributor.findButton( "step" + this.index + "-next" );
        }
        else {
            this.setHtmlContent( document.querySelector( ".shinken-loading-div" ) );
        }
    },
    setHtmlContent: function ( dom_element_target ) {
        if ( this.dom_element && dom_element_target ) {
            this.dom_element.innerHTML = dom_element_target.outerHTML;
        }
    },
    initDomElement: function ( shinken_id ) {
        this.dom_id = shinken_id + "-step" + this.index;
    }
};
OBJECT.TemplateProperty           = function ( name, template_name, value, _template_id ) {
    this.name = name;
    this.setTemplateName( template_name, _template_id );
    this.init( value );
};
OBJECT.TemplateProperty.prototype = {
    init              : function ( value ) {
        this.state               = COMPONENT.CONST.BTN_STATE.OFF;
        this.is_stopped          = false;
        this.is_heritage_stopped = false;
        this.is_last             = false;
        this.setValue( value );
    },
    updateValueWithUse: function ( property ) {
        if ( !this.hasPlus() ) {
            return;
        }
        if ( property.value === PROPERTY.CONST.CUSTOM_SELECT.NONE ||
             property.value === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
            this.is_heritage_stopped = true;
        }
        if ( this.is_heritage_stopped ) {
            return;
        }
        
        var _values = property.values;
        this.values = SHINKEN.TOOLS.ARRAY.concatUnique( this.values, _values );
        this._computeTags();
        if ( !property.hasPlus() ) {
            this.is_heritage_stopped = true;
        }
    },
    hasPlus           : function () {
        return (this.state === COMPONENT.CONST.BTN_STATE.ON);
    },
    getTags           : function () {
        return this.tags;
    },
    isEmpty           : function () {
        var _property = MANAGER.__instance_property_distributor.findElement( this.name );
        switch ( _property.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                return !this.size_tags;
            default:
                return !this.value;
        }
        return true;
    },
    setValue          : function ( to_set ) {
        if ( to_set && to_set.type === PROPERTY.CONST.TYPES.DATA ) {
            this.setValueData( to_set );
            return;
        }
        this.value = to_set;
        
        to_set        = to_set + "";
        var _has_plus = SHINKEN.TOOLS.STRING.extractStringIfBeginningBy( to_set, PROPERTY.CONST.STATE_VALUE_PLUS.ON );
        if ( _has_plus !== false ) { //CAN BE EMPTY ("")
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
            to_set = _has_plus;
        }
        switch ( to_set ){
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                this.value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                this.value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
                break;
        }
        this.label  = this.value;
        this.values = to_set ? to_set.split( ',' ) : [];
        this._computeTags();
    },
    setValueData      : function ( to_set ) {
        this.data   = to_set;
        this.value  = to_set.value + "";
        this.label  = this.value;
        this.values = this.value ? this.value.split( ',' ) : [];
    },
    setState          : function ( to_set ) {
        this.state = to_set;
    },
    setTags           : function ( to_set ) {
        this.tags = to_set;
    },
    setIsStopped      : function ( to_set ) {
        this.is_stopped = to_set;
    },
    setTemplateName   : function ( to_set, _template_id ) {
        this.template_name = to_set;
        if ( _template_id ) {
            this.template_id = _template_id;
        }
    },
    setIsLast         : function ( to_set ) {
        this.is_last = to_set;
    },
    _computeTags      : function () {
        var _property = MANAGER.__instance_property_distributor.findElement( this.name );
        if ( !_property ) {
            return;
        }
        if ( _property.type !== PROPERTY.CONST.TYPES.MULTI_SELECT ) {
            return;
        }
        this.size_tags = 0;
        var _size      = this.values.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = this._addTag( this.values[ i ], _property );
        }
        this.setTags( _to_return );
    },
    _createElementList: function ( name, state, type ) {
        var _element = new OBJECT.ElementList();
        _element.setName( name );
        _element.setState( state );
        _element.setType( type );
        return _element;
    },
    _addTag           : function ( key_name, _property ) {
        var _element = this._createElementList( key_name, 'inherited', OBJECT.CONST.ELEMENT_LIST.TYPE.INHERITANCE );
        var _tag     = new COMPONENT.Tag();
        _tag.setElement( _element );
        var _full_link = '';
        if ( _property && MANAGER.__instance_element_distributor.current_user.is_admin ) {
            var _element = _property.getSelector().list_element.getElement( key_name );
            if ( _element ) {
                var _link_1 = _element.getItemType();
                var _link_2 = _element.uuid;
                if ( _element.state === COMPONENT.CONST.TAG.STATE.NEW ) {
                    _link_2 = _link_2 + '?new=1';
                }
                _full_link = [ _link_1, _link_2 ];
            }
        }
        _tag.buildHTML( "", "", _full_link );
        this.size_tags++;
        return _tag;
    }
};
OBJECT.Template           = function ( data ) {
    this.init( data );
};
OBJECT.Template.prototype = {
    init                     : function ( data ) {
        this.properties                                  = {};
        this.datas                                       = {};
        this.checks                                      = [];
        this.size_dfe_check                              = 0;
        this[ OBJECT.CONST.TEMPLATE.FIELD.USE ]          = [];
        this[ OBJECT.CONST.TEMPLATE.FIELD.ENABLED ]      = true;
        this[ OBJECT.CONST.TEMPLATE.FIELD.IS_NEW ]       = false;
        this[ OBJECT.CONST.TEMPLATE.FIELD.UNCONFIGURED ] = false;
        this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.USEFUL );
        this.updateData( data );
    },
    updateData               : function ( data ) {
        var _currentKey;
        this[ OBJECT.CONST.TEMPLATE.FIELD._ID ]  = data[ OBJECT.CONST.TEMPLATE.FIELD._ID ];
        this[ OBJECT.CONST.TEMPLATE.FIELD.UUID ] = data[ OBJECT.CONST.TEMPLATE.FIELD._ID ];
        var _keys                                = Object.keys( data );
        var _sizeData                            = _keys.length;
        this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ] = data[ OBJECT.CONST.TEMPLATE.FIELD.NAME ];
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData                  : function ( key, value ) {
        switch ( key ) {
            case OBJECT.CONST.TEMPLATE.FIELD.NAME:
            case OBJECT.CONST.TEMPLATE.FIELD.IS_TEMPLATE:
            case OBJECT.CONST.TEMPLATE.FIELD.ITEM_TYPE:
            case OBJECT.CONST.TEMPLATE.FIELD.LAST_MODIFICATION:
            case OBJECT.CONST.TEMPLATE.FIELD.REGISTER:
            case OBJECT.CONST.TEMPLATE.FIELD.SOURCES:
                this[ key ] = value;
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.STATUS:
                this.setStatus( value );
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.ENABLED:
                this.setEnabled( value );
                
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.UNCONFIGURED:
                this[ key ] = value;
                if ( value ) {
                    this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN );
                }
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.IS_NEW:
                this[ key ] = value;
                if ( value ) {
                    this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.NEW );
                }
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.LOOP:
                this[ key ] = value;
                this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.BADLOOP );
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.USE:
                this.setUse( value );
                break;
            case OBJECT.CONST.TEMPLATE.FIELD.WORK_AREA_INFO:
            case OBJECT.CONST.TEMPLATE.FIELD.METADATA:
            case OBJECT.CONST.TEMPLATE.FIELD._SYNC_KEYS:
            case OBJECT.CONST.TEMPLATE.FIELD.IS_TOP_LEVEL:
                break;
            case OBJECT.CONST.ELEMENT.FIELD.SERVICE_OVERRIDES:
                this.override = new OBJECT.ServiceOverrides( value );
                break;
            default:
                if ( SHINKEN.TOOLS.STRING.startsWith( key, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                    var _data = new PROPERTY.Data( key, value );
                    if ( _data.is_valid ) {
                        this.datas[ key ] = new OBJECT.TemplateProperty( key, this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ], _data, this[ OBJECT.CONST.TEMPLATE.FIELD._ID ] );
                    }
                }
                else {  // Properties
                    this.properties[ key ] = new OBJECT.TemplateProperty( key, this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ], value, this[ OBJECT.CONST.TEMPLATE.FIELD._ID ] );
                }
        }
        
    },
    isEnabled                : function () {
        return this[ OBJECT.CONST.TEMPLATE.FIELD.ENABLED ];
    },
    setEnabled               : function ( to_set ) {
        if ( to_set === '0' ) {
            to_set = false;
        }
        to_set                                      = !!to_set;
        this[ OBJECT.CONST.TEMPLATE.FIELD.ENABLED ] = to_set;
        if ( !to_set ) {
            this.setStatus( OBJECT.CONST.TEMPLATE.STATUS.DISABLED );
        }
    },
    getName                  : function () {
        return this[ OBJECT.CONST.TEMPLATE.FIELD.NAME ];
    },
    getUuid                 : function () {
        return this[ OBJECT.CONST.TEMPLATE.FIELD.UUID ];
    },
    setUse                  : function ( to_set ) {
        this[ OBJECT.CONST.TEMPLATE.FIELD.USE ] = to_set.split( ',' );
    },
    isUsing                 : function ( template_name ) {
        return SHINKEN.TOOLS.ARRAY.contains( this[ OBJECT.CONST.TEMPLATE.FIELD.USE ], template_name );
    },
    isNew                   : function () {
        return !!this.is_new;
    },
    getType                 : function () {
        return this.item_type;
    },
    addCheck                : function ( to_add ) {
        this.checks.push( to_add );
        if ( to_add.is_dfe ) {
            this.size_dfe_check++;
        }
    },
    getValidCheck           : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.checks.length; i < _size_i; i++ ) {
            if ( !this.checks[ i ].is_obsolete ) {
                _to_return.push( this.checks[ i ] );
            }
        }
        return _to_return;
    },
    hasOverrideModulation   : function ( check_in_page_host, property_name ) {
        if ( !this.override ) {
            return false;
        }
        for ( var i = 0; i < this.override.size; i++ ) {
            if ( !this.override.overrides[ i ].is( check_in_page_host ) ) {
                continue;
            }
            if ( this.override.overrides[ i ].property !== property_name ) {
                continue;
            }
            switch ( this.override.overrides[ i ].value ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED;
                default:
                    return OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING;
            }
            break;
        }
        return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE;
    },
    getOverrideValue         : function ( prop_name, check_in_page_host ) {
        if ( !this.override || !check_in_page_host ) {
            return null;
        }
        return this.override.getOverrideValue( prop_name, check_in_page_host );
    },
    setStatus                : function ( to_set, parent_template ) {
        this.status = to_set;
        switch ( this.status ) {
            case  OBJECT.CONST.TEMPLATE.STATUS.USEFUL:
                this.status_tooltip = "";
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN:
                this.status_tooltip = _( 'element.tooltip_undefined' );
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.DISABLED:
                this.status_tooltip = _( 'element.tooltip_disabled' );
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.NEW:
                this.status_tooltip = _( 'element.tooltip_new' );
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.BADLOOP:
                if ( this[ OBJECT.CONST.TEMPLATE.FIELD.LOOP ] ) {
                    this.status_tooltip = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_loop' ), this[ OBJECT.CONST.TEMPLATE.FIELD.LOOP ].join( '  >>>  ' ) );
                }
                if ( !this.enabled ) {
                    this.status_tooltip += "<br>" + _( 'element.tooltip_disabled' );
                }
                break;
            case  OBJECT.CONST.TEMPLATE.STATUS.USELESS:
                this.status_tooltip = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_already_included' ), '<i><b>' + parent_template + '</b></i>' );
                break;
        }
    },
    isStatus                 : function ( to_test ) {
        return this.status === to_test;
    },
    completeTemplateWithUse  : function ( template_use ) {
        this.completePropertiesWithUse( template_use );
        this.completeDatasWithUse( template_use );
        this.completeOverrideWithUse( template_use );
    },
    completeDatasWithUse     : function ( template_use ) {
        var _current_key;
        var _current_data;
        
        var _datas = template_use.datas;
        var _keys  = Object.keys( _datas );
        var _size  = _keys.length;
        for ( var i = 0; i < _size; i++ ) {
            _current_key  = _keys[ i ];
            _current_data = _datas[ _current_key ];
            
            if ( this.datas[ _current_key ] ) {
                continue;
            }
            else {
                this.datas[ _current_key ] = _current_data;
            }
        }
        
        
    },
    completePropertiesWithUse: function ( template_use ) {
        var _current_key;
        var _current_property;
        
        var _properties = template_use.properties;
        var _keys       = Object.keys( _properties );
        var _size       = _keys.length;
        
        
        for ( var i = 0; i < _size; i++ ) {
            _current_key      = _keys[ i ];
            _current_property = _properties[ _current_key ];
            
            if ( !this.properties[ _current_key ] ) {
                this.properties[ _current_key ] = _current_property;
                this.properties[ _current_key ].setTemplateName( this.name, this._id );
                this.properties[ _current_key ].is_heritage_stopped = false;
            }
            else {
                this.properties[ _current_key ].updateValueWithUse( _current_property );
            }
        }
    },
    completeOverrideWithUse : function ( template_use ) {
        var _add;
        var _current_override;
        if ( !template_use.override ) {
            return;
        }
        if ( !this.override ) {
            this.override = template_use.override;
            return;
        }
        for ( var i = 0, _size_i = template_use.override.overrides.length; i < _size_i; i++ ) {
            _add              = true;
            _current_override = template_use.override.overrides[ i ];
            for ( var j = 0, _size_j = this.override.overrides.length; j < _size_j; j++ ) {
                if ( this.override.overrides[ j ].isOnSame( _current_override ) ) {
                    _add = false;
                }
            }
            if ( _add ) {
                this.override.overrides.push( _current_override );
                this.override.size = this.override.overrides.length;
            }
        }
    },
    getLink                 : function () {
        var _class = MANAGER.__instance_element_distributor.current_user.is_admin ? "shinken-link shinken-space" : "shinken-space";
        return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( this.item_type, this.uuid, this.getName(), _class ).outerHTML;
    },
    getProperty             : function ( key ) {
        return this.properties[ key ];
    }
};
PROPERTY.Boolean           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.Boolean.prototype = {
    init                         : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.state                     = null;
        this.component_radio_list      = new COMPONENT.RadioList( dom_element );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.checkErrorWarning();
    },
    ___clickOnRadioBtn           : function ( value ) {
        this.component_radio_list.clickOnRadioBtn( value );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
        this.updateView();
    },
    updateAllTemplatesCustomTags: function ( templates_properties ) {
        if ( !templates_properties ) {
            return;
        }
        var _size = templates_properties.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = templates_properties[ i ];
            if ( _current.value === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
                _current.label = this.default_label;
            }
            else if ( _current.value === "0" ) {
                _current.label = _( 'element.false' );
            }
            else if ( _current.value === "1" ) {
                _current.label = _( 'element.true' );
            }
        }
        
    },
    ___unset                     : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser             : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.DEFAULT_BUTTON_LABEL;
            }
        }
        switch ( value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.clickOnRadioBtn( null, value );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                this.clickOnRadioBtn( null, PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( !this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
            default:
                this.clickOnRadioBtn( null, value );
                break;
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    isDifferentValue             : function ( value1, value2 ) {
        if ( value1 === value2 ) {
            return false;
        }
        if ( value1 === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT && value2 === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            return false;
        }
        if ( value2 === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT && value1 === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            return false;
        }
        return true;
    },
    _computeBtnInheritance       : function () {
        var _value = this.component_radio_list.getValue();
        if ( _value === PROPERTY.CONST.DEFAULT_BUTTON_LABEL && this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
        else {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this._computeState();
    },
    _computeState                : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var is_default_on      = this.component_radio_list.isDefaultOn();
        if ( this.is_override ) {
            if ( this.component_radio_list.getRadioButton( PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE ).isOn() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
            else if ( is_default_on ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
        }
        else if ( this.is_mass_change ) {
            _to_set     = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    if ( this.component_radio_list.getValue() !== PROPERTY.CONST.DEFAULT_BUTTON_LABEL ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    }
                    break;
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else {
            if ( is_default_on && !this.component_btn_inheritance.isSet() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
            else if ( is_default_on ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
            }
        }
        this.setState( _to_set );
    },
    _computeInheritedLabel       : function ( inherited_value ) {
        switch ( inherited_value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                inherited_value = this.default_value;
                break;
            case "1":
                inherited_value = _( 'element.true' );
                break;
            case "0":
                inherited_value = _( 'element.false' );
                break;
            
        }
        return inherited_value;
    },
    updateWithTemplateSpecific   : function () {
        this.updateView();
    },
    ___updateView                : function () {
        switch ( this.getName() ) {
            case PROPERTY.CONST.NAME.SHELL_EXECUTION:
                var _status = this.component_radio_list.getValue() === '1' ? COMPONENT.CONST.TAG_INFORMATION.STATUS.IN_SHELL : COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE;
                this.tag_information.setStatus( _status );
                break;
            case PROPERTY.CONST.NAME.ENABLED:
                var _is_disabled = this.component_radio_list.getValue() === '0';
                if ( _is_disabled ) {
                    DOM.BodyService.getDomElement().classList.add( "shinken-current-element-is-disabled" );
                }
                else {
                    DOM.BodyService.getDomElement().classList.remove( "shinken-current-element-is-disabled" );
                }
                break;
        }
        this._computeLabelSelect();
        this.checkErrorWarning();
    },
    getDataToSaveFinal           : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Boolean, PROPERTY.Interface );
PROPERTY.CheckboxMulti           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.CheckboxMulti.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_checkbox_read     = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.READ + '"]' ) );
        this.component_checkbox_create   = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.CREATE + '"]' ) );
        this.component_checkbox_organize = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE + '"]' ) );
        this.component_checkbox_modify   = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.MODIFY + '"]' ) );
        this.component_checkbox_delete   = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.DELETE + '"]' ) );
        this.component_checkbox_all      = new COMPONENT.Checkbox( dom_element.querySelector( '.shinken-cell-checkbox-container[data-name="' + PROPERTY.CONST.ACL_MULTI.NAME.ALL + '"]' ) );
        this.component_btn_default       = new COMPONENT.Button( dom_element.querySelector( ".shinken-btn-default-cell .shinken-radio-btn" ) );
        this.component_btn_inheritance   = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.checkErrorWarning();
    },
    checkErrorWarning         : function () {
    },
    askComputeAfterChange     : function () {
        this.setStateInheritance( false );
        this.component_checkbox.setChecked();
        this._computeState();
    },
    ___clickOnRadioBtn           : function () {
        var _is_on = this.component_btn_default.isOn();
        if ( _is_on ) {
            return;
        }
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', COMPONENT.CONST.BTN_STATE.ON );  //UTILE ??
        this._computeState();
    },
    ___clickOnCheckboxInput      : function ( name ) {
        var _current;
        switch ( name ) {
            case PROPERTY.CONST.ACL_MULTI.NAME.READ:
                _current = this.component_checkbox_read;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.CREATE:
                _current = this.component_checkbox_create;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE:
                _current = this.component_checkbox_organize;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.MODIFY:
                _current = this.component_checkbox_modify;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.DELETE:
                _current = this.component_checkbox_delete;
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.ALL:
                _current = this.component_checkbox_all;
                break;
            
        }
        var _value = !_current.isCheckedUser();
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                _value = !_current.isCheckedDefault();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( !this.component_btn_inheritance.isSet() ) {
                    _value = !_current.isCheckedDefault();
                }
                else {
                    _value = !_current.isCheckedInheritance();
                }
                break;
        }
        _current.setCheckedUser( _value );
        this.synchronizeAfterClick( name, _current );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
    },
    synchronizeAfterClick     : function ( name, checkbox ) {
        switch ( name ) {
            case PROPERTY.CONST.ACL_MULTI.NAME.READ:
                if ( !checkbox.isCheckedUser() ) {
                    this.component_checkbox_create.setCheckedUser( false );
                    this.component_checkbox_organize.setCheckedUser( false );
                    this.component_checkbox_modify.setCheckedUser( false );
                    this.component_checkbox_delete.setCheckedUser( false );
                    this.component_checkbox_all.setCheckedUser( false );
                }
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.CREATE:
            case PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE:
            case PROPERTY.CONST.ACL_MULTI.NAME.MODIFY:
            case PROPERTY.CONST.ACL_MULTI.NAME.DELETE:
                if ( checkbox.isCheckedUser() ) {
                    this.component_checkbox_read.setCheckedUser( true );
                }
                else {
                    this.component_checkbox_all.setCheckedUser( false );
                }
                break;
            case PROPERTY.CONST.ACL_MULTI.NAME.ALL:
                var _value = checkbox.isCheckedUser();
                this.component_checkbox_read.setCheckedUser( _value );
                this.component_checkbox_create.setCheckedUser( _value );
                this.component_checkbox_organize.setCheckedUser( _value );
                this.component_checkbox_modify.setCheckedUser( _value );
                this.component_checkbox_delete.setCheckedUser( _value );
                break;
            
        }
    },
    _computeBtnInheritance    : function () {
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_SET ){
            return;
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT ){
            if ( this.component_btn_inheritance.isSet() ){
                return;
            }
        }
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    computeInheritanceCheckbox: function () {
        var _splitted = this.inherited_value.split( ',' );
        for ( var i = 0, _size = _splitted.length; i < _size; i++ ) {
            switch ( _splitted[i] ) {
                case PROPERTY.CONST.ACL_MULTI.NAME.READ:
                    this.component_checkbox_read.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.CREATE:
                    this.component_checkbox_create.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.ORGANIZE:
                    this.component_checkbox_organize.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.MODIFY:
                    this.component_checkbox_modify.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.DELETE:
                    this.component_checkbox_delete.setCheckedInheritance( true );
                    break;
                case PROPERTY.CONST.ACL_MULTI.NAME.ALL:
                    this.component_checkbox_read.setCheckedInheritance( true );
                    this.component_checkbox_create.setCheckedInheritance( true );
                    this.component_checkbox_organize.setCheckedInheritance( true );
                    this.component_checkbox_modify.setCheckedInheritance( true );
                    this.component_checkbox_delete.setCheckedInheritance( true );
                    this.component_checkbox_all.setCheckedInheritance( true );
                    break;
            }
        }
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    if ( this.component_btn_default.isOn() ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    }
                    break;
                default:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
            }
        }
        else if ( this.component_btn_default.isOn() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
    },
    updateWithTemplateSpecific: function () {
        this._computeState();
    },
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    ___unset                  : function () {
        this.___clickOnRadioBtn( '' );
        this._computeState();
    },
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : '';
        }
        var _to_return = '';
        _to_return += this.component_checkbox_delete.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_modify.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_organize.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_create.isCheckedUser() ? '1' : '0';
        _to_return += this.component_checkbox_read.isCheckedUser() ? '1' : '0';
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype(PROPERTY.CheckboxMulti ,PROPERTY.Interface);
PROPERTY.CheckboxSample           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.CheckboxSample.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_checkbox        = new COMPONENT.Checkbox( dom_element.querySelector( ".shinken-cell-checkbox-container" ) );
        this.component_btn_default     = new COMPONENT.Button( dom_element.querySelector( ".shinken-btn-default-cell .shinken-radio-btn" ) );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.initSpecific();
    },
    initSpecific              : function ( dom_element ) {
        switch ( this.name ) {
            case PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE:
                this.getCounterWarning().setTooltip( _( 'element.warning_show_history_range_and_hide_history' ), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                break;
            case PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE:
                this.getCounterWarning().setTooltip( _( 'element.warning_show_sla_range_and_hide_sla' ), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                break;
        }
    },
    computeErrorsSpecifics    : function () {
        switch ( this.name ) {
            case PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE:
                var _value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ).getFlatValue();
                if ( _value === PROPERTY.CONST.ACL_TYPE.SLA ) {
                    if ( this.isFlatValueOn() ) {
                        this.counter_temp_warning = 1;
                        break;
                    }
                }
                break;
            case PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE:
                var _value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY ).getFlatValue();
                if ( _value === PROPERTY.CONST.ACL_TYPE.HISTORY ) {
                    if ( this.isFlatValueOn() ) {
                        this.counter_temp_warning = 1;
                        break;
                    }
                }
                break;
        }
    },
    askComputeAfterChange     : function () {
        this.setStateInheritance( false );
        this.component_checkbox.setCheckedUser();
        this._computeState();
    },
    ___clickOnRadioBtn        : function () {
        if ( this.component_btn_default.isOn() ) {
            return;
        }
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', COMPONENT.CONST.BTN_STATE.ON );  //UTILE ??
        this._computeState();
    },
    ___clickOnCheckboxInput   : function () {
        var _value = !this.component_checkbox.isCheckedUser();
        if ( !this.is_mass_change ) {
            switch ( this.state ) {
                case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    _value = !this.component_checkbox.isCheckedDefault();
                    break;
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    _value = this.component_btn_inheritance.isSet() ? !this.component_checkbox.isCheckedInheritance() : !this.component_checkbox.isCheckedDefault();
                    break;
            }
        }
        this.component_checkbox.setCheckedUser( _value );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
    },
    synchronizeAtMaximum      : function ( property, force ) {
        if ( this.is_mass_change && !force ) {
            return this.synchronizeAtMassChange( property, true );
        }
        if ( property.isFlatValueOn() ) {
            return;
        }
        switch ( property.getName() ) {
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                var _value = property.getFlatValue();
                switch ( _value ) {
                    case PROPERTY.CONST.ACL_TYPE.HISTORY:
                        if ( this.name === PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE && this.isFlatValueOn() ) {
                            this.setValueFromUser( '0' );
                        }
                        break;
                    case PROPERTY.CONST.ACL_TYPE.SLA:
                        if ( this.name === PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE && this.isFlatValueOn() ) {
                            this.setValueFromUser( '0' );
                        }
                        break;
                }
                break;
            default:
                switch ( property.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.NONE:
                        if ( property.default_value === '1' ) {
                            return;
                        }
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        if ( property.inherited_value === '1' ) {
                            return;
                        }
                        break;
                    default:
                        if ( property.type === PROPERTY.CONST.TYPES.CHECKBOX_SINGLE && property.component_checkbox.isCheckedUser() ) {
                            return;
                        }
                }
                this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_checkbox.setCheckedUser( false );
                this._computeState();
                break;
        }
        this.checkErrorWarning();
    },
    synchronizeAtMinimum      : function ( property, force ) {
        if ( this.is_mass_change && !force ) {
            return this.synchronizeAtMassChange( property, false );
        }
        if ( this.isFlatValueOn() ) {
            return;
        }
        switch ( property.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.NONE:
                if ( property.default_value === '0' ) {
                    return;
                }
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( property.inherited_value === '0' ) {
                    return;
                }
                break;
            default:
                if ( !property.component_checkbox.isCheckedUser() && !property.component_checkbox.isCheckedDefault() ) {
                    return;
                }
        }
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        this.component_checkbox.setCheckedUser( true );
        this._computeState();
        this.checkErrorWarning();
    },
    synchronizeAtMassChange   : function ( property, is_max ) {
        var _action_property = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        var _action_this     = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        if ( property.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
            return;
        }
        var _to_set = false;
        switch ( property.getName() ) {
            case PROPERTY.CONST.NAME.CAN_SUBMIT_COMMANDS:
            case PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME:
            case PROPERTY.CONST.NAME.ACL_MAKE_ACKNOWLEDGE:
            case PROPERTY.CONST.NAME.ACL_FORCE_RESULT_CHECK:
            case PROPERTY.CONST.NAME.ACL_FORCE_RETRY_CHECK:
                if ( is_max ) {
                    if ( !property.component_checkbox.isCheckedUser() ) {
                        _to_set = "0";
                    }
                }
                else {
                    if ( property.component_checkbox.isCheckedUser() ) {
                        _to_set = "1";
                    }
                }
                break;
            case PROPERTY.CONST.NAME.ACL_IN_TAB_HISTORY:
                switch ( property.getValue() ) {
                    case PROPERTY.CONST.ACL_TYPE.HISTORY:
                        if ( this.getName() === PROPERTY.CONST.NAME.ACL_SHOW_SLA_RANGE ) {
                            _to_set = "0";
                        }
                        break;
                    case PROPERTY.CONST.ACL_TYPE.SLA:
                        if ( this.getName() === PROPERTY.CONST.NAME.ACL_SHOW_HISTORY_RANGE ) {
                            _to_set = "0";
                        }
                        break;
                }
                break;
        }
        if ( _to_set ) {
            if ( _action_property !== _action_this ) {
                this.clickOnItemSelector( _action_property, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
            }
            this.setValueFromUser( _to_set );
        }
    },
    ___unset                  : function () {
        this.setValueFromUser( '' );
        if ( this.is_mass_change ) {
            this.component_checkbox.setCheckedUser( '0' );
        }
    },
    setValueFromUser          : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = PROPERTY.CONST.DEFAULT_BUTTON_LABEL;
            }
        }
        switch ( value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                this.clickOnRadioBtn( null, PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( !this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
            case "0":
            case "1":
                this.component_checkbox.setCheckedUser( value );
                this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
                this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
                
                break;
        }
        this._computeState();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    _computeBtnInheritance    : function () {
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                this.component_checkbox.setCheckedInheritance( this.inherited_value );
            }
            else {
                this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        this.setStateInheritance( this.state_inheritance );
        if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    if ( this.component_btn_default.isOn() ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    }
                    break;
                default:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
            }
        }
        else if ( this.component_btn_default.isOn() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    _computeInheritedLabel    : function ( inherited_value ) {
        var _to_return;
        if ( inherited_value === '1' ) {
            _to_return = _( "element.true" );
        }
        else {
            _to_return = _( "element.false" );
        }
        return _to_return;
    },
    updateWithTemplateSpecific: function () {
        this._computeState();
        this._computeInheritedLabel();
    },
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    isFlatValueOn             : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return this.component_checkbox.isCheckedDefault();
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                if ( this.component_btn_inheritance.isSet() ) {
                    return this.component_checkbox.isCheckedInheritance();
                }
                return this.component_checkbox.isCheckedDefault();
        }
        return this.component_checkbox.isCheckedUser();
    },
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : '';
        }
        var _to_return = this.component_checkbox.isCheckedUser() ? '1' : '0';
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.CheckboxSample, PROPERTY.Interface );
PROPERTY.Data = function ( key, value, group_data ) {
    this.value = value;
    switch ( this.value ) {
        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            this.value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            this.custom_selected = PROPERTY.CONST.CUSTOM_SELECT.NONE;
            break;
    }
    this.inherited_data = null;
    this.type           = PROPERTY.CONST.TYPES.DATA;
    this.is_valid       = true;
    this.status         = PROPERTY.CONST.DATA.STATUS.NONE;
    this.setGroupData( group_data );
    this.setName( key );
    this.buildUUID();
    this._computeIsValid();
    this.init_done = false;
};
PROPERTY.Data.prototype = {
    init                       : function () {
        this.initCounters();
        this.tab_parent_name = WINDOW.CONST.ELEMENT.DATAS;
        this.tab_parent_id   = "id-shinken-window-datas-target";
        this._initDomElements();
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, this.dom_element, this.type );
        this._computeLabelBtnInheritance( this.inherited_data );
        this._computeValuePlaceholder();
        this.component_btn_inheritance.askUpdateHTML();
        this._finalyseErrorWarning();
        this._computeState();
        if ( this.isDfeData() && this.state_inheritance && !this.getActiveInput().original_value ) {
            this.getActiveInput().original_value = this.getValueInherited();
        }
        this.getCounterTotal().update( this.uuid, 1, "", true, true );
        this.init_done = true;
    },
    initWithDomElement         : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.buildUUID();
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, this.dom_element, this.type );
        var _text_area                 = this.dom_element.querySelector( "textarea.shinken-input" );
        if ( _text_area ) {
            this.component_input = new COMPONENT.Input( _text_area, this, true );
        }
        var _input = this.dom_element.querySelector( "input.shinken-input" );
        if ( _input ) {
            this.component_input_protected = new COMPONENT.Input( _input, this, true );
            this.component_input_protected.setIsProtected( true );
        }
        this._computeLabel();
        this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.label ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
        this._computeState();
        this._finalyseErrorWarning();
        this.getCounterTotal().update( this.uuid, 1, "", true, true );
        this.init_done = true;
    },
    doActionAfterChange        : function ( args ) {
        var _input_name = args[ 'input_name' ];
        switch ( _input_name ) {
            case "key":
                var _old_name = this.name;
                this.setLabel( this.component_input_key.getValue() );
                this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.label ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
                MANAGER.__instance_macro_distributor.renamedMacro( _old_name, this.name, this.getValue() );
                this.checkErrorWarning();
                if ( this.is_mass_change ) {
                    CONTROLLER.MassChange.ChangeDataName( this );
                }
                MANAGER.ListenerEventManager.askAfterActionProperty( this );
                break;
            case "value":
                if ( args[ 'validation_done' ] ) {
                    this.setStateInheritance( !this.getValue() );
                }
                if ( this.is_protected ) {
                    if ( this.is_mass_change ) {
                        this.setIsProtected( this.getValue() ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED : PROPERTY.CONST.PROTECTED_STATUS.PROTECTED );
                    }
                    else {
                        this.setIsProtected( PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED );
                    }
                }
                this._computeState();
                if ( !this.is_mass_change ) {
                    MANAGER.__instance_macro_distributor.changeMacro( this, this.getValue() );
                }
                break;
        }
        fire_element_is_modifie();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    askComputeAfterChange      : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.getActiveInput().askComputeAfterChange( dom_element, this, { 'input_name': 'value' } );
    },
    askComputeKeyAfterChange   : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input_key.askComputeAfterChange( dom_element, this, { 'input_name': 'key' } );
    },
    clickOnBtnInheritance      : function () {
        this.setStateInheritance( !this.state_inheritance );
        this._computeState();
        this.updateView();
        MANAGER.__instance_macro_distributor.changeMacro( this, this.state_inheritance ? this.getValueInherited() : this.getValue() );
    },
    delete                     : function () {
        delete MANAGER.__instance_property_distributor.elements[ this.is_override ? this.name : this.uuid ];
        DOM.Service.removeElement( this.dom_element );
        MANAGER.__instance_macro_distributor.deleteMacroContent( this.name );
        if ( this.is_mass_change ) {
            CONTROLLER.MassChange.removeData( this );
            this.is_mass_change_deleted = true;
        }
        else {
            App.Elements.ChecksTab.askInit( { data_change: true, property: this } );
        }
        this.resetCounters();
        MANAGER.ListenerEventManager.afterActionGlobal( this );
        fire_element_is_modifie();
    },
    onFocus                    : function () {
        if ( this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated() ) {
            this.getActiveInput().dom_element.value = "";
        }
    },
    ___onFocusOut              : function () {
        var self = this;
        setTimeout( function () {
            if ( self.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED ) {
                self.getActiveInput().dom_element.value = self.getActiveInput().original_value;
            }
        }, 500 );
    },
    isLocalData                : function () {
        if ( !this.group_data ) {
            return false;
        }
        return this.group_data.type === PROPERTY.CONST.DATA.GROUP.LOCALE;
    },
    isDfeData                  : function () {
        if ( !this.group_data ) {
            return false;
        }
        return this.group_data.type === PROPERTY.CONST.DATA.GROUP.DFE;
    },
    setGroupData               : function ( to_set ) {
        if ( this.isLocalData() && to_set.type !== PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            delete MANAGER.__instance_property_distributor.elements[ this.uuid ];
            this.uuid   = this.name;
            this.status = PROPERTY.CONST.DATA.STATUS.NONE;
            MANAGER.__instance_property_distributor.setElement( this.uuid, this );
        }
        if ( this.isDfeData() ) {
            return;
        }
        this.group_data = to_set;
        if ( this.group_data ) {
            this.group_data_uuid = this.group_data.uuid;
        }
    },
    setName                    : function ( to_set ) {
        this.name = to_set;
        if ( this.name ) {
            this._computeLabel();
        }
        this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.label ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
    },
    getLabel                   : function () {
        return this.label;
    },
    setLabel                   : function ( to_set ) {
        this.label = SHINKEN.TOOLS.STRING.toUpperCase( to_set );
        if ( !this.is_override ) {
            this.name = PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL + this.label;
        }
    },
    setStatus                  : function ( to_set ) {
        this.status = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'status', this.status );
        }
    },
    getValueInherited          : function () {
        if ( !this.inherited_data ) {
            return "";
        }
        return SHINKEN.TOOLS.STRING.unescape_xss( this.inherited_data.value );
    },
    getFlatValue               : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.component_btn_inheritance.isSet() ? this.getValueInherited() : '';
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                return this.getValue();
        }
    },
    setInheritedData           : function ( to_set ) {
        this.inherited_data = to_set;
    },
    isProtected                : function () {
        return !!this.is_protected;
    },
    setIsProtected             : function ( to_set ) {
        this.is_protected = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'isProtected', this.is_protected );
        }
    },
    getActiveInput             : function () {
        if ( this.is_protected ) {
            return this.component_input_protected;
        }
        return this.component_input;
    },
    getParentName              : function () {
        return this.isLocalData() ? this.uuid : this.name;
    },
    getNameOrUUID              : function () {
        return this.uuid;
    },
    _computeBtnInheritance     : function () {
        if ( this.state_inheritance !== undefined ) {
            return;
        }
        var _value = this.getValue();
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            _value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        this.setStateInheritance( !_value );
        this.updateView();
    },
    _computeState              : function () {
        this._computeBtnInheritance();
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_override ) {
            if ( this.getValue() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.getValue() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            if ( this.is_mass_change ) {
                switch ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY_DATA:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY_DATA_OVERRIDE:
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                        break;
                }
            }
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    _computeLabel              : function () {
        var _name = this.is_override ? this.override_prop_name : this.name;
        if ( SHINKEN.TOOLS.STRING.startsWith( _name, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
            this.setLabel( _name.substr( 1 ) );
        }
        else {
            this.setLabel( _name );
        }
    },
    _computeValuePlaceholder   : function () {
        var _label = '';
        if ( this.inherited_data ) {
            if ( this.is_protected ) {
                _label = SHINKEN.TOOLS.ENCRYPTION.getLabelHidden();
            }
            else {
                _label = this.getValueInherited();
                if ( _label === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    _label = _( 'element.forced_default' );
                }
                _label += ' [ ' + _( 'element.in_template' ) + ' ' + this.inherited_data.template_name + ' ]';
            }
        }
        if ( _label ) {
            this.getActiveInput().setPlaceholder( _label );
        }
    },
    _computeLabelBtnInheritance: function ( inherited_data ) {
        if ( !inherited_data ) {
            return false;
        }
        inherited_data.is_protected = this.is_protected;
        if ( this.is_protected ) {
            inherited_data.label = SHINKEN.TOOLS.ENCRYPTION.getDefaultSpanLabel();
        }
        return this.component_btn_inheritance.setTemplateProperty( inherited_data );
    },
    _computeIsValid            : function () {
        switch ( this.name ) {
            case '_id':
            case '_ID':
            case '_SYNC_KEYS':
            case '__SYNC_IDX__':
            case '_SE_UUID':
            case '_SE_UUID_HASH':
                this.is_valid = false;
        }
    },
    _initDomElements           : function () {
        this.selectors = {};
        var _template  = this.getTemplateHTML().outerHTML;
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$label", this.label );
        _template      = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$value", this.value );
        var _to_return = DOM.Service.createElement( "tbody", {}, _template );
        
        this.dom_element = _to_return.firstChild;
        this.dom_element.classList.add( PROPERTY.CONST.CLASS.SKINKEN_LINE );
        this.dom_element.classList.add( "shinken-parent-event-listener" );
        if ( !this.isLocalData() && !this.is_mass_change ) {
            this.dom_element.classList.add( "shinken-hidden" );
        }
        else {
            this.dom_element.classList.remove( "shinken-hidden" );
        }
        
        if ( MANAGER.__instance_element_distributor.current_element.work_area_status === OBJECT.CONST.ELEMENT.WORK_AREA_STATUS.PROPOSED
             || MANAGER.__instance_element_distributor.current_element.editable === "0" ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        
        this.dom_element.dataset.status    = this.status;
        this.dom_element.dataset.name      = this.uuid;
        this.dom_element.dataset.groupType = this.group_data.type;
        this._computeIsEditableKey();
        this.dom_element.dataset.isProtected = this.is_protected;
        this.dom_element.removeAttribute( 'id' );
        this.component_input_key = new COMPONENT.Input( this.dom_element.querySelector( ".shinken-input-key" ), this, true );
        this.component_input_key.setValidationRules( [PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DATA, PROPERTY.CONST.VALIDATOR.TYPE.NO_INVISIBLE_CHAR], COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS );
        this.component_input = new COMPONENT.Input( this.dom_element.querySelector( "textarea.shinken-input" ), this, true );
        this.component_input.setValidationRules( [PROPERTY.CONST.VALIDATOR.TYPE.NO_INVISIBLE_CHAR], COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS );
        this.component_input_protected = new COMPONENT.Input( this.dom_element.querySelector( "input.shinken-input" ), this, true );
        this.component_input_protected.setIsProtected( true );
        if ( this.modified_value_before_prop_use_modification ) {
            this.component_input.dom_element.value = this.modified_value_before_prop_use_modification;
            this.component_input.setValue();
            this.modified_value_before_prop_use_modification = "";
        }
        if ( this.isDfeData() ) {
            this.buildHtmlCheckDfe();
        }
        if ( this.is_mass_change ) {
            this.setMassChange( true );
        }
    },
    _computeIsEditableKey      : function () {
        this.is_editable_key = true;
        if ( this.group_data.type !== PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            this.is_editable_key = false;
        }
        else if ( this.is_protected ) {
            this.is_editable_key = false;
        }
        this.dom_element.dataset.editableKey = this.is_editable_key;
    },
    buildUUID                  : function () {
        if ( !this.group_data || (this.group_data.type !== PROPERTY.CONST.DATA.GROUP.LOCALE && this.group_data.type !== CONTROLLER.CONST.MASS_CHANGE.NAME) ) {
            this.uuid = this.name;
        }
        else {
            this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        }
    },
    ___unset                   : function () {
        this.setValueFromUser( "" );
        if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    this.getActiveInput().setPlaceholder();
                    break;
                default:
                    this.getActiveInput().setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                    break;
            }
        }
    },
    setKeyValueFromUser        : function ( value ) {
        this.component_input_key.setValueFromJs( value );
        this.askComputeKeyAfterChange();
        this._computeState();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    setValueFromUser           : function ( value ) {
        this.getActiveInput().setValueFromJs( value );
        this.askComputeAfterChange();
        this._computeState();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    computeErrorsSpecifics     : function () {
        this.validateValueInput();
    },
    validateValueInput         : function () {
        var _to_set;
        if ( this.is_override ) {
            _to_set = COMPONENT.CONST.STATUS.NONE;
            if ( this.dom_element.classList.contains( 'shinken-disabled-and-unknown' ) ) {
                if ( !this.dom_element.classList.contains( 'inherit-service-override' ) || this.state === PROPERTY.CONST.STATE_PROPERTY.OVERRIDE ) {
                    _to_set = COMPONENT.CONST.STATUS.WARNING;
                    this.getActiveInput().getCounterWarning().update( this.getActiveInput().uuid, 1 );
                    this.getActiveInput().addShinkenTooltip( _to_set, _( 'element.cannot_edit_invalid_overriden_data' ) );
                }
            }
            this.getActiveInput().setStatus( _to_set );
        }
        else {
            if ( this.isDfeData() ) {
                this.getActiveInput().setStatus( COMPONENT.CONST.STATUS.NONE );
                var _value = this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ? this.getValueInherited() : this.getValue();
                if ( !_value && this.is_mass_change ) {
                    return;
                }
                App.DFE._duplicateSplittedValue[ this.name ] = App.DFE.validatorDFE( App.DFE.splitDFE( this.name, _value ) );
                var _message                                 = App.DFE.setOutputDFE( App.DFE._duplicateSplittedValue[ this.name ], this.name, this.group_data.label );
                _message.is_dfe                              = true;
                _message.is_dfe_protected                    = this.is_protected;
                if ( this.getActiveInput().original_value && this.getFlatValue() !== this.getActiveInput().original_value ) {
                    var _messages_deleted = App.DFE.getMessageDeletedElements( App.DFE._duplicateSplittedValue[ this.name ]._dfe_elem,
                        App.DFE.validatorDFE( App.DFE.splitDFE( this.name, this.getActiveInput().original_value ) )._dfe_elem, this.list_check_link );
                    if ( _messages_deleted ) {
                        _message.property_name = this.name;
                        _message.addMessages( _messages_deleted );
                        _message.footer = _( 'element.tooltip_dfe_deleted_part_2' );
                    }
                }
                if ( this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON ) {
                    var _status      = _message.getStatus();
                    var _parent_name = true;
                    if ( this.component_btn_inheritance.list_template_property ) {
                        _parent_name = this.component_btn_inheritance.list_template_property.template_name;
                    }
                    this.setInheritanceStatus( _status, _message.buildMessage( false, _parent_name ) );
                    this.getActiveInput().setMessage( _message );
                }
                else {
                    this.setInheritanceStatus( "", "" );
                    this.getActiveInput().setMessage( _message );
                }
            }
            if ( !this.is_mass_change ) {
                App.Elements.ChecksTab.askInit( { data_change: true, property: this } );
            }
        }
    },
    
    getTemplateHTML  : function () {
        if ( !PROPERTY.CONST.data_template_html || SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            PROPERTY.CONST.data_template_html = document.getElementById( 'shinken-element-property-line-data-template' );
        }
        return PROPERTY.CONST.data_template_html;
    },
    mouseEnter       : function ( event ) {
        if ( !this.getLabel() ) {
            return;
        }
        MANAGER.HelpManager.setActive( this.name, this.getLabel(), this.isDfeData() ? 'element.tooltip_dfe_common' : 'element.help_text_data' );
        if ( this.is_mass_change ) {
            this.mouseEnterInOption( event );
        }
    },
    ___updateView    : function () {
        this.getActiveInput().updateView( this.state_inheritance, true, false, this.component_btn_inheritance.isSet() );
        this.computeErrorsSpecifics();
    },
    buildHtmlCheckDfe: function () {
        var _checks_dfe       = MANAGER.__instance_element_distributor.getAllChecksDFE();
        var _checks_candidate = SHINKEN.TOOLS.ARRAY.filterWith( _checks_dfe, PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME, this.name );
        var _size             = _checks_dfe.length;
        var _size_candidate   = _checks_candidate.length;
        
        var counter          = this._drawCounter( _size_candidate, _size );
        var label            = (_size_candidate > 1) ? _( 'element.used_by_checks' ) : _( 'element.used_by_check' );
        var columnUsedHead   = '<p style="padding-left: 8px;">' + label + counter + '</p>';
        var counter_unused   = this._drawCounter( _size - _size_candidate, _size );
        var label_unused     = (_size - _size_candidate > 1) ? _( 'element.unused_by_checks' ) : _( 'element.unused_by_check' );
        var columnUnusedHead = (_size - _size_candidate) ? '<p style="padding-left: 8px; ">' + label_unused + counter_unused + '</p>' : '';
        
        var columnUsedContent   = '';
        var columnUnusedContent = '';
        var current_check;
        
        this.list_check_link = []; // Use for compute the warning message of deleted DFE checks when user change DFE data value
        for ( var i = 0; i < _size; i++ ) {
            current_check = _checks_dfe[ i ];
            var _label    = "";
            if ( !current_check.isEnabled() ) {
                _label = current_check.getName() + "<span class='shinken-warning'>" + _( "element.disabled" ) + "</span>";
            }
            if ( current_check[ PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME ] === this.name ) {
                this.list_check_link.push( current_check.uuid );
                columnUsedContent += SHINKEN.TOOLS.buildLinkShinkenElement( current_check, _label, 'shinken-tag-check hide-if-collapse shinken-space' ).outerHTML;
            }
            else {
                columnUnusedContent += SHINKEN.TOOLS.buildLinkShinkenElement( current_check, _label, 'shinken-tag-check hide-if-collapse shinken-space' ).outerHTML;
            }
        }
        
        var _to_return = DOM.Service.createElement( "tr", { class: 'shinken-data-dfe-list-check-container shinken-collapse', onclick: 'MANAGER.EventManager.clickDataCollapseButton(this)' } );
        var _cell_1    = DOM.Service.createElement( "td", { class: 'shinken-data-dfe-list-check-used' }, columnUsedHead + columnUsedContent );
        var _cell_2    = DOM.Service.createElement( "td", { class: 'shinken-data-dfe-list-check-unused' }, columnUnusedHead + columnUnusedContent );
        var _cell_3    = DOM.Service.createElement( "td", { class: 'shinken-data-dfe-list-check-collapse' }, '<span class="shinken-dfe-collapse-btn"><span class="icon-white icon-plus-sign show-if-collapse"></span><span class="icon-white icon-minus-sign hide-if-collapse"></span></span>' );
        _to_return.appendChild( _cell_1 );
        _to_return.appendChild( _cell_2 );
        _to_return.appendChild( _cell_3 );
        
        this.dom_element.querySelector( '.shinken-element-property-line-data-table' ).appendChild( _to_return );
    },
    
    _drawCounter      : function ( value, total, className ) {
        className = (className) ? className : 'badge data-counter-active';
        var s     = '';
        if ( value != 0 ) {
            s = ' [ <span class="' + className + '">' + value + '</span> /' + total + ' ]';
        }
        else {
            s = ' [ ' + total + ' ]';
        }
        return s;
    },
    setCollapseCheck  : function ( to_set ) {
        var _element = this.dom_element.querySelector( '.shinken-data-dfe-list-check-container' );
        if ( !_element ) {
            return;
        }
        if ( to_set ) {
            _element.classList.add( 'shinken-collapse' );
            _element.classList.remove( 'shinken-not-collapse' );
        }
        else {
            _element.classList.remove( 'shinken-collapse' );
            _element.classList.add( 'shinken-not-collapse' );
        }
    },
    getValue          : function () {
        return this.getActiveInput().getValue();
    },
    getDataToSaveFinal: function () {
        if ( !this.is_valid ) {
            return "";
        }
        if ( this.name === PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) {
            return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : '';
        }
        var _to_return = this.getValue();
        if ( this.is_mass_change && this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED ) {
            _to_return = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
        }
        else if ( this.is_mass_change && !_to_return ) {
            _to_return = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
        }
        else if ( _to_return === "" && this.component_btn_inheritance.isSet() ) {
            _to_return = PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        if ( this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED_MODIFIED && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated() ) {
            return SHINKEN.TOOLS.STRING.b64Encode( _to_return );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Data, PROPERTY.Interface );
PROPERTY.MultiLine           = function ( dom_element ) {
    this.init( dom_element );
    this.timeout_ask_compute_after_change;
};
PROPERTY.MultiLine.prototype = {
    init                              : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.dom_template              = this.dom_element.querySelector( '.shinken-multi-line-object-template' );
        this.dom_container             = this.dom_element.querySelector( '.shinken-multi-line-object-container' );
        this.dom_output_cfg            = this.dom_element.querySelector( '.shinken-multi-line-object-stringify-result' );
        this.dom_cfg_inherited_label   = this.dom_element.querySelector( '.shinken-cfg-inherited-label-container' );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.getParentName(), dom_element, this.type );
        this.separator_line_saved      = dom_element.dataset.separatorLineSaved;
        this.separator_key_value_saved = dom_element.dataset.separatorKeyValueSaved;
        this.separator_line_html       = dom_element.dataset.separatorLineHtml;
        this.separator_key_value_html  = dom_element.dataset.separatorKeyValueHtml;
        this.line_type                 = dom_element.dataset.lineType;
        this.is_set                    = dom_element.dataset.isSet === "true";
        if ( this.line_type === PROPERTY.CONST.NAME.PERIOD_DAY_NAME ) {
            this.component_input = new COMPONENT.Input( dom_element.querySelector( ".shinken-prop-cell-action .shinken-input" ), this );
        }
        this.initLines();
        var self = this;
        setTimeout( function (  ) {
            self.checkErrorWarning();
        }, 400 )
    },
    initLines                         : function () {
        this.lines_object          = [];
        this.lines_object_mapping  = {};
        var _existing_line_objects = this.dom_container.querySelectorAll( '.shinken-multi-line-object-row' );
        for ( var i = 0, _size_i = _existing_line_objects.length; i < _size_i; i++ ) {
            var _new_line_object;
            switch ( this.line_type ) {
                case PROPERTY.CONST.NAME.OUTPUT_RULES:
                    _new_line_object = new COMPONENT.OutputRule( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
                case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                    _new_line_object = new COMPONENT.UrlLine( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
                case PROPERTY.CONST.NAME.PERIOD_ADVANCED_NAME:
                    _new_line_object = new COMPONENT.KeyValueLine( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
                case PROPERTY.CONST.NAME.PERIOD_DAY_NAME:
                    _new_line_object = new COMPONENT.TimePeriodDayLine( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
            }
            var _index                                         = this.lines_object.push( _new_line_object );
            this.lines_object_mapping[ _new_line_object.uuid ] = _index - 1;
        }
        this.computeValue();
    },
    rebuildMapping                    : function () {
        this.lines_object_mapping = {};
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            this.lines_object_mapping[ this.lines_object[ i ].uuid ] = i;
        }
    },
    clickOnAddLine                    : function () {
        var _to_add = DOM.Service.cloneElement( this.dom_template, { class: "shinken-multi-line-object-row" } );
        this.dom_container.appendChild( _to_add );
        var _new_line;
        switch ( this.line_type ) {
            case PROPERTY.CONST.NAME.OUTPUT_RULES:
                _new_line = new COMPONENT.OutputRule( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
            case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                _new_line = new COMPONENT.UrlLine( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
            case PROPERTY.CONST.NAME.PERIOD_ADVANCED_NAME:
                _new_line = new COMPONENT.KeyValueLine( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
            case PROPERTY.CONST.NAME.PERIOD_DAY_NAME:
                _new_line = new COMPONENT.TimePeriodDayLine( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
        }
        var _index                                  = this.lines_object.push( _new_line );
        this.lines_object_mapping[ _new_line.uuid ] = _index - 1;
        this.setStateInheritance( !this.lines_object.length );
        this.computeValue();
        this.askCheckErrorWarning();
        return _new_line;
    },
    ___clickOnItemSelector            : function ( target_component, key_name, element ) {
        target_component.___clickOnItemSelector( key_name, element );
        this.computeValue();
    },
    askComputeAfterChange             : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( dom_element.classList.contains( 'shinken-is-main-input' ) ) {
            this.askComputeAfterChangeMainInput();
        }
        else {
            var _line_object = this.getLineObjectViaChildrenElement( dom_element );
            _line_object.askComputeAfterChange( dom_element, this );
        }
    },
    askComputeAfterChangeMainInput    : function () {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.component_input.setValue();
            self.component_input.validateValueInput();
            self.computeValue();
            MANAGER.ListenerEventManager.askAfterActionProperty( self );
        }, 200 );
    },
    deleteLine                        : function ( dom_element ) {
        var _line_object = this.getLineObjectViaChildrenElement( dom_element );
        if ( !_line_object ) {
            return;
        }
        _line_object.delete();
        var _index = this.lines_object_mapping[ _line_object.uuid ];
        this.lines_object.splice( _index, 1 );
        this.rebuildMapping();
        this.setStateInheritance( !this.lines_object.length );
        this.computeValue();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    deleteAllLines                    : function () {
        for ( var i = this.lines_object.length - 1; i >= 0; i-- ) {
            this.deleteLine( this.lines_object[ i ].dom_element );
        }
    },
    ___onFocusOut                     : function ( dom_element ) {
        this.setValueFromUser( DOM.Service.getInnerText( dom_element ) );
        this.updateCfgDomElement();
        this.computeValue();
        this.setCfgEditable( false );
    },
    _computeBtnInheritance            : function () {
        if ( this.state && this.component_btn_inheritance.getState() !== COMPONENT.CONST.BTN_STATE.INIT ) {
            return;
        }
        var _is_inheritable = !this.value;
        this.setStateInheritance( _is_inheritable );
    },
    _computeState                     : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_mass_change && ! this.value ) {
            switch ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    break;
                default:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
            }
        }
        else if ( this.is_override ) {
            _to_set = this.lines_object.length ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.value && !this.lines_object.length ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        
        this.setState( _to_set );
        this.checkErrorWarning();
        this.updateCfgDomElement();
    },
    doActionAfterChange               : function (args) {
        if ( args['input_object'] ) {
            args['input_object'].updateView();
        }
        this.computeValue();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    computeValue                      : function () {
        this.value = "";
        var _current_value;
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            _current_value = this.lines_object[ i ].getValue();
            if ( _current_value === "" ) {
                continue;
            }
            if ( this.value ) {
                this.value += this.separator_line_saved;
            }
            this.value += _current_value;
        }
        if ( this.component_input ) {
            this.value = this.value ? this.component_input.getValue() + this.separator_line_saved + this.value : this.component_input.getValue();
        }
        this._computeState();
        this.computeIsSet();
    },
    updateCfgDomElement               : function () {
        if ( !this.dom_output_cfg ) {
            return;
        }
        var _line_separator = this.separator_line_html;
        switch ( this.separator_line_html ) {
            case "BACK_TO_LINE":
                _line_separator = "<br>";
                break;
        }
        
        
        var _to_write = "";
        if ( this.component_input ) {
            _to_write += this.component_input.getValue();
            if ( this.lines_object.length ) {
                _to_write += _line_separator;
            }
        }
        var _to_write_currrent = "";
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            if ( !SHINKEN.TOOLS.STRING.isEmptyHtml( _to_write_currrent ) ) {
                _to_write += _line_separator;
            }
            _to_write_currrent = this.lines_object[ i ].getCfgValue();
            _to_write += _to_write_currrent;
        }
        switch ( this.state ){
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                _to_write = PROPERTY.CONST.CUSTOM_SELECT.NONE;
                break;
        }
        this.dom_output_cfg.innerHTML = _to_write;
    },
    computeIsSet                      : function () {
        this.is_set = !!this.lines_object.length;
        DOM.Service.setDataSet( this.dom_element, 'isSet', this.is_set );
    },
    _updateCfgInheritedLabel          : function ( inherited_value ) {
        var _div_text_to_copy_container = DOM.Service.createElement( 'div', { class: 'shinken-text-to-copy' } );
        var _span_property_name         = DOM.Service.createElement( 'span', { class: 'shinken-multi-line-object-stringify-property' }, this.name );
        var _span_value                 = DOM.Service.createElement( 'span', { class: 'shinken-multi-line-object-inherited-value' }, SHINKEN.TOOLS.STRING.cleanXss(inherited_value) );
        DOM.Service.empty(this.dom_cfg_inherited_label);
        _div_text_to_copy_container.appendChild( _span_property_name );
        _div_text_to_copy_container.appendChild( _span_value );
        this.dom_cfg_inherited_label.appendChild( _div_text_to_copy_container );
    },
    parseValueFromUser                : function ( value, line ) {
        switch ( this.line_type ) {
            case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                if ( value.startsWith( PROPERTY.CONST.NAME.NOTE_MULTI_URL ) ) {
                    value = value.slice( PROPERTY.CONST.NAME.NOTE_MULTI_URL.length + 1 );
                }
                break;
            case PROPERTY.CONST.NAME.OUTPUT_RULES:
                if ( value.startsWith( PROPERTY.CONST.NAME.OUTPUT_RULES ) ) {
                    value = value.slice( PROPERTY.CONST.NAME.OUTPUT_RULES.length + 1 );
                }
                break;
        }
        return this.line_type === PROPERTY.CONST.NAME.PERIOD_DAY_NAME ? value : value.split( line.separator_key_value_html );
    },
    getSelectViaDomElement            : function ( dom_element ) {
        var _dom_target = DOM.Service.findParentElementWithClass( dom_element, "shinken-select-container", 20 );
        var _to_return  = this.selectors[ _dom_target.dataset.name ];
        if ( !_to_return ) {
            _to_return = this.getLineObjectViaChildrenElement( dom_element );
        }
        return _to_return;
    },
    getLineObjectViaChildrenElement   : function ( dom_element ) {
        var _dom_line_object = DOM.Service.findParentElementWithClass( dom_element, "shinken-multi-line-object-row", 20 );
        if ( !_dom_line_object ) {
            return null;
        }
        var _to_return = this.getLineObjectViaUUID( _dom_line_object.dataset.uuid );
        return _to_return || null;
    },
    getLineObjectViaUUID              : function ( uuid ) {
        var _index = this.lines_object_mapping[ uuid ];
        if ( _index === undefined ) {
            return null;
        }
        return this.lines_object[ _index ];
    },
    ___unset                          : function () {
        this.deleteAllLines();
        this._computeState();
    },
    updateWithTemplateSpecific        : function () {
        this._computeState();
    },
    setValueFromUser                  : function ( value ) {
        this.deleteAllLines();
        if ( this.line_type === PROPERTY.CONST.NAME.PERIOD_DAY_NAME ) {
            this.component_input.dom_element.value = "";
            this.askComputeAfterChangeMainInput();
        }
        var _line_separator = this.separator_line_html;
        switch ( this.separator_line_html ) {
            case "BACK_TO_LINE":
                _line_separator = "\n";
                break;
        }
        var _lines = value.split( _line_separator );
        var __new_line;
        var _data_splitted;
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            if ( _lines[ i ] ) {
                __new_line     = this.clickOnAddLine();
                _data_splitted = this.parseValueFromUser( _lines[ i ], __new_line );
                __new_line.setValueFromUser( _data_splitted );
            }
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    setCfgEditable                    : function ( to_set ) {
        DOM.Service.setDataSet( this.dom_element, 'cfgEditable', to_set );
        this.setContentEditableCfgTextContainer( to_set );
    },
    setContentEditableCfgTextContainer: function ( to_set ) {
        this.dom_output_cfg.contentEditable = to_set;
        if ( to_set === true ) {
            this.dom_output_cfg.focus();
            var range = document.createRange();
            range.selectNodeContents( this.dom_output_cfg );
            range.collapse( false );
            var sel = window.getSelection();
            sel.removeAllRanges();
            sel.addRange( range );
        }
    },
    ___hidePopup                      : function ( _uuid_exception ) {
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            if ( this.lines_object[ i ] !== _uuid_exception ) {
                this.lines_object[ i ].hidePopup();
            }
        }
    },
    computeErrorsSpecifics    : function () {
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            this.lines_object[i].computeErrorsSpecifics(this.state)
        }
    },
    getDataToSaveFinal                : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            default:
                return this.value || '';
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.MultiLine, PROPERTY.Interface );
PROPERTY.Range           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.Range.prototype = {
    init                        : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input_range       = new COMPONENT.InputRange( dom_element, this );
        this.component_btn_default       = new COMPONENT.Button( dom_element.querySelector( ".shinken-btn-default-cell .shinken-radio-btn" ), PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
        this.component_btn_default.value = this.default_value === 'same_as_host' ? '' : this.default_value;
        if ( this.is_override ) {
            this.component_btn_no_override       = new COMPONENT.Button( dom_element.querySelector( ".shinken-no-override-btn" ) );
            this.component_btn_no_override.value = parseInt( this.component_btn_no_override.dom_element.dataset.checkValue );
        }
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
    },
    onMoveRangeCursor           : function ( value_to_set, event, is_synchro ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( this.is_mass_change && !is_synchro && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() === PROPERTY.CONST.MASS_CHANGE.ACTION.SET_SYNCHRO ) {
            var self = this;
            setTimeout( function () {
                var _value = self.component_input_range.getValue();
                self.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.SET, null, self.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                self.setValueFromUser( _value );
            }, 200 );
        }
        if ( value_to_set !== null ) {
            switch ( this.type ) {
                case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                    value_to_set = SHINKEN.TOOLS.NUMBER.roundTo( value_to_set, 3 );
                    break;
            }
        }
        this.component_input_range.setValueFromUser( value_to_set );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.OFF );
        if ( event || value_to_set !== null ) {
            this._computeState();
        }
    },
    ___onFocusOut               : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                if ( this.component_input_range.component_input.hasBeenChanged() ) {
                    var new_value = this.component_input_range.component_input.getValue();
                    
                    var new_value_float = SHINKEN.TOOLS.NUMBER.parseFloat( new_value );
                    if ( isNaN( new_value_float ) || new_value_float < 0 || new_value_float > 100 ) {
                        return;
                    }
                    this.component_input_range.component_input.dom_element.value = SHINKEN.TOOLS.NUMBER.roundTo( new_value_float, 3 );
                    this.component_input_range.component_input.setValue();
                    this._computeState();
                }
                break;
        }
    },
    ___clickOnRadioBtn          : function ( value ) {
        var _value_to_set;
        var _btn_status;
        switch ( value ) {
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                _btn_status = this.component_btn_default.getState();
                switch ( _btn_status ) {
                    case COMPONENT.CONST.BTN_STATE.OFF:
                        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        _value_to_set = this.default_value;
                        break;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _btn_status = this.component_btn_no_override.getState();
                switch ( _btn_status ) {
                    case COMPONENT.CONST.BTN_STATE.OFF:
                        this.changeNoOverrideButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        _value_to_set = this.component_btn_no_override.value;
                        break;
                    case COMPONENT.CONST.BTN_STATE.ON:
                        return;
                }
                break;
        }
        this.component_input_range.setValue( _value_to_set );
        this._computeState();
    },
    changeDefaultButtonStatus   : function ( value, prevent_compute ) {
        this.component_btn_default.setState( value );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', value );
        if ( prevent_compute ) {
            return;
        }
        if ( this.component_btn_default.getState() && !(this.component_btn_inheritance.isSet() && this.component_btn_inheritance.getState()) ) {
            this.component_input_range.setValue( this.component_btn_default.getValue() );
        }
        if ( this.is_override ) {
            this.component_btn_no_override.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this._computeState();
    },
    changeNoOverrideButtonStatus: function ( value ) {
        this.component_btn_no_override.setState( value );
        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.OFF );
        if ( this.component_btn_no_override.getState() ) {
            this.component_input_range.setValue( this.component_btn_no_override.getValue() );
        }
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
    },
    clickOnBtnInheritance       : function () {
        this.setStateInheritance( !this.state_inheritance );
        this.custom_selected = this.state_inheritance ? PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
        this._computeState();
    },
    askComputeAfterChange       : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input_range.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange         : function () {
        this.component_input_range.component_input.setValue();
        if ( this.is_mass_change && this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() === PROPERTY.CONST.MASS_CHANGE.ACTION.SET_SYNCHRO ) {
            var _value = this.component_input_range.component_input.getValue();
            this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.SET, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
            this.setValueFromUser( _value );
        }
        if ( !this.component_input_range.component_input.getValue() && this.is_override ) {
            this.changeNoOverrideButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
        }
        else if ( !this.component_input_range.component_input.getValue() ) {
            this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON, true );
            var _value_to_set = this.component_btn_default.getValue();
            if ( this.state_inheritance && this.component_btn_inheritance.isSet() ) {
                _value_to_set = this.inherited_value;
            }
            this.component_input_range.setValue( _value_to_set );
        }
        else {
            this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.OFF, true );
            this.component_input_range.setValueFromUser( this.component_input_range.component_input.getValue() );
        }
        this.setStateInheritance( !this.component_input_range.getValue() );
        this._computeState();
        
        if ( !this.component_input_range.component_input || !this.component_input_range.component_input.hasFocus() ) {
            MANAGER.ListenerEventManager.afterActionProperty( this );
        }
        else {
            this.do_after_action_after_loosing_focus = true;
        }
    },
    _computeBtnInheritance      : function () {
        if ( this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
        else {
            if ( this.component_btn_inheritance.isSet() ) {
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
            }
        }
    },
    updateWithTemplateSpecific  : function () {
        this._computeState();
        this._computeInheritedLabel();
    },
    _computeState               : function () {
        var _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        if ( this.is_override ) {
            if ( this.component_btn_no_override.isOn() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
            else if ( this.component_btn_default.isOn() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
        }
        else if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    if ( this.component_input_range.getValue() === PROPERTY.CONST.DEFAULT_BUTTON_LABEL ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    }
                    break;
            }
        }
        else if ( this.state_inheritance && this.component_btn_inheritance.isSet() ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else {
            if ( this.component_btn_default.isOn() ) {
                if ( this.component_btn_inheritance.isSet() ) {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                }
                else {
                    if ( this.state === PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    }
                    else {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    }
                }
            }
        }
        this.setState( _to_set );
        this.askCheckErrorWarning();
    },
    _computeInheritedLabel      : function ( inherited_value ) {
        var _to_return;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.RANGE:
                switch ( inherited_value ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        inherited_value = this.default_value;
                        break;
                }
                _to_return = inherited_value + this.component_input_range.unit;
                break;
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                switch ( inherited_value ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        return _( "element.business_impact_" + this.default_value );
                }
                _to_return = _( "element.business_impact_" + inherited_value );
                break;
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                switch ( inherited_value ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        inherited_value = this.default_value;
                        break;
                }
                _to_return = inherited_value + this.component_input_range.unit;
                break;
        }
        return _to_return;
    },
    ___unset                    : function () {
        if ( this.is_mass_change ) {
            this.component_input_range.setValue( PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
            this.component_input_range.value_from_user = '';
            
            if ( this.component_input_range.component_label_input ) {
                this.component_input_range.component_label_input.updateLabel( _( 'mass-change.input.extra-action.NONE' ) );
            }
            this._computeState();
        }
        else {
            this.setValueFromUser( "" );
        }
    },
    setValueFromUser            : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.DEFAULT_BUTTON_LABEL;
            }
        }
        switch ( value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.clickOnRadioBtn( null, value );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                this.clickOnRadioBtn( null, PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( !this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
            default:
                this.onMoveRangeCursor( parseFloat( value ) );
                break;
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    isDifferentValue            : function ( value1, value2 ) {
        if ( value1 === value2 ) {
            return false;
        }
        return parseFloat( value1 ) !== parseFloat( value2 );
    },
    getComponents               : function () {
        return [ this.component_input_range, this.component_btn_inheritance ];
    },
    getFlatValue                : function () {
        var _to_return = '';
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                _to_return = this.component_btn_inheritance.isSet() ? this.getValueInherited() : this.default_value;
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                _to_return = this.default_value;
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                _to_return = this.getValue();
                break;
        }
        if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            _to_return = this.default_value;
        }
        return _to_return;
    },
    getValueInherited           : function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    setStateInheritanceSpecific : function () {
        if ( this.state_inheritance && this.component_btn_inheritance.isSet() ) {
            this.component_input_range.setValue( this.inherited_value, false );
        }
        else if ( this.component_btn_default.isOn() && !this.is_mass_change ) {
            this.component_input_range.setValue( this.component_btn_default.getValue(), false );
        }
        else {
            this.component_input_range.setValueFromUser( this.component_input_range.getValueFromUser() );
        }
    },
    computeErrorsSpecifics      : function () {
        if ( this.type === PROPERTY.CONST.TYPES.RANGE_WITH_INPUT ) {
            this.component_input_range.component_input.validateValueInput();
        }
    },
    setErrorsSpecific           : function () {
        var _property_associate = MANAGER.ListenerEventManager.getObjectLink( this )[ 0 ];
        this.counter_temp_error = 0;
        var _name               = this.is_override ? this.override_prop_name : this.name;
        switch ( _name ) {
            case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
                if ( this.is_override ) {
                    var _element = MANAGER.__instance_property_distributor.getElement( _property_associate );
                    if ( _element ) {
                        _element.checkErrorWarning();
                    }
                }
                else {
                    MANAGER.__instance_property_distributor.findElement( _property_associate ).checkErrorWarning();
                }
                return;
            case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
                if ( this.is_override ) {
                    var _element = MANAGER.__instance_property_distributor.getElement( _property_associate );
                    if ( !_element ) {
                        return;
                    }
                    var _high_value = this.getValueFinalOverride();
                    var _low_value  = _element.getValueFinalOverride();
                    if ( parseFloat( _high_value ) < parseFloat( _low_value ) ) {
                        this.counter_temp_error = 1;
                    }
                }
                else {
                    var _high_value = this.getFlatValue();
                    var _low_value  = MANAGER.__instance_property_distributor.findElement( _property_associate ).getFlatValue();
                    if ( parseInt( _high_value ) < parseInt( _low_value ) ) {
                        this.counter_temp_error = 1;
                    }
                }
                if ( this.counter_temp_error ) {
                    _name === PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ? this.counter_error_tooltip = _( "element.incoherent_flapping_values" ) : this.counter_error_tooltip = _( "element.incoherent_sla_values" );
                }
                return;
        }
    },
    synchronizeAtMinimum        : function ( property, force ) {
        if ( this.is_mass_change && !force ) {
            return this.synchronizeAtMassChange( property, false );
        }
        var _property_value = parseFloat( property._computeValueForSynchronize() );
        var _current_value  = parseFloat( this.component_input_range.getValue() );
        if ( isNaN( _current_value ) && this.is_mass_change ) {
            this.onMoveRangeCursor( _property_value, null, true );
        }
        else if ( _current_value < _property_value && _property_value >= this.component_input_range.min && _property_value <= this.component_input_range.max ) {
            this.onMoveRangeCursor( _property_value, null, true );
        }
    },
    synchronizeAtMaximum        : function ( property, force ) {
        if ( this.is_mass_change && !force ) {
            return this.synchronizeAtMassChange( property, true );
        }
        var _property_value = parseFloat( property._computeValueForSynchronize() );
        var _current_value  = parseFloat( this.component_input_range.getValue() );
        if ( isNaN( _current_value ) && this.is_mass_change ) {
            this.onMoveRangeCursor( _property_value, null, true );
        }
        else if ( _current_value > _property_value && _property_value >= this.component_input_range.min && _property_value <= this.component_input_range.max ) {
            this.onMoveRangeCursor( _property_value, null, true );
        }
    },
    synchronizeAtMassChange     : function ( property, is_max ) {
        var _action_property = property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        var _action_this     = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        switch ( _action_this ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_SYNCHRO:
                switch ( _action_property ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                        this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                        this.stop_synchronization = true;
                        return;
                }
                break;
        }
        switch ( _action_property ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                if ( (_action_this !== PROPERTY.CONST.MASS_CHANGE.ACTION.NONE && this.state !== PROPERTY.CONST.STATE_PROPERTY.INHERITANCE) ) {
                    this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                    this.stop_synchronization = true;
                }
                return;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                return;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                if ( _action_this === PROPERTY.CONST.MASS_CHANGE.ACTION.SET ) {
                    if ( property.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                            return;
                        }
                        else {
                            return property.synchronizeAtMassChange( this, !is_max );
                        }
                    }
                    return is_max ? this.synchronizeAtMaximum( property, true ) : this.synchronizeAtMinimum( property, true );
                }
                if ( property.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
                    return;
                }
                break;
        }
        switch ( _action_this ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                return;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION.SET_SYNCHRO, null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
                this.stop_synchronization = true;
                break;
        }
        if ( property.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE && this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
            return;
        }
        this.onMoveRangeCursor( property.getValue(), null, true );
    },
    getDataToSaveFinal          : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
        }
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Range, PROPERTY.Interface );
PROPERTY.MultiSelect           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.MultiSelect.prototype = {
    init                           : function ( element ) {
        this.initDomElement( element );
        this.initMainSelector();
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, element, this.type );
        this.limit_rest                = 0;
        this.is_limit_reached          = false;
        if ( !this.is_mass_change ) {
            this.component_btn_inheritance.setHasArborescence( this.has_plus );
        }
    },
    clickOnBtnPlus                 : function ( event ) {
        if ( this.is_disabled ) {
            return false;
        }
        if ( this.is_mass_change ) {
            this.hidePopup();
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].clickOnSelector();
            event.stopPropagation();
            return true;
        }
        var _to_set;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                _to_set = COMPONENT.CONST.BTN_STATE.OFF;
                break;
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                _to_set = COMPONENT.CONST.BTN_STATE.DISCREET;
                break;
            default:
                this.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE, null, this.getSelector() );
                return;
        }
        this.setStatePlus( _to_set );
        this.updateView();
    },
    clickOnAllItemsSelector        : function ( limit ) {
        var _keys = Object.keys( this.getSelector().list_element.list_mapping );
        var _size = _keys.length;
        if ( limit && _size > limit ) {
            _size = limit;
        }
        var _current_key;
        for ( var i = 0; i < _size; i++ ) {
            _current_key = _keys[ i ];
            switch ( _current_key ) {
                case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
                case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    break;
                default:
                    this.clickOnItemSelector( _current_key, null, this.getSelector() );
            }
        }
    },
    cleanAllSelectedElement        : function () {
        var _values = this.getSplitValueUser();
        this.getSelector().cleanAllTags();
        this.getSelector().cleanAllItemsSelected();
        if ( this.is_mass_change && this.synchronized_elements ) {
            for ( var i = 0, _size_i = _values.length; i < _size_i; i++ ) {
                MANAGER.ListenerEventManager.updateSynchronizedTags( this, _values[ i ] );
            }
        }
    },
    ___clickOnItemSelector         : function ( _target_component, key_name ) {
        if ( _target_component !== this.getSelector() ) {
            return;
        }
        this.synchronize_linked_elements = false;
        this.setLastItemSelected( key_name );
        switch ( key_name ) {
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                this.cleanAllSelectedElement();
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.cleanAllSelectedElement();
                this.state_plus = COMPONENT.CONST.BTN_STATE.DISCREET;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
                this.state_plus = COMPONENT.CONST.BTN_STATE.ON;
                if ( this.is_mass_change ) {
                    this.clickOnItemSelector( "ON", null, this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] );
                }
                else {
                    this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE:
                this.state_plus = COMPONENT.CONST.BTN_STATE.ON;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                this.state_plus = COMPONENT.CONST.BTN_STATE.OFF;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                this.cleanAllSelectedElement();
                this.state_plus = this.is_override ? COMPONENT.CONST.BTN_STATE.DISCREET : COMPONENT.CONST.BTN_STATE.OFF;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                this.cleanAllSelectedElement();
                this.state_plus = this.is_override ? COMPONENT.CONST.BTN_STATE.DISCREET : COMPONENT.CONST.BTN_STATE.OFF;
                this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            default:
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        this.cleanAllSelectedElement();
                        this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                        break;
                }
                if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
                    this.synchronize_linked_elements = true;
                }
                
                this.getSelector().clickOnItemSelector( this.name, key_name, 'shinken-select-no-events' );
                break;
        }
        this.updateView();
        return true;
    },
    clickOnDeleteItemSelector      : function ( key_name, synchronise ) {
        if ( this.is_disabled ) {
            return false;
        }
        this.getSelector().clickOnDeleteItemSelector( key_name );
        var _first_tag_remaining = this.getSelector().getActiveListForUser().getTagByIndex( 0 );
        if ( _first_tag_remaining ) {
            this.setLastItemSelected( _first_tag_remaining.element.name );
        }
        else if ( this.is_mass_change ) {
            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE );
        }
        else if ( this.is_override ) {
            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE );
            this.setStatePlus( COMPONENT.CONST.BTN_STATE.DISCREET );
        }
        else {
            this.setLastItemSelected( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ? PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT );
        }
        if ( this.is_mass_change ) {
            MANAGER.ListenerEventManager.clickOnDeleteItemSelectorMassChange( this, key_name );
        }
        this.updateView();
    },
    specificTreatment              : function () {
        this.is_all_selection_disabled = false;
        var _tag_information_status    = COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE;
        var _name                      = this.is_override ? this.override_prop_name : this.name;
        switch ( _name ) {
            case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
            case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
            case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
            case PROPERTY.CONST.NAME.ESCALATIONS:
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
                if ( this.hasInvalidElementForProduction() ) {
                    _tag_information_status = COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER;
                }
                break;
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                var _is_all_disabled = this.isAllElementsSelectedDisabled();
                if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
                    if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ||
                         this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.NONE ||
                         this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ||
                         _is_all_disabled ) {
                        if ( _is_all_disabled ) {
                            this.is_all_selection_disabled = true;
                        }
                        var _property_group = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS );
                        if ( _property_group.getValueAndValueInherited() ) {
                            this.tag_information.setStatus( COMPONENT.CONST.TAG_INFORMATION.STATUS.USER_GROUP_COHERENCY );
                            return;
                        }
                        else if ( _is_all_disabled ) {
                            this.tag_information.setStatus( COMPONENT.CONST.TAG_INFORMATION.STATUS.ALL_DISABLED );
                            return;
                        }
                    }
                }
                break;
            case PROPERTY.CONST.NAME.PARENTS:
                var _tags_inherited = this.getSelector().list_elements_inherited.tags;
                var _size           = _tags_inherited.length;
                var _current;
                var _current_name;
                if ( this.state_inheritance ) {
                    for ( var i = 0; i < _size; i++ ) {
                        _current      = _tags_inherited[ i ];
                        _current_name = _current.getName();
                        if ( _current_name === MANAGER.__instance_element_distributor.current_element.getName() ) {
                            _current.addClass( 'tag-error' );
                            _current.setMessageTooltip( _( 'element.tooltip_infinity_loop' ) );
                            _current.setState( COMPONENT.CONST.TAG.STATE.UNKNOWN );
                        }
                    }
                }
                if ( this.hasInvalidElementForProduction() ) {
                    _tag_information_status = COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER;
                }
                break;
        }
        this.tag_information.setStatus( _tag_information_status );
    },
    updateAllTemplatesCustomTags   : function ( templates_properties ) {
        if ( !templates_properties ) {
            return;
        }
        var _size = templates_properties.length;
        var _current;
        var _current_tag;
        var _size_tags;
        for ( var i = 0; i < _size; i++ ) {
            _current   = templates_properties[ i ];
            _size_tags = _current.tags.length;
            for ( var j = 0; j < _size_tags; j++ ) {
                _current_tag = _current.tags[ j ];
                if ( _current_tag.isDefaultTag() ) {
                    _current_tag.updateTagWithNoneTags( this.default_label );
                }
                else if ( _current_tag.isNullTag() ) {
                    _current_tag.updateTagWithNoneTags( this.none_label );
                }
            }
        }
        
    },
    updateWithTemplateSpecific     : function () {
        if ( this.component_btn_inheritance.isSet() ) {
            this.getSelector().updateWithTemplateSpecific( this.component_btn_inheritance.getTags() );
        }
        this.updateView();
    },
    clickOnBtnInheritance          : function () {
        if ( !this.component_btn_inheritance.isSet() ) {
            return;
        }
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                this.setStateInheritance( false );
                break;
            default:
                this.setStateInheritance( true );
                break;
        }
        if ( this.state_inheritance ) {
            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
        }
        else {
            if ( this.getSelector().list_element_selected.hasUserTag() ) {
                var _last_element_selected = this.getSelector().list_element.getFirstSelectedElement();
                this.setLastItemSelected( _last_element_selected.element.name );
            }
            else {
                this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
        }
        this.updateView();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    setStatePlus                   : function ( to_set ) {
        this.state_plus = to_set;
    },
    getValueInherited              : function () {
        return this.getSelector().list_elements_inherited.getValue();
    },
    getValueAndValueInherited      : function () {
        var _to_return;
        var _value     = "";
        var _inherited = "";
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                _value     = this.getValue();
                _inherited = this.getValueInherited();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                _inherited = this.getValueInherited();
                break;
            default :
                _value = this.getValue();
                break;
        }
        _to_return = _value;
        if ( _value && _inherited ) {
            _to_return += ',';
        }
        _to_return += _inherited;
        return _to_return;
    },
    isSetOrIsSetFromTemplate       : function () {
        if ( this.getSelector().isSet() ) {
            return true;
        }
        if ( this.component_btn_inheritance.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            return false;
        }
        return this.getSelector().list_elements_inherited.hasUserTag();
    },
    setValueFromUser               : function ( value ) {
        this.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.NONE, null, this.getSelector() );
        if ( !value ) {
            if ( this.is_mass_change ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
            }
            else if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            }
        }
        
        if ( SHINKEN.TOOLS.STRING.startsWith( value, PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ) {
            value = value.substr( 1 );
            this.clickOnBtnPlus();
        }
        var _values = value.split( ',' );
        for ( var i = 0, _size = _values.length; i < _size; i++ ) {
            this.clickOnItemSelector( _values[ i ], null, this.getSelector() );
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    isAllElementsSelectedDisabled  : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                return this.getSelector().isAllElementsSelectedDisabled();
        }
        return false;
    },
    hasInvalidElementForProduction : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                return this.getSelector().hasInvalidElementForProduction();
        }
        return false;
    },
    ___updateView                  : function () {
        this._computeState();
        this.specificTreatment();
        this._computeLimitReached();
        this._computeLabelSelect();
        this.checkErrorWarning();
    },
    finalActionAfterOverrideLoading: function () {
        if ( !this.is_override ) {
            return;
        }
        var _check          = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.override_check_uuid );
        var _value_on_check = _check.getValuesSplitted( this.override_prop_name );
        var _tag;
        var _current;
        for ( var i = 0, _size_i = _value_on_check.length; i < _size_i; i++ ) {
            _current = _value_on_check[ i ];
            _current = this.getSelector().list_element.getElement( _current );
            switch ( _current.name ) {
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                    this.dom_element.querySelector( '.shinken-value-from-check' ).appendChild( DOM.Service.createElement( 'span', {}, _current.getLabel() ) );
                    break;
                default:
                    _tag = new COMPONENT.Tag();
                    _tag.setElement( _current );
                    _tag.buildHTML();
                    this.dom_element.querySelector( '.shinken-value-from-check' ).appendChild( DOM.Service.createElement( 'div', { class: 'droppable' }, _tag.dom_element.outerHTML ) );
            }
        }
    },
    _computeBtnInheritance         : function () {
        if ( this.state ) {
            return;
        }
        if ( this.is_not_heritable ) {
            return;
        }
        if ( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            return;
        }
        var _is_set = this.getSelector().isSet();
        if ( _is_set ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        else {
            switch ( this.custom_selected ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                    this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
                    break;
                default:
                    this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    _computeState                  : function () {
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var _to_set            = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _to_set = this.is_mass_change ? PROPERTY.CONST.STATE_PROPERTY.USER_SET : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                if ( this.is_override ){
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
                if ( !this.state_plus && !this.getSelector().isSet() ) {
                    _to_set                         = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    this.last_list_element_selected = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                _to_set     = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
                switch ( _action ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                        if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ||
                             this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                            _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                            if ( this.has_plus ) {
                                if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() !== PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE ) {
                                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER;
                                }
                            }
                        }
                        else if ( this.has_plus ) {
                            if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() !== PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE ) {
                                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET_MASS_CHANGE_PLUS_ONLY;
                            }
                        }
                        break;
                    default:
                        if ( this.has_plus ) {
                            if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() !== PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE ) {
                                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET_MASS_CHANGE_PLUS_ONLY;
                            }
                        }
                }
                break;
        }
        if ( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ) {
            _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER;
        }
        this.setState( _to_set );
    },
    _computeLabelSelect            : function () {
        var _title_to_set = _( 'element.selected_values' );
        var _element_list;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( this.component_btn_inheritance.isSet() ) {
                    var _inherited_tag = this.component_btn_inheritance.getTags()[ 0 ];
                    switch ( _inherited_tag.getName() ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _element_list = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE );
                            _title_to_set = this._computeInheritedLabelHtml( this.component_btn_inheritance.list_template_property[ 0 ].template_name, _element_list.getLabel() );
                            break;
                        default:
                            _element_list = this.getSelector().list_element.getElement( this.last_list_element_selected );
                            _title_to_set = _element_list.getLabel();
                            break;
                    }
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                _element_list = this.getSelector().list_element.getElement( this.last_list_element_selected );
                _title_to_set = _element_list.getLabel();
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                if ( this.component_btn_inheritance.isSet() ) {
                    this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
                }
                _element_list = this.getSelector().list_element.getElement( this.last_list_element_selected );
                _title_to_set = _element_list.getLabel();
                break;
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER ) {
            _element_list = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE );
            _title_to_set = _element_list.getLabel();
        }
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS ) {
            _element_list = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE );
            _title_to_set = _element_list.getLabel();
        }
        if ( this.is_all_selection_disabled ) {
            if ( this.is_override ) {
                _title_to_set = "<span>" + _( 'element.in_check' ) + "</span>&nbsp;&nbsp;" + "<span class='shinken-only-disabled-tags'>" + _( 'element.selected_values_disabled' ) + "</span>";
            }
            else {
                _title_to_set = "<span>" + _( 'element.default' ) + "<span class='shinken-between-bracket shinken-default-label'>" + this.none_label + "</span></span>&nbsp;&nbsp;" + "<span class='shinken-only-disabled-tags'>" + _( 'element.selected_values_disabled' ) + "</span>";
            }
        }
        _title_to_set = '<span class="shinken-multiselect-title">' + _title_to_set + '</span>';
        if ( this.is_limit_reached ) {
            var _title_option = ' ( ' + _( 'element.maximum_of' ) + ' ' + this.getSelector().getMaximumSelected() + ' ' + _( 'element.reached' ) + ' )';
            _title_to_set += DOM.Service.createElement( 'span', {}, _title_option ).outerHTML;
            this.dom_element.classList.add( 'behavior-limit' );
        }
        else {
            this.dom_element.classList.remove( 'behavior-limit' );
        }
        this.getSelector().setTitle( _title_to_set );
    },
    _computeLimitReached           : function () {
        if ( !this.getSelector().getMaximumSelected() ) {
            return;
        }
        var limit = -1;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                limit = this.getSelector().isLimitReached();
                break;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                limit = this.getSelector().isLimitReachedForSelected();
                break;
        }
        
        this.limit_rest       = limit;
        this.is_limit_reached = limit >= 0;
        this.getSelector().disabledTagsOutOfLimit( this.limit_rest );
    },
    setStateInheritanceSpecific    : function () {
        if ( this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.setStatePlus( COMPONENT.CONST.BTN_STATE.OFF );
            if ( this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE && this.component_btn_inheritance.isSet() ) {
                this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
            }
        }
    },
    cleanBeforeUpdate              : function () {
        this.getSelector().list_elements_inherited.emptyList();
    },
    updateSynchronizedList         : function ( property_synchro ) {
        if ( this.synchronized_elements[ property_synchro.getName() ] ) {
            MANAGER.ListenerEventManager._synchronizeMassChangesSelectorAfterSynchro( this, property_synchro, this.synchronized_elements[ property_synchro.getName() ], true );
        }
        this.synchronized_elements[ property_synchro.getName() ] = SHINKEN.TOOLS.ARRAY.clone( property_synchro.getSelector().getActiveListForUser().getTags() );
        MANAGER.ListenerEventManager._synchronizeMassChangesSelectorAfterSynchro( this, property_synchro, this.synchronized_elements[ property_synchro.getName() ], false );
    },
    synchronizeAtMaximumMassChange : function ( property ) {
        switch ( this.getName() ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                return PROPERTY.UserRightsBehaviour.askSynchronization( property );
        }
    },
    synchronizeAtMinimumMassChange : function ( property ) {
        switch ( this.getName() ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                return PROPERTY.UserRightsBehaviour.askSynchronization( property );
        }
    },
    synchronizeAtMinimum           : function ( property ) {
        if ( this.is_mass_change ) {
            return this.synchronizeAtMinimumMassChange( property );
        }
        switch ( property.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.PLUS_AND_OVERRIDE:
                this.clickOnItemSelector( property.last_list_element_selected, null, this.getSelector() );
                return;
        }
        if ( property.state_plus === COMPONENT.CONST.BTN_STATE.ON && this.state_plus === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.clickOnBtnPlus();
        }
        if ( property.state_inheritance && !this.state_inheritance ) {
            if ( this.getSelector().isSet() ) {
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                        break;
                    default:
                        if ( this.component_btn_inheritance.isSet() ) {
                            this.clickOnBtnPlus();
                        }
                        break;
                }
            }
            else {
                this.clickOnBtnInheritance();
            }
        }
        PROPERTY.UserRightsBehaviour.addMissing( this, property );
    },
    synchronizeAtMaximum           : function ( property ) {
        if ( this.is_mass_change ) {
            return this.synchronizeAtMaximumMassChange( property );
        }
        switch ( property.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.clickOnItemSelector( property.last_list_element_selected, null, this.getSelector() );
                return;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                this.clickOnItemSelector( this.component_btn_inheritance.isSet() ? property.last_list_element_selected : PROPERTY.CONST.CUSTOM_SELECT.NONE, null, this.getSelector() );
                return;
        }
        
        var _missing       = SHINKEN.TOOLS.STRING.splitMultiselectValueWithNoPlus( this.getFlatValue() );
        var _value_present = SHINKEN.TOOLS.STRING.splitMultiselectValueWithNoPlus( property.getFlatValue() );
        _missing           = SHINKEN.TOOLS.ARRAY.concatUniqueIfNotPresentIn( [], _missing, _value_present );
        for ( var i = 0, _size_i = _missing.length; i < _size_i; i++ ) {
            PROPERTY.UserRightsBehaviour.addValueTo( property, _missing[ i ] );
        }
        switch ( property.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                if ( this.state_plus === COMPONENT.CONST.BTN_STATE.ON ) {
                    this.clickOnBtnPlus();
                }
                break;
        }
        
    },
    resetDragging                  : function () {
        fire_element_is_modifie();
        this.dom_element.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGING );
        this.getSelector().resetDragging();
        if ( this.name === PROPERTY.CONST.NAME.USE ) {
            MANAGER.ListenerEventManager.afterActionGlobal( this );
        }
    },
    dragStartShinken               : function ( type_element, key_name ) {
        this.dom_element.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGING );
        switch ( type_element ) {
            case PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM:
                return this.getSelector().dragStartShinken( type_element, key_name );
        }
    },
    addTagWithFilterName           : function () {
        var _name = SHINKEN.TOOLS.STRING.removeXss( this.getSelector().list_element.current_filter );
        _name     = SHINKEN.TOOLS.STRING.trim( _name );
        if ( !_name ) {
            return;
        }
        var _element = this.getSelector().validOrCreateTag( _name, this.name );
        if ( _element.is_selected ) {
            console.warn( "[already selected]", _element );
        }
        else {
            this.clickOnItemSelector( _element.getName(), null, this.getSelector() );
            MANAGER.ListenerEventManager.askAfterActionProperty( this );
        }
        this.getSelector().pulsateTag( _element.getName() );
        this.getSelector().list_element.current_filter = "";
        this.hidePopup();
        this.getSelector().cleanFilter();
    },
    getSplitValueUser              : function () {
        return this.getValue().split( ',' );
    },
    getDataToSaveFinal             : function () {
        var _to_return = {};
        if ( this.is_mass_change && this.last_list_element_selected === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
            return PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
        }
        _to_return.links = this.getSelector().getValueToSave();
        if ( !this.is_mass_change ) {
            _to_return.has_plus = (this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER || this.state === PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS);
        }
        return _to_return;
    },
    getDataToSave                  : function () {
        if ( this.is_mass_change ) {
            return this.getDataToSaveMassChange();
        }
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.DEFAULT_TO_LINK;
        }
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                return PROPERTY.CONST.NONE_TO_LINK;
        }
        return this.getDataToSaveFinal();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.MultiSelect, PROPERTY.InterfaceSelect );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.MultiSelect, PROPERTY.Interface );
PROPERTY.SingleSelect           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.SingleSelect.prototype = {
    init                  : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.initMainSelector();
        this.component_btn_inheritance                 = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.getSelector().buildLinkOpenNewTab( this.item_type, this.link_id );
    },
    computeErrorsSpecifics: function ( force_mass_change ) {
    },
    setErrorsSpecific     : function () {
        var _selected_element;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                break;
            default:
                _selected_element = this.getSelector().getLastSelectedElement();
                break;
        }
        if ( _selected_element ) {
            this.counter_temp_error = _selected_element.element.getError();
        }
        this.tag_information.setStatus( this.counter_temp_error ? COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER : COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE );
    },
    _computeBtnInheritance: function () {
        var _value        = this.getSelector().getValue();
        var _is_inherited = (this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE && !_value);
        
        if ( _is_inherited ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
        else {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
    },
    _computeState         : function () {
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var _to_set            = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _to_set = this.is_mass_change? PROPERTY.CONST.STATE_PROPERTY.USER_SET: PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                if ( this.is_override ){
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                break;
        }
        this.setState( _to_set );
        this._computeLabelSelect();
    },
    setValueFromUser      : function ( value ) {
        if ( !value ) {
            if ( this.is_mass_change ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
            }
            else if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            }
        }
        this.clickOnItemSelector( value, null, this.getSelector() );
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    getValueInherited     : function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    
    getDataToSaveFinal: function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
        }
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                return this.last_list_element_selected;
        }
        if ( !this.link_id ) {
            return this.getSelector().getValue();
        }
        var _to_return      = {};
        _to_return.links    = [ this.getSelector().getValueToSave() ];
        _to_return.has_plus = false;
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelect, PROPERTY.InterfaceSelect );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelect, PROPERTY.Interface );
PROPERTY.SingleSelectWithInput           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.SingleSelectWithInput.prototype = {
    init                  : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.initMainSelector();
        this.component_input           = new COMPONENT.Input( dom_element.querySelector( ".shinken-input" ), this );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.getSelector().buildLinkOpenNewTab( this.item_type, this.link_id );
    },
    computeErrorsSpecifics: function ( force_mass_change ) {
    },
    setErrorsSpecific     : function () {
        var _selected_element;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                break;
            default:
                _selected_element = this.getSelector().getLastSelectedElement();
                break;
        }
        if ( _selected_element ) {
            this.counter_temp_error = _selected_element.element.getError();
        }
        this.tag_information.setStatus( this.counter_temp_error ? COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER : COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE );
        if ( !this.counter_temp_error && this.is_required ) {
            var _message            = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init( this, this.last_list_element_selected );
            this.counter_temp_error = _message.messages_error.length;
            if ( this.counter_temp_error ) {
                this.counter_error_tooltip = _message.buildMessage();
            }
        }
    },
    askComputeAfterChange : function ( dom_element ) {
        switch ( dom_element.name ) {
            case 'multi-search':
                this.getSelectViaDomElement( dom_element ).askComputeAfterChange( dom_element );
                break;
            default:
                this.component_input.askComputeAfterChange( dom_element, this );
                break;
        }
    },
    doActionAfterChange   : function () {
        this.component_input.setValue();
        if ( this.state_inheritance && !this.is_override ) {
            this.clickOnItemSelector( this.inherited_cmd_name, null, this.getSelector() );
        }
        else {
            this._computeState();
        }
        if ( this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
            App.Elements.ChecksTab.askInit( { override_command_change: true, property: this } );
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    _computeBtnInheritance: function () {
        var _value        = this.getSelector().getValue();
        var _is_inherited = (this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE && !_value);
        if ( _is_inherited ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
        else {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        
        this.setStateInheritance( _is_inherited );
        this.component_input.updateView( _is_inherited );
        var _state_property = _is_inherited ? PROPERTY.CONST.STATE_PROPERTY.INHERITANCE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.setState( _state_property );
    },
    _computeState         : function () {
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var _to_set            = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET_NONE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                if ( this.component_input.getValue() ) {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _to_set = this.is_mass_change ? PROPERTY.CONST.STATE_PROPERTY.USER_SET : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                if ( this.is_override && this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND && this.component_input.getValue() ) {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
                }
                else {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                break;
        }
        this.setState( _to_set );
        this._computeLabelSelect();
        this._computeStateInput();
    },
    _computeStateInput    : function () {
        var _state = 1;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _state = 0;
                break;
        }
        DOM.Service.setDataSet( this.dom_element, 'stateInput', _state );
    },
    
    setValueFromUser  : function ( value, arg_value ) {
        arg_value = arg_value || '';
        if ( this.is_override ) {
            arg_value = value;
            value     = "";
        }
        this.component_input.dom_element.value = arg_value;
        this.doActionAfterChange();
        if ( !value ) {
            if ( this.is_mass_change ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
            }
            else if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            }
        }
        this.clickOnItemSelector( value, null, this.getSelector() );
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    getDataToSaveFinal: function () {
        var _args_value;
        var _need_value = true;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                return PROPERTY.CONST.CUSTOM_SELECT.NONE;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                return '';
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                if ( !this.component_input.getValue() ) {
                    return PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
                }
                _need_value = false;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _args_value = this.component_input.getValue();
                if ( this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
                    return _args_value;
                }
                if ( this.override_prop_name === PROPERTY.CONST.NAME.EVENT_HANDLER ) {
                    return '';
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            
        }
        var _to_return       = {};
        _to_return.node      = {};
        _to_return.node.args = this.component_input.getValue();
        if ( _need_value ) {
            _to_return.node.link = this.getSelector().getValueToSave();
            _to_return.raw_value = _to_return.node.args ? this.getSelector().getValue() + PROPERTY.CONST.CHECK_COMMAND.SEPERATOR + _to_return.node.args : this.getSelector().getValue();
        }
        if ( this.is_mass_change && this.is_override_mass_change ) {
            _to_return = this.component_input.getValue() ? this.component_input.getValue() : PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectWithInput, PROPERTY.InterfaceSelect );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectWithInput, PROPERTY.Interface );
PROPERTY.UserRightsBehaviourMassChange = (function ( self ) {
    self._timeout_add_consistenct            = null;
    self.synchronization                     = function ( modified_property ) {
        var _value;
        var _action      = modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        var _action_plus = modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] ? modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() : PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE;
        var _action_to_add,
            _value_to_add;
        switch ( modified_property.getName() ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                switch ( _action ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                        self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                        self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                        _value = modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue();
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), _action, _value, modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() );
                                break;
                        }
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                        _value = modified_property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ].getValue() || modified_property.last_list_element_selected;
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), _action, _value );
                                break;
                        }
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                        _value = modified_property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ].getValue() || modified_property.last_list_element_selected;
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                                if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
                                    self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, "" );
                                    self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, "" );
                                }
                                else {
                                    self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName() ), _action, _value );
                                }
                                break;
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE_ALL_EXCEPT, _value );
                                break;
                        }
                        break;
                }
                switch ( _action_plus ) {
                    case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.OFF:
                    case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE:
                        self.doActionPlusForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName() ), _action_plus, PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE );
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                switch ( _action ) {
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                        self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                        _value = modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue();
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_SYNCHRO, modified_property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValue() );
                                break;
                        }
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                        _value = modified_property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ].getValue() || modified_property.last_list_element_selected;
                        switch ( _value ) {
                            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                                break;
                            default:
                                self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), self.getActionSynchronized( PROPERTY.CONST.MASS_CHANGE.ACTION.ADD ), _value );
                                break;
                        }
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                        self.doActionForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName(), modified_property.getName() ), PROPERTY.CONST.MASS_CHANGE.ACTION.NONE, '' );
                        break;
                }
                switch ( _action_plus ) {
                    case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON:
                        self.doActionPlusForAll( PROPERTY.UserRightsBehaviour.getSynchronizedProperty( modified_property.getName() ), _action_plus, PROPERTY.CONST.MASS_CHANGE.ACTION.ADD );
                        break;
                }
                break;
        }
        self.askAddActionConsistency();
    };
    self.getActionSynchronized               = function ( action ) {
        switch ( action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                return PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_SYNCHRO;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                return PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE_SYNCHRO;
        }
    };
    self.doActionForAll                      = function ( properties, action, value, extra_value ) {
        for ( var i = 0, _size_i = properties.length; i < _size_i; i++ ) {
            self.doActionFor( properties[ i ], action, value, extra_value );
        }
    };
    self.doActionPlusForAll                  = function ( properties, action_plus, default_action ) {
        for ( var i = 0, _size_i = properties.length; i < _size_i; i++ ) {
            self.doActionPlusFor( properties[ i ], action_plus, default_action );
        }
    };
    self.doActionPlusFor                     = function ( property, action_plus, default_action ) {
        if ( property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue() === action_plus ) {
            return;
        }
        if ( property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() === PROPERTY.CONST.MASS_CHANGE.ACTION.NONE ) {
            property.clickOnItemSelector( default_action, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
        }
        property.clickOnItemSelector( action_plus, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] );
    };
    self.doActionFor                         = function ( property, action, value, extra_value ) {
        property.clickOnItemSelector( action, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] );
        if ( value && value !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
            switch ( action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                    property.clickOnItemSelector( value, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ] );
                    if ( extra_value && extra_value !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                        property.clickOnItemSelector( extra_value, null, property.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ] );
                    }
                    break;
                default:
                    var _value = value.split( ',' );
                    for ( var i = 0, _size_i = _value.length; i < _size_i; i++ ) {
                        property.clickOnItemSelector( _value[ i ], null, property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ] );
                    }
            }
        }
    };
    self.askAddActionConsistency             = function ( property ) {
        if ( self._timeout_add_consistenct ) {
            clearTimeout( self._timeout_add_consistenct );
        }
        self._timeout_add_consistenct = setTimeout( function () {
            self.addActionConsistency( property );
            self._timeout_add_consistenct = null;
        }, 200 );
    };
    self.addActionConsistency                = function ( property ) {
        if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
            self.addActionConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACTS );
            self.addActionConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS );
        }
        else if ( property && property.getName() === PROPERTY.CONST.NAME.USE ) {
            self.addActionConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACTS );
            self.addActionConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS );
        }
    };
    self.addActionConsistencyFor             = function ( property_name ) {
        var _action = PROPERTY.CONST.MASS_CHANGE.ACTION.NONE;
        if ( self.showConsistencyFor( property_name ) ) {
            _action = PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_CONSISTENCY;
            MANAGER.__instance_window_distributor.parent_windows[ MANAGER.__instance_element_distributor.current_element.getUUID() ].pulsateElementIfNotActive( WINDOW.CONST.ELEMENT.USER_RIGHTS );
        }
        var _property = PROPERTY.UserRightsBehaviour._prop( property_name, property_name );
        self.doActionForAll( [_property], _action );
        self.finalyseViewForConsistency( _property, _action );
    };
    self.finalyseViewForConsistency          = function ( property, action ) {
        if ( action !== PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_CONSISTENCY ) {
            return;
        }
        property.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.CONSISTENCY_VALUE, null, property.selectors[ PROPERTY.CONST.SELECTOR.MAIN ] );
        var _main_selector = property.getSelector();
        _main_selector.getActiveListForUser().addTag( '', _main_selector.list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.CONSISTENCY_VALUE ) );
        
        var _synchronized_property = PROPERTY.UserRightsBehaviour.getSynchronizedProperty( property.synchronized_name );
        
        for ( var i = 0, _size_i = _main_selector.list_element_selected.tags.length; i < _size_i; i++ ) {
            var _dom_span       = _main_selector.list_element_selected.tags[ i ].dom_element.querySelector( ".shinken-property-synchronized" );
            _dom_span.innerHTML = _synchronized_property[ i ].getLabelViaDom();
        }
        var _properties_synchro_dom = document.querySelectorAll( '.shinken-mass-change-property-step .shinken-element-property-line[data-synchronized-name="' + property.synchronized_name + '"]' );
        for ( var j = 0, _size_j = _properties_synchro_dom.length; j < _size_j - 1; j++ ) {
            if ( _properties_synchro_dom[ j ].dataset.synchroName === property.synchronized_name ) {
                DOM.Service.switchElement( _properties_synchro_dom[ j ], _properties_synchro_dom[ _size_j - 1 ] );
                break;
            }
        }
    };
    self.showConsistencyFor                  = function ( property_name ) {
        var _to_analyse = self.getPropertyForComputeConsistencyFor( property_name );
        if ( property_name === PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ) {
            _to_analyse = SHINKEN.TOOLS.ARRAY.concat( _to_analyse, self.getPropertyForComputeConsistencyFor( PROPERTY.CONST.NAME.VIEW_CONTACTS ) );
        }
        for ( var i = 0, _size_i = _to_analyse.length; i < _size_i; i++ ) {
            if ( !_to_analyse[ i ].getDataToSave() ) {
                continue;
            }
            var _action = _to_analyse[ i ].selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_SYNCHRO:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE_SYNCHRO:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    return true;
            }
        }
        return false;
    };
    self.getPropertyForComputeConsistencyFor = function ( property_name ) {
        var _to_return = [];
        if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
            _to_return = SHINKEN.TOOLS.ARRAY.filterWith( MANAGER.__instance_property_distributor.getAllElements(), 'synchronized_name', property_name );
            _to_return.push( MANAGER.__instance_property_distributor.getElement( property_name ) );
            _to_return.push( MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ) );
        }
        else {
            _to_return.push( MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ) );
        }
        return _to_return;
    };
    return self;
})( PROPERTY.UserRightsBehaviourMassChange || {} );
PROPERTY.UserRightsBehaviour = (function ( self ) {
    self.has_everybody_default    = null;
    self._timeout_synchronization = {};
    self.askSynchronization       = function ( modified_property ) {
        if ( self._timeout_synchronization[ modified_property.getName() ] ) {
            clearTimeout( self._timeout_synchronization[ modified_property.getName() ] );
        }
        self._timeout_synchronization[ modified_property.getName() ] = setTimeout( function () {
            self.synchronization( modified_property );
            self._timeout_synchronization[ modified_property.getName() ] = false;
        }, 200 );
    };
    self.synchronization          = function ( modified_property ) {
        if ( modified_property.is_mass_change ) {
            return PROPERTY.UserRightsBehaviourMassChange.synchronization( modified_property );
        }
        var _flat_value = modified_property.getFlatValue();
        var _properties = self.getSynchronizedProperty( modified_property.getName() );
        var i;
        var _size_i;
        switch ( modified_property.getName() ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                if ( modified_property.getName() === PROPERTY.CONST.NAME.VIEW_CONTACTS ) {
                    if ( self.isViewEveryone() ) {
                        return;
                    }
                    self.askSynchronization( MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ) );
                }
                else if ( self.isViewEveryone() && !_flat_value ) {
                    return;
                }
                switch ( modified_property.last_list_element_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                        for ( i = 0, _size_i = _properties.length; i < _size_i; i++ ) {
                            _properties[ i ].clickOnItemSelector( modified_property.last_list_element_selected, null, _properties[ i ].getSelector() );
                        }
                        return;
                }
                this.addMissing( modified_property );
                if ( modified_property.state_plus === COMPONENT.CONST.BTN_STATE.OFF ) {
                    this.synchronizePlus( modified_property );
                }
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
                var _property = _properties[ 0 ];
                switch ( _property.getName() ) {
                    case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                        if ( self.isViewEveryone() ) {
                            return;
                        }
                        break;
                    case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                        if ( self.isViewEveryone() && !_property.getFlatValue() ) {
                            return;
                        }
                        break;
                }
                _property.synchronizeAtMinimum( modified_property );
                break;
        }
    };
    self.addMissing               = function ( modified_property, synchronized_property ) {
        var _flat_value    = modified_property.getFlatValue();
        var _value_present = SHINKEN.TOOLS.STRING.splitMultiselectValueWithNoPlus( _flat_value );
        var _size_i,
            i;
        var _properties    = synchronized_property ? [synchronized_property] : self.getSynchronizedProperty( modified_property.getName() );
        var _missing       = [];
        for ( i = 0, _size_i = _properties.length; i < _size_i; i++ ) {
            _missing = SHINKEN.TOOLS.ARRAY.concatUniqueIfNotPresentIn( _missing, SHINKEN.TOOLS.STRING.splitMultiselectValueWithNoPlus( _properties[ i ].getFlatValue() ), _value_present );
        }
        for ( i = 0, _size_i = _missing.length; i < _size_i; i++ ) {
            self.addValueTo( modified_property, _missing[ i ] );
        }
    };
    self.addValueTo               = function ( property, value ) {
        switch ( value ) {
            case '':
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                return;
        }
        var _element = property.getSelector().validOrCreateTag( value, property.name );
        if ( _element.is_selected && property.state !== PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
            return;
        }
        DOM.Service.askAddClass( property.dom_element, "shinken-synchronization", 2000 );
        property.clickOnItemSelector( _element.getName(), null, property.getSelector() );
        self.makeAnimationFor( property, value );
    };
    self.makeAnimationFor         = function ( property, value ) {
        var _synchronized_property = self.getSynchronizedProperty( property.getName() );
        var _current;
        var _current_tag;
        for ( var i = 0, _size_i = _synchronized_property.length; i < _size_i; i++ ) {
            _current     = _synchronized_property[ i ];
            _current_tag = _current.getSelector().pulsateTag( value );
        }
        MANAGER.__instance_window_distributor.parent_windows[ MANAGER.__instance_element_distributor.current_element.getUUID() ].pulsateElementIfNotActive( WINDOW.CONST.ELEMENT.USER_RIGHTS );
    };
    self.synchronizePlus          = function ( modified_property ) {
        var _properties = self.getSynchronizedProperty( modified_property.getName() );
        for ( var i = 0, _size_i = _properties.length; i < _size_i; i++ ) {
            if ( _properties[ i ].getName() === PROPERTY.CONST.NAME.VIEW_CONTACTS && self.isViewEveryone() ) {
                return;
            }
            if ( modified_property.state_plus !== _properties[ i ].state_plus ) {
                _properties[ i ].clickOnBtnPlus();
            }
        }
    };
    self.isViewEveryone           = function () {
        if ( !self.has_everybody_default ) {
            return false;
        }
        var _view_user_group_value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ).getFlatValue();
        if ( _view_user_group_value && _view_user_group_value !== PROPERTY.CONST.STATE_VALUE_PLUS.ON ) {
            return false;
        }
        var _view_user_value = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.VIEW_CONTACTS ).getFlatValue();
        return !_view_user_value || _view_user_value === PROPERTY.CONST.STATE_VALUE_PLUS.ON || _view_user_value === 'everyone';
    };
    self._prop                    = function ( property_name, synchro_name ) {
        if ( synchro_name ) {
            return MANAGER.__instance_property_distributor.findElement( property_name, false, false, false, synchro_name );
        }
        return MANAGER.__instance_property_distributor.getElement( property_name );
    };
    self.getSynchronizedProperty  = function ( property_name, is_synchro ) {
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
                return [self._prop( PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS, is_synchro ), self._prop( PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS, is_synchro )];
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                return [self._prop( PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS, is_synchro ), self._prop( PROPERTY.CONST.NAME.EDITION_CONTACTS, is_synchro )];
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
                return [self._prop( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS, is_synchro )];
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
                return [self._prop( PROPERTY.CONST.NAME.VIEW_CONTACTS, is_synchro )];
        }
    };
    return self;
})( PROPERTY.UserRightsBehaviour || {} );
PROPERTY.StringInput           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.StringInput.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input           = new COMPONENT.Input( dom_element.querySelector( ".shinken-input" ), this, false );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( this.name ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
        if ( this.getName() === PROPERTY.CONST.NAME.PREFIX ) {
            this.component_input.setExtraTooltip( _( "sync.extra_tooltip_rename_prefix" ) );
        }
    },
    askComputeAfterChange     : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange       : function ( args ) {
        if ( args[ 'validation_done' ] ) {
            this.setStateInheritance( !this.component_input.getValue() );
        }
        this._computeState();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    onFocus                   : function () {
        if ( this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED ) {
            this.component_input.dom_element.value = "";
        }
    },
    ___onFocusOut             : function () {
        var self = this;
        setTimeout( function () {
            if ( self.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED && !self.component_input.hasBeenChanged() ) {
                self.component_input.dom_element.value = self.component_input.original_value;
            }
        }, 500 );
    },
    _computeBtnInheritance    : function () {
        if ( this.state && this.component_btn_inheritance.getState() !== COMPONENT.CONST.BTN_STATE.INIT ) {
            return;
        }
        var _is_inheritable = !this.getValue();
        this.setStateInheritance( _is_inheritable );
        this.updateView();
    },
    ___updateView             : function () {
        this.component_input.updateView( this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON, true, false, this.component_btn_inheritance.isSet() );
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_override ) {
            if ( this.getValue() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
        }
        else if ( this.is_mass_change ) {
            _to_set     = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    break;
                default:
                    if ( this.getValue() ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    }
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.getValue() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    computeErrorsSpecifics    : function ( force_mass_change ) {
        this.component_input.validateValueInput();
    },
    setErrorsSpecific         : function () {
        this.counter_temp_error   = 0;
        this.counter_temp_warning = 0;
    },
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    setIsProtected            : function ( to_set ) {
        this.is_protected = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'isProtected', this.is_protected );
            this.component_input.setIsProtected( this.is_protected );
        }
    },
    ___unset                  : function () {
        this.setValueFromUser( "" );
        if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    this.component_input.setPlaceholder();
                    break;
                default:
                    this.component_input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                    break;
            }
        }
    },
    setValueFromUser          : function ( value ) {
        this.component_input.setValueFromJs( value );
        this.askComputeAfterChange();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    getValueInherited         : function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    getComponents             : function () {
        return [this.component_input];
    },
    updateWithTemplateSpecific: function () {
        this._computeState();
        this.component_input.need_validation = true;
        this.updateView();
    },
    cleanBeforeUpdate         : function () {
        this.component_input.setPlaceholder();
    },
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            default:
                if ( this.is_protected && this.component_input.hasBeenChanged() ) {
                    return SHINKEN.TOOLS.STRING.b64Encode( this.getValue() );
                }
                return SHINKEN.TOOLS.STRING.trimExtented( this.getValue() );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInput, PROPERTY.Interface );
PROPERTY.StringInputWithDropDown           = function ( dom_element ) {
    this.timeout_ask_compute_after_change;
    this.init( dom_element );
};
PROPERTY.StringInputWithDropDown.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input                           = new COMPONENT.InputWithDropDown( dom_element.querySelector( ".shinken-input-with-dropdown" ), this );
        this.selectors[ PROPERTY.CONST.SELECTOR.MAIN ] = this.component_input;
        this.component_btn_inheritance                 = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        if ( this.getName() === PROPERTY.CONST.NAME.PREFIX ) {
            this.component_input.setExtraTooltip( _( "sync.extra_tooltip_rename_prefix" ) );
        }
    },
    askComputeAfterChange     : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange       : function ( args ) {
        this.component_input.doActionAfterChange();
        this._computeState();
        if ( this.is_mass_change ) {
            MANAGER.ListenerEventManager.askAfterActionProperty( this );
        }
        fire_element_is_modifie();
    },
    clickOnInput              : function () {
        this.component_input.clickOnInput();
    },
    ___clickOnItemSelector    : function ( target_component, key_name ) {
        this.component_input.clickOnItemSelector( this.name, key_name );
        this._computeState();
    },
    ___hidePopup              : function ( exception ) {
        if ( exception !== this.component_input ) {
            this.component_input.hidePopup();
        }
    },
    keydown                   : function ( event, key_code ) {
        this.component_input.keydown( event, key_code );
    },
    _computeBtnInheritance    : function () {
        if ( this.state && this.component_btn_inheritance.getState() !== COMPONENT.CONST.BTN_STATE.INIT ) {
            return;
        }
        var _is_inheritable = !this.getValue();
        this.setStateInheritance( _is_inheritable );
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_mass_change ) {
            _to_set     = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    break;
                default:
                    if ( this.getValue() ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    }
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.getValue() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    ___updateView             : function () {
        this._computeState();
    },
    computeErrorsSpecifics    : function () {
        this.component_input.validateValueInput();
    },
    setErrorsSpecific         : function () {
        this.counter_temp_error   = this.component_input.error_number;
        this.counter_temp_warning = this.component_input.warning_number;
    },
    getSelector               : function () {
        return this.selectors[ PROPERTY.CONST.SELECTOR.MAIN ];
    },
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    ___unset                  : function () {
        this.setValueFromUser( "" );
        if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getLastSelectedElement().element.name;
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    this.component_input.input.setPlaceholder();
                    break;
                default:
                    this.component_input.input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                    break;
            }
        }
    },
    setValueFromUser          : function ( value ) {
        this.component_input.dom_element.value = value;
        this.askComputeAfterChange();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    getValueInherited         : function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    getValue                  : function () {
        return this.component_input.getValue();
    },
    updateWithTemplateSpecific: function () {
        this._computeState();
    },
    cleanBeforeUpdate         : function () {
        this.component_input.setPlaceholder();
    },
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            default:
                if ( this.is_protected && this.component_input.hasBeenChanged() ) {
                    return SHINKEN.TOOLS.STRING.b64Encode( this.getValue() );
                }
                return this.getValue();
        }
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputWithDropDown, PROPERTY.Interface );
var MAX_ARGS_DFE   = 16;
var FORCED_TO_NULL = '[' + _( 'element.forced_empty' ) + ']';
App.DFE = (function ( self, Scope ) {
    "use strict";
    
    var IMPORT_KEY_DEFAULT_VALUE          = "default_value";
    var DFE_ARG_SEPARATOR_OPENNING        = "$(";
    var DFE_ARG_SEPARATOR_CLOSING         = ")$";
    var DFE_ARG_SEPARATOR_OPENNING_LENGTH = DFE_ARG_SEPARATOR_OPENNING.length;
    
    self._size                   = 0;
    self._duplicateSplittedValue = {};
    self._duplicateOutputValue   = {};
    self._group_dfe              = {};
    
    self._timerAskDFE;
    self._timerAskBuildHTMLCheckTab;
    
    self.init                  = function () {
    };
    self.getSplittedDataSize   = function ( key ) {
        return self._duplicateSplittedValue[ key ]._dfe_elem.length;
    };
    self.getSplittedData       = function ( key ) {
        return self._duplicateSplittedValue[ key ];
    };
    self.getSplittedDataUnique = function ( key ) {
        var _dfe_split = self.getSplittedData( key );
        var _to_return = [];
        if ( _dfe_split ) {
            if ( _dfe_split._messages.hasError() ) {
                _current           = _dfe_split._dfe_elem[ 0 ];
                _current._messages = _dfe_split._messages;
                _to_return.push( _current );
                return _to_return;
            }
            var _current;
            var _mapping = {};
            for ( var i = 0; i < _dfe_split._size; i++ ) {
                _current = _dfe_split._dfe_elem[ i ];
                if ( _current.is_duplicate && _mapping[ _current.key ] ) {
                    continue;
                }
                _to_return.push( _current );
                _mapping[ _current.key ] = true;
            }
        }
        return _to_return;
    };
    self.getDefaultArgsByCheck = function ( splited_dfe, check ) {
        var _to_return              = splited_dfe;
        _to_return.args_interpreted = jQuery.extend( true, [], splited_dfe.args );
        
        if ( check[ IMPORT_KEY_DEFAULT_VALUE ] ) {
            var propertyName            = (Object.keys( splited_dfe ).length !== 0) ? splited_dfe.property_name : '';
            var _default_value_splitted = _splitDFE( propertyName, check[ IMPORT_KEY_DEFAULT_VALUE ], true );
            
            var _validation = self.validateDefaultValueGetError( _default_value_splitted );
            if ( _default_value_splitted._messages.hasError() || _default_value_splitted._dfe_elem[ 0 ]._messages.hasError() ) {
                console.warn( "[_default_value_splitted 1]", "La valeur par défaut du check n'est pas valide.", check[ IMPORT_KEY_DEFAULT_VALUE ], check[ 'check_command' ] );
                return _to_return;
            }
            if ( _validation._messages.hasError() ) {
                console.warn( "[_default_value_splitted 2]", "La valeur par défaut du check n'est pas valide.", check[ IMPORT_KEY_DEFAULT_VALUE ], check[ 'check_command' ] );
                return _to_return;
            }
            
            var listDefaultArgs     = _default_value_splitted._dfe_elem[ 0 ].args;
            var listDefaultArgsSize = listDefaultArgs.length;
            
            for ( var k = 0; k < listDefaultArgsSize && k < MAX_ARGS_DFE; k++ ) {
                var current_arg = splited_dfe.args[ k ];
                if ( !current_arg ) {
                    var arg                          = listDefaultArgs[ k ] || '';
                    var _splitted_data               = MANAGER.__instance_macro_distributor.splitCommand( arg );
                    var _label_final                 = MANAGER.__instance_macro_distributor.buildLabel( _splitted_data, true );
                    _to_return.args[ k ]             = arg;
                    _to_return.args_interpreted[ k ] = _label_final;
                }
            }
        }
        return _to_return;
    };
    
    function _analyseAndRemoveCommaInPara ( propertyValue, _indexes_comma, _size_indexes_comma ) {
        var _to_return            = {};
        var _messages             = new OBJECT.Messages();
        var _indexes_openning_arg = SHINKEN.TOOLS.STRING.indexesOf( propertyValue, DFE_ARG_SEPARATOR_OPENNING );
        var _indexes_closing_arg  = SHINKEN.TOOLS.STRING.indexesOf( propertyValue, DFE_ARG_SEPARATOR_CLOSING );
        var _size_opening_arg     = _indexes_openning_arg.length;
        var _size_closing_arg     = _indexes_closing_arg.length;
        
        var _current_index;
        if ( _size_opening_arg !== _size_closing_arg ) {
            _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_odd_separator' ) );
        }
        else {
            for ( var i = 0; i < _size_opening_arg; i++ ) {
                var _index_openning_arg = _indexes_openning_arg[ i ];
                var _index_closing_arg  = _indexes_closing_arg[ i ];
                
                if ( i > 0 && _index_openning_arg - _indexes_closing_arg[ i - 1 ] < 2 ) {
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, Scope.format( _( 'element.tooltip_dfe_incomplete_tag' ), (i + 1) ) );
                    break;
                }
                else if ( _index_openning_arg < _index_closing_arg ) {
                    for ( var j = _size_indexes_comma - 1; j >= 0; j-- ) {
                        _current_index = _indexes_comma[ j ];
                        if ( _current_index > _index_openning_arg && _current_index < _index_closing_arg ) {
                            _indexes_comma.splice( j, 1 );
                            _size_indexes_comma--;
                        }
                    }
                }
                else {
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, Scope.format( _( 'element.tooltip_dfe_reverse_tag' ), (i + 1) ) );
                    break;
                }
            }
        }
        _to_return._indexes_comma = _indexes_comma;
        _to_return._messages      = _messages;
        return _to_return;
    }
    
    function _splittedKeyParam ( dfe, index, is_default ) {
        var _indexes_openning_arg = SHINKEN.TOOLS.STRING.indexesOf( dfe, DFE_ARG_SEPARATOR_OPENNING );
        
        var _temp = SHINKEN.TOOLS.STRING.splitWithIndexes( dfe, _indexes_openning_arg, DFE_ARG_SEPARATOR_OPENNING_LENGTH );
        
        var _size = _temp.length;
        
        for ( var i = 0; i < _size; i++ ) {
            _temp[ i ] = _temp[ i ].split( DFE_ARG_SEPARATOR_CLOSING );
        }
        
        var _to_return        = {};
        _to_return.key        = SHINKEN.TOOLS.STRING.trim( _temp[ 0 ][ 0 ] );
        _to_return.args       = [];
        _to_return._messages  = new OBJECT.Messages();
        _to_return._size_args = _size - 1;
        
        if ( _to_return.key && is_default ) {
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, App.Scope.format( _( 'element.tooltip_default_arf_dfe_with_key' ), (index + 1) ) );
        }
        else if ( !_to_return.key && !is_default ) {
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, App.Scope.format( _( 'element.tooltip_dfe_empty_key' ), (index + 1) ) );
        }
        
        var hasUnknownValue   = false;
        var hasBackToLineChar = false;
        var getUnknownValue   = [];
        
        for ( var i = 1; i < _size; i++ ) {
            _to_return.args[ i - 1 ] = _temp[ i ][ 0 ];
            if ( _temp[ i ][ 1 ] && !SHINKEN.TOOLS.STRING.isEmpty( _temp[ i ][ 1 ] ) ) {
                hasUnknownValue = true;
                getUnknownValue.push( '<span class=\'text-warning\'>' + _temp[ i ][ 1 ] + '</span>' );
            }
            else if ( _temp[ i ][ 1 ] && SHINKEN.TOOLS.STRING.containsCharCode( _temp[ i ][ 1 ], SHINKEN.TOOLS.STRING.CONST.CHAR_CODE_BACK_TO_LINE ) ) {
                hasBackToLineChar = true;
            }
            else {
                var _number$ = SHINKEN.TOOLS.STRING.getNumberOccurence( _temp[ i ][ 0 ], '$' );
                if ( _number$ === 1 ) {
                    _to_return._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, App.Scope.format( _( 'element.tooltip_dfe_unpair_$_number' ), '<span class="text-warning">' + _temp[ i ][ 0 ] + '</span>' ) );
                }
                else if ( _number$ % 2 ) {
                    _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, App.Scope.format( _( 'element.tooltip_dfe_unpair_$_number_2' ), '<span class="text-warning">' + _temp[ i ][ 0 ] + '</span>' ) );
                }
            }
        }
        
        if ( hasUnknownValue ) {
            var plural = (getUnknownValue.length > 1) ? 's' : '';
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, App.Scope.format( _( 'element.tooltip_dfe_unknown_value' + plural ), getUnknownValue.join( ' , ' ) ) );
        }
        if ( hasBackToLineChar ) {
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_back_to_line_before_comma' ) );
        }
        return _to_return;
    }
    
    function _setDuplicateKey ( listDfe ) {
        var _values = [];
        var _current;
        var _size   = listDfe.length;
        for ( var i = 0; i < _size; i++ ) {
            _current     = listDfe[ i ];
            _values[ i ] = _current.key;
            for ( var j = 0; j < i; j++ ) {
                if ( _values[ j ] === _current.key ) {
                    _current.is_duplicate     = true;
                    listDfe[ j ].is_duplicate = true;
                    break;
                }
            }
        }
        return listDfe;
    }
    
    self.splitDFE = function ( propertyName, propertyValue, is_default ) {
        return _splitDFE( propertyName, propertyValue, is_default );
    };
    
    function _splitDFE ( propertyName, propertyValue, is_default ) {
        var _to_return = {};
        
        if ( propertyValue === 'null' || propertyValue === FORCED_TO_NULL ) {
            propertyValue = '';
        }
        
        var _indexes_comma      = SHINKEN.TOOLS.STRING.indexesOf( propertyValue, ',' );
        var _size_indexes_comma = _indexes_comma.length;
        
        var _temp_return;
        _temp_return         = _analyseAndRemoveCommaInPara( propertyValue, _indexes_comma, _size_indexes_comma );
        _to_return._messages = _temp_return._messages;
        _indexes_comma       = _temp_return._indexes_comma;
        var _dfe_elem        = SHINKEN.TOOLS.STRING.splitWithIndexes( propertyValue, _indexes_comma );
        
        _to_return._size = _dfe_elem.length;
        
        if ( is_default && _to_return._size > 1 ) {
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_default_arf_dfe_multi' ) );
        }
        if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( propertyName ) ) {
            _to_return._size = 1;
        }
        for ( var i = 0; i < _to_return._size; i++ ) {
            _dfe_elem[ i ]               = _splittedKeyParam( _dfe_elem[ i ], i, is_default );
            _dfe_elem[ i ].property_name = propertyName;
        }
        
        _dfe_elem = _setDuplicateKey( _dfe_elem );
        
        _to_return._dfe_elem = _dfe_elem;
        
        return _to_return;
    }
    
    self.getMessageDeletedElements = function ( new_split, old_split, check_ids ) {
        var _keys_new = SHINKEN.TOOLS.ARRAY.extractKey( new_split, 'key' );
        var _keys_old = SHINKEN.TOOLS.ARRAY.extractKey( old_split, 'key' );
        _keys_new.sort();
        _keys_old.sort();
        var _to_return  = [];
        var _current_check;
        var _size_check = check_ids.length;
        for ( var i = 0, _size_i = _keys_old.length; i < _size_i; i++ ) {
            if ( !SHINKEN.TOOLS.ARRAY.contains( _keys_new, _keys_old[ i ] ) ) {
                var _key_escape = SHINKEN.TOOLS.STRING.cleanXss(_keys_old[ i ]);
                var _html_name = '';
                for ( var j = 0; j < _size_check; j++ ) {
                    _current_check = MANAGER.__instance_element_distributor.getElement( "core-service-" + check_ids[ j ] );
                    _html_name += "<li class='shinken-font-xs'>" + _current_check.getName().replace( '$KEY$',  _key_escape) + "</li>";
                }
                _to_return.push( new OBJECT.Message( COMPONENT.CONST.STATUS.BEWARE, '<span class="shinken-between-bracket shinken-icon-error">' + _key_escape + "</span><ul>" + _html_name + "</ul>" ) );
            }
        }
        var _size_deleted = _to_return.length;
        if ( !_size_deleted ) {
            return null;
        }
        return _to_return;
    };
    self.setOutputDFE              = function ( splitted, name, template_name ) {
        return _setOutputDFE( splitted, name, template_name );
    };
    
    function _setOutputDFE ( splitted, name, template_name ) {
        var _current;
        
        var _to_return = new OBJECT.Messages();
        
        if ( splitted._messages.hasError() ) {
            _to_return = splitted._messages;
        }
        else {
            if ( splitted._messages.hasWarning() ) {
                _to_return = splitted._messages;
            }
            for ( var i = 0; i < splitted._size; i++ ) {
                _current = splitted._dfe_elem[ i ];
                
                if ( _current._messages.hasError() ) {
                    _to_return.addMessages( _current._messages.messages_error );
                }
                else if ( _current._messages.hasWarning() ) {
                    _to_return.addMessages( _current._messages.messages_warning );
                    
                }
            }
        }
        
        _to_return.message = _to_return.buildMessage( false, template_name );
        if ( name ) {
            self._duplicateOutputValue[ name ] = _to_return;
        }
        
        return _to_return;
    }
    
    self.validatorDFE = function ( splitted ) {
        return _validatorDFE( splitted );
    };
    
    function _validatorDFE ( splitted ) {
        var number_empty_args;
        var _current;
        
        var _to_return = splitted;
        var _value;
        
        
        for ( var i = 0; i < _to_return._size; i++ ) {
            _current          = _to_return._dfe_elem[ i ];
            number_empty_args = 0;
            if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( _current.property_name ) ) {
                _current.is_dfe_protected = true;
                _current._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, _( 'element.tooltip_dfe_encrypted_data_has_value' ) );
                continue;
            }
            _value = _current.key.replace( PROPERTY.CONST.VALIDATOR.REGEXS.key_data, "" );
            if ( _value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_check ) ) {
                _current._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, ' ~!%^&*\"\'|<>?,()=+' ) );
            }
            else if ( _value.match( '[$]' ) ) {
                _current._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_dollar' ) );
            }
            for ( var j = 0; j < _current._size_args; j++ ) {
                if ( SHINKEN.TOOLS.STRING.isEmpty( _current.args[ j ] ) ) {
                    number_empty_args++;
                }
                
            }
            if ( number_empty_args ) {
                _current._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, number_empty_args === 1 ? _( 'element.tooltip_dfe_empty_arg' ) : _( 'element.tooltip_dfe_empty_args' ) );
            }
            
            if ( _current.is_duplicate ) {
                _current._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_same_key' ) );
            }
        }
        
        
        return _to_return;
    }
    
    self.validateDefaultValueGetError = function ( _split ) {
        
        var _to_return = { valid_type: COMPONENT.CONST.STATUS.NONE, _messages: new OBJECT.Messages() };
        
        var _current     = _split._dfe_elem[ 0 ];
        var _args_length = _current._size_args;
        
        var number_empty_args = 0;
        
        if ( _split._messages.hasError() ) {
            
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages  = _split._messages;
        }
        else if ( _split._size > 1 ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_check_comma_not_allowed' ) );
        }
        else if ( (_current.key && _args_length) || _current.error ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_check_not_between_tag' ) );
        }
        else if ( _current._messages.hasError() ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages  = _current._messages;
        }
        else if ( _split._messages.hasWarning() ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages  = _split._messages;
        }
        else if ( _current.key ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.WARNING;
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, _( 'element.tooltip_dfe_check_not_between_tag' ) );
        }
        else {
            number_empty_args = 0;
            for ( var i = 0; i < _args_length; i++ ) {
                if ( !_current.args[ i ] ) {
                    number_empty_args++;
                }
            }
            if ( number_empty_args ) {
                _to_return.valid_type = COMPONENT.CONST.STATUS.WARNING;
                var _message          = number_empty_args === 1 ? _( 'element.tooltip_dfe_empty_arg' ) : _( 'element.tooltip_dfe_empty_args' );
                _to_return._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, _message );
            }
        }
        
        return _to_return;
    };
    
    self.getKey = function ( v ) {
        v = (v) ? v : ''; // Default
        v = v.replace( /\s/g, '' );
        v = v.replace( /^(\$_SERVICE|\$_HOST|\$_CONTACT)/gi, '' );
        v = v.replace( /\$/g, '' );
        
        if ( v[ 0 ] != '_' ) {
            v = '_' + v;
        }
        return cleanString( v );
    };
    
    function cleanString ( val ) {
        val     = val + ''; // Convert in string :)
        var exp = (/([^a-z0-9\-_])/gi);
        return val.replace( exp, '' ).toUpperCase();
    }
    
    return self;
})( App.DFE || {}, App.Scope || {} );
CONTROLLER.Help = (function ( self ) {
    "use strict";
    self._dom_element_help = null;
    self.toggleHelp        = function ( event ) {
        event.preventDefault();
        event.stopPropagation();
        if ( !self._dom_element_help ) {
            self._dom_element_help = document.getElementById( 'id-shinken-help-pop-up' );
            self._dom_element_help.classList.remove( 'shinken-hidden' );
            return;
        }
        self._dom_element_help.classList.toggle( 'shinken-hidden' );
    };
    self.closeHelp         = function () {
        if ( !self._dom_element_help ) {
            return;
        }
        self._dom_element_help.classList.add( 'shinken-hidden' );
    };
    return self;
})( CONTROLLER.Help || {} );
MANAGER.HelpGenerator = (function ( self ) {
    "use strict";
    self.content                   = [];
    self.size                      = 0;
    self.init                      = function ( class_to_add ) {
        self.initContent();
        if ( !self.size ) {
            return;
        }
        self.buildButtonHtml();
        self.buildContentHtml( class_to_add );
        self.initEventListener();
    };
    self.initContent               = function () {
        var _found = document.querySelectorAll( ".shinken-help-container .shinken-help-content" );
        for ( var i = 0, _size_i = _found.length; i < _size_i; i++ ) {
            self.content.push( new OBJECT.Help( _found[ i ] ) );
            DOM.Service.removeElement( _found[ i ] );
        }
        self.size    = self.content.length;
        self.content = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( self.content, [ "order_tab", "name_tab", "order" ] );
    };
    self.initEventListener         = function () {
        document.addEventListener( 'keydown', function ( event ) {
            MANAGER.EventManager.keydown( event );
        } );
    };
    self.buildButtonHtml           = function () {
        var _button_f1       = DOM.Service.createElement( 'div', { class: "shinken-help-button-container", onclick: "CONTROLLER.Help.toggleHelp(event)", 'data-name': "toggle_help" } );
        _button_f1.innerHTML = '<button class="shinken-button"><table><tr><td><span class="key">F1</span></td><td>' + _( 'common.help.label' ) + '</td></tr></table></button>';
        document.body.appendChild( _button_f1 );
    };
    self.buildContentHtml          = function (class_to_add) {
        var _content_to_html  = DOM.Service.createElement( 'div', {
            id     : "id-shinken-help-pop-up",
            class  : "shinken-hidden " + class_to_add,
            onclick: "MANAGER.EventManager.stopPropagation(event)"
        } );
        var _container_html   = DOM.Service.createElement( 'div', { class: "shinken-help-container" } );
        var _container_html_2 = DOM.Service.createElement( 'div', { class: "shinken-help-container-2" } );
        var _container_html_3 = DOM.Service.createElement( 'div', { class: "shinken-help-container-3" },
            "<div class='shinken-text-centred'><div class='shinken-help-title'>" + _( 'common.help.label' ) + "</div></div>" );
        var _current_tab;
        var _current_tab_name = "";
        for ( var i = 0, _size_i = self.size; i < _size_i; i++ ) {
            if ( _current_tab_name !== self.content[ i ].tab ) {
                _current_tab_name = self.content[ i ].tab;
                _current_tab      = WINDOW.ElementService.getWindowTargetHtml( 'div', _current_tab_name, !i );
                _container_html_3.appendChild( _current_tab );
            }
            _current_tab.appendChild( self.content[ i ].getHtml() );
        }
        _content_to_html.appendChild( _container_html );
        _container_html.appendChild( _container_html_2 );
        _container_html_2.appendChild( self.buildWindowsLineHtml() );
        _container_html_2.appendChild( _container_html_3 );
        document.body.appendChild( _content_to_html );
        document.body.appendChild( _content_to_html );
    };
    self.buildWindowsLineHtml      = function () {
        var _to_return = DOM.Service.createElement( 'div', {
            class      : "shinken-help-windows-title-menu shinken-window-group",
            "data-name": "help-group",
            onclick    : "MANAGER.EventManager.clickOnWindowNavigation(event,'help-group')"
        } );
        var _tab_list  = SHINKEN.TOOLS.ARRAY.extractKeys( this.content, [ 'tab', 'name_tab' ], true, true );
        _tab_list      = SHINKEN.TOOLS.ARRAY.removeDuplicateArray( _tab_list );
        _tab_list      = self.concatDuplicationWindowID( _tab_list );
        var _current;
        for ( var i = 0, _size_i = _tab_list.length; i < _size_i; i++ ) {
            _current = _tab_list[ i ];
            _to_return.appendChild( WINDOW.ElementService.getWindowHtml( "div", _current[ 0 ], _current[ 1 ], "help-group", !i ) );
        }
        var _button_close = DOM.Service.createElement( 'div', { class: "shinken-help-close-button shinkon-times-bold", onclick: "CONTROLLER.Help.toggleHelp(event)" } );
        _to_return.appendChild( _button_close );
        return _to_return;
    };
    self.concatDuplicationWindowID = function ( tab_list ) {
        var _to_return = [];
        var _mapping   = {};
        var _current;
        var _index;
        for ( var i = 0, _size_i = tab_list.length; i < _size_i; i++ ) {
            _current = tab_list[ i ];
            if ( _mapping[ _current[ 0 ] ] ) {
                _index                    = _mapping[ _current[ 0 ] ] - 1;
                _to_return[ _index ][ 1 ] = _to_return[ _index ][ 1 ] + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE + _current[ 1 ];
            }
            else {
                _mapping[ _current[ 0 ] ] = _to_return.push( _current );
            }
        }
        return _to_return;
    };
    return self;
})( MANAGER.HelpGenerator || {} );
OBJECT.Help = function ( dom_element ) {
    this.dom_element = dom_element;
    this.tab         = dom_element.dataset.tab;
    this.order       = parseInt( dom_element.dataset.order ) || 1;
    this.order_tab   = parseInt( dom_element.dataset.tabOrder ) || 1;
    this.name_tab    = dom_element.dataset.tabName || "??";
};
OBJECT.Help.prototype = {
    getHtml: function () {
        return this.dom_element;
    }
};
SHINKEN.TRY_CHECK = (function ( self ) {
    "use strict";
    
    self.tryCheck                    = function ( check_in_page_host, is_exec, is_on_poller ) {
        var _id = check_in_page_host.getDomUUID();
        get_spinner( 'spinner-check-run-' + _id );
        var _current_obj              = get_current_object();
        var _macromodulations_on_host = MANAGER.__instance_property_distributor.getElement( 'macromodulations' );
        _current_obj.macromodulations = _macromodulations_on_host.getValueAndValueInherited();
        
        var _dfe = "";
        if ( check_in_page_host.key_dfe ) {
            _dfe = check_in_page_host.dfe_object;
            delete _dfe[ "_messages" ];
        }
        
        var _obj_string = JSON.stringify( _current_obj );
        var _host_type  = MANAGER.__instance_element_distributor.current_element.getType();
        
        $.ajax( {
            type   : "POST",
            data   : {
                host     : _obj_string,
                item_type: _host_type,
                check_id : check_in_page_host.uuid,
                do_exec  : is_exec,
                on_poller: is_on_poller,
                dfe      : JSON.stringify( _dfe )
            },
            url    : '/element/run?ts=' + Date.now(),
            success: function ( results ) {
                _displayTryCheckResult( check_in_page_host, results, is_exec );
            },
            error  : function ( data, txt ) {
                var _dom_element_content_try_check = document.getElementById( 'result-check-run-' + _id );
                var _dom_element_spinner           = document.getElementById( 'spinner-check-run-' + _id );
                DOM.Service.empty( _dom_element_spinner );
                check_in_page_host.dom_element_try_check_container.classList.remove( 'shinken-hidden' );
                check_in_page_host.dom_element.querySelector( '.shinken-hide-eval' ).classList.remove( 'shinken-hide-eval-hidden' );
                var _text = data.statusText;
                if ( !data.status ) {
                    _text = _( 'element.backend_unreacheable' );
                }
                _dom_element_content_try_check.innerHTML = '<span class="span12 alert alert-error">' + _text + '</span>';
            }
        } );
    };
    var _displayTryCheckResult       = function ( check_in_page_host, results, _is_exec ) {
        var _id                            = check_in_page_host.getDomUUID();
        var _dom_element_tr_try_check      = document.getElementById( 'tr-check-run-' + _id );
        var _dom_element_tr_check_line     = document.getElementById( 'id-shinken-check-line-' + _id );
        var _dom_element_content_try_check = document.getElementById( 'result-check-run-' + _id );
        var _dom_element_spinner           = document.getElementById( 'spinner-check-run-' + _id );
        DOM.Service.empty( _dom_element_spinner );
        
        var _macros = results.macros;
        
        _dom_element_tr_try_check.classList.remove( 'shinken-hidden' );
        _dom_element_tr_check_line.querySelector( '.shinken-hide-eval' ).classList.remove( 'shinken-hide-eval-hidden' );
        DOM.Service.empty( _dom_element_content_try_check );
        
        if ( results.error ) {
            _dom_element_content_try_check.innerHTML = '<span class="span12 alert alert-error">' + results.error + '</span>';
            return;
        }
        
        var $commandContainer = $( '<div class="shinken-block-container-try-check shinken-try-check-command-container">' );
        var $commandContent   = $( '<div class="content">' );
        $commandContainer.append( '<h4>' + _( 'element.command_line' ) + ': </h4>' );
        /***************************
         * EVALUATION
         ***************************/
        var $evaluationContainer = $( '<div class="shinken-block-container-try-check shinken-try-check-evaluation-container">' );
        var $evaluationContent   = $( '<div class="content">' );
        $evaluationContent.append( '<span class="title">' + _( 'element.args' ) + ':</span>' );
        
        if ( _macros.length > 0 ) {
            $evaluationContainer.append( '<h4>' + _( 'element.evaluation' ) + ': </h4>' );
            var $tableData = _createMacroEvaluationTable( _macros );
            $evaluationContent.append( $tableData );
            
            var cmd_line_expanded                   = results.expanded_command_line;
            var password_protected_display          = '<span class="shinken-protected-password">' + _( 'element.password_protected' ) + '</span>';
            var __missing_argn_display              = '';
            var __unknown_data_display              = '';
            var __missing_duplicate_foreach_display = '<span class="missing-evaluated-value">' + _( 'element.missing_dfe' ) + '</span>';
            var __missing_global_display            = '<span class="missing-evaluated-value">' + _( 'element.missing_global' ) + '</span>';
            
            cmd_line_expanded = cmd_line_expanded.replace( REGEXS.MISSING_ARGN, __missing_argn_display )
                                                 .replace( REGEXS.UNKNOWN_DATA, __unknown_data_display )
                                                 .replace( REGEXS.MISSING_DFE, __missing_duplicate_foreach_display )
                                                 .replace( REGEXS.MISSING_GLOBAL, __missing_global_display );
            cmd_line_expanded = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss( cmd_line_expanded );
            cmd_line_expanded = cmd_line_expanded.replace( REGEXS.PROTECTED_PASSWORD, password_protected_display );
            
            if ( results.command_line !== cmd_line_expanded ) {
                $evaluationContent.append( '<span class="title">' + _( 'element.command_line_data' ) + ':</span>' );
                $evaluationContent.append( '<div class="code"><p>' + cmd_line_expanded + '</p></div>' );
            }
            
            $evaluationContainer.append( $evaluationContent );
        }
        else {
            $evaluationContainer.append( '<h4>' + _( 'element.evaluation' ) + ': <span>' + _( 'element.evaluation_no_data' ) + '</span></h4>' );
        }
        
        var raw_command_line_html = _create_raw_command_line( results.command_line, _macros );
        $commandContent.append( raw_command_line_html );
        $commandContainer.append( $commandContent );
        _dom_element_content_try_check.appendChild( $commandContainer[ 0 ] );
        
        _dom_element_content_try_check.appendChild( $evaluationContainer[ 0 ] );
        
        /***************************
         * EXECUTION
         ***************************/
        
        _dom_element_content_try_check.appendChild( _createExecutionContainer( results, _is_exec ) );
        
        _dom_element_tr_try_check.classList.remove( 'shinken-hidden' );
        
    };
    var _createExecutionContainer    = function ( results, _is_exec ) {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-block-container-try-check" } );
        if ( !_is_exec ) {
            _to_return.appendChild( DOM.Service.createElement( "h4", {}, _( 'element.execution' ) + ' : <span>' + _( 'element.not_asked' ) + '</span>' ) );
            return _to_return;
        }
        
        
        results.execution.stdout = results.execution.stdout
                                          .replace( REGEXS.MISSING_ARGN, '' )
                                          .replace( REGEXS.UNKNOWN_DATA, '' )
                                          .replace( REGEXS.MISSING_DFE, '' )
                                          .replace( REGEXS.MISSING_GLOBAL, '' );
        
        _to_return.appendChild( DOM.Service.createElement( "h4", {}, _( 'element.execution' ) + _( 'element.execution_on_the_' + results.execution.executor_type ) + '[ <span class="executor_name">' + results.execution.executor_name + '</span> ] :' ) );
        
        var _has_result_modulation   = !!results[ 'resultmodulations' ];
        var _has_matching_modulation = _has_result_modulation && !!results[ 'applied_resultmodulation' ][ 'name' ];
        
        var _content = DOM.Service.createElement( "div", { class: "content" } );
        
        
        if ( _has_result_modulation ) {
            _content.appendChild( DOM.Service.createElement( "div", { class: "title" }, _( 'element.normal_execution' ) ) );
        }
        _content.appendChild( drawExecutionTable( results.execution.rc, results.execution.stdout, results.execution.shell_execution, results.execution.execution_time.toFixed( 3 ), results.execution.output, results.execution.long_output, results.execution.perf_data, 'shinken-execution-table' )[ 0 ] );
        if ( !_has_result_modulation ) {
            _to_return.appendChild( _content );
            return _to_return;
        }
        var _trad_modulation_matching;
        if ( _has_matching_modulation ) {
            _trad_modulation_matching = results[ 'applied_resultmodulation' ][ 'origin' ] === 'hosts' ? _( 'element.resultmodulation_match_on_host' ) : _( 'element.resultmodulation_match' );
        }
        else {
            _trad_modulation_matching = results[ 'applied_resultmodulation' ][ 'origin' ] === 'hosts' ? _( 'element.resultmodulation_no_match_on_host' ) : _( 'element.resultmodulation_no_match' );
        }
        
        _content.appendChild( DOM.Service.createElement( "div", { class: "title" }, _( 'type.resultmodulation' ) + ': <span class="high">' + _trad_modulation_matching + '</span>' ) );
        _createResultModulationTable( results, _has_matching_modulation, _content );
        
        if ( _has_matching_modulation ) {
            _content.appendChild( DOM.Service.createElement( "div", { class: "title" }, _( 'element.execution_with_modulation' ) + ':' ) );
            _content.appendChild( drawExecutionTable( results.applied_resultmodulation.rc, results.execution.stdout, results.execution.shell_execution, results.execution.execution_time.toFixed( 3 ), results.execution.output, results.execution.long_output, results.execution.perf_data, 'shinken-matching-modulation' )[ 0 ] );
        }
        _to_return.appendChild( _content );
        return _to_return;
    };
    var _createTagTimePeriod         = function ( time_period, modulation ) {
        var _tooltip = {};
        if ( time_period.isNew() ) {
            _tooltip[ 'shi-tip-html' ] = _( 'element.tooltip_timeperiod_new' );
            modulation._class_try_check_period += ' shinken-new';
        }
        else if ( modulation._class_try_check_period === 'shinken-inactive' ) {
            _tooltip[ 'shi-tip-html' ] = _( 'element.tooltip_timeperiod_out_time' );
        }
        else {
            _tooltip[ 'shi-tip-html' ]      = time_period.getName();
            _tooltip[ 'shi-tip-condition' ] = SHINKEN_TOOLTIP.CONDITION.ELLIPSIS;
            _tooltip[ 'shi-tip-class' ]     = 'shinken-space';
        }
        var _title = DOM.Service.createElement( 'span', { class: 'tag-timeperiod tag-block ' + modulation._class_try_check_period } );
        var _link  = DOM.Service.createElement( 'span', { class: 'shinken-link-title' }, time_period.getName() );
        DOM.Service.addTooltip( _link, _tooltip );
        _title.appendChild( DOM.Service.createElement( 'i', { class: 'icon-time' } ) );
        _title.appendChild( _link );
        return SHINKEN.TOOLS.buildLinkShinkenElement( time_period, _title.outerHTML );
    };
    var _createResultModulationTable = function ( results, modulationHasMatch, $executionContent ) {
        var _current_modulation;
        var _current_modulation_from_result;
        var _current_time_period;
        var _current_name;
        
        var _to_return = DOM.Service.createElement( "div", { class: 'shinken-content-modulation' } );
        for ( var i = 0, _size = results[ PROPERTY.CONST.NAME.RESULT_MODULATIONS ].length; i < _size; i++ ) {
            _current_modulation_from_result = results[ PROPERTY.CONST.NAME.RESULT_MODULATIONS ][ i ];
            _current_name                   = _current_modulation_from_result.item[ 'resultmodulation_name' ];
            _current_modulation             = MANAGER.__instance_element_distributor.getElementByName( _current_name );
            _current_time_period            = MANAGER.__instance_element_distributor.getElementByName( _current_modulation[ 'modulation_period' ] );
            
            _current_modulation._class_try_check          = '';
            _current_modulation.is_try_check_table_active = true;
            if ( results[ 'applied_resultmodulation' ][ 'name' ] === _current_modulation.getName() ) {
                _current_modulation._class_try_check = 'active';
            }
            else {
                _current_modulation.is_try_check_table_active = false;
            }
            
            var nbr        = _size > 1 ? 50 : 100;
            var marginSize = (i + 1 == _size) ? 0 : 10;
            var _block_mod = DOM.Service.createElement( "div", { class: 'block-modulation', style: 'width: calc(' + nbr + '% - ' + marginSize + 'px); margin-right: ' + marginSize + 'px;' } );
            
            if ( !_current_modulation.is_enabled ) {
                _current_modulation._class_try_check          = 'shinken-disabled';
                _current_modulation.is_try_check_table_active = false;
            }
            else if ( _current_modulation.is_new ) {
                _current_modulation._class_try_check = 'new';
            }
            
            var hasMissingModulation = !!_current_modulation_from_result[ 'missing' ];
            
            var rules = _current_modulation_from_result.rules || [];
            
            if ( _current_time_period ) {
                if ( _current_modulation_from_result[ 'timeperiod' ][ 'eval' ] ) {
                    _current_modulation._class_try_check_period = 'active';
                }
                else {
                    _current_modulation._class_try_check_period   = 'shinken-inactive';
                    _current_modulation.is_try_check_table_active = false;
                }
            }
            var _class = "table-rule-result table-hover table-striped table-bordered";
            if ( !_current_modulation.is_try_check_table_active ) {
                _class += " opacity";
            }
            var _table_rules      = DOM.Service.createElement( "table", { class: _class } );
            var _table_rules_head = DOM.Service.createElement( "thead", { style: 'background-color: #C2C2C2;' }, '' );
            _table_rules_head.appendChild( DOM.Service.createElement( "th", { class: 'col-status', colspan: 2 }, _( 'resultmodulations.status_match' ) ) );
            _table_rules_head.appendChild( DOM.Service.createElement( "th", { class: 'col-pattern', colspan: 2 }, _( 'resultmodulations.output_re_match' ) ) );
            _table_rules_head.appendChild( DOM.Service.createElement( "th", { class: 'col-status-out', colspan: 2 }, _( 'resultmodulations.status_result' ) ) );
            var _table_rules_body = DOM.Service.createElement( "tbody" );
            
            var _tag;
            if ( !hasMissingModulation ) {
                _tag = DOM.Service.createElement( 'div', {
                    class: 'shinken-tag-modulation tag-block shinken-space ' + _current_modulation._class_try_check
                }, _current_modulation.getName() );
                if ( !_current_modulation.is_enabled ) {
                    DOM.Service.addTooltip( _tag, { 'shi-tip-html': _( 'element.tooltip_resultmodulation_disabled' ) } );
                }
                else if ( _current_modulation.is_new ) {
                    DOM.Service.addTooltip( _tag, { 'shi-tip-html': _( 'element.tooltip_resultmodulation_new' ) } );
                }
                else {
                    DOM.Service.addTooltip( _tag, { 'shi-tip-html': _current_modulation.getName(), 'shi-tip-condition': SHINKEN_TOOLTIP.CONDITION.ELLIPSIS, 'shi-tip-class': 'shinken-space' } );
                }
                var _link = SHINKEN.TOOLS.buildLinkShinkenElement( _current_modulation, _tag.outerHTML );
                _block_mod.appendChild( _link );
                if ( _current_time_period ) {
                    _block_mod.appendChild( _createTagTimePeriod( _current_time_period, _current_modulation ) );
                }
                for ( var k = 0, kl = rules.length; k < kl; k++ ) {
                    var rule = rules[ k ];
                    
                    rule.in_state  = changeNbStatusToLabel( rule.in_state );
                    rule.out_state = changeNbStatusToLabel( rule.out_state );
                    rule.pattern   = (rule.pattern != null) ? rule.pattern : '';
                    
                    var hasMatch = '';
                    if ( rule.in_state_eval === 'true' && rule.pattern_eval === 'true' ) {
                        hasMatch                 = 'active';
                        rule[ 'out_state_eval' ] = true;
                    }
                    else {
                        rule[ 'out_state_eval' ] = false;
                    }
                    
                    var _rule_dom = DOM.Service.createElement( "tr", { class: hasMatch } );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-icon " + getIconClass( rule.in_state_eval ) }, getIcon( rule.in_state_eval ) ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-status" }, rule.in_state ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-icon " + getIconClass( rule.pattern_eval ) }, getIcon( rule.pattern_eval ) ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-pattern" }, SHINKEN.TOOLS.STRING.cleanXss( rule.pattern ) ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-icon" }, '<i class="icon-arrow-right"></i>' ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-status-out" }, rule.out_state ) );
                    _table_rules_body.appendChild( _rule_dom );
                }
                
                if ( kl !== 0 ) {
                    _table_rules.appendChild( _table_rules_head );
                    _table_rules.appendChild( _table_rules_body );
                    _block_mod.appendChild( _table_rules );
                }
                else {
                    _block_mod.appendChild( DOM.Service.createElement( "p", { class: "default-property" }, _( 'element.no_mod_rule' ) ) );
                }
            }
            else {
                _tag = DOM.Service.createElement( "span", { class: "shinken-tag-modulation tag-block error " }, _current_modulation.getName() );
                _block_mod.appendChild( _tag );
                _block_mod.appendChild( DOM.Service.createElement( "p", { class: "error-property" }, _( 'element.resultmodulation_missing' ) ) );
            }
            _to_return.appendChild( _block_mod );
        }
        
        $executionContent.appendChild( _to_return );
    };
    var _createMacroEvaluationTable  = function ( macros ) {
        var table_data = DOM.Service.createElement( 'table', { class: 'table-try-check-data-eval table-striped table-bordered' } );
        var thead_data = DOM.Service.createElement( 'thead', { class: 'shinken-macro-eval-table-thead' } );
        
        thead_data.appendChild( DOM.Service.createElement( 'th', { class: 'shinken-macro-eval-table-name' }, _( 'element.name' ) ) );
        thead_data.appendChild( DOM.Service.createElement( 'th', { class: 'shinken-macro-eval-table-raw-value' }, _( 'element.value_to_evaluate' ) ) );
        thead_data.appendChild( DOM.Service.createElement( 'th', { class: 'shinken-macro-eval-table-value' }, _( 'element.expanded_value' ) ) );
        thead_data.appendChild( DOM.Service.createElement( 'th', { class: 'shinken-macro-eval-table-from' }, _( 'element.found_into_type' ) ) );
        table_data.appendChild( thead_data );
        
        var tbody_data                          = DOM.Service.createElement( 'tbody' );
        var _size                               = macros.length;
        var __missing_duplicate_foreach_display = DOM.Service.createElement( 'span', { class: 'missing-evaluated-value' }, _( 'element.missing_dfe' ) );
        var macro;
        var orig_macro;
        var class_to_add;
        var macro_infos;
        var macro_value;
        var raw_value;
        var macro_from_info_translated;
        var new_line;
        var cell_name;
        var cell_value;
        var cell_raw_value;
        var _macro_name;
        for ( var i = 0; i < _size; i++ ) {
            macro       = macros[ i ];
            orig_macro  = macro[ 0 ];
            macro_infos = macro[ 1 ];
            macro_value = macro_infos[ 'value' ];
            raw_value   = macro_infos[ 'raw_value' ];
            
            if ( _containsMacro( raw_value ) ) {
                for ( var j = 0; j < _size; j++ ) {
                    var macro_possible_name = '$' + macros[ j ][ 0 ] + '$';
                    class_to_add            = '';
                    if ( _macroIsEmpty( macros[ j ][ 1 ][ 'raw_value' ] ) ) {
                        class_to_add = 'shinken-macro-is-missing';
                    }
                    raw_value = SHINKEN.TOOLS.STRING.replaceAll( raw_value, macro_possible_name, '<span class="shinken-macro-in-data ' + class_to_add + '">' + macro_possible_name + '</span>' );
                }
            }
            class_to_add = '';
            if ( _macroIsEmpty( raw_value ) ) {
                class_to_add = 'shinken-macro-is-missing';
            }
            _macro_name = orig_macro;
            _macro_name += macro_infos[ 'data_modulation' ] ? '<span class="shinken-macro-data-modulation">' + _( 'element.modulation' ) + '</span>' : '';
            cell_name   = DOM.Service.createElement( 'td', { class: 'shinken-macro-eval-table-name ' + class_to_add }, _macro_name );
            
            cell_raw_value = _getMacroValueTranslated( raw_value, orig_macro, macro_infos, true );
            
            macro_value = macro_value.replace( REGEXS.MISSING_DFE, __missing_duplicate_foreach_display );
            cell_value  = _getMacroValueTranslated( macro_value, orig_macro, macro_infos, false );
            
            macro_from_info_translated = _getMacroFromInfoTranslated( macro_infos.from );
            if ( macro_infos[ 'from_info' ] && macro_infos[ 'from_info' ][ 'uuid' ] ) {
                var _template = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( macro_infos[ 'from_info' ][ 'uuid' ] );
                if ( _template ) {
                    macro_from_info_translated += SHINKEN.TOOLS.buildLinkShinkenElement( _template, '', 'shinken-tag-check hide-if-collapse shinken-space' ).outerHTML;
                }
                else {
                    macro_from_info_translated += " " + macro_infos[ 'from_info' ][ 'name' ];
                }
            }
            if ( macro_infos[ 'data_modulation' ] ) {
                var _macro_modulation = MANAGER.__instance_element_distributor.getElementByName( macro_infos[ 'data_modulation' ] );
                var _link             = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( _macro_modulation.type, _macro_modulation.uuid, _macro_modulation.macromodulation_name ).outerHTML;
                macro_from_info_translated += _( 'element.modulate_by' ) + ' <span class="shinken-macro-data-modulation">' + _link + '</span>';
            }
            var cell_from = DOM.Service.createElement( 'td', { class: 'shinken-macro-eval-table-from' }, macro_from_info_translated );
            
            new_line = DOM.Service.createElement( 'tr' );
            new_line.appendChild( cell_name );
            new_line.appendChild( cell_raw_value );
            new_line.appendChild( cell_value );
            new_line.appendChild( cell_from );
            tbody_data.appendChild( new_line );
        }
        table_data.appendChild( tbody_data );
        return table_data;
    };
    var _getMacroFromInfoTranslated  = function ( macro_from ) {
        var data;
        switch ( macro_from ) {
            case 'global':
                data = _( 'element.global_data' );
                break;
            case 'host':
                data = _( 'element.local_host_data' );
                break;
            case 'check':
                data = _( 'element.local_check_data' );
                break;
            case 'template':
                data = _( 'element.from_host_template' );
                break;
            case 'argn':
                data = _( 'element.command_argument' );
                break;
            default:
                data = _( 'element.unknown' );
        }
        return data;
    };
    var _getMacroValueTranslated     = function ( value, macro_name, macro_infos, is_raw_value ) {
        var to_return;
        var generic_class = "shinken-macro-eval-table-raw-value";
        var missing_class = generic_class + ' missing-evaluated-value';
        var _class        = generic_class;
        var _tag_label    = is_raw_value ? _( 'element.try_check_before_modulation' ) : _( 'element.try_check_after_modulation' );
        var span_protected_password;
        var _value;
        
        if ( value ) {
            value = value.replace( REGEXS.DOUBLEDOLLAR, '$' );
        }
        switch ( value ) {
            case '__PROTECTED_PASSWORD__':
                _class                  = generic_class;
                span_protected_password = DOM.Service.createElement( 'span', { class: 'shinken-protected-password' }, '(' + _( 'element.password_protected' ) + ')' );
                _value                  = span_protected_password.outerHTML;
                break;
            case '__MISSING_ARGN__':
                _class = missing_class;
                _value = _( 'element.missing_argument' );
                break;
            case '__MISSING_DFE__':
                _class    = missing_class;
                _value    = _( 'element.missing_dfe' );
                to_return = DOM.Service.createElement( 'td', { class: missing_class }, _( 'element.missing_dfe' ) );
                break;
            case '__MISSING_HOST__':
                _class = missing_class;
                _value = SHINKEN.TOOLS.STRING.format( _( 'element.macro_missing_from_host' ), macro_name );
                break;
            case '__MISSING_CHECK__':
                _class = missing_class;
                _value = SHINKEN.TOOLS.STRING.format( _( 'element.macro_missing_from_check' ), macro_name );
                break;
            case '__MISSING_GLOBAL__':
                _class = missing_class;
                _value = _( 'element.macro_missing_global' );
                break;
            case '__NOT_IMPLEMENTED__':
                _class = missing_class;
                _value = _( 'element.macro_not_implemented' );
                break;
            case null:
            case 'null':
                _class = missing_class;
                _value = _( 'element.missing_value' );
                break;
            default:
                if ( SHINKEN.TOOLS.STRING.contains( value, '__PROTECTED_PASSWORD__' ) ) {
                    span_protected_password = DOM.Service.createElement( 'span', { class: 'shinken-protected-password' }, '(' + _( 'element.password_protected' ) + ')' );
                    _value                  = SHINKEN.TOOLS.STRING.replaceAll( value, '__PROTECTED_PASSWORD__', span_protected_password.outerHTML );
                }
                else {
                    _value = value;
                }
                _class = generic_class;
                break;
        }
        to_return           = DOM.Service.createElement( 'td', { class: _class } );
        to_return.innerHTML = macro_infos[ 'data_modulation' ] ? "<span class='shinken-tag-before-after-data-modulated'>" + _tag_label + "</span>" + _value : _value;
        return to_return;
    };
    var _containsMacro               = function ( value ) {
        if ( value && value.indexOf( '$' ) !== -1 ) {
            return true;
        }
        return false;
    };
    var _macroIsEmpty                = function ( marco_value ) {
        var is_empty = false;
        switch ( marco_value ) {
            case 'null':
            case '__MISSING_ARGN__':
            case '__MISSING_GLOBAL__':
            case '__MISSING_DFE__':
            case '__MISSING_HOST__':
            case '__MISSING_CHECK__':
            case '__NOT_IMPLEMENTED__':
                is_empty = true;
                break;
        }
        return is_empty;
        
    };
    var _create_raw_command_line     = function ( command_line, macros ) {
        command_line = SHINKEN.TOOLS.STRING.cleanXss( command_line );
        var _size    = macros.length;
        var replace_by;
        var macro_name;
        for ( var i = 0; i < _size; i++ ) {
            if ( _macroIsEmpty( macros[ i ][ 1 ].raw_value ) ) {
                macro_name   = '$' + macros[ i ][ 0 ] + '$';
                replace_by   = '<span class="missing-evaluated-value">$' + macro_name + '$</span>';
                command_line = command_line.replace( macro_name, replace_by );
            }
        }
        return '<div class="code"><p>' + command_line + '</p></div>';
    };
    var drawExecutionTable           = function ( result, stdout, shell, time, output, long_output, perf_data, extra_class ) {
        var __ret   = getContextById( result );
        var rStatus = __ret.rStatus;
        var rLabel  = __ret.rLabel;
        
        var _formatted_stdout = stdout;
        if ( output ) {
            output            = SHINKEN.TOOLS.STRING.cleanJavaScript( output );
            _formatted_stdout = '<div class="shinken-output-frame shinken-output-short"><div class="shinken-title">' + _( 'element.result' ) + '</div>' + DOM.Service.createElement( "div", { "class": "shinken-content-try-check" }, output ).outerHTML;
        }
        
        if ( long_output ) {
            long_output       = SHINKEN.TOOLS.STRING.cleanJavaScript( long_output );
            _formatted_stdout = _formatted_stdout + '<div class="shinken-output-frame shinken-output-long"><div class="shinken-title">' + _( 'element.long_result' ) + '</div>' + DOM.Service.createElement( "div", { "class": "shinken-content-try-check" }, long_output ).outerHTML;
        }
        if ( perf_data.trim()[ 0 ] === '|' ) {
            _formatted_stdout = _formatted_stdout + getPerformanceRowHtml( perf_data.trim().substr( 1 ) );
        }
        
        var $tableExecution = $( '<table class="table-execution table-hover table-striped table-bordered ' + extra_class + '" style="width: 100%;">' );
        var $theadExecution = $( '<thead style="background-color: #C2C2C2;">' +
                                 '<th class="col-result word-break-keep-all">' + _( 'element.status' ) + '</th>' +
                                 '<th class="col-output word-break-keep-all">' + _( 'element.result' ) + '</th>' +
                                 '<th class="col-shell word-break-keep-all">' + _( 'element.with_shell' ) + '</th>' +
                                 '<th class="col-time word-break-keep-all">' + _( 'element.execution_time' ) + '</th>' +
                                 '</thead>' );
        var $tbodyExecution = $( '<tbody>' +
                                 '<tr>' +
                                 '<td class="col-result"></td>' +
                                 '<td class="col-output cell-iFrame" ><div class="shinken-container">' + _formatted_stdout + '</div></td>' +
                                 '<td class="col-shell">' + shell + '</td>' +
                                 '<td class="col-time">' + time + '</td>' +
                                 '</tr>' +
                                 '</body>' );
        $tbodyExecution.find( ".col-result" ).append( App.Scope.Tags.create( rLabel, { context: rStatus } ).get( 0 ) );
        try {
            $tableExecution.append( $theadExecution ).append( $tbodyExecution );
        }
        catch ( ex ) {
            console.error( "[drawExecutionTable]", _( 'element.try_check_result_malformed' ) );
            console.warn( "[Malformed output]", output );
            $tableExecution.append( $theadExecution ).append( "<span style='color: red'>" + _( 'element.try_check_result_malformed' ) + "</span>" + SHINKEN.TOOLS.STRING.cleanXss( output + long_output + perf_data ) );
        }
        return $tableExecution;
    };
    var getPerformanceRowHtml        = function ( perf_data ) {
        perf_data = SHINKEN.TOOLS.STRING.cleanJavaScript(perf_data);
        if ( SHINKEN.TOOLS.STRING.isEmpty( perf_data ) ) {
            return "";
        }
        var _value_to_split = perf_data;
        var _to_return      = "";
        
        var _messages    = new OBJECT.Messages();
        var _index_comma = SHINKEN.TOOLS.STRING.indexesOf( _value_to_split, "," );
        if ( _index_comma.length ) {
            _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validator_js.perf_data.no_comma' ) );
            _value_to_split = SHINKEN.TOOLS.STRING.replaceAll( _value_to_split, ",", "" );
        }
        var _index_quotes     = SHINKEN.TOOLS.STRING.indexesOf( _value_to_split, "'" );
        var _splitted_metrics = [];
        if ( _index_quotes.length % 2 ) {
            _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validator_js.perf_data.nb_quotes_odd' ) );
        }
        else {
            var _indexes_spaces   = SHINKEN.TOOLS.STRING.indexesOfNotBetween( _value_to_split, " ", _index_quotes );
            var _perf_metrics_row = SHINKEN.TOOLS.STRING.splitWithIndexes( _value_to_split, _indexes_spaces, 1 );
            var _current;
            for ( var i = 0, _size_i = _perf_metrics_row.length; i < _size_i; i++ ) {
                _current = _perf_metrics_row[ i ];
                if ( SHINKEN.TOOLS.STRING.isEmpty( _current ) ) {
                    continue;
                }
                var _current_quotes = SHINKEN.TOOLS.STRING.indexesOf( _current, "'" );
                var _index_equals   = SHINKEN.TOOLS.STRING.indexesOfNotBetween( _current, "=", _current_quotes );
                if ( _index_equals.length === 0 ) {
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validator_js.perf_data.nb_equals_missing' ), _current ) );
                    continue;
                }
                else if ( _index_equals.length !== 1 ) {
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validator_js.perf_data.nb_equals_unique' ), _current ) );
                    continue;
                }
                var splited_equals = SHINKEN.TOOLS.STRING.splitWithIndexes( _current, _index_equals );
                var _current_name  = "";
                if ( _current_quotes.length ) {
                    _current_name = _current.substring( _current_quotes[ 0 ] + 1, _current_quotes[ _current_quotes.length - 1 ] );
                }
                else {
                    _current_name = splited_equals[ 0 ];
                }
                var _split_semi_colon = splited_equals[ 1 ].split( ';' );
                if ( _split_semi_colon.length > 5 ) {
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validator_js.perf_data.too_much_data' ), _current ) );
                }
                _splitted_metrics.push( SHINKEN.TOOLS.ARRAY.concat( [_current_name], _split_semi_colon ) );
            }
            
        }
        if ( !_messages.hasMessage() ) {
            _to_return += "<div class='shinken-output-frame shinken-metric-html'><div class='shinken-title'>" + _( 'element.metrics' ) + "</div><div class='shinken-content-try-check'><table class='shinken-metrics-table'>";
            _to_return += "<tr><th>" + _( 'element.metric' ) + "</th><th>" + _( 'element.value' ) + "</th><th>" + _( 'element.warning_threshold' ) + "</th><th>" + _( 'element.critical_threshold' ) + "</th></tr>";
            for ( var _metric_index = 0; _metric_index < _splitted_metrics.length; _metric_index++ ) {
                _to_return += "<tr><td class='metric-name'>" + _splitted_metrics[ _metric_index ][ 0 ] + "</td>";
                _to_return += "<td class='metric-value'>" + _splitted_metrics[ _metric_index ][ 1 ] + "</td>";
                _to_return += "<td class='metric-value'>" + (_splitted_metrics[ _metric_index ][ 2 ] || "");
                _to_return += "<td class='metric-value'>" + (_splitted_metrics[ _metric_index ][ 3 ] || "");
                _to_return += "</tr>";
            }
            _to_return += "</table></div></div>";
        }
        _to_return += "<div class='shinken-output-frame shinken-metric-flat'><div class='shinken-title'>" + _( 'element.raw_metrics' ) + "</div><div class='shinken-content-try-check shinken-div-inline-block'>" + perf_data + "</div>";
        if ( _messages.hasMessage() ) {
            _to_return += _messages.buildMessage();
        }
        _to_return += "</div>";
        return _to_return;
    };
    var getContextById               = function ( id ) {
        var rStatus = 'unknown',
            rLabel  = _( 'element.unknown' );
        if ( id == 0 ) {
            rStatus = 'success';
            rLabel  = _( 'element.ok' );
        }
        else if ( id == 1 ) {
            rStatus = 'warning';
            rLabel  = _( 'element.warning' );
        }
        else if ( id == 2 ) {
            rStatus = 'error';
            rLabel  = _( 'element.critical' );
        }
        return { rStatus: rStatus, rLabel: rLabel };
    };
    var getIcon                      = function ( value ) {
        return (value == true || value == 'true') ? '<i class="icon-ok"></i>' : (value == false || value == 'false') ? '<i class="icon-remove"></i>' : '-';
    };
    var getIconClass                 = function ( value ) {
        return (value == true || value == 'true') ? 'success' : (value == false || value == 'false') ? 'error' : 'default';
    };
    var changeNbStatusToLabel        = function ( statusNbr ) {
        return (statusNbr.length === 0) ? _( 'element.any_status' ) : getContextById( statusNbr ).rLabel;
    };
    return self;
})
( SHINKEN.TRY_CHECK || {} );
SOURCE.IpRanges           = function () {
};
SOURCE.IpRanges.prototype = {
    reset         : function () {
        this.list_ranges     = [];
        this.list_mapping_id = {};
    },
    init          : function ( datas, is_single_display ) {
        this.is_single_display = is_single_display;
        this.reset();
        for ( var i = 0, _size = datas.length; i < _size; i++ ) {
            this.addRangeInList( datas[ i ] );
        }
    },
    addRangeInList: function ( data ) {
        var _id                     = data[ SOURCE.CONST.RANGE.ID ];
        var _number                 = this.list_ranges.push( new SOURCE.Range( data, this.is_single_display ) );
        this.list_mapping_id[ _id ] = _number - 1;
        return this.getRangeById( _id );
    },
    updateData    : function ( datas ) {
        var _id;
        var _current;
        var _range;
        var _size = datas.length;
        
        for ( var i = 0; i < this.list_ranges.length; i++ ) {
            this.list_ranges[ i ].is_found = false;
        }
        
        for ( var i = 0; i < _size; i++ ) {
            _current = datas[ i ];
            _id      = _current[ SOURCE.CONST.RANGE.ID ];
            _range   = this.getRangeById( _id );
            if ( !_range ) {
                _range  = new SOURCE.Range( _current, this.is_single_display );
                this.list_ranges.push(_range);
                this.list_ranges = SHINKEN.TOOLS.ARRAY.sortArray(this.list_ranges, 'current_name')
                this.updateMapping();
                _range.createDomFromTemplate( this.list_mapping_id[ _id ] );
                _range.loadDomElements();
            }
            _range.is_found = true;
            _range.updateData( _current );
        }
        
        for ( var i = this.list_ranges.length - 1; i >= 0; i-- ) {
            if ( !this.list_ranges[ i ].is_found ) {
                this.list_ranges[ i ].remove();
                this.list_ranges.splice( i, 1 );
                this.updateMapping();
            }
        }
    },
    updateMapping : function () {
        this.list_mapping_id = {};
        for ( var i = 0, _size_i = this.list_ranges.length; i < _size_i; i++ ) {
            this.list_mapping_id[ this.list_ranges[ i ].getId() ] = i;
        }
    },
    getRangeById  : function ( id ) {
        var _index = this.list_mapping_id[ id ];
        
        if ( _index === undefined ) {
            console.warn( "[getRangeById]", "id not found need to create object" );
        }
        return this.list_ranges[ _index ];
    },
    getNbEnabled  : function () {
        var _to_return = 0;
        for ( var i = 0, _size_i = this.list_ranges.length; i < _size_i; i++ ) {
            if ( this.list_ranges[ i ].isEnabled() ) {
                _to_return++;
            }
        }
        return _to_return;
    }
};
SOURCE.Range           = function ( data, is_single_display ) {
    this.current_name      = '';
    this.is_single_display = !!is_single_display;
    this.init( data );
};
SOURCE.Range.prototype = {
    init                 : function ( data ) {
        this.initProperties();
        this.updateData( data );
        this.loadDomElements();
    },
    initProperties       : function () {
        this[ SOURCE.CONST.RANGE.NAME ]        = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.NAME );
        this[ SOURCE.CONST.RANGE.STATE ]       = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.STATE );
        this[ SOURCE.CONST.RANGE.ENABLED ]     = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.ENABLED );
        this[ SOURCE.CONST.RANGE.DESCRIPTION ] = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.DESCRIPTION );
        this[ SOURCE.CONST.RANGE.IP_RANGE ]    = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.IP_RANGE );
        this[ SOURCE.CONST.RANGE.SOURCE_NAME ] = new SOURCE.SourceProperty( SOURCE.CONST.RANGE.SOURCE_NAME );
    },
    updateData           : function ( data ) {
        if ( !data ) {
            return;
        }
        
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData              : function ( key, value ) {
        switch ( key ) {
            
            case SOURCE.CONST.RANGE.NAME:
                this.current_name = value;
            case SOURCE.CONST.RANGE.STATE:
            case SOURCE.CONST.RANGE.DESCRIPTION:
            case SOURCE.CONST.RANGE.IP_RANGE:
            case SOURCE.CONST.RANGE.SOURCE_NAME:
                this[ key ].updateValue( value );
                break;
            case SOURCE.CONST.RANGE.ENABLED:
                this[ key ].updateValue( value );
                if ( this.is_single_display && this.list_dom_element ) {
                    for ( var i = 0, _size_i = this.list_dom_element.length; i < _size_i; i++ ) {
                        this.list_dom_element[ i ].dataset.isActive = value ? "1" : "0";
                    }
                }
                break;
            
            case SOURCE.CONST.RANGE.ID:
                this[ key ] = value;
                break;
            
        }
    },
    getSourceName        : function () {
        return this[ SOURCE.CONST.RANGE.SOURCE_NAME ].value;
    },
    getName              : function () {
        return this[ SOURCE.CONST.RANGE.NAME ].value;
    },
    getId                : function () {
        return this[ SOURCE.CONST.RANGE.ID ];
    },
    getDomSelector       : function () {
        if ( this.is_single_display ) {
            return '.shinken-network-scan-row[data-id="' + this.getId() + '"]';
        }
        else {
            return '.line-source[data-name="' + this.getSourceName() + '"] .line-discovery[data-name="' + this.getName() + '"]';
        }
    },
    loadDomElements      : function () {
        this.list_dom_element = document.querySelectorAll( this.getDomSelector() );
        if ( !this.list_dom_element.length ) {
            var _self = this;
            setTimeout( function () {
                _self.loadDomElements();
            }, 1000 );
            return;
        }
        var _size = this.list_dom_element.length;
        this[ SOURCE.CONST.RANGE.NAME ].loadDomElements( this.list_dom_element, _size );
        this[ SOURCE.CONST.RANGE.ENABLED ].loadDomElements( this.list_dom_element, _size );
        this[ SOURCE.CONST.RANGE.IP_RANGE ].loadDomElements( this.list_dom_element, _size );
        this[ SOURCE.CONST.RANGE.DESCRIPTION ].loadDomElements( this.list_dom_element, _size );
    },
    createDomFromTemplate: function ( index_before ) {
        var _template = document.getElementById( "id-shinken-template-ip-range-discovery-lines" ).innerHTML;
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_name_$$$", this[ SOURCE.CONST.RANGE.NAME ].label );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_source_name_$$$", this[ SOURCE.CONST.RANGE.SOURCE_NAME ].label );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_id_$$$", this[ SOURCE.CONST.RANGE.ID ] );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_ip_range_$$$", this[ SOURCE.CONST.RANGE.IP_RANGE ].label );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_note_$$$", this[ SOURCE.CONST.RANGE.DESCRIPTION ].label );
        _template     = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_class_enable_$$$", this[ SOURCE.CONST.RANGE.ENABLED ].value ? 'conf-enabled' : 'conf-disabled' );
        var _source   = MANAGER.__instance_source_distributor.findSource( this[ SOURCE.CONST.RANGE.SOURCE_NAME ].value );
        for ( var i = 0, _size_i = _source.list_dom_element.length; i < _size_i; i++ ) {
            var _to_add = DOM.Service.createElement( "table", {}, _template );
            if ( index_before !== undefined ) {
                var _dom_existing = _source.list_dom_element[ i ].querySelectorAll( ".table-discovery-lines .line-discovery" )[ index_before ];
                if ( _dom_existing ) {
                    DOM.Service.insertElementBefore( _dom_existing, _to_add.firstElementChild.firstElementChild );
                    continue;
                }
            }
            DOM.Service.addElementTo( _to_add.firstElementChild.firstElementChild, _source.list_dom_element[ i ].querySelector( ".table-discovery-lines .shinken-target-ip-range-container" ) );
        }
        return this.loadDomElements();
    },
    isEnabled            : function () {
        return this[ SOURCE.CONST.RANGE.ENABLED ].value;
    },
    toggleEnable         : function () {
        var _is_enabled = !this.isEnabled();
        
        this.setData( SOURCE.CONST.RANGE.ENABLED, _is_enabled );
        
        var _enabled = _is_enabled ? COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.CONST.ENABLED : COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.CONST.DISABLED;
        
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.URL
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.OPTIONS.SOURCE_NAME
                     + this.getSourceName()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.OPTIONS.CONF_ID
                     + this.getId()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_DISCOVERY_ENABLED.OPTIONS.ENABLED
                     + _enabled,
            success: function ( data ) {
                if ( !self.is_single_display ) {
                    var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                    _sources.refresh();
                }
                else {
                    var _source = MANAGER.__instance_source_distributor.findSource( self.getSourceName() );
                    _source.askForRefresh();
                }
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    },
    remove               : function () {
        for ( var i = 0, _size_i = this.list_dom_element.length; i < _size_i; i++ ) {
            DOM.Service.removeElement( this.list_dom_element[ i ] );
        }
    }
};
SOURCE.SourceProperty           = function ( key ) {
    this.list_dom_element;
    this.previous_value = "";
    this.value          = "";
    this.label          = "";
    this.key            = key;
};
SOURCE.SourceProperty.prototype = {
    updateValue      : function ( to_set ) {
        if ( to_set === this.value ) {
            return;
        }
        switch ( this.key ) {
            case SOURCE.CONST.RANGE.STATE:
            case SOURCE.CONST.RANGE.NAME:
            case SOURCE.CONST.RANGE.SOURCE_NAME:
            case SOURCE.CONST.FIELD.STATE:
                if ( to_set === this.value ) {
                    return;
                }
                this.previous_value = this.value;
            case SOURCE.CONST.FIELD.ORDER:
            case SOURCE.CONST.FIELD.ENABLED:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_OK:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
            case SOURCE.CONST.FIELD.OUTPUT:
            case SOURCE.CONST.RANGE.DESCRIPTION:
            case SOURCE.CONST.RANGE.IP_RANGE:
            case SOURCE.CONST.RANGE.ENABLED:
                this.value = to_set;
                this.label = to_set;
                break;
            
            case SOURCE.CONST.FIELD.NEXT_IMPORT:
                this.value = to_set;
                if ( this.value === -1 ) {
                    this.label = "";
                }
                else {
                    this.label = DATE_TIME.durationToString( to_set * 1000, true, 1 );
                }
                break;
            case SOURCE.CONST.FIELD.LAST_IMPORT:
                this.value = to_set;
                this.label = DATE_TIME.durationToString( to_set * 1000, true, 1 );
                break;
        }
        this.updateDomElements();
    },
    updateDomElements: function () {
        if ( !this.list_dom_element ) {
            return;
        }
        var _size = this.list_dom_element.length;
        if ( !_size ) {
            console.warn( "[DOM NOT READY] Source Property", this.value );
            return;
        }
        for ( var i = 0; i < _size; i++ ) {
            this.updateDomElement( this.list_dom_element[ i ] );
        }
        
    },
    updateDomElement : function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        switch ( this.key ) {
            case SOURCE.CONST.FIELD.ENABLED:
                dom_element.classList.remove( this.value ? 'is-not-active' : 'is-active' );
                dom_element.classList.add( this.value ? 'is-active' : 'is-not-active' );
                break;
            case SOURCE.CONST.FIELD.STATE:
                DOM.Service.setDataSet( dom_element, 'state', this.value );
                if ( this.label === SOURCE.CONST.STATE.NOT_CONFIGURED ) {
                    dom_element.classList.remove( 'is-configured' );
                    dom_element.classList.add( 'is-not-configured' );
                }
                else {
                    dom_element.classList.remove( 'is-not-configured' );
                    dom_element.classList.add( 'is-configured' );
                }
                
                break;
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
                dom_element.innerHTML = this.label;
                dom_element           = this.getParentElement( dom_element );
                if ( this.value === 0 ) {
                    dom_element.classList.remove( 'shinken-element-in-warning' );
                }
                else {
                    dom_element.classList.add( 'shinken-element-in-warning' );
                }
                break;
            
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
                dom_element.innerHTML = this.label;
                dom_element           = this.getParentElement( dom_element );
                if ( this.value === 0 ) {
                    dom_element.classList.remove( 'shinken-element-in-error' );
                }
                else {
                    dom_element.classList.add( 'shinken-element-in-error' );
                }
                break;
            
            case SOURCE.CONST.FIELD.ORDER:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_OK:
            case SOURCE.CONST.FIELD.OUTPUT:
            case SOURCE.CONST.FIELD.LAST_IMPORT:
            case SOURCE.CONST.FIELD.NEXT_IMPORT:
            case SOURCE.CONST.RANGE.NAME:
            case SOURCE.CONST.RANGE.IP_RANGE:
            case SOURCE.CONST.RANGE.DESCRIPTION:
                dom_element.innerHTML = this.label;
                break;
            
            case SOURCE.CONST.RANGE.ENABLED:
                dom_element.classList.remove( this.value ? 'conf-disabled' : 'conf-enabled' );
                dom_element.classList.add( this.value ? 'conf-enabled' : 'conf-disabled' );
                break;
            
        }
        
    },
    getDomSelector   : function ( is_single_display ) {
        switch ( this.key ) {
            case SOURCE.CONST.FIELD.ORDER:
                return '.column-order .shinken-line-number';
            case SOURCE.CONST.FIELD.STATE:
            case SOURCE.CONST.RANGE.ENABLED:
            case SOURCE.CONST.FIELD.ENABLED:
                return ''; //WE TAKE THE PARENT
            case SOURCE.CONST.FIELD.NEXT_IMPORT:
                return '.column-next-import .next-import-content';
            case SOURCE.CONST.FIELD.NB_ELEMENTS_OK:
                return '.column-nb-elements .nb-elements-content .shinken-nb-elements-ok';
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
                return '.column-nb-elements .nb-elements-content .shinken-nb-elements-warning';
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
                return '.column-nb-elements .nb-elements-content .shinken-nb-elements-error';
            case SOURCE.CONST.FIELD.OUTPUT:
                return is_single_display ? '.shinken-source-summary-output-container' : '.column-output .output-content';
            case SOURCE.CONST.FIELD.LAST_IMPORT:
                return '.column-last-import .last-import-content';
            case SOURCE.CONST.RANGE.NAME:
                return '.line-discovery .discovery-name a';
            case SOURCE.CONST.RANGE.DESCRIPTION:
                return '.line-discovery .discovery-note .content';
            case SOURCE.CONST.RANGE.IP_RANGE:
                return '.line-discovery .discovery-ip_range .content';
        }
        
    },
    getParentElement : function ( dom_element ) {
        switch ( this.key ) {
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
            case SOURCE.CONST.FIELD.STATE:
                return dom_element.parentNode.parentNode;
            
            default:
                return dom_element.parentNode;
        }
    },
    loadDomElements  : function ( parent_dom_elements, size, is_single_display ) {
        var _selector = this.getDomSelector( is_single_display );
        if ( !_selector ) {
            this.list_dom_element = parent_dom_elements;
        }
        else if ( size && parent_dom_elements ) {
            this.list_dom_element = [];
            for ( var i = 0; i < size; i++ ) {
                this.list_dom_element[ i ] = parent_dom_elements[ i ].querySelector( _selector );
            }
            if ( this.key === SOURCE.CONST.FIELD.OUTPUT && is_single_display){
                this.list_dom_element.push(parent_dom_elements[0].querySelector( '.shinken-source-summary-output-container-inport-in-progress' ));
            }
        }
        var self = this;
        setTimeout( function () { //NORMALEMENT PAS NECESSAIRE
            if ( !self.list_dom_element ) {
                console.warn( "[reload dom element 2 ]", self.key );
                self.loadDomElements(parent_dom_elements, size, is_single_display);
            }
        }, 1000 );
    }
};
SOURCE.Source           = function ( data ) {
    this.init( data );
};
SOURCE.Source.prototype = {
    init                         : function ( data ) {
        this.is_single_display = !!data.is_single_display;
        this.initProperties( data );
        this[ SOURCE.CONST.FIELD.IMPORT_ENABLED ] = false;
        this[ SOURCE.CONST.FIELD.FULLY_MERGED ]   = false;
        this[ SOURCE.CONST.FIELD.ALREADY_IMPORT ] = false;
        this.is_imported_asked_for_this           = SOURCE.CONST.ASK_IMPORT.NONE;
        this.phase                                = new OBJECT.Phase();
        this.phase.current_phase                  = OBJECT.CONST.PHASE.READY;
        this.is_existing                          = true;
        this.updateData( data );
    },
    initProperties               : function ( data ) {
        this[ SOURCE.CONST.FIELD.ORDER ]               = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.ORDER );
        this[ SOURCE.CONST.FIELD.STATE ]               = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.STATE );
        this[ SOURCE.CONST.FIELD.ENABLED ]             = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.ENABLED );
        this[ SOURCE.CONST.FIELD.NEXT_IMPORT ]         = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.NEXT_IMPORT );
        this[ SOURCE.CONST.FIELD.LAST_IMPORT ]         = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.LAST_IMPORT );
        this[ SOURCE.CONST.FIELD.NB_ELEMENTS_OK ]      = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.NB_ELEMENTS_OK );
        this[ SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING ] = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING );
        this[ SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR ]   = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR );
        this[ SOURCE.CONST.FIELD.OUTPUT ]              = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.OUTPUT );
        this[ SOURCE.CONST.FIELD.MODULE_TYPE ]         = data[ SOURCE.CONST.FIELD.MODULE_TYPE ];
        this[ SOURCE.CONST.FIELD.IP_RANGES ]           = new SOURCE.IpRanges();
        if ( data[ 'ip_range' ] ) {
            this[ SOURCE.CONST.FIELD.IP_RANGES ].init( data[ 'ip_range' ], this.is_single_display );
        }
    },
    updateData                   : function ( data ) {
        if ( !data ) {
            return;
        }
        this.is_existing                              = true;
        if ( this.phase.isPhase( OBJECT.CONST.PHASE.SLEEPING ) ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
        this.setState( data[ SOURCE.CONST.FIELD.STATE ] );
    },
    setData                      : function ( key, value ) {
        switch ( key ) {
            case SOURCE.CONST.FIELD.NAME:
            case SOURCE.CONST.FIELD.ALREADY_IMPORT:
            case SOURCE.CONST.FIELD.TYPE:
                this[ key ] = value;
                break;
            
            case SOURCE.CONST.FIELD.STATE:
                break;
            
            case SOURCE.CONST.FIELD.ORDER:
            case SOURCE.CONST.FIELD.ENABLED:
                this[ key ].updateValue( value );
                break;
            
            case SOURCE.CONST.FIELD.LAST_IMPORT:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_OK:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
            case SOURCE.CONST.FIELD.OUTPUT:
                if ( this.isActive() ) {
                    this[ key ].updateValue( value );
                }
                break;
            
            case SOURCE.CONST.FIELD.NEXT_IMPORT:
                if ( this[ SOURCE.CONST.FIELD.TYPE ] !== SOURCE.CONST.TYPES.COLLECTOR && this[ SOURCE.CONST.FIELD.TYPE ] !== SOURCE.CONST.TYPES.ANALYZER ) {
                    return;
                }
                if ( this[ SOURCE.CONST.FIELD.STATE ] === SOURCE.CONST.STATE.NOT_CONFIGURED || this[ SOURCE.CONST.FIELD.STATE ] === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT ) {
                    return;
                }
                if ( !this.isActive() || !this.isImportEnabled() ) {
                    return;
                }
                if ( value < 0 ) {
                    return;
                }
                this[ key ].updateValue( value );
                break;
            
            case SOURCE.CONST.FIELD.IMPORT_INTERVAL:
                this.setImportEnabled( value );
                break;
            
            case SOURCE.CONST.FIELD.IP_RANGES:
                this[ SOURCE.CONST.FIELD.IP_RANGES ].updateData( value );
                break;
            
            case SOURCE.CONST.FIELD.MODULE_TYPE:
                break;
            
            case SOURCE.CONST.FIELD.FULLY_MERGED:
                this[ SOURCE.CONST.FIELD.FULLY_MERGED ] = value;
                break;
            
        }
    },
    getDomSelector               : function () {
        return this.is_single_display ? "#wrapper" : '.line-source[data-name="' + this.getName() + '"]';
    },
    loadDomElements              : function () {
        this.list_dom_element = document.querySelectorAll( this.getDomSelector() );
        
        var _size = this.list_dom_element.length;
        if ( !this.is_single_display ) {
            this[ SOURCE.CONST.FIELD.ORDER ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.NEXT_IMPORT ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.LAST_IMPORT ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.NB_ELEMENTS_OK ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.ENABLED ].loadDomElements( this.list_dom_element, _size );
        }
        this[ SOURCE.CONST.FIELD.STATE ].loadDomElements( this.list_dom_element, _size, this.is_single_display );
        this[ SOURCE.CONST.FIELD.OUTPUT ].loadDomElements( this.list_dom_element, _size, this.is_single_display );
        
        
        var self = this;
        setTimeout( function () { //NORMALEMENT PAS NECESSAIRE
            if ( !self.list_dom_element ) {
                console.warn( "[reload dom element]" );
                self.loadDomElements();
            }
        }, 1000 );
    },
    getDomElement                : function ( index ) {
        return this.list_dom_element[ index ];
    },
    resetExisting                : function () {
        this.is_existing = false;
    },
    getName                      : function () {
        return this[ SOURCE.CONST.FIELD.NAME ];
    },
    getOrder                     : function () {
        return this[ SOURCE.CONST.FIELD.ORDER ].value;
    },
    isActive                     : function () {
        return this.isEnabled();
    },
    isEnabled                    : function () {
        return this[ SOURCE.CONST.FIELD.ENABLED ].value;
    },
    getIsActive                  : function () {
        return this[ SOURCE.CONST.FIELD.ENABLED ].value;
    },
    isImportEnabled              : function () {
        return this[ SOURCE.CONST.FIELD.IMPORT_ENABLED ];
    },
    setImportEnabled             : function ( to_set ) {
        this[ SOURCE.CONST.FIELD.IMPORT_ENABLED ] = to_set !== 0;
    },
    toggleEnable                 : function () {
        var _is_active = !this.getIsActive(); //TOGGLE
        this.setData( SOURCE.CONST.FIELD.ENABLED, _is_active );
        
        var enabled = _is_active ? COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.CONST.ENABLED : COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.CONST.DISABLED;
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.URL
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.OPTIONS.SOURCE_NAME
                     + this[ SOURCE.CONST.FIELD.NAME ]
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.OPTIONS.ENABLED
                     + enabled,
            success: function ( data ) {
                if ( !self.is_single_display ) {
                    var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                    _sources.refresh();
                }
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
        
    },
    setOrder                     : function ( order ) {
        this.setData( SOURCE.CONST.FIELD.ORDER, order );
    },
    setPhase                     : function ( to_set ) {
        this.phase.setPhase( to_set );
        switch ( to_set ) {
            case OBJECT.CONST.PHASE.WAITING_FOR_UPDATE:
                this.askForRefresh();
                break;
            case OBJECT.CONST.PHASE.WAITING_FOR_START_IMPORT:
                DOM.BodyService.askAddClass( "shinken-import-in-progress" );
                if ( this.isSourceImportInProgress() ) {
                    DOM.BodyService.askAddClass( "shinken-import-in-progress_2" );
                }
                this.setRefreshIntervalForRefresh();
                break;
            case OBJECT.CONST.PHASE.REFRESHING:
                DOM.BodyService.askAddClass( "shinken-import-in-progress" );
                DOM.BodyService.askAddClass( "shinken-import-refreshing" );
                var self = this;
                setTimeout( function () {
                    if ( SHINKEN.HIGHWAY.getParams( 'shinken_test_auto' ) ){
                        DOM.BodyService.removeClass( "shinken-import-in-progress" );
                        self.phase.setPhase( OBJECT.CONST.PHASE.READY );
                        clearInterval(self.ask_for_refresh_interval);
                    }
                    else {
                        SHINKEN.HIGHWAY.refreshCurrentPage();
                    }
                }, 3000 );
                break;
            case OBJECT.CONST.PHASE.SLEEPING:
                this.phase.setPhaseWithTimeOut( OBJECT.CONST.PHASE.READY, 2000 );
                break;
        }
    },
    setState                     : function ( to_set ) {
        if ( !this.isEnabled() ) {
            return;
        }
        if ( this.is_single_display && this.is_imported_asked_for_this === SOURCE.CONST.ASK_IMPORT.CONFIRMED && this[ SOURCE.CONST.FIELD.FULLY_MERGED ] ) {
            this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_MERGE );
        }
        else if ( to_set !== SOURCE.CONST.STATE.READY_FOR_IMPORT && to_set !== SOURCE.CONST.STATE.RUNNING && !(to_set === SOURCE.CONST.STATE.NOT_CONFIGURED || to_set === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) && !this[ SOURCE.CONST.FIELD.FULLY_MERGED ] && !(this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED || this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) ) {
            to_set = SOURCE.CONST.STATE.IN_PROGRESS;
        }
        if ( this.is_imported_asked_for_this === SOURCE.CONST.ASK_IMPORT.CONFIRMED ) {
            to_set = SOURCE.CONST.STATE.RUNNING;
        }
        
        if ( this[ SOURCE.CONST.FIELD.STATE ].label === SOURCE.CONST.STATE.IN_PROGRESS && to_set !== SOURCE.CONST.STATE.IN_PROGRESS ) {
            ask_menu_update();
        }
        if ( this[ SOURCE.CONST.FIELD.ALREADY_IMPORT ] === false && to_set === SOURCE.CONST.STATE.PENDING ) {
            to_set = SOURCE.CONST.STATE.NEVER_IMPORT;
        }
        this[ SOURCE.CONST.FIELD.STATE ].updateValue( to_set );
        if ( this.is_single_display ) {
            switch ( to_set ) {
                case SOURCE.CONST.STATE.IN_PROGRESS:
                    this.setData( SOURCE.CONST.FIELD.OUTPUT, "" );
                case SOURCE.CONST.STATE.RUNNING:
                    if ( this.is_imported_asked_for_this === SOURCE.CONST.ASK_IMPORT.NONE ) {
                        this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_START_IMPORT );
                    }
                    break;
            }
            document.getElementById( 'wrapper' ).dataset.state = this.getState();
        }
        
    },
    getState                     : function () {
        return this[ SOURCE.CONST.FIELD.STATE ].value;
    },
    getPreviousState             : function () {
        return this[ SOURCE.CONST.FIELD.STATE ].previous_value;
    },
    isSourceImportInProgress     : function () {
        if ( !this[ SOURCE.CONST.FIELD.FULLY_MERGED ] ) {
            return true;
        }
        switch ( this[ SOURCE.CONST.FIELD.STATE ].value ) {
            case SOURCE.CONST.STATE.IN_PROGRESS:
            case SOURCE.CONST.STATE.RUNNING:
                return true;
        }
        return false;
    },
    resetDragging                : function () {
        this.list_dom_element[ 0 ].classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGING );
    },
    dragStartSource              : function () {
        this.list_dom_element[ 0 ].classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGING );
    },
    askForceImport               : function () {
        if ( !this.isEnabled() ) {
            return;
        }
        if ( this.is_single_display ) {
            this.is_imported_asked_for_this = SOURCE.CONST.ASK_IMPORT.ASKED;
        }
        else {
            this.setPhase( OBJECT.CONST.PHASE.SLEEPING );
            this.setState( SOURCE.CONST.STATE.RUNNING );
            this.forceImport();
            return;
        }
        this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_UPDATE );
        this.phase.next_phase = OBJECT.CONST.PHASE.WAITING_FOR_START_IMPORT;
    },
    askUpdateBeforeAnyAction     : function () {
        this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_UPDATE );
        this.phase.next_phase = OBJECT.CONST.PHASE.READY;
    },
    forceImport                  : function () {
        this.setData( SOURCE.CONST.FIELD.NEXT_IMPORT, 0 );
        if ( this.is_single_display ) {
            this.is_imported_asked_for_this = SOURCE.CONST.ASK_IMPORT.CONFIRMED;
        }
        this[ SOURCE.CONST.FIELD.OUTPUT ].updateValue( "" );
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.URL
                     + this[ SOURCE.CONST.FIELD.NAME ]
                     + COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                if ( !self.is_single_display ) {
                    var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                    _sources.refresh();
                }
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
        
    },
    cleanImport                  : function () {
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.CLEAN_IMPORT.URL
                     + this[ SOURCE.CONST.FIELD.NAME ]
                     + COMMUNICATION.QUERY.GET.SOURCE.CLEAN_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                _sources.refresh();
                ask_menu_update();
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    },
    setRefreshIntervalForRefresh : function () {
        if ( !this.is_single_display || this.ask_for_refresh_interval ) {
            return;
        }
        var self = this;
        setTimeout( function () {
            self.ask_for_refresh_interval = setInterval( function () {
                self.askForRefresh();
            }, 1000 );
        }, 2000 );
    },
    askForRefresh                : function () {
        if ( !this.is_single_display ) {
            return;
        }
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.REFRESH_UNIQUE.URL
                     + self[ SOURCE.CONST.FIELD.NAME ]
                     + COMMUNICATION.QUERY.GET.SOURCE.CLEAN_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                self.updateData( data );
                if ( self.is_single_display ) {
                    if ( self.phase.current_phase === OBJECT.CONST.PHASE.WAITING_FOR_UPDATE ) {
                        self.setPhase( self.phase.next_phase );
                    }
                    self.updateSingleDisplayView();
                }
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
        
    },
    updateSingleDisplayView      : function () {
        var _dom = document.querySelector( "#wrapper .shinken-number-active-conf" );
        if ( _dom ) {
            _dom.innerHTML = this[ SOURCE.CONST.FIELD.IP_RANGES ].getNbEnabled();
        }
        if ( !this.getIsActive() && this.is_imported_asked_for_this === SOURCE.CONST.ASK_IMPORT.CONFIRMED ) {
            this.setPhase( OBJECT.CONST.PHASE.REFRESHING );
            return;
        }
        switch ( this.phase.current_phase ) {
            case OBJECT.CONST.PHASE.WAITING_FOR_START_IMPORT:
                if ( this.getState() === SOURCE.CONST.STATE.RUNNING ) {
                    this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_IMPORT );
                }
                else if ( !this[ SOURCE.CONST.FIELD.FULLY_MERGED ] && this.getState() !== SOURCE.CONST.STATE.READY_FOR_IMPORT && !(this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED || this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) && !(this.getPreviousState() === SOURCE.CONST.STATE.NOT_CONFIGURED || this.getPreviousState() === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) ) {
                    this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_MERGE );
                }
                else {
                    this.forceImport();
                    this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_IMPORT );
                }
                break;
            case OBJECT.CONST.PHASE.WAITING_FOR_IMPORT:
                if ( this.getState() === SOURCE.CONST.STATE.RUNNING ) {
                }
                else if ( this[ SOURCE.CONST.FIELD.FULLY_MERGED ] && this[ SOURCE.CONST.FIELD.NEXT_IMPORT ].value < 1 ) {
                }
                else {
                    this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_MERGE );
                }
                break;
            case OBJECT.CONST.PHASE.WAITING_FOR_MERGE:
                if ( (this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED || this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) ) {
                    this.setPhase( OBJECT.CONST.PHASE.REFRESHING );
                }
                if ( !this[ SOURCE.CONST.FIELD.FULLY_MERGED ] ) {
                }
                else {
                    this.setPhase( OBJECT.CONST.PHASE.REFRESHING );
                }
                break;
        }
        
        var _dom_output = document.querySelector( "#wrapper #id-shinken-output-source" );
        if ( _dom_output ) {
            if ( this[ SOURCE.CONST.FIELD.OUTPUT ].value ) {
                _dom_output.setAttribute( "shi-tip-html", this[ SOURCE.CONST.FIELD.OUTPUT ].value );
                _dom_output.classList.remove( 'shinken-hidden' );
            }
            else {
                _dom_output.classList.add( 'shinken-hidden' );
            }
        }
        
    },
    redirectToSourceLastExecution: function () {
        var url = COMMUNICATION.QUERY.GET.SOURCE.REDIRECT_DETAIL.URL + this.getName() + COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER + COMMUNICATION.QUERY.GET.SOURCE.REDIRECT_DETAIL.OPTIONS.TAB_SUMMARY_OLD_RUN;
        window.open( url );
    }
};
var DATE_TIME = {};
var __traduction;
DATE_TIME.FORMAT = {
    TIME           : {
        DEFAULT: "HH:MM:SS",
        HH_MM  : "HH:MM"
    },
    DATE           : {
        DEFAULT   : "DD-MM-YYYY",
        WITH_SLASH: "DD/MM/YYYY"
    },
    TIME_PERIOD    : {
        YEAR   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30 * 355,
            KEY      : 'year',
            SHORT_KEY: 'short_year'
        },
        MONTH  : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30,
            KEY      : 'month',
            SHORT_KEY: 'short_month'
        },
        WEEK   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 7,
            KEY      : 'week',
            SHORT_KEY: 'short_week'
        },
        DAY    : {
            NB_MS    : 1000 * 60 * 60 * 24,
            KEY      : 'day',
            SHORT_KEY: 'short_day'
        },
        HOUR   : {
            NB_MS    : 1000 * 60 * 60,
            KEY      : 'hour',
            SHORT_KEY: 'short_hour'
        },
        MINUTE : {
            NB_MS    : 1000 * 60,
            KEY      : 'minute',
            SHORT_KEY: 'short_minute'
        },
        SECONDE: {
            NB_MS    : 1000,
            KEY      : 'second',
            SHORT_KEY: 'short_second'
        }
    },
    NOW            : 'now',
    TYPE_VALIDATION: {
        HOUR: "hour",
        MIN : "min"
    }
};
DATE_TIME.now = function() {
    return new Date();
};
DATE_TIME.getTimestampNow = function() {
    return Date.now();
};
DATE_TIME.FORMAT.getTime = function( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.TIME.DEFAULT;
    }
    format = format.toUpperCase();
    switch ( format ) {
        case DATE_TIME.FORMAT.TIME.DEFAULT:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
        case DATE_TIME.FORMAT.TIME.HH_MM:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 );
        default:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
    }
    
};
DATE_TIME.FORMAT.get_date = function( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.DATE.DEFAULT;
    }
    
    switch ( format ) {
        case DATE_TIME.FORMAT.DATE.DEFAULT:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDay(), 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth(), 2 ) + '-' + date.getFullYear();
        case DATE_TIME.FORMAT.DATE.WITH_SLASH:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDay(), 2 ) + '/' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth(), 2 ) + '/' + date.getFullYear();
        default:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDay(), 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth(), 2 ) + '-' + date.getFullYear();
    }
    
};
DATE_TIME.initTraduction = function() {
    __traduction = [];
    var keys = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _short_label;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key = keys[ i ];
        _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        _short_label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        __traduction[ _label ] = [_( 'timeperiods.' + _label ), _( 'timeperiods.' + _label + 's' )];
        __traduction[ _short_label ] = [_( 'timeperiods.' + _short_label ), _( 'timeperiods.' + _short_label + 's' )];
    }
    __traduction[ DATE_TIME.NOW ] = [_( 'timeperiods.now' ), ''];
};
DATE_TIME.getTraduction = function( key, is_plural ) {
    if ( !__traduction ) {
        this.initTraduction();
    }
    return __traduction[ key ][ is_plural ? 1 : 0 ];
};
DATE_TIME.durationToString = function( timestamp, is_short_name, limit ) {
    if ( !timestamp ) {
        return DATE_TIME.getTraduction( DATE_TIME.NOW, false );
    }
    
    var in_the_past = false;
    if ( timestamp < 0 ) {
        in_the_past = true;
        timestamp = -timestamp;
    }
    
    if ( !limit ) {
        limit = 9999;
    }
    var toReturn = '';
    var _nb;
    var keys = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _nb_sec;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key = keys[ i ];
        if ( is_short_name ) {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        }
        else {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        }
        
        _nb_sec = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'NB_MS' ];
        
        if ( timestamp >= _nb_sec ) {
            _nb = parseInt( timestamp / _nb_sec );
            if ( toReturn ) {
                toReturn += " ";
            }
            toReturn += _nb + " " + DATE_TIME.getTraduction( _label, _nb > 1 );
            timestamp = timestamp - _nb * _nb_sec;
            limit--;
        }
        if ( limit <= 0 ) {
            break;
        }
    }
    if ( !toReturn ) {
        toReturn = DATE_TIME.getTraduction( DATE_TIME.NOW, false );
    }
    else if ( in_the_past ) {
        toReturn = _( 'timeperiods.agoMoment' ) + ' ' + toReturn;
    }
    else {
        toReturn = _( 'timeperiods.inMoment' ) + ' ' + toReturn;
    }
    return toReturn;
};
DATE_TIME.relativeTime = function( elapsed ) {
    if ( elapsed < 0 ) {
        return relativeTime( -elapsed ) + ' ago';
    }
    var msPerSecond = DATE_TIME.FORMAT.TIME_PERIOD[ 'SECONDE' ][ 'NB_MS' ];
    var msPerMinute = DATE_TIME.FORMAT.TIME_PERIOD[ 'MINUTE' ][ 'NB_MS' ];
    var msPerHour = DATE_TIME.FORMAT.TIME_PERIOD[ 'HOUR' ][ 'NB_MS' ];
    var msPerDay = DATE_TIME.FORMAT.TIME_PERIOD[ 'DAY' ][ 'NB_MS' ];
    var msPerMonth = DATE_TIME.FORMAT.TIME_PERIOD[ 'MONTH' ][ 'NB_MS' ];
    var msPerYear = DATE_TIME.FORMAT.TIME_PERIOD[ 'YEAR' ][ 'NB_MS' ];
    
    if ( elapsed < msPerMinute ) {
        return Math.round( elapsed / msPerSecond );
    }
    else if ( elapsed < msPerHour ) {
        return Math.round( elapsed / msPerMinute );
    }
    else if ( elapsed < msPerDay ) {
        return Math.round( elapsed / msPerHour );
    }
    else if ( elapsed < msPerMonth ) {
        return Math.round( elapsed / msPerDay );
    }
    else if ( elapsed < msPerYear ) {
        return Math.round( elapsed / msPerMonth );
    }
    else {
        return Math.round( elapsed / msPerYear );
    }
};
DATE_TIME.isValid = function( type, string_value ) {
    if ( isNaN( string_value ) ) {
        return false;
    }
    var _value_splitted = string_value.split( '' );
    var _size = _value_splitted.length;
    var value;
    switch ( type ) {
        case DATE_TIME.FORMAT.TYPE_VALIDATION.HOUR:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 23 ) {
                return false;
            }
            break;
        case DATE_TIME.FORMAT.TYPE_VALIDATION.MIN:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 59 ) {
                return false;
            }
            break;
        default:
            console.warn( "DATE_TIME.isValid : unknown format =>", type );
    }
    return true;
};
DATE_TIME.isValidRangeTimeperiod = function( time1, time2 ) {
    return (DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time1 ) <= DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time2 ));
};
DATE_TIME.splitTimeperiodDay = function( value ) {
    var _to_return = [];
    var _timeperiod_ranges = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES );
    for ( var i = 0, _size = _timeperiod_ranges.length; i < _size; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodRanges( _timeperiod_ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodRanges = function( value ) {
    var ranges = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS );
    var _size_ranges = ranges.length;
    var _to_return = [];
    for ( var i = 0; i < _size_ranges; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodTime( ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodTime = function( value ) {
    var _to_return = {};
    var _time_splitted = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN );
    if ( _time_splitted.length !== 2 ) {
        _to_return.invalid = true;
        return _to_return;
    }
    _to_return.hour = _time_splitted[ 0 ].trim();
    _to_return.min = _time_splitted[ 1 ].trim();
    
    return _to_return;
};
DATE_TIME.getTimeperiodLabel = function( type, value ) {
    switch ( type ) {
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR:
            return value.hour + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN + value.min;
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE:
            return DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 0 ] ) + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS + DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 1 ] );
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.FULL:
            var _current_range;
            var _to_return = "";
            var _size = value.length;
            for ( var i = 0; i < _size; i++ ) {
                _current_range = value[ i ];
                _to_return += DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE, value[ i ] );
                if ( (value + 1) !== _size ) {
                    _to_return += PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES;
                }
            }
            return _to_return;
    }
};
SHINKEN.DOM = (function( self ) {
    "use strict";
    
    self.hide    = function( dom_element ) {
        if ( dom_element ) {
            dom_element.style.display = 'none';
        }
    };
    self.hideAll = function( dom_elements ) {
        if ( !dom_elements ) {
            return;
        }
        var _size = dom_elements.length;
        for ( var i = 0 ; i < _size; i++ )
            self.hide( dom_elements[i]);
    };
    self.show    = function( dom_element, display_type ) {
        if ( dom_element ) {
            dom_element.style.display = display_type || 'block';
        }
    };
    self.showAll = function( dom_elements ) {
        if ( !dom_elements ) {
            return;
        }
        var _size = dom_elements.length;
        for ( var i = 0 ; i < _size; i++ )
            self.show( dom_elements[i]);
    };
    
    self.remove_class_for = function( selector, class_to_remove ) {
        var _elements = document.querySelectorAll( selector );
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _elements[ i ].classList.remove( class_to_remove );
        }
    };
    self.add_class_for = function( selector, class_to_add ) {
        var _elements = document.querySelectorAll( selector );
        
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _elements[ i ].classList.add( class_to_add );
        }
    };
    
    self.set_inner_HTML_for = function( selector, html ) {
        var _elements = document.querySelectorAll( selector );
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _elements[ i ].innerHTML = html;
        }
    };
    
    
    
    return self;
})( SHINKEN.DOM || {} );
SHINKEN.TOOLS.ENCRYPTION = (function ( self ) {
    "use strict";
    self.default_label;
    self.getDefaultSpanLabel                   = function () {
        var _to_return = DOM.Service.createElement( "span", { class: 'shinken-encrypted-label shinken-between-parathensis' }, self.getDefaultLabel() );
        return _to_return.outerHTML;
    };
    self.getDefaultLabel                       = function () {
        if ( !self.default_label ) {
            self.default_label = _( 'element.password_protected' );
        }
        return self.default_label;
    };
    self.getLabelHidden                        = function () {
        return '**************';
    };
    self.getProtectedKeys                      = function () {
        return protect_fields__substrings_matching_fields;
    };
    self.isDatabaseEncryptionActivated         = function () {
        return protect_fields__activate_interface_encryption;
    };
    self.isProtectedFieldsAreViewableByAdminSi = function () {
        return protect_fields__are_viewable_by_admin_si;
    };
    self.isProtectedFieldsActivated            = function () {
        if ( this.isDatabaseEncryptionActivated() ) {
            return true;
        }
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin && !self.isProtectedFieldsAreViewableByAdminSi() ) {
            return true;
        }
        return false;
    };
    self.isProtectedField                      = function ( field_label ) {
        if ( !self.isDatabaseEncryptionActivated() && MANAGER.__instance_element_distributor.current_user.is_admin ) {
            return false;
        }
        if ( !field_label ) {
            return false;
        }
        var _protected_fields = self.getProtectedKeys();
        var _size             = _protected_fields.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = _protected_fields[ i ];
            if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( field_label, _current ) ) {
                return true;
            }
        }
        return false;
    };
    return self;
})( SHINKEN.TOOLS.ENCRYPTION || {} );
SHINKEN.TOOLS.EVENT = (function ( self ) {
    "use strict";
    self.getValueFromPaste = function ( event ) {
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) && window.clipboardData ) {
            if ( !window.clipboardData ) {
                console.error( "The browser have not window clipboardData" );
                return;
            }
            return window.clipboardData.getData( 'text' );
        }
        
        if ( !event.clipboardData ) {
            console.error( "It's not paste event" );
        }
        return event.clipboardData.getData( 'text' );
    };
    return self;
})( SHINKEN.TOOLS.EVENT || {} );
PROPERTY.CONST.VALIDATOR = {
    MESSAGES: {
        required       : _( "element.tooltip_required" ),
        url            : _( "element.tooltip_url" ),
        url_netloc     : _( "element.tooltip_url_netloc" ),
        notes_multi_url: _( "element.tooltip_missing_url" ),
        forbidden      : _( "element.tooltip_forbidden" ),
        replace        : _( "element.tooltip_replace" )
    },
    REGEXS  : {
        xss_exclude_characters                       : /[<>&"'/]/,
        xss_exclude_characters_url                   : /["' ]/,
        url                                          : /(ftp|https?):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@\-\/]))?/,
        note_url                                     : /^https?:\/\/(\w+(:\w+)?@)?[^"':/ ]+(:[0-9A-Za-z_$]+)?(\/|\/([\w#!:.?+=&%@\-\/$]+))?$/,
        restrict                                     : /[`~!$%^&*\"\'|<>?,()=/+\\]/,
        restrict_check                               : /[`~!%^&*\"\'|<>?,()=+]/, // The $ and / is allowed
        restrict_check_exclude                       : /[~!%^&\"\'|<>?()=+]/, // The $ and / is allowed
        restrict_host_group_name                     : /[~%^*\"\'<>?=]/,
        restrict_data                                : /[^0-9a-zA-Z_-]/,
        restrict_positive_integer                    : /^[1-9][0-9]*$/,
        restrict_positive_integer_or_zero            : /^[0-9][0-9]*$/,
        restrict_complex_expression_seps             : /[()&|!]/,
        restrict_filter_expression_seps              : /[()&|!"]/,
        restrict_positive_decimal_zero_to_one_hundred: /^(?:100(?:[.,]00?0?)?|0(?:[.,]\d\d?\d?)?|[1-9]\d?(?:[.,]\d\d?\d?)?)$/,
        restrict_filter_operators                    : /[&|]/,
        restrict_filter_modifiers                    : /[=*><]/g,
        compatible_filter_modifiers                  : /[*><]/g,
        key_data                                     : /[$]KEY[$]/,
        time_period_format                           : /^([0-9][0-9]:[0-9][0-9]\-[0-9][0-9]:[0-9][0-9]\,*){1,}$/
    },
    TYPE    : {
        SHINKEN_ELEMENT_NAME                         : {
            NAME : "shinken_element_name",
            VALUE: [ PROPERTY.CONST.CUSTOM_SELECT.DEFAULT, PROPERTY.CONST.CUSTOM_SELECT.NONE, 'shinken-service', 'shinken-host', 'shinken-cluster' ]
        },
        NO_INVISIBLE_CHAR                        : {
            NAME: "invisible_char"
        },
        NOT_EMPTY                                : {
            NAME: "not_empty"
        },
        NOT_NULL                                 : {
            NAME: "not_null"
        },
        RESULT_OK                                : {
            NAME: "result_ok"
        },
        REQUIRED                                 : {
            NAME: "required"
        },
        DFE_START                                    : {
            NAME   : "dfe_start",
            VALUE  : PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL,
            MESSAGE: _( 'validator_js.dfe_starts_not_by_' )
        },
        URL                                      : {
            NAME: "url"
        },
        NOTES_MULTI_URL                          : {
            NAME: "notes_multi_url"
        },
        RESTRICT                                 : {
            NAME   : "restrict",
            MESSAGE: '`~!$%^&*"\'|<>?,()=/+'
        },
        XSS_BLOCK                                : {
            NAME   : "xss_block",
            MESSAGE: '<>&"\'/'
        },
        XSS_BLOCK_URL                            : {
            NAME   : "xss_block_url",
            MESSAGE: "\" ' " + _( 'element.and_space_char' )
        },
        XSS_REPLACE                              : {
            NAME   : "xss_replace",
            MESSAGE: '<>&"\'/'
        },
        RESTRICT_CHECK                           : {
            NAME   : "restrict_check",
            MESSAGE: '`~!%^&*"\'|<>?,()=+'
        },
        RESTRICT_CHECK_EXCLUDE                   : {
            NAME   : "restrict_check_exclude",
            MESSAGE: '~!%^&"\'|<>?()=+'
        },
        RESTRICT_HOST_GROUP_NAME                 : {
            NAME   : "restrict_host_group_name",
            MESSAGE: '~%^*"\'<>?='
        },
        RESTRICT_DATA                            : {
            NAME: "restrict_data"
        },
        RESTRICT_DATA_DFE                        : {
            NAME: "restrict_data_dfe"
        },
        RESTRICT_POSITIVE_INTEGER                : {
            NAME: "restrict_positive_integer"
        },
        RESTRICT_POSITIVE_INTEGER_OR_ZERO        : {
            NAME: "restrict_positive_integer_or_zero"
        },
        RESTRICT_POSITIVE_DECIMAL_ZERO_TO_ONE_HUNDRED: {
            NAME: "restrict_positive_decimal_zero_to_one_hundred"
        },
        RESTRICT_INTEGER_WITH_MINUS_ONE          : {
            NAME     : "restrict_integer_with_minus_one",
            MINUS_ONE: '-1'
        },
        RESTRICT_HOST_NOTIFICATION_OPTIONS       : {
            NAME          : "restrict_host_notification_options",
            VALIDE_OPTIONS: ['w', 'c', 'd', 'u', 'r', 'f', 's', 'n']
        },
        RESTRICT_CHECK_NOTIFICATION_OPTIONS      : {
            NAME          : "restrict_check_notification_options",
            VALIDE_OPTIONS: ['d', 'w', 'u', 'c', 'r', 'f', 's', 'n']
        },
        RESTRICT_FLAP_DETECTION_OPTIONS_FOR_CHECK: {
            NAME            : "restrict_flap_detection_options_check",
            VALIDE_OPTIONS  : ['o', 'w', 'c', 'u'],
            REQUIRED_OPTIONS: ['o']
        },
        RESTRICT_FLAP_DETECTION_OPTIONS_FOR_HOST : {
            NAME            : "restrict_flap_detection_options_host",
            VALIDE_OPTIONS  : ['o', 'd', 'u'],
            REQUIRED_OPTIONS: ['o']
        },
        RESTRICT_ESCALATION_OPTIONS              : {
            NAME          : "restrict_escaltion_options",
            VALIDE_OPTIONS: ['d', 'u', 'r', 'w', 'c']
        },
        RESTRICT_DFE_VALUE                       : {
            NAME: 'restrict_dfe_value'
        },
        RESTRICT_TIMEPERIOD_DAYS                 : {
            NAME: "restrict_timeperiod_days"
        },
        SELECT_INPUT_WITH_CONDITION_FOCUS            : {
            NAME: "select_input_with_condition_focus"
        },
        SELECT_INPUT_WITH_CONDITION_NOT_FOCUS        : {
            NAME: "select_input_with_condition_not_focus"
        },
        RESTRICT_COMPLEX_EXPRESSION                  : {
            NAME: "restrict_complex_expression"
        },
        IP_RANGE                                 : {
            NAME: "ip_range_validator"
        },
        PORT_RANGE                               : {
            NAME: "port_range_validator"
        },
        MAXIMUM                                  : {
            NAME           : "maximum_date_validator",
            DATE_MAX_MINUTE: (5 * 365 + 2) * 1440,
            DATE_MAX_SECOND: ((5 * 365 + 2) * 1440) * 60
        }
    }
};
SHINKEN.TOOLS.SHINKEN_VALIDATOR = {
    init_with_name           : function ( validation_keys, value ) {
        var _prop = MANAGER.__instance_property_distributor.getElement( validation_keys.prop_name );
        return this.init( _prop, value, validation_keys.component_name );
    },
    init                     : function ( property, value, component_name ) {
        if ( !property ) {
            return new OBJECT.Messages();
        }
        
        var _validations_type = [];
        var name_property     = property.is_override ? property.override_prop_name : property.name;
        switch ( property.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.DATA:
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.NO_INVISIBLE_CHAR );
                break;
        }
        switch ( name_property ) {
            case PROPERTY.CONST.NAME.SERVICE_EXCLUDES:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_EXCLUDE );
                break;
            case PROPERTY.CONST.NAME.SERVICE_DESCRIPTION:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK );
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.SHINKEN_ELEMENT_NAME );
                break;
            case PROPERTY.CONST.NAME.NAME:
                if ( MANAGER.__instance_element_distributor.current_element.type === OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS ) {
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK );
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.SHINKEN_ELEMENT_NAME );
                }
                else {
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT );
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.SHINKEN_ELEMENT_NAME );
                }
                break;
            case PROPERTY.CONST.NAME.HOST_NAME:
                switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_GROUP_NAME );
                        break;
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_GROUP_NAME );
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_COMPLEX_EXPRESSION );
                        break;
                    default:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT );
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.SHINKEN_ELEMENT_NAME );
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.COMMAND_NAME:
            case PROPERTY.CONST.NAME.PREFIX:
            case PROPERTY.CONST.NAME.SYNC_NAME:
            case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATION_NAME:
            case PROPERTY.CONST.NAME.CONTACT_NAME:
            case PROPERTY.CONST.NAME.CONTACTGROUP_NAME:
            case PROPERTY.CONST.NAME.ESCALATION_NAME:
            case PROPERTY.CONST.NAME.NOTIFICATIONWAY_NAME:
            case PROPERTY.CONST.NAME.MACROMODULATION_NAME:
            case PROPERTY.CONST.NAME.RESULTMODULATION_NAME:
            case PROPERTY.CONST.NAME.TIMEPERIOD_NAME:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT );
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.SHINKEN_ELEMENT_NAME );
                break;
            case PROPERTY.CONST.NAME.HOSTGROUP_NAME:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_GROUP_NAME );
                break;
            case PROPERTY.CONST.NAME.DUPLICATE_FOREACH_NAME:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DATA );
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DATA_DFE );
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.DFE_START );
                break;
            case PROPERTY.CONST.NAME.DEFAULT_VALUE:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DFE_VALUE );
                break;
            case PROPERTY.CONST.NAME.ADDRESS:
            case PROPERTY.CONST.NAME.PACK:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK );
                break;
            case PROPERTY.CONST.NAME.NOTE_URL:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK_URL );
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.URL );
                break;
            case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                switch ( component_name ) {
                    case "shinken-name-urlmulti":
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK );
                        break;
                    case "shinken-url-urlmulti":
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK_URL );
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.NOTES_MULTI_URL );
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.URL );
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL:
                switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                    case OBJECT.CONST.ELEMENT.TYPE.ESCALATIONS:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_INTEGER_WITH_MINUS_ONE );
                        break;
                    default:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER_OR_ZERO );
                        property.validation_max_value = PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM.DATE_MAX_MINUTE;
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM );
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.FIRST_NOTIFICATION_DELAY:
            case PROPERTY.CONST.NAME.LAST_NOTIFICATION_TIME:
            case PROPERTY.CONST.NAME.FIRST_NOTIFICATION_TIME:
                property.validation_max_value = PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM.DATE_MAX_MINUTE;
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM );
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER_OR_ZERO );
                break;
            case PROPERTY.CONST.NAME.CHECK_INTERVAL:
            case PROPERTY.CONST.NAME.RETRY_INTERVAL:
                property.validation_max_value = PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM.DATE_MAX_MINUTE;
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM );
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER );
                break;
            case PROPERTY.CONST.NAME.WARNING_THRESHOLD_CPU_USAGE:
            case PROPERTY.CONST.NAME.FRESHNESS_THRESHOLD:
                property.validation_max_value = PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM.DATE_MAX_SECOND;
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM );
            case PROPERTY.CONST.NAME.DEFINITION_ORDER:
            case PROPERTY.CONST.NAME.MAX_CHECK_ATTEMPTS:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER );
                break;
            case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
            case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_DECIMAL_ZERO_TO_ONE_HUNDRED );
                break;
            case PROPERTY.CONST.NAME.CHECK_RUNNING_TIMEOUT:
            case PROPERTY.CONST.NAME.TIMEOUT:
                property.validation_max_value = PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM.DATE_MAX_SECOND;
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM );
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_INTEGER_WITH_MINUS_ONE );
                break;
            case PROPERTY.CONST.NAME.HOST_NOTIFICATION_OPTIONS:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_NOTIFICATION_OPTIONS );
                break;
            case PROPERTY.CONST.NAME.SERVICE_NOTIFICATION_OPTIONS:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_NOTIFICATION_OPTIONS );
                break;
            case PROPERTY.CONST.NAME.FLAP_DETECTION_OPTIONS:
                switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                    case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
                    case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_FLAP_DETECTION_OPTIONS_FOR_CHECK );
                        break;
                    default:
                        if ( property.is_override ) {
                            _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_FLAP_DETECTION_OPTIONS_FOR_CHECK );
                        }
                        else {
                            _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_FLAP_DETECTION_OPTIONS_FOR_HOST );
                        }
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.NOTIFICATION_OPTIONS:
                switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
                    case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                        _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_NOTIFICATION_OPTIONS );
                        break;
                    default:
                        if ( property.is_override ) {
                            _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_NOTIFICATION_OPTIONS );
                        }
                        else {
                            _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_NOTIFICATION_OPTIONS );
                        }
                        break;
                }
                break;
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.MONDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.TUESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.WEDNESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.THURSDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.FRIDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SATURDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SUNDAY:
            case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_TIMEPERIOD_DAYS );
                break;
            case PROPERTY.CONST.NAME.IP_RANGE:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.IP_RANGE );
                break;
            case PROPERTY.CONST.NAME.PORT_RANGE:
                _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.PORT_RANGE );
                break;
        }
        
        if ( !MANAGER.__instance_element_distributor.current_element.is_creation && property.is_required && property.component_btn_inheritance.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            switch ( property.type ) {
                case PROPERTY.CONST.TYPES.MULTI_SELECT:
                case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.NOT_NULL );
                    break;
                default:
                    _validations_type.push( PROPERTY.CONST.VALIDATOR.TYPE.NOT_EMPTY );
                    break;
            }
        }
        return this._compute_validation( _validations_type, value, null, property );
    },
    _compute_validation         : function ( _validations_type, value_original, _to_return, property ) {
        if ( !_to_return ) {
            _to_return = new OBJECT.Messages();
        }
        var value = value_original;
        if ( value === "null" ) {
            value = "";
        }
        var _validation_type;
        var _validation_type_name;
        for ( var i = 0; i < _validations_type.length; i++ ) {
            _validation_type      = _validations_type[ i ];
            _validation_type_name = _validation_type.NAME;
            switch ( _validation_type_name ) {
                case PROPERTY.CONST.VALIDATOR.TYPE.SHINKEN_ELEMENT_NAME.NAME:
                    if ( SHINKEN.TOOLS.ARRAY.contains( PROPERTY.CONST.VALIDATOR.TYPE.SHINKEN_ELEMENT_NAME.VALUE, value_original ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validator_js.shinken_name_forbidden' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.REQUIRED.NAME:
                    if ( !value ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.required, _( 'element.this_field' ) ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.NOTES_MULTI_URL.NAME:
                    if ( !value ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.notes_multi_url );
                        return _to_return;
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.URL.NAME:
                    if ( value ) {
                        if ( PROPERTY.CONST.VALIDATOR.REGEXS.note_url.test( value ) ) {
                            if ( !MANAGER.__instance_macro_distributor.hasMacro( value ) && !DOM.Service.hasHrefHost( value ) ) {
                                _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.url_netloc );
                            }
                        }
                        else {
                            _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.url_netloc );
                        }
                        if ( SHINKEN.TOOLS.STRING.startsWith( value, 'http://' ) ) {
                            if ( value.length < 8 ) {
                                _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.url );
                            }
                        }
                        else if ( SHINKEN.TOOLS.STRING.startsWith( value, 'https://' ) ) {
                            if ( value.length < 9 ) {
                                _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.url );
                            }
                        }
                        else {
                            var _split_command = MANAGER.__instance_macro_distributor.splitCommand( value );
                            if ( _split_command.length && typeof _split_command[ 0 ] === 'object' ) {
                            
                            }
                            else {
                                _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.MESSAGES.url );
                            }
                        }
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.xss_exclude_characters ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.XSS_BLOCK_URL.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.xss_exclude_characters_url ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.XSS_REPLACE.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.xss_exclude_characters ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.replace, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK_EXCLUDE.NAME:
                    if ( value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_check_exclude ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    if ( value ) {
                        var _split = value.split( ',' );
                        for ( var j = 0, _size_j = _split.length; j < _size_j; j++ ) {
                            if ( !_split[ j ].trim() ) {
                                _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_service_excludes_empty_part' ), j + 1 ) );
                            }
                        }
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_CHECK.NAME:
                    value = value.replace( PROPERTY.CONST.VALIDATOR.REGEXS.key_data, "" );
                    if ( value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_check ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    else if ( value.match( '[$]' ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, _( 'element.tooltip_dollar' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_HOST_GROUP_NAME.NAME:
                    if ( value && value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_host_group_name ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, _validation_type.MESSAGE ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DATA.NAME:
                    if ( value ) {
                        if ( value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_data ) ) {
                            _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_no_special_chars' ) );
                        }
                        else if ( !SHINKEN.TOOLS.STRING.isUpperCase( value ) ) {
                            _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, _( 'element.tooltip_not_in_upper_case' ) );
                        }
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_DATA_DFE.NAME:
                    if ( value ) {
                        if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( value ) ) {
                            _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_key_encrypted' ), value ) );
                        }
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.DFE_START.NAME:
                    if ( value ) {
                        if ( SHINKEN.TOOLS.STRING.startsWith( value, PROPERTY.CONST.VALIDATOR.TYPE.DFE_START.VALUE ) ) {
                            _to_return.addMessage( COMPONENT.CONST.STATUS.WARNING, PROPERTY.CONST.VALIDATOR.TYPE.DFE_START.MESSAGE );
                        }
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER_OR_ZERO.NAME:
                    if ( value && !value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_positive_integer_or_zero ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_no_letter_2' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_DECIMAL_ZERO_TO_ONE_HUNDRED.NAME:
                    if ( value && !value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_positive_decimal_zero_to_one_hundred ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_no_letter_decimal_1_100' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.RESTRICT_POSITIVE_INTEGER.NAME:
                    if ( value && !value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_positive_integer ) ) {
                        _to_return.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_no_letter' ) );
                    }
                    break;
                case PROPERTY.CONST.VALIDATOR.TYPE.MAXIMUM.NAME:
                    if ( value && value > property.validati