var shinkenDocumentationVerifyAddress = function () {
    var _path;
    var _url = "http://172.16.0.246:7766";
    switch ( __documentation_type ) {
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.GENERAL:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.SUBMIT_WITH_COMMENT:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.PROPERTY_MULTI:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.PROPERTY_RANGE:
        case SHINKEN.CONST.DOCUMENTATION.WORKING_AREA.SAVE_IN_WORKING_AREA:
        case SHINKEN.CONST.DOCUMENTATION.WORKING_AREA.SAVE_IN_STAGING:
            _path = '/elements/hosts/7896be80180411e9b09b0800278ae825?tab=generic&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.PROPERTY_CHECKBOX:
            _path = '/elements/contacts/30067cfe5adf11e59a28080027f08538?tab=authorization&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.PROPERTY_TAG_EVERYONE:
            _path = '/elements/add/working_area/hosts?tab=user-rights&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.CHECKS:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDED:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_MODE:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.GENERAL:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.SET_DONE:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_ERROR_WARNING_COUNTER:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_COUNTER:
            _path = '/elements/add/working_area/hosts?tab=checks&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.DATA:
            _path = '/elements/add/working_area/hosts?tab=datas&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.CHECK.DATA:
            _path = '/elements/add/serviceshost?tab=datas&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.ESCALADE.GENERAL:
            _path = '/elements/add/escalation?shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.MAIN.GENERAL:
            _path = '/main?shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_TEMPLATE:
            _path = '/elements/hosttpls/ee9589341b0d11e98cd60800278ae825?tab=checks&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_TEMPLATE_ON_HOST:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_PLUS:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_DATA:
            _path = '/elements/hosts/2abe7a821b0f11e9a7210800278ae825?tab=checks&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_FIELD_USE:
            _path = '/elements/hosts/2abe7a821b0f11e9a7210800278ae825?tab=generic&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.INVALID_OVERRIDE:
            _path = '/elements/hosts/bc5e6c841d5f11e9885f0800278ae825?tab=checks&shinken_doc=' + __documentation_type;
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_CHECK_COMMAND:
            _path = '/elements/hosts/7896be80180411e9b09b0800278ae825?tab=checks&shinken_doc=' + __documentation_type;
            break;
    }
    _path = _url + _path;
    if ( _path && location.href !== _path ) {
        window.location = _path;
    }
};


var shinkenDocumentationSimulateUserAction = function () {
    switch ( __documentation_type ) {
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.GENERAL:
            MANAGER.__instance_property_distributor.findElement( "enabled" ).clickOnForcedHelpButton();
            MANAGER.__instance_property_distributor.findElement( "enabled" ).mouseEnter();
            document.querySelector( ".staging-area-banner" ).classList.add( "shinken-hidden" );
            MANAGER.WorkFlowManager.clickOnTabArea( MANAGER.CONST.STATE.WORK_FLOW.WORKING_AREA );
            //fire_element_is_modifie();
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.SUBMIT_WITH_COMMENT:
            MANAGER.WorkFlowManager.clickOnTabArea( MANAGER.CONST.STATE.WORK_FLOW.WORKING_AREA );
            fire_element_is_modifie();
            show_comment_to_submit_to_stagging( document.getElementById( 'element-btn-submit-to-stagging-add-comment' ) );
            document.getElementById( "comment-to-submit-for-staging-input" ).innerHTML = _( 'shinken-documentation.' + __documentation_type );
            document.querySelector( ".shinken-right-block-content" ).classList.add( "shinken-hidden" );
            document.querySelector( "#right-column" ).classList.add( "shinken-hidden" );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.PROPERTY_MULTI:
            MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.PARENTS ).clickOnSelector();
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.PROPERTY_RANGE:
            MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.BUSINESS_IMPACT ).setValueFromUser( 1 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.PROPERTY_CHECKBOX:
            MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.ACL_MAKE_DOWNTIME ).setValueFromUser( "0" );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.PROPERTY_TAG_EVERYONE:
            var _view_contact = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.VIEW_CONTACTS );
            if ( !PROPERTY.UserRightsBehaviour.has_everybody_default ) {
                alert( "La valeur par défaut du champ " + PROPERTY.CONST.NAME.VIEW_CONTACTS + " doit être a everyone pour ce screenshot" );
            }
            MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ).setValueFromUser( "admins" );
            SHINKEN_TOOLTIP.showTooltip( _view_contact.tag_information.dom_element );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.DATA:
            MANAGER.EventManager.clickOnAddNewLocalMacro();
            var _property                                                     = MANAGER.__instance_property_distributor.getAllDatasSorted()[ 0 ];
            _property.dom_element.querySelector( ".shinken-input-key" ).value = "TEST2";
            _property.dom_element.querySelector( ".shinken-input" ).value     = _( 'shinken-documentation.' + __documentation_type + "_1" );
            _property.askComputeKeyAfterChange();
            _property.askComputeAfterChange();
            
            setTimeout( function () {
                MANAGER.EventManager.clickOnAddNewLocalMacro();
                var _property2                                                     = MANAGER.__instance_property_distributor.getAllDatasSorted()[ 0 ];
                _property2.dom_element.querySelector( ".shinken-input-key" ).value = "TEST";
                _property2.dom_element.querySelector( ".shinken-input" ).value     = _( 'shinken-documentation.' + __documentation_type + "_2" );
                _property2.askComputeKeyAfterChange();
                _property2.askComputeAfterChange();
            }, 500 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.CHECK.DATA:
            MANAGER.EventManager.clickOnAddNewLocalMacro();
            var _data1                                                     = MANAGER.__instance_property_distributor.getAllDatasSorted()[ 0 ];
            _data1.dom_element.querySelector( ".shinken-input-key" ).value = "WARNNING";
            _data1.dom_element.querySelector( ".shinken-input" ).value     = 80;
            _data1.askComputeKeyAfterChange();
            _data1.askComputeAfterChange();
            
            setTimeout( function () {
                MANAGER.EventManager.clickOnAddNewLocalMacro();
                var _data2                                                     = MANAGER.__instance_property_distributor.getAllDatasSorted()[ 0 ];
                _data2.dom_element.querySelector( ".shinken-input-key" ).value = "CRITICAL";
                _data2.dom_element.querySelector( ".shinken-input" ).value     = 90;
                _data2.askComputeKeyAfterChange();
                _data2.askComputeAfterChange();
            }, 500 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.ESCALADE.GENERAL:
            MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.ESCALATION_NAME ).setValueFromUser( _( 'shinken-documentation.' + __documentation_type ) );
            MANAGER.__instance_property_distributor.findElement( 'first_notification_time' ).setValueFromUser( 1 );
            MANAGER.__instance_property_distributor.findElement( 'last_notification_time' ).setValueFromUser( 1 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.CHECKS:
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).setValueFromUser( "mssql,mssql-availability" );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE:
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).setValueFromUser( "aix" );
            setTimeout( function () {
                MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
                document.querySelector( ".shinken-check-override-tag" ).click();
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDED:
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).setValueFromUser( "aix" );
            setTimeout( function () {
                document.querySelector( "#id-shinken-check-line-c2952c4c5ad911e58cc5080027f08538" ).dataset.overrideStatus = OBJECT.CONST.OVERRIDE_STATUS.ON;
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.GENERAL:
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).setValueFromUser( "aix" );
            setTimeout( function () {
                MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
                document.querySelector( ".shinken-check-override-tag" ).click();
                setTimeout( function () {
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD ).setValueFromUser( '10' );
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.MAINTENANCE_PERIOD ).setValueFromUser( '24x7' );
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.MAX_CHECK_ATTEMPTS ).setValueFromUser( '80' );
                    MANAGER.__instance_window_distributor.clickOnFirstWindowInParentWithName( 'monitoring-override' );
                }, 1000 );
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.SET_DONE:
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).setValueFromUser( "aix" );
            setTimeout( function () {
                MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
                document.querySelector( ".shinken-check-override-tag" ).click();
                setTimeout( function () {
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL ).setValueFromUser( '100' );
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.CONTACTS ).setValueFromUser( 'admin,admin-si' );
                    MANAGER.__instance_window_distributor.clickOnFirstWindowInParentWithName( 'notifications-override' );
                }, 1000 );
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_COUNTER:
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).setValueFromUser( "aix" );
            setTimeout( function () {
                MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
                document.querySelector( ".shinken-check-override-tag" ).click();
                setTimeout( function () {
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL ).setValueFromUser( '100' );
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.CONTACTS ).setValueFromUser( 'admin,admin-si' );
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.NOTE_URL ).setValueFromUser( 'http://www.shinken-solutions.com' );
                    MANAGER.__instance_window_distributor.clickOnFirstWindowInParentWithName( 'notifications-override' );
                }, 1000 );
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_ERROR_WARNING_COUNTER:
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).setValueFromUser( "aix" );
            setTimeout( function () {
                MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
                document.querySelector( ".shinken-check-override-tag" ).click();
                setTimeout( function () {
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL ).setValueFromUser( 'du texte' );
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.NOTE_URL ).setValueFromUser( 'www.shinken-solution.com' );
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.CONTACTS ).setValueFromUser( 'admin,admin-si' );
                }, 1000 );
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_TEMPLATE:
            setTimeout( function () {
                MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
                document.querySelector( ".shinken-check-override-tag" ).click();
                setTimeout( function () {
                    MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.CONTACTS ).setValueFromUser( 'admin-si' );
                    MANAGER.__instance_window_distributor.clickOnFirstWindowInParentWithName( 'notifications-override' );
                }, 1000 );
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_TEMPLATE_ON_HOST:
            setTimeout( function () {
                MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
                document.querySelector( ".shinken-check-override-tag" ).click();
                setTimeout( function () {
                    MANAGER.__instance_window_distributor.clickOnFirstWindowInParentWithName( 'notifications-override' );
                }, 1000 );
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_PLUS:
            MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
            document.querySelector( ".shinken-check-override-tag" ).click();
            setTimeout( function () {
                MANAGER.__instance_window_distributor.clickOnFirstWindowInParentWithName( 'notifications-override' );
                MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.CONTACTS ).setValueFromUser( 'admin' );
                MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.CONTACTS ).setStatePlus( true );
                MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.CONTACTS ).clickOnBtnPlus();
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_CHECK_COMMAND:
            MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
            document.querySelector( ".shinken-check-override-tag" ).click();
            setTimeout( function () {
                MANAGER.__instance_window_distributor.clickOnFirstWindowInParentWithName( 'monitoring-override' );
                MANAGER.__instance_property_distributor.getFirstOverridePropWithName( PROPERTY.CONST.NAME.CHECK_COMMAND ).setValueFromUser( '12' );
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_DATA:
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_FIELD_USE:
            MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
            document.querySelector( ".shinken-check-override-tag" ).click();
            setTimeout( function () {
                MANAGER.__instance_window_distributor.clickOnFirstWindowInParentWithName( 'datas-override' );
                MANAGER.__instance_property_distributor.getFirstOverridePropWithName( '_SSH_USER' ).setValueFromUser( 'customer5-login' );
                MANAGER.__instance_property_distributor.getFirstOverridePropWithName( '_SSH_KEY_PASSPHRASE' ).setValueFromUser( 'customer5-password' );
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.INVALID_OVERRIDE:
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).unset();
            break;
        case SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.OVERRIDE_MODE:
            MANAGER.EventManager.clickOnModeTab( document.querySelector( ".shinken-check-mode-menu-tab[data-value='1']" ) );
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).setValueFromUser( "aix" );
            setTimeout( function () {
                document.querySelector( "#id-shinken-check-line-c2952c4c5ad911e58cc5080027f08538" ).dataset.overrideStatus = OBJECT.CONST.OVERRIDE_STATUS.ON;
            }, 1000 );
            break;
        case SHINKEN.CONST.DOCUMENTATION.WORKING_AREA.SAVE_IN_WORKING_AREA:
            MANAGER.WorkFlowManager.clickOnTabArea( MANAGER.CONST.STATE.WORK_FLOW.WORKING_AREA );
        case SHINKEN.CONST.DOCUMENTATION.WORKING_AREA.SAVE_IN_STAGING:
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.HOST_NAME ).setValueFromUser( 'Localhost' );
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.DISPLAY_NAME ).setValueFromUser( 'Description' );
            MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE ).setValueFromUser( "shinken-full" );
            setTimeout( function () {
                fire_element_is_modifie();
            }, 1000 );
            break;
    }
};

/************************************************************************        INIT        *********************************************************************************************************/

var __documentation_type = SHINKEN.HIGHWAY.getParams( 'shinken_doc' );

var __doActionWhenReadyDocumentation_done = false;
var doActionWhenReadyDocumentation        = function () {
    if ( __doActionWhenReadyDocumentation_done ) {
        return;
    }
    __doActionWhenReadyDocumentation_done = true;
    shinkenDocumentationVerifyAddress();
    shinkenDocumentationSetText();
    shinkenDocumentationSimulateUserAction();
};

var shinkenDocumentationSetText = function () {
    for ( var i = 1; i < 6; i++ ) {
        if ( lang_fr[ "shinken-documentation" ][ __documentation_type + "_" + i ] ) {
            document.querySelector( '#id-shinken-decoration-container .div-' + i + ' .text' ).innerHTML = _( "shinken-documentation." + __documentation_type + "_" + i );
        }
    }
    
};

SHINKEN.CONST.DOCUMENTATION = {
    PAGE_ELEMENT: {
        GENERAL              : "01-01-form-element-description",
        SUBMIT_WITH_COMMENT  : "01-02-submit-with-comment",
        AREAS                : "01-03-configuration-area-description",
        PROPERTY_MULTI       : "01-05-property-multi-select",
        PROPERTY_RANGE       : "01-07-property-range",
        PROPERTY_CHECKBOX    : "01-08-property-checkbox",
        PROPERTY_TAG_EVERYONE: "01-12-property-tag_info_everyone",
        HOST                 : {
            DATA    : "03-02-page-data-vide-host",
            CHECKS  : "03-05-page-check-host",
            OVERRIDE: {
                STRUCTURE                     : "03-12-override-structure",
                OVERRIDED                     : "03-13-open-override-window",
                GENERAL                       : "03-14-override-general",
                SET_DONE                      : "03-15-set-done-override",
                OVERRIDE_ERROR_WARNING_COUNTER: "03-16-override-error-warning-counter",
                OVERRIDE_COUNTER              : "03-20-override-counter",
                OVERRIDE_TEMPLATE             : "03-21-override-on-template",
                OVERRIDE_TEMPLATE_ON_HOST     : "03-22-override-template-on-host",
                OVERRIDE_PLUS                 : "03-23-override-with-plus",
                OVERRIDE_CHECK_COMMAND        : "03-26-override-check-command",
                OVERRIDE_DATA                 : "03-27-override-data",
                OVERRIDE_FIELD_USE            : "03-28-override-field-use",
                INVALID_OVERRIDE              : "03-29-invalid-override",
                OVERRIDE_MODE                 : "03-31-override-mode"
            }
        },
        ESCALADE             : {
            GENERAL: "10-01-page-escalade-general"
        },
        CHECK                : {
            DATA: "06-02-check-data-tab"
        }
    },
    WORKING_AREA: {
        SAVE_IN_WORKING_AREA: "01-01-save-in-working-area",
        SAVE_IN_STAGING     : "01-02-save-in-staging"
    },
    MAIN        : {
        GENERAL: "01-main-page"
    }
};

lang_fr[ "shinken-documentation" ]                                                                            = {};
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.GENERAL + "_1" ]                 = "Aide contextuelle";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.GENERAL + "_2" ]                 = "Zone de configuration";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.SUBMIT_WITH_COMMENT ]            = "Suppression des checks inutiles";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_1" ]                   = "Catégories";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_2" ]                   = "Propriétés";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_3" ]                   = "Champs d'édition";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_4" ]                   = "Information de l'héritage";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_5" ]                   = "Type, statut et nom de l'objet";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.DATA + "_1" ]               = "La valeur d'une donnée peut être très longue, ce qui fait qu'elle s'affiche sur plusieurs lignes";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.DATA + "_2" ]               = "Exemple de donnée";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.ESCALADE.GENERAL ]               = "Mon escalade";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.MAIN.GENERAL + "_1" ]                         = "Zone 1";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.MAIN.GENERAL + "_2" ]                         = "Zone 2";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.MAIN.GENERAL + "_3" ]                         = "Zone 3";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE + "_1" ] = "Barre de navigation";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE + "_2" ] = "Propriétés";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE + "_3" ] = "Champs d'édition";
lang_fr[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE + "_4" ] = "Valeur original";



lang_en[ "shinken-documentation" ]                                                                            = {};
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.GENERAL + "_1" ]                 = "Contextual help";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.GENERAL + "_2" ]                 = "Configuration area";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.SUBMIT_WITH_COMMENT ]            = "Deleting useless checks";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_1" ]                   = "Categorie";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_2" ]                   = "Property";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_3" ]                   = "Edition field";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_4" ]                   = "Information on templating";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.AREAS + "_5" ]                   = "Type, status and name of the object";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.DATA + "_1" ]               = "The value of a data can be very long, which means that it is can be displayed on several lines";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.DATA + "_2" ]               = "Data example";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.ESCALADE.GENERAL ]               = "My escalation";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.MAIN.GENERAL + "_1" ]                         = "Area 1";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.MAIN.GENERAL + "_2" ]                         = "Area 2";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.MAIN.GENERAL + "_3" ]                         = "Area 3";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE + "_1" ] = "Navigation bar";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE + "_2" ] = "Property";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE + "_3" ] = "Edition field";
lang_en[ "shinken-documentation" ][ SHINKEN.CONST.DOCUMENTATION.PAGE_ELEMENT.HOST.OVERRIDE.STRUCTURE + "_4" ] = "Original value";