SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR = (function ( self ) {
    //********************************************  GET DOM ELEMENT   ****************************************//
    self._getOption    = function ( selector_dom_element, option_name ) {
        return selector_dom_element.querySelector( '.shinken-option[data-key-name="' + option_name + '"]' );
    };
    //********************************************  ACTION   **************************************************//
    self.clickOnOption = function ( timeout, property_name, selector_name, option_name ) {
        setTimeout( function () {
            var _selector   = SHINKEN.TOOLS.TEST_AUTO_PROPERTY._getSelector( property_name, selector_name );
            var _option_dom = self._getOption( _selector, option_name );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _option_dom );
        }, timeout );
        return 200;
    };
    //********************************************  TEST   **************************************************//
    self.isOptionState = function ( timeout, selector_dom_element, option_name, state ) {
        setTimeout( function () {
            var _option_dom = self._getOption( selector_dom_element, option_name );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.SELECTED_SELECTABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgb(0, 0, 0)", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(255, 255, 255)", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.SELECTED_UNSELECTABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgb(0, 0, 0)", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "0.18", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(255, 255, 255)", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "pointer-events", "none", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.NOT_SELECTED_SELECTABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgba(0, 0, 0, 0)", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(0, 0, 0)", "selector option" );
                    break;
            }
        }, timeout );
        return 10;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR || {} );

SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST = {
    OPTION_STATE: {
        SELECTED_SELECTABLE    : "SELECTED_SELECTABLE",
        SELECTED_UNSELECTABLE  : "SELECTED_UNSELECTABLE",
        NOT_SELECTED_SELECTABLE: "NOT_SELECTED_SELECTABLE"
    }
};