SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_DATA = (function ( self ) {
    //********************************************  GET DOM ELEMENT   ****************************************//
    self._getButtonAddData     = function () {
        return document.querySelector( "#id-shinken-mass-change-tunnel-step3 .shinken-add-data-button-container" );
    };
    self._getGroupDataList     = function () {
        return document.querySelectorAll( "#id-shinken-mass-change-tunnel-step3 #id-shinken-data-groups-list .shinken-data-group" );
    };
    self._getGroupDataByUuid   = function ( data_group_uuid ) {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step3 #id-shinken-data-groups-list .shinken-data-group[data-uuid="' + data_group_uuid + '"]' );
    };
    self._getFirstNewData      = function () {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step3 .shinken-element-property-line[data-status="' + PROPERTY.CONST.DATA.STATUS.NEW + '"]' );
    };
    self._getAllDataLines      = function () {
        return document.querySelectorAll( '#id-shinken-mass-change-tunnel-step3 .shinken-element-property-line[data-type="data"]' );
    };
    self._getFilterInput      = function () {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step3 #id-shinken-data-prop-table .shinken-list-filter[data-name="data_name"] .shinken-input' );
    };
    //********************************************  ACTION   **************************************************//
    self.removeFirstData       = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self._getFirstNewData().querySelector( '.shinken-delete-data-icon' ) );
        }, timeout );
        return 2000;
    };
    self.addNewData            = function ( timeout, name, value ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self._getButtonAddData() );
            if ( name !== undefined || value !== undefined ) {
                setTimeout( function () {
                    var _dom_element = self._getFirstNewData();
                    if ( name !== undefined ) {
                        SHINKEN.TOOLS.TEST_AUTO_PROPERTY_DATA.setKeyValue( 0, _dom_element.dataset.name, name );
                    }
                    if ( value !== undefined ) {
                        SHINKEN.TOOLS.TEST_AUTO_PROPERTY.setValue( 0, _dom_element.dataset.name, value );
                    }
                }, 1000 );
            }
        }, timeout );
        return 2000;
    };
    self.clickOnGroupData      = function ( timeout, uuid ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self._getGroupDataByUuid(uuid) );
        }, timeout );
        return 2000;
    };
    self.addFilterValue      = function ( timeout, filter_value ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self._getFilterInput(), filter_value );
        }, timeout );
        return 2000;
    };
    //********************************************  TEST   **************************************************//
    self.countDisplayedData    = function ( timeout, nb_expected ) {
        setTimeout( function () {
            var _list              = self._getAllDataLines();
            var _counter_displayed = 0;
            for ( var i = 0, _size_i = _list.length; i < _size_i; i++ ) {
                if ( DOM.Service.isVisible( _list[ i ] ) ) {
                    _counter_displayed++;
                }
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _counter_displayed, nb_expected, "nb data property visible" );
        }, timeout );
        return 200;
    };
    self.validGroupDataList    = function ( timeout, nb_entries_gp_data ) {
        setTimeout( function () {
            var _list = self._getGroupDataList();
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _list, nb_entries_gp_data, "nb group data" );
        }, timeout );
        return 200;
    };
    self.validGroupDataCounter = function ( timeout, data_group_uuid, nb_error, nb_warning, nb_user, nb_total ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.testCounter( 0, self._getGroupDataByUuid( data_group_uuid ), nb_error, nb_warning, nb_user, nb_total );
        }, timeout );
        return 200;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_DATA || {} );