SHINKEN.TOOLS.TEST_AUTO = (function ( self ) {
    //********************************************  MESSAGES   ******************************************************//
    var _messages                 = {};
    self.hasMessage               = function () {
        return !!Object.keys( _messages ).length;
    };
    self.addError                 = function ( text_message ) {
        console.warn( "[TEST AUTO]", text_message );
        if ( !_messages[ __shinken_test_type ] ) {
            _messages[ __shinken_test_type ] = [];
        }
        _messages[ __shinken_test_type ].push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, "[" + __shinken_test_type + "] - " + text_message ) );
    };
    self.addWarning               = function ( text_message ) {
        if ( !_messages[ __shinken_test_type ] ) {
            _messages[ __shinken_test_type ] = [];
        }
        _messages[ __shinken_test_type ].push( new OBJECT.Message( COMPONENT.CONST.STATUS.WARNING, "[" + __shinken_test_type + "] - " + text_message ) );
    };
    self.buildMessage             = function ( timeout ) {
        SHINKEN.TOOLS.TEST_AUTO_LOGGER.showInConsole();
        setTimeout( function () {
            if ( _has_script_error ) {
                self.addError( _has_script_error + ' error(s) javascript detected' );
            }
            var _to_write = new OBJECT.Messages();
            var _keys     = Object.keys( _messages );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                _to_write.addMessages( _messages[ _keys[ i ] ] );
            }
            var _dom_element = document.getElementById( 'saving-log-modal-body' );
            
            if ( _to_write.hasMessage() ) {
                if ( _dom_element ) {
                    _dom_element.innerHTML = _to_write.buildMessage();
                    SHINKEN.MODAL.toggle();
                }
                else {
                    var _dom_to_add = DOM.Service.createElement( "div", { style: "background: red;z-index:999999;position: absolute;" }, _to_write.buildMessage() );
                    DOM.Service.addElementTo( _dom_to_add, DOM.BodyService.getDomElement() );
                }
            }
            else if ( !__is_single ) {
                SHINKEN.TOOLS.TEST_AUTO_PHASE.doNext();
                console.log( "[TEST_AUTO DONE]", __shinken_test_type, "[OK]", "__do_next = " + __do_next, "phase" + __phase );
            }
        }, timeout );
        
    };
    //********************************************  TEST    ******************************************************//
    self.___isVariableEqualsTo    = function ( object, key, value_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( object[ key ] !== value_expected ) {
            if ( object.name ) {
                extra_label += " <span class='shinken-data-user'>" + object.name + "</span> ";
            }
            this.addError( extra_label + " la valeur de la clé [<span class='shinken-data-user'>" + key + "</span>] n'est pas égale à [<span class='shinken-data-user'>" + value_expected + "</span>] mais à [<span class='shinken-data-user'>" + object[ key ] + "</span>]" );
        }
    };
    self.___isEqualsTo            = function ( to_test, value_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( to_test !== value_expected ) {
            this.addError( extra_label + " la valeur n'est pas égale à  [<span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value_expected + '' ) + "</span>]  mais à [<span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( to_test + '' ) + "</span>]" );
        }
    };
    self.___isArrayLengthEqualsTo = function ( array, value_expected, label_array, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( array.length !== value_expected ) {
            this.addError( extra_label + "la longueur du tableau <span class='shinken-data-user'>" + label_array + "</span> n'est pas égale à [<span class='shinken-data-user'>" + value_expected + "</span>] mais à [<span class='shinken-data-user'>" + array.length + "</span>]" );
        }
    };
    self.__isFlatContentEqualTo   = function ( dom_element, string_expected, in_label, extra_label ) {
        string_expected = "" + string_expected;
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            console.warn( "GREG", "[__isInnerTextEqualTo]", "[NOT DONE ON IE]", __shinken_test_type );
            return;
        }
        if ( !in_label ) {
            in_label = dom_element.innerText;
        }
        return self.__isTextEqualTo( SHINKEN.TOOLS.STRING.replaceAll( dom_element.innerText, /\s/g, "" ).trim(), string_expected, in_label, extra_label );
    };
    self.__isInnerTextEqualTo     = function ( dom_element, string_expected, in_label, extra_label ) {
        string_expected = "" + string_expected;
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            console.warn( "[__isInnerTextEqualTo]", "[NOT DONE ON IE]", __shinken_test_type );
            return;
        }
        if ( !in_label ) {
            in_label = dom_element.innerText;
        }
        var _to_test = dom_element ? dom_element.innerText : "";
        _to_test     = _to_test.trim();
        //var _to_test = SHINKEN.TOOLS.STRING.replaceAll( dom_element ? dom_element.innerText : "", /\s/g, "" ).trim();
        if ( dom_element.tagName === "INPUT" || dom_element.tagName === "TEXTAREA" ) {
            _to_test = dom_element.value;
        }
        return self.__isTextEqualTo( _to_test, string_expected, in_label, extra_label );
    };
    self.__isInnerTextContains    = function ( dom_element, value_to_test, in_label, extra_label ) {
        value_to_test = "" + value_to_test;
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            console.warn( "GREG", "[__isInnerTextEqualTo]", "[NOT DONE ON IE]", __shinken_test_type );
            return;
        }
        if ( !in_label ) {
            in_label = dom_element.innerText;
        }
        return self.__containsText( SHINKEN.TOOLS.STRING.replaceAll( dom_element.innerText, /\s/g, " " ).trim(), value_to_test, in_label, extra_label );
    };
    self.__isTextEqualTo          = function ( text, string_expected, in_label, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( text !== string_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "le text dans <b>" + in_label + "</b> n'est pas égale à [<b>[" + SHINKEN.TOOLS.STRING.cleanXss( string_expected ) + "]</b>] ==> [" + SHINKEN.TOOLS.STRING.cleanXss( text ) + "]" );
        }
    };
    self.__containsText           = function ( text, value_to_test, in_label, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !SHINKEN.TOOLS.STRING.contains( text, value_to_test ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "le text dans <b>" + in_label + "</b> ne contient pas <b>" + value_to_test + "</b> ==> [" + text + "]" );
        }
    };
    self.__isNotEmpty             = function ( to_set, in_label, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( to_set === "" ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "le text dans <b>" + in_label + "</b> est vide" );
        }
    };
    /**
     *
     * @deprecated V02.08.01
     */
    self.__isPropErrorWarningCounter = function ( prop_name, error_expected, warning_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        var _prop = MANAGER.__instance_property_distributor.getElement( prop_name );
        if ( _prop.getCounterError().getValue() !== error_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le nombre d'erreur pour la propriété <b>" + prop_name + "</b> est différent de <b>" + error_expected + "</b> ==> [" + _prop.getCounterError().getValue() + "]" );
        }
        if ( _prop.getCounterWarning().getValue() !== warning_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le nombre de warning pour la propriété <b>" + prop_name + "</b> est différent de <b>" + warning_expected + "</b> ==> [" + _prop.getCounterWarning().getValue() + "]" );
        }
    };
    self.__hasStyle                 = function ( dom_element, key, value_expected, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = dom_element.innerText;
        }
        var _compute = DOM.Service.getComputedStyle( dom_element );
        if ( !_compute || _compute[ key ] !== value_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le style <b>" + key + "</b> de <b>" + text_desc + "</b> n'est pas égale à <b>" + value_expected + "</b> ==> <b>[" + _compute[ key ] + "]</b>" );
        }
        
    };
    self.__hasClass                 = function ( dom_element, class_name, text_desc, extra_label, inverse ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( inverse ) {
            if ( dom_element.classList.contains( class_name ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La class <b>" + class_name + "</b> existe dans <b>" + text_desc + "</b>" );
            }
        }
        else if ( !dom_element.classList.contains( class_name ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La class <b>" + class_name + "</b> n'existe pas dans <b>" + text_desc + "</b>" );
        }
        
    };
    self.__hasPulsate               = function ( dom_element, text_desc, timeout ) {
        SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-pulsate', text_desc, "pendant le clignotement" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-pulsate', text_desc, "aprés le clignotement de " + timeout + "ms", true );
        }, timeout );
    };
    self.__isVisible                = function ( dom_element, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = dom_element.innerText;
        }
        if ( !DOM.Service.isVisible( dom_element, 2 ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> n'est pas visible" );
        }
        
    };
    self.__isVisibleAndHasInnerText = function ( dom_element, innerText, text_desc, extra_label ) {
        self.__isVisible( dom_element, text_desc, extra_label );
        self.__isInnerTextEqualTo( dom_element, innerText, text_desc, extra_label );
    };
    self.__isNotVisible             = function ( dom_element, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
        }
        if ( DOM.Service.isVisible( dom_element, 2 ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> est visible" );
        }
        
    };
    self.__doesntExist              = function ( dom_element, text_desc, extra_label ) {
        if ( !dom_element ) {
            return;
        }
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc ) {
            text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
        }
        if ( dom_element ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> existe" );
        }
        
    };
    /**
     *
     * @deprecated V02.08.01
     */
    self.__nbUserElementSelected = function ( prop_name, number_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        var _prop   = MANAGER.__instance_property_distributor.elements[ prop_name ];
        var _length = 0;
        switch ( _prop.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                var _element_selected = _prop.getSelector().list_element.getSelectedElements();
                _length               = _element_selected.length;
                break;
        }
        if ( _length !== number_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le nombre d'éléments sélectionnés pour la propriété <b>" + prop_name + "</b> est different de " + number_expected + " ==> [" + _length + "]" );
        }
    };
    /**
     *
     * @deprecated V02.08.01
     */
    self.__validTimeperiodDaySimple = function ( prop_name, value, error_expected, warning_expected ) {
        var _timeout = 200;
        var _prop    = MANAGER.__instance_property_distributor.getElement( prop_name );
        _prop.setValueFromUser( value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isPropErrorWarningCounter( prop_name, error_expected, warning_expected );
        }, _timeout );
        return _timeout;
    };
    /**
     *
     * @deprecated V02.08.01
     */
    self.__isTagInformation = function ( name_property, status, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !status ) {
            status = COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE;
        }
        var _prop = MANAGER.__instance_property_distributor.getElement( name_property );
        if ( _prop.tag_information.dom_element.dataset.status !== status ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le status du tag information de <b>" + name_property + "</b> n'est pas " + status + " ==> [" + _prop.tag_information.dom_element.dataset.status + "]" );
        }
        switch ( status ) {
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _prop.tag_information.dom_element, "border", "1px solid rgb(236, 87, 87)", "tag d'information de " + _prop.getName(), extra_label );
                //SHINKEN.TOOLS.TEST_AUTO.__isVisible( _prop.tag_information.dom_element, "tag d'information de " + _prop.getName(), extra_label );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE :
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _prop.tag_information.dom_element, "display", "none", "tag d'information de " + _prop.getName(), extra_label );
                //SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _prop.tag_information.dom_element, "tag d'information de " + _prop.getName(), extra_label );
                break;
        }
    };
    /**
     *
     * @deprecated V02.08.01
     */
    self.__specific = function ( extra_label, arg1, arg2, arg3, arg4 ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        switch ( __shinken_test_type ) {
            case "00002":
                SHINKEN.TOOLS.TEST_AUTO.__nbUserElementSelected( arg1, 3, extra_label );
                SHINKEN.TOOLS.TEST_AUTO.__isPropErrorWarningCounter( arg1, arg2, arg3, extra_label );
                SHINKEN.TOOLS.TEST_AUTO.__isTagInformation( arg1, arg4, extra_label );
                break;
        }
    };
    //********************************************  ACTION    ******************************************************//
    self.changeUser   = function ( login, password ) {
        sessionStorage.removeItem( "user_id" );
        $.post( "/user/auth", { "shinken_login": login, "password": password } ).success(
            function ( data ) {
            }
        ).error(
            function ( res ) {
            }
        );
    };
    self.do_JS_action = function ( timeout, function_to_eval, time_to_return ) {
        setTimeout( function () {
            eval( function_to_eval );
        }, timeout );
        return time_to_return;
    };
    //var _interval_do_JS_action_when_ready;
    //self.do_JS_action_when_ready          = function ( timeout, function_to_eval, var_to_test, expected_value ) {
    //    var _to_return = 1000;
    //    _interval_do_JS_action_when_ready = setInterval( function () {
    //        if ( var_to_test === expected_value ){
    //            clearInterval( _interval_do_JS_action_when_ready );
    //        }
    //    }, 10 );
    //    return _to_return;
    //};
    //********************************************  DISPATCH    ******************************************************//
    self.dispatchMouseEvent         = function ( timeout, dom_element, type ) {
        setTimeout( function () {
            self.___dispatchMouseEvent( dom_element, type );
        }, timeout );
        return 100;
    };
    self.dispatchMouseEventWithEval = function ( timeout, dom_element_to_eval, type ) {
        setTimeout( function () {
            self.___dispatchMouseEvent( eval( dom_element_to_eval ), type );
        }, timeout );
        return 100;
    };
    self.___dispatchMouseEvent      = function ( dom_element, type ) {
        var event = new MouseEvent( type, {
            'view'      : window,
            'bubbles'   : true,
            'cancelable': true
        } );
        dom_element.dispatchEvent( event );
    };
    self.___dispatchEnterKeyEvent   = function ( dom_element, type ) {
        var event = new KeyboardEvent( type, {
            bubbles   : true,
            cancelable: true,
            code      : 'Enter',
            key       : 'Enter',
            charCode  : 13,
            keyCode   : 13,
            view      : window,
            shiftKey  : false
        } );
        dom_element.dispatchEvent( event );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO || {} );
SHINKEN.TOOLS.TEST_AUTO_PHASE = (function ( self ) {
    //********************************************  NEXT    ******************************************************//
    self.doNext                   = function ( timeout, forced_shinken_test_type, forced_phase ) {
        window.onbeforeunload = function () {
        };
        if ( SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ __shinken_test_type ].cancel_next ) {
            return;
        }
        var _timeout   = timeout + 2000;
        var _max_phase = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ __shinken_test_type ].phases || 1;
        if ( Array.isArray( SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ __shinken_test_type ].address ) ) {
            _max_phase = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ __shinken_test_type ].address.length;
        }
        var _has_other_phase = __phase < _max_phase;
        var _next;
        if ( _has_other_phase ) {
            __phase++;
            _next = __shinken_test_type;
        }
        else {
            __phase = 1;
            _next   = SHINKEN.TOOLS.STRING.prefix_by_zero( parseInt( __shinken_test_type ) + 1, 5 );
        }
        if ( !SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ _next ] || !SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ _next ].address ) {
            console.log( "GREG", "[FIN DES TEST AUTO]", "[1]" );
            return;
        }
        if ( Array.isArray( SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ _next ].address ) && !SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ _next ].address[ __phase - 1 ] ) {
            console.log( "GREG", "[FIN DES TEST AUTO]", "[2]" );
            return;
        }
        if ( __do_next ) {
            setTimeout( function () {
                window.location = self.getNextLink( _next, __phase );
            }, _timeout );
        }
        if ( forced_shinken_test_type && forced_phase ) {
            SHINKEN.HIGHWAY.goTo( self.getNextLink( forced_shinken_test_type, forced_phase ) );
        }
        
    };
    self.doNextWhen               = function ( timeout, function_to_eval ) {
        __do_next = false;
        setTimeout( function () {
            var _test = eval( function_to_eval );
            if ( _test ){
                __do_next = true;
                self.doNext(0, __shinken_test_type, __phase)
            }
            else {
                self.doNextWhen(1000, function_to_eval)
            }
        }, timeout );
    };
    self.refreshPage              = function ( timeout, go_next ) {
        setTimeout( function () {
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                if ( go_next ) {
                    SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO.getNextPhaseLink() );
                }
                SHINKEN.HIGHWAY.refreshCurrentPage();
            }
        }, timeout );
        return 50;
    };
    self.getNextLink              = function ( next, phase ) {
        var _params      = SHINKEN.HIGHWAY.getParams();
        var _new_address = Array.isArray( SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ next ].address ) ? SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ next ].address[ phase - 1 ] : SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ next ].address;
        if ( SHINKEN.TOOLS.STRING.contains( _new_address, "?" ) ) {
            return location.origin + _new_address + "&shinken_test_auto=" + next + "&phase=" + phase;
        }
        return location.origin + _new_address + "?shinken_test_auto=" + next + "&phase=" + phase;
    };
    self.getNextPhaseLink         = function () {
        var _params = SHINKEN.HIGHWAY.getParams();
        if ( isNaN( parseInt( _params.phase ) ) ) {
            _params.phase = 1;
        }
        _params.phase = parseInt( _params.phase ) + 1;
        return SHINKEN.HIGHWAY.buildParamsToUrl( _params );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PHASE || {} );

SHINKEN.TOOLS.TEST_AUTO_TOOLTIP = (function ( self ) {
    self.hasText      = function ( timeout, value_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "shi-tip" ), value_expected, "text dans le tooltip" );
        }, timeout );
        return 50;
    };
    self.containsText = function ( timeout, value_to_test ) {
        setTimeout( function () {
            var _dom_element = DOM.Service.createElement( "div", {}, value_to_test );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( document.getElementById( "shi-tip" ), _dom_element.innerText, "text dans le tooltip" );
        }, timeout );
        return 50;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_TOOLTIP || {} );

SHINKEN.TOOLS.TEST_AUTO_DOM = (function ( self ) {
    //********************************************  EVENT   **********************************************************//
    self.dispatchEvent  = function ( timeout, dom_element, event_to_dispatch, times ) {
        setTimeout( function () {
            if ( !times ) {
                times = 1;
            }
            for ( var i = 0; i < times; i++ ) {
                dom_element.dispatchEvent( event_to_dispatch );
            }
        }, timeout );
        return 300;
    };
    self.click          = function ( timeout, dom_element, force_click ) {
        setTimeout( function () {
            var _compute = DOM.Service.getComputedStyle( dom_element );
            if ( !force_click && _compute.pointerEvents === 'none' ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible pointerEvents === 'none'" );
            }
            else if ( !force_click && !DOM.Service.isVisible( dom_element ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible non visible" );
            }
            else {
                dom_element.click();
            }
        }, timeout );
        return 500;
    };
    //********************************************  SETTER GETTER   **************************************************//
    self.setValue       = function ( timeout, dom_element, to_set ) {
        setTimeout( function () {
            dom_element.focus();
            if ( dom_element.classList.contains( "shinken-input" ) || dom_element.classList.contains( "shinken-input-search" ) ) {
                dom_element.value = to_set;
                var evt           = document.createEvent( "HTMLEvents" );
                evt.initEvent( "keyup", false, true );
                dom_element.dispatchEvent( evt );
            }
            else if ( dom_element.hasAttribute( 'contenteditable' ) ) {
                dom_element.innerText = to_set;
                var evt               = document.createEvent( "HTMLEvents" );
                evt.initEvent( "focusout", false, true );
                dom_element.dispatchEvent( evt );
            }
        }, timeout );
        return DOM.CONST.WAITING_TIME_BEFORE_EXEC.INPUT * 3;
    };
    //********************************************  TEST   ***********************************************************//
    self.visibility     = function ( timeout, dom_element, text_desc, is_visible ) {
        if ( is_visible ) {
            return self.isVisible( timeout, dom_element, text_desc );
        }
        else {
            return self.isNotVisible( timeout, dom_element, text_desc );
        }
    };
    self.isVisible      = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( dom_element, text_desc );
        }, timeout );
        return 10;
    };
    self.isNotVisible   = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( dom_element, text_desc );
        }, timeout );
        return 10;
    };
    self.doesntExist    = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__doesntExist( dom_element, text_desc );
        }, timeout );
        return 10;
    };
    self.hasFocus       = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            if ( !text_desc && dom_element ) {
                text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
            }
            if ( !DOM.Service.hasFocus( dom_element ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le dom élément <b>" + text_desc + "</b> n'a pas le focus" );
            }
        }, timeout );
        return 10;
    };
    self.hasStyle       = function ( timeout, dom_element, key, value_expected, description ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, key, value_expected, description );
        }, timeout );
        return 10;
    };
    self.hasData        = function ( timeout, dom_element, key, value_expected, description ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( dom_element.dataset, key, value_expected, description );
        }, timeout );
        return 10;
    };
    self.hasStyleToEval = function ( timeout, dom_element_to_eval, key, value_expected ) {
        setTimeout( function () {
            var dom_element = eval( dom_element_to_eval );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, key, value_expected );
        }, timeout );
        return 10;
    };
    self.hasClass       = function ( timeout, dom_element, class_expected, revert, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, class_expected, text_desc, '', revert );
        }, timeout );
        return 10;
    };
    self.containsText   = function ( timeout, dom_element, text_expected, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( dom_element, text_expected, text_desc );
        }, timeout );
        return 10;
    };
    self.isText         = function ( timeout, dom_element, text_expected, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_element, text_expected, text_desc );
        }, timeout );
        return 10;
    };
    self.isTable        = function ( timeout, dom_element, nb_rows, nb_col, inner_flat_text ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( dom_element.tagName, "TABLE" );
            if ( inner_flat_text ) {
                SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( dom_element, inner_flat_text );
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( SHINKEN.TOOLS.ARRAY.getLength( dom_element.rows ), nb_rows );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( SHINKEN.TOOLS.ARRAY.getLength( dom_element.rows[ 0 ].cells ), nb_col );
        }, timeout );
        return 10;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_DOM || {} );

SHINKEN.TOOLS.TEST_AUTO_IFRAME = (function ( self ) {
    self.getIframeContent = function ( id ) {
        return document.getElementById( id ).querySelector( 'iframe' ).contentWindow.document;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_IFRAME || {} );


SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT = (function ( self ) {
    self.getEnterEvent = function () {
        return new KeyboardEvent( "keydown", {
            bubbles   : true,
            cancelable: true,
            code      : 'Enter',
            key       : 'Enter',
            charCode  : 13,
            keyCode   : 13,
            view      : window,
            shiftKey  : false
        } );
    };
    self.getDownEvent  = function () {
        return new KeyboardEvent( "keydown", {
            bubbles   : true,
            cancelable: true,
            code      : 'ArrowDown',
            key       : 'ArrowDown',
            charCode  : 0,
            keyCode   : 40,
            view      : window,
            shiftKey  : false
        } );
    };
    self.getSpaceEvent = function () {
        return new KeyboardEvent( "keydown", {
            bubbles   : true,
            cancelable: true,
            code      : 'Space',
            key       : ' ',
            charCode  : 0,
            keyCode   : 32,
            view      : window,
            shiftKey  : false
        } );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT || {} );

SHINKEN.TOOLS.TEST_AUTO_XSS = (function ( self ) {
    self.isFunctionExisting = function ( timeout ) {
        setTimeout( function () {
            try {
                eval( 'test_auto_injection' );
                SHINKEN.TOOLS.TEST_AUTO.addError( ' test_auto_injection existing ==> Faille XSS' );
            }
            catch ( e ) {
                //console.log("GSOU", "[ - ]", "[OK]" );
            }
            
        }, timeout );
        return 50;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_XSS || {} );