'use strict';

OBJECT.HostInPageHost           = function ( shinken_element, tpl_element ) {
    //dom_element;
    //checks_host;
    //checks;
    this.element          = shinken_element;
    this.tpl_element      = tpl_element;
    this.is_current       = !!shinken_element;
    this.size_checks      = 0;
    this.size_checks_host = 0;
    this.uuid             = shinken_element ? shinken_element.uuid : tpl_element.uuid;
    this.initCounters( MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.CHECKS, false, MANAGER.__instance_element_distributor.current_element.uuid ) );
    this.getCounterTotal().show_if_null = true;
};
OBJECT.HostInPageHost.prototype = {
    getElement                          : function () {
        return this.is_current ? this.element : this.tpl_element;
    },
    getCheckByID                        : function ( check_uuid, dfe_name ) {
        var _current;
        var _to_test = check_uuid;
        if ( dfe_name ) {
            _to_test = check_uuid + '-' + dfe_name;
        }
        var _to_compare = "";
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            _current    = this.checks_host[ i ];
            _to_compare = _current.is_dfe ? _current.uuid + '-' + _current.key_dfe : _current.uuid;
            if ( _to_compare === _to_test ) {
                return _current;
            }
        }
        return null;
    },
    getCheckInHostElement               : function ( check_uuid, dfe_name ) {
        var _current;
        var _to_test = check_uuid;
        if ( dfe_name ) {
            _to_test = check_uuid + '-' + dfe_name;
        }
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            _current = this.checks_host[ i ];
            if ( _current.getDomUUID() === _to_test ) {
                return _current;
            }
        }
        return null;
    },
    getName                             : function () {
        return this.is_current ? this.element.getName() : this.tpl_element.name;
    },
    getLink                             : function () {
        return this.is_current ? this.element.getName() : this.tpl_element.getLink();
    },
    getTypeName                         : function () {
        var _to_return = this.is_current ? '' : 'tpl';
        switch ( MANAGER.__instance_element_distributor.current_element.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
                _to_return = 'type.cluster' + _to_return;
                break;
            default:
                _to_return = 'type.host' + _to_return;
                break;
        }
        return _( _to_return );
    },
    isOverrideLinkTo                    : function( override ) {
        var _current;
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            _current = this.checks_host[ i ];
            if ( override.is( _current ) ) {
                return true;
            }
        }
        return false;
    },
    setChecks                           : function ( to_set ) {
        var _to_add_final = {};
        this.checks       = to_set;
        this.size_checks  = this.checks.length;
        this.checks_host  = [];
        for ( var i = 0; i < this.size_checks; i++ ) {
            if ( to_set[ i ].is_dfe ) {
                var _dfe_object = App.DFE.getSplittedDataUnique( to_set[ i ].duplicate_foreach );
                for ( var j = 0; j < _dfe_object.length; j++ ) {
                    if ( to_set[ i ].isEnabled() ) {
                        this.checks_host.push( new OBJECT.CheckInPageHost( to_set[ i ], this, _dfe_object[ j ] ) );
                    }
                    else {
                        var _not_used = new OBJECT.CheckInPageHost( to_set[ i ], this, _dfe_object[ j ] );
                        MANAGER.__instance_element_distributor.current_element.setCheckInPageHostOnOverride( _not_used );
                    }
                }
            }
            else if ( to_set[ i ].isEnabled() ) {
                var _to_add                   = new OBJECT.CheckInPageHost( to_set[ i ], this );
                _to_add_final[ _to_add.name ] = _to_add;
            }
            else { //NEEDED TO SET THE CHECK_IN_PAGE_HOST IN OVERRIDE
                var _not_used = new OBJECT.CheckInPageHost( to_set[ i ], this );
                MANAGER.__instance_element_distributor.current_element.setCheckInPageHostOnOverride( _not_used );
            }
        }
        var _keys = Object.keys( _to_add_final );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.checks_host.push( _to_add_final[ _keys[ i ] ] );
        }
        this.checks_host      = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( this.checks_host, OBJECT.CheckInPageHost.FilterTags );
        this.size_checks_host = this.checks_host.length;
    },
    updateExcludeStatus                 : function () {
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].updateExcludeStatus();
        }
        this.updateTagHtml();
    },
    updateHtmlAfterOverrideCommandChange: function ( property ) {
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].updateHtmlAfterOverrideCommandChange( property );
        }
    },
    updateHtmlAfterDataChange           : function ( data ) {
        if ( data.isDfeData() ) {
            return this.updateHtmlAfterDfeDataChange( data );
        }
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].updateHtmlAfterDataChange();
        }
    },
    computeModulationTag                : function () {
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].updateHtmlNameAfterChange();
        }
    },
    updateHtmlAfterDfeDataChange        : function ( data ) {
        var _current;
        for ( var i = 0; i < this.size_checks; i++ ) {
            _current = this.checks[ i ];
            if ( !_current.isEnabled() ) {
                continue;
            }
            if ( !_current.is_dfe ) {
                continue;
            }
            if ( data.name !== _current.duplicate_foreach ) {
                continue;
            }
            var _dfe_object  = App.DFE.getSplittedDataUnique( _current.duplicate_foreach );
            var _current_dom = this.dom_element_table_check.querySelector( '[data-dfe-key="' + _dfe_object[ 0 ].property_name + '"]' );
            var _existing    = SHINKEN.TOOLS.ARRAY.filterWith( this.checks_host, 'uuid', _current.uuid );
            
            for ( var k = 0; k < _existing.length; k++ ) {
                _existing[ k ].setObsolete( true );
            }
            for ( var j = 0; j < _dfe_object.length; j++ ) {
                var _found = false;
                for ( var k = 0; k < _existing.length; k++ ) {
                    if ( _dfe_object[ j ].key === _existing[ k ].key_dfe ) {
                        _found = _existing[ k ];
                        _existing[ k ].setDfeObject( _dfe_object[ j ] );
                        _existing[ k ].setObsolete( false );
                    }
                }
                if ( !_found ) {
                    var _check_new = new OBJECT.CheckInPageHost( _current, this, _dfe_object[ j ] );
                    this.checks_host.push( _check_new );
                    this.size_checks_host = this.checks_host.length;
                    this.buildCheck( _check_new, false, _current_dom );
                    _check_new.linkDomElements();
                }
                else {
                    _found.updateHtmlAfterDataChange( _dfe_object[ j ] );
                }
            }
            for ( var k = 0; k < _existing.length; k++ ) {
                if ( _existing[ k ].is_obsolete ) {
                    _existing[ k ].deleteHtml( _current_dom, this );
                }
            }
        }
        this.size_checks_host = this.checks_host.length;
        
        for ( var i = this.size_checks_host - 1; i >= 0; i-- ) {
            if ( this.checks_host[ i ].is_obsolete ) {
                this.checks_host[ i ].destroy();
                this.checks_host.splice( i, 1 );
            }
        }
        this.size_checks_host = this.checks_host.length;
    },
    linkDomElements                     : function () {
        this.dom_element             = document.getElementById( 'id-host-in-page-host-' + this.uuid );
        this.dom_element_table_check = this.dom_element.querySelector( '.shinken-table-checks' );
        this.initCountersDom();
    },
    appendHtml                          : function () {
        if ( !this.size_checks_host ) {
            return;
        }
        var _to_return      = DOM.Service.createElement( "div", { class: "shinken-container-host-in-page-host", id: 'id-host-in-page-host-' + this.uuid } );
        var _to_add_error   = DOM.Service.createElement( "span", {
            class: "shinken-error-counter shinken-counter shinken-counter-label shinken-hidden", title: _( 'element.title_panel_errors' ), 'data-number': ''
        }, '<span class="shinken-counter-label"></span>' );
        var _to_add_warning = DOM.Service.createElement( "span", {
            class: "shinken-warning-counter shinken-counter shinken-counter-label shinken-hidden", title: _( 'element.title_panel_warnings' ), 'data-number': ''
        }, '<span class="shinken-counter-label"></span>' );
        _to_return.appendChild( _to_add_error );
        _to_return.appendChild( _to_add_warning );
        _to_return.appendChild( this.buildHeader() );
        _to_return.appendChild( this.buildContent() );
        _to_return.appendChild( this.buildFooter() );
        var _container = document.getElementById( "id-shinken-check-list" );
        if ( this.is_first_template ) {
            _container.appendChild( this.buildSeparator( _( 'element.from_templates' ) ) );
        }
        _container.appendChild( _to_return );
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            this.checks_host[ i ].linkDomElements();
        }
        this.linkDomElements( _container );
    },
    buildSeparator                      : function ( _text ) {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-separator-container" } );
        var _to_add    = DOM.Service.createElement( "div", { class: "shinken-separator-title" }, _text );
        var _hr        = DOM.Service.createElement( "hr", { class: 'shinken-hr-sample' } );
        _to_return.appendChild( _to_add );
        _to_return.appendChild( _hr );
        return _to_return;
    },
    buildHeader                         : function () {
        var _to_return = DOM.Service.createElement( "div", { class: "header" } );
        var _text      = this.is_current ? _( 'element.directly_attached' ) : _( 'element.attached_on' );
        _text += "<span class='shinken-template shinken-space'>" + this.getLink() + "</span>";
        _text += "<span class='shinken-between-space-bracket shinken-nb-checks'><span class='shinken-pulsate-parent shinken-window-total-counter shinken-counter' data-number=''><span class='shinken-counter-label'></span></span>" + _( "element.checks" ) + "</span>";
        var _to_add    = DOM.Service.createElement( "h3", { class: "shinken-host-in-page-host-title" }, _text );
        _to_return.appendChild( _to_add );
        return _to_return;
    },
    buildContent                        : function () {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-container-table-checks" } );
        var _table     = DOM.Service.createElement( "table", { class: "shinken-table-checks" } );
        var _thead     = DOM.Service.createElement( "thead" );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-name" }, _( 'element.name' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-tags" }, _( 'element.override' ) + " / " + _( 'element.exclude' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-dfe" }, _( 'element.duplicate_foreach' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-contacts-groups" }, _( 'element.tab_check_contact_group_header' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-command" }, _( 'serviceshosts.check_command' ) ) );
        _thead.appendChild( DOM.Service.createElement( "td", { class: "shinken-tab-check-col-try-check" }, _( 'element.try_check' ) ) );
        _table.appendChild( _thead );
        this.buildChecks( _table );
        _to_return.appendChild( _table );
        return _to_return;
    },
    buildChecks                         : function ( container ) {
        var _current_dfe = '';
        var _is_even     = false;
        var _tbody;
        for ( var i = 0; i < this.size_checks_host; i++ ) {
            if ( !this.checks_host[ i ].element.duplicate_foreach ) {
                this.buildCheck( this.checks_host[ i ], _is_even, container );
            }
            else {
                if ( _current_dfe !== this.checks_host[ i ].element.duplicate_foreach ) {
                    _current_dfe = this.checks_host[ i ].element.duplicate_foreach;
                    if ( _tbody ) {
                        container.appendChild( _tbody );
                    }
                    _tbody   = DOM.Service.createElement( "tbody", { 'data-dfe-key': _current_dfe, class: 'shinken-dfe-check-container' } );
                    _is_even = false;
                    this.checks_host[ i ].buildDFESeparatorHtml( _tbody, _is_even );
                }
                this.buildCheck( this.checks_host[ i ], _is_even, _tbody );
            }
            _is_even = !_is_even;
        }
        if ( _tbody ) {
            container.appendChild( _tbody );
        }
    },
    buildCheck                          : function ( check_in_page_host, _is_even, container ) {
        check_in_page_host.appendHtml( container, _is_even );
        check_in_page_host.appendOverrideHtml( container, _is_even );
        check_in_page_host.appendTryCheckHtml( container, _is_even );
    },
    buildFooter                         : function () {
        return DOM.Service.createElement( "div", { class: "footer" } );
    },
    updateTagHtml                       : function () {
        if ( !this.tpl_element ) {
            return;
        }
        var _use   = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE );
        var _tag   = _use.getSelector().list_element_selected.getTagByName( this.tpl_element.name );
        var _icons = "";
        if ( __list_image_for_tpl[ _tag.getName() ] ) {
            _icons = DOM.Service.createElement( 'img', { class: 'shinken-use-icon-img', onerror: '$(this).hide()', src: "/static/" + http_start_time + "/images/sets/" + _tag.getName() + "/tag.png" } ).outerHTML;
        }
        var _label_html = DOM.Service.createElement( 'span', { class: 'shinken-tag-label' }, _icons + _tag.getName() );
        if ( this.getCounterTotal().counter_final ) {
            var _checks_template_size = DOM.Service.createElement( 'span', { class: 'shinken-checks-tag-label' }, SHINKEN.TOOLS.STRING.format( _( 'element.use_check' + (this.getCounterTotal().counter_final > 1 ? 's' : '') ), this.getCounterTotal().counter_final ) );
            DOM.Service.addElementTo( _checks_template_size, _label_html );
        }
        _tag.setLabel( _label_html.outerHTML );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.HostInPageHost, SHINKEN.OBJECT.CounterInterface );