'use strict';

OBJECT.Messages = function ( footer ) {
    this.messages_error   = [];
    this.messages_warning = [];
    this.messages_beware  = [];
    this.messages_info    = [];
    this.is_dfe           = false;
    this.is_dfe_protected = false;
    this.footer           = footer;
    this.no_duplicate     = false;
};

OBJECT.MESSAGE            = {
    ICON       : {
        ERROR  : '<span class="shinken-icon-error shinkon-warning"></span>',
        WARNING: '<span class="shinken-icon-warning shinkon-warning"></span>',
        BEWARE : '<span class="shinken-icon-warning shinkon-warning-light"></span>'
    },
    MAX_ERROR  : 5,
    MAX_WARNING: 5
};
OBJECT.Messages.prototype = {
    addMessage         : function ( type_message, text ) {
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.messages_error.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.messages_warning.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.messages_beware.push( new OBJECT.Message( type_message, text ) );
                break;
            default:
                this.messages_info.push( new OBJECT.Message( type_message, text ) );
                break;
        }
    },
    addMessages        : function ( messages ) {
        if ( !messages ) {
            return;
        }
        var _size = messages.length;
        var _current_message;
        for ( var i = 0; i < _size; i++ ) {
            _current_message = messages[ i ];
            this.addMessage( _current_message._type, _current_message._text );
        }
    },
    hasMessage         : function () {
        return this.hasError() || this.hasWarning() || this.hasBeware() || this.hasInfo();
    },
    hasError           : function () {
        return this.messages_error.length > 0;
    },
    hasWarning         : function () {
        return this.messages_warning.length > 0;
    },
    hasBeware          : function () {
        return this.messages_beware.length > 0;
    },
    hasInfo            : function () {
        return this.messages_info.length > 0;
    },
    getStatus          : function () {
        if ( this.hasError() ) {
            return COMPONENT.CONST.STATUS.ERROR;
        }
        if ( this.hasWarning() ) {
            return COMPONENT.CONST.STATUS.WARNING;
        }
        if ( this.hasBeware() ) {
            return COMPONENT.CONST.STATUS.BEWARE;
        }
        return COMPONENT.CONST.STATUS.NONE;
    },
    buildMessage       : function ( is_default, template_name ) {
        
        var _status = this.getStatus();
        if ( _status === COMPONENT.CONST.STATUS.NONE ) {
            return '';
        }
        var _to_return          = '<div class="shinken-tooltip-message text-left">';
        var _show_extra_message = false;
        if ( this.hasError() ) {
            _show_extra_message = true;
            _to_return += '<span class="text-underline">' + _( 'element.tooltip_message_invalid_syntax' ) + '</span><br>';
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'element.tooltip_message_tag_error' ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_error, OBJECT.MESSAGE.MAX_ERROR );
            _to_return += '</ol>';
        }
        if ( this.hasWarning() ) {
            _show_extra_message = true;
            _to_return += OBJECT.MESSAGE.ICON.WARNING + _( 'element.tooltip_message_tag_warning' ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_warning, OBJECT.MESSAGE.MAX_WARNING );
            _to_return += '</ol>';
        }
        if ( !this.is_dfe_protected && _show_extra_message && this.is_dfe ) {
            var _format_to_follow        = is_default ? _( 'element.tooltip_dfe_common_default_value' ) : _( 'element.tooltip_dfe_common' );
            var _note_to_update_template = template_name ? '<div class=\'container-legend \'>' + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_common_go_tpl' ), template_name ) + '</div>' : "";
            _to_return                   = _to_return +
                                           '<div class=\'container-legend\'>' + _format_to_follow + '</div>' +
                                           _note_to_update_template;
            
        }
        if ( this.hasBeware() && this.is_dfe ) {
            if ( !this.is_dfe_protected && _show_extra_message ) {
                _to_return += '<hr>';
            }
            _to_return += '<ol>' + OBJECT.MESSAGE.ICON.BEWARE + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_deleted_part_1' ), this.property_name );
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
            _to_return += '</ol>';
        }
        else if ( this.hasBeware() ) {
            _to_return += OBJECT.MESSAGE.ICON.BEWARE + _( 'element.tooltip_message_tag_warning' ) + '<br>';
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
        }
        if ( this.footer ) {
            _to_return += this.footer;
        }
        
        _to_return += '</div>';
        return _to_return;
    },
    buildMessageForList: function ( list, max ) {
        var _to_return = '';
        var _size      = Math.min( list.length, max );
        var _to_add;
        var _duplicate = {};
        for ( var i = 0; i < _size; i++ ) {
            _to_add = list[ i ].buildHtml();
            if ( this.no_duplicate ) {
                var _md5 = SHINKEN.TOOLS.MD5.MD5( _to_add );
                if ( _duplicate[ _md5 ] ) {
                    continue;
                }
                _duplicate[ _md5 ] = true;
            }
            _to_return += _to_add;
        }
        return _to_return;
    }
};

OBJECT.Message = function ( type, text ) {
    this._type = type;
    this._text = text;
};

OBJECT.Message.prototype = {
    buildHtml: function () {
        return '<li class=\'' + this._type + '\'>' + this._text + '</li>';
    }
};