'use strict';
OBJECT.ShinkenElement                    = function () {
    //key_name
    this.name_element = '';
    this.type         = '';
    this.is_enabled   = true;
    this.phase        = OBJECT.CONST.ELEMENT.PHASE.INIT;
};
OBJECT.ShinkenElement.prototype          = {
    FIELD                       : OBJECT.CONST.ELEMENT.FIELD,
    init                        : function () {
    },
    updateData                  : function ( datas ) {
        if ( !datas ) {
            return;
        }
        var _keys     = Object.keys( datas );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, datas[ _currentKey ] );
        }
        this.computeName();
    },
    //********************************************  SETTER GETTER   **************************************************//
    setPhase                    : function ( to_set ) {
        var self = this;
        switch ( to_set ) {
            case OBJECT.CONST.ELEMENT.PHASE.EDITING:
                if ( this.phase === OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED ) {
                    return;
                }
                break;
        }
        this.phase = to_set;
        switch ( this.phase ) {
            case OBJECT.CONST.ELEMENT.PHASE.SAVING_FAILED:
                var _all_properties = MANAGER.__instance_property_distributor.getAllElements();
                for ( var i = 0, _size = _all_properties.length; i < _size; i++ ) {
                    _all_properties[ i ].checkErrorWarning();
                }
                break;
        }
    },
    setType                     : function ( to_set ) {
        this.type = to_set;
    },
    getType                     : function () {
        return this.type;
    },
    getHelpType                 : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                return OBJECT.CONST.ELEMENT.TYPE.HOSTS;
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                return OBJECT.CONST.ELEMENT.TYPE.CLUSTERS;
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                return "services";
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
                return OBJECT.CONST.ELEMENT.TYPE.CONTACTS;
        }
        return this.type;
    },
    isType                      : function ( types ) {
        if ( typeof types === 'string' ) {
            types = [types];
        }
        for ( var i = 0, _size_i = types.length; i < _size_i; i++ ) {
            if ( this.type === types[ i ] ) {
                return true;
            }
        }
        return false;
    },
    isNew                       : function () {
        return this.is_new;
    },
    isCheck                     : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                return true;
        }
        return false;
    },
    isCluster                   : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                return true;
        }
        return false;
    },
    isTemplate                  : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
                return true;
        }
        return false;
    },
    canHaveData                 : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_DATA:
                return true;
        }
        return false;
    },
    canHaveCheck                : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                return true;
        }
        return false;
    },
    canHaveUserRights           : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                return true;
        }
        return false;
    },
    canHaveTemplate             : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                return true;
        }
        return false;
    },
    setData                     : function ( key, value ) {
        switch ( key ) {
            case this.FIELD.ID:
                this.setUUID( value );
                break;
            case this.FIELD.SERVICE_OVERRIDES:
                this.setOverride( value );
                break;
            case this.FIELD.SERVICE_EXCLUDES_BY_ID:
                this.setExclude( value );
                break;
            case this.FIELD.ENABLED:
                this.setEnabled( value );
                break;
            case this.FIELD.SOURCES:
            case this.FIELD.IMPORT_DATE:
            case this.FIELD.USE:
                this[ key ] = value;
                break;
            case this.FIELD.SYNC_KEYS:
            case this.FIELD.LAST_MODIFICATION:
            case '_SE_UUID':
            case '_SE_UUID_HASH':
                break;
            case '@metadata':
                this.setMetadata( value );
                break;
            case 'duplicate_foreach':
                this[ key ]           = value;
                this.is_dfe           = true;
                this.is_dfe_protected = SHINKEN.TOOLS.ENCRYPTION.isProtectedField( value );
                break;
            case this.FIELD.WORK_AREA_INFO:
                this.setWorkAreaData( value );
                break;
            default:
                this[ key ] = value;
            
        }
    },
    setMetadata                 : function ( to_set ) {
        this.setType( to_set.type );
        this.host_uuid = to_set.host_uuid;
        if ( !this.host_uuid && MANAGER.__instance_element_distributor && MANAGER.__instance_element_distributor.current_element ) {
            //BIDOUILE CAR IL N Y A PAS LES HOST_UUID POUR LES ELEMENTS NEW
            switch ( MANAGER.__instance_element_distributor.current_element.type ) {
                case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
                    if ( this.type === OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST ) {
                        this.host_uuid = MANAGER.__instance_element_distributor.current_element.uuid;
                    }
                    break;
                case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
                    if ( this.type === OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST ) {
                        this.host_uuid = MANAGER.__instance_element_distributor.current_element.uuid;
                    }
                    break;
            }
        }
        this.host_type   = to_set.host_type;
        this.is_new      = to_set.new;
        this.is_creation = to_set.in_creation || false;
        this.has_data    = to_set.has_data;
        this.setStatus( to_set.state );
    },
    setUUID                     : function ( to_set ) {
        this.uuid = to_set;
    },
    setEnabled                  : function ( to_set ) {
        if ( to_set === '1' ) {
            this.is_enabled = true;
        }
        else if ( to_set === '0' ) {
            this.is_enabled = false;
        }
    },
    setStatus                   : function ( to_set ) {
        this[ OBJECT.CONST.ELEMENT.FIELD.STATUS ] = to_set;
        if ( to_set === OBJECT.CONST.ELEMENT.STATUS.NEW ) {
            this.is_new = true;
        }
    },
    cleanChecks                 : function () {
        if ( !this.canHaveCheck() ) {
            return;
        }
        this.checks         = [];
        this.size_dfe_check = 0;
    },
    addCheck                    : function ( to_add ) {
        this.checks.push( to_add );
        if ( to_add.is_dfe ) {
            this.size_dfe_check++;
        }
    },
    isEnabled                   : function () {
        return this.is_enabled;
    },
    setWorkAreaData             : function ( data ) {
        this.work_area_status = data[ 'status' ];
    },
    getName                     : function () {
        return this.name_element;
    },
    getUUID                     : function () {
        return this.uuid;
    },
    getSEUUID                   : function () {
        return OBJECT.ShinkenElement.generateSEUUID( this.type, this.uuid );
    },
    getAllData                  : function () {
        var _to_return = {};
        var keys       = Object.keys( this );
        var _current;
        for ( var i = 0, _size = keys.length; i < _size; i++ ) {
            _current = keys[ i ];
            if ( SHINKEN.TOOLS.STRING.startsWith( _current, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                _to_return[ _current ] = this[ _current ];
            }
        }
        delete _to_return[ "_SYNC_KEYS" ];
        return _to_return;
    },
    computeKeyName              : function () {
        switch ( this.type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
                this.key_name = 'host_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.HOST_GROUPS:
                this.key_name = 'hostgroup_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
                this.key_name = 'service_description';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.COMMANDS:
                this.key_name = 'command_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_GROUPS:
                this.key_name = 'contactgroup_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
                this.key_name = 'name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
                this.key_name = 'contact_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.ESCALATIONS:
                this.key_name = 'escalation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_BUSINESS_IMPACT:
                this.key_name = 'business_impact_modulation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_DATA:
                this.key_name = 'macromodulation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_RESULT:
                this.key_name = 'resultmodulation_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.NOTIFICATION_WAYS:
                this.key_name = 'notificationway_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.TIME_PERIODS:
                this.key_name = 'timeperiod_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.DISCOVERY:
                this.key_name = 'discovery_name';
                break;
            case OBJECT.CONST.ELEMENT.TYPE.SYNCHRONIZER_LINKER:
                this.key_name = PROPERTY.CONST.NAME.SYNC_NAME;
                break;
            default:
                console.error( "[type not managed] ==>", this.type );
        }
    },
    computeName                 : function () {
        this.computeKeyName();
        this.name_element = this[ this.key_name ];
    },
    getValuesSplitted           : function ( property_name ) {
        var _to_return = [];
        if ( !this[ property_name ] ) {
            return _to_return;
        }
        var _modulation_list;
        var _modulation_name;
        switch ( property_name ) {
            case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
                _modulation_name = PROPERTY.CONST.NAME.RESULTMODULATION_NAME;
                break;
            case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
                _modulation_name = PROPERTY.CONST.NAME.MACROMODULATION_NAME;
                break;
            default:
                _to_return = SHINKEN.TOOLS.STRING.startsWith( this[ property_name ], PROPERTY.CONST.STATE_VALUE_PLUS.ON ) ? this[ property_name ].substr( 1 ) : this[ property_name ];
                _to_return = _to_return.split( ',' );
                break;
        }
        if ( _modulation_name ) {
            _modulation_list = this[ property_name ];
            _to_return       = [];
            if ( typeof _modulation_list !== 'string' ) {
                for ( var i = 0, _size_i = _modulation_list.length; i < _size_i; i++ ) {
                    _to_return.push( _modulation_list[ i ][ _modulation_name ] );
                }
            }
            else {
                _to_return = _modulation_list.split( ',' );
            }
        }
        
        return _to_return;
    },
    getValidCheck               : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.checks.length; i < _size_i; i++ ) {
            if ( !this.checks[ i ].is_obsolete ) {
                _to_return.push( this.checks[ i ] );
            }
        }
        return _to_return;
    },
    //********************************************  BASE   **************************************************//
    buildBaseUrl                : function () {
        var _to_return = "item_id=" + this.getUUID();
        _to_return += "&item_type=" + this.getType();
        _to_return += "&item_state=stagging";
        return _to_return;
    },
    //********************************************  MODULATION   **************************************************//
    getTypeModulation           : function ( modulation_name ) {
        if ( !this[ modulation_name ] ) {
            return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE;
        }
        switch ( this[ modulation_name ] ) {
            case PROPERTY.CONST.STATE_VALUE_PLUS.ON:
                return OBJECT.CONST.ELEMENT.MODULATION.TYPE.PLUS;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                return OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED;
        }
        var _current;
        for ( var i = 0, _size = this[ modulation_name ].length; i < _size; i++ ) {
            _current = this[ modulation_name ][ i ];
            if ( _current.missing || _current.invalid ) {
                return OBJECT.CONST.ELEMENT.MODULATION.TYPE.ERROR;
            }
        }
        return OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING;
    },
    //********************************************  MODULATION   **************************************************//
    getDataToSave               : function ( type ) {
        var _to_return = {};
        switch ( type ) {
            case OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK:
                _to_return[ OBJECT.CONST.ELEMENT.FIELD.ITEM_TYPE ] = this.getType();
                _to_return[ OBJECT.CONST.ELEMENT.FIELD.ID ]        = this.getUUID();
                _to_return[ "exists" ]                             = true;
                _to_return[ "name" ]                               = this.getName();
                break;
        }
        return _to_return;
    },
    //********************************************  EXCLUDE   **************************************************//
    setExclude                  : function ( to_set ) {
        this.exclude = new OBJECT.ServiceExcludes( to_set );
    },
    changeExcludeStatus         : function ( check_in_page_host ) {
        if ( !this.exclude ) {
            this.exclude = new OBJECT.ServiceExcludes();
        }
        var _to_return       = this.exclude.changeExcludeStatus( check_in_page_host );
        var _other_candidate = App.Elements.ChecksTab.getAllCheckByID( check_in_page_host.uuid, check_in_page_host.key_dfe );
        for ( var i = 0, _size_i = _other_candidate.length; i < _size_i; i++ ) {
            _other_candidate[ i ].updateExcludeStatus();
        }
        return _to_return;
    },
    getExcludeStatus            : function ( check_in_page_host ) {
        if ( !this.exclude ) {
            return OBJECT.CONST.EXCLUDE_STATUS.OFF;
        }
        return this.exclude.getExcludeStatus( check_in_page_host );
    },
    //********************************************  OVERRIDE   **************************************************//
    setOverride                 : function ( to_set ) {
        this.override = new OBJECT.ServiceOverrides( to_set );
    },
    addOverrideByProperty       : function ( property, check_in_page_host, host_in_page_host ) {
        if ( !this.override ) {
            this.override = new OBJECT.ServiceOverrides();
        }
        this.override.addOverrideByProperty( property, check_in_page_host, host_in_page_host );
    },
    hasOverride                 : function ( check_in_page_host ) {
        if ( !this.override ) {
            return false;
        }
        return this.override.hasOverride( check_in_page_host );
    },
    setCheckInPageHostOnOverride: function ( check_in_page_host ) {
        if ( !this.override ) {
            return false;
        }
        return this.override.setCheckInPageHostOnOverride( check_in_page_host );
    },
    removeParentCounter         : function ( check_in_page_host ) {
        if ( !this.override || !check_in_page_host ) {
            return;
        }
        this.override.removeParentCounter( check_in_page_host );
    },
    getOverrideValue            : function ( prop_name, check_in_page_host ) {
        if ( !this.override || !check_in_page_host ) {
            return null;
        }
        return this.override.getOverrideValue( prop_name, check_in_page_host );
    },
    
    hasOverrideModulation       : function ( check_host, property_name ) {
        if ( !this.override ) {
            return false;
        }
        return this.override.hasOverrideModulation( check_host, property_name );
    },
    cleanOverrideFor            : function ( _check_in_host ) {
        if ( !this.override ) {
            return;
        }
        var _nb_override = this.override.cleanOverrideFor( _check_in_host );
        if ( !_nb_override ) {
            delete this.override;
        }
        return _nb_override;
    },
    validateOverride            : function () {
        if ( !this.override ) {
            return;
        }
        this.override.validate();
    },
    unSetOverrideCheckInPageHost: function ( check_in_page_host ) {
        if ( !this.override ) {
            return;
        }
        this.override.unSetOverrideCheckInPageHost( check_in_page_host );
    }
};
OBJECT.ShinkenElement.generateSEUUID     = function ( type, uuid ) {
    return "core-" + OBJECT.ShinkenElement.generateSEUUIDType( type ) + "-" + uuid;
};
OBJECT.ShinkenElement.generateSEUUIDType = function ( type ) {
    switch ( type ) {
        case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
        case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            return "host";
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
        case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
            return "service";
        case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
        case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
            return "contact";
    }
    return SHINKEN.TOOLS.STRING.getSubStringUntil( type, 0, 1 );
};

OBJECT.ShinkenElementFactory = function ( data ) {
    var _to_return = new OBJECT.ShinkenElement();
    _to_return.updateData(data);
    return _to_return;
};