'use strict';

OBJECT.TemplateProperty           = function ( name, template_name, value, _template_id ) {
    // name
    // value
    // label
    // data
    // value_inherited
    // flat_value
    // flat_value_inherited
    // state (has plus)
    // is_heritage_stopped
    // tags
    // size_tags
    // is_stopped
    // is_last
    this.name = name;
    this.setTemplateName( template_name, _template_id );
    this.init( value );
};
OBJECT.TemplateProperty.prototype = {
    init              : function ( value ) {
        this.state               = COMPONENT.CONST.BTN_STATE.OFF;
        this.is_stopped          = false;
        this.is_heritage_stopped = false;
        this.is_last             = false;
        this.setValue( value );
    },
    updateValueWithUse: function ( property ) {
        if ( !this.hasPlus() ) {
            return;
        }
        if ( property.value === PROPERTY.CONST.CUSTOM_SELECT.NONE ||
             property.value === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
            this.is_heritage_stopped = true;
        }
        if ( this.is_heritage_stopped ) {
            return;
        }
        
        var _values = property.values;
        this.values = SHINKEN.TOOLS.ARRAY.concatUnique( this.values, _values );
        this._computeTags();
        if ( !property.hasPlus() ) {
            this.is_heritage_stopped = true;
        }
    },
    hasPlus           : function () {
        return (this.state === COMPONENT.CONST.BTN_STATE.ON);
    },
    getTags           : function () {
        return this.tags;
    },
    isEmpty           : function () {
        var _property = MANAGER.__instance_property_distributor.findElement( this.name );
        switch ( _property.type ) {
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                return !this.size_tags;
            default:
                return !this.value;
        }
        return true;
    },
    setValue          : function ( to_set ) {
        if ( to_set && to_set.type === PROPERTY.CONST.TYPES.DATA ) {
            this.setValueData( to_set );
            return;
        }
        this.value = to_set;
        
        to_set        = to_set + "";
        var _has_plus = SHINKEN.TOOLS.STRING.extractStringIfBeginningBy( to_set, PROPERTY.CONST.STATE_VALUE_PLUS.ON );
        if ( _has_plus !== false ) { //CAN BE EMPTY ("")
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
            to_set = _has_plus;
        }
        switch ( to_set ){
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                this.value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                this.value = PROPERTY.CONST.CUSTOM_SELECT.NONE;
                break;
        }
        this.label  = this.value;
        this.values = to_set ? to_set.split( ',' ) : [];
        this._computeTags();
    },
    setValueData      : function ( to_set ) {
        this.data   = to_set;
        this.value  = to_set.value + "";
        this.label  = this.value;
        this.values = this.value ? this.value.split( ',' ) : [];
    },
    setState          : function ( to_set ) {
        this.state = to_set;
    },
    setTags           : function ( to_set ) {
        this.tags = to_set;
    },
    setIsStopped      : function ( to_set ) {
        this.is_stopped = to_set;
    },
    setTemplateName   : function ( to_set, _template_id ) {
        this.template_name = to_set;
        if ( _template_id ) {
            this.template_id = _template_id;
        }
    },
    setIsLast         : function ( to_set ) {
        this.is_last = to_set;
    },
    _computeTags      : function () {
        var _property = MANAGER.__instance_property_distributor.findElement( this.name );
        if ( !_property ) {
            return;
        }
        if ( _property.type !== PROPERTY.CONST.TYPES.MULTI_SELECT ) {
            return;
        }
        this.size_tags = 0;
        var _size      = this.values.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = this._addTag( this.values[ i ], _property );
        }
        this.setTags( _to_return );
    },
    _createElementList: function ( name, state, type ) {
        var _element = new OBJECT.ElementList();
        _element.setName( name );
        _element.setState( state );
        _element.setType( type );
        return _element;
    },
    _addTag           : function ( key_name, _property ) {
        var _element = this._createElementList( key_name, 'inherited', OBJECT.CONST.ELEMENT_LIST.TYPE.INHERITANCE );
        var _tag     = new COMPONENT.Tag();
        _tag.setElement( _element );
        var _full_link = '';
        if ( _property && MANAGER.__instance_element_distributor.current_user.is_admin ) {
            var _element = _property.getSelector().list_element.getElement( key_name );
            if ( _element ) {
                var _link_1 = _element.getItemType();
                var _link_2 = _element.uuid;
                if ( _element.state === COMPONENT.CONST.TAG.STATE.NEW ) {
                    _link_2 = _link_2 + '?new=1';
                }
                _full_link = [ _link_1, _link_2 ];
            }
        }
        _tag.buildHTML( "", "", _full_link );
        this.size_tags++;
        return _tag;
    }
};