//priority 20
'use strict';


PROPERTY.Interface = function () {
};

PROPERTY.Interface.prototype = {
    initDomElement         : function ( element ) {
        this.name             = element.dataset.name;
        this.type             = element.dataset.type;
        this.default_value    = element.dataset.defaultValue;
        this.selectors        = {};
        this.dom_element      = element;
        this.default_label    = element.dataset.defaultLabel;
        this.none_label       = element.dataset.noneLabel;
        this.item_type        = element.dataset.itemType;
        this.link_id          = element.dataset.linkId;
        this.unit             = element.dataset.unit;
        this.custom_selected  = element.dataset.customSelected;
        this.is_not_heritable = element.dataset.isPropNotHeritable;
        this.is_synchro       = !!element.dataset.isSynchro;
        if ( this.is_synchro ) {
            this.synchro_name      = element.dataset.synchroName;
            this.synchronized_name = element.dataset.synchronizedName;
        }
        this.hide_import_key = parseInt( element.dataset.hideImportKey );
        this.state_plus      = parseInt( element.dataset.statePlus );
        this.has_plus        = this.state_plus !== COMPONENT.CONST.BTN_STATE.DISABLED;
        this.is_ordered      = !!parseInt( this.dom_element.dataset.isOrdered );
        this.is_disabled     = element.classList.contains( 'shinken-disabled' );
        this.computeTabId();
        this.initCounters();
        this.setOverride( element.dataset.override );
        this.setMassChange( element.dataset.isMassChange );
        
        this.setIsRequired( element.dataset.isRequired );
        this.tag_information = new COMPONENT.TagInformation( element.querySelector( ".shinken-prop-cell-label .shinken-information-tag" ) );
        this._finalyseErrorWarning();
    },
    _initWithCustomSelect  : function () {
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.setStateInheritance( false );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                        this.setStateInheritance( true );
                        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                        this.setStateInheritance( true );
                        this.changeNoOverrideButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.setStateInheritance( false );
                        this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                if ( this.state ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.component_btn_default.setState( COMPONENT.CONST.BTN_STATE.ON );
                        break;
                }
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                switch ( this.last_list_element_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                        if ( !this.component_btn_inheritance.isSet() ) {
                            this.setStateInheritance( false );
                            this.state_inheritance = false;
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT );
                        }
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                        if ( !this.component_btn_inheritance.isSet() ) {
                            this.setStateInheritance( false );
                            this.state_inheritance = false;
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
                        }
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        if ( this.component_btn_inheritance.isSet() ) {
                            this.setStateInheritance( true );
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE );
                        }
                        break;
                }
                
                if ( this.last_list_element_selected ) {
                    return;
                }
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                        this.setLastItemSelected( this.component_btn_inheritance.isSet() ? PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT );
                        if ( this.is_override ) {
                            this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE );
                        }
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                        this.setLastItemSelected( this.custom_selected );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                        this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                        this.setLastItemSelected( PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE );
                        break;
                    
                    default:
                        var _last_element_selected = this.getSelector().list_element.getFirstSelectedElement();
                        if ( !_last_element_selected ) {
                            return;
                        }
                        this.setLastItemSelected( _last_element_selected.element.name );
                        this.getSelector().last_selected_key_name = this.last_list_element_selected;
                }
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                switch ( this.custom_selected ) {
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                        this.setStateInheritance( false );
                        break;
                    case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE:
                        this.setStateInheritance( true );
                        break;
                }
                break;
        }
    },
    _finalyseErrorWarning  : function () {
        if ( this.type === PROPERTY.CONST.TYPES.DATA && !this.is_override && !this.is_mass_change ) {
            this.setParentCounter( this.group_data );
        }
        else {
            this.setParentCounter( this.getWindow() );
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askCheckErrorWarning   : function () {
        if ( this.ask_check_error_warning ) {
            clearTimeout( this.ask_check_error_warning );
        }
        var self                     = this;
        this.ask_check_error_warning = setTimeout( function () {
            self.checkErrorWarning();
            self.ask_check_error_warning = null;
        }, 500 );
    },
    checkErrorWarning      : function ( force_mass_change ) {
        this.computeErrors( force_mass_change );
        this.setErrors();
    },
    computeErrors          : function ( force_mass_change ) {
        this.counter_temp_error   = 0;
        this.counter_temp_warning = 0;
        this.computeErrorsSpecifics( force_mass_change );
    },
    setErrors              : function () {
        this.setErrorsSpecific();
        var _key = this.uuid ? this.uuid : this.name;
        this.setError( _key, this.counter_temp_error );
        this.setWarning( _key, this.counter_temp_warning );
        this.getCounterError().setTooltip( this.counter_error_tooltip, SHINKEN_TOOLTIP.TYPE.ERROR_BORDER );
        this.getCounterWarning().setTooltip( this.counter_warning_tooltip, SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
    },
    computeErrorsSpecifics : function () {
    },
    setErrorsSpecific      : function () {
    },
    clickOnBtnInheritance  : function () {
        this.setStateInheritance( !this.state_inheritance );
        this._computeState();
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.DATA:
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                this.component_input.updateView( this.state_inheritance, true, this.component_btn_inheritance.isSet() );
                break;
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    specificTreatment      : function () {
    },
    onFocus                : function () {
    },
    onFocusOut             : function ( dom_element ) {
        this.___onFocusOut( dom_element );
    },
    clickOnSelector        : function ( event ) {
        event.stopPropagation();
        if ( this.is_disabled ) {
            return false;
        }
        var _target_component = this.getSelectViaDomElement( event.target );
        _target_component.clickOnSelector( event.target );
        this.hidePopup( _target_component );
    },
    clickOnItemSelector    : function ( key_name, dom_element, target_component ) {
        if ( this.is_disabled ) {
            return false;
        }
        if ( !target_component ) {
            target_component = this.getSelectViaDomElement( dom_element );
        }
        if ( target_component.__class === SHINKEN.TOOLS.CLASS.CONST.COMPONENT.SELECT && target_component !== this.getSelector() ) {
            target_component.clickOnItemSelector( this.name, key_name );
        }
        this.clickOnItemSelector_end( target_component, key_name, dom_element );
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    clickOnItemSelector_end: function ( target_component, key_name, dom_element ) {
        if ( this.is_mass_change ) {
            MANAGER.ListenerEventManager.clickOnItemSelectorMassChange( this, target_component, key_name, dom_element );
        }
        if ( target_component.__class === SHINKEN.TOOLS.CLASS.CONST.COMPONENT.SELECT && target_component !== this.getSelector() ) {
            target_component.computeTitle( true );
            this.updateView();
            return;
        }
        this.___clickOnItemSelector( target_component, key_name, dom_element );
    },
    clickOnInput           : function () {
        this.hidePopup();
    },
    clickOnCheckboxInput   : function ( name ) {
        this.___clickOnCheckboxInput( name );
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    clickOnRadioBtn        : function ( dom_element, value ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( typeof value === "undefined" ) {
            value = dom_element.value;
        }
        this.___clickOnRadioBtn( value );
        fire_element_is_modifie();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    keydown                : function ( event, key_code ) {
    },
    //********************************************  INHERITANCE     **************************************************//
    updateWithTemplate     : function ( templates, is_update ) {
        if ( is_update ) {
            this.cleanBeforeUpdate();
        }
        if ( this.is_not_heritable || !templates ) {
            this._initWithCustomSelect();
            this._computeState();
            this.updateView();
            return;
        }
        var _template_properties = templates.getProperties( this.name );
        this.updateAllTemplatesCustomTags( _template_properties );
        var _has_template = this.component_btn_inheritance.setTemplateProperty( _template_properties );
        var _label;
        var _template;
        var _inherited_label;
        if ( _has_template ) {
            switch ( this.type ) {
                case PROPERTY.CONST.TYPES.MULTI_SELECT:
                    _template            = _template_properties[ 0 ];
                    this.inherited_value = _template.value;
                    switch ( this.inherited_value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _template.label  = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE ).getLabel();
                            _inherited_label = this._computeInheritedLabelHtml( _template.template_name, _template.label );
                            this.getSelector().list_element.getListSelectElement( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ).updateHtmlLabel( _inherited_label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.BOOLEAN:
                    this.inherited_value            = _template_properties[ 0 ].value;
                    this.inherited_value            = this._computeInheritedLabel( this.inherited_value );
                    _template_properties[ 0 ].label = this.inherited_value;
                    this.component_radio_list.getRadioButton( PROPERTY.CONST.DEFAULT_BUTTON_LABEL ).setInheritedLabel( this.inherited_value );
                    break;
                
                case PROPERTY.CONST.TYPES.RANGE:
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                    this.inherited_value = _template_properties[ 0 ].value;
                    switch ( this.inherited_value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            this.inherited_value = this.default_value;
                    }
                    _label = this._computeInheritedLabel( this.inherited_value );
                    this.component_btn_default.setInheritedLabel( _label );
                    
                    _template_properties[ 0 ].label = _label;
                    if ( this.type === PROPERTY.CONST.TYPES.RANGE_WITH_INPUT ) {
                        this.component_input_range.component_input.setPlaceholder( _label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                    this.inherited_value = _template_properties[ 0 ].value;
                    _label               = this._computeInheritedLabel( this.inherited_value );
                    this.component_btn_default.setInheritedLabel( _label );
                    _template_properties[ 0 ].label = _label;
                    this.component_checkbox.setCheckedInheritance( this.inherited_value );
                    break;
                case PROPERTY.CONST.TYPES.CHECKBOX_MULTI:
                    this.inherited_value = _template_properties[ 0 ].value;
                    this.component_btn_default.setInheritedLabel( this.inherited_value );
                    _template_properties[ 0 ].label = this.inherited_value;
                    this.computeInheritanceCheckbox();
                    break;
                
                case PROPERTY.CONST.TYPES.SINGLE_SELECT:
                    _template            = _template_properties[ 0 ];
                    this.inherited_value = _template.value;
                    _template.label      = this._computeInheritedLabel( this.inherited_value );
                    switch ( _template.value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _template.label = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE ).getLabel();
                            break;
                    }
                    if ( this.inherited_value ) {
                        _inherited_label = this._computeInheritedLabelHtml( _template.template_name, _template.label, "--" );
                        this.getSelector().list_element.getListSelectElement( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ).updateHtmlLabel( _inherited_label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                    _template               = _template_properties[ 0 ];
                    this.inherited_value    = _template.value;
                    var _elements_command   = this.inherited_value.split( '!' );
                    this.inherited_cmd_name = _elements_command[ 0 ];
                    this.inherited_cmd_args = _elements_command.splice( 1 ).join( '!' );
                    
                    _template.label = this._computeInheritedLabel( this.inherited_value );
                    switch ( _template.value ) {
                        case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                        case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                            _template.label = this.getSelector().list_element.getElement( PROPERTY.CONST.CUSTOM_SELECT.NONE ).getLabel();
                            break;
                    }
                    if ( this.is_override ) {
                        _label = this.inherited_cmd_args + ' [ ' + _( 'element.in_template' ) + ' ' + _template.template_name + ' ]';
                        this.component_input.setPlaceholder( _label );
                    }
                    else if ( this.inherited_value ) {
                        _inherited_label = this._computeInheritedLabelHtml( _template.template_name, _template.label );
                        this.getSelector().list_element.getListSelectElement( PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE ).updateHtmlLabel( _inherited_label );
                    }
                    break;
                case PROPERTY.CONST.TYPES.STRING_INPUT:
                case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                    _template = _template_properties[ 0 ];
                    if ( this.is_protected ) {
                        _label                          = PROPERTY.CONST.DATA.PROTECTED_PLACEHOLDER;
                        _template_properties[ 0 ].value = SHINKEN.TOOLS.ENCRYPTION.getDefaultLabel();
                    }
                    else {
                        if ( _template.value === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                            _label = _( 'element.forced_default' );
                            if ( this.default_value ) {
                                _label += " " + this.default_value;
                            }
                        }
                        else {
                            _label = _template.value;
                        }
                        _label += ' [' + _( 'element.in_template' ) + ' ' + _template.template_name + ']';
                    }
                    this.component_input.setPlaceholder( _label );
                    break;
                case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                    _template = _template_properties[ 0 ];
                    this._updateCfgInheritedLabel( _template.value );
                    break;
            }
        }
        else {
            switch ( this.type ) {
                case PROPERTY.CONST.TYPES.RANGE:
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                    this.inherited_value = this.default_value;
                    if ( this.state_inheritance ) {
                        this.component_input_range.setValue( this.inherited_value );
                    }
                    break;
            }
        }
        this._computeBtnInheritance();
        this.component_btn_inheritance.askUpdateHTML();
        this._initWithCustomSelect();
        this.updateWithTemplateSpecific();
    },
    cleanBeforeUpdate      : function () {
    },
    
    updateWithTemplateSpecific  : function () {
    },
    updateAllTemplatesCustomTags: function ( _template_properties ) {
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStateInheritance         : function ( to_set ) {
        this.state_inheritance = to_set;
        this.component_btn_inheritance.setState( this.state_inheritance ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.OFF );
        this.setStateInheritanceSpecific();
    },
    setStateInheritanceSpecific : function () {
    },
    getName                     : function () {
        return this.name;
    },
    getLabelViaDom              : function () {
        return this.dom_element.querySelector( '.shinken-property-label .shinken-label' ).innerText;
    },
    getNameOrUUID               : function () {
        return this.getName();
    },
    getParentName               : function () {
        return this.name;
    },
    getState                    : function () {
        return this.state;
    },
    setInheritanceStatus        : function ( to_set, message ) {
        DOM.Service.setDataSet( this.dom_element, 'inheritanceStatus', to_set );
        this.setInheritanceStatusTooltip( to_set, message );
    },
    setInheritanceStatusTooltip : function ( status, to_set ) {
        var _element = this.dom_element.querySelector( '.shinken-status-tag[data-status="' + status + '"]' );
        if ( _element ) {
            _element.setAttribute( 'shi-tip-html', to_set );
        }
    },
    setMassChange               : function ( _to_set ) {
        this.is_mass_change = !!_to_set;
        if ( this.is_mass_change ) {
            this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangeActionState" );
            if ( this.type === PROPERTY.CONST.TYPES.MULTI_SELECT ) {
                if ( this.is_ordered ) {
                    this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangeActionExtraState" );
                }
                this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ]  = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangeActionExtraElement" );
                this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangeActionSingleElement" );
                if ( this.has_plus ) {
                    this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ] = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS + '"]' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, "massChangePlusActionState" );
                }
            }
        }
    },
    setOverride                 : function ( _to_set ) {
        this.is_override = !!_to_set;
        if ( !_to_set ) {
            return;
        }
        this.override_prop_name        = this.dom_element.dataset.overridePropName;
        this.override_check_uuid       = this.dom_element.dataset.overrideElementUuid;
        this.override_check_name       = this.dom_element.dataset.overrideElementName;
        this.override_dfe_name         = this.dom_element.dataset.overrideDfeName;
        var _parents                   = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-override-check-content', 20 );
        this.override_check_uuid_final = _parents.dataset.domUuid;
        
        var help_title   = this.override_prop_name;
        var prop_is_data = SHINKEN.TOOLS.STRING.startsWith( this.override_prop_name, '_' );
        if ( !prop_is_data ) {
            help_title = _( 'help-services.' + this.override_prop_name + "-title" );
        }
        MANAGER.HelpManager.setTitle( this.name, help_title + ' (override)' );
        if ( this.is_disabled ) {
            if ( this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
                MANAGER.HelpManager.setContent( this.name, 'help-services.check_command-content-override' );
            }
            else {
                MANAGER.HelpManager.setContent( this.name, 'element.help_lock_property' );
            }
        }
        else {
            if ( prop_is_data ) {
                MANAGER.HelpManager.setContent( this.name, 'element.help_text_data' );
            }
            else {
                
                MANAGER.HelpManager.setContent( this.name, 'help-services.' + this.override_prop_name + "-content" );
            }
        }
        var _import_key_html = DOM.Service.createElement( 'div', {}, _( 'element.import_key' ) + ' : service_overrides' );
        if ( !this.is_disabled ) {
            var _example_html_title = DOM.Service.createElement( 'div', { class: 'shinken-example' }, _( 'common.example' ) );
            var _example_html       = DOM.Service.createElement( 'div', { class: 'shinken-example' }, 'service_overrides <span class="shinken-data-user">' + _( 'common.check_name' ) + '</span>,' + this.override_prop_name + '&nbsp;<span class="shinken-data-user">' + _( 'common.override_value' ) + '</span>' );
            DOM.Service.addElementTo( _example_html_title, _import_key_html );
            DOM.Service.addElementTo( _example_html, _import_key_html );
        }
        MANAGER.HelpManager.setImportKey( this.name, _import_key_html.innerHTML );
    },
    setState                    : function ( _to_set ) {
        this.state = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'state', this.state );
        this.computeStateInheritance();
        DOM.Service.setDataSet( this.dom_element, 'stateInheritance', this.component_btn_inheritance.getState() );
        if ( this.has_plus ) {
            DOM.Service.setDataSet( this.dom_element, 'statePlus', this.state_plus );
        }
        if ( !this.is_mass_change ) {
            switch ( this.state ) {
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    this.setUserSet( this.name, 0 );
                    break;
                default:
                    this.setUserSet( this.name, 1 );
                    break;
            }
        }
        fire_element_is_modifie();
    },
    computeStateInheritance     : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                this.setStateInheritance( true );
                break;
            default:
                this.setStateInheritance( false );
                break;
        }
    },
    setLastItemSelected         : function ( _to_set ) {
        this.last_list_element_selected = _to_set;
    },
    getValueInherited           : function () {
        console.warn( "getValueInherited", "[Not managed for type]", this.type );
    },
    getValueFinalOverride       : function () {
        if ( !this.is_override ) {
            return "";
        }
        var _to_return = this.getValue();
        if ( !_to_return ) {
            _to_return = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.override_check_uuid )[ this.override_prop_name ];
        }
        return _to_return;
    },
    getFlatValue                : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.component_btn_inheritance.isSet() ? this.getValueInherited() : this.default_value;
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return this.default_value;
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                if ( this.getValueInherited() ) {
                    return this.getValue() + "," + this.getValueInherited();
                }
                else {
                    return this.getValue();
                }
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET_MASS_CHANGE_PLUS_ONLY:
                return this.getValue();
        }
    },
    getValue                    : function () {
        var _to_return = "";
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.STRING_INPUT:
            case PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN:
                _to_return = this.component_input.getValue();
                break;
            case PROPERTY.CONST.TYPES.CHECKBOX_SINGLE:
                _to_return = this.getDataToSaveFinal();
                break;
            case PROPERTY.CONST.TYPES.SINGLE_SELECT:
            case PROPERTY.CONST.TYPES.MULTI_SELECT:
                _to_return = this.getSelector().getValue();
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
                    _to_return = '';
                }
                else if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ) {
                    _to_return = PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                }
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET_MASS_CHANGE_PLUS_ONLY:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                        _to_return = PROPERTY.CONST.STATE_VALUE_PLUS.ON + _to_return;
                }
                break;
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    case PROPERTY.CONST.STATE_PROPERTY.NO_OVERRIDE:
                        return '';
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                        return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                    default:
                        return this.component_input_range.getValue();
                }
            case PROPERTY.CONST.TYPES.BOOLEAN:
                switch ( this.state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    case PROPERTY.CONST.STATE_PROPERTY.NO_OVERRIDE:
                        return '';
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                        return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                    default:
                        return this.component_radio_list.getValue();
                }
            case PROPERTY.CONST.TYPES.SINGLE_SELECT_WITH_INPUT:
                _to_return = this.getSelector().getValue();
                if ( _to_return === "" ) {
                    return '';
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
                    return '';
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
                    return _to_return;
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE ) {
                    return _to_return;
                }
                if ( _to_return === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED ) {
                    return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                }
                
                _to_return += '!' + this.component_input.getValue();
                
                break;
            case PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT:
                _to_return = this.value;
                break;
        }
        return _to_return;
    },
    setValue                    : function ( _to_set ) {
        this.value = _to_set;
    },
    isSet                       : function () {
        var _to_return = this.getValue();
        return !!_to_return;
    },
    isStateOverride             : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return true;
        }
        return false;
    },
    setIsDisable                : function ( to_set ) {
        if ( to_set && !this.is_disabled ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        else if ( !to_set && this.is_disabled ) {
            this.dom_element.classList.remove( 'shinken-disabled' );
        }
        this.is_disabled = to_set;
    },
    computeTabId                : function () {
        var _tab_parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, this.is_override ? 'shinken-prop-table' : 'property-tab-pane', 50 );
        if ( _tab_parent_dom_element ) {
            this.tab_parent_id   = _tab_parent_dom_element.id;
            this.tab_parent_name = _tab_parent_dom_element.dataset.name;
        }
    },
    setIsRequired               : function ( to_set ) {
        this.is_required = to_set;
        if ( this.is_required && this.tab_parent_id ) {
            this.getWindow().setHasRequired( true );
        }
    },
    unset                       : function () {
        if ( this.is_mass_change ) {
            var _keys = Object.keys( this.selectors );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                switch ( _current_key ) {
                    case PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA:
                    case PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE:
                        this.clickOnItemSelector( PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE, null, this.selectors[ _current_key ] );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS:
                        this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.NONE, null, this.selectors[ _current_key ] );
                        break;
                    case PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA:
                        this.clickOnItemSelector( PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.NONE, null, this.selectors[ _current_key ] );
                        break;
                }
            }
        }
        this.___unset();
    },
    setValueFromUser            : function () {
        console.warn( "setValueFromUser", "[TYPE NOT MANAGED]", this.type );
    },
    getSelectViaDomElement      : function ( dom_element ) {
        var _dom_target = DOM.Service.findParentElementWithClass( dom_element, "shinken-select-container", 20 );
        return this.selectors[ _dom_target.dataset.name ];
    },
    getWindow                   : function () {
        if ( this.is_override ) {
            return MANAGER.__instance_window_distributor.findWindow( this.tab_parent_name, false, this.override_check_uuid_final );
        }
        return MANAGER.__instance_window_distributor.findWindow( this.tab_parent_name, false, MANAGER.__instance_element_distributor.current_element.uuid );
    },
    isDifferentValue            : function ( value1, value2 ) {
        return value1 !== value2 && SHINKEN.TOOLS.STRING.unescape_xss( value1 ) !== SHINKEN.TOOLS.STRING.unescape_xss( value2 );
    },
    //********************************************  COMPUTE  *********************************************************//
    _computeBtnInheritance      : function () {
    
    },
    _computeState               : function () {
    
    },
    _computeValueForSynchronize : function () {
        var _to_return;
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.RANGE:
            case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                var _state_default = this.component_btn_default.getState();
                _to_return         = this.component_input_range.getValue();
                if ( _state_default ) {
                    _to_return = this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON ? this.inherited_value : this.component_btn_default.getValue();
                }
                break;
        }
        return _to_return;
    },
    _computeInheritedLabelHtml  : function ( template_name, inherited_value, separator ) {
        if ( !separator ) {
            separator = "";
        }
        return "<span class='shinken-space'>" + separator + " " + SHINKEN.TOOLS.STRING.cleanXss( inherited_value ) + "   " + "<span class='shinken-between-bracket'>" + _( 'element.in_template' ) + " " + template_name + "</span> " + separator + "</span>";
    },
    _computeLabelSelect         : function () {
        if ( this.is_disabled ) {
            return;
        }
        var _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.selectors[ _keys[ i ] ].computeTitle();
        }
    },
    //********************************************  VIEW    **********************************************************//
    hidePopup                   : function ( exception ) {
        var _keys = Object.keys( this.selectors );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.selectors[ _keys[ i ] ] !== exception ) {
                this.selectors[ _keys[ i ] ].hidePopup();
            }
        }
        this.___hidePopup( exception );
    },
    updateView                  : function () {
        var _keys = Object.keys( this.selectors );
        var _current_dataset;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_dataset = this.selectors[ _keys[ i ] ].getDataSetLink();
            if ( _current_dataset ) {
                DOM.Service.setDataSet( this.dom_element, _current_dataset, this.selectors[ _keys[ i ] ].getValue() );
            }
        }
        this.___updateView();
    },
    remove                      : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
        }
        MANAGER.__instance_property_distributor.removeElement( this.name );
    },
    setParentCounter            : function ( to_set ) {
        if ( to_set ) {
            switch ( this.type ) {
                case PROPERTY.CONST.TYPES.DATA:
                    this.getCounterUserSet().setParent( to_set.getCounterUserSet() );
                    this.getCounterTotal().setParent( to_set.getCounterTotal() );
                    this.getCounterError().setParent( to_set.getCounterError() );
                    this.getCounterWarning().setParent( to_set.getCounterWarning() );
                    break;
                default:
                    if ( this.is_override || this.is_mass_change ) {
                        this.getCounterUserSet().setParent( to_set.getCounterUserSet() );
                    }
                    this.getCounterError().setParent( to_set.getCounterError() );
                    this.getCounterWarning().setParent( to_set.getCounterWarning() );
                    break;
            }
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
            this.getCounterUserSet().setParent();
            this.getCounterTotal().setParent();
        }
    },
    //********************************************  SAVE    **********************************************************//
    isFlatValueOn               : function () {
    },
    getDataToSave               : function () {
        if ( this.is_mass_change ) {
            return this.getDataToSaveMassChange();
        }
        if ( this.state_inheritance && !this.state_plus ) {
            return "";
        }
        return this.getDataToSaveFinal();
    },
    getDataToSaveMassChange     : function () {
        var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE_SYNCHRO:
                _action = PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_SYNCHRO:
                _action = PROPERTY.CONST.MASS_CHANGE.ACTION.ADD;
                break;
        }
        var _has_target     = false;
        var _need_value     = true;
        var _manage_plus    = true;
        var _to_return      = {};
        _to_return.action   = _action;
        _to_return.category = this.tab_parent_name;
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                return '';
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.MOVE:
                if ( this.is_ordered ) {
                    var _action_extra       = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_EXTRA ].getLastSelectedElement().element.name;
                    _to_return.extra_action = _action_extra;
                    switch ( _action_extra ) {
                        case PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.AFTER:
                        case PROPERTY.CONST.MASS_CHANGE.ACTION_EXTRA.BEFORE:
                            _has_target = true;
                            break;
                    }
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
                switch ( this.type ) {
                    case PROPERTY.CONST.TYPES.MULTI_SELECT:
                        _need_value = false;
                        if ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValue() !== PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                            _to_return.target = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_SINGLE ].getValueToSave();
                            _to_return.value  = { 'links': [this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValueToSave()] };
                        }
                        else {
                            _to_return.value = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
                        }
                        break;
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                if ( this.type === PROPERTY.CONST.TYPES.DATA ) {
                    _need_value       = false;
                    _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY;
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_IS_SET_ON_ITEM_OVERRIDE:
                _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_IS_SET_ON_ITEM;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_EXISTS_ON_ITEM_OVERRIDE:
                _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_EXISTS_ON_ITEM;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY_DATA_OVERRIDE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY_DATA:
                _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY;
                _need_value       = false;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_OR_CREATE:
                switch ( this.type ) {
                    case PROPERTY.CONST.TYPES.DATA:
                        _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.SET;
                        break;
                }
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.SET;
                _to_return.value  = PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                _need_value       = false;
                break;
            case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD_CONSISTENCY:
                _need_value = false;
                break;
        }
        if ( _need_value ) {
            var _value_set = false;
            switch ( this.last_list_element_selected ) {
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    _to_return.value = this.last_list_element_selected;
                    _value_set       = true;
                    _manage_plus     = false;
                    break;
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                    _to_return.value = PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
                    _value_set       = true;
                    _manage_plus     = false;
                    break;
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                    _to_return.action = PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY;
                    _value_set        = true;
                    break;
            }
            if ( !_value_set ) {
                _to_return.value = this.getDataToSaveFinal();
            }
        }
        if ( _has_target ) {
            _to_return.target = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ELEMENT_EXTRA ].getValueToSave();
        }
        switch ( _action ) {
            case PROPERTY.CONST.MASS_CHANGE.ACTION.ADD:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.MOVE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_OR_CREATE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_IS_SET_ON_ITEM:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_IS_SET_ON_ITEM_OVERRIDE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_EXISTS_ON_ITEM:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.SET_IF_DATA_EXISTS_ON_ITEM_OVERRIDE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REPLACE:
            case PROPERTY.CONST.MASS_CHANGE.ACTION.REMOVE:
                if ( _to_return.value === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                    _to_return = "";
                }
                break;
        }
        if ( this.has_plus && _manage_plus ) {
            var _value_plus = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION_PLUS ].getValue();
            switch ( _value_plus ) {
                case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON:
                case PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.OFF:
                    if ( !_to_return.value || _to_return.value === PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE ) {
                        _to_return          = {};
                        _to_return.action   = PROPERTY.CONST.MASS_CHANGE.ACTION.SET;
                        _to_return.value    = {};
                        _to_return.category = this.tab_parent_name;
                    }
                    _to_return.value.has_plus = _value_plus === PROPERTY.CONST.MASS_CHANGE.PLUS_ACTION.ON;
                    break;
            }
        }
        switch ( this.type ) {
            case PROPERTY.CONST.TYPES.DATA:
                if ( _to_return && this.is_protected ) {
                    _to_return.is_protected = true;
                }
        }
        if ( _to_return ) {
            _to_return.index = this.indexOfDisplay;
        }
        return _to_return;
    },
    //********************************************  SYNCHRONIZATION **************************************************//
    synchronize                 : function ( property, switch_type ) {
        switch ( this.getName() ) {
            case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.VIEW_CONTACTS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
            case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
            case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                if ( this.is_mass_change ) {
                    return this.synchronizeAtMaximumMassChange( property );
                }
                if ( PROPERTY.UserRightsBehaviour.has_everybody_default ) {
                    return PROPERTY.UserRightsBehaviour.askSynchronization( property );
                }
        }
        switch_type ? this.synchronizeAtMinimum( property ) : this.synchronizeAtMaximum( property );
    },
    synchronizeAtMinimum        : function ( property ) {
    },
    synchronizeAtMaximum        : function ( property ) {
    },
    //********************************************  HELP    **********************************************************//
    mouseEnter                  : function ( event ) {
        if ( this.is_override ) {
            var _title   = _( 'help-services.' + this.name_flat + "-title" );
            var _content = _( 'help-services.' + this.name_flat + "-content" );
            
            MANAGER.HelpManager.setActive( this.name, _title, _content );
        }
        else {
            MANAGER.HelpManager.setActive( this.name );
        }
        if ( this.is_synchro ) {
            SHINKEN_TOOLTIP.showTooltip( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].dom_element );
        }
        if ( event ) {
            this.mouseEnterInOption( event );
        }
    },
    mouseEnterInOption          : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, "shinken-option", 10 );
        if ( _parent_dom_element ) {
            var _target_component = this.getSelectViaDomElement( event.target );
            if ( _target_component ) {
                var _list = _target_component.getListElement( event );
                _list.updateLastAutoSelectIndex( _list.list_mapping[ _parent_dom_element.dataset.keyName ], COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOUSE );
            }
        }
    },
    mouseLeave                  : function () {
        MANAGER.HelpManager.askSetInactive( this.name );
        if ( this.is_synchro ) {
            SHINKEN_TOOLTIP.hideTooltip();
        }
    },
    onClick                     : function () {
        if ( !this.dom_element_help_btn ) {
            this.dom_element_help_btn = this.dom_element.querySelector( '.shinken-tag-help' );
        }
        if ( this.dom_element_help_btn.classList.contains( 'shinken-active' ) ) {
            return;
        }
        this.clickOnForcedHelpButton();
    },
    clickOnForcedHelpButton     : function () {
        if ( this.name.length === 1 && this.name.startsWith( '_' ) ) {
            return;
        }
        if ( !this.dom_element_help_btn ) {
            this.dom_element_help_btn = this.dom_element.querySelector( '.shinken-tag-help' );
        }
        MANAGER.HelpManager.setForced( this.name, this.dom_element_help_btn );
    }
};

PROPERTY.BuildSynchroName           = function ( property_target_name, property_synchronized_name ) {
    return property_target_name + "-SYNCHRO-" + property_synchronized_name;
};
PROPERTY.BuildOverrideName          = function ( property_name, property ) {
    return "override-" + property.override_check_uuid_final + '-' + property_name;
};
PROPERTY.BuildOverrideNameFromCheck = function ( property_name, check_host ) {
    if ( property_name === PROPERTY.CONST.NAME.CHECK_COMMAND_ARGS ) {
        property_name = PROPERTY.CONST.NAME.CHECK_COMMAND;
    }
    return "override-" + check_host.getDomUUID() + '-' + property_name;
};


PROPERTY.Abstract = function () {
};

PROPERTY.Abstract.prototype = {
    //********************************************  VIEW ************************************************//
    ___updateView          : function () {
    },
    //********************************************  GETTER AND SETTER ************************************************//
    ___unset               : function () {
    },
    getSelector            : function () {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___clickOnItemSelector : function ( _target_component, key_name ) {
    },
    ___clickOnCheckboxInput: function ( name ) {
    },
    ___clickOnRadioBtn     : function ( value ) {
    },
    ___onFocusOut          : function ( dom_element ) {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___hidePopup           : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Interface, PROPERTY.Abstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Interface, SHINKEN.OBJECT.CounterInterface );
