//priority 25
App.Elements.ChecksTab = (function ( self ) {
    "use strict";
    var __list_host_in_page_host;
    var __container_list_check;
    
    var __ask_init_timeout               = null;
    var __ask_update_override_cfg_format = null;
    
    self.askInit = function ( option ) {
        if ( !MANAGER.__instance_loading.isReady() ) {
            return;
        }
        if ( self.__ask_init_timeout ) {
            clearTimeout( self.__ask_init_timeout );
        }
        self.__ask_init_timeout = setTimeout( function () {
            if ( option && option.data_change ) {
                if ( !__list_host_in_page_host ) {
                    return;
                }
                _updateHtmlAfterDataChange( option.property );
                self.__ask_init_timeout = null;
            }
            else if ( option && option.override_command_change ) {
                if ( !__list_host_in_page_host ) {
                    return;
                }
                _updateHtmlAfterOverrideCommandChange( option.property );
                self.__ask_init_timeout = null;
            }
        }, 500 );
        
    };
    
    self.init = function () {
        if ( !MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            return;
        }
        __container_list_check = document.getElementById( 'id-shinken-check-list' );
        MANAGER.__instance_macro_distributor.recomputeLabelForEachMacro();
        _init2();
    };
    
    function _init2 () {
        DOM.Service.empty( document.getElementById( "id-shinken-check-list" ) );
        __list_host_in_page_host      = [];
        var _nb_checks_final          = 0;
        __list_host_in_page_host[ 0 ] = new OBJECT.HostInPageHost( MANAGER.__instance_element_distributor.current_element );
        __list_host_in_page_host[ 0 ].setChecks( MANAGER.__instance_element_distributor.getCheckForCurrentElement() );
        _nb_checks_final += __list_host_in_page_host[ 0 ].size_checks_host;
        for ( var i = 0; i < MANAGER.__instance_element_distributor.list_templates.size_computed; i++ ) {
            __list_host_in_page_host[ i + 1 ] = new OBJECT.HostInPageHost( null, MANAGER.__instance_element_distributor.list_templates.list_template_computed[ i ] );
            __list_host_in_page_host[ i + 1 ].setChecks( MANAGER.__instance_element_distributor.getCheckForElement( __list_host_in_page_host[ i + 1 ].uuid ) );
            _nb_checks_final += __list_host_in_page_host[ i + 1 ].size_checks_host;
            if ( i === 0 ) {
                __list_host_in_page_host[ i + 1 ].is_first_template = true;
            }
        }
        self.computeCheckNameIfAlreadyExist();
        for ( var i = 0, _size = __list_host_in_page_host.length; i < _size; i++ ) {
            __list_host_in_page_host[ i ].appendHtml();
        }
        
        if ( !_nb_checks_final ) {
            var _to_add_empty = DOM.Service.createElement( 'h3', { class: 'shinken-any-check-message text-middle' }, _( 'element.no_check_hooked' ) );
            __container_list_check.appendChild( _to_add_empty );
        }
        self.updateUnvalidOverride();
        self.buildOverrideCfgFormatHtml();
    }
    
    self.updateUnvalidOverride = function () {
        MANAGER.__instance_override_unvalid.init();
        if ( MANAGER.__instance_override_unvalid.size ) {
            DOM.Service.addElementTo( MANAGER.__instance_override_unvalid.buildHtml(), __container_list_check );
        }
    };
    
    self.updateExcludeStatus = function () {
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            __list_host_in_page_host[ i ].updateExcludeStatus();
        }
    };
    
    function _updateHtmlAfterOverrideCommandChange ( property ) {
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            __list_host_in_page_host[ i ].updateHtmlAfterOverrideCommandChange( property );
        }
    }
    
    function _updateHtmlAfterDataChange ( data ) {
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            __list_host_in_page_host[ i ].updateHtmlAfterDataChange( data );
        }
        if ( data.isDfeData() ) {
            self.updateUnvalidOverride();
        }
        self.computeCheckNameIfAlreadyExist();
    }
    
    self.computeModulationTag = function () {
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            __list_host_in_page_host[ i ].computeModulationTag();
        }
    };
    
    self.computeCheckNameIfAlreadyExist = function () {
        var _mapping_check_name     = {};
        var _current_host;
        var _current_check;
        var _size_host_in_page_host = __list_host_in_page_host.length;
        for ( var i = 0; i < _size_host_in_page_host; i++ ) {
            _current_host = __list_host_in_page_host[ i ];
            for ( var j = 0; j < _current_host.size_checks_host; j++ ) {
                _current_check = _current_host.checks_host[ j ];
                if ( _mapping_check_name[ _current_check.name ] ) {
                    _current_check.check_with_same_name = _mapping_check_name[ _current_check.name ];
                    if ( _current_host.uuid === _mapping_check_name[ _current_check.name ].parent_uuid && _current_check.is_dfe === _mapping_check_name[ _current_check.name ].is_dfe ) {
                        _current_check.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME );
                        _mapping_check_name[ _current_check.name ].setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME );
                        _mapping_check_name[ _current_check.name ].check_with_same_name = _mapping_check_name[ _current_check.name ];
                    }
                    else if ( _current_check.uuid === _mapping_check_name[ _current_check.name ].uuid ) {
                        _current_check.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE );
                    }
                    else {
                        _current_check.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME );
                    }
                }
                else {
                    if ( _current_check.exclude_status !== OBJECT.CONST.EXCLUDE_STATUS.BY_ID ) {
                        _mapping_check_name[ _current_check.name ] = _current_check;
                    }
                    _current_check.setStatus( OBJECT.CONST.CHECK_IN_HOST.STATUS.NONE );
                }
            }
            _current_host.updateTagHtml();
        }
    };
    
    self.updateCurrentElementName   = function ( to_set ) {
        if ( __list_host_in_page_host[ 0 ].dom_element ) {
            __list_host_in_page_host[ 0 ].dom_element.querySelector( ".shinken-host-in-page-host-title .shinken-template" ).innerText = to_set;
        }
    };
    self.buildOverrideCfgFormatHtml = function () {
        var _dom_container = DOM.Service.createElement( "div", { class: "shinken-override-cfg-format-container" } );
        
        var _dom_separator_container = DOM.Service.createElement( "div", { class: "shinken-separator-container" } );
        var _to_add                  = DOM.Service.createElement( "div", { class: "shinken-separator-title" }, _( 'element.override_cfg_format' ) );
        _dom_separator_container.appendChild( _to_add );
        var _text                       = getCfgFormatOverrideForCurrentElement();
        var _dom_format_value_container = DOM.Service.createElement( "div", { class: "shinken-override-cfg-format-value-container shinken-parent-text-to-copy" } );
        var _dom_format_value           = DOM.Service.createElement( "div", { class: "shinken-override-cfg-format-value shinken-text-to-copy" }, _text );
        
        _dom_container.appendChild( _dom_separator_container );
        _dom_format_value_container.appendChild( CLIPBOARD_SERVICE.buildHtmlButtons( true, false ) );
        _dom_format_value_container.appendChild( _dom_format_value );
        _dom_container.appendChild( _dom_format_value_container );
        
        DOM.Service.addElementTo( _dom_container, __container_list_check );
    };
    self.askUpdateOverrideFormatCfg = function () {
        if ( self.__ask_update_override_cfg_format ) {
            clearTimeout( self.__ask_update_override_cfg_format );
        }
        self.__ask_update_override_cfg_format = setTimeout( function () {
            self.updateOverrideFormatCfg();
        }, 300 );
        
    };
    self.updateOverrideFormatCfg    = function () {
        var dom_override_cfg_format       = document.querySelector( '.shinken-override-cfg-format-container .shinken-override-cfg-format-value-container .shinken-override-cfg-format-value' );
        dom_override_cfg_format.innerHTML = getCfgFormatOverrideForCurrentElement();
    };
    self.getCheckInHostElement      = function ( check_uuid, dfe_name ) {
        var _to_return;
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            _to_return = __list_host_in_page_host[ i ].getCheckInHostElement( check_uuid, dfe_name );
            if ( _to_return ) {
                return _to_return;
            }
        }
        return null;
    };
    self.getAllCheckByID            = function ( check_uuid, dfe_name ) {
        var _to_return = [];
        var _to_add;
        var _size      = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            _to_add = __list_host_in_page_host[ i ].getCheckByID( check_uuid, dfe_name );
            if ( _to_add ) {
                _to_return.push( _to_add );
            }
        }
        return _to_return;
    };
    self.getCheckByID               = function ( check_uuid, dfe_name ) {
        var _to_return;
        var _size = __list_host_in_page_host.length;
        for ( var i = 0; i < _size; i++ ) {
            _to_return = __list_host_in_page_host[ i ].getCheckByID( check_uuid, dfe_name );
            if ( _to_return ) {
                return _to_return;
            }
        }
        return null;
    };
    self.getListHostInPageHost      = function () {
        return __list_host_in_page_host;
    };
    
    
    self.buildIdTagModulation         = function ( check_host ) {
        return "id-tag-modulation-" + check_host.getDomUUID();
    };
    self.isTagModulationNeededForProp = function ( check_host, property_name, property ) {
        if ( property ) {
            var _value_property = MANAGER.__instance_property_distributor.findElement( PROPERTY.BuildOverrideName( property_name, property ) ).getDataToSave();
            switch ( _value_property ) {
                case "":
                    break;
                case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                    return false;
                default:
                    return true;
            }
        }
        var _return_override = MANAGER.__instance_element_distributor.current_element.hasOverrideModulation( check_host, property_name );
        if ( _return_override > OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE ) {
            return true;
        }
        else if ( _return_override === OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED ) {
            return false;
        }
        
        var _return_check = check_host.element.getTypeModulation( property_name );
        switch ( _return_check ) {
            case OBJECT.CONST.ELEMENT.MODULATION.TYPE.NONE_FORCED:
            case OBJECT.CONST.ELEMENT.MODULATION.TYPE.PLUS:
                return false;
            case OBJECT.CONST.ELEMENT.MODULATION.TYPE.EXISTING:
            case OBJECT.CONST.ELEMENT.MODULATION.TYPE.ERROR:
                return true;
        }
        if ( check_host.parent_uuid !== MANAGER.__instance_element_distributor.current_element.uuid ) {
            var _tpl = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( check_host.parent_uuid );
            if ( _tpl.hasOverrideModulation( check_host, property_name ) ) {
                return true;
            }
        }
        
        var _on_current_element = MANAGER.__instance_property_distributor.getElement( property_name ).getValueAndValueInherited();
        if ( _on_current_element && _on_current_element !== PROPERTY.CONST.STATE_VALUE_PLUS.ON ) {
            return true;
        }
        return false;
    };
    self.isTagModulationNeeded        = function ( check_host, property ) {
        if ( self.isTagModulationNeededForProp( check_host, PROPERTY.CONST.NAME.MACRO_MODULATIONS, property ) ) {
            return true;
        }
        if ( self.isTagModulationNeededForProp( check_host, PROPERTY.CONST.NAME.RESULT_MODULATIONS, property ) ) {
            return true;
        }
        return false;
    };
    self.createTagModulation          = function ( check_host ) {
        var _check_macro_mod_type  = check_host.element.getTypeModulation( PROPERTY.CONST.NAME.MACRO_MODULATIONS );
        var _check_result_mod_type = check_host.element.getTypeModulation( PROPERTY.CONST.NAME.RESULT_MODULATIONS );
        var _id                    = self.buildIdTagModulation( check_host );
        var _class                 = "shinken-tag-modulation";
        if ( !self.isTagModulationNeeded( check_host ) ) {
            _class += ' shinken-hidden';
        }
        var _attributes = {};
        if ( _check_macro_mod_type === OBJECT.CONST.ELEMENT.MODULATION.TYPE.ERROR || _check_result_mod_type === OBJECT.CONST.ELEMENT.MODULATION.TYPE.ERROR ) {
            _class += ' error';
            _attributes.onmouseenter      = "SHINKEN_TOOLTIP.showTooltip(this)";
            _attributes.onmouseleave      = "SHINKEN_TOOLTIP.hideTooltip()";
            _attributes[ 'shi-tip-html' ] = _( 'element.tooltip_modulation_bad_config' );
            check_host.setError( 'shinken-modulation', 1 );
        }
        else {
            check_host.setError( 'shinken-modulation', 0 );
        }
        _attributes.class   = _class;
        _attributes.id      = _id;
        var _tab_modulation = DOM.Service.createElement( 'div', _attributes, _( 'element.modulation' ) );
        var _to_return      = DOM.Service.createElement( 'div', { class: "shinken-tag-modulation-container" } );
        _to_return.appendChild( _tab_modulation );
        return _to_return;
    };
    
    //OVERRIDE
    self.initOverrideWindows                     = function ( dom_element, _check_in_host ) {
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( _check_in_host.getDomUUID() );
        _parent_window.setParentCounter( _check_in_host.button_override );
    };
    self.initOverrideProperties                  = function ( dom_element, _check_in_host ) {
        MANAGER.__instance_element_distributor.current_element.removeParentCounter( _check_in_host );
        
        var _elements = dom_element.querySelectorAll( '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE );
        var _current;
        var _name;
        var _current_property;
        var _user_value;
        var _saved_value;
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _current          = _elements[ i ];
            _name             = _current.dataset.name;
            _current_property = MANAGER.__instance_property_distributor.findElement( _name, false, '', _current );
            _current_property.updateWithTemplate();
            _user_value  = MANAGER.__instance_element_distributor.current_element.getOverrideValue( _current_property.override_prop_name, _check_in_host );
            _saved_value = _current_property.getValue();
            if ( !_user_value ) {
                _user_value = "";
            }
            if ( _current_property.isDifferentValue( _user_value, _saved_value ) ) {
                _current_property.setValueFromUser( _user_value );
            }
            if ( _current_property.override_prop_name === PROPERTY.CONST.NAME.RESULT_MODULATIONS ) {
                _current_property.getSelector().setMaximumSelected( PROPERTY.CONST.MAX_SELECTABLE_ITEMS.RESULT_MODULATIONS );
                _current_property.updateView();
            }
            if ( _current_property.type === PROPERTY.CONST.TYPES.DATA ) {
                _current_property.updateView();
            }
            if ( _current_property.type === PROPERTY.CONST.TYPES.MULTI_SELECT && _current_property.has_plus && _current.querySelector( '.shinken-value-from-check' ) ) {
                _current_property.finalActionAfterOverrideLoading();
            }
            
        }
        MANAGER.__instance_element_distributor.current_element.cleanOverrideFor( _check_in_host );
    };
    self.updateWarningAndErrorForMultiLineObject = function ( check_in_host ) {
        ////PATCH POURRI POUR FIXER LE PROBLEM... DEVRAIT ËTRE FAIT DE FACON DIFFERENTE QUAND LES COUNTERS SERONT AUTONOME AYANT LEUR PARENT
        var _props = MANAGER.__instance_property_distributor.getAllOverridePropByCheckId( check_in_host.getDomUUID() );
        for ( var i = 0, _size_i = _props.length; i < _size_i; i++ ) {
            if ( _props[ i ].type === PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT ) {
                for ( var j = 0, _size_j = _props[ i ].lines_object.length; j < _size_j; j++ ) {
                    var _keys = Object.keys( _props[ i ].lines_object[ j ].inputs );
                    var _current_key;
                    for ( var k = 0, _size = _keys.length; k < _size; k++ ) {
                        _current_key = _keys[ k ];
                        MANAGER.EventManager.onChangeOnInput( { target: _props[ i ].lines_object[ j ].inputs[ _current_key ].dom_element } );
                    }
                }
            }
        }
        
    };
    self.getCheckOverrideData                    = function ( dom_uuid ) {
        if ( !MANAGER.__instance_loading.isReady() ) {
            console.warn( "[NOT READY]" );
            return;
        }
        MANAGER.__instance_loading.setIsReady( false );
        
        var _check_in_host = self.getCheckInHostElement( dom_uuid );
        if ( !_check_in_host ) {
            console.error( "NO ELEMENT FOUND FOR THIS UUID", "[SHOULD NOT HAPPEN]", "[DATA SHOULD BE CORRUPTED]", dom_uuid );
            MANAGER.__instance_loading.setIsReady( true );
            return;
        }
        if ( _check_in_host.status === OBJECT.CONST.CHECK_IN_HOST.STATUS.DFE_STRUCTURE ) {
            console.error( "CANNOT OPEN OVERRIDE WITH A WRONG DFE STRUCTURE" );
            MANAGER.__instance_loading.setIsReady( true );
            return;
        }
        var _type_check               = _check_in_host.element.type;
        var _id_result_check_override = "result-check-override-" + dom_uuid;
        var _container                = document.getElementById( _id_result_check_override );
        var _parent                   = _container.parentElement.parentElement;
        var _parent_cell_button_name  = 'id-col-tags-' + _type_check + '-' + dom_uuid;
        var _parent_cell_button       = document.getElementById( _parent_cell_button_name );
        
        if ( !_parent.classList.contains( 'shinken-hidden' ) ) {
            _parent.classList.add( 'shinken-hidden' );
            _parent_cell_button.classList.remove( 'shinken-active' );
            MANAGER.__instance_loading.setIsReady( true );
            return;
        }
        // Scroll to override window when try-check window is open
        var _check_line          = DOM.Service.findParentElementWithDataSet( _parent_cell_button, 'overrideStatus', 10 );
        var _try_check_container = _check_line.nextSibling;
        if ( !_try_check_container.classList.contains( 'hide' ) ) {
            var _check_list       = document.querySelector( '#id-shinken-check-list' );
            _check_list.scrollTop = _check_list.scrollTop + _try_check_container.offsetHeight;
        }
        
        if ( !_container.classList.contains( 'shinken-unset' ) ) {
            _parent.classList.remove( 'shinken-hidden' );
            _parent_cell_button.classList.add( 'shinken-active' );
            MANAGER.__instance_loading.setIsReady( true );
            return;
        }
        var current_host_uuid = MANAGER.__instance_element_distributor.current_element.uuid;
        var current_host_type = MANAGER.__instance_element_distributor.current_element.type;
        
        var path = COMMUNICATION.QUERY.GET.OVERRIDE.BASE + current_host_type;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.SLASH + current_host_uuid;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.SLASH + _type_check;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.SLASH + _check_in_host.uuid;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.SLASH + _check_in_host.element.host_type;
        
        var _get_separator_added = false;
        if ( MANAGER.__instance_element_distributor.current_element.is_new ) {
            path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER + "item_state=new";
            _get_separator_added = true;
        }
        
        if ( MANAGER.__instance_element_distributor.current_element.is_creation ) {
            path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
            path += 'in_creation' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + "1";
            _get_separator_added = true;
        }
        
        if ( _check_in_host.is_dfe ) {
            path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
            path += 'name' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + _check_in_host.name;
            path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD;
            path += 'dfe_name' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + SHINKEN.TOOLS.STRING.utf8Encode( _check_in_host.key_dfe );
            _get_separator_added = true;
        }
        else {
            path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
            path += 'name' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + _check_in_host.element.service_description;
            _get_separator_added = true;
        }
        
        if ( _check_in_host.force_clean ) {
            path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
            path += 'force_clean' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + "1";
            _get_separator_added = true;
        }
        switch ( _check_in_host.status ) {
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_DUPLICATE:
                return;
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME:
            case OBJECT.CONST.CHECK_IN_HOST.STATUS.ALREADY_EXISTING_NAME_IN_SAME:
                path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
                path += 'force_disable' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + "1";
                _get_separator_added = true;
                break;
        }
        
        path += _get_separator_added ? COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD : COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
        var tpl = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE );
        path += 'tpl' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + tpl.getValue();
        
        path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD + 'editable' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + MANAGER.__instance_element_distributor.current_element.editable;
        path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD + 'dom-uuid' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + SHINKEN.TOOLS.STRING.utf8Encode( dom_uuid );
        if ( !__is_working_area__ ) {
            path += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD + 'item-state' + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + 'stagging';
        }
        $.ajax( {
            url     : path,
            dataType: "text",
            success : function ( data ) {
                _container.innerHTML = data;
                _parent.classList.remove( 'shinken-hidden' );
                _container.classList.remove( 'shinken-unset' );
                _parent_cell_button.classList.add( 'shinken-active' );
                self.initOverrideWindows( _container, _check_in_host );
                self.initOverrideProperties( _container, _check_in_host );
                App.Elements.ChecksTab.updateWarningAndErrorForMultiLineObject( _check_in_host );
                MANAGER.__instance_loading.setIsReady( true );
            },
            error   : function ( rc, state, error ) {
                console.error( 'getCheckOverrideData data', 'Got bad result ' + rc.status );
                var data = "";
                switch ( rc.status ) {
                    case 404:
                        data = DOM.Service.createElement( 'span', { class: "span12 alert alert-error" }, _( 'element.service_override_missing_host_or_check' ) );
                        break;
                    
                    default:
                        data = DOM.Service.createElement( 'span', { class: "span12 alert alert-error" }, _( 'element.service_override_bad_request' ) );
                        break;
                    
                }
                DOM.Service.addElementTo( data, _container );
                _parent.classList.remove( 'shinken-hidden' );
                _container.classList.remove( 'shinken-unset' );
                _parent_cell_button.classList.add( 'shinken-active' );
                MANAGER.__instance_loading.setIsReady( true );
            }
        } );
    };
    
    
    return self;
})( App.Elements.ChecksTab || {} );
