'use strict';

SOURCE.Source           = function ( data ) {
    // name
    // type
    // value
    // state
    // list_dom_element
    // fully_merged
    // phase
    this.init( data );
};
SOURCE.Source.prototype = {
    init                         : function ( data ) {
        this.is_single_display = !!data.is_single_display;
        this.initProperties( data );
        this[ SOURCE.CONST.FIELD.IMPORT_ENABLED ] = false;
        this[ SOURCE.CONST.FIELD.FULLY_MERGED ]   = false;
        this[ SOURCE.CONST.FIELD.ALREADY_IMPORT ] = false;
        this.is_imported_asked_for_this           = SOURCE.CONST.ASK_IMPORT.NONE;
        this.phase                                = new OBJECT.Phase();
        this.phase.current_phase                  = OBJECT.CONST.PHASE.READY;
        this.is_existing                          = true;
        this.updateData( data );
    },
    initProperties               : function ( data ) {
        this[ SOURCE.CONST.FIELD.ORDER ]               = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.ORDER );
        this[ SOURCE.CONST.FIELD.STATE ]               = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.STATE );
        this[ SOURCE.CONST.FIELD.ENABLED ]             = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.ENABLED );
        this[ SOURCE.CONST.FIELD.NEXT_IMPORT ]         = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.NEXT_IMPORT );
        this[ SOURCE.CONST.FIELD.LAST_IMPORT ]         = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.LAST_IMPORT );
        this[ SOURCE.CONST.FIELD.NB_ELEMENTS_OK ]      = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.NB_ELEMENTS_OK );
        this[ SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING ] = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING );
        this[ SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR ]   = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR );
        this[ SOURCE.CONST.FIELD.OUTPUT ]              = new SOURCE.SourceProperty( SOURCE.CONST.FIELD.OUTPUT );
        this[ SOURCE.CONST.FIELD.MODULE_TYPE ]         = data[ SOURCE.CONST.FIELD.MODULE_TYPE ];
        this[ SOURCE.CONST.FIELD.IP_RANGES ]           = new SOURCE.IpRanges();
        if ( data[ 'ip_range' ] ) {
            this[ SOURCE.CONST.FIELD.IP_RANGES ].init( data[ 'ip_range' ], this.is_single_display );
        }
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateData                   : function ( data ) {
        if ( !data ) {
            return;
        }
        this.is_existing                              = true;
        if ( this.phase.isPhase( OBJECT.CONST.PHASE.SLEEPING ) ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
        this.setState( data[ SOURCE.CONST.FIELD.STATE ] );
    },
    setData                      : function ( key, value ) {
        switch ( key ) {
            case SOURCE.CONST.FIELD.NAME:
            case SOURCE.CONST.FIELD.ALREADY_IMPORT:
            case SOURCE.CONST.FIELD.TYPE:
                this[ key ] = value;
                break;
            
            case SOURCE.CONST.FIELD.STATE:
                //DONE AT THE END
                break;
            
            case SOURCE.CONST.FIELD.ORDER:
            case SOURCE.CONST.FIELD.ENABLED:
                this[ key ].updateValue( value );
                break;
            
            case SOURCE.CONST.FIELD.LAST_IMPORT:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_OK:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING:
            case SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR:
            case SOURCE.CONST.FIELD.OUTPUT:
                if ( this.isActive() ) {
                    this[ key ].updateValue( value );
                }
                break;
            
            case SOURCE.CONST.FIELD.NEXT_IMPORT:
                if ( this[ SOURCE.CONST.FIELD.TYPE ] !== SOURCE.CONST.TYPES.COLLECTOR && this[ SOURCE.CONST.FIELD.TYPE ] !== SOURCE.CONST.TYPES.ANALYZER ) {
                    return;
                }
                if ( this[ SOURCE.CONST.FIELD.STATE ] === SOURCE.CONST.STATE.NOT_CONFIGURED || this[ SOURCE.CONST.FIELD.STATE ] === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT ) {
                    return;
                }
                if ( !this.isActive() || !this.isImportEnabled() ) {
                    return;
                }
                if ( value < 0 ) {
                    return;
                }
                this[ key ].updateValue( value );
                break;
            
            case SOURCE.CONST.FIELD.IMPORT_INTERVAL:
                this.setImportEnabled( value );
                break;
            
            case SOURCE.CONST.FIELD.IP_RANGES:
                this[ SOURCE.CONST.FIELD.IP_RANGES ].updateData( value );
                break;
            
            case SOURCE.CONST.FIELD.MODULE_TYPE:
                break;
            
            case SOURCE.CONST.FIELD.FULLY_MERGED:
                this[ SOURCE.CONST.FIELD.FULLY_MERGED ] = value;
                break;
            
            //default:
            //   console.warn( "[SOURCE]", "[IGNORED DATA]", "[" + key + "]", value );
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    getDomSelector               : function () {
        return this.is_single_display ? "#wrapper" : '.line-source[data-name="' + this.getName() + '"]';
    },
    loadDomElements              : function () {
        this.list_dom_element = document.querySelectorAll( this.getDomSelector() );
        
        var _size = this.list_dom_element.length;
        if ( !this.is_single_display ) {
            this[ SOURCE.CONST.FIELD.ORDER ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.NEXT_IMPORT ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.LAST_IMPORT ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.NB_ELEMENTS_OK ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.NB_ELEMENTS_WARNING ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.NB_ELEMENTS_ERROR ].loadDomElements( this.list_dom_element, _size );
            this[ SOURCE.CONST.FIELD.ENABLED ].loadDomElements( this.list_dom_element, _size );
        }
        this[ SOURCE.CONST.FIELD.STATE ].loadDomElements( this.list_dom_element, _size, this.is_single_display );
        this[ SOURCE.CONST.FIELD.OUTPUT ].loadDomElements( this.list_dom_element, _size, this.is_single_display );
        
        
        var self = this;
        setTimeout( function () { //NORMALEMENT PAS NECESSAIRE
            if ( !self.list_dom_element ) {
                console.warn( "[reload dom element]" );
                self.loadDomElements();
            }
        }, 1000 );
    },
    getDomElement                : function ( index ) {
        return this.list_dom_element[ index ];
    },
    resetExisting                : function () {
        this.is_existing = false;
    },
    getName                      : function () {
        return this[ SOURCE.CONST.FIELD.NAME ];
    },
    getOrder                     : function () {
        return this[ SOURCE.CONST.FIELD.ORDER ].value;
    },
    isActive                     : function () {
        return this.isEnabled();
    },
    isEnabled                    : function () {
        return this[ SOURCE.CONST.FIELD.ENABLED ].value;
    },
    getIsActive                  : function () {
        return this[ SOURCE.CONST.FIELD.ENABLED ].value;
    },
    isImportEnabled              : function () {
        return this[ SOURCE.CONST.FIELD.IMPORT_ENABLED ];
    },
    setImportEnabled             : function ( to_set ) {
        this[ SOURCE.CONST.FIELD.IMPORT_ENABLED ] = to_set !== 0;
    },
    toggleEnable                 : function () {
        var _is_active = !this.getIsActive(); //TOGGLE
        this.setData( SOURCE.CONST.FIELD.ENABLED, _is_active );
        
        var enabled = _is_active ? COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.CONST.ENABLED : COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.CONST.DISABLED;
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.URL
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.OPTIONS.SOURCE_NAME
                     + this[ SOURCE.CONST.FIELD.NAME ]
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ENABLED.OPTIONS.ENABLED
                     + enabled,
            success: function ( data ) {
                if ( !self.is_single_display ) {
                    var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                    _sources.refresh();
                }
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
        
    },
    setOrder                     : function ( order ) {
        this.setData( SOURCE.CONST.FIELD.ORDER, order );
    },
    setPhase                     : function ( to_set ) {
        this.phase.setPhase( to_set );
        switch ( to_set ) {
            case OBJECT.CONST.PHASE.WAITING_FOR_UPDATE:
                this.askForRefresh();
                break;
            case OBJECT.CONST.PHASE.WAITING_FOR_START_IMPORT:
                DOM.BodyService.askAddClass( "shinken-import-in-progress" );
                if ( this.isSourceImportInProgress() ) {
                    DOM.BodyService.askAddClass( "shinken-import-in-progress_2" );
                }
                this.setRefreshIntervalForRefresh();
                break;
            case OBJECT.CONST.PHASE.REFRESHING:
                DOM.BodyService.askAddClass( "shinken-import-in-progress" );
                DOM.BodyService.askAddClass( "shinken-import-refreshing" );
                var self = this;
                setTimeout( function () {
                    if ( SHINKEN.HIGHWAY.getParams( 'shinken_test_auto' ) ){
                        DOM.BodyService.removeClass( "shinken-import-in-progress" );
                        self.phase.setPhase( OBJECT.CONST.PHASE.READY );
                        clearInterval(self.ask_for_refresh_interval);
                    }
                    else {
                        SHINKEN.HIGHWAY.refreshCurrentPage();
                    }
                }, 3000 );
                break;
            case OBJECT.CONST.PHASE.SLEEPING:
                this.phase.setPhaseWithTimeOut( OBJECT.CONST.PHASE.READY, 2000 );
                break;
        }
    },
    setState                     : function ( to_set ) {
        if ( !this.isEnabled() ) {
            return;
        }
        if ( this.is_single_display && this.is_imported_asked_for_this === SOURCE.CONST.ASK_IMPORT.CONFIRMED && this[ SOURCE.CONST.FIELD.FULLY_MERGED ] ) {
            this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_MERGE );
        }
        else if ( to_set !== SOURCE.CONST.STATE.READY_FOR_IMPORT && to_set !== SOURCE.CONST.STATE.RUNNING && !(to_set === SOURCE.CONST.STATE.NOT_CONFIGURED || to_set === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) && !this[ SOURCE.CONST.FIELD.FULLY_MERGED ] && !(this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED || this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) ) {
            to_set = SOURCE.CONST.STATE.IN_PROGRESS;
        }
        if ( this.is_imported_asked_for_this === SOURCE.CONST.ASK_IMPORT.CONFIRMED ) {
            to_set = SOURCE.CONST.STATE.RUNNING;
        }
        
        if ( this[ SOURCE.CONST.FIELD.STATE ].label === SOURCE.CONST.STATE.IN_PROGRESS && to_set !== SOURCE.CONST.STATE.IN_PROGRESS ) {
            ask_menu_update();
        }
        if ( this[ SOURCE.CONST.FIELD.ALREADY_IMPORT ] === false && to_set === SOURCE.CONST.STATE.PENDING ) {
            to_set = SOURCE.CONST.STATE.NEVER_IMPORT;
        }
        this[ SOURCE.CONST.FIELD.STATE ].updateValue( to_set );
        if ( this.is_single_display ) {
            switch ( to_set ) {
                case SOURCE.CONST.STATE.IN_PROGRESS:
                    this.setData( SOURCE.CONST.FIELD.OUTPUT, "" );
                case SOURCE.CONST.STATE.RUNNING:
                    if ( this.is_imported_asked_for_this === SOURCE.CONST.ASK_IMPORT.NONE ) {
                        this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_START_IMPORT );
                    }
                    break;
            }
            document.getElementById( 'wrapper' ).dataset.state = this.getState();
        }
        
    },
    getState                     : function () {
        return this[ SOURCE.CONST.FIELD.STATE ].value;
    },
    getPreviousState             : function () {
        return this[ SOURCE.CONST.FIELD.STATE ].previous_value;
    },
    isSourceImportInProgress     : function () {
        if ( !this[ SOURCE.CONST.FIELD.FULLY_MERGED ] ) {
            return true;
        }
        switch ( this[ SOURCE.CONST.FIELD.STATE ].value ) {
            case SOURCE.CONST.STATE.IN_PROGRESS:
            case SOURCE.CONST.STATE.RUNNING:
                return true;
        }
        return false;
    },
    //********************************************  DRAG AND DROP  **************************************************//
    resetDragging                : function () {
        this.list_dom_element[ 0 ].classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGING );
    },
    dragStartSource              : function () {
        this.list_dom_element[ 0 ].classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGING );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askForceImport               : function () {
        if ( !this.isEnabled() ) {
            return;
        }
        if ( this.is_single_display ) {
            this.is_imported_asked_for_this = SOURCE.CONST.ASK_IMPORT.ASKED;
        }
        else {
            this.setPhase( OBJECT.CONST.PHASE.SLEEPING );
            this.setState( SOURCE.CONST.STATE.RUNNING );
            this.forceImport();
            return;
        }
        this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_UPDATE );
        this.phase.next_phase = OBJECT.CONST.PHASE.WAITING_FOR_START_IMPORT;
    },
    askUpdateBeforeAnyAction     : function () {
        this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_UPDATE );
        this.phase.next_phase = OBJECT.CONST.PHASE.READY;
    },
    forceImport                  : function () {
        this.setData( SOURCE.CONST.FIELD.NEXT_IMPORT, 0 );
        if ( this.is_single_display ) {
            this.is_imported_asked_for_this = SOURCE.CONST.ASK_IMPORT.CONFIRMED;
        }
        this[ SOURCE.CONST.FIELD.OUTPUT ].updateValue( "" );
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.URL
                     + this[ SOURCE.CONST.FIELD.NAME ]
                     + COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                if ( !self.is_single_display ) {
                    var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                    _sources.refresh();
                }
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
        
    },
    cleanImport                  : function () {
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.CLEAN_IMPORT.URL
                     + this[ SOURCE.CONST.FIELD.NAME ]
                     + COMMUNICATION.QUERY.GET.SOURCE.CLEAN_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                _sources.refresh();
                ask_menu_update();
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    },
    //********************************************  UPDATE VIEW  **************************************************//
    setRefreshIntervalForRefresh : function () {
        if ( !this.is_single_display || this.ask_for_refresh_interval ) {
            return;
        }
        var self = this;
        setTimeout( function () {
            self.ask_for_refresh_interval = setInterval( function () {
                self.askForRefresh();
            }, 1000 );
        }, 2000 );
    },
    askForRefresh                : function () {
        if ( !this.is_single_display ) {
            return;
        }
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.REFRESH_UNIQUE.URL
                     + self[ SOURCE.CONST.FIELD.NAME ]
                     + COMMUNICATION.QUERY.GET.SOURCE.CLEAN_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                self.updateData( data );
                if ( self.is_single_display ) {
                    if ( self.phase.current_phase === OBJECT.CONST.PHASE.WAITING_FOR_UPDATE ) {
                        self.setPhase( self.phase.next_phase );
                    }
                    self.updateSingleDisplayView();
                }
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
        
    },
    updateSingleDisplayView      : function () {
        var _dom = document.querySelector( "#wrapper .shinken-number-active-conf" );
        if ( _dom ) {
            _dom.innerHTML = this[ SOURCE.CONST.FIELD.IP_RANGES ].getNbEnabled();
        }
        if ( !this.getIsActive() && this.is_imported_asked_for_this === SOURCE.CONST.ASK_IMPORT.CONFIRMED ) {
            this.setPhase( OBJECT.CONST.PHASE.REFRESHING );
            return;
        }
        switch ( this.phase.current_phase ) {
            case OBJECT.CONST.PHASE.WAITING_FOR_START_IMPORT:
                if ( this.getState() === SOURCE.CONST.STATE.RUNNING ) {
                    this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_IMPORT );
                }
                else if ( !this[ SOURCE.CONST.FIELD.FULLY_MERGED ] && this.getState() !== SOURCE.CONST.STATE.READY_FOR_IMPORT && !(this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED || this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) && !(this.getPreviousState() === SOURCE.CONST.STATE.NOT_CONFIGURED || this.getPreviousState() === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) ) {
                    this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_MERGE );
                }
                else {
                    this.forceImport();
                    this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_IMPORT );
                }
                break;
            case OBJECT.CONST.PHASE.WAITING_FOR_IMPORT:
                if ( this.getState() === SOURCE.CONST.STATE.RUNNING ) {
                }
                else if ( this[ SOURCE.CONST.FIELD.FULLY_MERGED ] && this[ SOURCE.CONST.FIELD.NEXT_IMPORT ].value < 1 ) {
                }
                else {
                    this.setPhase( OBJECT.CONST.PHASE.WAITING_FOR_MERGE );
                }
                break;
            case OBJECT.CONST.PHASE.WAITING_FOR_MERGE:
                if ( (this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED || this.getState() === SOURCE.CONST.STATE.NOT_CONFIGURED_BEFORE_IMPORT) ) {
                    this.setPhase( OBJECT.CONST.PHASE.REFRESHING );
                }
                if ( !this[ SOURCE.CONST.FIELD.FULLY_MERGED ] ) {
                }
                else {
                    this.setPhase( OBJECT.CONST.PHASE.REFRESHING );
                }
                break;
        }
        
        var _dom_output = document.querySelector( "#wrapper #id-shinken-output-source" );
        if ( _dom_output ) {
            if ( this[ SOURCE.CONST.FIELD.OUTPUT ].value ) {
                _dom_output.setAttribute( "shi-tip-html", this[ SOURCE.CONST.FIELD.OUTPUT ].value );
                _dom_output.classList.remove( 'shinken-hidden' );
            }
            else {
                _dom_output.classList.add( 'shinken-hidden' );
            }
        }
        
    },
    //********************************************  OTHERS  **************************************************//
    redirectToSourceLastExecution: function () {
        var url = COMMUNICATION.QUERY.GET.SOURCE.REDIRECT_DETAIL.URL + this.getName() + COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER + COMMUNICATION.QUERY.GET.SOURCE.REDIRECT_DETAIL.OPTIONS.TAB_SUMMARY_OLD_RUN;
        window.open( url );
    }
};