//priority 10
//__lib__ lib_external
DOM.Service = (function ( self ) {
    "use strict";
    
    var __previous_scrollLeft = 0;
    
    self.hasKeyInDataSet                   = function ( element, key ) {
        return typeof element.dataset[ key ] !== "undefined";
    };
    self.findParentElementWithDataSet      = function ( element, key, deepLimit ) {
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( self.hasKeyInDataSet( element, key ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithDataSet( element.parentElement, key, deepLimit );
    };
    self.findParentElementWithClass        = function ( element, class_tag, deepLimit ) {
        if ( deepLimit < 0 || !element ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    };
    self.createElement                     = function ( tag, attributes, innerHTML ) {
        var toReturn = document.createElement( tag );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                toReturn.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        if ( innerHTML ) {
            toReturn.innerHTML = innerHTML;
        }
        return toReturn;
    };
    self.cloneElement                      = function ( dom_element_to_clone, attributes ) {
        var _to_return = dom_element_to_clone.cloneNode( true );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                _to_return.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        return _to_return;
    };
    self.addTooltip                        = function ( element, attributes ) {
        if ( !attributes ) {
            return;
        }
        element.setAttribute( 'onmouseenter', "SHINKEN_TOOLTIP.showTooltip(this)" );
        element.setAttribute( 'onmouseleave', "SHINKEN_TOOLTIP.hideTooltip()" );
        var _keys = Object.keys( attributes );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            element.setAttribute( _keys[ i ], attributes[ _keys[ i ] ] );
        }
        return element;
    };
    self.bindElementOnScroll               = function ( elementScrolled, elementToBind, name_property, callback ) {
        elementScrolled.addEventListener( DOM_CONSTANT.SCROLL.EVENT, function () {
            var scrollPos         = elementScrolled.getData( name_property );
            var _do_callback      = scrollPos !== __previous_scrollLeft;
            __previous_scrollLeft = scrollPos;
            elementToBind.setData( name_property, scrollPos );
            if ( _do_callback && callback ) {
                callback();
            }
        } );
    };
    self.removeElement                     = function ( element ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        
        try {
            var _to_return = parent.removeChild( element );
            return _to_return;
        }
        catch ( e ) {
            return false;
        }
    };
    self.removeParentIfHasClassOrElement   = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        if ( !parent ) {
            return;
        }
        
        if ( parent.classList.contains( class_to_test ) ) {
            var _grand_parent = parent.parentNode;
            if ( !_grand_parent ) {
                return;
            }
            _grand_parent.removeChild( parent );
        }
        
        return parent.removeChild( element );
    };
    self.setDataSet                        = function ( element, attr, value ) {
        if ( !element ) {
            return;
        }
        element.dataset[ attr ] = value;
        element.classList.toggle( "IE-PATCH" );
    };
    self.getInnerText                      = function ( element ) {
        if ( !element ) {
            return;
        }
        return element.innerText.trim();
    };
    self.askAddClass                       = function ( element, to_add, time_out ) {
        element.classList.add( to_add );
        if ( time_out ) {
            setTimeout( function () {
                element.classList.remove( to_add );
            }, time_out );
        }
    };
    self.removeElementIfHasClass           = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        if ( !element.classList.contains( class_to_test ) ) {
            return false;
        }
        var parent = element.parentNode;
        return parent.removeChild( element );
    };
    self.addElementAtIndex                 = function ( element, parent, index ) {
        if ( !parent || !element ) {
            return;
        }
        if ( !index ) {
            index = 0;
        }
        if ( parent.childElementCount <= index ) {
            self.addElementTo( element, parent );
        } else {
            self.insertElementBefore(element, parent.children[index])
        }
    };
    self.addElementTo                      = function ( element, parent ) {
        if ( parent && element ) {
            parent.appendChild( element );
        }
    };
    self.addElementAfterTo                 = function ( element, target ) {
        var _next = target.nextSibling.nextSibling;
        if ( _next ) {
            target.parentNode.insertBefore( element, _next );
        }
        else {
            self.addElementTo( element, target.parentNode );
        }
    };
    self.switchElementParent                     = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        parent_1.removeChild( element_1 );
        parent_2.removeChild( element_2 );
        
        parent_1.appendChild( element_2 );
        parent_2.appendChild( element_1 );
    };
    self.switchElement                     = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        var _index_1 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_1.children, element_1 );
        var _index_2 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_2.children, element_2 );
        self.insertElementBefore( element_2, element_1 );
        self.addElementAtIndex(element_1, parent_2, _index_2);
    };
    self.insertElementBefore               = function ( element_existing, element_to_insert ) {
        if ( !element_existing || !element_to_insert ) {
            return;
        }
        var _parent = element_existing.parentNode;
        _parent.insertBefore( element_to_insert, element_existing );
    };
    self.getValueDataSet                   = function ( dom_element, key ) {
        return dom_element.dataset[ key ];
    };
    self.setStyle                          = function ( dom_element, key, value ) {
        if ( !dom_element || !key ) {
            return;
        }
        
        switch ( key ) {
            case DOM.CONST.STYLE.LEFT:
            case DOM.CONST.STYLE.TOP:
            case DOM.CONST.STYLE.HEIGHT:
            case DOM.CONST.STYLE.WIDTH:
            case DOM.CONST.STYLE.MAX_HEIGHT:
            case DOM.CONST.STYLE.MAX_WIDTH:
                if ( !isNaN( value ) ) {
                    value = value + 'px';
                }
                dom_element.style[ key ] = value;
                break;
            default:
                dom_element.style[ key ] = value;
        }
    };
    self.setStyles                         = function ( dom_element, styles ) {
        var keys = Object.keys( styles );
        for ( var i = 0, size = keys.length; i < size; i++ ) {
            self.setStyle( dom_element, keys[ i ], styles[ keys[ i ] ] );
        }
    };
    self.addClasses                        = function ( dom_element, class_to_add ) {
        if ( typeof class_to_add === 'string' ) {
            class_to_add = class_to_add.split( ' ' );
        }
        for ( var i = 0, _size_i = class_to_add.length; i < _size_i; i++ ) {
            dom_element.classList.add( class_to_add[ i ] );
        }
    };
    self.removeClasses                     = function ( dom_element, class_to_remove ) {
        if ( typeof class_to_remove === 'string' ) {
            class_to_remove = class_to_remove.split( ' ' );
        }
        for ( var i = 0, _size_i = class_to_remove.length; i < _size_i; i++ ) {
            dom_element.classList.remove( class_to_remove[ i ] );
        }
    };
    self.getBoundingClientRect             = function ( dom_element, key ) {
        if ( !dom_element ) {
            return;
        }
        var _rect = dom_element.getBoundingClientRect();
        if ( !key ) {
            return _rect;
        }
        if ( key === DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM ) {
            return parseInt( (_rect[ DOM.CONST.STYLE.TOP ] + _rect[ DOM.CONST.STYLE.BOTTOM ]) / 2 );
        }
        return parseInt( _rect[ key ] );
    };
    self.hasScrollHeight                   = function ( dom_element ) {
        var _height = self.getBoundingClientRect( dom_element, 'height' );
        return _height < dom_element.scrollHeight;
    };
    self.setHtmlOrHide                     = function ( dom_element, to_set ) {
        if ( !dom_element ) {
            return;
        }
        if ( to_set ) {
            dom_element.innerHTML = to_set;
            dom_element.classList.remove( 'shinken-hidden' );
        }
        else {
            dom_element.classList.add( 'shinken-hidden' );
        }
    };
    self.replaceChild                      = function ( element_to_replace, element_replace_with ) {
        var _parent_node = element_to_replace.parentNode;
        _parent_node.replaceChild( element_replace_with, element_to_replace );
    };
    self.empty                             = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        while ( dom_element.firstChild ) {
            dom_element.removeChild( dom_element.firstChild );
        }
    };
    self.removeAttribute                   = function ( dom_element, attribute_name ) {
        dom_element.removeAttribute( attribute_name );
    };
    self.getComputedStyle                  = function ( dom_element, key ) {
        if ( !dom_element ) {
            return {};
        }
        var _to_return = dom_element.currentStyle || getComputedStyle( dom_element );
        if ( key ) {
            _to_return = _to_return[ key ];
            if ( SHINKEN.TOOLS.STRING.endsWith( _to_return, 'px' ) ) {
                _to_return = parseInt( _to_return );
            }
        }
        return _to_return;
    };
    self.getHeight                         = function ( dom_element ) {
        if ( !dom_element ) {
            return 0;
        }
        return dom_element.offsetHeight;
    };
    self.isVisible                         = function ( elem, deepness ) {
        if ( !elem ) {
            return false;
        }
        if ( !deepness ) {
            deepness = 0;
        }
        if ( !(elem instanceof Element) ) {
            throw Error( 'DomUtil: elem is not an element.' );
        }
        var styles = self.getComputedStyle( elem );
        if ( styles.display === 'none' ) {
            return false;
        }
        if ( styles.visibility !== 'visible' && styles.visibility !== 'inherit' ) {
            return false;
        }
        if ( styles.opacity < 0.1 ) {
            return false;
        }
        if ( elem.parentElement && deepness > 0 ) {
            return self.isVisible( elem.parentElement, deepness-- );
        }
        return true;
    };
    self.isFullyVisibleInParent            = function ( dom_element, dom_parent ) {
        var _parent_rect  = self.getBoundingClientRect( dom_parent );
        var _element_rect = self.getBoundingClientRect( dom_element );
        if ( _element_rect[ DOM.CONST.STYLE.TOP ] < _parent_rect[ DOM.CONST.STYLE.TOP ] ) {
            return false;
        }
        if ( _element_rect[ DOM.CONST.STYLE.BOTTOM ] > _parent_rect[ DOM.CONST.STYLE.BOTTOM ] ) {
            return false;
        }
        return true;
    };
    self.setInputValue                     = function ( dom_element, to_set ) {
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            // Cette BGL permet de rendre les modifications de la valeur visibles dans le navigateur
            dom_element.setAttribute( 'value', to_set );
            dom_element.classList.toggle( "IE-PATCH" );
            //dom_element = self.replaceChild( dom_element, dom_element );
            dom_element.value = to_set;
            return;
        }
        dom_element.value = to_set;
    };
    self.hasFocus                          = function ( dom_element ) {
        return dom_element === document.activeElement;
    };
    self.generateDomElementFromString      = function ( string ) {
        var _to_return = self.createElement( "div", "", string );
        return _to_return.children;
    };
    self.hasHrefHost                       = function ( url ) {
        var _dom_url = self.createElement( "a", { href: url } );
        return !!_dom_url.host;
    };
    self.isMatchingMedianDomElementTopWith = function ( list, y ) {
        var _median_index = SHINKEN.TOOLS.ARRAY.getMedianIndex( list, true );
        if ( _median_index === SHINKEN.TOOLS.ARRAY.NOT_FOUND ) {
            return DOM.CONST.VALUE.NONE;
        }
        var _median  = list[ _median_index ];
        var _compare = self.compareCoordinates( _median, null, y );
        if ( _compare === 0 ) {
            return _median;
        }
        return _compare;
    };
    self.compareCoordinates                = function ( dom_element, x, y ) {
        var _rect = self.getBoundingClientRect( dom_element );
        if ( x ) {
            if ( _rect.left < x ) {
                return -1;
            }
            if ( _rect.left + _rect.width > x ) {
                return 1;
            }
        }
        if ( y ) {
            if ( _rect.top > y ) {
                return -1;
            }
            if ( _rect.top + _rect.height < y ) {
                return 1;
            }
        }
        return 0;
    };
    self.show                              = function ( dom_element ) {
        dom_element.classList.remove( "shinken-hidden" );
    };
    self.hide                              = function ( dom_element ) {
        dom_element.classList.add( "shinken-hidden" );
    };
    self.setEditable                       = function ( edit_content, dom_container, dom_to_edit ) {
        dom_to_edit.contentEditable = edit_content;
        if ( edit_content === true ) {
            self.focusAtTheEnd( dom_to_edit );
        }
        self.setDataSet( dom_container, 'statusEdit', edit_content ? "1" : "0" );
    };
    self.focusAtTheEnd                     = function ( dom_element ) {
        dom_element.focus();
        var range = document.createRange();
        range.selectNodeContents( dom_element );
        range.collapse( false );
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange( range );
    };
    
    return self;
})( DOM.Service || {} );

DOM.CONST = {
    STYLE                   : {
        LEFT      : 'left',
        RIGHT     : 'right',
        TOP       : 'top',
        BOTTOM    : 'bottom',
        HEIGHT    : 'height',
        MAX_HEIGHT: 'max-height',
        MAX_WIDTH : 'max-width',
        WIDTH     : 'width',
        Z_INDEX   : 'z-index',
        DISPLAY   : 'display'
    },
    ATTRIBUTE               : {
        SCROLL_DOWN: 'scrollDown',
        SCROLL_TOP : 'scrollTop',
        SCROLL_LEFT: 'scrollLeft'
    },
    VALUE                   : {
        NONE: 'none'
    },
    SPECIAL                 : {
        MEDIAN_TOP_BOTTOM: 'MEDIAN_TOP_BOTTOM'
    },
    WAITING_TIME_BEFORE_EXEC: {
        INPUT: 200
    }
};