%group_name = ""
%group_name_label = ""
%if 'is_mass_change' not in locals():
    %is_mass_change=False
%end
%if is_mass_change:
    %group_name = "mass-change"
    %group_name_label = "-mass-change"
    %list_tab_for_element = ['generic','monitoring','checks-defaults','user-rights','notifications','advanced']
    %is_disabled_name = False
%end

%sla_critical_threshold_label = app._('element.critical_threshold')
%sla_warning_threshold_label = app._('element.warning_threshold')

<form id="id-shinken-form-element" data-type={{item_type}} name='form-element' class='form-element no-margin form-inline gray-back '>
    <div class="shinken-form-container" >
        %if is_mass_change:
            <table class="shinken-mass-change-navigation">
                <tr class="shinken-window-group" data-name="{{group_name}}" onclick="MANAGER.EventManager.clickOnWindowNavigation(event,'{{group_name}}')">
                    %for current_tab in list_tab_for_element:
                        %include( "__print_element_td_tab", app=app, name=current_tab , label=app._('element.%s' % current_tab), group_name=group_name, has_properties=True )
                    %end
                </tr>
            </table>
        %else:
            %include( "__print_element_li_tab", app=app, list=list_tab_for_element, has_properties=True)
        %end
        <div class="shinken-tab-content tab-content tab-area">
            <div {{!helper.get_window_target_div('generic', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        %if not is_mass_change:
                            {{!helper.get_string_input(item, 'name', item_type,  is_disabled=is_disabled_name, required=True, mass_change=is_mass_change)}}
                        %end
                        {{!helper.get_string_input(item, 'bp_rule', item_type,  is_disabled=is_disabled_name, input_type="textarea", mass_change=is_mass_change)}}
                        {{!helper.get_multiselect_input(item, 'use', item_type, ITEM_TYPE.CLUSTERTPLS, is_disabled=is_disabled, mass_change=is_mass_change )}}
                        {{!helper.get_select_input(item, 'realm', item_type, None, special_look='realm', is_disabled=is_disabled, mass_change=is_mass_change)}}
                        {{!helper.get_slider_input(item, 'business_impact', item_type, is_disabled=is_disabled, default=2, data_min=0, data_max=5, data_type='range_business_impact', mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'notes_url', item_type, is_disabled=is_disabled, mass_change=is_mass_change) }}
                        {{!helper.get_multiple_line_object(item, 'notes_multi_url', item_type, type="notes_multi_url", is_disabled=is_disabled, separator_line_saved="~#~", separator_key_value_html="~=", separator_key_value_saved="~=", separator_line_html="~#~", mass_change=is_mass_change)}}
                        %if not is_mass_change:
                            {{!helper.get_bool_input(item, 'enabled',  item_type, is_disabled=is_disabled, default=True)}}
                        %end
                        {{!helper.get_string_input(item, 'pack', item_type, is_disabled=is_disabled, mass_change=is_mass_change) }}
                    </table>
                </div>
            </div>
            %if not is_mass_change:
                <div {{!helper.get_window_target_div('datas', group_name_label, selected_tab)}} >
                    %include( "__print_data_part",item=item, app=app)
                </div>
            %end
            %include(  "__print_user_rights" )
            <div {{!helper.get_window_target_div('monitoring', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        {{!helper.get_select_input(item, 'maintenance_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        {{!helper.get_select_input(item, 'poller_tag', item_type, None, special_look='poller', is_disabled=is_disabled, default="%s"%app._('element.untagged'), extra_label="%s" % app._('element.only_use_on_checks'), none_text="%s" % app._('element.untagged'), mass_change=is_mass_change)}}
                        {{!helper.get_property_group('type1', title=app._('element.title_collected_data'))}}
                        {{!helper.get_property_sub_group_start('type1', title=app._('element.sla'), mass_change=is_mass_change)}}
                        {{!helper.get_slider_input(item, 'sla_warning_threshold', item_type, is_disabled=is_disabled, data_unit='%', item_prop_label=sla_warning_threshold_label, data_type='range_with_input', data_digits=3, mass_change=is_mass_change)}}
                        {{!helper.get_slider_input(item, 'sla_critical_threshold', item_type, is_disabled=is_disabled, data_unit='%', item_prop_label=sla_critical_threshold_label, data_type='range_with_input', data_digits=3, mass_change=is_mass_change)}}
                        {{!helper.get_property_sub_group_end()}}
                    </table>
                 </div>
            </div>
            <div {{!helper.get_window_target_div('checks-defaults', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        {{!helper.get_select_input(item, 'check_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, default='%s' % app._('element.always'), none_text='%s' % app._('element.always'), mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'check_running_timeout', item_type, is_disabled=is_disabled, default=app._('element.same_as_shinken__cfg_check_running_timeout') % DEF_ITEMS[ITEM_TYPE.HOSTS]['class'].properties['check_running_timeout'].default, mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'warning_threshold_cpu_usage', item_type, is_disabled=is_disabled, default=app._('element.same_as_shinken__cfg_warning_threshold_cpu_usage') % DEF_ITEMS[ITEM_TYPE.HOSTS]['class'].properties['warning_threshold_cpu_usage'].default, mass_change=is_mass_change)}}
                    </table>
                 </div>
            </div>
            %if not is_mass_change:
                <div {{!helper.get_window_target_div('checks', group_name_label, selected_tab, extra_class='shinken-host-check-window-container', extra_attr='data-tab-selected="0"')}}>
                    <div>
                        <table class="shinken-prop-table">
                            %include( "checks_tab/__template_for_name_cell", app=app)
                            %include( "checks_tab/__template_for_override_exclude_cell", app=app)
                            %include( "checks_tab/__template_for_try_check_cell", app=app)
                        </table>
                    </div>
                    <div id="id-shinken-check{{group_name_label}}-list" class="shinken-scroll-auto shinken-scroll-without-header"></div>
                </div>
            %end
            <div {{!helper.get_window_target_div('notifications', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        {{!helper.get_bool_input(item, 'notifications_enabled', item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'notification_interval', item_type, is_disabled=is_disabled, default='1440 (%s)'%app._('element.day'), mass_change=is_mass_change)}}
                        {{!helper.get_select_input(item, 'notification_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, default='%s' % app._('element.always'), none_text='%s' % app._('element.always'), mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'notification_options', item_type, is_disabled=is_disabled, default='d,u,r,f', mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'first_notification_delay', item_type, is_disabled=is_disabled, default='0', mass_change=is_mass_change)}}
                        {{!helper.get_multiselect_input(item, 'escalations', item_type, ITEM_TYPE.ESCALATIONS, is_disabled=is_disabled, mass_change=is_mass_change)}}
                    </table>
                </div>
            </div>
            <div {{!helper.get_window_target_div('advanced', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type0', title=app._('element.title_setting_flapping'))}}
                            {{!helper.get_bool_input(item, 'flap_detection_enabled', item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change)}}
                            {{!helper.get_string_input(item, 'flap_detection_options', item_type, is_disabled=is_disabled, default='o,d,u', mass_change=is_mass_change)}}
                            {{!helper.get_slider_input(item, 'low_flap_threshold', item_type, is_disabled=is_disabled, data_unit='%', mass_change=is_mass_change)}}
                            {{!helper.get_slider_input(item, 'high_flap_threshold', item_type, is_disabled=is_disabled, data_unit='%', mass_change=is_mass_change)}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type1', title=app._('element.title_modulation'))}}
                            {{!helper.get_multiselect_input(item, 'business_impact_modulations', item_type, ITEM_TYPE.BUSINESSIMPACTMODULATIONS, is_disabled=is_disabled, mass_change=is_mass_change)}}
                            {{!helper.get_multiselect_input(item, 'macromodulations', item_type, ITEM_TYPE.MACROMODULATIONS, is_disabled=is_disabled, mass_change=is_mass_change)}}
                            {{!helper.get_multiselect_input(item, 'resultmodulations', item_type, ITEM_TYPE.RESULTMODULATIONS, item_prop_label=app._('type.resultmodulation'), is_disabled=is_disabled, mass_change=is_mass_change)}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type1', title=app._('element.title_event_handler'))}}
                            {{!helper.get_bool_input(item, 'event_handler_enabled', item_type, is_disabled=is_disabled, default=False, mass_change=is_mass_change)}}
                            {{!helper.get_select_input(item, 'reactionner_tag', item_type, None, special_look='reactionner', is_disabled=is_disabled, default="%s"%app._('element.untagged'), none_text="%s" % app._('element.untagged'), mass_change=is_mass_change)}}
                            {{!helper.get_command_input(item, 'event_handler', item_type, ITEM_TYPE.COMMANDS, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        </tbody>
                    </table>
                </div>
            </div>
            %if not is_mass_change:
                %if display_changes:
                    <div {{!helper.get_window_target_div('changes', group_name_label, selected_tab)}} >
                        %include("__print_pane_change", locals=locals())
                    </div>
                %end
            %end
        </div>
    </div>
</form>