%group_name = ""
%group_name_label = ""
%if 'is_mass_change' not in locals():
    %is_mass_change=False
%end
%if 'is_override' not in locals():
    %is_override=False
%end
%if is_mass_change:
    %group_name = "mass-change"
    %group_name_label = "-mass-change"
    %if is_override:
        %list_tab_for_element = ['generic','datas','monitoring','notifications','advanced']
    %else:
        %list_tab_for_element = ['generic','monitoring','notifications','advanced']
    %end
    %if item_type == ITEM_TYPE.SERVICESCLUSTERS:
        %same_as_object_trad=app._('element.same_as_cluster')
        %same_as_object_key='same_as_cluster'
    %elif item_type == ITEM_TYPE.SERVICESCLUSTERTPLS:
        %same_as_object_trad=app._('element.same_as_cluster')
        %same_as_object_key='same_as_cluster'
    %elif item_type == ITEM_TYPE.SERVICESHOSTTPLS:
        %same_as_object_trad=app._('element.same_as_host')
        %same_as_object_key='same_as_host'
    %elif item_type == ITEM_TYPE.SERVICESHOSTS:
        %same_as_object_trad=app._('element.same_as_host')
        %same_as_object_key='same_as_host'
    %else:
        %same_as_object_trad=app._('element.same_as_host_parent')
        %same_as_object_key='same_as_host'
    %end
%end

%sla_critical_threshold_label = app._('element.critical_threshold')
%sla_warning_threshold_label = app._('element.warning_threshold')

<form id="id-shinken-form-element" data-type={{item_type}} name='form-element' class='form-element no-margin form-inline gray-back '>
    <div class="shinken-form-container" >
        %if is_mass_change:
            <table class="shinken-mass-change-navigation">
                <tr class="shinken-window-group" data-name="{{group_name}}" onclick="MANAGER.EventManager.clickOnWindowNavigation(event,'{{group_name}}')">
                    %for current_tab in list_tab_for_element:
                        %include( "__print_element_td_tab", app=app, name=current_tab , label=app._('element.%s' % current_tab), group_name=group_name, has_properties=True )
                    %end
                </tr>
            </table>
        %else:
            %include( "__print_element_li_tab", app=app, list=list_tab_for_element, has_properties=True)
        %end
        <div class="shinken-tab-content tab-content tab-area">
            <div {{!helper.get_window_target_div('generic', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        %if not is_mass_change:
                            %if item_type == ITEM_TYPE.SERVICETPLS:
                                {{!helper.get_string_input(item, 'name', item_type, is_disabled=is_disabled_name, required=True, mass_change=is_mass_change)}}
                            %else:
                                {{!helper.get_string_input(item, 'service_description', item_type, is_disabled=is_disabled_name, required=True, mass_change=is_mass_change)}}
                            %end
                        %end
                        %if not is_override:
                            {{!helper.get_multiselect_input(item, 'use', item_type, ITEM_TYPE.SERVICETPLS, is_disabled=is_disabled , mass_change=is_mass_change)}}
                        %end
                        %if item_type in [ITEM_TYPE.SERVICESHOSTS, ITEM_TYPE.SERVICESHOSTTPLS] and not is_override:
                            {{!helper.get_string_input(item, 'hostgroup_name', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        %end
                        %if item_type == ITEM_TYPE.SERVICESCLUSTERS:
                            {{!helper.get_multiselect_input(item, 'host_name', item_type, ITEM_TYPE.CLUSTERS, is_disabled=is_disabled , mass_change=is_mass_change)}}
                        %elif item_type == ITEM_TYPE.SERVICESCLUSTERTPLS or item_type == ITEM_TYPE.SERVICESHOSTTPLS:
                            {{!helper.get_string_input_with_dropdown(item, 'host_name', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        %elif item_type == ITEM_TYPE.SERVICESHOSTS and not is_override:
                            {{!helper.get_multiselect_input(item, 'host_name', item_type, ITEM_TYPE.HOSTS, is_disabled=is_disabled , mass_change=is_mass_change)}}
                        %end
                        {{!helper.get_slider_input(item, 'business_impact', item_type, is_disabled=is_disabled, default=same_as_object_trad, data_min=0, data_max=5, data_type='range_business_impact', mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'notes_url', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        {{!helper.get_multiple_line_object(item, 'notes_multi_url', item_type, type="notes_multi_url", is_disabled=is_disabled, separator_line_saved="~#~", separator_key_value_html="~=", separator_key_value_saved="~=", separator_line_html="~#~", mass_change=is_mass_change)}}
                        %if not is_override and not is_mass_change:
                            {{!helper.get_bool_input(item, 'enabled', item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change)}}
                        %end
                        %if not is_override:
                            {{!helper.get_string_input(item, 'pack', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        %end
                        %if not is_override and not is_mass_change:
                            {{!helper.get_string_input(item, 'display_name', item_type, item_prop_label='display_name(hidden)', is_disabled=True, extra_class='shinken-hidden', mass_change=is_mass_change)}}
                        %end
                    </table>
                </div>
            </div>
            %if is_mass_change and is_override:
                %import re
                %import json
                %from ...dao.def_items import ITEM_TYPE, DEF_ITEMS, METADATA
                %from ...front_end.helper_object import COUNTER
                <div {{!helper.get_window_target_div('datas', group_name_label, selected_tab)}} >
                    %include( "massive_change/step_3/elements_data_mass_change_content", app=app, item_type=item_type_ref)
                </div>
            %elif not is_mass_change:
                <div {{!helper.get_window_target_div('datas', group_name_label, selected_tab)}} >
                    %include( "__print_data_part",item=item, app=app)
                </div>
            %end
            <div {{!helper.get_window_target_div('monitoring', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        {{!helper.get_select_input(item, 'maintenance_period', item_type, ITEM_TYPE.TIMEPERIODS, special_look='maintenance_period', is_disabled=is_disabled, default=same_as_object_trad, mass_change=is_mass_change)}}

                        {{!helper.get_property_group('type1', title=app._('element.title_checking_status_element'))}}
                        {{!helper.get_property_sub_group_start('type1', title=app._('element.title_active'), mass_change=is_mass_change)}}
                        {{!helper.get_bool_input(item, 'active_checks_enabled', item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change )}}
                        {{!helper.get_command_input(item, 'check_command', item_type, ITEM_TYPE.COMMANDS, is_disabled=is_disabled, required=True, mass_change=is_mass_change)}}
                        %if not is_override:
                            {{!helper.get_select_input(item, 'poller_tag', item_type, None, special_look='poller', is_disabled=is_disabled, default=same_as_object_trad, none_text=same_as_object_trad, mass_change=is_mass_change)}}
                        %end
                        {{!helper.get_select_input(item, 'check_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, default=same_as_object_trad, none_text='%s'% same_as_object_trad, mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'max_check_attempts', item_type, is_disabled=is_disabled, required=True, mass_change=is_mass_change )}}
                        {{!helper.get_string_input(item, 'check_interval', item_type, is_disabled=is_disabled, required=True, mass_change=is_mass_change )}}
                        {{!helper.get_string_input(item, 'retry_interval', item_type, is_disabled=is_disabled, required=True, mass_change=is_mass_change )}}
                        {{!helper.get_string_input(item, 'check_running_timeout', item_type, is_disabled=is_disabled, default=same_as_object_trad, mass_change=is_mass_change )}}
                        {{!helper.get_string_input(item, 'warning_threshold_cpu_usage', item_type, is_disabled=is_disabled, default=same_as_object_trad, mass_change=is_mass_change )}}
                        {{!helper.get_property_sub_group_end()}}
                        {{!helper.get_property_sub_group_start('type1', title=app._('element.title_passive'), mass_change=is_mass_change)}}
                        {{!helper.get_bool_input(item, 'passive_checks_enabled', item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change )}}
                        {{!helper.get_bool_input(item, 'check_freshness', item_type, is_disabled=is_disabled, default=False, mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'freshness_threshold', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        {{!helper.get_property_sub_group_end()}}

                        %if not is_override:
                        {{!helper.get_property_group('type1', title=app._('element.title_duplicate_foreach'))}}
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_string_input(item, 'duplicate_foreach', item_type, is_disabled=is_disabled, mass_change=is_mass_change )}}
                            {{!helper.get_string_input(item, 'default_value', item_type, is_disabled=is_disabled, mass_change=is_mass_change )}}
                        </tbody>
                        %end

                        {{!helper.get_property_group('type1', title=app._('element.title_collected_data'))}}
                        {{!helper.get_property_sub_group_start('type1', title=app._('element.metrology'), mass_change=is_mass_change)}}
                        {{!helper.get_bool_input(item, 'process_perf_data', item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change)}}
                        {{!helper.get_property_sub_group_end()}}
                        {{!helper.get_property_sub_group_start('type1', title=app._('element.sla'), mass_change=is_mass_change)}}
                        {{!helper.get_slider_input(item, 'sla_warning_threshold', item_type, is_disabled=is_disabled, data_unit='%', data_type='range_with_input', item_prop_label=sla_warning_threshold_label, data_digits=3, mass_change=is_mass_change)}}
                        {{!helper.get_slider_input(item, 'sla_critical_threshold', item_type, is_disabled=is_disabled, data_unit='%', data_type='range_with_input', item_prop_label=sla_critical_threshold_label, data_digits=3, mass_change=is_mass_change)}}
                        {{!helper.get_property_sub_group_end()}}
                    </table>
                 </div>
            </div>
            <div {{!helper.get_window_target_div('notifications', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        {{!helper.get_bool_input(item, 'notifications_enabled', item_type, is_disabled=is_disabled, default=same_as_object_trad, mass_change=is_mass_change)}}
                        {{!helper.get_multiselect_input(item, 'contacts', item_type, ITEM_TYPE.CONTACTS, is_disabled=is_disabled, default=same_as_object_key, mass_change=is_mass_change )}}
                        {{!helper.get_multiselect_input(item, 'contact_groups', item_type, ITEM_TYPE.CONTACTGROUPS, is_disabled=is_disabled, default=same_as_object_key, mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'notification_interval', item_type, is_disabled=is_disabled, default=same_as_object_trad, mass_change=is_mass_change)}}
                        {{!helper.get_select_input(item, 'notification_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, default=same_as_object_trad, none_text='%s' % same_as_object_trad, mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'notification_options', item_type, is_disabled=is_disabled, default=same_as_object_trad, mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'first_notification_delay', item_type, is_disabled=is_disabled, default=same_as_object_trad, mass_change=is_mass_change)}}
                        {{!helper.get_multiselect_input(item, 'escalations', item_type, ITEM_TYPE.ESCALATIONS, is_disabled=is_disabled, default=same_as_object_key, mass_change=is_mass_change)}}
                    </table>
                </div>
            </div>
            <div {{!helper.get_window_target_div('advanced', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        <tbody>
                            {{!helper.get_bool_input(item, 'is_volatile', item_type, is_disabled=is_disabled, default=False, mass_change=is_mass_change)}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type1', title=app._('element.title_setting_flapping'))}}
                            {{!helper.get_bool_input(item, 'flap_detection_enabled', item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change)}}
                            {{!helper.get_string_input(item, 'flap_detection_options', item_type, is_disabled=is_disabled, default='o,w,c,u', mass_change=is_mass_change)}}
                            {{!helper.get_slider_input(item, 'low_flap_threshold', item_type, is_disabled=is_disabled, data_unit='%', mass_change=is_mass_change)}}
                            {{!helper.get_slider_input(item, 'high_flap_threshold',item_type, is_disabled=is_disabled, data_unit='%', mass_change=is_mass_change)}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type1', title=app._('element.title_modulation'))}}
                            {{!helper.get_multiselect_input(item, 'business_impact_modulations', item_type, ITEM_TYPE.BUSINESSIMPACTMODULATIONS, is_disabled=is_disabled, default=same_as_object_key, mass_change=is_mass_change )}}
                            {{!helper.get_multiselect_input(item, 'macromodulations', item_type, ITEM_TYPE.MACROMODULATIONS, is_disabled=is_disabled, default='none', mass_change=is_mass_change )}}
                            {{!helper.get_multiselect_input(item, 'resultmodulations', item_type, ITEM_TYPE.RESULTMODULATIONS, is_disabled=is_disabled, default=same_as_object_key, mass_change=is_mass_change)}}
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            {{!helper.get_property_group('type1', title=app._('element.title_event_handler'))}}
                            {{!helper.get_bool_input(item, 'event_handler_enabled', item_type, is_disabled=is_disabled, default=False, mass_change=is_mass_change)}}
                            %if not is_override:
                                {{!helper.get_select_input(item, 'reactionner_tag', item_type, None, special_look='reactionner', is_disabled=is_disabled, default=same_as_object_trad, none_text=same_as_object_trad, mass_change=is_mass_change)}}
                            %end
                            %if not (is_mass_change and is_override) :
                                {{!helper.get_command_input(item, 'event_handler', item_type, ITEM_TYPE.COMMANDS, is_disabled=is_disabled, mass_change=is_mass_change)}}
                            %end
                        </tbody>
                        <tbody class="shinken-properties-tabulate">
                            %if not (is_mass_change and is_override):
                                {{!helper.get_property_group('type1', title=app._('element.title_other'))}}
                                {{!helper.get_string_input(item, 'definition_order', item_type, is_disabled=is_disabled, default='100', mass_change=is_mass_change)}}
                            %end
                        </tbody>

                    </table>
                </div>
            </div>
            %if not is_mass_change:
                %if display_changes:
                    <div {{!helper.get_window_target_div('changes', group_name_label, selected_tab)}} >
                        %include("__print_pane_change", locals=locals())
                    </div>
                %end
            %end
        </div>
    </div>
</form>